/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.refresh;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;

public class CloudConfigRefreshScheduler
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudConfigRefreshScheduler.class);
    private final ContextRefresher contextRefresher;

    public CloudConfigRefreshScheduler(ContextRefresher contextRefresher, long interval) {
        this.contextRefresher = contextRefresher;
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(CloudConfigRefreshScheduler.class.getSimpleName() + "-%d").build()).scheduleWithFixedDelay(this, interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            this.contextRefresher.refresh();
        }
        catch (Throwable t) {
            log.error("Error refreshing cloud config", t);
        }
    }
}

