/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.consul.api.v1.services;

import com.netflix.spinnaker.clouddriver.consul.api.v1.model.AgentDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.CheckDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.CheckResult;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.ServiceDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.ServiceResult;
import com.squareup.okhttp.Response;
import java.util.Map;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;

public interface AgentApi {
    @GET(value="/v1/agent/checks")
    public Map<String, CheckResult> checks();

    @GET(value="/v1/agent/services")
    public Map<String, ServiceResult> services();

    @GET(value="/v1/agent/self")
    public AgentDefinition self();

    @GET(value="/v1/agent/join/{address}")
    public Response join(@Path(value="address") String var1, @Query(value="wan") Integer var2);

    @PUT(value="/v1/agent/check/register")
    public Response registerCheck(@Body CheckDefinition var1, @Query(value="token") String var2);

    @PUT(value="/v1/agent/check/deregister/{checkId}")
    public Response deregisterCheck(@Path(value="checkId") String var1);

    @PUT(value="/v1/agent/service/register")
    public Response registerService(@Body ServiceDefinition var1, @Query(value="token") String var2);

    @PUT(value="/v1/agent/service/deregister/{serviceId}")
    public Response deregisterService(@Path(value="serviceId") String var1);

    @PUT(value="/v1/agent/service/maintenance/{serviceId}")
    public Response maintenance(@Path(value="serviceId") String var1, @Query(value="enable") boolean var2, @Query(value="reason") String var3);

    @PUT(value="/v1/agent/maintenance")
    public Response maintenance(@Query(value="enable") boolean var1, @Query(value="reason") String var2, @Body String var3);
}

