/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.consul.api.v1.services;

import com.netflix.spinnaker.clouddriver.consul.api.v1.model.AgentDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.CheckDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.CheckResult;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.ServiceDefinition;
import com.netflix.spinnaker.clouddriver.consul.api.v1.model.ServiceResult;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface AgentApi {
    @GET(value="/v1/agent/checks")
    public Call<Map<String, CheckResult>> checks();

    @GET(value="/v1/agent/services")
    public Call<Map<String, ServiceResult>> services();

    @GET(value="/v1/agent/self")
    public Call<AgentDefinition> self();

    @GET(value="/v1/agent/join/{address}")
    public Call<ResponseBody> join(@Path(value="address") String var1, @Query(value="wan") Integer var2);

    @PUT(value="/v1/agent/check/register")
    public Call<ResponseBody> registerCheck(@Body CheckDefinition var1, @Query(value="token") String var2);

    @PUT(value="/v1/agent/check/deregister/{checkId}")
    public Call<ResponseBody> deregisterCheck(@Path(value="checkId") String var1);

    @PUT(value="/v1/agent/service/register")
    public Call<ResponseBody> registerService(@Body ServiceDefinition var1, @Query(value="token") String var2);

    @PUT(value="/v1/agent/service/deregister/{serviceId}")
    public Call<ResponseBody> deregisterService(@Path(value="serviceId") String var1);

    @PUT(value="/v1/agent/service/maintenance/{serviceId}")
    public Call<ResponseBody> maintenance(@Path(value="serviceId") String var1, @Query(value="enable") boolean var2, @Query(value="reason") String var3);

    @PUT(value="/v1/agent/maintenance")
    public Call<ResponseBody> maintenance(@Query(value="enable") boolean var1, @Query(value="reason") String var2, @Body String var3);
}

