/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerToken;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryAuthenticationException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Path;
import retrofit.http.Query;

public class DockerBearerTokenService
implements GroovyObject {
    private Map<String, TokenService> realmToService;
    private Map<String, DockerBearerToken> cachedTokens;
    private String username;
    private String password;
    private String passwordCommand;
    private File passwordFile;
    private String authWarning;
    private static final String userAgent;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerBearerTokenService() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(HashMap.class);
        this.realmToService = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object object2 = callSiteArray[1].callConstructor(HashMap.class);
        this.cachedTokens = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
    }

    public DockerBearerTokenService(String username, String password, String passwordCommand) {
        String string;
        String string2;
        String string3;
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        this.username = string3 = username;
        this.password = string2 = password;
        this.passwordCommand = string = passwordCommand;
    }

    public DockerBearerTokenService(String username, File passwordFile) {
        File file;
        String string;
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        this();
        this.username = string = username;
        this.passwordFile = file = passwordFile;
    }

    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        if (!(DefaultTypeTransformation.booleanUnbox((Object)this.username) || DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile))) {
            return ShortTypeHandling.castToString(null);
        }
        Object resolvedPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.password)) {
            String string = this.password;
            resolvedPassword = string;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
            Object object;
            Object pb = callSiteArray[2].callConstructor(ProcessBuilder.class, (Object)"bash", (Object)"-c", (Object)this.passwordCommand);
            Object process = callSiteArray[3].call(pb);
            Object errCode = callSiteArray[4].call(process);
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)log)) ? callSiteArray[6].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[7].call(pb)}, new String[]{"Full command is: ", ""})) : null;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)errCode, (Object)0)) {
                Object err = callSiteArray[8].call(IOUtils.class, callSiteArray[9].call(process), callSiteArray[10].callGetProperty(StandardCharsets.class));
                Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call((Object)log)) ? callSiteArray[12].call((Object)log, (Object)new GStringImpl(new Object[]{err}, new String[]{"Password command returned a non 0 return code, stderr/stdout was: '", "'"})) : null;
            }
            resolvedPassword = object = callSiteArray[13].call(callSiteArray[14].call(IOUtils.class, callSiteArray[15].call(process), callSiteArray[16].callGetProperty(StandardCharsets.class)));
            Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)log)) ? callSiteArray[18].call((Object)log, (Object)new GStringImpl(new Object[]{resolvedPassword}, new String[]{"resolvedPassword is ", ""})) : null;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile)) {
            Object object;
            resolvedPassword = object = callSiteArray[19].call(callSiteArray[20].callConstructor(BufferedReader.class, callSiteArray[21].callConstructor(FileReader.class, (Object)this.passwordFile)));
        } else {
            String string = "";
            resolvedPassword = string;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[22].callSafe(resolvedPassword), (Object)0)) {
            String message = "Your registry password has %s whitespace, if this is unintentional authentication will fail.";
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(callSiteArray[24].call(resolvedPassword, (Object)0)))) {
                Object object = callSiteArray[25].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"leading"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call(callSiteArray[27].call(resolvedPassword, callSiteArray[28].call(callSiteArray[29].call(resolvedPassword), (Object)1))))) {
                Object object = callSiteArray[30].callCurrent((GroovyObject)this, (Object)message, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"trailing"}));
                this.authWarning = ShortTypeHandling.castToString((Object)object);
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[31].callConstructor(String.class, callSiteArray[32].call(callSiteArray[33].callGetProperty(Base64.class), callSiteArray[34].callGroovyObjectGetProperty((Object)new GStringImpl(new Object[]{this.username, resolvedPassword}, new String[]{"", ":", ""})))));
    }

    public String getBasicAuthHeader() {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object basicAuth = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            basicAuth = object = callSiteArray[35].callCurrent((GroovyObject)this);
        } else {
            String string = this.getBasicAuth();
            basicAuth = string;
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)basicAuth) ? new GStringImpl(new Object[]{basicAuth}, new String[]{"Basic ", ""}) : null));
    }

    public AuthenticateDetails parseBearerAuthenticateHeader(String header) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        String realmKey = "realm";
        String serviceKey = "service";
        String scopeKey = "scope";
        AuthenticateDetails result = (AuthenticateDetails)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callConstructor(AuthenticateDetails.class, (Object)this), AuthenticateDetails.class);
        while (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[37].call((Object)header), (Object)0)) {
            String key = null;
            String value = null;
            Object keyEnd = callSiteArray[38].call((Object)header, (Object)"=");
            if (ScriptBytecodeAdapter.compareEqual((Object)keyEnd, (Object)-1)) {
                throw (Throwable)callSiteArray[39].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{header}, new String[]{"Www-Authenticate header terminated with junk: '", "'."}));
            }
            Object object = callSiteArray[40].call((Object)header, (Object)0, keyEnd);
            key = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[41].call((Object)header, callSiteArray[42].call(keyEnd, (Object)1));
            header = ShortTypeHandling.castToString((Object)object2);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[43].call((Object)header), (Object)0)) {
                throw (Throwable)callSiteArray[44].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{key}, new String[]{"Www-Authenticate header unmatched parameter key: '", "'."}));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[45].call((Object)header, (Object)0), (Object)"\"")) {
                Object object3 = callSiteArray[46].call((Object)header, (Object)1);
                header = ShortTypeHandling.castToString((Object)object3);
                Object valueEnd = callSiteArray[47].call((Object)header, (Object)"\"");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    throw (Throwable)callSiteArray[48].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header has unterminated \" (quotation mark).");
                }
                Object object4 = callSiteArray[49].call((Object)header, (Object)0, valueEnd);
                value = ShortTypeHandling.castToString((Object)object4);
                Object object5 = callSiteArray[50].call((Object)header, callSiteArray[51].call(valueEnd, (Object)1));
                header = ShortTypeHandling.castToString((Object)object5);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[52].call((Object)header), (Object)0)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[53].call((Object)header, (Object)0), (Object)",")) {
                        throw (Throwable)callSiteArray[54].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header params must be separated by , (comma).");
                    }
                    Object object6 = callSiteArray[55].call((Object)header, (Object)1);
                    header = ShortTypeHandling.castToString((Object)object6);
                }
            } else {
                Object valueEnd = callSiteArray[56].call((Object)header, (Object)",");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    String string;
                    String string2;
                    value = string2 = header;
                    header = string = "";
                } else {
                    Object object7 = callSiteArray[57].call((Object)header, (Object)0, valueEnd);
                    value = ShortTypeHandling.castToString((Object)object7);
                    Object object8 = callSiteArray[58].call((Object)header, callSiteArray[59].call(valueEnd, (Object)1));
                    header = ShortTypeHandling.castToString((Object)object8);
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)key, (Object)realmKey))) {
                Object url = callSiteArray[61].callConstructor(URL.class, (Object)value);
                Object object9 = callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].callGetProperty(url), (Object)"://"), callSiteArray[65].callGetProperty(url));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, DockerBearerTokenService.class, (GroovyObject)result, (String)"realm");
                Object object10 = callSiteArray[66].callGetProperty(url);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[67].call(callSiteArray[68].callGroovyObjectGetProperty((Object)result)), (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[69].call(callSiteArray[70].callGroovyObjectGetProperty((Object)result), (Object)0), (Object)"/"))) continue;
                Object object11 = callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)result), (Object)1);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object11, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                continue;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call((Object)key, (Object)serviceKey))) {
                String string = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
                continue;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].call((Object)key, (Object)scopeKey))) continue;
            String string = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DockerBearerTokenService.class, (GroovyObject)result, (String)"scope");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].callGroovyObjectGetProperty((Object)result))) {
            throw (Throwable)callSiteArray[76].callConstructor(DockerRegistryAuthenticationException.class, (Object)"Www-Authenticate header must provide 'realm' parameter.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].callGroovyObjectGetProperty((Object)result))) {
            Object var28_28 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var28_28, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
        }
        return result;
    }

    private Object getTokenService(String realm) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object tokenService = callSiteArray[78].call(this.realmToService, (Object)realm);
        if (ScriptBytecodeAdapter.compareEqual((Object)tokenService, null)) {
            Object object;
            Object builder = callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].callConstructor(RestAdapter.Builder.class), (Object)realm), callSiteArray[83].callGetProperty(RestAdapter.LogLevel.class)));
            tokenService = object = callSiteArray[84].call(builder, TokenService.class);
            Object object2 = tokenService;
            callSiteArray[85].call(this.realmToService, (Object)realm, object2);
        }
        return tokenService;
    }

    public DockerBearerToken getToken(String repository) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call(this.cachedTokens, (Object)repository), DockerBearerToken.class);
    }

    public DockerBearerToken getToken(String repository, String authenticateHeader) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object authenticateDetails = null;
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object;
                authenticateDetails = object = callSiteArray[87].callCurrent((GroovyObject)this, (Object)authenticateHeader);
            } else {
                AuthenticateDetails authenticateDetails2 = this.parseBearerAuthenticateHeader(authenticateHeader);
                authenticateDetails = authenticateDetails2;
            }
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[88].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[89].callGetProperty((Object)e)}, new String[]{"Failed to parse www-authenticate header: ", ""}));
        }
        Object tokenService = callSiteArray[90].callCurrent((GroovyObject)this, callSiteArray[91].callGetProperty(authenticateDetails));
        Object token = null;
        try {
            Object object;
            Object object2;
            token = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callGroovyObjectGetProperty((Object)this)) ? (object2 = callSiteArray[93].call(tokenService, ArrayUtil.createArray((Object)callSiteArray[94].callGetProperty(authenticateDetails), (Object)callSiteArray[95].callGetProperty(authenticateDetails), (Object)callSiteArray[96].callGetProperty(authenticateDetails), (Object)callSiteArray[97].callGroovyObjectGetProperty((Object)this), (Object)userAgent))) : (object = callSiteArray[98].call(tokenService, callSiteArray[99].callGetProperty(authenticateDetails), callSiteArray[100].callGetProperty(authenticateDetails), callSiteArray[101].callGetProperty(authenticateDetails), (Object)userAgent));
        }
        catch (Exception e) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.authWarning)) {
                throw (Throwable)callSiteArray[102].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{this.authWarning, callSiteArray[103].call((Object)e)}, new String[]{"Authentication failed (", "): ", ""}), (Object)e);
            }
            throw (Throwable)callSiteArray[104].callConstructor(DockerRegistryAuthenticationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[105].call((Object)e)}, new String[]{"Authentication failed: ", ""}), (Object)e);
        }
        Object object = token;
        callSiteArray[106].call(this.cachedTokens, (Object)repository, object);
        return (DockerBearerToken)ScriptBytecodeAdapter.castToType((Object)token, DockerBearerToken.class);
    }

    public void clearToken(String repository) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        callSiteArray[107].call(this.cachedTokens, (Object)repository);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerBearerTokenService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DockerBearerTokenService.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerBearerTokenService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DockerBearerTokenService.$getCallSiteArray()[108].call(DockerUserAgent.class);
        userAgent = ShortTypeHandling.castToString((Object)object);
        Object object2 = DockerBearerTokenService.$getCallSiteArray()[109].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    @Generated
    public Map<String, TokenService> getRealmToService() {
        return this.realmToService;
    }

    @Generated
    public void setRealmToService(Map<String, TokenService> map) {
        this.realmToService = map;
    }

    @Generated
    public Map<String, DockerBearerToken> getCachedTokens() {
        return this.cachedTokens;
    }

    @Generated
    public void setCachedTokens(Map<String, DockerBearerToken> map) {
        this.cachedTokens = map;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String string) {
        this.username = string;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public String getPasswordCommand() {
        return this.passwordCommand;
    }

    @Generated
    public void setPasswordCommand(String string) {
        this.passwordCommand = string;
    }

    @Generated
    public File getPasswordFile() {
        return this.passwordFile;
    }

    @Generated
    public void setPasswordFile(File file) {
        this.passwordFile = file;
    }

    @Generated
    public String getAuthWarning() {
        return this.authWarning;
    }

    @Generated
    public void setAuthWarning(String string) {
        this.authWarning = string;
    }

    @Generated
    public static String getUserAgent() {
        return userAgent;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "start";
        stringArray[4] = "waitFor";
        stringArray[5] = "isDebugEnabled";
        stringArray[6] = "debug";
        stringArray[7] = "command";
        stringArray[8] = "toString";
        stringArray[9] = "getErrorStream";
        stringArray[10] = "UTF_8";
        stringArray[11] = "isErrorEnabled";
        stringArray[12] = "error";
        stringArray[13] = "trim";
        stringArray[14] = "toString";
        stringArray[15] = "getInputStream";
        stringArray[16] = "UTF_8";
        stringArray[17] = "isDebugEnabled";
        stringArray[18] = "debug";
        stringArray[19] = "getText";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "length";
        stringArray[23] = "isWhitespace";
        stringArray[24] = "charAt";
        stringArray[25] = "sprintf";
        stringArray[26] = "isWhitespace";
        stringArray[27] = "charAt";
        stringArray[28] = "minus";
        stringArray[29] = "length";
        stringArray[30] = "sprintf";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "encode";
        stringArray[33] = "encoder";
        stringArray[34] = "bytes";
        stringArray[35] = "getBasicAuth";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "length";
        stringArray[38] = "indexOf";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "substring";
        stringArray[41] = "substring";
        stringArray[42] = "plus";
        stringArray[43] = "length";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "getAt";
        stringArray[46] = "substring";
        stringArray[47] = "indexOf";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "substring";
        stringArray[50] = "substring";
        stringArray[51] = "plus";
        stringArray[52] = "length";
        stringArray[53] = "getAt";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "substring";
        stringArray[56] = "indexOf";
        stringArray[57] = "substring";
        stringArray[58] = "substring";
        stringArray[59] = "plus";
        stringArray[60] = "equalsIgnoreCase";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "protocol";
        stringArray[65] = "authority";
        stringArray[66] = "path";
        stringArray[67] = "length";
        stringArray[68] = "path";
        stringArray[69] = "getAt";
        stringArray[70] = "path";
        stringArray[71] = "substring";
        stringArray[72] = "path";
        stringArray[73] = "equalsIgnoreCase";
        stringArray[74] = "equalsIgnoreCase";
        stringArray[75] = "realm";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "service";
        stringArray[78] = "get";
        stringArray[79] = "build";
        stringArray[80] = "setLogLevel";
        stringArray[81] = "setEndpoint";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "NONE";
        stringArray[84] = "create";
        stringArray[85] = "putAt";
        stringArray[86] = "getAt";
        stringArray[87] = "parseBearerAuthenticateHeader";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "message";
        stringArray[90] = "getTokenService";
        stringArray[91] = "realm";
        stringArray[92] = "basicAuthHeader";
        stringArray[93] = "getToken";
        stringArray[94] = "path";
        stringArray[95] = "service";
        stringArray[96] = "scope";
        stringArray[97] = "basicAuthHeader";
        stringArray[98] = "getToken";
        stringArray[99] = "path";
        stringArray[100] = "service";
        stringArray[101] = "scope";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "getMessage";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "getMessage";
        stringArray[106] = "putAt";
        stringArray[107] = "remove";
        stringArray[108] = "getUserAgent";
        stringArray[109] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[110];
        DockerBearerTokenService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerBearerTokenService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerBearerTokenService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    interface TokenService {
        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="Authorization") String var4, @Header(value="User-Agent") String var5);
    }

    class AuthenticateDetails
    implements GroovyObject {
        private String realm;
        private String path;
        private String service;
        private String scope;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        final /* synthetic */ DockerBearerTokenService this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AuthenticateDetails(DockerBearerTokenService $p$) {
            MetaClass metaClass;
            DockerBearerTokenService dockerBearerTokenService;
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0 = dockerBearerTokenService = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AuthenticateDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AuthenticateDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AuthenticateDetails.class, DockerBearerTokenService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getRealm() {
            return this.realm;
        }

        @Generated
        public void setRealm(String string) {
            this.realm = string;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public void setService(String string) {
            this.service = string;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public void setScope(String string) {
            this.scope = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AuthenticateDetails.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AuthenticateDetails.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

