/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.security.TrustAllX509TrustManager;
import com.squareup.okhttp.OkHttpClient;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import retrofit.client.OkClient;

public class DefaultDockerOkClientProvider
implements DockerOkClientProvider {
    @Override
    public OkClient provide(String address, long timeoutMs, boolean insecure) {
        OkHttpClient client = new OkHttpClient();
        client.setReadTimeout(timeoutMs, TimeUnit.MILLISECONDS);
        if (insecure) {
            SSLContext sslContext;
            try {
                sslContext = SSLContext.getInstance("SSL");
                TrustManager[] trustManagers = new TrustManager[]{new TrustAllX509TrustManager()};
                sslContext.init(null, trustManagers, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("Failed configuring insecure SslSocketFactory", e);
            }
            client.setSslSocketFactory(sslContext.getSocketFactory());
        }
        return new OkClient(client);
    }
}

