/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.health;

import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.core.AccountHealthIndicator;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.Optional;

public class DockerRegistryHealthIndicator
extends AccountHealthIndicator<DockerRegistryNamedAccountCredentials> {
    private static final String ID = "docker";
    private final CredentialsRepository<DockerRegistryNamedAccountCredentials> credentialsRepository;

    public DockerRegistryHealthIndicator(Registry registry, CredentialsRepository<DockerRegistryNamedAccountCredentials> credentialsRepository) {
        super(ID, registry);
        this.credentialsRepository = credentialsRepository;
    }

    protected ImmutableList<DockerRegistryNamedAccountCredentials> getAccounts() {
        return ImmutableList.copyOf((Collection)this.credentialsRepository.getAll());
    }

    protected Optional<String> accountHealth(DockerRegistryNamedAccountCredentials accountCredentials) {
        try {
            accountCredentials.getCredentials().getClient().checkV2Availability();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e.getMessage());
        }
    }
}

