/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.security;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.clouddriver.docker.registry.DockerRegistryCloudProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.provider.DockerRegistryProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.provider.agent.DockerRegistryImageCachingAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DockerRegistryCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<DockerRegistryNamedAccountCredentials> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerRegistryCredentialsLifecycleHandler.class);
    private final DockerRegistryProvider provider;
    private final DockerRegistryCloudProvider cloudProvider;

    public void credentialsAdded(DockerRegistryNamedAccountCredentials credentials) {
        log.info("Adding agents for docker account {}", (Object)credentials.getName());
        this.provider.addAgents(this.agentsForCredentials(credentials));
    }

    public void credentialsUpdated(DockerRegistryNamedAccountCredentials credentials) {
        log.info("Updating agents for docker account {}", (Object)credentials.getName());
        this.provider.removeAgentsForAccounts(List.of(credentials.getName()));
        this.provider.addAgents(this.agentsForCredentials(credentials));
    }

    public void credentialsDeleted(DockerRegistryNamedAccountCredentials credentials) {
        log.info("Removing agents for docker account {}", (Object)credentials.getName());
        this.provider.removeAgentsForAccounts(List.of(credentials.getName()));
    }

    private List<Agent> agentsForCredentials(DockerRegistryNamedAccountCredentials credentials) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (int i = 0; i < credentials.getCacheThreads(); ++i) {
            agents.add((Agent)new DockerRegistryImageCachingAgent(this.cloudProvider, credentials.getName(), credentials.getCredentials(), i, credentials.getCacheThreads(), credentials.getCacheIntervalSeconds(), credentials.getRegistry()));
        }
        return agents;
    }

    @Generated
    public DockerRegistryCredentialsLifecycleHandler(DockerRegistryProvider provider, DockerRegistryCloudProvider cloudProvider) {
        this.provider = provider;
        this.cloudProvider = cloudProvider;
    }
}

