/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryClient;
import com.netflix.spinnaker.clouddriver.docker.registry.exception.DockerRegistryConfigException;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryCredentials;
import com.netflix.spinnaker.clouddriver.docker.registry.security.KeyBasedSorter;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistryNamedAccountCredentials
extends AbstractAccountCredentials<DockerRegistryCredentials>
implements GroovyObject {
    private static final String CLOUD_PROVIDER = "dockerRegistry";
    private final String accountName;
    private final String environment;
    private final String accountType;
    private final String address;
    private final String registry;
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private final String password;
    private final String passwordCommand;
    private final File passwordFile;
    private final String email;
    private final boolean trackDigests;
    private final boolean inspectDigests;
    private final boolean sortTagsByDate;
    private final int cacheThreads;
    private final long cacheIntervalSeconds;
    private final long clientTimeoutMillis;
    private final int paginateSize;
    private final boolean insecureRegistry;
    @JsonIgnore
    private final DockerRegistryCredentials credentials;
    private final Permissions permissions;
    private final List<String> skip;
    private final String catalogFile;
    private final String repositoriesRegex;
    private final DockerOkClientProvider dockerOkClientProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, String passwordCommand, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean inspectDigests, boolean sortTagsByDate, String catalogFile, String repositoriesRegex, boolean insecureRegistry, DockerOkClientProvider dockerOkClientProvider) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        this(accountName, environment, accountType, address, username, password, passwordCommand, passwordFile, dockerconfigFile, email, repositories, skip, cacheThreads, cacheIntervalSeconds, clientTimeoutMillis, paginateSize, trackDigests, inspectDigests, sortTagsByDate, catalogFile, repositoriesRegex, insecureRegistry, null, null, dockerOkClientProvider);
    }

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, String passwordCommand, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean inspectDigests, boolean sortTagsByDate, String catalogFile, String repositoriesRegex, boolean insecureRegistry, List<String> requiredGroupMembership, Permissions permissions, DockerOkClientProvider dockerOkClientProvider) {
        List list;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        DockerOkClientProvider dockerOkClientProvider2;
        int n;
        int n2;
        File file;
        String string6;
        String string7;
        String string8;
        String string9;
        MetaClass metaClass;
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)accountName)) {
            throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"Docker Registry account must be provided with a name.");
        }
        if (DefaultTypeTransformation.booleanUnbox(repositories) && DefaultTypeTransformation.booleanUnbox((Object)catalogFile)) {
            throw (Throwable)callSiteArray[1].callConstructor(IllegalArgumentException.class, (Object)"repositories and catalogFile may not be specified together.");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)repositoriesRegex) && (DefaultTypeTransformation.booleanUnbox(repositories) || DefaultTypeTransformation.booleanUnbox((Object)catalogFile))) {
            throw (Throwable)callSiteArray[2].callConstructor(IllegalArgumentException.class, (Object)"repositoriesRegex may not be specified at the same time than repositories or catalogFile.");
        }
        this.accountName = string9 = accountName;
        this.environment = string8 = environment;
        this.accountType = string7 = accountType;
        this.passwordCommand = string6 = passwordCommand;
        this.passwordFile = file = passwordFile;
        int n3 = cacheThreads;
        this.cacheThreads = n2 = n3 != 0 ? n3 : 1;
        long l = cacheIntervalSeconds;
        long l2 = l != 0L ? l : (long)30;
        this.cacheIntervalSeconds = l2;
        int n4 = paginateSize;
        this.paginateSize = n = n4 != 0 ? n4 : 100;
        long l3 = clientTimeoutMillis;
        Long l4 = l3 != 0L ? Long.valueOf(l3) : callSiteArray[3].call(callSiteArray[4].callGetProperty(TimeUnit.class), (Object)1);
        this.clientTimeoutMillis = DefaultTypeTransformation.longUnbox((Object)l4);
        this.dockerOkClientProvider = dockerOkClientProvider2 = dockerOkClientProvider;
        if (!DefaultTypeTransformation.booleanUnbox((Object)address)) {
            throw (Throwable)callSiteArray[5].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{accountName}, new String[]{"Docker Registry account ", " must provide an endpoint address."}));
        }
        int addressLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[6].call((Object)address));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call((Object)address, callSiteArray[8].call((Object)addressLen, (Object)1)), (Object)"/")) {
                address = ShortTypeHandling.castToString((Object)callSiteArray[9].call((Object)address, (Object)0, callSiteArray[10].call((Object)addressLen, (Object)1)));
                addressLen = DefaultTypeTransformation.intUnbox((Object)callSiteArray[11].call((Object)addressLen, (Object)1));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].call((Object)address, (Object)(addressLen - 1)), (Object)"/")) {
            address = ShortTypeHandling.castToString((Object)callSiteArray[13].call((Object)address, (Object)0, (Object)(addressLen - 1)));
            addressLen = addressLen - 1;
        }
        if (!BytecodeInterface8.isOrigInt() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)address, (Object)"/v2"))) {
                address = ShortTypeHandling.castToString((Object)callSiteArray[15].call((Object)address, (Object)0, callSiteArray[16].call((Object)addressLen, (Object)3)));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)address, (Object)"/v2"))) {
            address = ShortTypeHandling.castToString((Object)callSiteArray[18].call((Object)address, (Object)0, (Object)(addressLen - 3)));
        }
        this.address = string5 = address;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)address, (Object)"https://"))) {
            Object object = callSiteArray[20].call((Object)address, callSiteArray[21].call((Object)"https://"));
            this.registry = ShortTypeHandling.castToString((Object)object);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)address, (Object)"http://"))) {
            Object object = callSiteArray[23].call((Object)address, callSiteArray[24].call((Object)"http://"));
            this.registry = ShortTypeHandling.castToString((Object)object);
        } else {
            String string10;
            this.registry = string10 = address;
        }
        this.username = string4 = username;
        this.password = string3 = password;
        this.email = string2 = email;
        this.repositoriesRegex = string = repositoriesRegex;
        this.trackDigests = bl4 = trackDigests;
        this.inspectDigests = bl3 = inspectDigests;
        this.sortTagsByDate = bl2 = sortTagsByDate;
        this.insecureRegistry = bl = insecureRegistry;
        List list2 = skip;
        this.skip = list = DefaultTypeTransformation.booleanUnbox(list2) ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Permissions permissions2 = permissions;
        Permissions permissions3 = DefaultTypeTransformation.booleanUnbox((Object)permissions2) ? permissions2 : callSiteArray[25].callStatic(DockerRegistryNamedAccountCredentials.class, requiredGroupMembership);
        this.permissions = (Permissions)ScriptBytecodeAdapter.castToType((Object)permissions3, Permissions.class);
        Object object = callSiteArray[26].callCurrent((GroovyObject)this, repositories, (Object)catalogFile, (Object)dockerconfigFile);
        this.credentials = (DockerRegistryCredentials)ScriptBytecodeAdapter.castToType((Object)object, DockerRegistryCredentials.class);
    }

    @JsonIgnore
    public List<String> getRepositories() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this.credentials), List.class);
    }

    public String getName() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.accountName;
    }

    public String getRegistry() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.registry;
    }

    @JsonIgnore
    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object object = callSiteArray[28].callGetPropertySafe(callSiteArray[29].callGetPropertySafe((Object)this.credentials));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ""));
    }

    @JsonIgnore
    public List<String> getTags(String repository) {
        Reference repository2 = new Reference((Object)repository);
        List<String> tags = this.credentials.getClient().getTags((String)repository2.get()).getTags();
        if (this.sortTagsByDate) {
            public final class _getTags_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference repository;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getTags_closure1(Object _outerInstance, Object _thisObject, Reference repository) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.repository = reference = repository;
                }

                public Instant doCall(String t) {
                    return ((DockerRegistryNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DockerRegistryNamedAccountCredentials.class))).getCreationDate(ShortTypeHandling.castToString((Object)this.repository.get()), t);
                }

                @Generated
                public Instant call(String t) {
                    return this.doCall(t);
                }

                @Generated
                public String getRepository() {
                    return ShortTypeHandling.castToString((Object)this.repository.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTags_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            tags = KeyBasedSorter.sort(tags, (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _getTags_closure1((Object)this, (Object)this, repository2)), Function.class), Comparator.reverseOrder());
        }
        return tags;
    }

    private Instant getCreationDate(String repository, String tag) {
        Instant instant = this.credentials.getClient().getCreationDate(repository, tag);
        try {
            return instant;
        }
        catch (Exception e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn("Unable to fetch tag creation date, reason: {} (tag: {}, repository: {})", new Object[]{e.getMessage(), tag, repository});
                v0 = null;
            } else {
                v0 = null;
            }
            Instant instant2 = Instant.EPOCH;
            return instant2;
        }
    }

    public String getV2Endpoint() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.address}, new String[]{"", "/v2"}));
    }

    public boolean getTrackDigests() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.trackDigests;
    }

    public boolean getInspectDigests() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.inspectDigests;
    }

    public int getCacheThreads() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.cacheThreads;
    }

    public long getCacheIntervalSeconds() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.cacheIntervalSeconds;
    }

    public DockerRegistryCredentials getCredentials() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return this.credentials;
    }

    public String getCloudProvider() {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return CLOUD_PROVIDER;
    }

    private DockerRegistryCredentials buildCredentials(List<String> repositories, String catalogFile, File dockerconfigFile) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        DockerRegistryClient client = (DockerRegistryClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].callConstructor(DockerRegistryClient.Builder.class), (Object)this.address), (Object)this.email), (Object)this.username), (Object)this.password), (Object)this.passwordCommand), (Object)this.passwordFile), (Object)this.clientTimeoutMillis), (Object)this.paginateSize), (Object)catalogFile), (Object)dockerconfigFile), (Object)this.repositoriesRegex), (Object)this.insecureRegistry), (Object)this.dockerOkClientProvider)), DockerRegistryClient.class);
        DockerRegistryCredentials dockerRegistryCredentials = (DockerRegistryCredentials)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callConstructor(DockerRegistryCredentials.class, ArrayUtil.createArray((Object)client, repositories, (Object)this.trackDigests, (Object)this.inspectDigests, this.skip, (Object)this.sortTagsByDate)), DockerRegistryCredentials.class);
        try {
            return dockerRegistryCredentials;
        }
        catch (SpinnakerHttpException e) {
            block6: {
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[46].call((Object)e), (Object)404)) break block6;
                throw (Throwable)callSiteArray[47].callConstructor(DockerRegistryConfigException.class, (Object)new GStringImpl(new Object[]{callSiteArray[48].callGroovyObjectGetProperty((Object)this), this.address}, new String[]{"No repositories specified for ", ", and the provided endpoint ", " does not support /_catalog."}));
            }
            throw (Throwable)e;
        }
    }

    private static Permissions buildPermissionsFromRequiredGroupMembership(List<String> requiredGroupMembership) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object object = callSiteArray[49].callGetPropertySafe(requiredGroupMembership);
        if (DefaultTypeTransformation.booleanUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Boolean.valueOf(true)))) {
            return (Permissions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callGetProperty(Permissions.class), Permissions.class);
        }
        Reference builder = new Reference(callSiteArray[51].callConstructor(Permissions.Builder.class));
        public final class _buildPermissionsFromRequiredGroupMembership_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildPermissionsFromRequiredGroupMembership_closure2(Object _outerInstance, Object _thisObject, Reference builder) {
                Reference reference;
                CallSite[] callSiteArray = _buildPermissionsFromRequiredGroupMembership_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.builder = reference = builder;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildPermissionsFromRequiredGroupMembership_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(this.builder.get(), callSiteArray[2].callGetProperty(Authorization.class), it), callSiteArray[3].callGetProperty(Authorization.class), it);
            }

            @Generated
            public Object getBuilder() {
                CallSite[] callSiteArray = _buildPermissionsFromRequiredGroupMembership_closure2.$getCallSiteArray();
                return this.builder.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildPermissionsFromRequiredGroupMembership_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildPermissionsFromRequiredGroupMembership_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "add";
                stringArray[1] = "add";
                stringArray[2] = "READ";
                stringArray[3] = "WRITE";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _buildPermissionsFromRequiredGroupMembership_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildPermissionsFromRequiredGroupMembership_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildPermissionsFromRequiredGroupMembership_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[52].call(requiredGroupMembership, (Object)new _buildPermissionsFromRequiredGroupMembership_closure2(DockerRegistryNamedAccountCredentials.class, DockerRegistryNamedAccountCredentials.class, builder));
        return (Permissions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(builder.get()), Permissions.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DockerRegistryNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[54].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[55].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[56].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = DockerRegistryNamedAccountCredentials.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = DockerRegistryNamedAccountCredentials.$getCallSiteArray()[57].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public final String getEnvironment() {
        return this.environment;
    }

    @Generated
    public final String getAccountType() {
        return this.accountType;
    }

    @Generated
    public final String getAddress() {
        return this.address;
    }

    @Generated
    public final String getUsername() {
        return this.username;
    }

    @Generated
    public final String getPassword() {
        return this.password;
    }

    @Generated
    public final String getPasswordCommand() {
        return this.passwordCommand;
    }

    @Generated
    public final File getPasswordFile() {
        return this.passwordFile;
    }

    @Generated
    public final String getEmail() {
        return this.email;
    }

    @Generated
    public final boolean getSortTagsByDate() {
        return this.sortTagsByDate;
    }

    @Generated
    public final boolean isSortTagsByDate() {
        return this.sortTagsByDate;
    }

    @Generated
    public final long getClientTimeoutMillis() {
        return this.clientTimeoutMillis;
    }

    @Generated
    public final int getPaginateSize() {
        return this.paginateSize;
    }

    @Generated
    public final boolean getInsecureRegistry() {
        return this.insecureRegistry;
    }

    @Generated
    public final boolean isInsecureRegistry() {
        return this.insecureRegistry;
    }

    @Generated
    public final Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public final List<String> getSkip() {
        return this.skip;
    }

    @Generated
    public final String getCatalogFile() {
        return this.catalogFile;
    }

    @Generated
    public final String getRepositoriesRegex() {
        return this.repositoriesRegex;
    }

    @Generated
    public final DockerOkClientProvider getDockerOkClientProvider() {
        return this.dockerOkClientProvider;
    }

    public /* synthetic */ Permissions super$2$getPermissions() {
        return super.getPermissions();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "toMillis";
        stringArray[4] = "MINUTES";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "length";
        stringArray[7] = "getAt";
        stringArray[8] = "minus";
        stringArray[9] = "substring";
        stringArray[10] = "minus";
        stringArray[11] = "minus";
        stringArray[12] = "getAt";
        stringArray[13] = "substring";
        stringArray[14] = "endsWith";
        stringArray[15] = "substring";
        stringArray[16] = "minus";
        stringArray[17] = "endsWith";
        stringArray[18] = "substring";
        stringArray[19] = "startsWith";
        stringArray[20] = "substring";
        stringArray[21] = "length";
        stringArray[22] = "startsWith";
        stringArray[23] = "substring";
        stringArray[24] = "length";
        stringArray[25] = "buildPermissionsFromRequiredGroupMembership";
        stringArray[26] = "buildCredentials";
        stringArray[27] = "repositories";
        stringArray[28] = "basicAuth";
        stringArray[29] = "client";
        stringArray[30] = "build";
        stringArray[31] = "okClientProvider";
        stringArray[32] = "insecureRegistry";
        stringArray[33] = "repositoriesRegex";
        stringArray[34] = "dockerconfigFile";
        stringArray[35] = "catalogFile";
        stringArray[36] = "paginateSize";
        stringArray[37] = "clientTimeoutMillis";
        stringArray[38] = "passwordFile";
        stringArray[39] = "passwordCommand";
        stringArray[40] = "password";
        stringArray[41] = "username";
        stringArray[42] = "email";
        stringArray[43] = "address";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "getResponseCode";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "name";
        stringArray[49] = "empty";
        stringArray[50] = "EMPTY";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "forEach";
        stringArray[53] = "build";
        stringArray[54] = "length";
        stringArray[55] = "getAt";
        stringArray[56] = "length";
        stringArray[57] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[58];
        DockerRegistryNamedAccountCredentials.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerRegistryNamedAccountCredentials.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerRegistryNamedAccountCredentials.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Builder
    implements GroovyObject {
        private String accountName;
        private String environment;
        private String accountType;
        private String address;
        private String username;
        private String password;
        private String passwordCommand;
        private File passwordFile;
        private File dockerconfigFile;
        private String email;
        private int cacheThreads;
        private long cacheIntervalSeconds;
        private long clientTimeoutMillis;
        private int paginateSize;
        private boolean trackDigests;
        private boolean inspectDigests;
        private boolean sortTagsByDate;
        private boolean insecureRegistry;
        private List<String> repositories;
        private List<String> skip;
        private String catalogFile;
        private String repositoriesRegex;
        private Permissions permissions;
        private DockerOkClientProvider dockerOkClientProvider;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Builder() {
            MetaClass metaClass;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder accountName(String accountName) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.accountName = string = accountName;
            return this;
        }

        public Builder environment(String environment) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.environment = string = environment;
            return this;
        }

        public Builder accountType(String accountType) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.accountType = string = accountType;
            return this;
        }

        public Builder address(String address) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.address = string = address;
            return this;
        }

        public Builder username(String username) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.username = string = username;
            return this;
        }

        public Builder password(String address) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.password = string = address;
            return this;
        }

        public Builder passwordCommand(String passwordCommand) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.passwordCommand = string = passwordCommand;
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)passwordFile)) {
                Object object = callSiteArray[0].callConstructor(File.class, (Object)passwordFile);
                this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            } else {
                Object var4_4 = null;
                this.passwordFile = (File)ScriptBytecodeAdapter.castToType(var4_4, File.class);
            }
            return this;
        }

        public Builder dockerconfigFile(String dockerconfigFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)dockerconfigFile)) {
                Object object = callSiteArray[1].callConstructor(File.class, (Object)dockerconfigFile);
                this.dockerconfigFile = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            } else {
                Object var4_4 = null;
                this.dockerconfigFile = (File)ScriptBytecodeAdapter.castToType(var4_4, File.class);
            }
            return this;
        }

        public Builder email(String email) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.email = string = email;
            return this;
        }

        public Builder cacheThreads(int cacheThreads) {
            int n;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.cacheThreads = n = cacheThreads;
            return this;
        }

        public Builder cacheIntervalSeconds(long cacheIntervalSeconds) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            long l = cacheIntervalSeconds;
            this.cacheIntervalSeconds = l;
            return this;
        }

        public Builder clientTimeoutMillis(long clientTimeoutMillis) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            long l = clientTimeoutMillis;
            this.clientTimeoutMillis = l;
            return this;
        }

        public Builder paginateSize(int paginateSize) {
            int n;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.paginateSize = n = paginateSize;
            return this;
        }

        public Builder trackDigests(boolean trackDigests) {
            boolean bl;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.trackDigests = bl = trackDigests;
            return this;
        }

        public Builder inspectDigests(boolean inspectDigests) {
            boolean bl;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.inspectDigests = bl = inspectDigests;
            return this;
        }

        public Builder sortTagsByDate(boolean sortTagsByDate) {
            boolean bl;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.sortTagsByDate = bl = sortTagsByDate;
            return this;
        }

        public Builder insecureRegistry(boolean insecureRegistry) {
            boolean bl;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.insecureRegistry = bl = insecureRegistry;
            return this;
        }

        public Builder repositories(List<String> repositories) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = repositories;
            this.repositories = list;
            return this;
        }

        public Builder skip(List<String> skip) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = skip;
            this.skip = list;
            return this;
        }

        public Builder catalogFile(String catalogFile) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.catalogFile = string = catalogFile;
            return this;
        }

        public Builder repositoriesRegex(String repositoriesRegex) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.repositoriesRegex = string = repositoriesRegex;
            return this;
        }

        public Builder permissions(Permissions permissions) {
            Permissions permissions2;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.permissions = permissions2 = permissions;
            return this;
        }

        public Builder dockerOkClientProvider(DockerOkClientProvider dockerOkClientProvider) {
            DockerOkClientProvider dockerOkClientProvider2;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.dockerOkClientProvider = dockerOkClientProvider2 = dockerOkClientProvider;
            return this;
        }

        public DockerRegistryNamedAccountCredentials build() {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return (DockerRegistryNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(DockerRegistryNamedAccountCredentials.class, ArrayUtil.createArray((Object)this.accountName, (Object)this.environment, (Object)this.accountType, (Object)this.address, (Object)this.username, (Object)this.password, (Object)this.passwordCommand, (Object)this.passwordFile, (Object)this.dockerconfigFile, (Object)this.email, this.repositories, this.skip, (Object)this.cacheThreads, (Object)this.cacheIntervalSeconds, (Object)this.clientTimeoutMillis, (Object)this.paginateSize, (Object)this.trackDigests, (Object)this.inspectDigests, (Object)this.sortTagsByDate, (Object)this.catalogFile, (Object)this.repositoriesRegex, (Object)this.insecureRegistry, null, (Object)this.permissions, (Object)this.dockerOkClientProvider)), DockerRegistryNamedAccountCredentials.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[7].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getAccountName() {
            return this.accountName;
        }

        @Generated
        public void setAccountName(String string) {
            this.accountName = string;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public void setEnvironment(String string) {
            this.environment = string;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public void setAccountType(String string) {
            this.accountType = string;
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public void setAddress(String string) {
            this.address = string;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public void setUsername(String string) {
            this.username = string;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String string) {
            this.password = string;
        }

        @Generated
        public String getPasswordCommand() {
            return this.passwordCommand;
        }

        @Generated
        public void setPasswordCommand(String string) {
            this.passwordCommand = string;
        }

        @Generated
        public File getPasswordFile() {
            return this.passwordFile;
        }

        @Generated
        public void setPasswordFile(File file) {
            this.passwordFile = file;
        }

        @Generated
        public File getDockerconfigFile() {
            return this.dockerconfigFile;
        }

        @Generated
        public void setDockerconfigFile(File file) {
            this.dockerconfigFile = file;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setEmail(String string) {
            this.email = string;
        }

        @Generated
        public int getCacheThreads() {
            return this.cacheThreads;
        }

        @Generated
        public void setCacheThreads(int n) {
            this.cacheThreads = n;
        }

        @Generated
        public long getCacheIntervalSeconds() {
            return this.cacheIntervalSeconds;
        }

        @Generated
        public void setCacheIntervalSeconds(long l) {
            this.cacheIntervalSeconds = l;
        }

        @Generated
        public long getClientTimeoutMillis() {
            return this.clientTimeoutMillis;
        }

        @Generated
        public void setClientTimeoutMillis(long l) {
            this.clientTimeoutMillis = l;
        }

        @Generated
        public int getPaginateSize() {
            return this.paginateSize;
        }

        @Generated
        public void setPaginateSize(int n) {
            this.paginateSize = n;
        }

        @Generated
        public boolean getTrackDigests() {
            return this.trackDigests;
        }

        @Generated
        public boolean isTrackDigests() {
            return this.trackDigests;
        }

        @Generated
        public void setTrackDigests(boolean bl) {
            this.trackDigests = bl;
        }

        @Generated
        public boolean getInspectDigests() {
            return this.inspectDigests;
        }

        @Generated
        public boolean isInspectDigests() {
            return this.inspectDigests;
        }

        @Generated
        public void setInspectDigests(boolean bl) {
            this.inspectDigests = bl;
        }

        @Generated
        public boolean getSortTagsByDate() {
            return this.sortTagsByDate;
        }

        @Generated
        public boolean isSortTagsByDate() {
            return this.sortTagsByDate;
        }

        @Generated
        public void setSortTagsByDate(boolean bl) {
            this.sortTagsByDate = bl;
        }

        @Generated
        public boolean getInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public boolean isInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public void setInsecureRegistry(boolean bl) {
            this.insecureRegistry = bl;
        }

        @Generated
        public List<String> getRepositories() {
            return this.repositories;
        }

        @Generated
        public void setRepositories(List<String> list) {
            this.repositories = list;
        }

        @Generated
        public List<String> getSkip() {
            return this.skip;
        }

        @Generated
        public void setSkip(List<String> list) {
            this.skip = list;
        }

        @Generated
        public String getCatalogFile() {
            return this.catalogFile;
        }

        @Generated
        public void setCatalogFile(String string) {
            this.catalogFile = string;
        }

        @Generated
        public String getRepositoriesRegex() {
            return this.repositoriesRegex;
        }

        @Generated
        public void setRepositoriesRegex(String string) {
            this.repositoriesRegex = string;
        }

        @Generated
        public Permissions getPermissions() {
            return this.permissions;
        }

        @Generated
        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }

        @Generated
        public DockerOkClientProvider getDockerOkClientProvider() {
            return this.dockerOkClientProvider;
        }

        @Generated
        public void setDockerOkClientProvider(DockerOkClientProvider dockerOkClientProvider) {
            this.dockerOkClientProvider = dockerOkClientProvider;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "length";
            stringArray[4] = "getAt";
            stringArray[5] = "length";
            stringArray[6] = "length";
            stringArray[7] = "getAt";
            stringArray[8] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[9];
            Builder.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Builder.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Builder.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

