/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerToken;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryAuthenticationException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerRetrofitErrorHandler;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.converter.JacksonConverter;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Path;
import retrofit.http.Query;

public class DockerBearerTokenService
implements GroovyObject {
    private Map<String, TokenService> realmToService;
    private Map<String, DockerBearerToken> cachedTokens;
    private String username;
    private String password;
    private String passwordCommand;
    private File passwordFile;
    private String authWarning;
    private static final String userAgent;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DockerBearerTokenService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, HashMap.class);
        this.realmToService = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, HashMap.class);
        this.cachedTokens = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    public DockerBearerTokenService(String username, String password, String passwordCommand) {
        this();
        String string;
        String string2;
        String string3;
        this.username = string3 = username;
        this.password = string2 = password;
        this.passwordCommand = string = passwordCommand;
    }

    public DockerBearerTokenService(String username, File passwordFile) {
        this();
        File file;
        String string;
        this.username = string = username;
        this.passwordFile = file = passwordFile;
    }

    public String getBasicAuth() {
        if (!(DefaultTypeTransformation.booleanUnbox((Object)this.username) || DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object resolvedPassword = null;
        if (IndyInterface.bootstrap("cast", "()", 0, this.password) != false) {
            resolvedPassword = this.password;
        } else if (IndyInterface.bootstrap("cast", "()", 0, this.passwordCommand) != false) {
            CallSite pb = IndyInterface.bootstrap("init", "<init>", 0, ProcessBuilder.class, "bash", "-c", this.passwordCommand);
            CallSite process = IndyInterface.bootstrap("invoke", "start", 0, pb);
            CallSite errCode = IndyInterface.bootstrap("invoke", "waitFor", 0, process);
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "command", 0, pb)}, new String[]{"Full command is: ", ""})) : null;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)errCode, (Object)0)) {
                CallSite err = IndyInterface.bootstrap("invoke", "toString", 0, IOUtils.class, IndyInterface.bootstrap("invoke", "getErrorStream", 0, process), IndyInterface.bootstrap("getProperty", "UTF_8", 0, StandardCharsets.class));
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{err}, new String[]{"Password command returned a non 0 return code, stderr/stdout was: '", "'"})) : null;
            }
            resolvedPassword = IndyInterface.bootstrap("invoke", "trim", 0, IndyInterface.bootstrap("invoke", "toString", 0, IOUtils.class, IndyInterface.bootstrap("invoke", "getInputStream", 0, process), IndyInterface.bootstrap("getProperty", "UTF_8", 0, StandardCharsets.class)));
            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{resolvedPassword}, new String[]{"resolvedPassword is ", ""})) : null;
        } else {
            resolvedPassword = IndyInterface.bootstrap("cast", "()", 0, this.passwordFile) != false ? IndyInterface.bootstrap("invoke", "getText", 0, IndyInterface.bootstrap("init", "<init>", 0, BufferedReader.class, IndyInterface.bootstrap("init", "<init>", 0, FileReader.class, this.passwordFile))) : "";
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 1, resolvedPassword), (Object)0)) {
            String message = "Your registry password has %s whitespace, if this is unintentional authentication will fail.";
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWhitespace", 0, IndyInterface.bootstrap("invoke", "charAt", 0, resolvedPassword, false))) != false) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "sprintf", 2, this, message, ScriptBytecodeAdapter.createList((Object[])new Object[]{"leading"}));
                this.authWarning = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWhitespace", 0, IndyInterface.bootstrap("invoke", "charAt", 0, resolvedPassword, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, resolvedPassword), true)))) != false) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "sprintf", 2, this, message, ScriptBytecodeAdapter.createList((Object[])new Object[]{"trailing"}));
                this.authWarning = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, String.class, IndyInterface.bootstrap("invoke", "encode", 0, IndyInterface.bootstrap("getProperty", "encoder", 0, Base64.class), IndyInterface.bootstrap("getProperty", "bytes", 4, new GStringImpl(new Object[]{this.username, resolvedPassword}, new String[]{"", ":", ""})))));
    }

    public String getBasicAuthHeader() {
        CallSite basicAuth = IndyInterface.bootstrap("invoke", "getBasicAuth", 2, this);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, basicAuth) != false ? new GStringImpl(new Object[]{basicAuth}, new String[]{"Basic ", ""}) : null);
    }

    public AuthenticateDetails parseBearerAuthenticateHeader(String header) {
        String realmKey = "realm";
        String serviceKey = "service";
        String scopeKey = "scope";
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AuthenticateDetails.class, this));
        while (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, header), (Object)0)) {
            CallSite key = null;
            Object value = null;
            CallSite keyEnd = IndyInterface.bootstrap("invoke", "indexOf", 0, header, "=");
            if (ScriptBytecodeAdapter.compareEqual((Object)keyEnd, (Object)-1)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, new GStringImpl(new Object[]{header}, new String[]{"Www-Authenticate header terminated with junk: '", "'."})));
            }
            key = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, false, keyEnd));
            header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, IndyInterface.bootstrap("invoke", "plus", 0, keyEnd, true)));
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, header), (Object)0)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, new GStringImpl(new Object[]{key}, new String[]{"Www-Authenticate header unmatched parameter key: '", "'."})));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, header, false), (Object)"\"")) {
                header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, true));
                CallSite valueEnd = IndyInterface.bootstrap("invoke", "indexOf", 0, header, "\"");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, "Www-Authenticate header has unterminated \" (quotation mark)."));
                }
                value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, false, valueEnd));
                header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, IndyInterface.bootstrap("invoke", "plus", 0, valueEnd, true)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, header), (Object)0)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, header, false), (Object)",")) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, "Www-Authenticate header params must be separated by , (comma)."));
                    }
                    header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, true));
                }
            } else {
                CallSite valueEnd = IndyInterface.bootstrap("invoke", "indexOf", 0, header, ",");
                if (ScriptBytecodeAdapter.compareEqual((Object)valueEnd, (Object)-1)) {
                    value = header;
                    header = "";
                } else {
                    value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, false, valueEnd));
                    header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, header, IndyInterface.bootstrap("invoke", "plus", 0, valueEnd, true)));
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, key, realmKey)) != false) {
                CallSite url = IndyInterface.bootstrap("init", "<init>", 0, URL.class, value);
                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "protocol", 0, url), "://"), IndyInterface.bootstrap("getProperty", "authority", 0, url));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, DockerBearerTokenService.class, (GroovyObject)result, (String)"realm");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "path", 0, url);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, IndyInterface.bootstrap("getProperty", "path", 4, result)), (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "path", 4, result), false), (Object)"/"))) continue;
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("getProperty", "path", 4, result), true);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, DockerBearerTokenService.class, (GroovyObject)result, (String)"path");
                continue;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, key, serviceKey)) != false) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
                continue;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, key, scopeKey)) == false) continue;
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)result, (String)"scope");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "realm", 4, result)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, "Www-Authenticate header must provide 'realm' parameter."));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "service", 4, result)) == false) {
            Object var17_17 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var17_17, DockerBearerTokenService.class, (GroovyObject)result, (String)"service");
        }
        return result;
    }

    private Object getTokenService(String realm) {
        CallSite tokenService = IndyInterface.bootstrap("invoke", "get", 0, this.realmToService, realm);
        if (ScriptBytecodeAdapter.compareEqual((Object)tokenService, null)) {
            CallSite builder = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "setErrorHandler", 0, IndyInterface.bootstrap("invoke", "setLogLevel", 0, IndyInterface.bootstrap("invoke", "setConverter", 0, IndyInterface.bootstrap("invoke", "setEndpoint", 0, IndyInterface.bootstrap("init", "<init>", 0, RestAdapter.Builder.class), realm), IndyInterface.bootstrap("init", "<init>", 0, JacksonConverter.class)), IndyInterface.bootstrap("getProperty", "NONE", 0, RestAdapter.LogLevel.class)), IndyInterface.bootstrap("invoke", "getInstance", 0, SpinnakerRetrofitErrorHandler.class)));
            tokenService = IndyInterface.bootstrap("invoke", "create", 0, builder, TokenService.class);
            CallSite callSite = tokenService;
            IndyInterface.bootstrap("invoke", "putAt", 0, this.realmToService, realm, callSite);
        }
        return tokenService;
    }

    public DockerBearerToken getToken(String repository) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.cachedTokens, repository));
    }

    public DockerBearerToken getToken(String repository, String authenticateHeader) {
        CallSite authenticateDetails = null;
        try {
            authenticateDetails = IndyInterface.bootstrap("invoke", "parseBearerAuthenticateHeader", 2, this, authenticateHeader);
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Failed to parse www-authenticate header: ", ""})));
        }
        CallSite tokenService = IndyInterface.bootstrap("invoke", "getTokenService", 2, this, IndyInterface.bootstrap("getProperty", "realm", 0, authenticateDetails));
        CallSite token = null;
        try {
            token = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "basicAuthHeader", 12, this)) != false ? IndyInterface.bootstrap("invoke", "getToken", 0, tokenService, IndyInterface.bootstrap("getProperty", "path", 0, authenticateDetails), IndyInterface.bootstrap("getProperty", "service", 0, authenticateDetails), IndyInterface.bootstrap("getProperty", "scope", 0, authenticateDetails), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 12, this), userAgent) : IndyInterface.bootstrap("invoke", "getToken", 0, tokenService, IndyInterface.bootstrap("getProperty", "path", 0, authenticateDetails), IndyInterface.bootstrap("getProperty", "service", 0, authenticateDetails), IndyInterface.bootstrap("getProperty", "scope", 0, authenticateDetails), userAgent);
        }
        catch (Exception e) {
            if (IndyInterface.bootstrap("cast", "()", 0, this.authWarning) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, new GStringImpl(new Object[]{this.authWarning, IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Authentication failed (", "): ", ""}), e));
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryAuthenticationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Authentication failed: ", ""}), e));
        }
        CallSite callSite = token;
        IndyInterface.bootstrap("invoke", "putAt", 0, this.cachedTokens, repository, callSite);
        return IndyInterface.bootstrap("cast", "()", 0, token);
    }

    public void clearToken(String repository) {
        IndyInterface.bootstrap("invoke", "remove", 0, this.cachedTokens, repository);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerBearerTokenService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerBearerTokenService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerBearerTokenService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerBearerTokenService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getUserAgent", 0, DockerUserAgent.class);
        userAgent = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    @Generated
    public Map<String, TokenService> getRealmToService() {
        return this.realmToService;
    }

    @Generated
    public void setRealmToService(Map<String, TokenService> map) {
        this.realmToService = map;
    }

    @Generated
    public Map<String, DockerBearerToken> getCachedTokens() {
        return this.cachedTokens;
    }

    @Generated
    public void setCachedTokens(Map<String, DockerBearerToken> map) {
        this.cachedTokens = map;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String string) {
        this.username = string;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public String getPasswordCommand() {
        return this.passwordCommand;
    }

    @Generated
    public void setPasswordCommand(String string) {
        this.passwordCommand = string;
    }

    @Generated
    public File getPasswordFile() {
        return this.passwordFile;
    }

    @Generated
    public void setPasswordFile(File file) {
        this.passwordFile = file;
    }

    @Generated
    public String getAuthWarning() {
        return this.authWarning;
    }

    @Generated
    public void setAuthWarning(String string) {
        this.authWarning = string;
    }

    @Generated
    public static String getUserAgent() {
        return userAgent;
    }

    private interface TokenService {
        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public DockerBearerToken getToken(@Path(encode=false, value="path") String var1, @Query(value="service") String var2, @Query(value="scope") String var3, @Header(value="Authorization") String var4, @Header(value="User-Agent") String var5);
    }

    private class AuthenticateDetails
    implements GroovyObject {
        private String realm;
        private String path;
        private String service;
        private String scope;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        final /* synthetic */ DockerBearerTokenService this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AuthenticateDetails(DockerBearerTokenService $p$) {
            MetaClass metaClass;
            DockerBearerTokenService dockerBearerTokenService;
            this.this$0 = dockerBearerTokenService = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AuthenticateDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            try {
                return this.this$0.this$dist$invoke$1(name, args);
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AuthenticateDetails.class, DockerBearerTokenService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AuthenticateDetails.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                this.this$0.this$dist$set$1(name, value);
                return;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerBearerTokenService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AuthenticateDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            try {
                return this.this$0.this$dist$get$1(name);
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AuthenticateDetails.class, DockerBearerTokenService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AuthenticateDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getRealm() {
            return this.realm;
        }

        @Generated
        public void setRealm(String string) {
            this.realm = string;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public void setService(String string) {
            this.service = string;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public void setScope(String string) {
            this.scope = string;
        }
    }
}

