/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.provider.agent;

import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.docker.registry.DockerRegistryCloudProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.cache.DefaultCacheDataBuilder;
import com.netflix.spinnaker.clouddriver.docker.registry.cache.Keys;
import com.netflix.spinnaker.clouddriver.docker.registry.provider.DockerRegistryProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.provider.DockerRegistryProviderUtils;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryCredentials;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistryImageCachingAgent
implements CachingAgent,
AccountAware,
AgentIntervalAware,
GroovyObject {
    private static final Set<AgentDataType> types;
    private DockerRegistryCredentials credentials;
    private DockerRegistryCloudProvider dockerRegistryCloudProvider;
    private String accountName;
    private final int index;
    private final int threadCount;
    private final long interval;
    private String registry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DockerRegistryImageCachingAgent(DockerRegistryCloudProvider dockerRegistryCloudProvider, String accountName, DockerRegistryCredentials credentials, int index, int threadCount, Long intervalSecs, String registry) {
        String string;
        int n;
        int n2;
        DockerRegistryCredentials dockerRegistryCredentials;
        String string2;
        DockerRegistryCloudProvider dockerRegistryCloudProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.dockerRegistryCloudProvider = dockerRegistryCloudProvider2 = dockerRegistryCloudProvider;
        this.accountName = string2 = accountName;
        this.credentials = dockerRegistryCredentials = credentials;
        this.index = n2 = index;
        this.threadCount = n = threadCount;
        CallSite callSite = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "SECONDS", 0, TimeUnit.class), intervalSecs);
        this.interval = DefaultTypeTransformation.longUnbox((Object)callSite);
        this.registry = string = registry;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        CallSite tags = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadTags", 2, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, tags));
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.accountName, IndyInterface.bootstrap("getProperty", "simpleName", 0, DockerRegistryImageCachingAgent.class), IndyInterface.bootstrap("invoke", "plus", 0, this.index, true), this.threadCount}, new String[]{"", "/", "[", "/", "]"}));
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, DockerRegistryProvider.class));
    }

    private Map<String, Set<String>> loadTags() {
        public final class _loadTags_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadTags_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "threadCount", 12, this)) == 1 || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "abs", 0, IndyInterface.bootstrap("invoke", "mod", 0, IndyInterface.bootstrap("invoke", "hashCode", 0, it), IndyInterface.bootstrap("getProperty", "threadCount", 12, this))), (Object)IndyInterface.bootstrap("getProperty", "index", 12, this));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadTags_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _loadTags_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadTags_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object repository) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("getProperty", "skip", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), repository)) != false) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                }
                CallSite tags = null;
                try {
                    tags = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTags", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), repository));
                }
                catch (Exception e) {
                    if (e instanceof SpinnakerHttpException && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResponseCode", 0, IndyInterface.bootstrap("cast", "()", 0, e)), (Object)404)) {
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{repository, IndyInterface.bootstrap("getProperty", "address", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this))), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Could not load tags for ", " in ", ", reason: ", ""})) : null;
                    } else {
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{repository, IndyInterface.bootstrap("getProperty", "address", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)))}, new String[]{"Could not load tags for ", " in ", ""}), e) : null;
                    }
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    return map;
                }
                Object name = IndyInterface.bootstrap("getProperty", "name", 5, tags);
                CallSite imageTags = IndyInterface.bootstrap("getProperty", "tags", 5, tags);
                if (DefaultTypeTransformation.booleanUnbox((Object)name) && DefaultTypeTransformation.booleanUnbox((Object)imageTags)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)name, (Object)repository)) {
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 12, this), repository, name}, new String[]{"Docker registry ", " responded with an image name that does not match the repository name. Defaulting to repository='", "' over name='", "'"})) : null;
                        name = repository;
                    }
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{name, imageTags});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadTags_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "repositories", 4, this.credentials), new _loadTags_closure1(this, this)), new _loadTags_closure2(this, this)));
    }

    public String getAccountName() {
        return this.accountName;
    }

    private CacheResult buildCacheResult(Map<String, Set<String>> tagMap) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""})) : null;
        Reference cachedTags = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "defaultCacheDataBuilderMap", 0, DefaultCacheDataBuilder.class)));
        Reference cachedIds = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "defaultCacheDataBuilderMap", 0, DefaultCacheDataBuilder.class)));
        public final class _buildCacheResult_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cachedTags;
            private /* synthetic */ Reference cachedIds;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure3(Object _outerInstance, Object _thisObject, Reference cachedTags, Reference cachedIds) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.cachedTags = reference2 = cachedTags;
                this.cachedIds = reference = cachedIds;
            }

            public Object doCall(Object repository, Object tags) {
                Reference repository2 = new Reference(repository);
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference repository;
                    private /* synthetic */ Reference cachedTags;
                    private /* synthetic */ Reference cachedIds;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference repository, Reference cachedTags, Reference cachedIds) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.repository = reference3 = repository;
                        this.cachedTags = reference2 = cachedTags;
                        this.cachedIds = reference = cachedIds;
                    }

                    public Object doCall(Object tag) {
                        if (IndyInterface.bootstrap("cast", "()", 0, tag) == false) {
                            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 12, this), this.repository.get()}, new String[]{"Empty tag encountered for ", "/", ", not caching"})) : null;
                            return null;
                        }
                        CallSite tagKey = IndyInterface.bootstrap("invoke", "getTaggedImageKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "accountName", 12, this), this.repository.get(), tag);
                        CallSite imageIdKey = IndyInterface.bootstrap("invoke", "getImageIdKey", 0, Keys.class, IndyInterface.bootstrap("invoke", "imageId", 0, DockerRegistryProviderUtils.class, IndyInterface.bootstrap("getProperty", "registry", 12, this), this.repository.get(), tag));
                        CallSite digest = null;
                        CallSite digestContent = null;
                        CallSite creationDate = null;
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "trackDigests", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this))) != false) {
                            try {
                                digest = IndyInterface.bootstrap("invoke", "getDigest", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), this.repository.get(), tag);
                            }
                            catch (Exception e) {
                                if (e instanceof SpinnakerHttpException && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResponseCode", 0, IndyInterface.bootstrap("cast", "()", 0, e)), (Object)404)) {
                                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{tagKey, IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Image manifest for ", " no longer available; tag will not be cached: ", ""})) : null;
                                    Object var8_8 = null;
                                    return var8_8;
                                }
                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{tagKey, IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Error retrieving manifest for ", "; digest and tag will not be cached: ", ""})) : null;
                                Object var9_9 = null;
                                return var9_9;
                            }
                        }
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "inspectDigests", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this))) != false) {
                            try {
                                digest = IndyInterface.bootstrap("invoke", "getConfigDigest", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), this.repository.get(), tag);
                                digestContent = IndyInterface.bootstrap("invoke", "getDigestContent", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), this.repository.get(), digest);
                            }
                            catch (Exception e) {
                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{tagKey, IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Error retrieving config digest for ", "; digest and tag will not be cached: ", ""})) : null;
                            }
                        }
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sortTagsByDate", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this))) != false) {
                            try {
                                creationDate = IndyInterface.bootstrap("invoke", "getCreationDate", 0, IndyInterface.bootstrap("getProperty", "client", 4, IndyInterface.bootstrap("getProperty", "credentials", 12, this)), this.repository.get(), tag);
                            }
                            catch (Exception e) {
                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Unable to fetch tag creation date, reason: {} (tag: {}, repository: {})", IndyInterface.bootstrap("getProperty", "message", 0, e), tag, this.repository.get()) : null;
                            }
                        }
                        CallSite tagData = IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheDataBuilder.class);
                        IndyInterface.bootstrap("invoke", "setId", 0, tagData, tagKey);
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, tagData), "name", IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.repository.get(), tag}, new String[]{"", ":", ""})));
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, tagData), "account", IndyInterface.bootstrap("getProperty", "accountName", 12, this));
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, tagData), "digest", digest);
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, tagData), "date", creationDate);
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "config", 1, digestContent), null)) {
                            IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, tagData), "labels", IndyInterface.bootstrap("getProperty", "Labels", 0, IndyInterface.bootstrap("getProperty", "config", 0, digestContent)));
                        }
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.cachedTags.get()), tagKey, tagData);
                        CallSite idData = IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheDataBuilder.class);
                        IndyInterface.bootstrap("invoke", "setId", 0, idData, imageIdKey);
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, idData), "tagKey", tagKey);
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, idData), "account", IndyInterface.bootstrap("getProperty", "accountName", 12, this));
                        return IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.cachedIds.get()), imageIdKey, idData);
                    }

                    @Generated
                    public Object getRepository() {
                        return this.repository.get();
                    }

                    @Generated
                    public ConcurrentMap getCachedTags() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.cachedTags.get());
                    }

                    @Generated
                    public ConcurrentMap getCachedIds() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.cachedIds.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "forEach", 0, IndyInterface.bootstrap("invoke", "parallelStream", 0, tags), new _closure6((Object)this, this.getThisObject(), repository2, this.cachedTags, this.cachedIds));
                return null;
            }

            @Generated
            public Object call(Object repository, Object tags) {
                Reference repository2 = new Reference(repository);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, repository2.get(), tags);
            }

            @Generated
            public ConcurrentMap getCachedTags() {
                return IndyInterface.bootstrap("cast", "()", 0, this.cachedTags.get());
            }

            @Generated
            public ConcurrentMap getCachedIds() {
                return IndyInterface.bootstrap("cast", "()", 0, this.cachedIds.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "forEach", 0, tagMap, new _buildCacheResult_closure3(this, this, cachedTags, cachedIds));
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, (ConcurrentMap)cachedTags.get()), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " tagged images in ", ""})) : null;
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, (ConcurrentMap)cachedIds.get()), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " image ids in ", ""})) : null;
        public final class _buildCacheResult_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object builder) {
                return IndyInterface.bootstrap("invoke", "build", 0, builder);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _buildCacheResult_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object builder) {
                return IndyInterface.bootstrap("invoke", "build", 0, builder);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TAGGED_IMAGE", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "values", 0, (ConcurrentMap)cachedTags.get()), new _buildCacheResult_closure4(this, this)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGE_ID", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "values", 0, (ConcurrentMap)cachedIds.get()), new _buildCacheResult_closure5(this, this))})));
    }

    public Long getAgentInterval() {
        return this.interval;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerRegistryImageCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableSet", 0, Collections.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TAGGED_IMAGE", 0, Keys.Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGE_ID", 0, Keys.Namespace.class)))}), Set.class))), Set.class));
        types = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.docker.registry.provider.agent.DockerRegistryImageCachingAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    @Generated
    public static Set<AgentDataType> getTypes() {
        return types;
    }
}

