/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryClient;
import com.netflix.spinnaker.clouddriver.docker.registry.exception.DockerRegistryConfigException;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryCredentials;
import com.netflix.spinnaker.clouddriver.docker.registry.security.KeyBasedSorter;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistryNamedAccountCredentials
extends AbstractAccountCredentials<DockerRegistryCredentials>
implements GroovyObject {
    private static final String CLOUD_PROVIDER = "dockerRegistry";
    private final String accountName;
    private final String environment;
    private final String accountType;
    private final String address;
    private final String registry;
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private final String password;
    private final String passwordCommand;
    private final File passwordFile;
    private final String email;
    private final boolean trackDigests;
    private final boolean inspectDigests;
    private final boolean sortTagsByDate;
    private final int cacheThreads;
    private final long cacheIntervalSeconds;
    private final long clientTimeoutMillis;
    private final int paginateSize;
    private final boolean insecureRegistry;
    @JsonIgnore
    private final DockerRegistryCredentials credentials;
    private final Permissions permissions;
    private final List<String> skip;
    private final String catalogFile;
    private final String repositoriesRegex;
    private final DockerOkClientProvider dockerOkClientProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, String passwordCommand, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean inspectDigests, boolean sortTagsByDate, String catalogFile, String repositoriesRegex, boolean insecureRegistry, DockerOkClientProvider dockerOkClientProvider) {
        this(accountName, environment, accountType, address, username, password, passwordCommand, passwordFile, dockerconfigFile, email, repositories, skip, cacheThreads, cacheIntervalSeconds, clientTimeoutMillis, paginateSize, trackDigests, inspectDigests, sortTagsByDate, catalogFile, repositoriesRegex, insecureRegistry, null, null, dockerOkClientProvider);
    }

    public DockerRegistryNamedAccountCredentials(String accountName, String environment, String accountType, String address, String username, String password, String passwordCommand, File passwordFile, File dockerconfigFile, String email, List<String> repositories, List<String> skip, int cacheThreads, long cacheIntervalSeconds, long clientTimeoutMillis, int paginateSize, boolean trackDigests, boolean inspectDigests, boolean sortTagsByDate, String catalogFile, String repositoriesRegex, boolean insecureRegistry, List<String> requiredGroupMembership, Permissions permissions, DockerOkClientProvider dockerOkClientProvider) {
        List list;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        DockerOkClientProvider dockerOkClientProvider2;
        int n;
        int n2;
        File file;
        String string6;
        String string7;
        String string8;
        String string9;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (IndyInterface.bootstrap("cast", "()", 0, accountName) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "Docker Registry account must be provided with a name."));
        }
        if (DefaultTypeTransformation.booleanUnbox(repositories) && DefaultTypeTransformation.booleanUnbox((Object)catalogFile)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "repositories and catalogFile may not be specified together."));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)repositoriesRegex) && (DefaultTypeTransformation.booleanUnbox(repositories) || DefaultTypeTransformation.booleanUnbox((Object)catalogFile))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "repositoriesRegex may not be specified at the same time than repositories or catalogFile."));
        }
        this.accountName = string9 = accountName;
        this.environment = string8 = environment;
        this.accountType = string7 = accountType;
        this.passwordCommand = string6 = passwordCommand;
        this.passwordFile = file = passwordFile;
        int n3 = cacheThreads;
        this.cacheThreads = n2 = n3 != 0 ? n3 : 1;
        long l = cacheIntervalSeconds;
        long l2 = l != 0L ? l : (long)30;
        this.cacheIntervalSeconds = l2;
        int n4 = paginateSize;
        this.paginateSize = n = n4 != 0 ? n4 : 100;
        long l3 = clientTimeoutMillis;
        Long l4 = l3 != 0L ? Long.valueOf(l3) : IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), true);
        this.clientTimeoutMillis = DefaultTypeTransformation.longUnbox((Object)l4);
        this.dockerOkClientProvider = dockerOkClientProvider2 = dockerOkClientProvider;
        if (IndyInterface.bootstrap("cast", "()", 0, address) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{accountName}, new String[]{"Docker Registry account ", " must provide an endpoint address."})));
        }
        int addressLen = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "length", 0, address));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, address, IndyInterface.bootstrap("invoke", "minus", 0, addressLen, true)), (Object)"/")) {
            address = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, address, false, IndyInterface.bootstrap("invoke", "minus", 0, addressLen, true)));
            addressLen = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, addressLen, true));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, address, "/v2")) != false) {
            address = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, address, false, IndyInterface.bootstrap("invoke", "minus", 0, addressLen, 3)));
        }
        this.address = string5 = address;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, address, "https://")) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "substring", 0, address, IndyInterface.bootstrap("invoke", "length", 0, "https://"));
            this.registry = IndyInterface.bootstrap("cast", "()", 0, callSite);
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, address, "http://")) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "substring", 0, address, IndyInterface.bootstrap("invoke", "length", 0, "http://"));
            this.registry = IndyInterface.bootstrap("cast", "()", 0, callSite);
        } else {
            Object object;
            this.registry = object = address;
        }
        this.username = string4 = username;
        this.password = string3 = password;
        this.email = string2 = email;
        this.repositoriesRegex = string = repositoriesRegex;
        this.trackDigests = bl4 = trackDigests;
        this.inspectDigests = bl3 = inspectDigests;
        this.sortTagsByDate = bl2 = sortTagsByDate;
        this.insecureRegistry = bl = insecureRegistry;
        List list2 = skip;
        this.skip = list = IndyInterface.bootstrap("cast", "()", 0, list2) != false ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Permissions permissions2 = permissions;
        Permissions permissions3 = IndyInterface.bootstrap("cast", "()", 0, permissions2) != false ? permissions2 : IndyInterface.bootstrap("invoke", "buildPermissionsFromRequiredGroupMembership", 0, DockerRegistryNamedAccountCredentials.class, requiredGroupMembership);
        this.permissions = IndyInterface.bootstrap("cast", "()", 0, permissions3);
        CallSite callSite = IndyInterface.bootstrap("invoke", "buildCredentials", 2, this, repositories, catalogFile, dockerconfigFile);
        this.credentials = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @JsonIgnore
    public List<String> getRepositories() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "repositories", 4, this.credentials));
    }

    public String getName() {
        return this.accountName;
    }

    public String getRegistry() {
        return this.registry;
    }

    @JsonIgnore
    public String getBasicAuth() {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "basicAuth", 1, IndyInterface.bootstrap("getProperty", "client", 1, this.credentials));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "");
    }

    @JsonIgnore
    public List<String> getTags(String repository) {
        Reference repository2 = new Reference((Object)repository);
        List<String> tags = this.credentials.getClient().getTags((String)repository2.get()).getTags();
        if (this.sortTagsByDate) {
            public final class _getTags_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference repository;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getTags_closure1(Object _outerInstance, Object _thisObject, Reference repository) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.repository = reference = repository;
                }

                public Instant doCall(String t) {
                    return ((DockerRegistryNamedAccountCredentials)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getCreationDate((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.repository.get())), t);
                }

                @Generated
                public Instant call(String t) {
                    return this.doCall(t);
                }

                @Generated
                public String getRepository() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.repository.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTags_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            tags = KeyBasedSorter.sort(tags, IndyInterface.bootstrap("cast", "()", 0, new _getTags_closure1((Object)this, (Object)this, repository2)), Comparator.reverseOrder());
        }
        return tags;
    }

    private Instant getCreationDate(String repository, String tag) {
        Instant instant = this.credentials.getClient().getCreationDate(repository, tag);
        try {
            return instant;
        }
        catch (Exception e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn("Unable to fetch tag creation date, reason: {} (tag: {}, repository: {})", new Object[]{e.getMessage(), tag, repository});
                v0 = null;
            } else {
                v0 = null;
            }
            Instant instant2 = Instant.EPOCH;
            return instant2;
        }
    }

    public String getV2Endpoint() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.address}, new String[]{"", "/v2"}));
    }

    public boolean getTrackDigests() {
        return this.trackDigests;
    }

    public boolean getInspectDigests() {
        return this.inspectDigests;
    }

    public int getCacheThreads() {
        return this.cacheThreads;
    }

    public long getCacheIntervalSeconds() {
        return this.cacheIntervalSeconds;
    }

    public DockerRegistryCredentials getCredentials() {
        return this.credentials;
    }

    public String getCloudProvider() {
        return CLOUD_PROVIDER;
    }

    private DockerRegistryCredentials buildCredentials(List<String> repositories, String catalogFile, File dockerconfigFile) {
        CallSite client = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "okClientProvider", 0, IndyInterface.bootstrap("invoke", "insecureRegistry", 0, IndyInterface.bootstrap("invoke", "repositoriesRegex", 0, IndyInterface.bootstrap("invoke", "dockerconfigFile", 0, IndyInterface.bootstrap("invoke", "catalogFile", 0, IndyInterface.bootstrap("invoke", "paginateSize", 0, IndyInterface.bootstrap("invoke", "clientTimeoutMillis", 0, IndyInterface.bootstrap("invoke", "passwordFile", 0, IndyInterface.bootstrap("invoke", "passwordCommand", 0, IndyInterface.bootstrap("invoke", "password", 0, IndyInterface.bootstrap("invoke", "username", 0, IndyInterface.bootstrap("invoke", "email", 0, IndyInterface.bootstrap("invoke", "address", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryClient.Builder.class), this.address), this.email), this.username), this.password), this.passwordCommand), this.passwordFile), this.clientTimeoutMillis), this.paginateSize), catalogFile), dockerconfigFile), this.repositoriesRegex), this.insecureRegistry), this.dockerOkClientProvider)));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryCredentials.class, client, repositories, this.trackDigests, this.inspectDigests, this.skip, this.sortTagsByDate));
        try {
            return callSite;
        }
        catch (SpinnakerHttpException e) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResponseCode", 0, e), (Object)404)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryConfigException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 12, this), this.address}, new String[]{"No repositories specified for ", ", and the provided endpoint ", " does not support /_catalog."})));
            }
            throw (Throwable)e;
        }
    }

    private static Permissions buildPermissionsFromRequiredGroupMembership(List<String> requiredGroupMembership) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "empty", 1, requiredGroupMembership);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Boolean.valueOf(true)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "EMPTY", 0, Permissions.class));
        }
        Reference builder = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, Permissions.Builder.class));
        public final class _buildPermissionsFromRequiredGroupMembership_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildPermissionsFromRequiredGroupMembership_closure2(Object _outerInstance, Object _thisObject, Reference builder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.builder = reference = builder;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "add", 0, this.builder.get(), IndyInterface.bootstrap("getProperty", "READ", 0, Authorization.class), it), IndyInterface.bootstrap("getProperty", "WRITE", 0, Authorization.class), it);
            }

            @Generated
            public Object getBuilder() {
                return this.builder.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildPermissionsFromRequiredGroupMembership_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "forEach", 0, requiredGroupMembership, new _buildPermissionsFromRequiredGroupMembership_closure2(DockerRegistryNamedAccountCredentials.class, DockerRegistryNamedAccountCredentials.class, builder));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder.get()));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DockerRegistryNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerRegistryNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final String getEnvironment() {
        return this.environment;
    }

    @Generated
    public final String getAccountType() {
        return this.accountType;
    }

    @Generated
    public final String getAddress() {
        return this.address;
    }

    @Generated
    public final String getUsername() {
        return this.username;
    }

    @Generated
    public final String getPassword() {
        return this.password;
    }

    @Generated
    public final String getPasswordCommand() {
        return this.passwordCommand;
    }

    @Generated
    public final File getPasswordFile() {
        return this.passwordFile;
    }

    @Generated
    public final String getEmail() {
        return this.email;
    }

    @Generated
    public final boolean getSortTagsByDate() {
        return this.sortTagsByDate;
    }

    @Generated
    public final boolean isSortTagsByDate() {
        return this.sortTagsByDate;
    }

    @Generated
    public final long getClientTimeoutMillis() {
        return this.clientTimeoutMillis;
    }

    @Generated
    public final int getPaginateSize() {
        return this.paginateSize;
    }

    @Generated
    public final boolean getInsecureRegistry() {
        return this.insecureRegistry;
    }

    @Generated
    public final boolean isInsecureRegistry() {
        return this.insecureRegistry;
    }

    @Generated
    public final Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public final List<String> getSkip() {
        return this.skip;
    }

    @Generated
    public final String getCatalogFile() {
        return this.catalogFile;
    }

    @Generated
    public final String getRepositoriesRegex() {
        return this.repositoriesRegex;
    }

    @Generated
    public final DockerOkClientProvider getDockerOkClientProvider() {
        return this.dockerOkClientProvider;
    }

    public /* synthetic */ Permissions super$2$getPermissions() {
        return super.getPermissions();
    }

    public static class Builder
    implements GroovyObject {
        private String accountName;
        private String environment;
        private String accountType;
        private String address;
        private String username;
        private String password;
        private String passwordCommand;
        private File passwordFile;
        private File dockerconfigFile;
        private String email;
        private int cacheThreads;
        private long cacheIntervalSeconds;
        private long clientTimeoutMillis;
        private int paginateSize;
        private boolean trackDigests;
        private boolean inspectDigests;
        private boolean sortTagsByDate;
        private boolean insecureRegistry;
        private List<String> repositories;
        private List<String> skip;
        private String catalogFile;
        private String repositoriesRegex;
        private Permissions permissions;
        private DockerOkClientProvider dockerOkClientProvider;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Builder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder accountName(String accountName) {
            String string;
            this.accountName = string = accountName;
            return this;
        }

        public Builder environment(String environment) {
            String string;
            this.environment = string = environment;
            return this;
        }

        public Builder accountType(String accountType) {
            String string;
            this.accountType = string = accountType;
            return this;
        }

        public Builder address(String address) {
            String string;
            this.address = string = address;
            return this;
        }

        public Builder username(String username) {
            String string;
            this.username = string = username;
            return this;
        }

        public Builder password(String address) {
            String string;
            this.password = string = address;
            return this;
        }

        public Builder passwordCommand(String passwordCommand) {
            String string;
            this.passwordCommand = string = passwordCommand;
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            if (IndyInterface.bootstrap("cast", "()", 0, passwordFile) != false) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, passwordFile);
                this.passwordFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            } else {
                Object var3_3 = null;
                this.passwordFile = IndyInterface.bootstrap("cast", "()", 0, var3_3);
            }
            return this;
        }

        public Builder dockerconfigFile(String dockerconfigFile) {
            if (IndyInterface.bootstrap("cast", "()", 0, dockerconfigFile) != false) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, File.class, dockerconfigFile);
                this.dockerconfigFile = IndyInterface.bootstrap("cast", "()", 0, callSite);
            } else {
                Object var3_3 = null;
                this.dockerconfigFile = IndyInterface.bootstrap("cast", "()", 0, var3_3);
            }
            return this;
        }

        public Builder email(String email) {
            String string;
            this.email = string = email;
            return this;
        }

        public Builder cacheThreads(int cacheThreads) {
            int n;
            this.cacheThreads = n = cacheThreads;
            return this;
        }

        public Builder cacheIntervalSeconds(long cacheIntervalSeconds) {
            long l = cacheIntervalSeconds;
            this.cacheIntervalSeconds = l;
            return this;
        }

        public Builder clientTimeoutMillis(long clientTimeoutMillis) {
            long l = clientTimeoutMillis;
            this.clientTimeoutMillis = l;
            return this;
        }

        public Builder paginateSize(int paginateSize) {
            int n;
            this.paginateSize = n = paginateSize;
            return this;
        }

        public Builder trackDigests(boolean trackDigests) {
            boolean bl;
            this.trackDigests = bl = trackDigests;
            return this;
        }

        public Builder inspectDigests(boolean inspectDigests) {
            boolean bl;
            this.inspectDigests = bl = inspectDigests;
            return this;
        }

        public Builder sortTagsByDate(boolean sortTagsByDate) {
            boolean bl;
            this.sortTagsByDate = bl = sortTagsByDate;
            return this;
        }

        public Builder insecureRegistry(boolean insecureRegistry) {
            boolean bl;
            this.insecureRegistry = bl = insecureRegistry;
            return this;
        }

        public Builder repositories(List<String> repositories) {
            List<String> list = repositories;
            this.repositories = list;
            return this;
        }

        public Builder skip(List<String> skip) {
            List<String> list = skip;
            this.skip = list;
            return this;
        }

        public Builder catalogFile(String catalogFile) {
            String string;
            this.catalogFile = string = catalogFile;
            return this;
        }

        public Builder repositoriesRegex(String repositoriesRegex) {
            String string;
            this.repositoriesRegex = string = repositoriesRegex;
            return this;
        }

        public Builder permissions(Permissions permissions) {
            Permissions permissions2;
            this.permissions = permissions2 = permissions;
            return this;
        }

        public Builder dockerOkClientProvider(DockerOkClientProvider dockerOkClientProvider) {
            DockerOkClientProvider dockerOkClientProvider2;
            this.dockerOkClientProvider = dockerOkClientProvider2 = dockerOkClientProvider;
            return this;
        }

        public DockerRegistryNamedAccountCredentials build() {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryNamedAccountCredentials.class, this.accountName, this.environment, this.accountType, this.address, this.username, this.password, this.passwordCommand, this.passwordFile, this.dockerconfigFile, this.email, this.repositories, this.skip, this.cacheThreads, this.cacheIntervalSeconds, this.clientTimeoutMillis, this.paginateSize, this.trackDigests, this.inspectDigests, this.sortTagsByDate, this.catalogFile, this.repositoriesRegex, this.insecureRegistry, null, this.permissions, this.dockerOkClientProvider));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getAccountName() {
            return this.accountName;
        }

        @Generated
        public void setAccountName(String string) {
            this.accountName = string;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public void setEnvironment(String string) {
            this.environment = string;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public void setAccountType(String string) {
            this.accountType = string;
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public void setAddress(String string) {
            this.address = string;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public void setUsername(String string) {
            this.username = string;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String string) {
            this.password = string;
        }

        @Generated
        public String getPasswordCommand() {
            return this.passwordCommand;
        }

        @Generated
        public void setPasswordCommand(String string) {
            this.passwordCommand = string;
        }

        @Generated
        public File getPasswordFile() {
            return this.passwordFile;
        }

        @Generated
        public void setPasswordFile(File file) {
            this.passwordFile = file;
        }

        @Generated
        public File getDockerconfigFile() {
            return this.dockerconfigFile;
        }

        @Generated
        public void setDockerconfigFile(File file) {
            this.dockerconfigFile = file;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setEmail(String string) {
            this.email = string;
        }

        @Generated
        public int getCacheThreads() {
            return this.cacheThreads;
        }

        @Generated
        public void setCacheThreads(int n) {
            this.cacheThreads = n;
        }

        @Generated
        public long getCacheIntervalSeconds() {
            return this.cacheIntervalSeconds;
        }

        @Generated
        public void setCacheIntervalSeconds(long l) {
            this.cacheIntervalSeconds = l;
        }

        @Generated
        public long getClientTimeoutMillis() {
            return this.clientTimeoutMillis;
        }

        @Generated
        public void setClientTimeoutMillis(long l) {
            this.clientTimeoutMillis = l;
        }

        @Generated
        public int getPaginateSize() {
            return this.paginateSize;
        }

        @Generated
        public void setPaginateSize(int n) {
            this.paginateSize = n;
        }

        @Generated
        public boolean getTrackDigests() {
            return this.trackDigests;
        }

        @Generated
        public boolean isTrackDigests() {
            return this.trackDigests;
        }

        @Generated
        public void setTrackDigests(boolean bl) {
            this.trackDigests = bl;
        }

        @Generated
        public boolean getInspectDigests() {
            return this.inspectDigests;
        }

        @Generated
        public boolean isInspectDigests() {
            return this.inspectDigests;
        }

        @Generated
        public void setInspectDigests(boolean bl) {
            this.inspectDigests = bl;
        }

        @Generated
        public boolean getSortTagsByDate() {
            return this.sortTagsByDate;
        }

        @Generated
        public boolean isSortTagsByDate() {
            return this.sortTagsByDate;
        }

        @Generated
        public void setSortTagsByDate(boolean bl) {
            this.sortTagsByDate = bl;
        }

        @Generated
        public boolean getInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public boolean isInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public void setInsecureRegistry(boolean bl) {
            this.insecureRegistry = bl;
        }

        @Generated
        public List<String> getRepositories() {
            return this.repositories;
        }

        @Generated
        public void setRepositories(List<String> list) {
            this.repositories = list;
        }

        @Generated
        public List<String> getSkip() {
            return this.skip;
        }

        @Generated
        public void setSkip(List<String> list) {
            this.skip = list;
        }

        @Generated
        public String getCatalogFile() {
            return this.catalogFile;
        }

        @Generated
        public void setCatalogFile(String string) {
            this.catalogFile = string;
        }

        @Generated
        public String getRepositoriesRegex() {
            return this.repositoriesRegex;
        }

        @Generated
        public void setRepositoriesRegex(String string) {
            this.repositoriesRegex = string;
        }

        @Generated
        public Permissions getPermissions() {
            return this.permissions;
        }

        @Generated
        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }

        @Generated
        public DockerOkClientProvider getDockerOkClientProvider() {
            return this.dockerOkClientProvider;
        }

        @Generated
        public void setDockerOkClientProvider(DockerOkClientProvider dockerOkClientProvider) {
            this.dockerOkClientProvider = dockerOkClientProvider;
        }
    }
}

