/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client;

import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.security.TrustAllX509TrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class DefaultDockerOkClientProvider
implements DockerOkClientProvider {
    @Override
    public OkHttpClient provide(String address, long timeoutMs, boolean insecure) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(timeoutMs, TimeUnit.MILLISECONDS);
        if (insecure) {
            SSLContext sslContext;
            TrustManager[] trustManagers = new TrustManager[]{new TrustAllX509TrustManager()};
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("Failed configuring insecure SslSocketFactory", e);
            }
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
        }
        return clientBuilder.build();
    }
}

