/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryCatalog;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryTags;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryOperationException;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.lang.Tuple2;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.time.Instant;
import java.util.Map;
import okhttp3.ResponseBody;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class DockerRegistryClient
implements GroovyObject {
    private static final Logger LOG;
    private DockerBearerTokenService tokenService;
    private String address;
    private String email;
    private DockerRegistryService registryService;
    private String catalogFile;
    private String repositoriesRegex;
    private static final String userAgent;
    private final int paginateSize;
    private static ObjectMapper objectMapper;
    private Map tagDateCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DockerRegistryClient(String address, long clientTimeoutMillis, int paginateSize, String catalogFile, String repositoriesRegex, boolean insecureRegistry, DockerOkClientProvider okClientProvider, ServiceClientProvider serviceClientProvider) {
        String string;
        String string2;
        String string3;
        int n;
        MetaClass metaClass;
        Map map;
        this.tagDateCache = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.paginateSize = n = paginateSize;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, DockerBearerTokenService.class, serviceClientProvider);
        this.tokenService = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "create", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "addConverterFactory", 0, IndyInterface.bootstrap("invoke", "addCallAdapterFactory", 0, IndyInterface.bootstrap("invoke", "client", 0, IndyInterface.bootstrap("invoke", "baseUrl", 0, IndyInterface.bootstrap("init", "<init>", 0, Retrofit.Builder.class), address), IndyInterface.bootstrap("invoke", "provide", 0, okClientProvider, address, clientTimeoutMillis, insecureRegistry)), IndyInterface.bootstrap("invoke", "getInstance", 0, ErrorHandlingExecutorCallAdapterFactory.class)), IndyInterface.bootstrap("invoke", "create", 0, JacksonConverterFactory.class))), DockerRegistryService.class);
        this.registryService = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.address = string3 = address;
        this.catalogFile = string2 = catalogFile;
        this.repositoriesRegex = string = repositoriesRegex;
    }

    public DockerRegistryClient(String address, String email, String username, String password, String passwordCommand, long clientTimeoutMillis, int paginateSize, String catalogFile, String repositoriesRegex, boolean insecureRegistry, DockerOkClientProvider okClientProvider, ServiceClientProvider serviceClientProvider) {
        this(address, clientTimeoutMillis, paginateSize, catalogFile, repositoriesRegex, insecureRegistry, okClientProvider, serviceClientProvider);
        String string;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, DockerBearerTokenService.class, username, password, passwordCommand, serviceClientProvider);
        this.tokenService = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.email = string = email;
    }

    public DockerRegistryClient(String address, int paginateSize, String catalogFile, String repositoriesRegex, DockerRegistryService dockerRegistryService, DockerBearerTokenService dockerBearerTokenService) {
        DockerRegistryService dockerRegistryService2;
        DockerBearerTokenService dockerBearerTokenService2;
        String string;
        String string2;
        String string3;
        int n;
        MetaClass metaClass;
        Map map;
        this.tagDateCache = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.paginateSize = n = paginateSize;
        this.address = string3 = address;
        this.catalogFile = string2 = catalogFile;
        this.repositoriesRegex = string = repositoriesRegex;
        this.tokenService = dockerBearerTokenService2 = dockerBearerTokenService;
        this.registryService = dockerRegistryService2 = dockerRegistryService;
    }

    public DockerRegistryClient(String address, String email, String username, File passwordFile, long clientTimeoutMillis, int paginateSize, String catalogFile, String repositoriesRegex, boolean insecureRegistry, DockerOkClientProvider okClientProvider, ServiceClientProvider serviceClientProvider) {
        this(address, clientTimeoutMillis, paginateSize, catalogFile, repositoriesRegex, insecureRegistry, okClientProvider, serviceClientProvider);
        String string;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, DockerBearerTokenService.class, username, passwordFile, serviceClientProvider);
        this.tokenService = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.email = string = email;
    }

    private static ObjectMapper getObjectMapper() {
        if (ScriptBytecodeAdapter.compareEqual((Object)objectMapper, null)) {
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ObjectMapper.class);
            objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite);
            IndyInterface.bootstrap("invoke", "configure", 0, objectMapper, IndyInterface.bootstrap("getProperty", "FAIL_ON_UNKNOWN_PROPERTIES", 0, DeserializationFeature.class), false);
        }
        return objectMapper;
    }

    public String getBasicAuth() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "basicAuth", 5, this.tokenService));
    }

    public String getDigest(String name, String tag) {
        CallSite response = IndyInterface.bootstrap("invoke", "getManifest", 2, this, name, tag);
        CallSite headers = IndyInterface.bootstrap("getProperty", "headers", 0, response);
        public final class _getDigest_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDigest_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)"Docker-Content-Digest");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDigest_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite digest = IndyInterface.bootstrap("invoke", "find", 1, headers, new _getDigest_closure1(this, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 1, digest));
    }

    public String getConfigDigest(String name, String tag) {
        CallSite response = IndyInterface.bootstrap("invoke", "getSchemaV2Manifest", 2, this, name, tag);
        CallSite manifestMap = IndyInterface.bootstrap("invoke", "convertResponseBody", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "body", 0, response), Map.class);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "digest", 1, IndyInterface.bootstrap("getProperty", "config", 1, manifestMap)));
    }

    /*
     * WARNING - void declaration
     */
    public Map getDigestContent(String name, String digest) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference digest2 = new Reference((Object)var2_2);
        public final class _getDigestContent_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference digest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDigestContent_closure2(Object _outerInstance, Object _thisObject, Reference name, Reference digest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.digest = reference = digest;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getDigestContent", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.digest.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getDigest() {
                return IndyInterface.bootstrap("cast", "()", 0, this.digest.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDigestContent_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getDigestContent_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference digest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDigestContent_closure3(Object _outerInstance, Object _thisObject, Reference name, Reference digest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.digest = reference = digest;
            }

            public Object doCall(Object token) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getDigestContent", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.digest.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getDigest() {
                return IndyInterface.bootstrap("cast", "()", 0, this.digest.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDigestContent_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite response = IndyInterface.bootstrap("invoke", "request", 2, this, new _getDigestContent_closure2(this, this, name2, digest2), new _getDigestContent_closure3(this, this, name2, digest2), (String)name2.get());
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertResponseBody", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "body", 0, response), Map.class));
    }

    public static Object convertResponseBody(ResponseBody responseBody, Class aClass) {
        if (ScriptBytecodeAdapter.compareEqual((Object)responseBody, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryOperationException.class, "ResponseBody cannot be null"));
        }
        CallSite jsonString = IndyInterface.bootstrap("invoke", "string", 0, responseBody);
        CallSite callSite = IndyInterface.bootstrap("invoke", "readValue", 0, IndyInterface.bootstrap("invoke", "getObjectMapper", 0, DockerRegistryClient.class), jsonString, aClass);
        try {
            return callSite;
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Failed to parse ResponseBody : ", ""}), e));
        }
    }

    public Instant getCreationDate(String name, String tag) {
        CallSite key = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name, tag}, new String[]{"", ":", ""}));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, this.tagDateCache, key)) && ScriptBytecodeAdapter.compareNotEqual((Object)tag, (Object)"latest")) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.tagDateCache, key));
        }
        CallSite manifest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertResponseBody", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "body", 0, IndyInterface.bootstrap("invoke", "getManifest", 2, this, name, tag)), Map.class));
        CallSite dateCreated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Instant.class, IndyInterface.bootstrap("getProperty", "created", 0, IndyInterface.bootstrap("invoke", "fromJson", 0, IndyInterface.bootstrap("init", "<init>", 0, Gson.class), IndyInterface.bootstrap("getProperty", "v1Compatibility", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "history", 0, manifest), false)), Map.class))));
        CallSite callSite = dateCreated;
        IndyInterface.bootstrap("invoke", "putAt", 0, this.tagDateCache, key, callSite);
        return dateCreated;
    }

    /*
     * WARNING - void declaration
     */
    private Object getManifest(String name, String tag) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference tag2 = new Reference((Object)var2_2);
        public final class _getManifest_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getManifest_closure4(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getManifest", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.tag.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getTag() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tag.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getManifest_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getManifest_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getManifest_closure5(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object token) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getManifest", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.tag.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getTag() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tag.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getManifest_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "request", 2, this, new _getManifest_closure4(this, this, name2, tag2), new _getManifest_closure5(this, this, name2, tag2), (String)name2.get());
    }

    /*
     * WARNING - void declaration
     */
    private Object getSchemaV2Manifest(String name, String tag) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference tag2 = new Reference((Object)var2_2);
        public final class _getSchemaV2Manifest_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSchemaV2Manifest_closure6(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getSchemaV2Manifest", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.tag.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getTag() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tag.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSchemaV2Manifest_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getSchemaV2Manifest_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSchemaV2Manifest_closure7(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object token) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getSchemaV2Manifest", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.tag.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public String getTag() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tag.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSchemaV2Manifest_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "request", 2, this, new _getSchemaV2Manifest_closure6(this, this, name2, tag2), new _getSchemaV2Manifest_closure7(this, this, name2, tag2), (String)name2.get());
    }

    private static String parseLink(String headerValue) {
        public final class _parseLink_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _parseLink_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "trim", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite links = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "split", 0, headerValue, ";"), new _parseLink_closure8(DockerRegistryClient.class, DockerRegistryClient.class));
        public final class _parseLink_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _parseLink_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String tok) {
                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("invoke", "replace", 0, tok, " ", ""), "rel=\"next\"");
            }

            @Generated
            public Object call(String tok) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tok);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, links, new _parseLink_closure9(DockerRegistryClient.class, DockerRegistryClient.class))) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        public final class _parseLink_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _parseLink_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String tok) {
                return DefaultTypeTransformation.booleanUnbox((Object)tok) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, tok, false), (Object)"<") && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, tok, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, tok), true)), (Object)">");
            }

            @Generated
            public Object call(String tok) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tok);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite path = IndyInterface.bootstrap("invoke", "find", 0, links, new _parseLink_closure10(DockerRegistryClient.class, DockerRegistryClient.class));
        CallSite link = IndyInterface.bootstrap("invoke", "substring", 1, path, true, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, path), true));
        try {
            CallSite url = IndyInterface.bootstrap("init", "<init>", 0, URL.class, link);
            link = IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("invoke", "getFile", 0, url), true);
        }
        catch (Exception e) {
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, link, "/")) != false ? IndyInterface.bootstrap("invoke", "replaceFirst", 0, link, "/", "") : link);
    }

    private static String findNextLink(okhttp3.Headers headers) {
        Reference headers2 = new Reference((Object)headers);
        if (IndyInterface.bootstrap("cast", "()", 0, (okhttp3.Headers)headers2.get()) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        public final class _findNextLink_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findNextLink_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findNextLink_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference caseInsensitiveHeaders = new Reference((Object)IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _findNextLink_closure11(DockerRegistryClient.class, DockerRegistryClient.class)));
        public final class _findNextLink_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference caseInsensitiveHeaders;
            private /* synthetic */ Reference headers;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findNextLink_closure12(Object _outerInstance, Object _thisObject, Reference caseInsensitiveHeaders, Reference headers) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.caseInsensitiveHeaders = reference2 = caseInsensitiveHeaders;
                this.headers = reference = headers;
            }

            public Object doCall(Object name) {
                Object object = this.caseInsensitiveHeaders.get();
                CallSite callSite = IndyInterface.bootstrap("invoke", "toLowerCase", 0, name);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAt", 0, object, callSite), IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("cast", "()", 0, this.headers.get()), name));
                IndyInterface.bootstrap("invoke", "putAt", 0, object, callSite, callSite2);
                return callSite2;
            }

            @Generated
            public Object getCaseInsensitiveHeaders() {
                return this.caseInsensitiveHeaders.get();
            }

            @Generated
            public okhttp3.Headers getHeaders() {
                return IndyInterface.bootstrap("cast", "()", 0, this.headers.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findNextLink_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "names", 0, (okhttp3.Headers)headers2.get()), new _findNextLink_closure12(DockerRegistryClient.class, DockerRegistryClient.class, caseInsensitiveHeaders, headers2));
        CallSite headerValues = IndyInterface.bootstrap("invoke", "getAt", 0, caseInsensitiveHeaders.get(), "link");
        if (IndyInterface.bootstrap("cast", "()", 0, headerValues) == false || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, headerValues), (Object)0)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, headerValues), (Object)1)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryOperationException.class, new GStringImpl(new Object[]{headerValues}, new String[]{"Ambiguous number of Link headers provided, the following paths were identified: ", ""})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseLink", 0, DockerRegistryClient.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, headerValues, false), String.class))), String.class)));
    }

    /*
     * WARNING - void declaration
     */
    public DockerRegistryCatalog getCatalog(String path, Map<String, String> queryParams) {
        void var2_2;
        Reference path2 = new Reference((Object)path);
        Reference queryParams2 = new Reference((Object)var2_2);
        if (IndyInterface.bootstrap("cast", "()", 0, this.catalogFile) != false) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{this.catalogFile}, new String[]{"Using catalog list at ", ""})) : null;
            CallSite userDefinedCatalog = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getText", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.catalogFile)));
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromJson", 0, IndyInterface.bootstrap("init", "<init>", 0, Gson.class), userDefinedCatalog, DockerRegistryCatalog.class));
            try {
                return callSite2;
            }
            catch (Exception e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryOperationException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.catalogFile}, new String[]{"Unable to read catalog file ", ": "}), IndyInterface.bootstrap("invoke", "getMessage", 0, e)), e));
            }
        }
        public final class _getCatalog_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getCatalog_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "paginateSize", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCatalog_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "computeIfAbsent", 0, (Map)queryParams2.get(), "n", new _getCatalog_closure13(this, this));
        CallSite response = null;
        try {
            public final class _getCatalog_closure14
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference path;
                private /* synthetic */ Reference queryParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCatalog_closure14(Object _outerInstance, Object _thisObject, Reference path, Reference queryParams) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.path = reference2 = path;
                    this.queryParams = reference = queryParams;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())) != false ? IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.path.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get()))) : IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getCatalog", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get())));
                }

                @Generated
                public String getPath() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.path.get());
                }

                @Generated
                public Map getQueryParams() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCatalog_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            public final class _getCatalog_closure15
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference path;
                private /* synthetic */ Reference queryParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCatalog_closure15(Object _outerInstance, Object _thisObject, Reference path, Reference queryParams) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.path = reference2 = path;
                    this.queryParams = reference = queryParams;
                }

                public Object doCall(Object token) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())) != false ? IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.path.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get()))) : IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getCatalog", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get())));
                }

                @Generated
                public String getPath() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.path.get());
                }

                @Generated
                public Map getQueryParams() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCatalog_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            response = IndyInterface.bootstrap("invoke", "request", 2, this, new _getCatalog_closure14(this, this, path2, queryParams2), new _getCatalog_closure15(this, this, path2, queryParams2), "_catalog");
        }
        catch (Exception e) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{(String)path2.get()}, new String[]{"Error encountered during catalog of ", ""}), e) : null;
            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryCatalog.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"repositories", ScriptBytecodeAdapter.createList((Object[])new Object[0])})));
            return callSite3;
        }
        CallSite nextPath = IndyInterface.bootstrap("invoke", "findNextLink", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "headers", 1, response));
        CallSite catalog = IndyInterface.bootstrap("invoke", "convertResponseBody", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "body", 0, response), DockerRegistryCatalog.class);
        if (IndyInterface.bootstrap("cast", "()", 0, this.repositoriesRegex) != false) {
            public final class _getCatalog_closure16
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCatalog_closure16(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.matchRegex((Object)it, (Object)IndyInterface.bootstrap("getProperty", "repositoriesRegex", 12, this));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCatalog_closure16.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "repositories", 0, catalog), new _getCatalog_closure16(this, this));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)catalog, (String)"repositories");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, nextPath) != false) {
            CallSite nextPathNew = null;
            CallSite callSite = IndyInterface.bootstrap("invoke", "parseForQueryParams", 0, DockerRegistryClient.class, nextPath);
            nextPathNew = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(0));
            queryParams2.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(1))));
            CallSite nextCatalog = IndyInterface.bootstrap("invoke", "getCatalog", 2, this, nextPathNew, (Map)queryParams2.get());
            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "repositories", 0, catalog), IndyInterface.bootstrap("getProperty", "repositories", 0, nextCatalog));
        }
        return IndyInterface.bootstrap("cast", "()", 0, catalog);
    }

    /*
     * WARNING - void declaration
     */
    public DockerRegistryTags getTags(String repository, String path, Map<String, String> queryParams) {
        void var3_3;
        void var2_2;
        Reference repository2 = new Reference((Object)repository);
        Reference path2 = new Reference((Object)var2_2);
        Reference queryParams2 = new Reference((Object)var3_3);
        public final class _getTags_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTags_closure17(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "paginateSize", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTags_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "computeIfAbsent", 0, (Map)queryParams2.get(), "n", new _getTags_closure17(this, this));
        public final class _getTags_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference path;
            private /* synthetic */ Reference queryParams;
            private /* synthetic */ Reference repository;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTags_closure18(Object _outerInstance, Object _thisObject, Reference path, Reference queryParams, Reference repository) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.path = reference3 = path;
                this.queryParams = reference2 = queryParams;
                this.repository = reference = repository;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())) != false ? IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.path.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get()))) : IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getTags", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.repository.get()), IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, IndyInterface.bootstrap("getProperty", "tokenService", 12, this)), IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get())));
            }

            @Generated
            public String getPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.path.get());
            }

            @Generated
            public Map getQueryParams() {
                return IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get());
            }

            @Generated
            public String getRepository() {
                return IndyInterface.bootstrap("cast", "()", 0, this.repository.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTags_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getTags_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference path;
            private /* synthetic */ Reference queryParams;
            private /* synthetic */ Reference repository;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTags_closure19(Object _outerInstance, Object _thisObject, Reference path, Reference queryParams, Reference repository) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.path = reference3 = path;
                this.queryParams = reference2 = queryParams;
                this.repository = reference = repository;
            }

            public Object doCall(Object token) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())) != false ? IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.path.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get()))) : IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "getTags", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.repository.get()), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get())));
            }

            @Generated
            public String getPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.path.get());
            }

            @Generated
            public Map getQueryParams() {
                return IndyInterface.bootstrap("cast", "()", 0, this.queryParams.get());
            }

            @Generated
            public String getRepository() {
                return IndyInterface.bootstrap("cast", "()", 0, this.repository.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTags_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite response = IndyInterface.bootstrap("invoke", "request", 2, this, new _getTags_closure18(this, this, path2, queryParams2, repository2), new _getTags_closure19(this, this, path2, queryParams2, repository2), (String)repository2.get());
        CallSite nextPath = IndyInterface.bootstrap("invoke", "findNextLink", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "headers", 1, response));
        CallSite tags = IndyInterface.bootstrap("invoke", "convertResponseBody", 0, DockerRegistryClient.class, IndyInterface.bootstrap("invoke", "body", 0, response), DockerRegistryTags.class);
        if (IndyInterface.bootstrap("cast", "()", 0, nextPath) != false) {
            CallSite nextPathNew = null;
            CallSite callSite = IndyInterface.bootstrap("invoke", "parseForQueryParams", 0, DockerRegistryClient.class, nextPath);
            nextPathNew = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(0));
            queryParams2.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(1))));
            CallSite nextTags = IndyInterface.bootstrap("invoke", "getTags", 2, this, (String)repository2.get(), nextPathNew, (Map)queryParams2.get());
            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "tags", 0, tags), IndyInterface.bootstrap("getProperty", "tags", 0, nextTags));
        }
        return IndyInterface.bootstrap("cast", "()", 0, tags);
    }

    public static Tuple2<String, Map<String, String>> parseForQueryParams(String nextPath) {
        Object nextPathNew = null;
        CallSite queryParamsString = null;
        Object queryParams = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, nextPath, "?")) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "split", 0, nextPath, "\\?", 2);
            nextPathNew = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(0));
            queryParamsString = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(1));
        } else {
            nextPathNew = nextPath;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, queryParamsString) != false) {
            public final class _parseForQueryParams_closure20
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _parseForQueryParams_closure20(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object param) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "split", 0, param, "=");
                    CallSite key = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(0));
                    CallSite value = IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(1));
                    return ScriptBytecodeAdapter.createList((Object[])new Object[]{key, value});
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parseForQueryParams_closure20.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            queryParams = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "split", 0, queryParamsString, "&"), new _parseForQueryParams_closure20(DockerRegistryClient.class, DockerRegistryClient.class)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{nextPathNew, queryParams}));
    }

    /*
     * Unable to fully structure code
     */
    public void checkV2Availability() {
        try {
            IndyInterface.bootstrap("invoke", "doCheckV2Availability", 2, this);
        }
        catch (SpinnakerServerException error) {
            if (!((IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, this.tokenService)) == false != false && error instanceof SpinnakerHttpException != false) != false && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResponseCode", 0, IndyInterface.bootstrap("cast", "()", 0, error)), (Object)401) != false)) ** GOTO lbl12
            return;
lbl12:
            // 1 sources

            response = IndyInterface.bootstrap("invoke", "doCheckV2Availability", 2, this, IndyInterface.bootstrap("getProperty", "basicAuthHeader", 4, this.tokenService));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "body", 0, response)) == false) {
                IndyInterface.bootstrap("invoke", "error", 0, DockerRegistryClient.LOG, "checkV2Availability", error);
                throw (Throwable)error;
            }
        }
    }

    private Response<ResponseBody> doCheckV2Availability(String basicAuthHeader) {
        Reference basicAuthHeader2 = new Reference((Object)basicAuthHeader);
        public final class _doCheckV2Availability_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference basicAuthHeader;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doCheckV2Availability_closure21(Object _outerInstance, Object _thisObject, Reference basicAuthHeader) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.basicAuthHeader = reference = basicAuthHeader;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "checkVersion", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.basicAuthHeader.get()), IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            @Generated
            public String getBasicAuthHeader() {
                return IndyInterface.bootstrap("cast", "()", 0, this.basicAuthHeader.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doCheckV2Availability_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _doCheckV2Availability_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doCheckV2Availability_closure22(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object token) {
                return IndyInterface.bootstrap("invoke", "executeCall", 0, Retrofit2SyncCall.class, IndyInterface.bootstrap("invoke", "checkVersion", 0, IndyInterface.bootstrap("getProperty", "registryService", 12, this), token, IndyInterface.bootstrap("getProperty", "userAgent", 12, this)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doCheckV2Availability_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "request", 2, this, new _doCheckV2Availability_closure21(this, this, basicAuthHeader2), new _doCheckV2Availability_closure22(this, this), "v2 version check"));
    }

    /*
     * Exception decompiling
     */
    public Response<ResponseBody> request(Closure<Response<ResponseBody>> withoutToken, Closure<Response<ResponseBody>> withToken, String target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerRegistryClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerRegistryClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerRegistryClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    public DockerRegistryCatalog getCatalog(String path) {
        Reference path2 = new Reference((Object)path);
        return this.getCatalog((String)path2.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public DockerRegistryCatalog getCatalog() {
        return this.getCatalog(null, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    public DockerRegistryTags getTags(String repository, String path) {
        void var2_2;
        Reference repository2 = new Reference((Object)repository);
        Reference path2 = new Reference((Object)var2_2);
        return this.getTags((String)repository2.get(), (String)path2.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public DockerRegistryTags getTags(String repository) {
        Reference repository2 = new Reference((Object)repository);
        return this.getTags((String)repository2.get(), null, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    private Response<ResponseBody> doCheckV2Availability() {
        return this.doCheckV2Availability(null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, DockerRegistryClient.class);
        LOG = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getUserAgent", 0, DockerUserAgent.class);
        userAgent = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryClient");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Generated
    public DockerBearerTokenService getTokenService() {
        return this.tokenService;
    }

    @Generated
    public void setTokenService(DockerBearerTokenService dockerBearerTokenService) {
        this.tokenService = dockerBearerTokenService;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public void setAddress(String string) {
        this.address = string;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public void setEmail(String string) {
        this.email = string;
    }

    @Generated
    public DockerRegistryService getRegistryService() {
        return this.registryService;
    }

    @Generated
    public void setRegistryService(DockerRegistryService dockerRegistryService) {
        this.registryService = dockerRegistryService;
    }

    @Generated
    public String getCatalogFile() {
        return this.catalogFile;
    }

    @Generated
    public void setCatalogFile(String string) {
        this.catalogFile = string;
    }

    @Generated
    public String getRepositoriesRegex() {
        return this.repositoriesRegex;
    }

    @Generated
    public void setRepositoriesRegex(String string) {
        this.repositoriesRegex = string;
    }

    @Generated
    public static String getUserAgent() {
        return userAgent;
    }

    @Generated
    public final int getPaginateSize() {
        return this.paginateSize;
    }

    @Generated
    public static void setObjectMapper(ObjectMapper objectMapper) {
        DockerRegistryClient.objectMapper = objectMapper;
    }

    public interface DockerRegistryService {
        @GET(value="/v2/{repository}/tags/list")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> getTags(@Path(value="repository", encoded=true) String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3, @QueryMap(encoded=true) Map<String, String> var4);

        @GET(value="/v2/{name}/manifests/{reference}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> getManifest(@Path(value="name", encoded=true) String var1, @Path(value="reference", encoded=true) String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/v2/{name}/manifests/{reference}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0", "Accept: application/vnd.docker.distribution.manifest.v2+json"})
        public Call<ResponseBody> getSchemaV2Manifest(@Path(value="name", encoded=true) String var1, @Path(value="reference", encoded=true) String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/v2/_catalog")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> getCatalog(@Header(value="Authorization") String var1, @Header(value="User-Agent") String var2, @QueryMap(encoded=true) Map<String, String> var3);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> get(@Path(value="path", encoded=true) String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3, @QueryMap(encoded=true) Map<String, String> var4);

        @GET(value="/v2/")
        @Headers(value={"User-Agent: Spinnaker-Clouddriver", "Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> checkVersion(@Header(value="Authorization") String var1, @Header(value="User-Agent") String var2);

        @GET(value="/v2/{repository}/blobs/{digest}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Call<ResponseBody> getDigestContent(@Path(value="repository", encoded=true) String var1, @Path(value="digest", encoded=true) String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);
    }

    public static class Builder
    implements GroovyObject {
        private String address;
        private String email;
        private String username;
        private String password;
        private String passwordCommand;
        private File passwordFile;
        private File dockerconfigFile;
        private long clientTimeoutMillis;
        private int paginateSize;
        private String catalogFile;
        private String repositoriesRegex;
        private boolean insecureRegistry;
        private DockerOkClientProvider okClientProvider;
        private ServiceClientProvider serviceClientProvider;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Builder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder address(String address) {
            String string;
            this.address = string = address;
            return this;
        }

        public Builder email(String email) {
            String string;
            this.email = string = email;
            return this;
        }

        public Builder username(String username) {
            String string;
            this.username = string = username;
            return this;
        }

        public Builder password(String password) {
            String string;
            this.password = string = password;
            return this;
        }

        public Builder passwordCommand(String passwordCommand) {
            String string;
            this.passwordCommand = string = passwordCommand;
            return this;
        }

        public Builder passwordFile(File passwordFile) {
            File file;
            this.passwordFile = file = passwordFile;
            return this;
        }

        public Builder dockerconfigFile(File dockerconfigFile) {
            File file;
            this.dockerconfigFile = file = dockerconfigFile;
            return this;
        }

        public Builder clientTimeoutMillis(long clientTimeoutMillis) {
            long l = clientTimeoutMillis;
            this.clientTimeoutMillis = l;
            return this;
        }

        public Builder paginateSize(int paginateSize) {
            int n;
            this.paginateSize = n = paginateSize;
            return this;
        }

        public Builder catalogFile(String catalogFile) {
            String string;
            this.catalogFile = string = catalogFile;
            return this;
        }

        public Builder repositoriesRegex(String regex) {
            String string;
            this.repositoriesRegex = string = regex;
            return this;
        }

        public Builder insecureRegistry(boolean insecureRegistry) {
            boolean bl;
            this.insecureRegistry = bl = insecureRegistry;
            return this;
        }

        public Builder okClientProvider(DockerOkClientProvider okClientProvider) {
            DockerOkClientProvider dockerOkClientProvider;
            this.okClientProvider = dockerOkClientProvider = okClientProvider;
            return this;
        }

        public Builder serviceClientProvider(ServiceClientProvider serviceClientProvider) {
            ServiceClientProvider serviceClientProvider2;
            this.serviceClientProvider = serviceClientProvider2 = serviceClientProvider;
            return this;
        }

        public DockerRegistryClient build() {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) || DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "Error, at most one of \"password\", \"passwordFile\", \"passwordCommand\" or \"dockerconfigFile\" can be specified"));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryClient.class, this.address, this.email, this.username, this.password, this.passwordCommand, this.clientTimeoutMillis, this.paginateSize, this.catalogFile, this.repositoriesRegex, this.insecureRegistry, this.okClientProvider, this.serviceClientProvider));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, this.passwordFile) != false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryClient.class, this.address, this.email, this.username, this.passwordFile, this.clientTimeoutMillis, this.paginateSize, this.catalogFile, this.repositoriesRegex, this.insecureRegistry, this.okClientProvider, this.serviceClientProvider));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DockerRegistryClient.class, this.address, this.clientTimeoutMillis, this.paginateSize, this.catalogFile, this.repositoriesRegex, this.insecureRegistry, this.okClientProvider, this.serviceClientProvider));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public void setAddress(String string) {
            this.address = string;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setEmail(String string) {
            this.email = string;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public void setUsername(String string) {
            this.username = string;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String string) {
            this.password = string;
        }

        @Generated
        public String getPasswordCommand() {
            return this.passwordCommand;
        }

        @Generated
        public void setPasswordCommand(String string) {
            this.passwordCommand = string;
        }

        @Generated
        public File getPasswordFile() {
            return this.passwordFile;
        }

        @Generated
        public void setPasswordFile(File file) {
            this.passwordFile = file;
        }

        @Generated
        public File getDockerconfigFile() {
            return this.dockerconfigFile;
        }

        @Generated
        public void setDockerconfigFile(File file) {
            this.dockerconfigFile = file;
        }

        @Generated
        public long getClientTimeoutMillis() {
            return this.clientTimeoutMillis;
        }

        @Generated
        public void setClientTimeoutMillis(long l) {
            this.clientTimeoutMillis = l;
        }

        @Generated
        public int getPaginateSize() {
            return this.paginateSize;
        }

        @Generated
        public void setPaginateSize(int n) {
            this.paginateSize = n;
        }

        @Generated
        public String getCatalogFile() {
            return this.catalogFile;
        }

        @Generated
        public void setCatalogFile(String string) {
            this.catalogFile = string;
        }

        @Generated
        public String getRepositoriesRegex() {
            return this.repositoriesRegex;
        }

        @Generated
        public void setRepositoriesRegex(String string) {
            this.repositoriesRegex = string;
        }

        @Generated
        public boolean getInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public boolean isInsecureRegistry() {
            return this.insecureRegistry;
        }

        @Generated
        public void setInsecureRegistry(boolean bl) {
            this.insecureRegistry = bl;
        }

        @Generated
        public DockerOkClientProvider getOkClientProvider() {
            return this.okClientProvider;
        }

        @Generated
        public void setOkClientProvider(DockerOkClientProvider dockerOkClientProvider) {
            this.okClientProvider = dockerOkClientProvider;
        }

        @Generated
        public ServiceClientProvider getServiceClientProvider() {
            return this.serviceClientProvider;
        }

        @Generated
        public void setServiceClientProvider(ServiceClientProvider serviceClientProvider) {
            this.serviceClientProvider = serviceClientProvider;
        }
    }
}

