/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerOkClientProvider;
import com.netflix.spinnaker.clouddriver.docker.registry.config.DockerRegistryConfigurationProperties;
import com.netflix.spinnaker.clouddriver.docker.registry.health.DockerRegistryHealthIndicator;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryCredentialsInitializer;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.poller.Poller;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableConfigurationProperties
@EnableScheduling
@ConditionalOnProperty(value={"docker-registry.enabled"})
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.docker.registry"})
@Import(value={DockerRegistryCredentialsInitializer.class})
public class DockerRegistryConfiguration {
    @Bean
    @RefreshScope
    @ConfigurationProperties(value="docker-registry")
    public DockerRegistryConfigurationProperties dockerRegistryConfigurationProperties() {
        return new DockerRegistryConfigurationProperties();
    }

    @Bean
    public DockerRegistryHealthIndicator dockerRegistryHealthIndicator(Registry registry, CredentialsRepository<DockerRegistryNamedAccountCredentials> credentialsRepository) {
        return new DockerRegistryHealthIndicator(registry, credentialsRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={DockerRegistryNamedAccountCredentials.class}, parameterizedContainer={AbstractCredentialsLoader.class})
    public AbstractCredentialsLoader<DockerRegistryNamedAccountCredentials> dockerRegistryCredentialsLoader(@Nullable CredentialsDefinitionSource<DockerRegistryConfigurationProperties.ManagedAccount> dockerRegistryCredentialsSource, DockerRegistryConfigurationProperties accountProperties, DockerOkClientProvider dockerOkClientProvider, CredentialsRepository<DockerRegistryNamedAccountCredentials> dockerRegistryCredentialsRepository, ServiceClientProvider serviceClientProvider) {
        if (dockerRegistryCredentialsSource == null) {
            dockerRegistryCredentialsSource = accountProperties::getAccounts;
        }
        return new BasicCredentialsLoader(dockerRegistryCredentialsSource, a -> new DockerRegistryNamedAccountCredentials.Builder().accountName(a.getName()).environment(a.getEnvironment() != null ? a.getEnvironment() : a.getName()).accountType(a.getAccountType() != null ? a.getAccountType() : a.getName()).address(a.getAddress()).password(a.getPassword()).passwordCommand(a.getPasswordCommand()).username(a.getUsername()).email(a.getEmail()).passwordFile(a.getPasswordFile()).catalogFile(a.getCatalogFile()).repositoriesRegex(a.getRepositoriesRegex()).dockerconfigFile(a.getDockerconfigFile()).cacheThreads(a.getCacheThreads()).cacheIntervalSeconds(a.getCacheIntervalSeconds()).clientTimeoutMillis(a.getClientTimeoutMillis()).paginateSize(a.getPaginateSize()).trackDigests(a.getTrackDigests()).inspectDigests(a.getInspectDigests()).sortTagsByDate(a.getSortTagsByDate()).insecureRegistry(a.getInsecureRegistry()).repositories(a.getRepositories()).skip(a.getSkip()).permissions(a.getPermissions().build()).dockerOkClientProvider(dockerOkClientProvider).serviceClientProvider(serviceClientProvider).build(), dockerRegistryCredentialsRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={DockerRegistryNamedAccountCredentials.class}, parameterizedContainer={CredentialsRepository.class})
    public CredentialsRepository<DockerRegistryNamedAccountCredentials> dockerRegistryCredentialsRepository(CredentialsLifecycleHandler<DockerRegistryNamedAccountCredentials> eventHandler) {
        return new MapBackedCredentialsRepository("dockerRegistry", eventHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={DockerRegistryConfigurationProperties.ManagedAccount.class}, parameterizedContainer={CredentialsDefinitionSource.class})
    public CredentialsInitializerSynchronizable dockerRegistryCredentialsInitializerSynchronizable(AbstractCredentialsLoader<DockerRegistryNamedAccountCredentials> loader) {
        final Poller poller = new Poller(loader);
        return new CredentialsInitializerSynchronizable(){

            public void synchronize() {
                poller.run();
            }
        };
    }
}

