/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.event.persistence;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.event.Aggregate;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.event.SpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.config.MemoryEventRepositoryConfigProperties;
import com.netflix.spinnaker.clouddriver.event.exceptions.AggregateChangeRejectedException;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.event.persistence.InMemoryEventRepository;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001c\u001a\u00020\u001dH\u0003J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001dH\u0003J.\u0010)\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/netflix/spinnaker/clouddriver/event/persistence/InMemoryEventRepository;", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "config", "Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties;Lorg/springframework/context/ApplicationEventPublisher;Lcom/netflix/spectator/api/Registry;)V", "aggregateCountId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "aggregateReadCountId", "aggregateWriteCountId", "eventCountId", "eventReadCountId", "eventWriteCountId", "events", "", "Lcom/netflix/spinnaker/clouddriver/event/Aggregate;", "", "Lcom/netflix/spinnaker/clouddriver/event/SpinnakerEvent;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "cleanup", "", "getAggregate", "aggregateType", "", "aggregateId", "list", "", "listAggregates", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository$ListAggregatesResult;", "criteria", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository$ListAggregatesCriteria;", "recordMetrics", "save", "originatingVersion", "", "newEvents", "MissingAggregateEventsException", "clouddriver-event"})
public final class InMemoryEventRepository
implements EventRepository {
    private final Lazy log$delegate;
    private final Id aggregateCountId;
    private final Id aggregateWriteCountId;
    private final Id aggregateReadCountId;
    private final Id eventCountId;
    private final Id eventWriteCountId;
    private final Id eventReadCountId;
    private final Map<Aggregate, List<SpinnakerEvent>> events;
    private final MemoryEventRepositoryConfigProperties config;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Registry registry;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        InMemoryEventRepository inMemoryEventRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull String aggregateType, @NotNull String aggregateId, long originatingVersion, @NotNull List<? extends SpinnakerEvent> newEvents) {
        SpinnakerEvent it;
        void $this$mapTo$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(newEvents, (String)"newEvents");
        this.registry.counter(this.aggregateWriteCountId).increment();
        Aggregate aggregate = this.getAggregate(aggregateType, aggregateId);
        if (aggregate.getVersion() != originatingVersion) {
            throw (Throwable)((Object)new AggregateChangeRejectedException(aggregate.getVersion(), originatingVersion));
        }
        Object $this$getOrPut$iv = this.events;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(aggregate);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(aggregate, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        $this$getOrPut$iv = list;
        $i$f$getOrPut = false;
        boolean bl = false;
        List aggregateEvents = (List)$this$getOrPut$iv;
        boolean bl3 = false;
        Iterable $this$map$iv = aggregateEvents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SpinnakerEvent spinnakerEvent = (SpinnakerEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            Long l = it.getMetadata().getSequence();
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        long currentSequence = l != null ? l : 0L;
        Iterable $this$forEachIndexed$iv = newEvents;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void newEvent;
            int n = index$iv++;
            boolean bl5 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (SpinnakerEvent)item$iv;
            int index = n;
            boolean bl6 = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
            newEvent.setMetadata(new EventMetadata(string, aggregateType, aggregateId, currentSequence + (long)(index + 1), originatingVersion, null, null, null, 224, null));
        }
        this.registry.counter(this.eventWriteCountId).increment((long)newEvents.size());
        aggregateEvents.addAll((Collection)newEvents);
        aggregate.setVersion(aggregate.getVersion() + 1L);
        this.getLog().debug("Saved " + aggregateType + '/' + aggregateId + '@' + aggregate.getVersion() + ": " + '[' + CollectionsKt.joinToString$default((Iterable)newEvents, (CharSequence)",", null, null, (int)0, null, (Function1)save.3.INSTANCE, (int)30, null) + ']');
        Iterable $this$forEach$iv = newEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpinnakerEvent it2 = (SpinnakerEvent)element$iv;
            boolean bl7 = false;
            this.applicationEventPublisher.publishEvent((Object)it2);
        }
    }

    @Override
    @NotNull
    public List<SpinnakerEvent> list(@NotNull String aggregateType, @NotNull String aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        this.registry.counter(this.eventReadCountId).increment();
        Aggregate aggregate = this.getAggregate(aggregateType, aggregateId);
        boolean bl = false;
        boolean bl2 = false;
        Aggregate it = aggregate;
        boolean bl3 = false;
        List<SpinnakerEvent> list = this.events.get(it);
        List list2 = list != null ? CollectionsKt.toList((Iterable)list) : null;
        if (list2 == null) {
            throw (Throwable)((Object)new MissingAggregateEventsException(aggregateType, aggregateId));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventRepository.ListAggregatesResult listAggregates(@NotNull EventRepository.ListAggregatesCriteria criteria) {
        String string;
        List result;
        Object object;
        Object list;
        boolean bl;
        boolean bl2;
        Object object2;
        block11: {
            block10: {
                Object v3;
                boolean bl3;
                int n;
                List list2;
                block9: {
                    List list3;
                    Aggregate it;
                    Iterable $this$filter$iv;
                    boolean bl4;
                    boolean bl5;
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
                    Set<Aggregate> aggregates = this.events.keySet();
                    object2 = CollectionsKt.toList((Iterable)aggregates);
                    bl2 = false;
                    bl = false;
                    list = object2;
                    boolean bl6 = false;
                    String string3 = criteria.getAggregateType();
                    if (string3 != null) {
                        void $this$filterTo$iv$iv;
                        string2 = string3;
                        bl5 = false;
                        bl4 = false;
                        String requiredType = string2;
                        boolean bl7 = false;
                        $this$filter$iv = (Iterable)list;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Aggregate)element$iv$iv;
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)requiredType)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list3 = (List)destination$iv$iv;
                    } else {
                        list3 = list;
                    }
                    object2 = list3;
                    bl2 = false;
                    bl = false;
                    list = object2;
                    boolean bl9 = false;
                    object = criteria.getToken();
                    if (object == null) break block10;
                    string2 = object;
                    bl5 = false;
                    bl4 = false;
                    String nextPageToken = string2;
                    boolean bl10 = false;
                    $this$filter$iv = (Iterable)list;
                    list2 = list;
                    n = 0;
                    Iterable iterable = $this$filter$iv;
                    bl3 = false;
                    for (Object element$iv$iv : iterable) {
                        it = (Aggregate)element$iv$iv;
                        boolean bl11 = false;
                        if (!Intrinsics.areEqual((Object)(it.getType() + '/' + it.getId()), (Object)nextPageToken)) continue;
                        v3 = element$iv$iv;
                        break block9;
                    }
                    v3 = null;
                }
                Object var23_28 = v3;
                int start = CollectionsKt.indexOf((List)list2, var23_28);
                n = start + criteria.getPerPage();
                boolean bl12 = false;
                bl3 = false;
                int it = n;
                boolean bl13 = false;
                int end = it > list.size() - 1 ? list.size() : criteria.getPerPage();
                List list4 = list.subList(start, end);
                object = list4;
                if (list4 != null) break block11;
            }
            object = list;
        }
        List list5 = result = object;
        Aggregate aggregate = (Aggregate)CollectionsKt.lastOrNull((List)result);
        if (aggregate != null) {
            void it;
            object2 = aggregate;
            bl2 = false;
            bl = false;
            list = object2;
            List list6 = list5;
            boolean bl14 = false;
            String string4 = it.getType() + '/' + it.getId();
            list5 = list6;
            string = string4;
        } else {
            string = null;
        }
        String string5 = string;
        List list7 = list5;
        return new EventRepository.ListAggregatesResult(list7, string5);
    }

    private final Aggregate getAggregate(String aggregateType, String aggregateId) {
        Object element$iv2;
        block1: {
            this.registry.counter(this.aggregateReadCountId).increment();
            Aggregate aggregate = new Aggregate(aggregateType, aggregateId, 0L);
            boolean bl = false;
            this.events.putIfAbsent(aggregate, new ArrayList());
            Iterable $this$first$iv = this.events.keySet();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Aggregate it = (Aggregate)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)aggregate)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Aggregate)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedDelayString="${spinnaker.clouddriver.eventing.memory-repository.cleanup-job-delay-ms:60000}")
    private final void cleanup() {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        Number number;
        this.registry.counter(this.eventReadCountId).increment();
        Comparable<Long> comparable = this.config.getMaxAggregateAgeMs();
        if (comparable != null) {
            number = comparable;
            bl2 = false;
            bl = false;
            long it = ((Number)number).longValue();
            boolean bl3 = false;
            comparable = Duration.ofMillis(it);
            if (comparable != null) {
                Iterator $this$mapTo$iv$iv;
                Map.Entry it2;
                Iterable $this$filterTo$iv$iv;
                number = comparable;
                bl2 = false;
                bl = false;
                Number maxAge = number;
                boolean bl4 = false;
                Instant horizon = Instant.now().minus((TemporalAmount)((Object)maxAge));
                this.getLog().info("Cleaning up aggregates last updated earlier than " + maxAge + " (" + horizon + ')');
                Iterable $this$filter$iv = this.events.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl5;
                    block12: {
                        it2 = (Map.Entry)element$iv$iv;
                        boolean bl6 = false;
                        Iterable $this$any$iv = (Iterable)it2.getValue();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                SpinnakerEvent event = (SpinnakerEvent)element$iv;
                                boolean bl7 = false;
                                if (!event.getMetadata().getTimestamp().isBefore(horizon)) continue;
                                bl5 = true;
                                break block12;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv = iterator.next();
                    it2 = (Map.Entry)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl8 = false;
                    object = (Aggregate)it2.getKey();
                    object2.add(object);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Aggregate it3 = (Aggregate)element$iv;
                    boolean bl9 = false;
                    this.getLog().trace("Cleaning up " + it3);
                    this.events.remove(it3);
                }
            }
        }
        Integer n = this.config.getMaxAggregatesCount();
        if (n != null) {
            void $this$flatMapTo$iv$iv;
            number = n;
            bl2 = false;
            bl = false;
            int maxCount = ((Number)number).intValue();
            boolean bl10 = false;
            this.getLog().info("Cleaning up aggregates to max " + maxCount + " items, pruning by earliest updated");
            Iterable $this$flatMap$iv = this.events.entrySet();
            boolean $i$f$flatMap = false;
            Iterable $i$f$forEach = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl11 = false;
                Iterable $this$map$iv = (Iterable)entry.getValue();
                boolean $i$f$map = false;
                Iterable $i$f$any = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object2 = (SpinnakerEvent)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl12 = false;
                    Pair pair = new Pair(entry.getKey(), (Object)it);
                    object.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$sortedBy$iv22 = (List)destination$iv$iv;
            int $i$f$sortedBy = 0;
            boolean bl13 = false;
            int $this$sortedBy$iv22 = this.events.size() - maxCount;
            $i$f$sortedBy = 0;
            bl13 = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv22, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Pair it = (Pair)a;
                    boolean bl2 = false;
                    Comparable comparable = ((SpinnakerEvent)it.getSecond()).getMetadata().getTimestamp();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Instant instant = ((SpinnakerEvent)it.getSecond()).getMetadata().getTimestamp();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
                }
            }).subList(0, Math.max($this$sortedBy$iv22, $i$f$sortedBy));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl14 = false;
                this.getLog().trace("Cleaning up " + (Aggregate)it.getFirst());
                this.events.remove(it.getFirst());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedRate=1000L)
    private final void recordMetrics() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        this.registry.gauge(this.aggregateCountId).set((double)this.events.size());
        Map<Aggregate, List<SpinnakerEvent>> map = this.events;
        Gauge gauge = this.registry.gauge(this.eventCountId);
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_7 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gauge.set((double)list.size());
    }

    public InMemoryEventRepository(@NotNull MemoryEventRepositoryConfigProperties config, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.config = config;
        this.applicationEventPublisher = applicationEventPublisher;
        this.registry = registry;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ InMemoryEventRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = inMemoryEventRepository;
                super(0);
            }
        }));
        this.aggregateCountId = this.registry.createId("eventing.aggregates");
        this.aggregateWriteCountId = this.registry.createId("eventing.aggregates.writes");
        this.aggregateReadCountId = this.registry.createId("eventing.aggregates.reads");
        this.eventCountId = this.registry.createId("eventing.events");
        this.eventWriteCountId = this.registry.createId("eventing.events.writes");
        this.eventReadCountId = this.registry.createId("eventing.events.reads");
        this.events = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/clouddriver/event/persistence/InMemoryEventRepository$MissingAggregateEventsException;", "Lcom/netflix/spinnaker/kork/exceptions/SystemException;", "aggregateType", "", "aggregateId", "(Lcom/netflix/spinnaker/clouddriver/event/persistence/InMemoryEventRepository;Ljava/lang/String;Ljava/lang/String;)V", "clouddriver-event"})
    public final class MissingAggregateEventsException
    extends SystemException {
        public MissingAggregateEventsException(@NotNull String aggregateType, String aggregateId) {
            Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            super("Aggregate " + aggregateType + '/' + aggregateId + " is missing its internal events list store");
        }
    }
}

