/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.event.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.event.config.MemoryEventRepositoryConfigProperties;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.event.persistence.InMemoryEventRepository;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MemoryEventRepositoryConfigProperties.class})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfig;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "eventRepository", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "properties", "Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "registry", "Lcom/netflix/spectator/api/Registry;", "clouddriver-event"})
public class MemoryEventRepositoryConfig {
    private final Lazy log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
        final /* synthetic */ MemoryEventRepositoryConfig this$0;

        public final Logger invoke() {
            return LoggerFactory.getLogger(this.this$0.getClass());
        }
        {
            this.this$0 = memoryEventRepositoryConfig;
            super(0);
        }
    }));

    private Logger getLog() {
        Lazy lazy = this.log$delegate;
        MemoryEventRepositoryConfig memoryEventRepositoryConfig = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @Bean
    @ConditionalOnMissingBean(value={EventRepository.class})
    @NotNull
    public EventRepository eventRepository(@NotNull MemoryEventRepositoryConfigProperties properties, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new InMemoryEventRepository(properties, applicationEventPublisher, registry);
    }

    public MemoryEventRepositoryConfig() {
        this.getLog().info("Configuring EventRepository: InMemoryEventRepository");
    }
}

