/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.event.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Min;
import kotlin.Metadata;
import kotlin.annotation.AnnotationTarget;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@SpinValidated
@ConfigurationProperties(value="spinnaker.clouddriver.eventing.memory-repository")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties;", "", "()V", "maxAggregateAgeMs", "", "getMaxAggregateAgeMs", "()Ljava/lang/Long;", "setMaxAggregateAgeMs", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "maxAggregatesCount", "", "getMaxAggregatesCount", "()Ljava/lang/Integer;", "setMaxAggregatesCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "SpinValidated", "Validator", "clouddriver-event"})
public class MemoryEventRepositoryConfigProperties {
    @Min(value=86400000L, message="Event repository aggregate age cannot be less than 24 hours.")
    @Nullable
    private Long maxAggregateAgeMs = Duration.ofHours(24L).toMillis();
    @Nullable
    private Integer maxAggregatesCount;

    @Nullable
    public Long getMaxAggregateAgeMs() {
        return this.maxAggregateAgeMs;
    }

    public void setMaxAggregateAgeMs(@Nullable Long l) {
        this.maxAggregateAgeMs = l;
    }

    @Nullable
    public Integer getMaxAggregatesCount() {
        return this.maxAggregatesCount;
    }

    public void setMaxAggregatesCount(@Nullable Integer n) {
        this.maxAggregatesCount = n;
    }

    @Validated
    @Constraint(validatedBy={Validator.class})
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.CLASS})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0097\u0002\u0018\u00002\u00020\u0001B:\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005R \u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\tR\u0012\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\nR \u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties$SpinValidated;", "", "message", "", "groups", "", "Lkotlin/reflect/KClass;", "", "payload", "()[Ljava/lang/Class;", "()Ljava/lang/String;", "clouddriver-event"})
    public static @interface SpinValidated {
        public String message() default "Invalid event repository configuration";

        public Class<? extends Object>[] groups() default {};

        public Class<? extends Object>[] payload() default {};
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties$Validator;", "Ljavax/validation/ConstraintValidator;", "Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties$SpinValidated;", "Lcom/netflix/spinnaker/clouddriver/event/config/MemoryEventRepositoryConfigProperties;", "()V", "isValid", "", "value", "context", "Ljavax/validation/ConstraintValidatorContext;", "clouddriver-event"})
    public static final class Validator
    implements ConstraintValidator<SpinValidated, MemoryEventRepositoryConfigProperties> {
        public boolean isValid(@NotNull MemoryEventRepositoryConfigProperties value, @NotNull ConstraintValidatorContext context) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (value.getMaxAggregateAgeMs() != null && value.getMaxAggregatesCount() != null) {
                context.buildConstraintViolationWithTemplate("Only one of 'maxAggregateAgeMs' and 'maxAggregatesCount' can be defined").addConstraintViolation();
                return false;
            }
            if (value.getMaxAggregateAgeMs() == null && value.getMaxAggregatesCount() == null) {
                context.buildConstraintViolationWithTemplate("One of 'maxAggregateAgeMs' and 'maxAggregatesCount' must be set").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

