/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.googlecommon.deploy;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleApiException;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonnullByDefault
public final class GoogleCommonSafeRetry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleCommonSafeRetry.class);
    private final long maxWaitInterval;
    private final long retryIntervalBase;
    private final long jitterMultiplier;
    private final long maxRetries;

    @ParametersAreNullableByDefault
    public GoogleCommonSafeRetry(Integer maxWaitInterval, Integer retryIntervalBase, Integer jitterMultiplier, Integer maxRetries) {
        this.maxWaitInterval = Optional.ofNullable(maxWaitInterval).orElse(60000).intValue();
        this.retryIntervalBase = Optional.ofNullable(retryIntervalBase).orElse(2).intValue();
        this.jitterMultiplier = Optional.ofNullable(jitterMultiplier).orElse(1000).intValue();
        this.maxRetries = Optional.ofNullable(maxRetries).orElse(10).intValue();
    }

    public static GoogleCommonSafeRetry withoutDelay() {
        return GoogleCommonSafeRetry.builder().retryIntervalBase(0).jitterMultiplier(0).build();
    }

    @Nullable
    public <V> V doRetry(Callable<V> operation, String description, List<Integer> retryCodes, List<Integer> successCodes, Map<String, String> tags, Registry registry) throws GoogleApiException {
        boolean success = false;
        long startTime = registry.clock().monotonicTime();
        try {
            V result = this.performOperation(operation, description, retryCodes, successCodes);
            success = true;
            V v = result;
            return v;
        }
        catch (GoogleJsonResponseException e) {
            throw GoogleApiException.fromGoogleJsonException(e);
        }
        catch (SocketTimeoutException e) {
            throw new GoogleApiException("Operation failed. Last attempt timed out.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GoogleApiException("Operation failed. Thread was interrupted waiting to retry.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Operation failed.", e);
        }
        finally {
            ImmutableMap metricTags = ImmutableMap.builder().putAll(tags).put((Object)"success", (Object)Boolean.toString(success)).build();
            registry.timer(registry.createId("google.safeRetry", (Map)metricTags)).record(registry.clock().monotonicTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Nullable
    private <V> V performOperation(Callable<V> operation, String description, List<Integer> retryCodes, List<Integer> successfulErrorCodes) throws Exception {
        long maxAttempts = Math.max(1L, this.maxRetries);
        int tries = 1;
        while ((long)tries < maxAttempts) {
            try {
                return GoogleCommonSafeRetry.attemptOperation(operation, successfulErrorCodes);
            }
            catch (GoogleJsonResponseException jsonException) {
                if (!retryCodes.contains(jsonException.getStatusCode())) {
                    throw jsonException;
                }
                log.warn("{} attempt #{} encountered retryable statusCode={} with error message: {}.", new Object[]{description, tries, jsonException.getStatusCode(), jsonException.getMessage()});
            }
            catch (SocketTimeoutException toEx) {
                log.warn("Retryable {} attempt #{} timed out.", (Object)description, (Object)tries);
            }
            long thisIntervalWait = TimeUnit.SECONDS.toMillis((long)Math.pow(this.retryIntervalBase, ++tries - 1));
            long sleepMillis = Math.min(thisIntervalWait, this.maxWaitInterval) + Math.round(Math.random() * (double)this.jitterMultiplier);
            log.warn("Waiting {} ms to retry {}.", (Object)sleepMillis, (Object)description);
            Thread.sleep(sleepMillis);
            log.warn("Retrying {} attempt #{}...", (Object)description, (Object)tries);
        }
        return GoogleCommonSafeRetry.attemptOperation(operation, successfulErrorCodes);
    }

    @Nullable
    private static <V> V attemptOperation(Callable<V> operation, List<Integer> successCodes) throws Exception {
        try {
            return operation.call();
        }
        catch (GoogleJsonResponseException e) {
            if (successCodes.contains(e.getStatusCode())) {
                return null;
            }
            throw e;
        }
    }

    @Generated
    public static GoogleCommonSafeRetryBuilder builder() {
        return new GoogleCommonSafeRetryBuilder();
    }

    @Generated
    public static class GoogleCommonSafeRetryBuilder {
        @Generated
        private Integer maxWaitInterval;
        @Generated
        private Integer retryIntervalBase;
        @Generated
        private Integer jitterMultiplier;
        @Generated
        private Integer maxRetries;

        @Generated
        GoogleCommonSafeRetryBuilder() {
        }

        @Generated
        public GoogleCommonSafeRetryBuilder maxWaitInterval(Integer maxWaitInterval) {
            this.maxWaitInterval = maxWaitInterval;
            return this;
        }

        @Generated
        public GoogleCommonSafeRetryBuilder retryIntervalBase(Integer retryIntervalBase) {
            this.retryIntervalBase = retryIntervalBase;
            return this;
        }

        @Generated
        public GoogleCommonSafeRetryBuilder jitterMultiplier(Integer jitterMultiplier) {
            this.jitterMultiplier = jitterMultiplier;
            return this;
        }

        @Generated
        public GoogleCommonSafeRetryBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleCommonSafeRetry build() {
            return new GoogleCommonSafeRetry(this.maxWaitInterval, this.retryIntervalBase, this.jitterMultiplier, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "GoogleCommonSafeRetry.GoogleCommonSafeRetryBuilder(maxWaitInterval=" + this.maxWaitInterval + ", retryIntervalBase=" + this.retryIntervalBase + ", jitterMultiplier=" + this.jitterMultiplier + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

