/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.googlecommon.deploy;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;

@NonnullByDefault
public class GoogleApiException
extends IOException {
    GoogleApiException(String message) {
        super(message);
    }

    static GoogleApiException fromGoogleJsonException(GoogleJsonResponseException e) {
        ErrorDetails errorDetails = ErrorDetails.fromGoogleJsonException(e);
        if (errorDetails.getStatusCode() == 404) {
            return new NotFoundException(errorDetails.toString());
        }
        if (errorDetails.getReason().equals("resourceInUseByAnotherResource")) {
            return new ResourceInUseException(errorDetails.toString());
        }
        return new GoogleApiException(errorDetails.toString());
    }

    public static final class NotFoundException
    extends GoogleApiException {
        NotFoundException(String message) {
            super(message);
        }
    }

    public static final class ResourceInUseException
    extends GoogleApiException {
        ResourceInUseException(String message) {
            super(message);
        }
    }

    private static final class ErrorDetails {
        private final int statusCode;
        private final String message;
        private final String reason;

        @ParametersAreNullableByDefault
        private ErrorDetails(int statusCode, String message, String reason) {
            this.statusCode = statusCode;
            this.message = Strings.nullToEmpty((String)message);
            this.reason = Strings.nullToEmpty((String)reason);
        }

        static ErrorDetails fromGoogleJsonException(GoogleJsonResponseException e) {
            Optional optionalErrorInfo = Optional.ofNullable(e.getDetails()).map(GoogleJsonError::getErrors).orElse((List)ImmutableList.of()).stream().findFirst();
            if (optionalErrorInfo.isPresent()) {
                GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)optionalErrorInfo.get();
                return new ErrorDetails(e.getStatusCode(), errorInfo.getMessage(), errorInfo.getReason());
            }
            return new ErrorDetails(e.getStatusCode(), e.getMessage(), "");
        }

        public String toString() {
            String base = String.format("Operation failed. Last attempt returned status code %s with error message %s", this.statusCode, this.message);
            if (Strings.isNullOrEmpty((String)this.reason)) {
                return String.format("%s.", base);
            }
            return String.format("%s and reason %s.", base, this.reason);
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorDetails)) {
                return false;
            }
            ErrorDetails other = (ErrorDetails)o;
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatusCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }
    }
}

