/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.model.Operation;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.util.Map;

final class GlobalGoogleComputeRequestFactory {
    private static final ImmutableMap<String, String> TAGS = ImmutableMap.of((Object)GoogleExecutor.getTAG_SCOPE(), (Object)GoogleExecutor.getSCOPE_GLOBAL());
    private final String serviceName;
    private final GoogleNamedAccountCredentials credentials;
    private final Registry registry;
    private final GoogleOperationPoller poller;

    GlobalGoogleComputeRequestFactory(String serviceName, GoogleNamedAccountCredentials credentials, GoogleOperationPoller poller, Registry registry) {
        this.serviceName = serviceName;
        this.credentials = credentials;
        this.registry = registry;
        this.poller = poller;
    }

    <RequestT extends ComputeRequest<ResponseT>, ResponseT> GoogleComputeRequest<RequestT, ResponseT> wrapRequest(RequestT request, String api) {
        return new GoogleComputeRequestImpl(request, this.registry, this.getMetricName(api), (Map<String, String>)TAGS);
    }

    <RequestT extends ComputeRequest<ResponseT>, ResponseT> GoogleComputeGetRequest<RequestT, ResponseT> wrapGetRequest(RequestT request, String api) {
        return new GoogleComputeGetRequestImpl(request, this.registry, this.getMetricName(api), (Map<String, String>)TAGS);
    }

    <RequestT extends ComputeRequest<Operation>> GoogleComputeOperationRequest<RequestT> wrapOperationRequest(RequestT request, String api) {
        return new GoogleComputeOperationRequestImpl<RequestT>(request, this.registry, this.getMetricName(api), (Map<String, String>)TAGS, new GlobalOperationWaiter());
    }

    private String getMetricName(String api) {
        return String.join((CharSequence)".", "compute", this.serviceName, api);
    }

    private final class GlobalOperationWaiter
    implements GoogleComputeOperationRequestImpl.OperationWaiter {
        private GlobalOperationWaiter() {
        }

        @Override
        public Operation wait(Operation operation, Task task, String phase) {
            return GlobalGoogleComputeRequestFactory.this.poller.waitForGlobalOperation(GlobalGoogleComputeRequestFactory.this.credentials.getCompute(), GlobalGoogleComputeRequestFactory.this.credentials.getProject(), operation.getName(), null, task, GCEUtil.getLocalName(operation.getTargetLink()), phase);
        }
    }
}

