/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerList;
import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.ZonalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.util.Optional;

public final class ZoneInstanceGroupManagers {
    private final Compute.InstanceGroupManagers computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final ZonalGoogleComputeRequestFactory requestFactory;

    ZoneInstanceGroupManagers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().instanceGroupManagers();
        this.credentials = credentials;
        this.requestFactory = new ZonalGoogleComputeRequestFactory("instanceGroupManagers", credentials, operationPoller, registry);
    }

    public GoogleComputeGetRequest<Compute.InstanceGroupManagers.Get, InstanceGroupManager> get(String zone, String name) throws IOException {
        return this.requestFactory.wrapGetRequest(this.computeApi.get(this.credentials.getProject(), zone, name), "get", zone);
    }

    public PaginatedComputeRequest<Compute.InstanceGroupManagers.List, InstanceGroupManager> list(String zone) {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject(), zone).setPageToken(pageToken), "list", zone), InstanceGroupManagerList::getNextPageToken, response -> Optional.ofNullable(response.getItems()).orElseGet(ImmutableList::of));
    }
}

