/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.AutoscalingPolicy;
import com.google.api.services.compute.model.AutoscalingPolicyCpuUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyCustomMetricUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyLoadBalancingUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyScaleInControl;
import com.google.api.services.compute.model.AutoscalingPolicyScalingSchedule;
import com.google.api.services.compute.model.Backend;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FixedOrPercent;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HealthCheck;
import com.google.api.services.compute.model.HealthCheckList;
import com.google.api.services.compute.model.HealthStatus;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.HttpHealthCheckList;
import com.google.api.services.compute.model.HttpsHealthCheck;
import com.google.api.services.compute.model.HttpsHealthCheckList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerAggregatedList;
import com.google.api.services.compute.model.InstanceGroupManagerAutoHealingPolicy;
import com.google.api.services.compute.model.InstanceGroupManagersScopedList;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NamedPort;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.SSLHealthCheck;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.api.services.compute.model.ShieldedVmConfig;
import com.google.api.services.compute.model.TCPHealthCheck;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetSslProxy;
import com.google.api.services.compute.model.TargetTcpProxy;
import com.google.api.services.compute.model.UrlMap;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.batch.GoogleBatchRequest;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BaseGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BasicGoogleDeployDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoHealingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDisk;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDiskType;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstance;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstances;
import com.netflix.spinnaker.clouddriver.google.model.GoogleNetwork;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSubnet;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleLoadBalancerHealth;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleNetworkProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSubnetProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.config.GoogleConfiguration;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCEUtil
implements GroovyObject {
    public static final String GCE_IMAGE_TYPE = "gce/image";
    private static final String DISK_TYPE_PERSISTENT = "PERSISTENT";
    private static final String DISK_TYPE_SCRATCH = "SCRATCH";
    private static final String GCE_API_PREFIX = "https://compute.googleapis.com/compute/v1/projects/";
    private static final List<Integer> RETRY_ERROR_CODES;
    public static final String TARGET_POOL_NAME_PREFIX = "tp";
    public static final String REGIONAL_LOAD_BALANCER_NAMES = "load-balancer-names";
    public static final String GLOBAL_LOAD_BALANCER_NAMES = "global-load-balancer-names";
    public static final String BACKEND_SERVICE_NAMES = "backend-service-names";
    public static final String REGION_BACKEND_SERVICE_NAMES = "region-backend-service-names";
    public static final String LOAD_BALANCING_POLICY = "load-balancing-policy";
    public static final String SELECT_ZONES = "select-zones";
    public static final String AUTOSCALING_POLICY = "autoscaling-policy";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public GCEUtil() {
        MetaClass metaClass;
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String queryMachineType(String instanceType, String location, GoogleNamedAccountCredentials credentials, Task task, String phase) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[0].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{instanceType}, new String[]{"Looking up machine type ", "..."}));
        if (ScriptBytecodeAdapter.isCase((Object)instanceType, (Object)callSiteArray[1].callGetPropertySafe(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)credentials), (Object)location)))) {
            return instanceType;
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[4].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{instanceType}, new String[]{"Machine type ", " not found."}), (Object)task, (Object)phase));
    }

    /*
     * WARNING - void declaration
     */
    public static Image queryImage(String imageName, GoogleNamedAccountCredentials credentials, Task task, String phase, String clouddriverUserAgentApplicationName, List<String> baseImageProjects, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Reference imageName2 = new Reference((Object)imageName);
        Reference credentials2 = new Reference((Object)var1_1);
        Reference task2 = new Reference((Object)var2_2);
        Reference phase2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[5].call((Object)((Task)task2.get()), (Object)((String)phase2.get()), (Object)new GStringImpl(new Object[]{(String)imageName2.get()}, new String[]{"Looking up image ", "..."}));
        Reference filter = new Reference((Object)new GStringImpl(new Object[]{(String)imageName2.get()}, new String[]{"name eq ", ""}));
        Reference imageProjects = new Reference(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)((GoogleNamedAccountCredentials)((Object)credentials2.get())))}), callSiteArray[10].callGroovyObjectGetPropertySafe((Object)((GoogleNamedAccountCredentials)((Object)credentials2.get())))), baseImageProjects), null));
        Reference sourceImage = new Reference(null);
        Reference imageListBatch = new Reference(callSiteArray[11].callConstructor(GoogleBatchRequest.class, callSiteArray[12].callGroovyObjectGetProperty((Object)((GoogleNamedAccountCredentials)((Object)credentials2.get()))), (Object)clouddriverUserAgentApplicationName));
        Reference imageListCallback = new Reference((Object)new GroovyObject(imageName2, imageProjects, task2, phase2, sourceImage){
            public /* synthetic */ Reference sourceImage;
            public /* synthetic */ Reference phase;
            public /* synthetic */ Reference task;
            public /* synthetic */ Reference imageProjects;
            public /* synthetic */ Reference imageName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.sourceImage = reference5 = p4;
                this.phase = reference4 = p3;
                this.task = reference3 = p2;
                this.imageProjects = reference2 = p1;
                this.imageName = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                callSiteArray[0].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.imageName.get(), this.imageProjects.get(), callSiteArray[1].callGetProperty((Object)e)}, new String[]{"Error locating ", " in these projects: ", ": ", ""}), this.task.get(), this.phase.get());
            }

            public void onSuccess(ImageList imageList, HttpHeaders responseHeaders) throws IOException {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.sourceImage.get()) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty((Object)imageList))) {
                    Object object = callSiteArray[3].call(callSiteArray[4].callGetProperty((Object)imageList), (Object)0);
                    this.sourceImage.set(object);
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, GCEUtil.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "updateStatusAndThrowNotFoundException";
                stringArray[1] = "message";
                stringArray[2] = "items";
                stringArray[3] = "getAt";
                stringArray[4] = "items";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        public final class _queryImage_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference filter;
            private /* synthetic */ Reference imageListBatch;
            private /* synthetic */ Reference imageListCallback;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryImage_closure1(Object _outerInstance, Object _thisObject, Reference credentials, Reference filter, Reference imageListBatch, Reference imageListCallback) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.credentials = reference4 = credentials;
                this.filter = reference3 = filter;
                this.imageListBatch = reference2 = imageListBatch;
                this.imageListCallback = reference = imageListCallback;
            }

            public Object doCall(Object imageProject) {
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                Object imagesList = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty(this.credentials.get())), imageProject);
                callSiteArray[3].call(imagesList, this.filter.get());
                return callSiteArray[4].call(this.imageListBatch.get(), imagesList, this.imageListCallback.get());
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
            }

            @Generated
            public Object getFilter() {
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                return this.filter.get();
            }

            @Generated
            public Object getImageListBatch() {
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                return this.imageListBatch.get();
            }

            @Generated
            public Object getImageListCallback() {
                CallSite[] callSiteArray = _queryImage_closure1.$getCallSiteArray();
                return this.imageListCallback.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryImage_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "list";
                stringArray[1] = "images";
                stringArray[2] = "compute";
                stringArray[3] = "setFilter";
                stringArray[4] = "queue";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _queryImage_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryImage_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryImage_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[13].call(imageProjects.get(), (Object)new _queryImage_closure1(GCEUtil.class, GCEUtil.class, credentials2, filter, imageListBatch, imageListCallback));
        callSiteArray[14].call((Object)executor, imageListBatch.get(), (Object)"findImage");
        if (DefaultTypeTransformation.booleanUnbox((Object)sourceImage.get())) {
            return (Image)ScriptBytecodeAdapter.castToType((Object)sourceImage.get(), Image.class);
        }
        return (Image)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{(String)imageName2.get(), imageProjects.get()}, new String[]{"Image ", " not found in any of these projects: ", "."}), (Object)((Task)task2.get()), (Object)((String)phase2.get())), Image.class);
    }

    public static Image getImageFromArtifact(Artifact artifact, Compute compute, Task task, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        Reference compute2 = new Reference((Object)compute);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].call((Object)artifact), (Object)GCE_IMAGE_TYPE)) {
            throw (Throwable)callSiteArray[17].callConstructor(GoogleOperationException.class, (Object)new GStringImpl(new Object[]{GCE_IMAGE_TYPE}, new String[]{"Artifact to deploy to GCE must be of type ", ""}));
        }
        Reference reference = new Reference(callSiteArray[18].call((Object)artifact));
        callSiteArray[19].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{reference.get()}, new String[]{"Looking up image ", "..."}));
        public final class _getImageFromArtifact_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference reference;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getImageFromArtifact_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference reference) {
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getImageFromArtifact_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference3 = compute;
                this.reference = reference2 = reference;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getImageFromArtifact_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(this.compute.get()), callSiteArray[4].callConstructor(GenericUrl.class, this.reference.get())), callSiteArray[5].callConstructor(JsonObjectParser.class, callSiteArray[6].call(JacksonFactory.class))));
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _getImageFromArtifact_closure2.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public Object getReference() {
                CallSite[] callSiteArray = _getImageFromArtifact_closure2.$getCallSiteArray();
                return this.reference.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getImageFromArtifact_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getImageFromArtifact_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "execute";
                stringArray[1] = "setParser";
                stringArray[2] = "buildGetRequest";
                stringArray[3] = "getRequestFactory";
                stringArray[4] = "<$constructor$>";
                stringArray[5] = "<$constructor$>";
                stringArray[6] = "getDefaultInstance";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getImageFromArtifact_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getImageFromArtifact_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getImageFromArtifact_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        HttpResponse result = (HttpResponse)ScriptBytecodeAdapter.asType((Object)callSiteArray[20].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _getImageFromArtifact_closure2(GCEUtil.class, GCEUtil.class, compute2, reference)), (Object)GCE_IMAGE_TYPE, (Object)task, RETRY_ERROR_CODES, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", "compute.buildGetRequest.execute", callSiteArray[21].callGetProperty((Object)executor), callSiteArray[22].callGetProperty((Object)executor)}), (Object)callSiteArray[23].callGetProperty((Object)executor))), HttpResponse.class);
        return (Image)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call((Object)result, Image.class), Image.class);
    }

    public static Image getBootImage(BaseGoogleInstanceDescription description, Task task, String phase, String clouddriverUserAgentApplicationName, List<String> baseImageProjects, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[25].callGroovyObjectGetProperty((Object)description), (Object)callSiteArray[26].callGetProperty(BaseGoogleInstanceDescription.ImageSource.class))) {
            return (Image)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)callSiteArray[28].callGroovyObjectGetProperty((Object)description), (Object)callSiteArray[29].callGetProperty(callSiteArray[30].callGroovyObjectGetProperty((Object)description)), (Object)task, (Object)phase, (Object)safeRetry, (Object)executor)), Image.class);
        }
        return (Image)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)description), (Object)callSiteArray[33].callGroovyObjectGetProperty((Object)description), (Object)task, (Object)phase, (Object)clouddriverUserAgentApplicationName, baseImageProjects, (Object)executor)), Image.class);
    }

    public static boolean isShieldedVmCompatible(Image image) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        List guestOsFeatureList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)image), List.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)guestOsFeatureList, null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[35].call((Object)guestOsFeatureList), (Object)0) : ScriptBytecodeAdapter.compareEqual((Object)guestOsFeatureList, null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[36].call((Object)guestOsFeatureList), (Object)0)) {
            return false;
        }
        Reference isUefiCompatible = new Reference((Object)false);
        Reference isSecureBootCompatible = new Reference((Object)false);
        public final class _isShieldedVmCompatible_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference isUefiCompatible;
            private /* synthetic */ Reference isSecureBootCompatible;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isShieldedVmCompatible_closure3(Object _outerInstance, Object _thisObject, Reference isUefiCompatible, Reference isSecureBootCompatible) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _isShieldedVmCompatible_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.isUefiCompatible = reference2 = isUefiCompatible;
                this.isSecureBootCompatible = reference = isSecureBootCompatible;
            }

            public Object doCall(Object feature) {
                CallSite[] callSiteArray = _isShieldedVmCompatible_closure3.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(feature), (Object)"UEFI_COMPATIBLE")) {
                    boolean bl = true;
                    this.isUefiCompatible.set((Object)bl);
                    return null;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(feature), (Object)"SECURE_BOOT")) {
                    boolean bl = true;
                    this.isSecureBootCompatible.set((Object)bl);
                    return null;
                }
                return null;
            }

            @Generated
            public Boolean getIsUefiCompatible() {
                CallSite[] callSiteArray = _isShieldedVmCompatible_closure3.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isUefiCompatible.get(), Boolean.class);
            }

            @Generated
            public Boolean getIsSecureBootCompatible() {
                CallSite[] callSiteArray = _isShieldedVmCompatible_closure3.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isSecureBootCompatible.get(), Boolean.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isShieldedVmCompatible_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getType";
                stringArray[1] = "getType";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _isShieldedVmCompatible_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isShieldedVmCompatible_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isShieldedVmCompatible_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[37].call((Object)guestOsFeatureList, (Object)new _isShieldedVmCompatible_closure3(GCEUtil.class, GCEUtil.class, isUefiCompatible, isSecureBootCompatible));
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)isUefiCompatible.get())) && DefaultTypeTransformation.booleanUnbox((Object)((Boolean)isSecureBootCompatible.get()));
    }

    public static GoogleNetwork queryNetwork(String accountName, String networkName, Task task, String phase, GoogleNetworkProvider googleNetworkProvider) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[38].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{networkName}, new String[]{"Looking up network ", "..."}));
        Object networks = callSiteArray[39].call((Object)googleNetworkProvider, callSiteArray[40].call(Keys.class, (Object)networkName, (Object)"global", (Object)accountName));
        if (DefaultTypeTransformation.booleanUnbox((Object)networks)) {
            return (GoogleNetwork)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(networks, (Object)0), GoogleNetwork.class);
        }
        return (GoogleNetwork)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{networkName}, new String[]{"Network ", " not found."}), (Object)task, (Object)phase), GoogleNetwork.class);
    }

    public static GoogleSubnet querySubnet(String accountName, String region, String subnetName, Task task, String phase, GoogleSubnetProvider googleSubnetProvider) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[43].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{subnetName, region}, new String[]{"Looking up subnet ", " in ", "..."}));
        Object subnets = callSiteArray[44].call((Object)googleSubnetProvider, callSiteArray[45].call(Keys.class, (Object)subnetName, (Object)region, (Object)accountName));
        if (DefaultTypeTransformation.booleanUnbox((Object)subnets)) {
            return (GoogleSubnet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(subnets, (Object)0), GoogleSubnet.class);
        }
        return (GoogleSubnet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{subnetName, region}, new String[]{"Subnet ", " not found in ", "."}), (Object)task, (Object)phase), GoogleSubnet.class);
    }

    public static ForwardingRule queryRegionalForwardingRule(String projectName, String forwardingRuleName, Compute compute, Task task, String phase, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[48].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{forwardingRuleName}, new String[]{"Checking for existing network load balancer (forwarding rule) ", "..."}));
        Object all_regions = callSiteArray[49].call((Object)executor, callSiteArray[50].call(callSiteArray[51].call((Object)compute), (Object)projectName), (Object)"compute.regions.list", callSiteArray[52].callGetProperty((Object)executor), callSiteArray[53].callGetProperty((Object)executor));
        Object region = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call(callSiteArray[55].callGetProperty(all_regions)), Iterator.class);
        while (iterator.hasNext()) {
            region = iterator.next();
            ForwardingRule forwardingRule = (ForwardingRule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call((Object)executor, ArrayUtil.createArray((Object)callSiteArray[57].call(callSiteArray[58].call((Object)compute), (Object)projectName, callSiteArray[59].callGetProperty(region), (Object)forwardingRuleName), (Object)"compute.forwardingRules.get", (Object)callSiteArray[60].callGetProperty((Object)executor), (Object)callSiteArray[61].callGetProperty((Object)executor), (Object)callSiteArray[62].callGetProperty((Object)executor), (Object)callSiteArray[63].callGetProperty(region))), ForwardingRule.class);
            try {
                return forwardingRule;
            }
            catch (GoogleJsonResponseException e) {
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[64].call((Object)e), (Object)404)) continue;
                throw (Throwable)e;
            }
        }
        return (ForwardingRule)ScriptBytecodeAdapter.castToType(null, ForwardingRule.class);
    }

    public static BackendService queryBackendService(Compute compute, String project, String serviceName, Task task, String phase, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[65].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{serviceName}, new String[]{"Checking for existing backend service ", "..."}));
        BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].call((Object)executor, callSiteArray[67].call(callSiteArray[68].call((Object)compute), (Object)project, (Object)serviceName), (Object)"compute.backendServices.get", callSiteArray[69].callGetProperty((Object)executor), callSiteArray[70].callGetProperty((Object)executor)), BackendService.class);
        try {
            return backendService;
        }
        catch (GoogleJsonResponseException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[71].call((Object)e), (Object)404)) {
                throw (Throwable)e;
            }
            BackendService backendService2 = (BackendService)ScriptBytecodeAdapter.castToType(null, BackendService.class);
            return backendService2;
        }
    }

    public static TargetPool queryTargetPool(String projectName, String region, String targetPoolName, Compute compute, Task task, String phase, GoogleExecutorTraits executor) {
        Reference targetPoolName2 = new Reference((Object)targetPoolName);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[72].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{(String)targetPoolName2.get()}, new String[]{"Checking for existing network load balancer (target pool) ", "..."}));
        Object all_pools = callSiteArray[73].call((Object)executor, ArrayUtil.createArray((Object)callSiteArray[74].call(callSiteArray[75].call((Object)compute), (Object)projectName, (Object)region), (Object)"compute.targetPools.list", (Object)callSiteArray[76].callGetProperty((Object)executor), (Object)callSiteArray[77].callGetProperty((Object)executor), (Object)callSiteArray[78].callGetProperty((Object)executor), (Object)region));
        public final class _queryTargetPool_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference targetPoolName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryTargetPool_closure4(Object _outerInstance, Object _thisObject, Reference targetPoolName) {
                Reference reference;
                CallSite[] callSiteArray = _queryTargetPool_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.targetPoolName = reference = targetPoolName;
            }

            public Object doCall(Object existingTargetPool) {
                CallSite[] callSiteArray = _queryTargetPool_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(existingTargetPool), (Object)this.targetPoolName.get());
            }

            @Generated
            public String getTargetPoolName() {
                CallSite[] callSiteArray = _queryTargetPool_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.targetPoolName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryTargetPool_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryTargetPool_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryTargetPool_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (TargetPool)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(callSiteArray[80].callGetProperty(all_pools), (Object)new _queryTargetPool_closure4(GCEUtil.class, GCEUtil.class, targetPoolName2)), TargetPool.class);
    }

    public static HttpHealthCheck queryHttpHealthCheck(String projectName, String httpHealthCheckName, Compute compute, Task task, String phase, GoogleExecutorTraits executor) {
        Reference httpHealthCheckName2 = new Reference((Object)httpHealthCheckName);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[81].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{(String)httpHealthCheckName2.get()}, new String[]{"Checking for existing network load balancer (http health check) ", "..."}));
        Object all_checks = callSiteArray[82].call((Object)executor, callSiteArray[83].call(callSiteArray[84].call((Object)compute), (Object)projectName), (Object)"compute.httpHealthChecks.list", callSiteArray[85].callGetProperty((Object)executor), callSiteArray[86].callGetProperty((Object)executor));
        public final class _queryHttpHealthCheck_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference httpHealthCheckName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryHttpHealthCheck_closure5(Object _outerInstance, Object _thisObject, Reference httpHealthCheckName) {
                Reference reference;
                CallSite[] callSiteArray = _queryHttpHealthCheck_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.httpHealthCheckName = reference = httpHealthCheckName;
            }

            public Object doCall(Object existingHealthCheck) {
                CallSite[] callSiteArray = _queryHttpHealthCheck_closure5.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(existingHealthCheck), (Object)this.httpHealthCheckName.get());
            }

            @Generated
            public String getHttpHealthCheckName() {
                CallSite[] callSiteArray = _queryHttpHealthCheck_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.httpHealthCheckName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryHttpHealthCheck_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryHttpHealthCheck_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryHttpHealthCheck_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (HttpHealthCheck)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(callSiteArray[88].callGetProperty(all_checks), (Object)new _queryHttpHealthCheck_closure5(GCEUtil.class, GCEUtil.class, httpHealthCheckName2)), HttpHealthCheck.class);
    }

    public static Object queryHealthCheck(String projectName, String account, String healthCheckName, GoogleHealthCheck.HealthCheckKind healthCheckKind, Compute compute, Cache cacheView, Task task, String phase, GoogleExecutorTraits executor) {
        Object object;
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[89].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Looking up health check ", "..."}));
        GoogleHealthCheck.HealthCheckKind healthCheckKind2 = healthCheckKind;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)healthCheckKind2), (Object)callSiteArray[90].callGetProperty(GoogleHealthCheck.HealthCheckKind.class))) {
            return callSiteArray[91].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)projectName, (Object)account, (Object)healthCheckName, (Object)compute, (Object)cacheView, (Object)task, (Object)phase, (Object)executor));
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)healthCheckKind2), (Object)callSiteArray[92].callGetProperty(GoogleHealthCheck.HealthCheckKind.class))) {
            return callSiteArray[93].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)account, (Object)healthCheckName, (Object)cacheView, (Object)task, (Object)phase));
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)healthCheckKind2), (Object)callSiteArray[94].callGetProperty(GoogleHealthCheck.HealthCheckKind.class))) {
            return callSiteArray[95].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)projectName, (Object)healthCheckName, (Object)compute, (Object)task, (Object)phase, (Object)executor));
        }
        Object object2 = callSiteArray[96].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)projectName, (Object)account, (Object)healthCheckName, (Object)compute, (Object)cacheView, (Object)task, (Object)phase, (Object)executor));
        return DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : (DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[97].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)account, (Object)healthCheckName, (Object)cacheView, (Object)task, (Object)phase)))) ? object : callSiteArray[98].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)projectName, (Object)healthCheckName, (Object)compute, (Object)task, (Object)phase, (Object)executor)));
    }

    public static Object queryNestedHealthCheck(String projectName, String account, String healthCheckName, Compute compute, Cache cacheView, Task task, String phase, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[99].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Looking up health check ", "..."}));
        Object healthCheckIdentifiers = callSiteArray[100].call((Object)cacheView, callSiteArray[101].callGetProperty(callSiteArray[102].callGetProperty(Keys.Namespace.class)), callSiteArray[103].call(Keys.class, (Object)account, (Object)"healthCheck", (Object)healthCheckName));
        Object results = callSiteArray[104].call((Object)cacheView, callSiteArray[105].callGetProperty(callSiteArray[106].callGetProperty(Keys.Namespace.class)), healthCheckIdentifiers, callSiteArray[107].call(RelationshipCacheFilter.class));
        return callSiteArray[108].callGetPropertySafe(callSiteArray[109].callGetPropertySafe(callSiteArray[110].call(results, (Object)0)));
    }

    public static Object queryLegacyHttpHealthCheck(String account, String healthCheckName, Cache cacheView, Task task, String phase) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[111].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Looking up http health check ", "..."}));
        Object httpHealthCheckIdentifiers = callSiteArray[112].call((Object)cacheView, callSiteArray[113].callGetProperty(callSiteArray[114].callGetProperty(Keys.Namespace.class)), callSiteArray[115].call(Keys.class, (Object)account, (Object)healthCheckName));
        Object results = callSiteArray[116].call((Object)cacheView, callSiteArray[117].callGetProperty(callSiteArray[118].callGetProperty(Keys.Namespace.class)), httpHealthCheckIdentifiers, callSiteArray[119].call(RelationshipCacheFilter.class));
        return callSiteArray[120].callGetPropertySafe(callSiteArray[121].callGetPropertySafe(callSiteArray[122].call(results, (Object)0)));
    }

    /*
     * Exception decompiling
     */
    public static Object queryLegacyHttpsHealthCheck(String projectName, String healthCheckName, Compute compute, Task task, String phase, GoogleExecutorTraits executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public static List<ForwardingRule> queryRegionalForwardingRules(String projectName, String region, List<String> forwardingRuleNames, Compute compute, Task task, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Reference projectName2 = new Reference((Object)projectName);
        Reference region2 = new Reference((Object)var1_1);
        Reference forwardingRuleNames2 = new Reference((Object)var2_2);
        Reference compute2 = new Reference((Object)var3_3);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[132].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{(List)forwardingRuleNames2.get()}, new String[]{"Looking up regional load balancers ", "..."}));
        public final class _queryRegionalForwardingRules_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryRegionalForwardingRules_closure6(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference projectName, Reference region) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference4 = executor;
                this.compute = reference3 = compute;
                this.projectName = reference2 = projectName;
                this.region = reference = region;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(this.executor.get(), callSiteArray[2].call(callSiteArray[3].call(this.compute.get()), this.projectName.get(), this.region.get()), (Object)"compute.forwardingRules.list", callSiteArray[4].callGetProperty(this.executor.get()), callSiteArray[5].callGetProperty(this.executor.get())));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProjectName() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.projectName.get());
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryRegionalForwardingRules_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "timeExecute";
                stringArray[2] = "list";
                stringArray[3] = "forwardingRules";
                stringArray[4] = "TAG_SCOPE";
                stringArray[5] = "SCOPE_GLOBAL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _queryRegionalForwardingRules_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryRegionalForwardingRules_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryRegionalForwardingRules_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List forwardingRules = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[133].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _queryRegionalForwardingRules_closure6(GCEUtil.class, GCEUtil.class, executor2, compute2, projectName2, region2)), (Object)"regional forwarding rules", (Object)task, RETRY_ERROR_CODES, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "list", "phase", phase, "operation", "compute.forwardingRules.list", callSiteArray[134].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[135].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))}), (Object)callSiteArray[136].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
        public final class _queryRegionalForwardingRules_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference forwardingRuleNames;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryRegionalForwardingRules_closure7(Object _outerInstance, Object _thisObject, Reference forwardingRuleNames) {
                Reference reference;
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.forwardingRuleNames = reference = forwardingRuleNames;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure7.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)this.forwardingRuleNames.get());
            }

            @Generated
            public List getForwardingRuleNames() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure7.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.forwardingRuleNames.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryRegionalForwardingRules_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryRegionalForwardingRules_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryRegionalForwardingRules_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundForwardingRules = callSiteArray[137].call((Object)forwardingRules, (Object)new _queryRegionalForwardingRules_closure7(GCEUtil.class, GCEUtil.class, forwardingRuleNames2));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[138].callGetProperty(foundForwardingRules), (Object)callSiteArray[139].callGetProperty((Object)((List)forwardingRuleNames2.get())))) {
            return (List)ScriptBytecodeAdapter.castToType((Object)foundForwardingRules, List.class);
        }
        public final class _queryRegionalForwardingRules_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryRegionalForwardingRules_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure8.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryRegionalForwardingRules_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryRegionalForwardingRules_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryRegionalForwardingRules_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryRegionalForwardingRules_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundNames = callSiteArray[140].call(foundForwardingRules, (Object)new _queryRegionalForwardingRules_closure8(GCEUtil.class, GCEUtil.class));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{callSiteArray[142].call((Object)((List)forwardingRuleNames2.get()), foundNames)}, new String[]{"Regional load balancers ", " not found."}), (Object)task, (Object)phase), List.class);
    }

    public static List<GoogleLoadBalancerView> queryAllLoadBalancers(GoogleLoadBalancerProvider googleLoadBalancerProvider, List<String> forwardingRuleNames, Task task, String phase) {
        Reference forwardingRuleNames2 = new Reference(forwardingRuleNames);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        List loadBalancers = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[143].call((Object)googleLoadBalancerProvider, (Object)""), List.class);
        public final class _queryAllLoadBalancers_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference forwardingRuleNames;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryAllLoadBalancers_closure9(Object _outerInstance, Object _thisObject, Reference forwardingRuleNames) {
                Reference reference;
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.forwardingRuleNames = reference = forwardingRuleNames;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure9.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)this.forwardingRuleNames.get());
            }

            @Generated
            public List getForwardingRuleNames() {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.forwardingRuleNames.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryAllLoadBalancers_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryAllLoadBalancers_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryAllLoadBalancers_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundLoadBalancers = callSiteArray[144].call((Object)loadBalancers, (Object)new _queryAllLoadBalancers_closure9(GCEUtil.class, GCEUtil.class, forwardingRuleNames2));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[145].call(foundLoadBalancers), (Object)callSiteArray[146].call((Object)((List)forwardingRuleNames2.get())))) {
            return (List)ScriptBytecodeAdapter.castToType((Object)foundLoadBalancers, List.class);
        }
        public final class _queryAllLoadBalancers_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryAllLoadBalancers_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure10.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryAllLoadBalancers_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryAllLoadBalancers_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryAllLoadBalancers_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryAllLoadBalancers_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundNames = callSiteArray[147].call(foundLoadBalancers, (Object)new _queryAllLoadBalancers_closure10(GCEUtil.class, GCEUtil.class));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{callSiteArray[149].call((Object)((List)forwardingRuleNames2.get()), foundNames)}, new String[]{"Load balancers ", " not found."}), (Object)task, (Object)phase), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> queryInstanceUrls(String projectName, String region, List<String> instanceLocalNames, Compute compute, Task task, String phase, GoogleExecutorTraits executor) {
        void var2_2;
        Reference region2 = new Reference((Object)region);
        Reference instanceLocalNames2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[150].call((Object)task, (Object)phase, (Object)new GStringImpl(new Object[]{(List)instanceLocalNames2.get()}, new String[]{"Looking up instances ", "..."}));
        Map zoneToInstancesMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callGetProperty(callSiteArray[152].call((Object)executor, callSiteArray[153].call(callSiteArray[154].call((Object)compute), (Object)projectName), (Object)"compute.instances.aggregatedList", callSiteArray[155].callGetProperty((Object)executor), callSiteArray[156].callGetProperty((Object)executor))), Map.class);
        public final class _queryInstanceUrls_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference instanceLocalNames;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryInstanceUrls_closure11(Object _outerInstance, Object _thisObject, Reference region, Reference instanceLocalNames) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _queryInstanceUrls_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.region = reference2 = region;
                this.instanceLocalNames = reference = instanceLocalNames;
            }

            public Object doCall(Object zone, Object instanceList) {
                CallSite[] callSiteArray = _queryInstanceUrls_closure11.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(zone, (Object)new GStringImpl(new Object[]{this.region.get()}, new String[]{"zones/", "-"}))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(instanceList))) {
                    public final class _closure103
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference instanceLocalNames;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure103(Object _outerInstance, Object _thisObject, Reference instanceLocalNames) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure103.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.instanceLocalNames = reference = instanceLocalNames;
                        }

                        public Object doCall(Object instance) {
                            CallSite[] callSiteArray = _closure103.$getCallSiteArray();
                            return callSiteArray[0].call(this.instanceLocalNames.get(), callSiteArray[1].callGetProperty(instance));
                        }

                        @Generated
                        public List getInstanceLocalNames() {
                            CallSite[] callSiteArray = _closure103.$getCallSiteArray();
                            return (List)ScriptBytecodeAdapter.castToType((Object)this.instanceLocalNames.get(), List.class);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure103.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "contains";
                            stringArray[1] = "name";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure103.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure103.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure103.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[2].call(callSiteArray[3].callGetProperty(instanceList), (Object)new _closure103((Object)this, this.getThisObject(), this.instanceLocalNames));
                }
                return null;
            }

            public Object call(Object zone, Object instanceList) {
                CallSite[] callSiteArray = _queryInstanceUrls_closure11.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, zone, instanceList);
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _queryInstanceUrls_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            @Generated
            public List getInstanceLocalNames() {
                CallSite[] callSiteArray = _queryInstanceUrls_closure11.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.instanceLocalNames.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryInstanceUrls_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "instances";
                stringArray[2] = "findAll";
                stringArray[3] = "instances";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _queryInstanceUrls_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryInstanceUrls_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryInstanceUrls_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundInstances = callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call((Object)zoneToInstancesMap, (Object)new _queryInstanceUrls_closure11(GCEUtil.class, GCEUtil.class, region2, instanceLocalNames2))), null);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[160].callGetProperty(foundInstances), (Object)callSiteArray[161].callGetProperty((Object)((List)instanceLocalNames2.get())))) {
            public final class _queryInstanceUrls_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryInstanceUrls_closure12(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _queryInstanceUrls_closure12.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _queryInstanceUrls_closure12.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _queryInstanceUrls_closure12.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryInstanceUrls_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "selfLink";
                    return new CallSiteArray(_queryInstanceUrls_closure12.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryInstanceUrls_closure12.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].call(foundInstances, (Object)new _queryInstanceUrls_closure12(GCEUtil.class, GCEUtil.class)), List.class);
        }
        public final class _queryInstanceUrls_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryInstanceUrls_closure13(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _queryInstanceUrls_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryInstanceUrls_closure13.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryInstanceUrls_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryInstanceUrls_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_queryInstanceUrls_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryInstanceUrls_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundNames = callSiteArray[163].call(foundInstances, (Object)new _queryInstanceUrls_closure13(GCEUtil.class, GCEUtil.class));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{callSiteArray[165].call((Object)((List)instanceLocalNames2.get()), foundNames)}, new String[]{"Instances ", " not found."}), (Object)task, (Object)phase), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public static InstanceGroupManager queryRegionalManagedInstanceGroup(String projectName, String region, String serverGroupName, GoogleNamedAccountCredentials credentials, Task task, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Reference projectName2 = new Reference((Object)projectName);
        Reference region2 = new Reference((Object)var1_1);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        Reference credentials2 = new Reference((Object)var3_3);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _queryRegionalManagedInstanceGroup_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryRegionalManagedInstanceGroup_closure14(Object _outerInstance, Object _thisObject, Reference executor, Reference credentials, Reference projectName, Reference region, Reference serverGroupName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference5 = executor;
                this.credentials = reference4 = credentials;
                this.projectName = reference3 = projectName;
                this.region = reference2 = region;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty(this.credentials.get())), this.projectName.get(), this.region.get(), this.serverGroupName.get()), (Object)"compute.regionInstanceGroupManagers.get", (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)callSiteArray[6].callGetProperty(this.executor.get()), (Object)this.region.get()));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
            }

            @Generated
            public String getProjectName() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.projectName.get());
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            @Generated
            public String getServerGroupName() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryRegionalManagedInstanceGroup_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "regionInstanceGroupManagers";
                stringArray[3] = "compute";
                stringArray[4] = "TAG_SCOPE";
                stringArray[5] = "SCOPE_REGIONAL";
                stringArray[6] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _queryRegionalManagedInstanceGroup_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryRegionalManagedInstanceGroup_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryRegionalManagedInstanceGroup_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (InstanceGroupManager)ScriptBytecodeAdapter.asType((Object)callSiteArray[166].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _queryRegionalManagedInstanceGroup_closure14(GCEUtil.class, GCEUtil.class, executor2, credentials2, projectName2, region2, serverGroupName2)), (Object)"regional managed instance group", (Object)task, RETRY_ERROR_CODES, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", "compute.regionInstanceGroupManagers.get", callSiteArray[167].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[168].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[169].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (String)region2.get()}), (Object)callSiteArray[170].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), InstanceGroupManager.class);
    }

    /*
     * WARNING - void declaration
     */
    public static InstanceGroupManager queryZonalManagedInstanceGroup(String projectName, String zone, String serverGroupName, GoogleNamedAccountCredentials credentials, Task task, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Reference projectName2 = new Reference((Object)projectName);
        Reference zone2 = new Reference((Object)var1_1);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        Reference credentials2 = new Reference((Object)var3_3);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _queryZonalManagedInstanceGroup_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference zone;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryZonalManagedInstanceGroup_closure15(Object _outerInstance, Object _thisObject, Reference executor, Reference credentials, Reference projectName, Reference zone, Reference serverGroupName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference5 = executor;
                this.credentials = reference4 = credentials;
                this.projectName = reference3 = projectName;
                this.zone = reference2 = zone;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty(this.credentials.get())), this.projectName.get(), this.zone.get(), this.serverGroupName.get()), (Object)"compute.instanceGroupManagers.get", (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)callSiteArray[6].callGetProperty(this.executor.get()), (Object)this.zone.get()));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
            }

            @Generated
            public String getProjectName() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.projectName.get());
            }

            @Generated
            public String getZone() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.zone.get());
            }

            @Generated
            public String getServerGroupName() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryZonalManagedInstanceGroup_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryZonalManagedInstanceGroup_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "instanceGroupManagers";
                stringArray[3] = "compute";
                stringArray[4] = "TAG_SCOPE";
                stringArray[5] = "SCOPE_ZONAL";
                stringArray[6] = "TAG_ZONE";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _queryZonalManagedInstanceGroup_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryZonalManagedInstanceGroup_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryZonalManagedInstanceGroup_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (InstanceGroupManager)ScriptBytecodeAdapter.asType((Object)callSiteArray[171].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _queryZonalManagedInstanceGroup_closure15(GCEUtil.class, GCEUtil.class, executor2, credentials2, projectName2, zone2, serverGroupName2)), (Object)"zonal managed instance group", (Object)task, RETRY_ERROR_CODES, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", "compute.instanceGroupManagers.get", callSiteArray[172].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[173].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[174].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (String)zone2.get()}), (Object)callSiteArray[175].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), InstanceGroupManager.class);
    }

    /*
     * WARNING - void declaration
     */
    public static List<InstanceGroupManager> queryAllManagedInstanceGroups(String projectName, String region, GoogleNamedAccountCredentials credentials, Task task, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference projectName2 = new Reference((Object)projectName);
        Reference region2 = new Reference((Object)var1_1);
        Reference credentials2 = new Reference((Object)var2_2);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference executedAtLeastOnce = new Reference((Object)false);
        Reference nextPageToken = new Reference(null);
        public final class _queryAllManagedInstanceGroups_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryAllManagedInstanceGroups_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure16.$getCallSiteArray();
                return callSiteArray[0].callConstructor(InstanceGroupManagersScopedList.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryAllManagedInstanceGroups_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "<$constructor$>";
                return new CallSiteArray(_queryAllManagedInstanceGroups_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryAllManagedInstanceGroups_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference fullAggregatedList = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _queryAllManagedInstanceGroups_closure16(GCEUtil.class, GCEUtil.class)), Map.class)));
        while (!DefaultTypeTransformation.booleanUnbox((Object)((Boolean)executedAtLeastOnce.get())) || DefaultTypeTransformation.booleanUnbox((Object)((String)nextPageToken.get()))) {
            public final class _queryAllManagedInstanceGroups_closure17
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference credentials;
                private /* synthetic */ Reference projectName;
                private /* synthetic */ Reference nextPageToken;
                private /* synthetic */ Reference executedAtLeastOnce;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryAllManagedInstanceGroups_closure17(Object _outerInstance, Object _thisObject, Reference executor, Reference credentials, Reference projectName, Reference nextPageToken, Reference executedAtLeastOnce) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference5 = executor;
                    this.credentials = reference4 = credentials;
                    this.projectName = reference3 = projectName;
                    this.nextPageToken = reference2 = nextPageToken;
                    this.executedAtLeastOnce = reference = executedAtLeastOnce;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    InstanceGroupManagerAggregatedList instanceGroupManagerAggregatedList = (InstanceGroupManagerAggregatedList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty(this.credentials.get())), this.projectName.get()), this.nextPageToken.get()), (Object)"compute.instanceGroupManagers.aggregatedList", callSiteArray[5].callGetProperty(this.executor.get()), callSiteArray[6].callGetProperty(this.executor.get())), InstanceGroupManagerAggregatedList.class);
                    boolean bl = true;
                    this.executedAtLeastOnce.set((Object)bl);
                    Object object = callSiteArray[7].call((Object)instanceGroupManagerAggregatedList);
                    this.nextPageToken.set((Object)ShortTypeHandling.castToString((Object)object));
                    return callSiteArray[8].call((Object)instanceGroupManagerAggregatedList);
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public GoogleNamedAccountCredentials getCredentials() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
                }

                @Generated
                public String getProjectName() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.projectName.get());
                }

                @Generated
                public String getNextPageToken() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.nextPageToken.get());
                }

                @Generated
                public Boolean getExecutedAtLeastOnce() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.executedAtLeastOnce.get(), Boolean.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure17.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryAllManagedInstanceGroups_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "setPageToken";
                    stringArray[2] = "aggregatedList";
                    stringArray[3] = "instanceGroupManagers";
                    stringArray[4] = "compute";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_GLOBAL";
                    stringArray[7] = "getNextPageToken";
                    stringArray[8] = "getItems";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[9];
                    _queryAllManagedInstanceGroups_closure17.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_queryAllManagedInstanceGroups_closure17.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryAllManagedInstanceGroups_closure17.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Map aggregatedList = (Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[177].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _queryAllManagedInstanceGroups_closure17(GCEUtil.class, GCEUtil.class, executor2, credentials2, projectName2, nextPageToken, executedAtLeastOnce)), (Object)"aggregated managed instance groups", (Object)task, RETRY_ERROR_CODES, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "list", "phase", phase, "operation", "compute.instanceGroupManagers.aggregatedList", callSiteArray[178].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[179].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))}), (Object)callSiteArray[180].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), Map.class);
            public final class _queryAllManagedInstanceGroups_closure18
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference fullAggregatedList;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryAllManagedInstanceGroups_closure18(Object _outerInstance, Object _thisObject, Reference fullAggregatedList) {
                    Reference reference;
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure18.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.fullAggregatedList = reference = fullAggregatedList;
                }

                public Object doCall(Object scope, InstanceGroupManagersScopedList instanceGroupManagersScopedList) {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure18.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)instanceGroupManagersScopedList))) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(callSiteArray[2].call(this.fullAggregatedList.get(), scope)))) {
                            callSiteArray[3].call(callSiteArray[4].call(this.fullAggregatedList.get(), scope), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        }
                        return callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(this.fullAggregatedList.get(), scope)), callSiteArray[8].call((Object)instanceGroupManagersScopedList));
                    }
                    return null;
                }

                public Object call(Object scope, InstanceGroupManagersScopedList instanceGroupManagersScopedList) {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure18.$getCallSiteArray();
                    return callSiteArray[9].callCurrent((GroovyObject)this, scope, (Object)instanceGroupManagersScopedList);
                }

                @Generated
                public Map getFullAggregatedList() {
                    CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure18.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.fullAggregatedList.get(), Map.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryAllManagedInstanceGroups_closure18.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getInstanceGroupManagers";
                    stringArray[1] = "getInstanceGroupManagers";
                    stringArray[2] = "getAt";
                    stringArray[3] = "setInstanceGroupManagers";
                    stringArray[4] = "getAt";
                    stringArray[5] = "addAll";
                    stringArray[6] = "getInstanceGroupManagers";
                    stringArray[7] = "getAt";
                    stringArray[8] = "getInstanceGroupManagers";
                    stringArray[9] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[10];
                    _queryAllManagedInstanceGroups_closure18.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_queryAllManagedInstanceGroups_closure18.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryAllManagedInstanceGroups_closure18.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[181].call((Object)aggregatedList, (Object)new _queryAllManagedInstanceGroups_closure18(GCEUtil.class, GCEUtil.class, fullAggregatedList));
        }
        Reference zonesInRegion = new Reference(callSiteArray[182].call((Object)((GoogleNamedAccountCredentials)((Object)credentials2.get())), (Object)((String)region2.get())));
        public final class _queryAllManagedInstanceGroups_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference zonesInRegion;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _queryAllManagedInstanceGroups_closure19(Object _outerInstance, Object _thisObject, Reference zonesInRegion, Reference region) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zonesInRegion = reference2 = zonesInRegion;
                this.region = reference = region;
            }

            public Object doCall(Object object, InstanceGroupManagersScopedList instanceGroupManagersScopedList) {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure19.$getCallSiteArray();
                public final class _closure104
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference zonesInRegion;
                    private /* synthetic */ Reference region;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure104(Object _outerInstance, Object _thisObject, Reference zonesInRegion, Reference region) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure104.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.zonesInRegion = reference2 = zonesInRegion;
                        this.region = reference = region;
                    }

                    public Object doCall(Object mig) {
                        CallSite[] callSiteArray = _closure104.$getCallSiteArray();
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(mig))) {
                            return ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].callStatic(GCEUtil.class, callSiteArray[2].callGetProperty(mig)), (Object)this.zonesInRegion.get()) ? mig : null;
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callStatic(GCEUtil.class, callSiteArray[4].callGetProperty(mig)), (Object)this.region.get()) ? mig : null;
                    }

                    @Generated
                    public Object getZonesInRegion() {
                        CallSite[] callSiteArray = _closure104.$getCallSiteArray();
                        return this.zonesInRegion.get();
                    }

                    @Generated
                    public String getRegion() {
                        CallSite[] callSiteArray = _closure104.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.region.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure104.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "zone";
                        stringArray[1] = "getLocalName";
                        stringArray[2] = "zone";
                        stringArray[3] = "getLocalName";
                        stringArray[4] = "region";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure104.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure104.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure104.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].callSafe(callSiteArray[1].call((Object)instanceGroupManagersScopedList), (Object)new _closure104((Object)this, this.getThisObject(), this.zonesInRegion, this.region));
            }

            public Object call(Object object, InstanceGroupManagersScopedList instanceGroupManagersScopedList) {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure19.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, object, (Object)instanceGroupManagersScopedList);
            }

            @Generated
            public Object getZonesInRegion() {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure19.$getCallSiteArray();
                return this.zonesInRegion.get();
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _queryAllManagedInstanceGroups_closure19.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _queryAllManagedInstanceGroups_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "findResults";
                stringArray[1] = "getInstanceGroupManagers";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _queryAllManagedInstanceGroups_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_queryAllManagedInstanceGroups_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _queryAllManagedInstanceGroups_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].call(callSiteArray[184].call((Object)((Map)fullAggregatedList.get()), (Object)new _queryAllManagedInstanceGroups_closure19(GCEUtil.class, GCEUtil.class, zonesInRegion, region2))), List.class);
    }

    public static GoogleServerGroup.View queryServerGroup(GoogleClusterProvider googleClusterProvider, String accountName, String region, String serverGroupName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object serverGroup = callSiteArray[185].call((Object)googleClusterProvider, (Object)accountName, (Object)region, (Object)serverGroupName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
            throw (Throwable)callSiteArray[186].callConstructor(GoogleResourceNotFoundException.class, (Object)new GStringImpl(new Object[]{serverGroupName, region}, new String[]{"Unable to locate server group ", " in ", "."}));
        }
        return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)serverGroup, GoogleServerGroup.View.class);
    }

    public static List<String> collectInstanceUrls(GoogleServerGroup.View serverGroup, List<String> instanceIds) {
        Reference instanceIds2 = new Reference(instanceIds);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _collectInstanceUrls_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceIds;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _collectInstanceUrls_closure20(Object _outerInstance, Object _thisObject, Reference instanceIds) {
                Reference reference;
                CallSite[] callSiteArray = _collectInstanceUrls_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instanceIds = reference = instanceIds;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _collectInstanceUrls_closure20.$getCallSiteArray();
                return callSiteArray[0].call(this.instanceIds.get(), callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public List getInstanceIds() {
                CallSite[] callSiteArray = _collectInstanceUrls_closure20.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.instanceIds.get(), List.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _collectInstanceUrls_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectInstanceUrls_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "instanceId";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _collectInstanceUrls_closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_collectInstanceUrls_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _collectInstanceUrls_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _collectInstanceUrls_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _collectInstanceUrls_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _collectInstanceUrls_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _collectInstanceUrls_closure21.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _collectInstanceUrls_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectInstanceUrls_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "selfLink";
                return new CallSiteArray(_collectInstanceUrls_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _collectInstanceUrls_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[187].call(callSiteArray[188].call(callSiteArray[189].callGroovyObjectGetProperty((Object)serverGroup), (Object)new _collectInstanceUrls_closure20(GCEUtil.class, GCEUtil.class, instanceIds2)), (Object)new _collectInstanceUrls_closure21(GCEUtil.class, GCEUtil.class)), List.class);
    }

    public static InstanceTemplate queryInstanceTemplate(String instanceTemplateName, GoogleNamedAccountCredentials credentials, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return (InstanceTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].call((Object)executor, callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].callGroovyObjectGetProperty((Object)credentials)), callSiteArray[194].callGroovyObjectGetProperty((Object)credentials), (Object)instanceTemplateName), (Object)"compute.instanceTemplates.get", callSiteArray[195].callGetProperty((Object)executor), callSiteArray[196].callGetProperty((Object)executor)), InstanceTemplate.class);
    }

    public static List<InstanceTemplate> queryAllInstanceTemplates(GoogleNamedAccountCredentials credentials, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[197].call(callSiteArray[198].call((Object)executor, callSiteArray[199].call(callSiteArray[200].call(callSiteArray[201].callGroovyObjectGetProperty((Object)credentials)), callSiteArray[202].callGroovyObjectGetProperty((Object)credentials)), (Object)"compute.instanceTemplates.list", callSiteArray[203].callGetProperty((Object)executor), callSiteArray[204].callGetProperty((Object)executor))), List.class);
    }

    public static BaseGoogleInstanceDescription buildInstanceDescriptionFromTemplate(String project, InstanceTemplate instanceTemplate) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference instanceTemplateProperties = new Reference(callSiteArray[205].callGetPropertySafe((Object)instanceTemplate));
        if (ScriptBytecodeAdapter.compareEqual((Object)instanceTemplateProperties.get(), null)) {
            throw (Throwable)callSiteArray[206].callConstructor(GoogleOperationException.class, callSiteArray[207].call((Object)"Unable to determine properties of instance template ", (Object)new GStringImpl(new Object[]{callSiteArray[208].callGetProperty((Object)instanceTemplate)}, new String[]{"", "."})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[209].callGetPropertySafe(callSiteArray[210].callGetProperty(instanceTemplateProperties.get())), (Object)1)) {
            throw (Throwable)callSiteArray[211].callConstructor(GoogleOperationException.class, callSiteArray[212].call((Object)"Instance templates must have exactly one network interface defined. ", (Object)new GStringImpl(new Object[]{callSiteArray[213].callGetProperty((Object)instanceTemplate), callSiteArray[214].callGetPropertySafe(callSiteArray[215].callGetProperty(instanceTemplateProperties.get()))}, new String[]{"Instance template ", " has ", "."})));
        }
        Object image = null;
        Object disks = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[216].callGetProperty(instanceTemplateProperties.get()))) {
            throw (Throwable)callSiteArray[224].callConstructor(GoogleOperationException.class, callSiteArray[225].call((Object)"Instance templates must have at least one disk defined. Instance template ", (Object)new GStringImpl(new Object[]{callSiteArray[226].callGetProperty((Object)instanceTemplate), callSiteArray[227].callGetPropertySafe(callSiteArray[228].callGetProperty(instanceTemplateProperties.get()))}, new String[]{"", " has ", "."})));
        }
        public final class _buildInstanceDescriptionFromTemplate_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInstanceDescriptionFromTemplate_closure22(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure22.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInstanceDescriptionFromTemplate_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "getBoot";
                return new CallSiteArray(_buildInstanceDescriptionFromTemplate_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInstanceDescriptionFromTemplate_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object bootDisk = callSiteArray[217].call(callSiteArray[218].callGetProperty(instanceTemplateProperties.get()), (Object)new _buildInstanceDescriptionFromTemplate_closure22(GCEUtil.class, GCEUtil.class));
        image = object2 = callSiteArray[219].callStatic(GCEUtil.class, callSiteArray[220].callGetPropertySafe(callSiteArray[221].callGetPropertySafe(bootDisk)));
        public final class _buildInstanceDescriptionFromTemplate_closure23
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceTemplateProperties;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInstanceDescriptionFromTemplate_closure23(Object _outerInstance, Object _thisObject, Reference instanceTemplateProperties) {
                Reference reference;
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instanceTemplateProperties = reference = instanceTemplateProperties;
            }

            public Object doCall(Object attachedDisk) {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure23.$getCallSiteArray();
                Object initializeParams = callSiteArray[0].callGetProperty(attachedDisk);
                return callSiteArray[1].callConstructor(GoogleDisk.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", callSiteArray[2].callGetProperty(initializeParams), "sizeGb", callSiteArray[3].callGetProperty(initializeParams), "autoDelete", callSiteArray[4].callGetProperty(attachedDisk), "labels", callSiteArray[5].callGetProperty(this.instanceTemplateProperties.get())}));
            }

            @Generated
            public Object getInstanceTemplateProperties() {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure23.$getCallSiteArray();
                return this.instanceTemplateProperties.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInstanceDescriptionFromTemplate_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "initializeParams";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "diskType";
                stringArray[3] = "diskSizeGb";
                stringArray[4] = "autoDelete";
                stringArray[5] = "labels";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _buildInstanceDescriptionFromTemplate_closure23.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildInstanceDescriptionFromTemplate_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInstanceDescriptionFromTemplate_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        disks = object = callSiteArray[222].call(callSiteArray[223].callGetProperty(instanceTemplateProperties.get()), (Object)new _buildInstanceDescriptionFromTemplate_closure23(GCEUtil.class, GCEUtil.class, instanceTemplateProperties));
        Object networkInterface = callSiteArray[229].call(callSiteArray[230].callGetProperty(instanceTemplateProperties.get()), (Object)0);
        Object serviceAccountEmail = callSiteArray[231].callGetPropertySafe(callSiteArray[232].callSafe(callSiteArray[233].callGetProperty(instanceTemplateProperties.get()), (Object)0));
        Object shieldedVmConfig = callSiteArray[234].callGetProperty(instanceTemplateProperties.get());
        public final class _buildInstanceDescriptionFromTemplate_closure24
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInstanceDescriptionFromTemplate_closure24(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure24.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(it), callSiteArray[1].callGetProperty(it)});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildInstanceDescriptionFromTemplate_closure24.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInstanceDescriptionFromTemplate_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _buildInstanceDescriptionFromTemplate_closure24.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildInstanceDescriptionFromTemplate_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInstanceDescriptionFromTemplate_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (BaseGoogleInstanceDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[235].callConstructor(BaseGoogleInstanceDescription.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", image, "instanceType", callSiteArray[236].callGetProperty(instanceTemplateProperties.get()), "minCpuPlatform", callSiteArray[237].callGetProperty(instanceTemplateProperties.get()), "disks", disks, "instanceMetadata", callSiteArray[238].callSafe(callSiteArray[239].callGetPropertySafe(callSiteArray[240].callGetProperty(instanceTemplateProperties.get())), (Object)new _buildInstanceDescriptionFromTemplate_closure24(GCEUtil.class, GCEUtil.class)), "tags", callSiteArray[241].callGetPropertySafe(callSiteArray[242].callGetProperty(instanceTemplateProperties.get())), "network", callSiteArray[243].call(Utils.class, (Object)project, callSiteArray[244].callGetProperty(networkInterface)), "subnet", callSiteArray[245].call(Utils.class, (Object)project, callSiteArray[246].callGetProperty(networkInterface)), "serviceAccountEmail", serviceAccountEmail, "authScopes", callSiteArray[247].callStatic(GCEUtil.class, serviceAccountEmail, callSiteArray[248].callGetProperty(instanceTemplateProperties.get())), "enableSecureBoot", callSiteArray[249].callGetPropertySafe(shieldedVmConfig), "enableVtpm", callSiteArray[250].callGetPropertySafe(shieldedVmConfig), "enableIntegrityMonitoring", callSiteArray[251].callGetPropertySafe(shieldedVmConfig)})), BaseGoogleInstanceDescription.class);
    }

    public static GoogleAutoHealingPolicy buildAutoHealingPolicyDescriptionFromAutoHealingPolicy(InstanceGroupManagerAutoHealingPolicy autoHealingPolicy) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)autoHealingPolicy)) {
            return (GoogleAutoHealingPolicy)ScriptBytecodeAdapter.castToType(null, GoogleAutoHealingPolicy.class);
        }
        return (GoogleAutoHealingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callConstructor(GoogleAutoHealingPolicy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", callSiteArray[253].call(Utils.class, callSiteArray[254].callGetProperty((Object)autoHealingPolicy)), "initialDelaySec", callSiteArray[255].callGetProperty((Object)autoHealingPolicy), "maxUnavailable", callSiteArray[256].callGetProperty((Object)autoHealingPolicy)})), GoogleAutoHealingPolicy.class);
    }

    public static List<String> retrieveScopesFromServiceAccount(String serviceAccountEmail, List<ServiceAccount> serviceAccounts) {
        Reference serviceAccountEmail2 = new Reference((Object)serviceAccountEmail);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _retrieveScopesFromServiceAccount_closure25
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serviceAccountEmail;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _retrieveScopesFromServiceAccount_closure25(Object _outerInstance, Object _thisObject, Reference serviceAccountEmail) {
                Reference reference;
                CallSite[] callSiteArray = _retrieveScopesFromServiceAccount_closure25.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serviceAccountEmail = reference = serviceAccountEmail;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _retrieveScopesFromServiceAccount_closure25.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.serviceAccountEmail.get());
            }

            @Generated
            public String getServiceAccountEmail() {
                CallSite[] callSiteArray = _retrieveScopesFromServiceAccount_closure25.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serviceAccountEmail.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _retrieveScopesFromServiceAccount_closure25.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _retrieveScopesFromServiceAccount_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "email";
                return new CallSiteArray(_retrieveScopesFromServiceAccount_closure25.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _retrieveScopesFromServiceAccount_closure25.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)((String)serviceAccountEmail2.get())) ? callSiteArray[257].callGetPropertySafe(callSiteArray[258].callSafe(serviceAccounts, (Object)new _retrieveScopesFromServiceAccount_closure25(GCEUtil.class, GCEUtil.class, serviceAccountEmail2))) : null, List.class);
    }

    public static String buildDiskTypeUrl(String projectName, String zone, GoogleDiskType diskType) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[259].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, zone, diskType}, new String[]{"", "/zones/", "/diskTypes/", ""})));
    }

    public static String buildZonalServerGroupUrl(String projectName, String zone, String serverGroupName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[260].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, zone, serverGroupName}, new String[]{"", "/zones/", "/instanceGroups/", ""})));
    }

    public static String buildCertificateUrl(String projectName, String certName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[261].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, certName}, new String[]{"", "/global/sslCertificates/", ""})));
    }

    public static String buildRegionalCertificateUrl(String projectName, String region, String certName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[262].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, region, certName}, new String[]{"", "/regions/", "/sslCertificates/", ""})));
    }

    public static String buildHttpHealthCheckUrl(String projectName, String healthCheckName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[263].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, healthCheckName}, new String[]{"", "/global/httpHealthChecks/", ""})));
    }

    public static String buildHttpsHealthCheckUrl(String projectName, String healthCheckName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[264].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, healthCheckName}, new String[]{"", "/global/httpsHealthChecks/", ""})));
    }

    public static String buildHealthCheckUrl(String projectName, String healthCheckName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[265].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, healthCheckName}, new String[]{"", "/global/healthChecks/", ""})));
    }

    public static String buildRegionalHealthCheckUrl(String projectName, String region, String healthCheckName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[266].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, region, healthCheckName}, new String[]{"", "/regions/", "/healthChecks/", ""})));
    }

    public static String buildInstanceTemplateUrl(String projectName, String templateName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[267].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, templateName}, new String[]{"", "/global/instanceTemplates/", ""})));
    }

    public static String buildBackendServiceUrl(String projectName, String backendServiceName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[268].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, backendServiceName}, new String[]{"", "/global/backendServices/", ""})));
    }

    public static String buildRegionBackendServiceUrl(String projectName, String region, String backendServiceName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[269].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, region, backendServiceName}, new String[]{"", "/regions/", "/backendServices/", ""})));
    }

    public static String buildRegionalServerGroupUrl(String projectName, String region, String serverGroupName) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[270].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, region, serverGroupName}, new String[]{"", "/regions/", "/instanceGroups/", ""})));
    }

    public static String buildZoneUrl(String projectName, String zone) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[271].call((Object)GCE_API_PREFIX, (Object)new GStringImpl(new Object[]{projectName, zone}, new String[]{"", "/zones/", ""})));
    }

    /*
     * WARNING - void declaration
     */
    public static List<AttachedDisk> buildAttachedDisks(BaseGoogleInstanceDescription description, String zone, boolean useDiskTypeUrl, GoogleConfiguration.DeployDefaults deployDefaults, Task task, String phase, String clouddriverUserAgentApplicationName, List<String> baseImageProjects, Image bootImage, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var1_1;
        Reference description2 = new Reference((Object)description);
        Reference zone2 = new Reference((Object)var1_1);
        Reference useDiskTypeUrl2 = new Reference((Object)useDiskTypeUrl);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference clouddriverUserAgentApplicationName2 = new Reference((Object)clouddriverUserAgentApplicationName);
        Reference baseImageProjects2 = new Reference(baseImageProjects);
        Reference bootImage2 = new Reference((Object)bootImage);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference credentials = new Reference(callSiteArray[272].callGroovyObjectGetProperty((Object)((BaseGoogleInstanceDescription)description2.get())));
        Object disks = callSiteArray[273].callGroovyObjectGetProperty((Object)((BaseGoogleInstanceDescription)description2.get()));
        Object instanceType = callSiteArray[274].callGroovyObjectGetProperty((Object)((BaseGoogleInstanceDescription)description2.get()));
        if (!DefaultTypeTransformation.booleanUnbox((Object)disks)) {
            Object object;
            disks = object = callSiteArray[275].callGetProperty(callSiteArray[276].call((Object)deployDefaults, instanceType));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)disks)) {
            throw (Throwable)callSiteArray[277].callConstructor(GoogleOperationException.class, (Object)new GStringImpl(new Object[]{instanceType}, new String[]{"Unable to determine disks for instance type ", "."}));
        }
        public final class _buildAttachedDisks_closure26
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildAttachedDisks_closure26(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure26.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure26.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure26.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildAttachedDisks_closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "isPersistent";
                return new CallSiteArray(_buildAttachedDisks_closure26.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildAttachedDisks_closure26.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _buildAttachedDisks_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference description;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildAttachedDisks_closure27(Object _outerInstance, Object _thisObject, Reference description) {
                Reference reference;
                CallSite[] callSiteArray = _buildAttachedDisks_closure27.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.description = reference = description;
            }

            public Object doCall(Object disk, Object i) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure27.$getCallSiteArray();
                Object object = callSiteArray[0].callGroovyObjectGetProperty(this.description.get());
                Object baseDeviceName = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "device";
                GStringImpl gStringImpl = new GStringImpl(new Object[]{baseDeviceName, i}, new String[]{"", "-", ""});
                ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)disk, (String)"deviceName");
                return gStringImpl;
            }

            public Object call(Object disk, Object i) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure27.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, disk, i);
            }

            @Generated
            public BaseGoogleInstanceDescription getDescription() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure27.$getCallSiteArray();
                return (BaseGoogleInstanceDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BaseGoogleInstanceDescription.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildAttachedDisks_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "baseDeviceName";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _buildAttachedDisks_closure27.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildAttachedDisks_closure27.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildAttachedDisks_closure27.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[278].call(callSiteArray[279].call(disks, (Object)new _buildAttachedDisks_closure26(GCEUtil.class, GCEUtil.class)), (Object)new _buildAttachedDisks_closure27(GCEUtil.class, GCEUtil.class, description2));
        public final class _buildAttachedDisks_closure28
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildAttachedDisks_closure28(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure28.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure28.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure28.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildAttachedDisks_closure28.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "persistent";
                return new CallSiteArray(_buildAttachedDisks_closure28.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildAttachedDisks_closure28.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference firstPersistentDisk = new Reference(callSiteArray[280].call(disks, (Object)new _buildAttachedDisks_closure28(GCEUtil.class, GCEUtil.class)));
        public final class _buildAttachedDisks_closure29
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference useDiskTypeUrl;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference zone;
            private /* synthetic */ Reference firstPersistentDisk;
            private /* synthetic */ Reference bootImage;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phase;
            private /* synthetic */ Reference clouddriverUserAgentApplicationName;
            private /* synthetic */ Reference baseImageProjects;
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference description;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildAttachedDisks_closure29(Object _outerInstance, Object _thisObject, Reference useDiskTypeUrl, Reference credentials, Reference zone, Reference firstPersistentDisk, Reference bootImage, Reference task, Reference phase, Reference clouddriverUserAgentApplicationName, Reference baseImageProjects, Reference executor, Reference description) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                Reference reference9;
                Reference reference10;
                Reference reference11;
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.useDiskTypeUrl = reference11 = useDiskTypeUrl;
                this.credentials = reference10 = credentials;
                this.zone = reference9 = zone;
                this.firstPersistentDisk = reference8 = firstPersistentDisk;
                this.bootImage = reference7 = bootImage;
                this.task = reference6 = task;
                this.phase = reference5 = phase;
                this.clouddriverUserAgentApplicationName = reference4 = clouddriverUserAgentApplicationName;
                this.baseImageProjects = reference3 = baseImageProjects;
                this.executor = reference2 = executor;
                this.description = reference = description;
            }

            public Object doCall(Object disk) {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                Object diskType = DefaultTypeTransformation.booleanUnbox((Object)this.useDiskTypeUrl.get()) ? callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty(this.credentials.get()), this.zone.get(), callSiteArray[2].callGetProperty(disk)) : callSiteArray[3].callGetProperty(disk);
                Object sourceImage = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(disk))) {
                    Object object;
                    sourceImage = object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(disk, this.firstPersistentDisk.get())) ? this.bootImage.get() : callSiteArray[6].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)callSiteArray[7].callGetProperty(disk), (Object)this.credentials.get(), (Object)this.task.get(), (Object)this.phase.get(), (Object)this.clouddriverUserAgentApplicationName.get(), (Object)this.baseImageProjects.get(), (Object)this.executor.get()));
                }
                if (DefaultTypeTransformation.booleanUnbox(sourceImage) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].callGetProperty(sourceImage), (Object)callSiteArray[9].callGetProperty(disk))) {
                    Object object = callSiteArray[10].callGetProperty(sourceImage);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)disk, (String)"sizeGb");
                }
                Object attachedDiskInitializeParams = callSiteArray[11].callConstructor(AttachedDiskInitializeParams.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceImage", callSiteArray[12].callGetPropertySafe(sourceImage), "diskSizeGb", callSiteArray[13].callGetProperty(disk), "diskType", diskType, "labels", callSiteArray[14].callGroovyObjectGetProperty(this.description.get())}));
                return callSiteArray[15].callConstructor(AttachedDisk.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"boot", callSiteArray[16].call(disk, this.firstPersistentDisk.get()), "autoDelete", callSiteArray[17].callGetProperty(disk), "deviceName", callSiteArray[18].callGetProperty(disk), "type", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callGetProperty(disk)) ? ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(_buildAttachedDisks_closure29.class, GCEUtil.class, (String)"DISK_TYPE_PERSISTENT")) : ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(_buildAttachedDisks_closure29.class, GCEUtil.class, (String)"DISK_TYPE_SCRATCH")), "initializeParams", attachedDiskInitializeParams}));
            }

            @Generated
            public boolean getUseDiskTypeUrl() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.useDiskTypeUrl.get());
            }

            @Generated
            public Object getCredentials() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return this.credentials.get();
            }

            @Generated
            public String getZone() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.zone.get());
            }

            @Generated
            public Object getFirstPersistentDisk() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return this.firstPersistentDisk.get();
            }

            @Generated
            public Image getBootImage() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return (Image)ScriptBytecodeAdapter.castToType((Object)this.bootImage.get(), Image.class);
            }

            @Generated
            public Task getTask() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
            }

            @Generated
            public String getPhase() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.phase.get());
            }

            @Generated
            public String getClouddriverUserAgentApplicationName() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.clouddriverUserAgentApplicationName.get());
            }

            @Generated
            public List getBaseImageProjects() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.baseImageProjects.get(), List.class);
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public BaseGoogleInstanceDescription getDescription() {
                CallSite[] callSiteArray = _buildAttachedDisks_closure29.$getCallSiteArray();
                return (BaseGoogleInstanceDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BaseGoogleInstanceDescription.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildAttachedDisks_closure29.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "buildDiskTypeUrl";
                stringArray[1] = "project";
                stringArray[2] = "type";
                stringArray[3] = "type";
                stringArray[4] = "persistent";
                stringArray[5] = "is";
                stringArray[6] = "queryImage";
                stringArray[7] = "sourceImage";
                stringArray[8] = "diskSizeGb";
                stringArray[9] = "sizeGb";
                stringArray[10] = "diskSizeGb";
                stringArray[11] = "<$constructor$>";
                stringArray[12] = "selfLink";
                stringArray[13] = "sizeGb";
                stringArray[14] = "labels";
                stringArray[15] = "<$constructor$>";
                stringArray[16] = "is";
                stringArray[17] = "autoDelete";
                stringArray[18] = "deviceName";
                stringArray[19] = "persistent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[20];
                _buildAttachedDisks_closure29.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildAttachedDisks_closure29.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildAttachedDisks_closure29.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[281].call(disks, (Object)new _buildAttachedDisks_closure29(GCEUtil.class, GCEUtil.class, useDiskTypeUrl2, credentials, zone2, firstPersistentDisk, bootImage2, task2, phase2, clouddriverUserAgentApplicationName2, baseImageProjects2, executor2, description2)), List.class);
    }

    public static NetworkInterface buildNetworkInterface(GoogleNetwork network, GoogleSubnet subnet, boolean associatePublicIpAddress, String accessConfigName, String accessConfigType) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        NetworkInterface networkInterface = (NetworkInterface)ScriptBytecodeAdapter.castToType((Object)callSiteArray[282].callConstructor(NetworkInterface.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"network", callSiteArray[283].callGroovyObjectGetProperty((Object)network), "subnetwork", DefaultTypeTransformation.booleanUnbox((Object)subnet) ? callSiteArray[284].callGroovyObjectGetProperty((Object)subnet) : null})), NetworkInterface.class);
        if (associatePublicIpAddress) {
            callSiteArray[285].call((Object)networkInterface, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[286].callConstructor(AccessConfig.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", accessConfigName, "type", accessConfigType}))}));
        }
        return networkInterface;
    }

    public static Metadata buildMetadataFromMap(Map<String, String> instanceMetadata) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object itemsList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (ScriptBytecodeAdapter.compareNotEqual(instanceMetadata, null)) {
            Object object;
            public final class _buildMetadataFromMap_closure30
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _buildMetadataFromMap_closure30(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _buildMetadataFromMap_closure30.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object key, Object value) {
                    CallSite[] callSiteArray = _buildMetadataFromMap_closure30.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(Metadata.Items.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", key, "value", value}));
                }

                public Object call(Object key, Object value) {
                    CallSite[] callSiteArray = _buildMetadataFromMap_closure30.$getCallSiteArray();
                    return callSiteArray[1].callCurrent((GroovyObject)this, key, value);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildMetadataFromMap_closure30.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _buildMetadataFromMap_closure30.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_buildMetadataFromMap_closure30.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _buildMetadataFromMap_closure30.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            itemsList = object = callSiteArray[287].call(instanceMetadata, (Object)new _buildMetadataFromMap_closure30(GCEUtil.class, GCEUtil.class));
        }
        return (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[288].callConstructor(Metadata.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"items", itemsList})), Metadata.class);
    }

    public static Map<String, String> buildMapFromMetadata(Metadata metadata) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _buildMapFromMetadata_closure31
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildMapFromMetadata_closure31(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildMapFromMetadata_closure31.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object metadataItems) {
                CallSite[] callSiteArray = _buildMapFromMetadata_closure31.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].callGetProperty(metadataItems), callSiteArray[1].callGetProperty(metadataItems)});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildMapFromMetadata_closure31.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _buildMapFromMetadata_closure31.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildMapFromMetadata_closure31.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildMapFromMetadata_closure31.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[289].callSafe(callSiteArray[290].callSafe((Object)metadata), (Object)new _buildMapFromMetadata_closure31(GCEUtil.class, GCEUtil.class)), Map.class);
        Map map2 = map;
        return DefaultTypeTransformation.booleanUnbox((Object)map2) ? map2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
    }

    public static Tags buildTagsFromList(List<String> tagsList) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return (Tags)ScriptBytecodeAdapter.castToType((Object)callSiteArray[291].callConstructor(Tags.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"items", tagsList})), Tags.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Autoscaler buildAutoscaler(String serverGroupName, String targetLink, GoogleAutoscalingPolicy autoscalingPolicy) {
        void var1_1;
        Reference serverGroupName2 = new Reference((Object)serverGroupName);
        Reference targetLink2 = new Reference((Object)var1_1);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _buildAutoscaler_closure32
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference targetLink;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildAutoscaler_closure32(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference targetLink) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _buildAutoscaler_closure32.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroupName = reference2 = serverGroupName;
                this.targetLink = reference = targetLink;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildAutoscaler_closure32.$getCallSiteArray();
                Object gceAutoscalingPolicy = callSiteArray[0].callConstructor(AutoscalingPolicy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"coolDownPeriodSec", callSiteArray[1].callGroovyObjectGetProperty((Object)this), "minNumReplicas", callSiteArray[2].callGroovyObjectGetProperty((Object)this), "maxNumReplicas", callSiteArray[3].callGroovyObjectGetProperty((Object)this), "mode", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this)) ? callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this)) : "ON"}));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGetProperty(callSiteArray[9].callGroovyObjectGetProperty((Object)this)))) {
                    Object object = callSiteArray[10].callConstructor(AutoscalingPolicyCpuUtilization.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"utilizationTarget", callSiteArray[11].callGetProperty(callSiteArray[12].callGroovyObjectGetProperty((Object)this)), "predictiveMethod", callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty((Object)this))}));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)gceAutoscalingPolicy, (String)"cpuUtilization");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetProperty(callSiteArray[17].callGroovyObjectGetProperty((Object)this)))) {
                    Object object = callSiteArray[18].callConstructor(AutoscalingPolicyLoadBalancingUtilization.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"utilizationTarget", callSiteArray[19].callGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)this))}));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)gceAutoscalingPolicy, (String)"loadBalancingUtilization");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGroovyObjectGetProperty((Object)this))) {
                    public final class _closure105
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure105(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure105.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure105.$getCallSiteArray();
                            return callSiteArray[0].callConstructor(AutoscalingPolicyCustomMetricUtilization.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"metric", callSiteArray[1].callGetProperty(it), "utilizationTarget", callSiteArray[2].callGetProperty(it), "utilizationTargetType", callSiteArray[3].callGetProperty(it), "filter", callSiteArray[4].callGetProperty(it), "singleInstanceAssignment", callSiteArray[5].callGetProperty(it)}));
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure105.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure105.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "<$constructor$>";
                            stringArray[1] = "metric";
                            stringArray[2] = "utilizationTarget";
                            stringArray[3] = "utilizationTargetType";
                            stringArray[4] = "filter";
                            stringArray[5] = "singleInstanceAssignment";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[6];
                            _closure105.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure105.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure105.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object = callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)new _closure105((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)gceAutoscalingPolicy, (String)"customMetricUtilizations");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].callGroovyObjectGetProperty((Object)this))) {
                    public final class _closure106
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure106(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure106.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object scalingSchedule) {
                            CallSite[] callSiteArray = _closure106.$getCallSiteArray();
                            return ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[0].callGetProperty(scalingSchedule), callSiteArray[1].callConstructor(AutoscalingPolicyScalingSchedule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", callSiteArray[2].callGetProperty(scalingSchedule), "disabled", !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGetProperty(scalingSchedule)), "durationSec", callSiteArray[4].callGetProperty(scalingSchedule), "minRequiredReplicas", callSiteArray[5].callGetProperty(scalingSchedule), "schedule", callSiteArray[6].callGetProperty(scalingSchedule), "timeZone", callSiteArray[7].callGetProperty(scalingSchedule)}))});
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure106.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "scheduleName";
                            stringArray[1] = "<$constructor$>";
                            stringArray[2] = "scheduleDescription";
                            stringArray[3] = "enabled";
                            stringArray[4] = "duration";
                            stringArray[5] = "minimumRequiredInstances";
                            stringArray[6] = "scheduleCron";
                            stringArray[7] = "timezone";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[8];
                            _closure106.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure106.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure106.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object = callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this), (Object)new _closure106((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)gceAutoscalingPolicy, (String)"scalingSchedules");
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].callGetProperty(callSiteArray[29].callGroovyObjectGetProperty((Object)this))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].callGetProperty(callSiteArray[31].callGroovyObjectGetProperty((Object)this)))) {
                    Object scaledInReplicasInput = callSiteArray[32].callGetProperty(callSiteArray[33].callGroovyObjectGetProperty((Object)this));
                    FixedOrPercent maxScaledInReplicas = null;
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)scaledInReplicasInput, null)) {
                        Object object = callSiteArray[34].callConstructor(FixedOrPercent.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fixed", callSiteArray[35].callGetProperty(scaledInReplicasInput), "percent", callSiteArray[36].callGetProperty(scaledInReplicasInput)}));
                        maxScaledInReplicas = (FixedOrPercent)ScriptBytecodeAdapter.castToType((Object)object, FixedOrPercent.class);
                    }
                    Object object = callSiteArray[37].callConstructor(AutoscalingPolicyScaleInControl.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"maxScaledInReplicas", maxScaledInReplicas, "timeWindowSec", callSiteArray[38].callGetProperty(callSiteArray[39].callGroovyObjectGetProperty((Object)this))}));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)gceAutoscalingPolicy, (String)"scaleInControl");
                }
                return callSiteArray[40].callConstructor(Autoscaler.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", this.serverGroupName.get(), "target", this.targetLink.get(), "autoscalingPolicy", gceAutoscalingPolicy}));
            }

            @Generated
            public String getServerGroupName() {
                CallSite[] callSiteArray = _buildAutoscaler_closure32.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            @Generated
            public String getTargetLink() {
                CallSite[] callSiteArray = _buildAutoscaler_closure32.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.targetLink.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildAutoscaler_closure32.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildAutoscaler_closure32.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "coolDownPeriodSec";
                stringArray[2] = "minNumReplicas";
                stringArray[3] = "maxNumReplicas";
                stringArray[4] = "mode";
                stringArray[5] = "toString";
                stringArray[6] = "mode";
                stringArray[7] = "cpuUtilization";
                stringArray[8] = "utilizationTarget";
                stringArray[9] = "cpuUtilization";
                stringArray[10] = "<$constructor$>";
                stringArray[11] = "utilizationTarget";
                stringArray[12] = "cpuUtilization";
                stringArray[13] = "predictiveMethod";
                stringArray[14] = "cpuUtilization";
                stringArray[15] = "loadBalancingUtilization";
                stringArray[16] = "utilizationTarget";
                stringArray[17] = "loadBalancingUtilization";
                stringArray[18] = "<$constructor$>";
                stringArray[19] = "utilizationTarget";
                stringArray[20] = "loadBalancingUtilization";
                stringArray[21] = "customMetricUtilizations";
                stringArray[22] = "collect";
                stringArray[23] = "customMetricUtilizations";
                stringArray[24] = "scalingSchedules";
                stringArray[25] = "collectEntries";
                stringArray[26] = "scalingSchedules";
                stringArray[27] = "scaleInControl";
                stringArray[28] = "maxScaledInReplicas";
                stringArray[29] = "scaleInControl";
                stringArray[30] = "timeWindowSec";
                stringArray[31] = "scaleInControl";
                stringArray[32] = "maxScaledInReplicas";
                stringArray[33] = "scaleInControl";
                stringArray[34] = "<$constructor$>";
                stringArray[35] = "fixed";
                stringArray[36] = "percent";
                stringArray[37] = "<$constructor$>";
                stringArray[38] = "timeWindowSec";
                stringArray[39] = "scaleInControl";
                stringArray[40] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[41];
                _buildAutoscaler_closure32.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildAutoscaler_closure32.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildAutoscaler_closure32.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Autoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[292].call((Object)autoscalingPolicy, (Object)new _buildAutoscaler_closure32(GCEUtil.class, GCEUtil.class, serverGroupName2, targetLink2)), Autoscaler.class);
    }

    public static void calibrateTargetSizeWithAutoscaler(BasicGoogleDeployDescription description) {
        Reference description2 = new Reference((Object)description);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _calibrateTargetSizeWithAutoscaler_closure33
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference description;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _calibrateTargetSizeWithAutoscaler_closure33(Object _outerInstance, Object _thisObject, Reference description) {
                Reference reference;
                CallSite[] callSiteArray = _calibrateTargetSizeWithAutoscaler_closure33.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.description = reference = description;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _calibrateTargetSizeWithAutoscaler_closure33.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[0].callGroovyObjectGetProperty(this.description.get()), (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this))) {
                    Object object = callSiteArray[2].callGroovyObjectGetProperty((Object)this);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _calibrateTargetSizeWithAutoscaler_closure33.class, (GroovyObject)this.description.get(), (String)"targetSize");
                    return object;
                }
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].callGroovyObjectGetProperty(this.description.get()), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this))) {
                    Object object = callSiteArray[5].callGroovyObjectGetProperty((Object)this);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _calibrateTargetSizeWithAutoscaler_closure33.class, (GroovyObject)this.description.get(), (String)"targetSize");
                    return object;
                }
                return null;
            }

            @Generated
            public BasicGoogleDeployDescription getDescription() {
                CallSite[] callSiteArray = _calibrateTargetSizeWithAutoscaler_closure33.$getCallSiteArray();
                return (BasicGoogleDeployDescription)ScriptBytecodeAdapter.castToType((Object)this.description.get(), BasicGoogleDeployDescription.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _calibrateTargetSizeWithAutoscaler_closure33.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calibrateTargetSizeWithAutoscaler_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "targetSize";
                stringArray[1] = "minNumReplicas";
                stringArray[2] = "minNumReplicas";
                stringArray[3] = "targetSize";
                stringArray[4] = "maxNumReplicas";
                stringArray[5] = "maxNumReplicas";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _calibrateTargetSizeWithAutoscaler_closure33.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_calibrateTargetSizeWithAutoscaler_closure33.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _calibrateTargetSizeWithAutoscaler_closure33.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[293].call(callSiteArray[294].callGroovyObjectGetProperty((Object)((BasicGoogleDeployDescription)description2.get())), (Object)new _calibrateTargetSizeWithAutoscaler_closure33(GCEUtil.class, GCEUtil.class, description2));
    }

    public static List<String> resolveAuthScopes(List<String> authScopes) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _resolveAuthScopes_closure34
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveAuthScopes_closure34(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _resolveAuthScopes_closure34.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object authScope) {
                CallSite[] callSiteArray = _resolveAuthScopes_closure34.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(authScope, (Object)"https://")) ? authScope : callSiteArray[1].call((Object)new GStringImpl(new Object[]{authScope}, new String[]{"https://www.googleapis.com/auth/", ""}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveAuthScopes_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _resolveAuthScopes_closure34.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveAuthScopes_closure34.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveAuthScopes_closure34.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[295].callSafe(authScopes, (Object)new _resolveAuthScopes_closure34(GCEUtil.class, GCEUtil.class)), List.class);
    }

    public static List<ServiceAccount> buildServiceAccount(String serviceAccountEmail, List<String> authScopes) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)serviceAccountEmail) && DefaultTypeTransformation.booleanUnbox(authScopes) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[296].callConstructor(ServiceAccount.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"email", serviceAccountEmail, "scopes", callSiteArray[297].callStatic(GCEUtil.class, authScopes)}))}) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public static ServiceAccount buildScheduling(BaseGoogleInstanceDescription description) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object scheduling = callSiteArray[298].callConstructor(Scheduling.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[299].callGroovyObjectGetProperty((Object)description), null)) {
            Object object = callSiteArray[300].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)scheduling, (String)"preemptible");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[301].callGroovyObjectGetProperty((Object)description), null)) {
            Object object = callSiteArray[302].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)scheduling, (String)"automaticRestart");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[303].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[304].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)scheduling, (String)"onHostMaintenance");
        }
        return (ServiceAccount)ScriptBytecodeAdapter.castToType((Object)scheduling, ServiceAccount.class);
    }

    public static ShieldedVmConfig buildShieldedVmConfig(BaseGoogleInstanceDescription description) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object shieldedVmConfig = callSiteArray[305].callConstructor(ShieldedVmConfig.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[306].callGroovyObjectGetProperty((Object)description), null)) {
            Object object = callSiteArray[307].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)shieldedVmConfig, (String)"enableSecureBoot");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[308].callGroovyObjectGetProperty((Object)description), null)) {
            Object object = callSiteArray[309].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)shieldedVmConfig, (String)"enableVtpm");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[310].callGroovyObjectGetProperty((Object)description), null)) {
            Object object = callSiteArray[311].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)shieldedVmConfig, (String)"enableIntegrityMonitoring");
        }
        return (ShieldedVmConfig)ScriptBytecodeAdapter.castToType((Object)shieldedVmConfig, ShieldedVmConfig.class);
    }

    public static void updateStatusAndThrowNotFoundException(String errorMsg, Task task, String phase) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[312].call((Object)task, (Object)phase, (Object)errorMsg);
        throw (Throwable)callSiteArray[313].callConstructor(GoogleResourceNotFoundException.class, (Object)errorMsg);
    }

    public static String getLocalName(String fullUrl) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            return fullUrl;
        }
        Object urlParts = callSiteArray[314].call((Object)fullUrl, (Object)"/");
        return ShortTypeHandling.castToString((Object)callSiteArray[315].call(urlParts, callSiteArray[316].call(callSiteArray[317].callGetProperty(urlParts), (Object)1)));
    }

    public static String deriveProjectId(String fullUrl) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            throw (Throwable)callSiteArray[318].callConstructor(IllegalArgumentException.class, (Object)"Attempting to derive project id from empty resource url.");
        }
        List urlParts = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[319].call((Object)fullUrl, (Object)"/"), List.class);
        int indexOfProjectsToken = DefaultTypeTransformation.intUnbox((Object)callSiteArray[320].call((Object)urlParts, (Object)"projects"));
        if (ScriptBytecodeAdapter.compareEqual((Object)indexOfProjectsToken, (Object)-1)) {
            throw (Throwable)callSiteArray[321].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Attempting to derive project id from resource url that does not contain 'projects': ", ""}));
        }
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[322].call((Object)urlParts, callSiteArray[323].call((Object)indexOfProjectsToken, (Object)1)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[324].call((Object)urlParts, (Object)(indexOfProjectsToken + 1)));
    }

    public static Object buildHttpHealthCheck(String name, UpsertGoogleLoadBalancerDescription.HealthCheck healthCheckDescription) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return callSiteArray[325].callConstructor(HttpHealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name, "checkIntervalSec", callSiteArray[326].callGroovyObjectGetProperty((Object)healthCheckDescription), "timeoutSec", callSiteArray[327].callGroovyObjectGetProperty((Object)healthCheckDescription), "healthyThreshold", callSiteArray[328].callGroovyObjectGetProperty((Object)healthCheckDescription), "unhealthyThreshold", callSiteArray[329].callGroovyObjectGetProperty((Object)healthCheckDescription), "port", callSiteArray[330].callGroovyObjectGetProperty((Object)healthCheckDescription), "requestPath", callSiteArray[331].callGroovyObjectGetProperty((Object)healthCheckDescription)}));
    }

    /*
     * WARNING - void declaration
     */
    public static void addInternalLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[332].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Reference region = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[333].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[334].callGetPropertySafe(callSiteArray[335].callGetPropertySafe(callSiteArray[336].callGetPropertySafe(callSiteArray[337].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
        Map metadataMap = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[338].callStatic(GCEUtil.class, (Object)instanceMetadata);
            metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
        }
        Object object = callSiteArray[339].callSafe(callSiteArray[340].callSafe((Object)metadataMap, (Object)REGIONAL_LOAD_BALANCER_NAMES), (Object)",");
        Object regionalLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _addInternalLoadBalancerBackends_closure35
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addInternalLoadBalancerBackends_closure35(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure35.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure35.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure35.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addInternalLoadBalancerBackends_closure35.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBalancerType";
                stringArray[1] = "INTERNAL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addInternalLoadBalancerBackends_closure35.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addInternalLoadBalancerBackends_closure35.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addInternalLoadBalancerBackends_closure35.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object internalLoadBalancersToAddTo = callSiteArray[341].call(callSiteArray[342].callStatic(GCEUtil.class, (Object)googleLoadBalancerProvider, regionalLoadBalancersInMetadata, (Object)((Task)task2.get()), (Object)((String)phase2.get())), (Object)new _addInternalLoadBalancerBackends_closure35(GCEUtil.class, GCEUtil.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)internalLoadBalancersToAddTo)) {
            Object object2;
            callSiteArray[343].call((Object)log, (Object)"Cache call missed for internal load balancer, making a call to GCP");
            List projectRegionalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[344].call(callSiteArray[345].call((Object)((GoogleExecutorTraits)executor2.get()), ArrayUtil.createArray((Object)callSiteArray[346].call(callSiteArray[347].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), (Object)((String)region.get())), (Object)"compute.forwardingRules.list", (Object)callSiteArray[348].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[349].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[350].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)((String)region.get())))), List.class);
            public final class _addInternalLoadBalancerBackends_closure36
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addInternalLoadBalancerBackends_closure36(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure36.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure36.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].callGetProperty(it), (Object)callSiteArray[2].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure36.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure36.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInternalLoadBalancerBackends_closure36.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "backendService";
                    stringArray[1] = "name";
                    stringArray[2] = "loadBalancers";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _addInternalLoadBalancerBackends_closure36.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addInternalLoadBalancerBackends_closure36.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addInternalLoadBalancerBackends_closure36.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            internalLoadBalancersToAddTo = object2 = callSiteArray[351].call((Object)projectRegionalForwardingRules, (Object)new _addInternalLoadBalancerBackends_closure36(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)internalLoadBalancersToAddTo)) {
            public final class _addInternalLoadBalancerBackends_closure37
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference serverGroup;
                private /* synthetic */ Reference serverGroupName;
                private /* synthetic */ Reference googleOperationPoller;
                private /* synthetic */ Reference task;
                private /* synthetic */ Reference phase;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addInternalLoadBalancerBackends_closure37(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference serverGroup, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference9 = executor;
                    this.compute = reference8 = compute;
                    this.project = reference7 = project;
                    this.region = reference6 = region;
                    this.serverGroup = reference5 = serverGroup;
                    this.serverGroupName = reference4 = serverGroupName;
                    this.googleOperationPoller = reference3 = googleOperationPoller;
                    this.task = reference2 = task;
                    this.phase = reference = phase;
                }

                public Object doCall(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    GoogleInternalLoadBalancer.View ilbView = (GoogleInternalLoadBalancer.View)ScriptBytecodeAdapter.asType((Object)loadBalancerView, GoogleInternalLoadBalancer.View.class);
                    Object backendServiceName = callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)ilbView));
                    BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[3].call(callSiteArray[4].call(this.compute.get()), this.project.get(), this.region.get(), backendServiceName), (Object)"compute.regionBackendServices", (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)callSiteArray[6].callGetProperty(this.executor.get()), (Object)callSiteArray[7].callGetProperty(this.executor.get()), (Object)this.region.get())), BackendService.class);
                    Backend backendToAdd = (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(Backend.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"balancingMode", "CONNECTION"})), Backend.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGroovyObjectGetProperty(this.serverGroup.get()))) {
                        callSiteArray[10].call((Object)backendToAdd, callSiteArray[11].callStatic(GCEUtil.class, this.project.get(), this.region.get(), this.serverGroupName.get()));
                    } else {
                        callSiteArray[12].call((Object)backendToAdd, callSiteArray[13].callStatic(GCEUtil.class, this.project.get(), callSiteArray[14].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[15].callGetProperty((Object)backendService), null)) {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)backendService, (String)"backends");
                    }
                    callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)backendService), (Object)backendToAdd);
                    Object updateOp = callSiteArray[18].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[19].call(callSiteArray[20].call(this.compute.get()), this.project.get(), this.region.get(), backendServiceName, (Object)backendService), (Object)"compute.regionBackendServices.update", (Object)callSiteArray[21].callGetProperty(this.executor.get()), (Object)callSiteArray[22].callGetProperty(this.executor.get()), (Object)callSiteArray[23].callGetProperty(this.executor.get()), (Object)this.region.get()));
                    callSiteArray[24].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)this.region.get(), (Object)callSiteArray[25].call(updateOp), null, (Object)this.task.get(), (Object)new GStringImpl(new Object[]{this.region.get()}, new String[]{"compute.", ".backendServices.update"}), (Object)this.phase.get()));
                    return callSiteArray[26].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Enabled backend for server group ", " in Internal load balancer backend service ", "."}));
                }

                public Object call(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return callSiteArray[27].callCurrent((GroovyObject)this, (Object)loadBalancerView);
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getRegion() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                @Generated
                public String getServerGroupName() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                }

                @Generated
                public GoogleOperationPoller getGoogleOperationPoller() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                }

                @Generated
                public Task getTask() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                @Generated
                public String getPhase() {
                    CallSite[] callSiteArray = _addInternalLoadBalancerBackends_closure37.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.phase.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInternalLoadBalancerBackends_closure37.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                    stringArray[2] = "timeExecute";
                    stringArray[3] = "get";
                    stringArray[4] = "regionBackendServices";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_REGIONAL";
                    stringArray[7] = "TAG_REGION";
                    stringArray[8] = "<$constructor$>";
                    stringArray[9] = "regional";
                    stringArray[10] = "setGroup";
                    stringArray[11] = "buildRegionalServerGroupUrl";
                    stringArray[12] = "setGroup";
                    stringArray[13] = "buildZonalServerGroupUrl";
                    stringArray[14] = "zone";
                    stringArray[15] = "backends";
                    stringArray[16] = "leftShift";
                    stringArray[17] = "backends";
                    stringArray[18] = "timeExecute";
                    stringArray[19] = "update";
                    stringArray[20] = "regionBackendServices";
                    stringArray[21] = "TAG_SCOPE";
                    stringArray[22] = "SCOPE_REGIONAL";
                    stringArray[23] = "TAG_REGION";
                    stringArray[24] = "waitForRegionalOperation";
                    stringArray[25] = "getName";
                    stringArray[26] = "updateStatus";
                    stringArray[27] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[28];
                    _addInternalLoadBalancerBackends_closure37.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addInternalLoadBalancerBackends_closure37.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addInternalLoadBalancerBackends_closure37.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[352].call(internalLoadBalancersToAddTo, (Object)new _addInternalLoadBalancerBackends_closure37(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region, serverGroup2, serverGroupName, googleOperationPoller2, task2, phase2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addHttpLoadBalancerBackends(Compute compute, ObjectMapper objectMapper, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[353].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[354].callGetPropertySafe(callSiteArray[355].callGetPropertySafe(callSiteArray[356].callGetPropertySafe(callSiteArray[357].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
        Map metadataMap = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[358].callStatic(GCEUtil.class, (Object)instanceMetadata);
            metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
        }
        Object object = callSiteArray[359].callSafe(callSiteArray[360].callSafe((Object)metadataMap, (Object)GLOBAL_LOAD_BALANCER_NAMES), (Object)",");
        Object httpLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object2 = callSiteArray[361].callSafe(callSiteArray[362].callSafe((Object)metadataMap, (Object)REGIONAL_LOAD_BALANCER_NAMES), (Object)",");
        Object networkLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List allFoundLoadBalancers = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[363].call(httpLoadBalancersInMetadata, networkLoadBalancersInMetadata), List.class);
        public final class _addHttpLoadBalancerBackends_closure38
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addHttpLoadBalancerBackends_closure38(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure38.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure38.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure38.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHttpLoadBalancerBackends_closure38.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBalancerType";
                stringArray[1] = "HTTP";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addHttpLoadBalancerBackends_closure38.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addHttpLoadBalancerBackends_closure38.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addHttpLoadBalancerBackends_closure38.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object httpLoadBalancersToAddTo = callSiteArray[364].call(callSiteArray[365].callStatic(GCEUtil.class, (Object)googleLoadBalancerProvider, (Object)allFoundLoadBalancers, (Object)((Task)task2.get()), (Object)((String)phase2.get())), (Object)new _addHttpLoadBalancerBackends_closure38(GCEUtil.class, GCEUtil.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)httpLoadBalancersToAddTo)) {
            Object object3;
            Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[366].call((Object)log)) ? callSiteArray[367].call((Object)log, (Object)new GStringImpl(new Object[]{httpLoadBalancersInMetadata}, new String[]{"Cache call missed for Http load balancers ", ", making a call to GCP"})) : null;
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[368].call(callSiteArray[369].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[370].call(callSiteArray[371].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules.list", callSiteArray[372].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[373].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _addHttpLoadBalancerBackends_closure39
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addHttpLoadBalancerBackends_closure39(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure39.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure39.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[3].callGetProperty(GoogleTargetProxyType.class), callSiteArray[4].callGetProperty(GoogleTargetProxyType.class)})) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[5].callGetProperty((Object)forwardingRule), (Object)callSiteArray[6].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure39.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[7].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure39.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addHttpLoadBalancerBackends_closure39.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "HTTP";
                    stringArray[4] = "HTTPS";
                    stringArray[5] = "name";
                    stringArray[6] = "loadBalancers";
                    stringArray[7] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _addHttpLoadBalancerBackends_closure39.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addHttpLoadBalancerBackends_closure39.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addHttpLoadBalancerBackends_closure39.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            httpLoadBalancersToAddTo = object3 = callSiteArray[374].call((Object)projectGlobalForwardingRules, (Object)new _addHttpLoadBalancerBackends_closure39(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)httpLoadBalancersToAddTo)) {
            String policyJson = ShortTypeHandling.castToString((Object)callSiteArray[375].callSafe((Object)metadataMap, (Object)LOAD_BALANCING_POLICY));
            if (!DefaultTypeTransformation.booleanUnbox((Object)policyJson)) {
                callSiteArray[376].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{(String)serverGroupName.get()}, new String[]{"Load Balancing Policy not found for server group ", ""}), (Object)((Task)task2.get()), (Object)((String)phase2.get()));
            }
            Reference policy = new Reference((Object)((GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[377].call((Object)objectMapper, (Object)policyJson, GoogleHttpLoadBalancingPolicy.class), GoogleHttpLoadBalancingPolicy.class)));
            Object object5 = callSiteArray[378].callSafe(callSiteArray[379].callSafe((Object)metadataMap, (Object)BACKEND_SERVICE_NAMES), (Object)",");
            List backendServiceNames = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)backendServiceNames)) {
                public final class _addHttpLoadBalancerBackends_closure40
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference policy;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference googleOperationPoller;
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference phase;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _addHttpLoadBalancerBackends_closure40(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference policy, Reference serverGroup, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference9 = executor;
                        this.compute = reference8 = compute;
                        this.project = reference7 = project;
                        this.policy = reference6 = policy;
                        this.serverGroup = reference5 = serverGroup;
                        this.serverGroupName = reference4 = serverGroupName;
                        this.googleOperationPoller = reference3 = googleOperationPoller;
                        this.task = reference2 = task;
                        this.phase = reference = phase;
                    }

                    public Object doCall(String backendServiceName) {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), (Object)backendServiceName), (Object)"compute.backendServices.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get())), BackendService.class);
                        Backend backendToAdd = (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callStatic(GCEUtil.class, this.policy.get()), Backend.class);
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGroovyObjectGetProperty(this.serverGroup.get()))) {
                            callSiteArray[7].call((Object)backendToAdd, callSiteArray[8].callStatic(GCEUtil.class, this.project.get(), callSiteArray[9].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                        } else {
                            callSiteArray[10].call((Object)backendToAdd, callSiteArray[11].callStatic(GCEUtil.class, this.project.get(), callSiteArray[12].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                        }
                        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[13].callGetProperty((Object)backendService), null)) {
                            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)backendService, (String)"backends");
                        }
                        callSiteArray[14].call(callSiteArray[15].callGetProperty((Object)backendService), (Object)backendToAdd);
                        Object updateOp = callSiteArray[16].call(this.executor.get(), callSiteArray[17].call(callSiteArray[18].call(this.compute.get()), this.project.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[19].callGetProperty(this.executor.get()), callSiteArray[20].callGetProperty(this.executor.get()));
                        callSiteArray[21].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[22].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                        return callSiteArray[23].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Enabled backend for server group ", " in Http(s) load balancer backend service ", "."}));
                    }

                    public Object call(String backendServiceName) {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[24].callCurrent((GroovyObject)this, (Object)backendServiceName);
                        }
                        return this.doCall(backendServiceName);
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public GoogleHttpLoadBalancingPolicy getPolicy() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)this.policy.get(), GoogleHttpLoadBalancingPolicy.class);
                    }

                    @Generated
                    public GoogleServerGroup.View getServerGroup() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                    }

                    @Generated
                    public String getServerGroupName() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                    }

                    @Generated
                    public GoogleOperationPoller getGoogleOperationPoller() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                    }

                    @Generated
                    public Task getTask() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                    }

                    @Generated
                    public String getPhase() {
                        CallSite[] callSiteArray = _addHttpLoadBalancerBackends_closure40.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.phase.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _addHttpLoadBalancerBackends_closure40.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "get";
                        stringArray[2] = "backendServices";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                        stringArray[5] = "backendFromLoadBalancingPolicy";
                        stringArray[6] = "regional";
                        stringArray[7] = "setGroup";
                        stringArray[8] = "buildRegionalServerGroupUrl";
                        stringArray[9] = "region";
                        stringArray[10] = "setGroup";
                        stringArray[11] = "buildZonalServerGroupUrl";
                        stringArray[12] = "zone";
                        stringArray[13] = "backends";
                        stringArray[14] = "leftShift";
                        stringArray[15] = "backends";
                        stringArray[16] = "timeExecute";
                        stringArray[17] = "update";
                        stringArray[18] = "backendServices";
                        stringArray[19] = "TAG_SCOPE";
                        stringArray[20] = "SCOPE_GLOBAL";
                        stringArray[21] = "waitForGlobalOperation";
                        stringArray[22] = "getName";
                        stringArray[23] = "updateStatus";
                        stringArray[24] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[25];
                        _addHttpLoadBalancerBackends_closure40.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_addHttpLoadBalancerBackends_closure40.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _addHttpLoadBalancerBackends_closure40.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[380].call((Object)backendServiceNames, (Object)new _addHttpLoadBalancerBackends_closure40(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, policy, serverGroup2, serverGroupName, googleOperationPoller2, task2, phase2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addInternalHttpLoadBalancerBackends(Compute compute, ObjectMapper objectMapper, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[381].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Reference region = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[382].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[383].callGetPropertySafe(callSiteArray[384].callGetPropertySafe(callSiteArray[385].callGetPropertySafe(callSiteArray[386].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
        Map metadataMap = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[387].callStatic(GCEUtil.class, (Object)instanceMetadata);
            metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
        }
        Object object = callSiteArray[388].callSafe(callSiteArray[389].callSafe((Object)metadataMap, (Object)REGIONAL_LOAD_BALANCER_NAMES), (Object)",");
        Object internalHttpLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _addInternalHttpLoadBalancerBackends_closure41
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addInternalHttpLoadBalancerBackends_closure41(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure41.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure41.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure41.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addInternalHttpLoadBalancerBackends_closure41.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBalancerType";
                stringArray[1] = "INTERNAL_MANAGED";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addInternalHttpLoadBalancerBackends_closure41.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addInternalHttpLoadBalancerBackends_closure41.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addInternalHttpLoadBalancerBackends_closure41.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object internalHttpLoadBalancersToAddTo = callSiteArray[390].call(callSiteArray[391].callStatic(GCEUtil.class, (Object)googleLoadBalancerProvider, internalHttpLoadBalancersInMetadata, (Object)((Task)task2.get()), (Object)((String)phase2.get())), (Object)new _addInternalHttpLoadBalancerBackends_closure41(GCEUtil.class, GCEUtil.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)internalHttpLoadBalancersToAddTo)) {
            Object object2;
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[392].call((Object)log)) ? callSiteArray[393].call((Object)log, (Object)new GStringImpl(new Object[]{internalHttpLoadBalancersInMetadata}, new String[]{"Cache call missed for Internal Http load balancers ", ", making a call to GCP"})) : null;
            List projectForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[394].call(callSiteArray[395].call((Object)((GoogleExecutorTraits)executor2.get()), ArrayUtil.createArray((Object)callSiteArray[396].call(callSiteArray[397].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), (Object)((String)region.get())), (Object)"compute.forwardingRules.list", (Object)callSiteArray[398].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[399].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[400].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)((String)region.get())))), List.class);
            public final class _addInternalHttpLoadBalancerBackends_closure42
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addInternalHttpLoadBalancerBackends_closure42(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure42.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure42.$getCallSiteArray();
                    return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty((Object)forwardingRule), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[3].call(Utils.class, callSiteArray[4].callGetProperty((Object)forwardingRule)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[5].callGetProperty(GoogleTargetProxyType.class), callSiteArray[6].callGetProperty(GoogleTargetProxyType.class)}));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure42.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[7].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure42.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInternalHttpLoadBalancerBackends_closure42.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "loadBalancers";
                    stringArray[2] = "target";
                    stringArray[3] = "getTargetProxyType";
                    stringArray[4] = "target";
                    stringArray[5] = "HTTP";
                    stringArray[6] = "HTTPS";
                    stringArray[7] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _addInternalHttpLoadBalancerBackends_closure42.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addInternalHttpLoadBalancerBackends_closure42.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addInternalHttpLoadBalancerBackends_closure42.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            internalHttpLoadBalancersToAddTo = object2 = callSiteArray[401].call((Object)projectForwardingRules, (Object)new _addInternalHttpLoadBalancerBackends_closure42(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)internalHttpLoadBalancersToAddTo)) {
            String policyJson = ShortTypeHandling.castToString((Object)callSiteArray[402].callSafe((Object)metadataMap, (Object)LOAD_BALANCING_POLICY));
            if (!DefaultTypeTransformation.booleanUnbox((Object)policyJson)) {
                callSiteArray[403].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{(String)serverGroupName.get()}, new String[]{"Load Balancing Policy not found for server group ", ""}), (Object)((Task)task2.get()), (Object)((String)phase2.get()));
            }
            Reference policy = new Reference((Object)((GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[404].call((Object)objectMapper, (Object)policyJson, GoogleHttpLoadBalancingPolicy.class), GoogleHttpLoadBalancingPolicy.class)));
            Object object4 = callSiteArray[405].callSafe(callSiteArray[406].callSafe((Object)metadataMap, (Object)REGION_BACKEND_SERVICE_NAMES), (Object)",");
            List backendServiceNames = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)backendServiceNames)) {
                public final class _addInternalHttpLoadBalancerBackends_closure43
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference policy;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference googleOperationPoller;
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference phase;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _addInternalHttpLoadBalancerBackends_closure43(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference policy, Reference serverGroup, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        Reference reference10;
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference10 = executor;
                        this.compute = reference9 = compute;
                        this.project = reference8 = project;
                        this.region = reference7 = region;
                        this.policy = reference6 = policy;
                        this.serverGroup = reference5 = serverGroup;
                        this.serverGroupName = reference4 = serverGroupName;
                        this.googleOperationPoller = reference3 = googleOperationPoller;
                        this.task = reference2 = task;
                        this.phase = reference = phase;
                    }

                    public Object doCall(String backendServiceName) {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName), (Object)"compute.regionBackendServices.get", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get())), BackendService.class);
                        Backend backendToAdd = (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callStatic(GCEUtil.class, this.policy.get()), Backend.class);
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty(this.serverGroup.get()))) {
                            callSiteArray[8].call((Object)backendToAdd, callSiteArray[9].callStatic(GCEUtil.class, this.project.get(), callSiteArray[10].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                        } else {
                            callSiteArray[11].call((Object)backendToAdd, callSiteArray[12].callStatic(GCEUtil.class, this.project.get(), callSiteArray[13].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                        }
                        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[14].callGetProperty((Object)backendService), null)) {
                            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)backendService, (String)"backends");
                        }
                        callSiteArray[15].call(callSiteArray[16].callGetProperty((Object)backendService), (Object)backendToAdd);
                        Object updateOp = callSiteArray[17].call(this.executor.get(), callSiteArray[18].call(callSiteArray[19].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.regionBackendServices.update", callSiteArray[20].callGetProperty(this.executor.get()), callSiteArray[21].callGetProperty(this.executor.get()));
                        callSiteArray[22].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[23].call(updateOp), null, (Object)this.task.get(), (Object)"compute.regionBackendService.update", (Object)this.phase.get()));
                        return callSiteArray[24].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Enabled backend for server group ", " in Internal Http(s) load balancer backend service ", "."}));
                    }

                    public Object call(String backendServiceName) {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[25].callCurrent((GroovyObject)this, (Object)backendServiceName);
                        }
                        return this.doCall(backendServiceName);
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getRegion() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.region.get());
                    }

                    @Generated
                    public GoogleHttpLoadBalancingPolicy getPolicy() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)this.policy.get(), GoogleHttpLoadBalancingPolicy.class);
                    }

                    @Generated
                    public GoogleServerGroup.View getServerGroup() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                    }

                    @Generated
                    public String getServerGroupName() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                    }

                    @Generated
                    public GoogleOperationPoller getGoogleOperationPoller() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                    }

                    @Generated
                    public Task getTask() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                    }

                    @Generated
                    public String getPhase() {
                        CallSite[] callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.phase.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _addInternalHttpLoadBalancerBackends_closure43.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "get";
                        stringArray[2] = "regionBackendServices";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_REGIONAL";
                        stringArray[5] = "TAG_REGION";
                        stringArray[6] = "backendFromLoadBalancingPolicy";
                        stringArray[7] = "regional";
                        stringArray[8] = "setGroup";
                        stringArray[9] = "buildRegionalServerGroupUrl";
                        stringArray[10] = "region";
                        stringArray[11] = "setGroup";
                        stringArray[12] = "buildZonalServerGroupUrl";
                        stringArray[13] = "zone";
                        stringArray[14] = "backends";
                        stringArray[15] = "leftShift";
                        stringArray[16] = "backends";
                        stringArray[17] = "timeExecute";
                        stringArray[18] = "update";
                        stringArray[19] = "regionBackendServices";
                        stringArray[20] = "TAG_SCOPE";
                        stringArray[21] = "SCOPE_REGIONAL";
                        stringArray[22] = "waitForGlobalOperation";
                        stringArray[23] = "getName";
                        stringArray[24] = "updateStatus";
                        stringArray[25] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[26];
                        _addInternalHttpLoadBalancerBackends_closure43.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_addInternalHttpLoadBalancerBackends_closure43.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _addInternalHttpLoadBalancerBackends_closure43.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[407].call((Object)backendServiceNames, (Object)new _addInternalHttpLoadBalancerBackends_closure43(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region, policy, serverGroup2, serverGroupName, googleOperationPoller2, task2, phase2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addSslLoadBalancerBackends(Compute compute, ObjectMapper objectMapper, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[408].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[409].callGetPropertySafe(callSiteArray[410].callGetPropertySafe(callSiteArray[411].callGetPropertySafe(callSiteArray[412].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
        Map metadataMap = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[413].callStatic(GCEUtil.class, (Object)instanceMetadata);
            metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
        }
        Object object = callSiteArray[414].callSafe(callSiteArray[415].callSafe((Object)metadataMap, (Object)GLOBAL_LOAD_BALANCER_NAMES), (Object)",");
        Object globalLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object2 = callSiteArray[416].callSafe(callSiteArray[417].callSafe((Object)metadataMap, (Object)REGIONAL_LOAD_BALANCER_NAMES), (Object)",");
        Object regionalLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List allFoundLoadBalancers = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[418].call(globalLoadBalancersInMetadata, regionalLoadBalancersInMetadata), List.class);
        public final class _addSslLoadBalancerBackends_closure44
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addSslLoadBalancerBackends_closure44(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure44.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure44.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure44.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addSslLoadBalancerBackends_closure44.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBalancerType";
                stringArray[1] = "SSL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addSslLoadBalancerBackends_closure44.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addSslLoadBalancerBackends_closure44.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addSslLoadBalancerBackends_closure44.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object sslLoadBalancersToAddTo = callSiteArray[419].call(callSiteArray[420].callStatic(GCEUtil.class, (Object)googleLoadBalancerProvider, (Object)allFoundLoadBalancers, (Object)((Task)task2.get()), (Object)((String)phase2.get())), (Object)new _addSslLoadBalancerBackends_closure44(GCEUtil.class, GCEUtil.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)sslLoadBalancersToAddTo)) {
            Object object3;
            callSiteArray[421].call((Object)log, (Object)"Cache call missed for ssl load balancer, making a call to GCP");
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[422].call(callSiteArray[423].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[424].call(callSiteArray[425].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules", callSiteArray[426].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[427].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _addSslLoadBalancerBackends_closure45
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addSslLoadBalancerBackends_closure45(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure45.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure45.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)callSiteArray[3].callGetProperty(GoogleTargetProxyType.class)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[4].callGetProperty((Object)forwardingRule), (Object)callSiteArray[5].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure45.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[6].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure45.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addSslLoadBalancerBackends_closure45.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "SSL";
                    stringArray[4] = "name";
                    stringArray[5] = "loadBalancers";
                    stringArray[6] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _addSslLoadBalancerBackends_closure45.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addSslLoadBalancerBackends_closure45.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addSslLoadBalancerBackends_closure45.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            sslLoadBalancersToAddTo = object3 = callSiteArray[428].call((Object)projectGlobalForwardingRules, (Object)new _addSslLoadBalancerBackends_closure45(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)sslLoadBalancersToAddTo)) {
            String policyJson = ShortTypeHandling.castToString((Object)callSiteArray[429].callSafe((Object)metadataMap, (Object)LOAD_BALANCING_POLICY));
            if (!DefaultTypeTransformation.booleanUnbox((Object)policyJson)) {
                callSiteArray[430].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{(String)serverGroupName.get()}, new String[]{"Load Balancing Policy not found for server group ", ""}), (Object)((Task)task2.get()), (Object)((String)phase2.get()));
            }
            Reference policy = new Reference((Object)((GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[431].call((Object)objectMapper, (Object)policyJson, GoogleHttpLoadBalancingPolicy.class), GoogleHttpLoadBalancingPolicy.class)));
            public final class _addSslLoadBalancerBackends_closure46
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference policy;
                private /* synthetic */ Reference serverGroup;
                private /* synthetic */ Reference serverGroupName;
                private /* synthetic */ Reference googleOperationPoller;
                private /* synthetic */ Reference task;
                private /* synthetic */ Reference phase;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addSslLoadBalancerBackends_closure46(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference policy, Reference serverGroup, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference9 = executor;
                    this.compute = reference8 = compute;
                    this.project = reference7 = project;
                    this.policy = reference6 = policy;
                    this.serverGroup = reference5 = serverGroup;
                    this.serverGroupName = reference4 = serverGroupName;
                    this.googleOperationPoller = reference3 = googleOperationPoller;
                    this.task = reference2 = task;
                    this.phase = reference = phase;
                }

                public Object doCall(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    GoogleSslLoadBalancer.View sslView = (GoogleSslLoadBalancer.View)ScriptBytecodeAdapter.asType((Object)loadBalancerView, GoogleSslLoadBalancer.View.class);
                    String backendServiceName = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)sslView)));
                    BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(this.executor.get(), callSiteArray[3].call(callSiteArray[4].call(this.compute.get()), this.project.get(), (Object)backendServiceName), (Object)"compute.backendServices", callSiteArray[5].callGetProperty(this.executor.get()), callSiteArray[6].callGetProperty(this.executor.get())), BackendService.class);
                    Backend backendToAdd = (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callStatic(GCEUtil.class, this.policy.get()), Backend.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGroovyObjectGetProperty(this.serverGroup.get()))) {
                        callSiteArray[9].call((Object)backendToAdd, callSiteArray[10].callStatic(GCEUtil.class, this.project.get(), callSiteArray[11].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                    } else {
                        callSiteArray[12].call((Object)backendToAdd, callSiteArray[13].callStatic(GCEUtil.class, this.project.get(), callSiteArray[14].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[15].callGetProperty((Object)backendService), null)) {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)backendService, (String)"backends");
                    }
                    callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)backendService), (Object)backendToAdd);
                    Object updateOp = callSiteArray[18].call(this.executor.get(), callSiteArray[19].call(callSiteArray[20].call(this.compute.get()), this.project.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[21].callGetProperty(this.executor.get()), callSiteArray[22].callGetProperty(this.executor.get()));
                    callSiteArray[23].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[24].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                    return callSiteArray[25].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Enabled backend for server group ", " in ssl load balancer backend service ", "."}));
                }

                public Object call(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return callSiteArray[26].callCurrent((GroovyObject)this, (Object)loadBalancerView);
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public GoogleHttpLoadBalancingPolicy getPolicy() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)this.policy.get(), GoogleHttpLoadBalancingPolicy.class);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                @Generated
                public String getServerGroupName() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                }

                @Generated
                public GoogleOperationPoller getGoogleOperationPoller() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                }

                @Generated
                public Task getTask() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                @Generated
                public String getPhase() {
                    CallSite[] callSiteArray = _addSslLoadBalancerBackends_closure46.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.phase.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addSslLoadBalancerBackends_closure46.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                    stringArray[2] = "timeExecute";
                    stringArray[3] = "get";
                    stringArray[4] = "backendServices";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_GLOBAL";
                    stringArray[7] = "backendFromLoadBalancingPolicy";
                    stringArray[8] = "regional";
                    stringArray[9] = "setGroup";
                    stringArray[10] = "buildRegionalServerGroupUrl";
                    stringArray[11] = "region";
                    stringArray[12] = "setGroup";
                    stringArray[13] = "buildZonalServerGroupUrl";
                    stringArray[14] = "zone";
                    stringArray[15] = "backends";
                    stringArray[16] = "leftShift";
                    stringArray[17] = "backends";
                    stringArray[18] = "timeExecute";
                    stringArray[19] = "update";
                    stringArray[20] = "backendServices";
                    stringArray[21] = "TAG_SCOPE";
                    stringArray[22] = "SCOPE_GLOBAL";
                    stringArray[23] = "waitForGlobalOperation";
                    stringArray[24] = "getName";
                    stringArray[25] = "updateStatus";
                    stringArray[26] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[27];
                    _addSslLoadBalancerBackends_closure46.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addSslLoadBalancerBackends_closure46.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addSslLoadBalancerBackends_closure46.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[432].call(sslLoadBalancersToAddTo, (Object)new _addSslLoadBalancerBackends_closure46(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, policy, serverGroup2, serverGroupName, googleOperationPoller2, task2, phase2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addTcpLoadBalancerBackends(Compute compute, ObjectMapper objectMapper, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[433].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get()))));
        Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[434].callGetPropertySafe(callSiteArray[435].callGetPropertySafe(callSiteArray[436].callGetPropertySafe(callSiteArray[437].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
        Map metadataMap = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[438].callStatic(GCEUtil.class, (Object)instanceMetadata);
            metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Map map;
            metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
        }
        Object object = callSiteArray[439].callSafe(callSiteArray[440].callSafe((Object)metadataMap, (Object)GLOBAL_LOAD_BALANCER_NAMES), (Object)",");
        Object globalLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object2 = callSiteArray[441].callSafe(callSiteArray[442].callSafe((Object)metadataMap, (Object)REGIONAL_LOAD_BALANCER_NAMES), (Object)",");
        Object regionalLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List allFoundLoadBalancers = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[443].call(globalLoadBalancersInMetadata, regionalLoadBalancersInMetadata), List.class);
        public final class _addTcpLoadBalancerBackends_closure47
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addTcpLoadBalancerBackends_closure47(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure47.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure47.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure47.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addTcpLoadBalancerBackends_closure47.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "loadBalancerType";
                stringArray[1] = "TCP";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _addTcpLoadBalancerBackends_closure47.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_addTcpLoadBalancerBackends_closure47.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addTcpLoadBalancerBackends_closure47.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object tcpLoadBalancersToAddTo = callSiteArray[444].call(callSiteArray[445].callStatic(GCEUtil.class, (Object)googleLoadBalancerProvider, (Object)allFoundLoadBalancers, (Object)((Task)task2.get()), (Object)((String)phase2.get())), (Object)new _addTcpLoadBalancerBackends_closure47(GCEUtil.class, GCEUtil.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)tcpLoadBalancersToAddTo)) {
            Object object3;
            callSiteArray[446].call((Object)log, (Object)"Cache call missed for tcp load balancer, making a call to GCP");
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[447].call(callSiteArray[448].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[449].call(callSiteArray[450].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules", callSiteArray[451].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[452].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _addTcpLoadBalancerBackends_closure48
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addTcpLoadBalancerBackends_closure48(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure48.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure48.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)callSiteArray[3].callGetProperty(GoogleTargetProxyType.class)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[4].callGetProperty((Object)forwardingRule), (Object)callSiteArray[5].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure48.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[6].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure48.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addTcpLoadBalancerBackends_closure48.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "TCP";
                    stringArray[4] = "name";
                    stringArray[5] = "loadBalancers";
                    stringArray[6] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _addTcpLoadBalancerBackends_closure48.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addTcpLoadBalancerBackends_closure48.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addTcpLoadBalancerBackends_closure48.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            tcpLoadBalancersToAddTo = object3 = callSiteArray[453].call((Object)projectGlobalForwardingRules, (Object)new _addTcpLoadBalancerBackends_closure48(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)tcpLoadBalancersToAddTo)) {
            String policyJson = ShortTypeHandling.castToString((Object)callSiteArray[454].callSafe((Object)metadataMap, (Object)LOAD_BALANCING_POLICY));
            if (!DefaultTypeTransformation.booleanUnbox((Object)policyJson)) {
                callSiteArray[455].callStatic(GCEUtil.class, (Object)new GStringImpl(new Object[]{(String)serverGroupName.get()}, new String[]{"Load Balancing Policy not found for server group ", ""}), (Object)((Task)task2.get()), (Object)((String)phase2.get()));
            }
            Reference policy = new Reference((Object)((GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[456].call((Object)objectMapper, (Object)policyJson, GoogleHttpLoadBalancingPolicy.class), GoogleHttpLoadBalancingPolicy.class)));
            public final class _addTcpLoadBalancerBackends_closure49
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference policy;
                private /* synthetic */ Reference serverGroup;
                private /* synthetic */ Reference serverGroupName;
                private /* synthetic */ Reference googleOperationPoller;
                private /* synthetic */ Reference task;
                private /* synthetic */ Reference phase;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addTcpLoadBalancerBackends_closure49(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference policy, Reference serverGroup, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference9 = executor;
                    this.compute = reference8 = compute;
                    this.project = reference7 = project;
                    this.policy = reference6 = policy;
                    this.serverGroup = reference5 = serverGroup;
                    this.serverGroupName = reference4 = serverGroupName;
                    this.googleOperationPoller = reference3 = googleOperationPoller;
                    this.task = reference2 = task;
                    this.phase = reference = phase;
                }

                public Object doCall(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    GoogleTcpLoadBalancer.View tcpView = (GoogleTcpLoadBalancer.View)ScriptBytecodeAdapter.asType((Object)loadBalancerView, GoogleTcpLoadBalancer.View.class);
                    String backendServiceName = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)tcpView)));
                    BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(this.executor.get(), callSiteArray[3].call(callSiteArray[4].call(this.compute.get()), this.project.get(), (Object)backendServiceName), (Object)"compute.backendServices", callSiteArray[5].callGetProperty(this.executor.get()), callSiteArray[6].callGetProperty(this.executor.get())), BackendService.class);
                    Backend backendToAdd = (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callStatic(GCEUtil.class, this.policy.get()), Backend.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGroovyObjectGetProperty(this.serverGroup.get()))) {
                        callSiteArray[9].call((Object)backendToAdd, callSiteArray[10].callStatic(GCEUtil.class, this.project.get(), callSiteArray[11].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                    } else {
                        callSiteArray[12].call((Object)backendToAdd, callSiteArray[13].callStatic(GCEUtil.class, this.project.get(), callSiteArray[14].callGroovyObjectGetProperty(this.serverGroup.get()), this.serverGroupName.get()));
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[15].callGetProperty((Object)backendService), null)) {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)backendService, (String)"backends");
                    }
                    callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)backendService), (Object)backendToAdd);
                    Object updateOp = callSiteArray[18].call(this.executor.get(), callSiteArray[19].call(callSiteArray[20].call(this.compute.get()), this.project.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[21].callGetProperty(this.executor.get()), callSiteArray[22].callGetProperty(this.executor.get()));
                    callSiteArray[23].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[24].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                    return callSiteArray[25].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Enabled backend for server group ", " in tcp load balancer backend service ", "."}));
                }

                public Object call(GoogleLoadBalancerView loadBalancerView) {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return callSiteArray[26].callCurrent((GroovyObject)this, (Object)loadBalancerView);
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public GoogleHttpLoadBalancingPolicy getPolicy() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)this.policy.get(), GoogleHttpLoadBalancingPolicy.class);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                @Generated
                public String getServerGroupName() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                }

                @Generated
                public GoogleOperationPoller getGoogleOperationPoller() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                }

                @Generated
                public Task getTask() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                @Generated
                public String getPhase() {
                    CallSite[] callSiteArray = _addTcpLoadBalancerBackends_closure49.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.phase.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addTcpLoadBalancerBackends_closure49.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                    stringArray[2] = "timeExecute";
                    stringArray[3] = "get";
                    stringArray[4] = "backendServices";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_GLOBAL";
                    stringArray[7] = "backendFromLoadBalancingPolicy";
                    stringArray[8] = "regional";
                    stringArray[9] = "setGroup";
                    stringArray[10] = "buildRegionalServerGroupUrl";
                    stringArray[11] = "region";
                    stringArray[12] = "setGroup";
                    stringArray[13] = "buildZonalServerGroupUrl";
                    stringArray[14] = "zone";
                    stringArray[15] = "backends";
                    stringArray[16] = "leftShift";
                    stringArray[17] = "backends";
                    stringArray[18] = "timeExecute";
                    stringArray[19] = "update";
                    stringArray[20] = "backendServices";
                    stringArray[21] = "TAG_SCOPE";
                    stringArray[22] = "SCOPE_GLOBAL";
                    stringArray[23] = "waitForGlobalOperation";
                    stringArray[24] = "getName";
                    stringArray[25] = "updateStatus";
                    stringArray[26] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[27];
                    _addTcpLoadBalancerBackends_closure49.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addTcpLoadBalancerBackends_closure49.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addTcpLoadBalancerBackends_closure49.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[457].call(tcpLoadBalancersToAddTo, (Object)new _addTcpLoadBalancerBackends_closure49(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, policy, serverGroup2, serverGroupName, googleOperationPoller2, task2, phase2));
        }
    }

    public static Backend backendFromLoadBalancingPolicy(GoogleHttpLoadBalancingPolicy policy) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object balancingMode = callSiteArray[458].callGroovyObjectGetProperty((Object)policy);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[459].callConstructor(Backend.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"balancingMode", balancingMode, "maxRatePerInstance", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[460].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) || ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[461].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[462].callGroovyObjectGetProperty((Object)policy) : null, "maxUtilization", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[463].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[464].callGroovyObjectGetProperty((Object)policy) : null, "maxConnectionsPerInstance", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[465].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[466].callGroovyObjectGetProperty((Object)policy) : null, "capacityScaler", ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[467].callGroovyObjectGetProperty((Object)policy), null) ? callSiteArray[468].callGroovyObjectGetProperty((Object)policy) : $const$0})), Backend.class);
        }
        return (Backend)ScriptBytecodeAdapter.castToType((Object)callSiteArray[469].callConstructor(Backend.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"balancingMode", balancingMode, "maxRatePerInstance", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[470].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) || ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[471].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[472].callGroovyObjectGetProperty((Object)policy) : null, "maxUtilization", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[473].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[474].callGroovyObjectGetProperty((Object)policy) : null, "maxConnectionsPerInstance", ScriptBytecodeAdapter.compareEqual((Object)balancingMode, (Object)callSiteArray[475].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[476].callGroovyObjectGetProperty((Object)policy) : null, "capacityScaler", ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[477].callGroovyObjectGetProperty((Object)policy), null) ? callSiteArray[478].callGroovyObjectGetProperty((Object)policy) : $const$0})), Backend.class);
    }

    public static void updateMetadataWithLoadBalancingPolicy(GoogleHttpLoadBalancingPolicy policy, Map instanceMetadata, ObjectMapper objectMapper) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[479].callGroovyObjectGetProperty((Object)policy))) {
            callSiteArray[480].call((Object)log, (Object)"Translated old load balancer instance metadata entry to new format");
            callSiteArray[481].call((Object)policy, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[482].callConstructor(NamedPort.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[483].callGetProperty(GoogleHttpLoadBalancingPolicy.class), "port", callSiteArray[484].callGroovyObjectGetProperty((Object)policy)}))}));
            Object var4_4 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var4_4, GCEUtil.class, (GroovyObject)policy, (String)"listeningPort");
        }
        Object object = callSiteArray[485].call((Object)objectMapper, (Object)policy);
        callSiteArray[486].call((Object)instanceMetadata, (Object)LOAD_BALANCING_POLICY, object);
    }

    public static GoogleHttpLoadBalancingPolicy loadBalancingPolicyFromBackend(Backend backend) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object backendBalancingMode = callSiteArray[487].call(GoogleLoadBalancingPolicy.BalancingMode.class, callSiteArray[488].callGetProperty((Object)backend));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[489].callConstructor(GoogleHttpLoadBalancingPolicy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"balancingMode", backendBalancingMode, "maxRatePerInstance", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[490].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) || ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[491].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[492].callGetProperty((Object)backend) : null, "maxUtilization", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[493].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[494].callGetProperty((Object)backend) : null, "maxConnectionsPerInstance", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[495].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[496].callGetProperty((Object)backend) : null, "capacityScaler", callSiteArray[497].callGetProperty((Object)backend)})), GoogleHttpLoadBalancingPolicy.class);
        }
        return (GoogleHttpLoadBalancingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[498].callConstructor(GoogleHttpLoadBalancingPolicy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"balancingMode", backendBalancingMode, "maxRatePerInstance", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[499].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) || ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[500].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[501].callGetProperty((Object)backend) : null, "maxUtilization", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[502].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[503].callGetProperty((Object)backend) : null, "maxConnectionsPerInstance", ScriptBytecodeAdapter.compareEqual((Object)backendBalancingMode, (Object)callSiteArray[504].callGetProperty(GoogleLoadBalancingPolicy.BalancingMode.class)) ? callSiteArray[505].callGetProperty((Object)backend) : null, "capacityScaler", callSiteArray[506].callGetProperty((Object)backend)})), GoogleHttpLoadBalancingPolicy.class);
    }

    /*
     * WARNING - void declaration
     */
    public static void destroySslLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference(callSiteArray[507].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Reference region = new Reference(callSiteArray[508].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        public final class _destroySslLoadBalancerBackends_closure50
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroySslLoadBalancerBackends_closure50(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure50.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure50.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure50.$getCallSiteArray();
                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure50.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure50.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "loadBalancers";
                stringArray[2] = "loadBalancerType";
                stringArray[3] = "SSL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _destroySslLoadBalancerBackends_closure50.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroySslLoadBalancerBackends_closure50.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroySslLoadBalancerBackends_closure50.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundSslLoadBalancers = callSiteArray[509].call(callSiteArray[510].call((Object)googleLoadBalancerProvider, (Object)""), (Object)new _destroySslLoadBalancerBackends_closure50(GCEUtil.class, GCEUtil.class, serverGroup2));
        List backendServicesToDeleteFrom = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)foundSslLoadBalancers)) {
            public final class _destroySslLoadBalancerBackends_closure51
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroySslLoadBalancerBackends_closure51(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure51.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object lb) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure51.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(lb));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure51.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _destroySslLoadBalancerBackends_closure51.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroySslLoadBalancerBackends_closure51.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroySslLoadBalancerBackends_closure51.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[511].call(foundSslLoadBalancers, (Object)new _destroySslLoadBalancerBackends_closure51(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            callSiteArray[512].call((Object)log, (Object)"Cache call missed for ssl load balancer, making a call to GCP");
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[513].call(callSiteArray[514].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[515].call(callSiteArray[516].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules.list", callSiteArray[517].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[518].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            List projectSslProxies = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[519].call(callSiteArray[520].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[521].call(callSiteArray[522].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.targetSslProxies.list", callSiteArray[523].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[524].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _destroySslLoadBalancerBackends_closure52
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroySslLoadBalancerBackends_closure52(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure52.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure52.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)callSiteArray[3].callGetProperty(GoogleTargetProxyType.class)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[4].callGetProperty((Object)forwardingRule), (Object)callSiteArray[5].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure52.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[6].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure52.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure52.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "SSL";
                    stringArray[4] = "name";
                    stringArray[5] = "loadBalancers";
                    stringArray[6] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _destroySslLoadBalancerBackends_closure52.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroySslLoadBalancerBackends_closure52.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroySslLoadBalancerBackends_closure52.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _destroySslLoadBalancerBackends_closure53
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroySslLoadBalancerBackends_closure53(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure53.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure53.$getCallSiteArray();
                    return callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)forwardingRule));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure53.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure53.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "target";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _destroySslLoadBalancerBackends_closure53.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroySslLoadBalancerBackends_closure53.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroySslLoadBalancerBackends_closure53.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Reference matchingSslProxyNames = new Reference(callSiteArray[525].call(callSiteArray[526].call((Object)projectGlobalForwardingRules, (Object)new _destroySslLoadBalancerBackends_closure52(GCEUtil.class, GCEUtil.class, serverGroup2)), (Object)new _destroySslLoadBalancerBackends_closure53(GCEUtil.class, GCEUtil.class)));
            public final class _destroySslLoadBalancerBackends_closure54
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference matchingSslProxyNames;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroySslLoadBalancerBackends_closure54(Object _outerInstance, Object _thisObject, Reference matchingSslProxyNames) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure54.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.matchingSslProxyNames = reference = matchingSslProxyNames;
                }

                public Object doCall(TargetSslProxy proxy) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure54.$getCallSiteArray();
                    return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].call((Object)proxy), (Object)this.matchingSslProxyNames.get());
                }

                public Object call(TargetSslProxy proxy) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure54.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)proxy);
                    }
                    return this.doCall(proxy);
                }

                @Generated
                public Object getMatchingSslProxyNames() {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure54.$getCallSiteArray();
                    return this.matchingSslProxyNames.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure54.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getName";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _destroySslLoadBalancerBackends_closure54.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroySslLoadBalancerBackends_closure54.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroySslLoadBalancerBackends_closure54.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _destroySslLoadBalancerBackends_closure55
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroySslLoadBalancerBackends_closure55(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure55.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(TargetSslProxy proxy) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure55.$getCallSiteArray();
                    return callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].call((Object)proxy));
                }

                public Object call(TargetSslProxy proxy) {
                    CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure55.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)proxy);
                    }
                    return this.doCall(proxy);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure55.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "getService";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _destroySslLoadBalancerBackends_closure55.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroySslLoadBalancerBackends_closure55.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroySslLoadBalancerBackends_closure55.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[527].call(callSiteArray[528].call((Object)projectSslProxies, (Object)new _destroySslLoadBalancerBackends_closure54(GCEUtil.class, GCEUtil.class, matchingSslProxyNames)), (Object)new _destroySslLoadBalancerBackends_closure55(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        public final class _destroySslLoadBalancerBackends_closure56
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroySslLoadBalancerBackends_closure56(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure56.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure56.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure56.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure56.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_destroySslLoadBalancerBackends_closure56.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroySslLoadBalancerBackends_closure56.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[529].call((Object)log)) ? callSiteArray[530].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[531].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())), callSiteArray[532].call(foundSslLoadBalancers, (Object)new _destroySslLoadBalancerBackends_closure56(GCEUtil.class, GCEUtil.class))}, new String[]{"Attempting to delete backends for ", " from the following global load balancers: ", ""})) : null;
        public final class _destroySslLoadBalancerBackends_closure57
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference googleOperationPoller;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phase;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroySslLoadBalancerBackends_closure57(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference serverGroupName, Reference region, Reference googleOperationPoller, Reference task, Reference phase) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference8 = executor;
                this.compute = reference7 = compute;
                this.project = reference6 = project;
                this.serverGroupName = reference5 = serverGroupName;
                this.region = reference4 = region;
                this.googleOperationPoller = reference3 = googleOperationPoller;
                this.task = reference2 = task;
                this.phase = reference = phase;
            }

            public Object doCall(Object backendServiceName) {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), backendServiceName), (Object)"compute.backendServices.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get())), BackendService.class);
                public final class _closure107
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference region;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure107(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference region) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure107.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroupName = reference2 = serverGroupName;
                        this.region = reference = region;
                    }

                    public Object doCall(Backend backend) {
                        CallSite[] callSiteArray = _closure107.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(Utils.class, callSiteArray[3].callGetProperty((Object)backend)), (Object)this.region.get());
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callStatic(GCEUtil.class, callSiteArray[5].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(Utils.class, callSiteArray[7].callGetProperty((Object)backend)), (Object)this.region.get());
                    }

                    public Object call(Backend backend) {
                        CallSite[] callSiteArray = _closure107.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)backend);
                        }
                        return this.doCall(backend);
                    }

                    @Generated
                    public Object getServerGroupName() {
                        CallSite[] callSiteArray = _closure107.$getCallSiteArray();
                        return this.serverGroupName.get();
                    }

                    @Generated
                    public Object getRegion() {
                        CallSite[] callSiteArray = _closure107.$getCallSiteArray();
                        return this.region.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure107.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getLocalName";
                        stringArray[1] = "group";
                        stringArray[2] = "getRegionFromGroupUrl";
                        stringArray[3] = "group";
                        stringArray[4] = "getLocalName";
                        stringArray[5] = "group";
                        stringArray[6] = "getRegionFromGroupUrl";
                        stringArray[7] = "group";
                        stringArray[8] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[9];
                        _closure107.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure107.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure107.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[5].callSafe(callSiteArray[6].callGetPropertySafe((Object)backendService), (Object)new _closure107((Object)this, this.getThisObject(), this.serverGroupName, this.region));
                Object updateOp = callSiteArray[7].call(this.executor.get(), callSiteArray[8].call(callSiteArray[9].call(this.compute.get()), this.project.get(), backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[10].callGetProperty(this.executor.get()), callSiteArray[11].callGetProperty(this.executor.get()));
                callSiteArray[12].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[13].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                return callSiteArray[14].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Deleted backend for server group ", " from ssl load balancer backend service ", "."}));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public Object getServerGroupName() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return this.serverGroupName.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public GoogleOperationPoller getGoogleOperationPoller() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
            }

            @Generated
            public Task getTask() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
            }

            @Generated
            public String getPhase() {
                CallSite[] callSiteArray = _destroySslLoadBalancerBackends_closure57.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.phase.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure57.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "backendServices";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_GLOBAL";
                stringArray[5] = "removeAll";
                stringArray[6] = "backends";
                stringArray[7] = "timeExecute";
                stringArray[8] = "update";
                stringArray[9] = "backendServices";
                stringArray[10] = "TAG_SCOPE";
                stringArray[11] = "SCOPE_GLOBAL";
                stringArray[12] = "waitForGlobalOperation";
                stringArray[13] = "getName";
                stringArray[14] = "updateStatus";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _destroySslLoadBalancerBackends_closure57.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroySslLoadBalancerBackends_closure57.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroySslLoadBalancerBackends_closure57.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[533].callSafe((Object)backendServicesToDeleteFrom, (Object)new _destroySslLoadBalancerBackends_closure57(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, serverGroupName, region, googleOperationPoller2, task2, phase2));
    }

    /*
     * WARNING - void declaration
     */
    public static void destroyTcpLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference(callSiteArray[534].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Reference region = new Reference(callSiteArray[535].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        public final class _destroyTcpLoadBalancerBackends_closure58
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyTcpLoadBalancerBackends_closure58(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure58.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure58.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure58.$getCallSiteArray();
                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure58.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure58.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "loadBalancers";
                stringArray[2] = "loadBalancerType";
                stringArray[3] = "TCP";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _destroyTcpLoadBalancerBackends_closure58.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure58.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyTcpLoadBalancerBackends_closure58.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundTcpLoadBalancers = callSiteArray[536].call(callSiteArray[537].call((Object)googleLoadBalancerProvider, (Object)""), (Object)new _destroyTcpLoadBalancerBackends_closure58(GCEUtil.class, GCEUtil.class, serverGroup2));
        List backendServicesToDeleteFrom = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)foundTcpLoadBalancers)) {
            public final class _destroyTcpLoadBalancerBackends_closure59
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyTcpLoadBalancerBackends_closure59(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure59.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object lb) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure59.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(lb));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure59.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _destroyTcpLoadBalancerBackends_closure59.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure59.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyTcpLoadBalancerBackends_closure59.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[538].call(foundTcpLoadBalancers, (Object)new _destroyTcpLoadBalancerBackends_closure59(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            callSiteArray[539].call((Object)log, (Object)"Cache call missed for tcp load balancer, making a call to GCP");
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[540].call(callSiteArray[541].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[542].call(callSiteArray[543].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules.list", callSiteArray[544].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[545].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            List projectTcpProxies = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[546].call(callSiteArray[547].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[548].call(callSiteArray[549].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.targetTcpProxies.list", callSiteArray[550].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[551].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _destroyTcpLoadBalancerBackends_closure60
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyTcpLoadBalancerBackends_closure60(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure60.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure60.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)callSiteArray[3].callGetProperty(GoogleTargetProxyType.class)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[4].callGetProperty((Object)forwardingRule), (Object)callSiteArray[5].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure60.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[6].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure60.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure60.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "TCP";
                    stringArray[4] = "name";
                    stringArray[5] = "loadBalancers";
                    stringArray[6] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _destroyTcpLoadBalancerBackends_closure60.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure60.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyTcpLoadBalancerBackends_closure60.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _destroyTcpLoadBalancerBackends_closure61
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyTcpLoadBalancerBackends_closure61(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure61.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure61.$getCallSiteArray();
                    return callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)forwardingRule));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure61.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure61.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "target";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _destroyTcpLoadBalancerBackends_closure61.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure61.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyTcpLoadBalancerBackends_closure61.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Reference matchingTcpProxyNames = new Reference(callSiteArray[552].call(callSiteArray[553].call((Object)projectGlobalForwardingRules, (Object)new _destroyTcpLoadBalancerBackends_closure60(GCEUtil.class, GCEUtil.class, serverGroup2)), (Object)new _destroyTcpLoadBalancerBackends_closure61(GCEUtil.class, GCEUtil.class)));
            public final class _destroyTcpLoadBalancerBackends_closure62
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference matchingTcpProxyNames;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyTcpLoadBalancerBackends_closure62(Object _outerInstance, Object _thisObject, Reference matchingTcpProxyNames) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure62.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.matchingTcpProxyNames = reference = matchingTcpProxyNames;
                }

                public Object doCall(TargetTcpProxy proxy) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure62.$getCallSiteArray();
                    return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].call((Object)proxy), (Object)this.matchingTcpProxyNames.get());
                }

                public Object call(TargetTcpProxy proxy) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure62.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)proxy);
                    }
                    return this.doCall(proxy);
                }

                @Generated
                public Object getMatchingTcpProxyNames() {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure62.$getCallSiteArray();
                    return this.matchingTcpProxyNames.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure62.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getName";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _destroyTcpLoadBalancerBackends_closure62.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure62.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyTcpLoadBalancerBackends_closure62.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _destroyTcpLoadBalancerBackends_closure63
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyTcpLoadBalancerBackends_closure63(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure63.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(TargetTcpProxy proxy) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure63.$getCallSiteArray();
                    return callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].call((Object)proxy));
                }

                public Object call(TargetTcpProxy proxy) {
                    CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure63.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)proxy);
                    }
                    return this.doCall(proxy);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure63.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "getService";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _destroyTcpLoadBalancerBackends_closure63.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure63.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyTcpLoadBalancerBackends_closure63.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[554].call(callSiteArray[555].call((Object)projectTcpProxies, (Object)new _destroyTcpLoadBalancerBackends_closure62(GCEUtil.class, GCEUtil.class, matchingTcpProxyNames)), (Object)new _destroyTcpLoadBalancerBackends_closure63(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        public final class _destroyTcpLoadBalancerBackends_closure64
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyTcpLoadBalancerBackends_closure64(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure64.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure64.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure64.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure64.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure64.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyTcpLoadBalancerBackends_closure64.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[556].call((Object)log)) ? callSiteArray[557].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[558].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())), callSiteArray[559].call(foundTcpLoadBalancers, (Object)new _destroyTcpLoadBalancerBackends_closure64(GCEUtil.class, GCEUtil.class))}, new String[]{"Attempting to delete backends for ", " from the following global load balancers: ", ""})) : null;
        public final class _destroyTcpLoadBalancerBackends_closure65
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference googleOperationPoller;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phase;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyTcpLoadBalancerBackends_closure65(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference serverGroupName, Reference region, Reference googleOperationPoller, Reference task, Reference phase) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference8 = executor;
                this.compute = reference7 = compute;
                this.project = reference6 = project;
                this.serverGroupName = reference5 = serverGroupName;
                this.region = reference4 = region;
                this.googleOperationPoller = reference3 = googleOperationPoller;
                this.task = reference2 = task;
                this.phase = reference = phase;
            }

            public Object doCall(String backendServiceName) {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), (Object)backendServiceName), (Object)"compute.backendServices.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get())), BackendService.class);
                public final class _closure108
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference region;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure108(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference region) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure108.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroupName = reference2 = serverGroupName;
                        this.region = reference = region;
                    }

                    public Object doCall(Backend backend) {
                        CallSite[] callSiteArray = _closure108.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(Utils.class, callSiteArray[3].callGetProperty((Object)backend)), (Object)this.region.get());
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callStatic(GCEUtil.class, callSiteArray[5].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(Utils.class, callSiteArray[7].callGetProperty((Object)backend)), (Object)this.region.get());
                    }

                    public Object call(Backend backend) {
                        CallSite[] callSiteArray = _closure108.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)backend);
                        }
                        return this.doCall(backend);
                    }

                    @Generated
                    public Object getServerGroupName() {
                        CallSite[] callSiteArray = _closure108.$getCallSiteArray();
                        return this.serverGroupName.get();
                    }

                    @Generated
                    public Object getRegion() {
                        CallSite[] callSiteArray = _closure108.$getCallSiteArray();
                        return this.region.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure108.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getLocalName";
                        stringArray[1] = "group";
                        stringArray[2] = "getRegionFromGroupUrl";
                        stringArray[3] = "group";
                        stringArray[4] = "getLocalName";
                        stringArray[5] = "group";
                        stringArray[6] = "getRegionFromGroupUrl";
                        stringArray[7] = "group";
                        stringArray[8] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[9];
                        _closure108.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure108.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure108.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[5].callSafe(callSiteArray[6].callGetPropertySafe((Object)backendService), (Object)new _closure108((Object)this, this.getThisObject(), this.serverGroupName, this.region));
                Object updateOp = callSiteArray[7].call(this.executor.get(), callSiteArray[8].call(callSiteArray[9].call(this.compute.get()), this.project.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[10].callGetProperty(this.executor.get()), callSiteArray[11].callGetProperty(this.executor.get()));
                callSiteArray[12].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[13].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                return callSiteArray[14].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Deleted backend for server group ", " from tcp load balancer backend service ", "."}));
            }

            public Object call(String backendServiceName) {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[15].callCurrent((GroovyObject)this, (Object)backendServiceName);
                }
                return this.doCall(backendServiceName);
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public Object getServerGroupName() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return this.serverGroupName.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public GoogleOperationPoller getGoogleOperationPoller() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
            }

            @Generated
            public Task getTask() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
            }

            @Generated
            public String getPhase() {
                CallSite[] callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.phase.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure65.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "backendServices";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_GLOBAL";
                stringArray[5] = "removeAll";
                stringArray[6] = "backends";
                stringArray[7] = "timeExecute";
                stringArray[8] = "update";
                stringArray[9] = "backendServices";
                stringArray[10] = "TAG_SCOPE";
                stringArray[11] = "SCOPE_GLOBAL";
                stringArray[12] = "waitForGlobalOperation";
                stringArray[13] = "getName";
                stringArray[14] = "updateStatus";
                stringArray[15] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[16];
                _destroyTcpLoadBalancerBackends_closure65.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyTcpLoadBalancerBackends_closure65.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyTcpLoadBalancerBackends_closure65.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[560].callSafe((Object)backendServicesToDeleteFrom, (Object)new _destroyTcpLoadBalancerBackends_closure65(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, serverGroupName, region, googleOperationPoller2, task2, phase2));
    }

    /*
     * WARNING - void declaration
     */
    public static void destroyInternalLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference(callSiteArray[561].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Reference region = new Reference(callSiteArray[562].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        public final class _destroyInternalLoadBalancerBackends_closure66
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyInternalLoadBalancerBackends_closure66(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure66.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure66.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure66.$getCallSiteArray();
                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure66.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure66.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "loadBalancers";
                stringArray[2] = "loadBalancerType";
                stringArray[3] = "INTERNAL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _destroyInternalLoadBalancerBackends_closure66.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyInternalLoadBalancerBackends_closure66.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyInternalLoadBalancerBackends_closure66.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundInternalLoadBalancers = callSiteArray[563].call(callSiteArray[564].call((Object)googleLoadBalancerProvider, (Object)""), (Object)new _destroyInternalLoadBalancerBackends_closure66(GCEUtil.class, GCEUtil.class, serverGroup2));
        List backendServicesToDeleteFrom = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)foundInternalLoadBalancers)) {
            public final class _destroyInternalLoadBalancerBackends_closure67
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyInternalLoadBalancerBackends_closure67(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure67.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object lb) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure67.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(lb));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure67.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "backendService";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _destroyInternalLoadBalancerBackends_closure67.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyInternalLoadBalancerBackends_closure67.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyInternalLoadBalancerBackends_closure67.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[565].call(foundInternalLoadBalancers, (Object)new _destroyInternalLoadBalancerBackends_closure67(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            callSiteArray[566].call((Object)log, (Object)"Cache call missed for internal load balancer, making a call to GCP");
            List projectForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[567].call(callSiteArray[568].call((Object)((GoogleExecutorTraits)executor2.get()), ArrayUtil.createArray((Object)callSiteArray[569].call(callSiteArray[570].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), region.get()), (Object)"compute.forwardingRules.list", (Object)callSiteArray[571].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[572].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[573].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)region.get()))), List.class);
            public final class _destroyInternalLoadBalancerBackends_closure68
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyInternalLoadBalancerBackends_closure68(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure68.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure68.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].callGetProperty((Object)forwardingRule), (Object)callSiteArray[2].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure68.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[3].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure68.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure68.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "backendService";
                    stringArray[1] = "name";
                    stringArray[2] = "loadBalancers";
                    stringArray[3] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _destroyInternalLoadBalancerBackends_closure68.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyInternalLoadBalancerBackends_closure68.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyInternalLoadBalancerBackends_closure68.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object matchingForwardingRules = callSiteArray[574].call((Object)projectForwardingRules, (Object)new _destroyInternalLoadBalancerBackends_closure68(GCEUtil.class, GCEUtil.class, serverGroup2));
            public final class _destroyInternalLoadBalancerBackends_closure69
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyInternalLoadBalancerBackends_closure69(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure69.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure69.$getCallSiteArray();
                    return callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].call((Object)forwardingRule));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure69.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure69.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "getBackendService";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _destroyInternalLoadBalancerBackends_closure69.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyInternalLoadBalancerBackends_closure69.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyInternalLoadBalancerBackends_closure69.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[575].call(matchingForwardingRules, (Object)new _destroyInternalLoadBalancerBackends_closure69(GCEUtil.class, GCEUtil.class));
            backendServicesToDeleteFrom = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[576].call((Object)log)) ? callSiteArray[577].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[578].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())), backendServicesToDeleteFrom}, new String[]{"Attempting to delete backends for ", " from the following backend services: ", ""})) : null;
        public final class _destroyInternalLoadBalancerBackends_closure70
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference googleOperationPoller;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phase;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyInternalLoadBalancerBackends_closure70(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference serverGroupName, Reference googleOperationPoller, Reference task, Reference phase) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference8 = executor;
                this.compute = reference7 = compute;
                this.project = reference6 = project;
                this.region = reference5 = region;
                this.serverGroupName = reference4 = serverGroupName;
                this.googleOperationPoller = reference3 = googleOperationPoller;
                this.task = reference2 = task;
                this.phase = reference = phase;
            }

            public Object doCall(String backendServiceName) {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName), (Object)"compute.regionBackendServices.get", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get())), BackendService.class);
                public final class _closure109
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference region;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure109(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference region) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure109.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.serverGroupName = reference2 = serverGroupName;
                        this.region = reference = region;
                    }

                    public Object doCall(Backend backend) {
                        CallSite[] callSiteArray = _closure109.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(Utils.class, callSiteArray[3].callGetProperty((Object)backend)), (Object)this.region.get());
                        }
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callStatic(GCEUtil.class, callSiteArray[5].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(Utils.class, callSiteArray[7].callGetProperty((Object)backend)), (Object)this.region.get());
                    }

                    public Object call(Backend backend) {
                        CallSite[] callSiteArray = _closure109.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)backend);
                        }
                        return this.doCall(backend);
                    }

                    @Generated
                    public Object getServerGroupName() {
                        CallSite[] callSiteArray = _closure109.$getCallSiteArray();
                        return this.serverGroupName.get();
                    }

                    @Generated
                    public Object getRegion() {
                        CallSite[] callSiteArray = _closure109.$getCallSiteArray();
                        return this.region.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure109.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getLocalName";
                        stringArray[1] = "group";
                        stringArray[2] = "getRegionFromGroupUrl";
                        stringArray[3] = "group";
                        stringArray[4] = "getLocalName";
                        stringArray[5] = "group";
                        stringArray[6] = "getRegionFromGroupUrl";
                        stringArray[7] = "group";
                        stringArray[8] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[9];
                        _closure109.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure109.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure109.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[6].callSafe(callSiteArray[7].callGetPropertySafe((Object)backendService), (Object)new _closure109((Object)this, this.getThisObject(), this.serverGroupName, this.region));
                Object updateOp = callSiteArray[8].call(this.executor.get(), callSiteArray[9].call(callSiteArray[10].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[11].callGetProperty(this.executor.get()), callSiteArray[12].callGetProperty(this.executor.get()));
                callSiteArray[13].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)this.region.get(), (Object)callSiteArray[14].call(updateOp), null, (Object)this.task.get(), (Object)new GStringImpl(new Object[]{this.region.get()}, new String[]{"compute.", ".backendServices.update"}), (Object)this.phase.get()));
                return callSiteArray[15].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Deleted backend for server group ", " from internal load balancer backend service ", "."}));
            }

            public Object call(String backendServiceName) {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[16].callCurrent((GroovyObject)this, (Object)backendServiceName);
                }
                return this.doCall(backendServiceName);
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object getServerGroupName() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return this.serverGroupName.get();
            }

            @Generated
            public GoogleOperationPoller getGoogleOperationPoller() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
            }

            @Generated
            public Task getTask() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
            }

            @Generated
            public String getPhase() {
                CallSite[] callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.phase.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure70.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "regionBackendServices";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
                stringArray[6] = "removeAll";
                stringArray[7] = "backends";
                stringArray[8] = "timeExecute";
                stringArray[9] = "update";
                stringArray[10] = "regionBackendServices";
                stringArray[11] = "TAG_SCOPE";
                stringArray[12] = "SCOPE_GLOBAL";
                stringArray[13] = "waitForRegionalOperation";
                stringArray[14] = "getName";
                stringArray[15] = "updateStatus";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _destroyInternalLoadBalancerBackends_closure70.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyInternalLoadBalancerBackends_closure70.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyInternalLoadBalancerBackends_closure70.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[579].callSafe((Object)backendServicesToDeleteFrom, (Object)new _destroyInternalLoadBalancerBackends_closure70(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region, serverGroupName, googleOperationPoller2, task2, phase2));
    }

    /*
     * WARNING - void declaration
     */
    public static void destroyHttpLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference(callSiteArray[580].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Object object = callSiteArray[581].callSafe(callSiteArray[582].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get())), (Object)GLOBAL_LOAD_BALANCER_NAMES);
        Object httpLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[583].call((Object)log)) ? callSiteArray[584].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[585].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())), httpLoadBalancersInMetadata}, new String[]{"Attempting to delete backends for ", " from the following Http load balancers: ", ""})) : null;
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[586].call((Object)log)) ? callSiteArray[587].call((Object)log, (Object)new GStringImpl(new Object[]{httpLoadBalancersInMetadata}, new String[]{"Looking up the following Http load balancers in the cache: ", ""})) : null;
        public final class _destroyHttpLoadBalancerBackends_closure71
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyHttpLoadBalancerBackends_closure71(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure71.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure71.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure71.$getCallSiteArray();
                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure71.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure71.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "loadBalancers";
                stringArray[2] = "loadBalancerType";
                stringArray[3] = "HTTP";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _destroyHttpLoadBalancerBackends_closure71.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyHttpLoadBalancerBackends_closure71.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyHttpLoadBalancerBackends_closure71.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundHttpLoadBalancers = callSiteArray[588].call(callSiteArray[589].call((Object)googleLoadBalancerProvider, (Object)""), (Object)new _destroyHttpLoadBalancerBackends_closure71(GCEUtil.class, GCEUtil.class, serverGroup2));
        if (!DefaultTypeTransformation.booleanUnbox((Object)foundHttpLoadBalancers)) {
            Object object4;
            Object object5 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[590].call((Object)log)) ? callSiteArray[591].call((Object)log, (Object)new GStringImpl(new Object[]{httpLoadBalancersInMetadata}, new String[]{"Cache call missed for Http load balancers ", ", making a call to GCP"})) : null;
            List projectGlobalForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[592].call(callSiteArray[593].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[594].call(callSiteArray[595].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules", callSiteArray[596].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[597].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), List.class);
            public final class _destroyHttpLoadBalancerBackends_closure72
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyHttpLoadBalancerBackends_closure72(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure72.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure72.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[3].callGetProperty(GoogleTargetProxyType.class), callSiteArray[4].callGetProperty(GoogleTargetProxyType.class)})) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[5].callGetProperty((Object)forwardingRule), (Object)callSiteArray[6].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure72.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[7].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure72.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure72.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "HTTP";
                    stringArray[4] = "HTTPS";
                    stringArray[5] = "name";
                    stringArray[6] = "loadBalancers";
                    stringArray[7] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _destroyHttpLoadBalancerBackends_closure72.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyHttpLoadBalancerBackends_closure72.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyHttpLoadBalancerBackends_closure72.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            foundHttpLoadBalancers = object4 = callSiteArray[598].call((Object)projectGlobalForwardingRules, (Object)new _destroyHttpLoadBalancerBackends_closure72(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        public final class _destroyHttpLoadBalancerBackends_closure73
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyHttpLoadBalancerBackends_closure73(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure73.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure73.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure73.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure73.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_destroyHttpLoadBalancerBackends_closure73.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyHttpLoadBalancerBackends_closure73.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object notDeleted = callSiteArray[599].call(httpLoadBalancersInMetadata, callSiteArray[600].call(foundHttpLoadBalancers, (Object)new _destroyHttpLoadBalancerBackends_closure73(GCEUtil.class, GCEUtil.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)notDeleted)) {
            Object object6 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[601].call((Object)log)) ? callSiteArray[602].call((Object)log, (Object)new GStringImpl(new Object[]{notDeleted}, new String[]{"Could not locate the following Http load balancers: ", ". Proceeding with other backend deletions without mutating them."})) : null;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)foundHttpLoadBalancers)) {
            Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[603].callGetPropertySafe(callSiteArray[604].callGetPropertySafe(callSiteArray[605].callGetPropertySafe(callSiteArray[606].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
            Map metadataMap = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object7 = callSiteArray[607].callStatic(GCEUtil.class, (Object)instanceMetadata);
                metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object7, Map.class);
            } else {
                Map map;
                metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
            }
            List backendServiceNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[608].callSafe(callSiteArray[609].callSafe((Object)metadataMap, (Object)BACKEND_SERVICE_NAMES), (Object)","), List.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)backendServiceNames)) {
                public final class _destroyHttpLoadBalancerBackends_closure74
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference googleOperationPoller;
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference phase;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _destroyHttpLoadBalancerBackends_closure74(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference serverGroupName, Reference serverGroup, Reference googleOperationPoller, Reference task, Reference phase) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference8 = executor;
                        this.compute = reference7 = compute;
                        this.project = reference6 = project;
                        this.serverGroupName = reference5 = serverGroupName;
                        this.serverGroup = reference4 = serverGroup;
                        this.googleOperationPoller = reference3 = googleOperationPoller;
                        this.task = reference2 = task;
                        this.phase = reference = phase;
                    }

                    public Object doCall(String backendServiceName) {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), (Object)backendServiceName), (Object)"compute.backendService.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get())), BackendService.class);
                        public final class _closure110
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference serverGroupName;
                            private /* synthetic */ Reference serverGroup;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure110(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference serverGroup) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure110.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.serverGroupName = reference2 = serverGroupName;
                                this.serverGroup = reference = serverGroup;
                            }

                            public Object doCall(Backend backend) {
                                CallSite[] callSiteArray = _closure110.$getCallSiteArray();
                                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(Utils.class, callSiteArray[3].callGetProperty((Object)backend)), (Object)callSiteArray[4].callGroovyObjectGetProperty(this.serverGroup.get()));
                                }
                                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callStatic(GCEUtil.class, callSiteArray[6].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call(Utils.class, callSiteArray[8].callGetProperty((Object)backend)), (Object)callSiteArray[9].callGroovyObjectGetProperty(this.serverGroup.get()));
                            }

                            public Object call(Backend backend) {
                                CallSite[] callSiteArray = _closure110.$getCallSiteArray();
                                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return callSiteArray[10].callCurrent((GroovyObject)this, (Object)backend);
                                }
                                return this.doCall(backend);
                            }

                            @Generated
                            public Object getServerGroupName() {
                                CallSite[] callSiteArray = _closure110.$getCallSiteArray();
                                return this.serverGroupName.get();
                            }

                            @Generated
                            public GoogleServerGroup.View getServerGroup() {
                                CallSite[] callSiteArray = _closure110.$getCallSiteArray();
                                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure110.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "getLocalName";
                                stringArray[1] = "group";
                                stringArray[2] = "getRegionFromGroupUrl";
                                stringArray[3] = "group";
                                stringArray[4] = "region";
                                stringArray[5] = "getLocalName";
                                stringArray[6] = "group";
                                stringArray[7] = "getRegionFromGroupUrl";
                                stringArray[8] = "group";
                                stringArray[9] = "region";
                                stringArray[10] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[11];
                                _closure110.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure110.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure110.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[5].callSafe(callSiteArray[6].callGetPropertySafe((Object)backendService), (Object)new _closure110((Object)this, this.getThisObject(), this.serverGroupName, this.serverGroup));
                        Object updateOp = callSiteArray[7].call(this.executor.get(), callSiteArray[8].call(callSiteArray[9].call(this.compute.get()), this.project.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.backendServices.update", callSiteArray[10].callGetProperty(this.executor.get()), callSiteArray[11].callGetProperty(this.executor.get()));
                        callSiteArray[12].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[13].call(updateOp), null, (Object)this.task.get(), (Object)"compute.backendService.update", (Object)this.phase.get()));
                        return callSiteArray[14].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Deleted backend for server group ", " from Http(s) load balancer backend service ", "."}));
                    }

                    public Object call(String backendServiceName) {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[15].callCurrent((GroovyObject)this, (Object)backendServiceName);
                        }
                        return this.doCall(backendServiceName);
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public Object getServerGroupName() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return this.serverGroupName.get();
                    }

                    @Generated
                    public GoogleServerGroup.View getServerGroup() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                    }

                    @Generated
                    public GoogleOperationPoller getGoogleOperationPoller() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                    }

                    @Generated
                    public Task getTask() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                    }

                    @Generated
                    public String getPhase() {
                        CallSite[] callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.phase.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure74.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "get";
                        stringArray[2] = "backendServices";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                        stringArray[5] = "removeAll";
                        stringArray[6] = "backends";
                        stringArray[7] = "timeExecute";
                        stringArray[8] = "update";
                        stringArray[9] = "backendServices";
                        stringArray[10] = "TAG_SCOPE";
                        stringArray[11] = "SCOPE_GLOBAL";
                        stringArray[12] = "waitForGlobalOperation";
                        stringArray[13] = "getName";
                        stringArray[14] = "updateStatus";
                        stringArray[15] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[16];
                        _destroyHttpLoadBalancerBackends_closure74.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_destroyHttpLoadBalancerBackends_closure74.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _destroyHttpLoadBalancerBackends_closure74.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[610].call((Object)backendServiceNames, (Object)new _destroyHttpLoadBalancerBackends_closure74(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, serverGroupName, serverGroup2, googleOperationPoller2, task2, phase2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void destroyInternalHttpLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider, Task task, String phase, GoogleOperationPoller googleOperationPoller, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference serverGroup2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)task);
        Reference phase2 = new Reference((Object)phase);
        Reference googleOperationPoller2 = new Reference((Object)googleOperationPoller);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference serverGroupName = new Reference(callSiteArray[611].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Reference region = new Reference(callSiteArray[612].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())));
        Object object = callSiteArray[613].callSafe(callSiteArray[614].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get())), (Object)REGIONAL_LOAD_BALANCER_NAMES);
        Object httpLoadBalancersInMetadata = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[615].call((Object)log)) ? callSiteArray[616].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[617].callGroovyObjectGetProperty((Object)((GoogleServerGroup.View)serverGroup2.get())), httpLoadBalancersInMetadata}, new String[]{"Attempting to delete backends for ", " from the following Internal Http load balancers: ", ""})) : null;
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[618].call((Object)log)) ? callSiteArray[619].call((Object)log, (Object)new GStringImpl(new Object[]{httpLoadBalancersInMetadata}, new String[]{"Looking up the following Internal Http load balancers in the cache: ", ""})) : null;
        public final class _destroyInternalHttpLoadBalancerBackends_closure75
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyInternalHttpLoadBalancerBackends_closure75(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure75.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure75.$getCallSiteArray();
                return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.serverGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(GoogleLoadBalancerType.class));
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure75.$getCallSiteArray();
                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure75.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalHttpLoadBalancerBackends_closure75.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "loadBalancers";
                stringArray[2] = "loadBalancerType";
                stringArray[3] = "INTERNAL_MANAGED";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _destroyInternalHttpLoadBalancerBackends_closure75.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_destroyInternalHttpLoadBalancerBackends_closure75.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure75.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object foundInternalHttpLoadBalancers = callSiteArray[620].call(callSiteArray[621].call((Object)googleLoadBalancerProvider, (Object)""), (Object)new _destroyInternalHttpLoadBalancerBackends_closure75(GCEUtil.class, GCEUtil.class, serverGroup2));
        if (!DefaultTypeTransformation.booleanUnbox((Object)foundInternalHttpLoadBalancers)) {
            Object object4;
            Object object5 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[622].call((Object)log)) ? callSiteArray[623].call((Object)log, (Object)new GStringImpl(new Object[]{httpLoadBalancersInMetadata}, new String[]{"Cache call missed for Internal Http load balancers ", ", making a call to GCP"})) : null;
            List projectForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[624].call(callSiteArray[625].call((Object)((GoogleExecutorTraits)executor2.get()), ArrayUtil.createArray((Object)callSiteArray[626].call(callSiteArray[627].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), region.get()), (Object)"compute.forwardingRules", (Object)callSiteArray[628].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[629].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[630].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)region.get()))), List.class);
            public final class _destroyInternalHttpLoadBalancerBackends_closure76
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _destroyInternalHttpLoadBalancerBackends_closure76(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    Reference reference;
                    CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure76.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure76.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)forwardingRule)) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty((Object)forwardingRule)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[3].callGetProperty(GoogleTargetProxyType.class), callSiteArray[4].callGetProperty(GoogleTargetProxyType.class)})) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[5].callGetProperty((Object)forwardingRule), (Object)callSiteArray[6].callGroovyObjectGetProperty(this.serverGroup.get()));
                }

                public Object call(ForwardingRule forwardingRule) {
                    CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure76.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[7].callCurrent((GroovyObject)this, (Object)forwardingRule);
                    }
                    return this.doCall(forwardingRule);
                }

                @Generated
                public GoogleServerGroup.View getServerGroup() {
                    CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure76.$getCallSiteArray();
                    return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _destroyInternalHttpLoadBalancerBackends_closure76.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "target";
                    stringArray[1] = "getTargetProxyType";
                    stringArray[2] = "target";
                    stringArray[3] = "HTTP";
                    stringArray[4] = "HTTPS";
                    stringArray[5] = "name";
                    stringArray[6] = "loadBalancers";
                    stringArray[7] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _destroyInternalHttpLoadBalancerBackends_closure76.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_destroyInternalHttpLoadBalancerBackends_closure76.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure76.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            foundInternalHttpLoadBalancers = object4 = callSiteArray[631].call((Object)projectForwardingRules, (Object)new _destroyInternalHttpLoadBalancerBackends_closure76(GCEUtil.class, GCEUtil.class, serverGroup2));
        }
        public final class _destroyInternalHttpLoadBalancerBackends_closure77
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _destroyInternalHttpLoadBalancerBackends_closure77(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure77.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure77.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure77.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalHttpLoadBalancerBackends_closure77.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_destroyInternalHttpLoadBalancerBackends_closure77.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure77.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object notDeleted = callSiteArray[632].call(httpLoadBalancersInMetadata, callSiteArray[633].call(foundInternalHttpLoadBalancers, (Object)new _destroyInternalHttpLoadBalancerBackends_closure77(GCEUtil.class, GCEUtil.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)notDeleted)) {
            Object object6 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[634].call((Object)log)) ? callSiteArray[635].call((Object)log, (Object)new GStringImpl(new Object[]{notDeleted}, new String[]{"Could not locate the following Internal Http load balancers: ", ". Proceeding with other backend deletions without mutating them."})) : null;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)foundInternalHttpLoadBalancers)) {
            Metadata instanceMetadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[636].callGetPropertySafe(callSiteArray[637].callGetPropertySafe(callSiteArray[638].callGetPropertySafe(callSiteArray[639].callGroovyObjectGetPropertySafe((Object)((GoogleServerGroup.View)serverGroup2.get()))))), Metadata.class);
            Map metadataMap = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object7 = callSiteArray[640].callStatic(GCEUtil.class, (Object)instanceMetadata);
                metadataMap = (Map)ScriptBytecodeAdapter.castToType((Object)object7, Map.class);
            } else {
                Map map;
                metadataMap = map = GCEUtil.buildMapFromMetadata(instanceMetadata);
            }
            List backendServiceNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[641].callSafe(callSiteArray[642].callSafe((Object)metadataMap, (Object)REGION_BACKEND_SERVICE_NAMES), (Object)","), List.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)backendServiceNames)) {
                public final class _destroyInternalHttpLoadBalancerBackends_closure78
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference serverGroupName;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference googleOperationPoller;
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference phase;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _destroyInternalHttpLoadBalancerBackends_closure78(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference serverGroupName, Reference serverGroup, Reference googleOperationPoller, Reference task, Reference phase) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference9 = executor;
                        this.compute = reference8 = compute;
                        this.project = reference7 = project;
                        this.region = reference6 = region;
                        this.serverGroupName = reference5 = serverGroupName;
                        this.serverGroup = reference4 = serverGroup;
                        this.googleOperationPoller = reference3 = googleOperationPoller;
                        this.task = reference2 = task;
                        this.phase = reference = phase;
                    }

                    public Object doCall(String backendServiceName) {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        BackendService backendService = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName), (Object)"compute.regionBackendService.get", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get())), BackendService.class);
                        public final class _closure111
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference serverGroupName;
                            private /* synthetic */ Reference serverGroup;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure111(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference serverGroup) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure111.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.serverGroupName = reference2 = serverGroupName;
                                this.serverGroup = reference = serverGroup;
                            }

                            public Object doCall(Backend backend) {
                                CallSite[] callSiteArray = _closure111.$getCallSiteArray();
                                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(Utils.class, callSiteArray[3].callGetProperty((Object)backend)), (Object)callSiteArray[4].callGroovyObjectGetProperty(this.serverGroup.get()));
                                }
                                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callStatic(GCEUtil.class, callSiteArray[6].callGetProperty((Object)backend)), (Object)this.serverGroupName.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call(Utils.class, callSiteArray[8].callGetProperty((Object)backend)), (Object)callSiteArray[9].callGroovyObjectGetProperty(this.serverGroup.get()));
                            }

                            public Object call(Backend backend) {
                                CallSite[] callSiteArray = _closure111.$getCallSiteArray();
                                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return callSiteArray[10].callCurrent((GroovyObject)this, (Object)backend);
                                }
                                return this.doCall(backend);
                            }

                            @Generated
                            public Object getServerGroupName() {
                                CallSite[] callSiteArray = _closure111.$getCallSiteArray();
                                return this.serverGroupName.get();
                            }

                            @Generated
                            public GoogleServerGroup.View getServerGroup() {
                                CallSite[] callSiteArray = _closure111.$getCallSiteArray();
                                return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure111.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "getLocalName";
                                stringArray[1] = "group";
                                stringArray[2] = "getRegionFromGroupUrl";
                                stringArray[3] = "group";
                                stringArray[4] = "region";
                                stringArray[5] = "getLocalName";
                                stringArray[6] = "group";
                                stringArray[7] = "getRegionFromGroupUrl";
                                stringArray[8] = "group";
                                stringArray[9] = "region";
                                stringArray[10] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[11];
                                _closure111.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure111.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure111.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[6].callSafe(callSiteArray[7].callGetPropertySafe((Object)backendService), (Object)new _closure111((Object)this, this.getThisObject(), this.serverGroupName, this.serverGroup));
                        Object updateOp = callSiteArray[8].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[9].call(callSiteArray[10].call(this.compute.get()), this.project.get(), this.region.get(), (Object)backendServiceName, (Object)backendService), (Object)"compute.regionBackendServices.update", (Object)callSiteArray[11].callGetProperty(this.executor.get()), (Object)callSiteArray[12].callGetProperty(this.executor.get()), (Object)callSiteArray[13].callGetProperty(this.executor.get()), (Object)this.region.get()));
                        callSiteArray[14].call(this.googleOperationPoller.get(), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)this.region.get(), (Object)callSiteArray[15].call(updateOp), null, (Object)this.task.get(), (Object)"compute.regionBackendService.update", (Object)this.phase.get()));
                        return callSiteArray[16].call(this.task.get(), this.phase.get(), (Object)new GStringImpl(new Object[]{this.serverGroupName.get(), backendServiceName}, new String[]{"Deleted backend for server group ", " from Internal Http(s) load balancer backend service ", "."}));
                    }

                    public Object call(String backendServiceName) {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[17].callCurrent((GroovyObject)this, (Object)backendServiceName);
                        }
                        return this.doCall(backendServiceName);
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public Object getRegion() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return this.region.get();
                    }

                    @Generated
                    public Object getServerGroupName() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return this.serverGroupName.get();
                    }

                    @Generated
                    public GoogleServerGroup.View getServerGroup() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return (GoogleServerGroup.View)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.View.class);
                    }

                    @Generated
                    public GoogleOperationPoller getGoogleOperationPoller() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return (GoogleOperationPoller)ScriptBytecodeAdapter.castToType((Object)this.googleOperationPoller.get(), GoogleOperationPoller.class);
                    }

                    @Generated
                    public Task getTask() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                    }

                    @Generated
                    public String getPhase() {
                        CallSite[] callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.phase.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _destroyInternalHttpLoadBalancerBackends_closure78.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "get";
                        stringArray[2] = "regionBackendServices";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_REGIONAL";
                        stringArray[5] = "TAG_REGION";
                        stringArray[6] = "removeAll";
                        stringArray[7] = "backends";
                        stringArray[8] = "timeExecute";
                        stringArray[9] = "update";
                        stringArray[10] = "regionBackendServices";
                        stringArray[11] = "TAG_SCOPE";
                        stringArray[12] = "SCOPE_REGIONAL";
                        stringArray[13] = "TAG_REGION";
                        stringArray[14] = "waitForRegionalOperation";
                        stringArray[15] = "getName";
                        stringArray[16] = "updateStatus";
                        stringArray[17] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[18];
                        _destroyInternalHttpLoadBalancerBackends_closure78.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_destroyInternalHttpLoadBalancerBackends_closure78.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _destroyInternalHttpLoadBalancerBackends_closure78.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[643].call((Object)backendServiceNames, (Object)new _destroyInternalHttpLoadBalancerBackends_closure78(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region, serverGroupName, serverGroup2, googleOperationPoller2, task2, phase2));
            }
        }
    }

    public static Boolean isBackendServiceInUse(List<UrlMap> projectUrlMaps, String backendServiceName) {
        Reference backendServiceName2 = new Reference((Object)backendServiceName);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _isBackendServiceInUse_closure79
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServiceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isBackendServiceInUse_closure79(Object _outerInstance, Object _thisObject, Reference backendServiceName) {
                Reference reference;
                CallSite[] callSiteArray = _isBackendServiceInUse_closure79.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.backendServiceName = reference = backendServiceName;
            }

            public Object doCall(UrlMap urlMap) {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure79.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callStatic(GCEUtil.class, callSiteArray[1].call((Object)urlMap)), (Object)this.backendServiceName.get());
            }

            public Object call(UrlMap urlMap) {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure79.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)urlMap);
                }
                return this.doCall(urlMap);
            }

            @Generated
            public String getBackendServiceName() {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure79.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.backendServiceName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isBackendServiceInUse_closure79.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "getDefaultService";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _isBackendServiceInUse_closure79.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isBackendServiceInUse_closure79.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isBackendServiceInUse_closure79.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object defaultServicesMatch = callSiteArray[644].callSafe(projectUrlMaps, (Object)new _isBackendServiceInUse_closure79(GCEUtil.class, GCEUtil.class, backendServiceName2));
        Reference servicesInUse = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _isBackendServiceInUse_closure80
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference servicesInUse;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _isBackendServiceInUse_closure80(Object _outerInstance, Object _thisObject, Reference servicesInUse) {
                Reference reference;
                CallSite[] callSiteArray = _isBackendServiceInUse_closure80.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.servicesInUse = reference = servicesInUse;
            }

            public Object doCall(UrlMap urlMap) {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure80.$getCallSiteArray();
                public final class _closure112
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference servicesInUse;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure112(Object _outerInstance, Object _thisObject, Reference servicesInUse) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure112.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.servicesInUse = reference = servicesInUse;
                    }

                    public Object doCall(PathMatcher pathMatcher) {
                        CallSite[] callSiteArray = _closure112.$getCallSiteArray();
                        callSiteArray[0].call(this.servicesInUse.get(), callSiteArray[1].callStatic(GCEUtil.class, callSiteArray[2].call((Object)pathMatcher)));
                        public final class _closure113
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference servicesInUse;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure113(Object _outerInstance, Object _thisObject, Reference servicesInUse) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure113.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.servicesInUse = reference = servicesInUse;
                            }

                            public Object doCall(PathRule pathRule) {
                                CallSite[] callSiteArray = _closure113.$getCallSiteArray();
                                return callSiteArray[0].call(this.servicesInUse.get(), callSiteArray[1].callStatic(GCEUtil.class, callSiteArray[2].call((Object)pathRule)));
                            }

                            public Object call(PathRule pathRule) {
                                CallSite[] callSiteArray = _closure113.$getCallSiteArray();
                                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)pathRule);
                                }
                                return this.doCall(pathRule);
                            }

                            @Generated
                            public Object getServicesInUse() {
                                CallSite[] callSiteArray = _closure113.$getCallSiteArray();
                                return this.servicesInUse.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure113.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "leftShift";
                                stringArray[1] = "getLocalName";
                                stringArray[2] = "getService";
                                stringArray[3] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[4];
                                _closure113.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure113.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure113.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[3].callSafe(callSiteArray[4].callSafe((Object)pathMatcher), (Object)new _closure113((Object)this, this.getThisObject(), this.servicesInUse));
                    }

                    public Object call(PathMatcher pathMatcher) {
                        CallSite[] callSiteArray = _closure112.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[5].callCurrent((GroovyObject)this, (Object)pathMatcher);
                        }
                        return this.doCall(pathMatcher);
                    }

                    @Generated
                    public Object getServicesInUse() {
                        CallSite[] callSiteArray = _closure112.$getCallSiteArray();
                        return this.servicesInUse.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure112.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "getLocalName";
                        stringArray[2] = "getDefaultService";
                        stringArray[3] = "each";
                        stringArray[4] = "getPathRules";
                        stringArray[5] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _closure112.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure112.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure112.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].callSafe(callSiteArray[1].callSafe((Object)urlMap), (Object)new _closure112((Object)this, this.getThisObject(), this.servicesInUse));
            }

            public Object call(UrlMap urlMap) {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure80.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)urlMap);
                }
                return this.doCall(urlMap);
            }

            @Generated
            public Object getServicesInUse() {
                CallSite[] callSiteArray = _isBackendServiceInUse_closure80.$getCallSiteArray();
                return this.servicesInUse.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isBackendServiceInUse_closure80.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "getPathMatchers";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _isBackendServiceInUse_closure80.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_isBackendServiceInUse_closure80.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _isBackendServiceInUse_closure80.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[645].callSafe(projectUrlMaps, (Object)new _isBackendServiceInUse_closure80(GCEUtil.class, GCEUtil.class, servicesInUse));
        return DefaultTypeTransformation.booleanUnbox((Object)defaultServicesMatch) || ScriptBytecodeAdapter.isCase((Object)((String)backendServiceName2.get()), (Object)servicesInUse.get());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> resolveHttpLoadBalancerNamesMetadata(List<String> backendServiceNames, Compute compute, String project, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference executor2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference loadBalancerNames = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Object object = callSiteArray[646].call(callSiteArray[647].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[648].call(callSiteArray[649].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.urlMaps.list", callSiteArray[650].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[651].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))));
        Object projectUrlMaps = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _resolveHttpLoadBalancerNamesMetadata_closure81
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveHttpLoadBalancerNamesMetadata_closure81(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure81.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(UrlMap urlMap) {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure81.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].callGetProperty((Object)urlMap), callSiteArray[1].call(Utils.class, (Object)urlMap)});
            }

            public Object call(UrlMap urlMap) {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure81.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)urlMap);
                }
                return this.doCall(urlMap);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveHttpLoadBalancerNamesMetadata_closure81.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "getBackendServicesFromUrlMap";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _resolveHttpLoadBalancerNamesMetadata_closure81.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveHttpLoadBalancerNamesMetadata_closure81.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure81.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference servicesByUrlMap = new Reference(callSiteArray[652].call(projectUrlMaps, (Object)new _resolveHttpLoadBalancerNamesMetadata_closure81(GCEUtil.class, GCEUtil.class)));
        Reference urlMapsInUse = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _resolveHttpLoadBalancerNamesMetadata_closure82
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference servicesByUrlMap;
            private /* synthetic */ Reference urlMapsInUse;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveHttpLoadBalancerNamesMetadata_closure82(Object _outerInstance, Object _thisObject, Reference servicesByUrlMap, Reference urlMapsInUse) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.servicesByUrlMap = reference2 = servicesByUrlMap;
                this.urlMapsInUse = reference = urlMapsInUse;
            }

            public Object doCall(String backendServiceName) {
                Reference backendServiceName2 = new Reference((Object)backendServiceName);
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$getCallSiteArray();
                public final class _closure114
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServiceName;
                    private /* synthetic */ Reference urlMapsInUse;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure114(Object _outerInstance, Object _thisObject, Reference backendServiceName, Reference urlMapsInUse) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure114.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.backendServiceName = reference2 = backendServiceName;
                        this.urlMapsInUse = reference = urlMapsInUse;
                    }

                    public Object doCall(Object urlMapName, Object services) {
                        CallSite[] callSiteArray = _closure114.$getCallSiteArray();
                        if (ScriptBytecodeAdapter.isCase((Object)this.backendServiceName.get(), (Object)services)) {
                            return callSiteArray[0].call(this.urlMapsInUse.get(), urlMapName);
                        }
                        return null;
                    }

                    public Object call(Object urlMapName, Object services) {
                        CallSite[] callSiteArray = _closure114.$getCallSiteArray();
                        return callSiteArray[1].callCurrent((GroovyObject)this, urlMapName, services);
                    }

                    @Generated
                    public String getBackendServiceName() {
                        CallSite[] callSiteArray = _closure114.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.backendServiceName.get());
                    }

                    @Generated
                    public Object getUrlMapsInUse() {
                        CallSite[] callSiteArray = _closure114.$getCallSiteArray();
                        return this.urlMapsInUse.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure114.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure114.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure114.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure114.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(this.servicesByUrlMap.get(), (Object)new _closure114((Object)this, this.getThisObject(), backendServiceName2, this.urlMapsInUse));
            }

            public Object call(String backendServiceName) {
                Reference backendServiceName2 = new Reference((Object)backendServiceName);
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)((String)backendServiceName2.get()));
                }
                return this.doCall((String)backendServiceName2.get());
            }

            @Generated
            public Object getServicesByUrlMap() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$getCallSiteArray();
                return this.servicesByUrlMap.get();
            }

            @Generated
            public Object getUrlMapsInUse() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$getCallSiteArray();
                return this.urlMapsInUse.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveHttpLoadBalancerNamesMetadata_closure82.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _resolveHttpLoadBalancerNamesMetadata_closure82.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveHttpLoadBalancerNamesMetadata_closure82.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure82.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[653].call(backendServiceNames, (Object)new _resolveHttpLoadBalancerNamesMetadata_closure82(GCEUtil.class, GCEUtil.class, servicesByUrlMap, urlMapsInUse));
        Object globalForwardingRules = callSiteArray[654].call(callSiteArray[655].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[656].call(callSiteArray[657].call((Object)((Compute)compute2.get())), (Object)((String)project2.get())), (Object)"compute.globalForwardingRules", callSiteArray[658].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[659].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))));
        public final class _resolveHttpLoadBalancerNamesMetadata_closure83
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference urlMapsInUse;
            private /* synthetic */ Reference loadBalancerNames;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resolveHttpLoadBalancerNamesMetadata_closure83(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference urlMapsInUse, Reference loadBalancerNames) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference5 = executor;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.urlMapsInUse = reference2 = urlMapsInUse;
                this.loadBalancerNames = reference = loadBalancerNames;
            }

            public Object doCall(ForwardingRule fr) {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                GoogleTargetProxyType proxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[0].call(Utils.class, callSiteArray[1].callGetProperty((Object)fr)), GoogleTargetProxyType.class);
                Object proxy = null;
                GoogleTargetProxyType googleTargetProxyType = proxyType;
                if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[2].callGetProperty(GoogleTargetProxyType.class))) {
                    Object object;
                    proxy = object = callSiteArray[3].call(this.executor.get(), callSiteArray[4].call(callSiteArray[5].call(this.compute.get()), this.project.get(), callSiteArray[6].callStatic(GCEUtil.class, callSiteArray[7].callGetProperty((Object)fr))), (Object)"compute.targetHttpProxies.get", callSiteArray[8].callGetProperty(this.executor.get()), callSiteArray[9].callGetProperty(this.executor.get()));
                } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[10].callGetProperty(GoogleTargetProxyType.class))) {
                    Object object;
                    proxy = object = callSiteArray[11].call(this.executor.get(), callSiteArray[12].call(callSiteArray[13].call(this.compute.get()), this.project.get(), callSiteArray[14].callStatic(GCEUtil.class, callSiteArray[15].callGetProperty((Object)fr))), (Object)"compute.targetHttpsProxies.get", callSiteArray[16].callGetProperty(this.executor.get()), callSiteArray[17].callGetProperty(this.executor.get()));
                }
                if (DefaultTypeTransformation.booleanUnbox(proxy) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[18].callStatic(GCEUtil.class, callSiteArray[19].callGetProperty(proxy)), (Object)this.urlMapsInUse.get())) {
                    return callSiteArray[20].call(this.loadBalancerNames.get(), callSiteArray[21].callGetProperty((Object)fr));
                }
                return null;
            }

            public Object call(ForwardingRule fr) {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[22].callCurrent((GroovyObject)this, (Object)fr);
                }
                return this.doCall(fr);
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public Object getUrlMapsInUse() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                return this.urlMapsInUse.get();
            }

            @Generated
            public Object getLoadBalancerNames() {
                CallSite[] callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$getCallSiteArray();
                return this.loadBalancerNames.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveHttpLoadBalancerNamesMetadata_closure83.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getTargetProxyType";
                stringArray[1] = "target";
                stringArray[2] = "HTTP";
                stringArray[3] = "timeExecute";
                stringArray[4] = "get";
                stringArray[5] = "targetHttpProxies";
                stringArray[6] = "getLocalName";
                stringArray[7] = "target";
                stringArray[8] = "TAG_SCOPE";
                stringArray[9] = "SCOPE_GLOBAL";
                stringArray[10] = "HTTPS";
                stringArray[11] = "timeExecute";
                stringArray[12] = "get";
                stringArray[13] = "targetHttpsProxies";
                stringArray[14] = "getLocalName";
                stringArray[15] = "target";
                stringArray[16] = "TAG_SCOPE";
                stringArray[17] = "SCOPE_GLOBAL";
                stringArray[18] = "getLocalName";
                stringArray[19] = "urlMap";
                stringArray[20] = "leftShift";
                stringArray[21] = "name";
                stringArray[22] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[23];
                _resolveHttpLoadBalancerNamesMetadata_closure83.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resolveHttpLoadBalancerNamesMetadata_closure83.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resolveHttpLoadBalancerNamesMetadata_closure83.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[660].call(globalForwardingRules, (Object)new _resolveHttpLoadBalancerNamesMetadata_closure83(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, urlMapsInUse, loadBalancerNames));
        return (List)ScriptBytecodeAdapter.castToType((Object)loadBalancerNames.get(), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getTargetProxyFromRule(Compute compute, String project, ForwardingRule forwardingRule, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        String target = ShortTypeHandling.castToString((Object)callSiteArray[661].call((Object)forwardingRule));
        GoogleTargetProxyType targetProxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[662].call(Utils.class, (Object)target), GoogleTargetProxyType.class);
        Reference targetProxyName = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[663].callStatic(GCEUtil.class, (Object)target);
            targetProxyName.set((Object)ShortTypeHandling.castToString((Object)object));
        } else {
            String string = GCEUtil.getLocalName(target);
            targetProxyName.set((Object)string);
        }
        String operationName = null;
        Closure proxyGet = null;
        GoogleTargetProxyType googleTargetProxyType = targetProxyType;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[664].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            _getTargetProxyFromRule_closure84 _getTargetProxyFromRule_closure842;
            public final class _getTargetProxyFromRule_closure84
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTargetProxyFromRule_closure84(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference4 = executor;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetHttpProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure84.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTargetProxyFromRule_closure84.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "targetHttpProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getTargetProxyFromRule_closure84.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getTargetProxyFromRule_closure84.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTargetProxyFromRule_closure84.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            proxyGet = _getTargetProxyFromRule_closure842 = new _getTargetProxyFromRule_closure84(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
            operationName = string = "compute.targetHttpProxies.get";
        } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[665].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            public final class _getTargetProxyFromRule_closure85
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTargetProxyFromRule_closure85(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference4 = executor;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetHttpsProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure85.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTargetProxyFromRule_closure85.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "targetHttpsProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getTargetProxyFromRule_closure85.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getTargetProxyFromRule_closure85.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTargetProxyFromRule_closure85.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _getTargetProxyFromRule_closure85 _getTargetProxyFromRule_closure852 = new _getTargetProxyFromRule_closure85(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
            proxyGet = _getTargetProxyFromRule_closure852;
            operationName = string = "compute.targetHttpsProxies.get";
        } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[666].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            public final class _getTargetProxyFromRule_closure86
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTargetProxyFromRule_closure86(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference4 = executor;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetSslProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure86.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTargetProxyFromRule_closure86.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "targetSslProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getTargetProxyFromRule_closure86.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getTargetProxyFromRule_closure86.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTargetProxyFromRule_closure86.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _getTargetProxyFromRule_closure86 _getTargetProxyFromRule_closure862 = new _getTargetProxyFromRule_closure86(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
            proxyGet = _getTargetProxyFromRule_closure862;
            operationName = string = "compute.targetSslProxies.get";
        } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[667].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            public final class _getTargetProxyFromRule_closure87
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getTargetProxyFromRule_closure87(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference4 = executor;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetTcpProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getTargetProxyFromRule_closure87.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getTargetProxyFromRule_closure87.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "targetTcpProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getTargetProxyFromRule_closure87.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getTargetProxyFromRule_closure87.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getTargetProxyFromRule_closure87.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _getTargetProxyFromRule_closure87 _getTargetProxyFromRule_closure872 = new _getTargetProxyFromRule_closure87(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
            proxyGet = _getTargetProxyFromRule_closure872;
            operationName = string = "compute.targetTcpProxies.get";
        } else {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[668].call((Object)log)) ? callSiteArray[669].call((Object)log, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"Unexpected target proxy type for ", "."})) : null;
            return null;
        }
        Object retrievedTargetProxy = callSiteArray[670].call((Object)safeRetry, ArrayUtil.createArray((Object)proxyGet, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"Target proxy ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", operationName, callSiteArray[671].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[672].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))}), (Object)callSiteArray[673].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))));
        return retrievedTargetProxy;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getRegionTargetProxyFromRule(Compute compute, String project, String region, ForwardingRule forwardingRule, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference region2 = new Reference((Object)var2_2);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        String target = ShortTypeHandling.castToString((Object)callSiteArray[674].call((Object)forwardingRule));
        GoogleTargetProxyType targetProxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[675].call(Utils.class, (Object)target), GoogleTargetProxyType.class);
        Reference targetProxyName = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[676].callStatic(GCEUtil.class, (Object)target);
            targetProxyName.set((Object)ShortTypeHandling.castToString((Object)object));
        } else {
            String string = GCEUtil.getLocalName(target);
            targetProxyName.set((Object)string);
        }
        String operationName = null;
        Closure proxyGet = null;
        GoogleTargetProxyType googleTargetProxyType = targetProxyType;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[677].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            _getRegionTargetProxyFromRule_closure88 _getRegionTargetProxyFromRule_closure882;
            public final class _getRegionTargetProxyFromRule_closure88
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getRegionTargetProxyFromRule_closure88(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference5 = executor;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetProxyName.get()), (Object)"compute.regionTargetHttpProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getRegion() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure88.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getRegionTargetProxyFromRule_closure88.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "regionTargetHttpProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_REGIONAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getRegionTargetProxyFromRule_closure88.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getRegionTargetProxyFromRule_closure88.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getRegionTargetProxyFromRule_closure88.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            proxyGet = _getRegionTargetProxyFromRule_closure882 = new _getRegionTargetProxyFromRule_closure88(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region2, targetProxyName);
            operationName = string = "compute.regionTargetHttpProxies.get";
        } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[678].callGetProperty(GoogleTargetProxyType.class))) {
            String string;
            public final class _getRegionTargetProxyFromRule_closure89
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference executor;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference targetProxyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getRegionTargetProxyFromRule_closure89(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference targetProxyName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.executor = reference5 = executor;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.targetProxyName = reference = targetProxyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetProxyName.get()), (Object)"compute.regionTargetHttpsProxies.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                }

                @Generated
                public GoogleExecutorTraits getExecutor() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getRegion() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public String getTargetProxyName() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getRegionTargetProxyFromRule_closure89.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getRegionTargetProxyFromRule_closure89.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "regionTargetHttpsProxies";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_REGIONAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _getRegionTargetProxyFromRule_closure89.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getRegionTargetProxyFromRule_closure89.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getRegionTargetProxyFromRule_closure89.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _getRegionTargetProxyFromRule_closure89 _getRegionTargetProxyFromRule_closure892 = new _getRegionTargetProxyFromRule_closure89(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region2, targetProxyName);
            proxyGet = _getRegionTargetProxyFromRule_closure892;
            operationName = string = "compute.regionTargetHttpsProxies.get";
        } else {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[679].call((Object)log)) ? callSiteArray[680].call((Object)log, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get(), (String)region2.get()}, new String[]{"Unexpected target proxy type for ", " in ", "."})) : null;
            return null;
        }
        Object retrievedTargetProxy = callSiteArray[681].call((Object)safeRetry, ArrayUtil.createArray((Object)proxyGet, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"Region Target proxy ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", operationName, callSiteArray[682].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[683].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[684].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (String)region2.get()}), (Object)callSiteArray[685].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))));
        return retrievedTargetProxy;
    }

    /*
     * WARNING - void declaration
     */
    public static Operation deleteGlobalListener(Compute compute, String project, String forwardingRuleName, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference forwardingRuleName2 = new Reference((Object)var2_2);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _deleteGlobalListener_closure90
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteGlobalListener_closure90(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference forwardingRuleName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference4 = executor;
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.forwardingRuleName.get()), (Object)"compute.globalForwardingRules.get", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public String getForwardingRuleName() {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.forwardingRuleName.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _deleteGlobalListener_closure90.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure90.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "globalForwardingRules";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_GLOBAL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _deleteGlobalListener_closure90.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteGlobalListener_closure90.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteGlobalListener_closure90.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ForwardingRule ruleToDelete = (ForwardingRule)ScriptBytecodeAdapter.asType((Object)callSiteArray[686].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _deleteGlobalListener_closure90(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, forwardingRuleName2)), (Object)new GStringImpl(new Object[]{(String)forwardingRuleName2.get()}, new String[]{"global forwarding rule ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", "compute.globalForwardingRules.get", callSiteArray[687].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[688].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))}), (Object)callSiteArray[689].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), ForwardingRule.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)ruleToDelete)) {
            String operation_name = null;
            callSiteArray[690].call((Object)((GoogleExecutorTraits)executor2.get()), callSiteArray[691].call(callSiteArray[692].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), callSiteArray[693].call((Object)ruleToDelete)), (Object)"compute.globalForwardingRules.delete", callSiteArray[694].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[695].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())));
            String targetProxyLink = ShortTypeHandling.castToString((Object)callSiteArray[696].call((Object)ruleToDelete));
            Reference targetProxyName = new Reference(null);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[697].callStatic(GCEUtil.class, (Object)targetProxyLink);
                targetProxyName.set((Object)ShortTypeHandling.castToString((Object)object));
            } else {
                String string = GCEUtil.getLocalName(targetProxyLink);
                targetProxyName.set((Object)string);
            }
            GoogleTargetProxyType targetProxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[698].call(Utils.class, (Object)targetProxyLink), GoogleTargetProxyType.class);
            public final class _deleteGlobalListener_closure91
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _deleteGlobalListener_closure91(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _deleteGlobalListener_closure91.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _deleteGlobalListener_closure91.$getCallSiteArray();
                    return null;
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _deleteGlobalListener_closure91.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure91.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_deleteGlobalListener_closure91.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _deleteGlobalListener_closure91.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Closure deleteProxyClosure = new _deleteGlobalListener_closure91(GCEUtil.class, GCEUtil.class);
            GoogleTargetProxyType googleTargetProxyType = targetProxyType;
            if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[699].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteGlobalListener_closure92
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteGlobalListener_closure92(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference4 = executor;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetHttpProxies.delete", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure92.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure92.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "targetHttpProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _deleteGlobalListener_closure92.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteGlobalListener_closure92.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteGlobalListener_closure92.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteGlobalListener_closure92 _deleteGlobalListener_closure922 = new _deleteGlobalListener_closure92(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
                deleteProxyClosure = _deleteGlobalListener_closure922;
                operation_name = string = "compute.targetHttpProxies.delete";
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[700].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteGlobalListener_closure93
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteGlobalListener_closure93(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference4 = executor;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetHttpsProxies.delete", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure93.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure93.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "targetHttpsProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _deleteGlobalListener_closure93.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteGlobalListener_closure93.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteGlobalListener_closure93.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteGlobalListener_closure93 _deleteGlobalListener_closure932 = new _deleteGlobalListener_closure93(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
                deleteProxyClosure = _deleteGlobalListener_closure932;
                operation_name = string = "compute.targetHttpsProxies.delete";
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[701].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteGlobalListener_closure94
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteGlobalListener_closure94(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference4 = executor;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetSslProxies.delete", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure94.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure94.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "targetSslProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _deleteGlobalListener_closure94.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteGlobalListener_closure94.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteGlobalListener_closure94.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteGlobalListener_closure94 _deleteGlobalListener_closure942 = new _deleteGlobalListener_closure94(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
                deleteProxyClosure = _deleteGlobalListener_closure942;
                operation_name = string = "compute.targetSslProxies.delete";
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[702].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteGlobalListener_closure95
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteGlobalListener_closure95(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference4 = executor;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.targetProxyName.get()), (Object)"compute.targetTcpProxies.delete", callSiteArray[3].callGetProperty(this.executor.get()), callSiteArray[4].callGetProperty(this.executor.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteGlobalListener_closure95.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteGlobalListener_closure95.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "targetTcpProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _deleteGlobalListener_closure95.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteGlobalListener_closure95.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteGlobalListener_closure95.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteGlobalListener_closure95 _deleteGlobalListener_closure952 = new _deleteGlobalListener_closure95(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, targetProxyName);
                deleteProxyClosure = _deleteGlobalListener_closure952;
                operation_name = string = "compute.targetTcpProxies.delete";
            } else {
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[703].call((Object)log)) ? callSiteArray[704].call((Object)log, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"Unexpected target proxy type for ", "."})) : null;
            }
            Operation result = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[705].call((Object)safeRetry, ArrayUtil.createArray((Object)deleteProxyClosure, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"target proxy ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", phase, "operation", operation_name, callSiteArray[706].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[707].callGetProperty((Object)((GoogleExecutorTraits)executor2.get()))}), (Object)callSiteArray[708].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), Operation.class);
            return result;
        }
        return (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Operation deleteRegionalListener(Compute compute, String project, String region, String forwardingRuleName, String phase, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var1_1);
        Reference region2 = new Reference((Object)var2_2);
        Reference forwardingRuleName2 = new Reference((Object)var3_3);
        Reference executor2 = new Reference((Object)executor);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _deleteRegionalListener_closure96
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executor;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteRegionalListener_closure96(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference forwardingRuleName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executor = reference5 = executor;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.forwardingRuleName.get()), (Object)"compute.forwardingRules.get", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get()));
            }

            @Generated
            public GoogleExecutorTraits getExecutor() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public String getRegion() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.region.get());
            }

            @Generated
            public String getForwardingRuleName() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.forwardingRuleName.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _deleteRegionalListener_closure96.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteRegionalListener_closure96.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "forwardingRules";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _deleteRegionalListener_closure96.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteRegionalListener_closure96.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteRegionalListener_closure96.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ForwardingRule ruleToDelete = (ForwardingRule)ScriptBytecodeAdapter.asType((Object)callSiteArray[709].call((Object)safeRetry, ArrayUtil.createArray((Object)((Object)new _deleteRegionalListener_closure96(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region2, forwardingRuleName2)), (Object)new GStringImpl(new Object[]{(String)forwardingRuleName2.get()}, new String[]{"forwarding rule ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", phase, "operation", "compute.forwardingRules.get", callSiteArray[710].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[711].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[712].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (String)region2.get()}), (Object)callSiteArray[713].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), ForwardingRule.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)ruleToDelete)) {
            String operation_name = null;
            callSiteArray[714].call((Object)((GoogleExecutorTraits)executor2.get()), ArrayUtil.createArray((Object)callSiteArray[715].call(callSiteArray[716].call((Object)((Compute)compute2.get())), (Object)((String)project2.get()), (Object)((String)region2.get()), callSiteArray[717].call((Object)ruleToDelete)), (Object)"compute.forwardingRules.delete", (Object)callSiteArray[718].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[719].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)callSiteArray[720].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (Object)((String)region2.get())));
            String targetProxyLink = ShortTypeHandling.castToString((Object)callSiteArray[721].call((Object)ruleToDelete));
            Reference targetProxyName = new Reference(null);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[722].callStatic(GCEUtil.class, (Object)targetProxyLink);
                targetProxyName.set((Object)ShortTypeHandling.castToString((Object)object));
            } else {
                String string = GCEUtil.getLocalName(targetProxyLink);
                targetProxyName.set((Object)string);
            }
            GoogleTargetProxyType targetProxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[723].call(Utils.class, (Object)targetProxyLink), GoogleTargetProxyType.class);
            public final class _deleteRegionalListener_closure97
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _deleteRegionalListener_closure97(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _deleteRegionalListener_closure97.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _deleteRegionalListener_closure97.$getCallSiteArray();
                    return null;
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _deleteRegionalListener_closure97.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteRegionalListener_closure97.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_deleteRegionalListener_closure97.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _deleteRegionalListener_closure97.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Closure deleteProxyClosure = new _deleteRegionalListener_closure97(GCEUtil.class, GCEUtil.class);
            GoogleTargetProxyType googleTargetProxyType = targetProxyType;
            if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[724].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteRegionalListener_closure98
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteRegionalListener_closure98(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference5 = executor;
                        this.compute = reference4 = compute;
                        this.project = reference3 = project;
                        this.region = reference2 = region;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetProxyName.get()), (Object)"compute.regionTargetHttpProxies.delete", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getRegion() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.region.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure98.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteRegionalListener_closure98.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "regionTargetHttpProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_REGIONAL";
                        stringArray[5] = "TAG_REGION";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _deleteRegionalListener_closure98.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteRegionalListener_closure98.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteRegionalListener_closure98.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteRegionalListener_closure98 _deleteRegionalListener_closure982 = new _deleteRegionalListener_closure98(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region2, targetProxyName);
                deleteProxyClosure = _deleteRegionalListener_closure982;
                operation_name = string = "compute.regionTargetHttpProxies.delete";
            } else if (ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[725].callGetProperty(GoogleTargetProxyType.class))) {
                String string;
                public final class _deleteRegionalListener_closure99
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference executor;
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference targetProxyName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _deleteRegionalListener_closure99(Object _outerInstance, Object _thisObject, Reference executor, Reference compute, Reference project, Reference region, Reference targetProxyName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.executor = reference5 = executor;
                        this.compute = reference4 = compute;
                        this.project = reference3 = project;
                        this.region = reference2 = region;
                        this.targetProxyName = reference = targetProxyName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return callSiteArray[0].call(this.executor.get(), ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetProxyName.get()), (Object)"compute.regionTargetHttpsProxies.delete", (Object)callSiteArray[3].callGetProperty(this.executor.get()), (Object)callSiteArray[4].callGetProperty(this.executor.get()), (Object)callSiteArray[5].callGetProperty(this.executor.get()), (Object)this.region.get()));
                    }

                    @Generated
                    public GoogleExecutorTraits getExecutor() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return (GoogleExecutorTraits)ScriptBytecodeAdapter.castToType((Object)this.executor.get(), GoogleExecutorTraits.class);
                    }

                    @Generated
                    public Compute getCompute() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                    }

                    @Generated
                    public String getProject() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.project.get());
                    }

                    @Generated
                    public String getRegion() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.region.get());
                    }

                    @Generated
                    public String getTargetProxyName() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.targetProxyName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _deleteRegionalListener_closure99.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _deleteRegionalListener_closure99.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "regionTargetHttpsProxies";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_REGIONAL";
                        stringArray[5] = "TAG_REGION";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _deleteRegionalListener_closure99.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_deleteRegionalListener_closure99.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _deleteRegionalListener_closure99.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _deleteRegionalListener_closure99 _deleteRegionalListener_closure992 = new _deleteRegionalListener_closure99(GCEUtil.class, GCEUtil.class, executor2, compute2, project2, region2, targetProxyName);
                deleteProxyClosure = _deleteRegionalListener_closure992;
                operation_name = string = "compute.regionTargetHttpsProxies.delete";
            } else {
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[726].call((Object)log)) ? callSiteArray[727].call((Object)log, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"Unexpected target proxy type for ", "."})) : null;
            }
            Operation result = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[728].call((Object)safeRetry, ArrayUtil.createArray((Object)deleteProxyClosure, (Object)new GStringImpl(new Object[]{(String)targetProxyName.get()}, new String[]{"region target proxy ", ""}), null, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", phase, "operation", operation_name, callSiteArray[729].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[730].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), callSiteArray[731].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())), (String)region2.get()}), (Object)callSiteArray[732].callGetProperty((Object)((GoogleExecutorTraits)executor2.get())))), Operation.class);
            return result;
        }
        return (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
    }

    public static Operation deleteIfNotInUse(Closure<Operation> closure, String component, String project, Task task, Map tags, SafeRetry safeRetry, GoogleExecutorTraits executor) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        callSiteArray[733].call((Object)task, callSiteArray[734].call((Object)tags, (Object)"phase"), (Object)new GStringImpl(new Object[]{component, project}, new String[]{"Deleting ", " for ", "..."}));
        Operation deleteOp = null;
        try {
            Operation operation;
            deleteOp = operation = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[735].call((Object)safeRetry, ArrayUtil.createArray(closure, (Object)component, (Object)task, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)tags, (Object)callSiteArray[736].callGetProperty((Object)executor))), Operation.class);
        }
        catch (GoogleJsonResponseException e) {
            block11: {
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[737].callGetPropertySafe(callSiteArray[738].callGetProperty((Object)e)), (Object)400) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[739].callGetPropertySafe(callSiteArray[740].callSafe(callSiteArray[741].callGetPropertySafe(callSiteArray[742].callGetProperty((Object)e)), (Object)0)), (Object)"resourceInUseByAnotherResource")) {
                        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[743].call((Object)log)) ? callSiteArray[744].call((Object)log, (Object)new GStringImpl(new Object[]{component, project}, new String[]{"Could not delete ", " for ", ", it was in use by another resource."})) : null;
                        Operation operation = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
                        return operation;
                    }
                    throw (Throwable)e;
                }
                if (!(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[745].callGetPropertySafe(callSiteArray[746].callGetProperty((Object)e)), (Object)400) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[747].callGetPropertySafe(callSiteArray[748].callSafe(callSiteArray[749].callGetPropertySafe(callSiteArray[750].callGetProperty((Object)e)), (Object)0)), (Object)"resourceInUseByAnotherResource"))) break block11;
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[751].call((Object)log)) ? callSiteArray[752].call((Object)log, (Object)new GStringImpl(new Object[]{component, project}, new String[]{"Could not delete ", " for ", ", it was in use by another resource."})) : null;
                Operation operation = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
                return operation;
            }
            throw (Throwable)e;
        }
        return deleteOp;
    }

    public static Firewall buildFirewallRule(String accountName, UpsertGoogleSecurityGroupDescription securityGroupDescription, Task task, String phase, GoogleNetworkProvider googleNetworkProvider) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object network = callSiteArray[753].callStatic(GCEUtil.class, ArrayUtil.createArray((Object)accountName, (Object)callSiteArray[754].callGroovyObjectGetProperty((Object)securityGroupDescription), (Object)task, (Object)phase, (Object)googleNetworkProvider));
        Object firewall = callSiteArray[755].callConstructor(Firewall.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[756].callGroovyObjectGetProperty((Object)securityGroupDescription), "network", callSiteArray[757].callGetProperty(network)}));
        public final class _buildFirewallRule_closure100
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildFirewallRule_closure100(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildFirewallRule_closure100.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildFirewallRule_closure100.$getCallSiteArray();
                return callSiteArray[0].callConstructor(Firewall.Allowed.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"IPProtocol", callSiteArray[1].callGetProperty(it), "ports", callSiteArray[2].callGetProperty(it)}));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildFirewallRule_closure100.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildFirewallRule_closure100.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "ipProtocol";
                stringArray[2] = "portRanges";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _buildFirewallRule_closure100.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildFirewallRule_closure100.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildFirewallRule_closure100.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object allowed = callSiteArray[758].call(callSiteArray[759].callGroovyObjectGetProperty((Object)securityGroupDescription), (Object)new _buildFirewallRule_closure100(GCEUtil.class, GCEUtil.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)allowed)) {
            Object object = allowed;
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)firewall, (String)"allowed");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[760].callGroovyObjectGetProperty((Object)securityGroupDescription))) {
            Object object = callSiteArray[761].callGroovyObjectGetProperty((Object)securityGroupDescription);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)firewall, (String)"description");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[762].callGroovyObjectGetProperty((Object)securityGroupDescription))) {
            Object object = callSiteArray[763].callGroovyObjectGetProperty((Object)securityGroupDescription);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)firewall, (String)"sourceRanges");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[764].callGroovyObjectGetProperty((Object)securityGroupDescription))) {
            Object object = callSiteArray[765].callGroovyObjectGetProperty((Object)securityGroupDescription);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)firewall, (String)"sourceTags");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[766].callGroovyObjectGetProperty((Object)securityGroupDescription))) {
            Object object = callSiteArray[767].callGroovyObjectGetProperty((Object)securityGroupDescription);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)firewall, (String)"targetTags");
        }
        return (Firewall)ScriptBytecodeAdapter.castToType((Object)firewall, Firewall.class);
    }

    public static Boolean healthCheckShouldBeUpdated(Object existingHealthCheck, GoogleHealthCheck descriptionHealthCheck) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Boolean shouldUpdate = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[768].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[769].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[770].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[771].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[772].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[773].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[774].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[775].call(existingHealthCheck));
            shouldUpdate = bl;
        } else {
            boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[776].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[777].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[778].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[779].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[780].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[781].call(existingHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[782].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[783].call(existingHealthCheck));
            shouldUpdate = bl;
        }
        Object object = callSiteArray[784].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[785].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            shouldUpdate = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[786].call((Object)shouldUpdate, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[787].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[788].callGetProperty(callSiteArray[789].callGetProperty(existingHealthCheck))) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[790].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[791].callGetProperty(callSiteArray[792].callGetProperty(existingHealthCheck))) ? 1 : 0)), Boolean.class) : (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[793].call((Object)shouldUpdate, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[794].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[795].callGetProperty(callSiteArray[796].callGetProperty(existingHealthCheck))) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[797].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[798].callGetProperty(callSiteArray[799].callGetProperty(existingHealthCheck))) ? 1 : 0)), Boolean.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[800].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            shouldUpdate = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[801].call((Object)shouldUpdate, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[802].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[803].callGetProperty(callSiteArray[804].callGetProperty(existingHealthCheck))) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[805].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[806].callGetProperty(callSiteArray[807].callGetProperty(existingHealthCheck))) ? 1 : 0)), Boolean.class) : (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[808].call((Object)shouldUpdate, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[809].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[810].callGetProperty(callSiteArray[811].callGetProperty(existingHealthCheck))) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[812].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[813].callGetProperty(callSiteArray[814].callGetProperty(existingHealthCheck))) ? 1 : 0)), Boolean.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[815].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            shouldUpdate = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[816].call((Object)shouldUpdate, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[817].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[818].callGetProperty(callSiteArray[819].callGetProperty(existingHealthCheck)))), Boolean.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[820].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            shouldUpdate = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[821].call((Object)shouldUpdate, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[822].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[823].callGetProperty(callSiteArray[824].callGetProperty(existingHealthCheck)))), Boolean.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[825].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            shouldUpdate = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[826].call((Object)shouldUpdate, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[827].callGroovyObjectGetProperty((Object)descriptionHealthCheck), (Object)callSiteArray[828].callGetProperty(callSiteArray[829].callGetProperty(existingHealthCheck)))), Boolean.class);
        } else {
            throw (Throwable)callSiteArray[830].callConstructor(IllegalArgumentException.class, (Object)"Description contains illegal health check type.");
        }
        return shouldUpdate;
    }

    public static void updateExistingHealthCheck(HealthCheck existingHealthCheck, GoogleHealthCheck descriptionHealthCheck) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object object = callSiteArray[831].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)existingHealthCheck, (String)"checkIntervalSec");
        Object object2 = callSiteArray[832].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)existingHealthCheck, (String)"healthyThreshold");
        Object object3 = callSiteArray[833].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)existingHealthCheck, (String)"unhealthyThreshold");
        Object object4 = callSiteArray[834].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)existingHealthCheck, (String)"timeoutSec");
        Object object5 = callSiteArray[835].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        if (ScriptBytecodeAdapter.isCase((Object)object5, (Object)callSiteArray[836].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            Object object6 = callSiteArray[837].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)callSiteArray[838].callGetProperty((Object)existingHealthCheck), (String)"port");
            Object object7 = callSiteArray[839].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)callSiteArray[840].callGetProperty((Object)existingHealthCheck), (String)"requestPath");
        } else if (ScriptBytecodeAdapter.isCase((Object)object5, (Object)callSiteArray[841].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            Object object8 = callSiteArray[842].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)callSiteArray[843].callGetProperty((Object)existingHealthCheck), (String)"port");
            Object object9 = callSiteArray[844].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object9, null, (Object)callSiteArray[845].callGetProperty((Object)existingHealthCheck), (String)"requestPath");
        } else if (ScriptBytecodeAdapter.isCase((Object)object5, (Object)callSiteArray[846].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            Object object10 = callSiteArray[847].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object10, null, (Object)callSiteArray[848].callGetProperty((Object)existingHealthCheck), (String)"port");
        } else if (ScriptBytecodeAdapter.isCase((Object)object5, (Object)callSiteArray[849].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            Object object11 = callSiteArray[850].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
            ScriptBytecodeAdapter.setProperty((Object)object11, null, (Object)callSiteArray[851].callGetProperty((Object)existingHealthCheck), (String)"port");
        } else {
            throw (Throwable)callSiteArray[852].callConstructor(IllegalArgumentException.class, (Object)"Description contains illegal health check type.");
        }
    }

    public static HealthCheck createNewHealthCheck(GoogleHealthCheck descriptionHealthCheck) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object newHealthCheck = callSiteArray[853].callConstructor(HealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[854].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "checkIntervalSec", callSiteArray[855].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "healthyThreshold", callSiteArray[856].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "unhealthyThreshold", callSiteArray[857].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "timeoutSec", callSiteArray[858].callGroovyObjectGetProperty((Object)descriptionHealthCheck)}));
        Object object = callSiteArray[859].callGroovyObjectGetProperty((Object)descriptionHealthCheck);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[860].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            String string = "HTTP";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)newHealthCheck, (String)"type");
            Object object2 = callSiteArray[861].callConstructor(HttpHealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"port", callSiteArray[862].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "requestPath", callSiteArray[863].callGroovyObjectGetProperty((Object)descriptionHealthCheck)}));
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)newHealthCheck, (String)"httpHealthCheck");
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[864].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            String string = "HTTPS";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)newHealthCheck, (String)"type");
            Object object3 = callSiteArray[865].callConstructor(HttpsHealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"port", callSiteArray[866].callGroovyObjectGetProperty((Object)descriptionHealthCheck), "requestPath", callSiteArray[867].callGroovyObjectGetProperty((Object)descriptionHealthCheck)}));
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)newHealthCheck, (String)"httpsHealthCheck");
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[868].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            String string = "TCP";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)newHealthCheck, (String)"type");
            Object object4 = callSiteArray[869].callConstructor(TCPHealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"port", callSiteArray[870].callGroovyObjectGetProperty((Object)descriptionHealthCheck)}));
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)newHealthCheck, (String)"tcpHealthCheck");
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[871].callGetProperty(GoogleHealthCheck.HealthCheckType.class))) {
            String string = "SSL";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)newHealthCheck, (String)"type");
            Object object5 = callSiteArray[872].callConstructor(SSLHealthCheck.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"port", callSiteArray[873].callGroovyObjectGetProperty((Object)descriptionHealthCheck)}));
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)newHealthCheck, (String)"sslHealthCheck");
        } else {
            throw (Throwable)callSiteArray[874].callConstructor(IllegalArgumentException.class, (Object)"Description contains illegal health check type.");
        }
        return (HealthCheck)ScriptBytecodeAdapter.castToType((Object)newHealthCheck, HealthCheck.class);
    }

    public static List<BackendService> fetchBackendServices(GoogleExecutorTraits agent, Compute compute, String project) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[875].call(callSiteArray[876].call((Object)agent, callSiteArray[877].call(callSiteArray[878].call((Object)compute), (Object)project), (Object)"compute.backendServices.list", callSiteArray[879].callGetProperty((Object)agent), callSiteArray[880].callGetProperty((Object)agent))), List.class);
    }

    public static List<BackendService> fetchRegionBackendServices(GoogleExecutorTraits agent, Compute compute, String project, String region) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[881].call(callSiteArray[882].call((Object)agent, ArrayUtil.createArray((Object)callSiteArray[883].call(callSiteArray[884].call((Object)compute), (Object)project, (Object)region), (Object)"compute.regionBackendServices.list", (Object)callSiteArray[885].callGetProperty((Object)agent), (Object)callSiteArray[886].callGetProperty((Object)agent), (Object)callSiteArray[887].callGetProperty((Object)agent), (Object)region))), List.class);
    }

    public static List<HttpHealthCheck> fetchHttpHealthChecks(GoogleExecutorTraits agent, Compute compute, String project) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Boolean executedAtLeastOnce = false;
        String nextPageToken = null;
        List httpHealthChecks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (!DefaultTypeTransformation.booleanUnbox((Object)executedAtLeastOnce) || DefaultTypeTransformation.booleanUnbox(nextPageToken)) {
            HttpHealthCheckList httpHealthCheckList = (HttpHealthCheckList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[888].call((Object)agent, callSiteArray[889].call(callSiteArray[890].call(callSiteArray[891].call((Object)compute), (Object)project), nextPageToken), (Object)"compute.httpHealthChecks.list", callSiteArray[892].callGetProperty((Object)agent), callSiteArray[893].callGetProperty((Object)agent)), HttpHealthCheckList.class);
            boolean bl = true;
            executedAtLeastOnce = bl;
            Object object = callSiteArray[894].call((Object)httpHealthCheckList);
            nextPageToken = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[896].call((Object)httpHealthCheckList);
            callSiteArray[895].call((Object)httpHealthChecks, DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        }
        return httpHealthChecks;
    }

    public static List<HttpsHealthCheck> fetchHttpsHealthChecks(GoogleExecutorTraits agent, Compute compute, String project) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Boolean executedAtLeastOnce = false;
        String nextPageToken = null;
        List httpsHealthChecks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (!DefaultTypeTransformation.booleanUnbox((Object)executedAtLeastOnce) || DefaultTypeTransformation.booleanUnbox(nextPageToken)) {
            HttpsHealthCheckList httpsHealthCheckList = (HttpsHealthCheckList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[897].call((Object)agent, callSiteArray[898].call(callSiteArray[899].call(callSiteArray[900].call((Object)compute), (Object)project), nextPageToken), (Object)"compute.httpsHealthChecks.list", callSiteArray[901].callGetProperty((Object)agent), callSiteArray[902].callGetProperty((Object)agent)), HttpsHealthCheckList.class);
            boolean bl = true;
            executedAtLeastOnce = bl;
            Object object = callSiteArray[903].call((Object)httpsHealthCheckList);
            nextPageToken = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[905].call((Object)httpsHealthCheckList);
            callSiteArray[904].call((Object)httpsHealthChecks, DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        }
        return httpsHealthChecks;
    }

    public static List<HealthCheck> fetchHealthChecks(GoogleExecutorTraits agent, Compute compute, String project) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Boolean executedAtLeastOnce = false;
        String nextPageToken = null;
        List healthChecks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (!DefaultTypeTransformation.booleanUnbox((Object)executedAtLeastOnce) || DefaultTypeTransformation.booleanUnbox(nextPageToken)) {
            HealthCheckList healthCheckList = (HealthCheckList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[906].call((Object)agent, callSiteArray[907].call(callSiteArray[908].call(callSiteArray[909].call((Object)compute), (Object)project), nextPageToken), (Object)"compute.healthChecks.list", callSiteArray[910].callGetProperty((Object)agent), callSiteArray[911].callGetProperty((Object)agent)), HealthCheckList.class);
            boolean bl = true;
            executedAtLeastOnce = bl;
            Object object = callSiteArray[912].call((Object)healthCheckList);
            nextPageToken = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[914].call((Object)healthCheckList);
            callSiteArray[913].call((Object)healthChecks, DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        }
        return healthChecks;
    }

    public static List<HealthCheck> fetchRegionalHealthChecks(GoogleExecutorTraits agent, Compute compute, String project, String region) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Boolean executedAtLeastOnce = false;
        String nextPageToken = null;
        List healthChecks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (!DefaultTypeTransformation.booleanUnbox((Object)executedAtLeastOnce) || DefaultTypeTransformation.booleanUnbox(nextPageToken)) {
            HealthCheckList healthCheckList = (HealthCheckList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[915].call((Object)agent, ArrayUtil.createArray((Object)callSiteArray[916].call(callSiteArray[917].call(callSiteArray[918].call((Object)compute), (Object)project, (Object)region), nextPageToken), (Object)"compute.regionHealthChecks.list", (Object)callSiteArray[919].callGetProperty((Object)agent), (Object)callSiteArray[920].callGetProperty((Object)agent), (Object)callSiteArray[921].callGetProperty((Object)agent), (Object)region)), HealthCheckList.class);
            boolean bl = true;
            executedAtLeastOnce = bl;
            Object object = callSiteArray[922].call((Object)healthCheckList);
            nextPageToken = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[924].call((Object)healthCheckList);
            callSiteArray[923].call((Object)healthChecks, DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        }
        return healthChecks;
    }

    public static List<GoogleInstance> fetchInstances(GoogleExecutorTraits agent, GoogleNamedAccountCredentials credentials) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        List instances = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[925].callConstructor(ArrayList.class), List.class);
        String pageToken = null;
        do {
            InstanceAggregatedList instanceAggregatedList = (InstanceAggregatedList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[926].call((Object)agent, callSiteArray[927].call(callSiteArray[928].call(callSiteArray[929].call(callSiteArray[930].callGroovyObjectGetProperty((Object)credentials)), callSiteArray[931].callGroovyObjectGetProperty((Object)credentials)), pageToken), (Object)"compute.instances.aggregatedList", callSiteArray[932].callGetProperty((Object)agent), callSiteArray[933].callGetProperty((Object)agent)), InstanceAggregatedList.class);
            instances = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[934].call((Object)instances, callSiteArray[935].callStatic(GCEUtil.class, (Object)instanceAggregatedList, (Object)credentials)), List.class);
            Object object = callSiteArray[936].call((Object)instanceAggregatedList);
            pageToken = ShortTypeHandling.castToString((Object)object);
        } while (!(!DefaultTypeTransformation.booleanUnbox((Object)pageToken)));
        return instances;
    }

    private static List<GoogleInstance> transformInstances(InstanceAggregatedList instanceAggregatedList, GoogleNamedAccountCredentials credentials) throws IOException {
        Reference credentials2 = new Reference((Object)credentials);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Reference instances = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _transformInstances_closure101
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private /* synthetic */ Reference credentials;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _transformInstances_closure101(Object _outerInstance, Object _thisObject, Reference instances, Reference credentials) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _transformInstances_closure101.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instances = reference2 = instances;
                this.credentials = reference = credentials;
            }

            public Object doCall(String zone, InstancesScopedList instancesScopedList) {
                CallSite[] callSiteArray = _transformInstances_closure101.$getCallSiteArray();
                public final class _closure115
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instances;
                    private /* synthetic */ Reference credentials;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure115(Object _outerInstance, Object _thisObject, Reference instances, Reference credentials) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure115.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.instances = reference2 = instances;
                        this.credentials = reference = credentials;
                    }

                    public Object doCall(Instance instance) {
                        CallSite[] callSiteArray = _closure115.$getCallSiteArray();
                        return callSiteArray[0].call(this.instances.get(), callSiteArray[1].call(GoogleInstances.class, (Object)instance, this.credentials.get()));
                    }

                    public Object call(Instance instance) {
                        CallSite[] callSiteArray = _closure115.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[2].callCurrent((GroovyObject)this, (Object)instance);
                        }
                        return this.doCall(instance);
                    }

                    @Generated
                    public List getInstances() {
                        CallSite[] callSiteArray = _closure115.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), List.class);
                    }

                    @Generated
                    public GoogleNamedAccountCredentials getCredentials() {
                        CallSite[] callSiteArray = _closure115.$getCallSiteArray();
                        return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure115.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "createFromComputeInstance";
                        stringArray[2] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure115.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure115.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure115.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].callSafe(callSiteArray[1].callGetPropertySafe((Object)instancesScopedList), (Object)new _closure115((Object)this, this.getThisObject(), this.instances, this.credentials));
            }

            public Object call(String zone, InstancesScopedList instancesScopedList) {
                CallSite[] callSiteArray = _transformInstances_closure101.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)zone, (Object)instancesScopedList);
                }
                return this.doCall(zone, instancesScopedList);
            }

            @Generated
            public List getInstances() {
                CallSite[] callSiteArray = _transformInstances_closure101.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.instances.get(), List.class);
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _transformInstances_closure101.$getCallSiteArray();
                return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _transformInstances_closure101.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "instances";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _transformInstances_closure101.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_transformInstances_closure101.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _transformInstances_closure101.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[937].callSafe(callSiteArray[938].callGetPropertySafe((Object)instanceAggregatedList), (Object)new _transformInstances_closure101(GCEUtil.class, GCEUtil.class, instances, credentials2));
        return (List)instances.get();
    }

    public static void handleHealthObject(GoogleLoadBalancer googleLoadBalancer, Object healthObject) {
        Reference googleLoadBalancer2 = new Reference((Object)googleLoadBalancer);
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        public final class _handleHealthObject_closure102
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference googleLoadBalancer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _handleHealthObject_closure102(Object _outerInstance, Object _thisObject, Reference googleLoadBalancer) {
                Reference reference;
                CallSite[] callSiteArray = _handleHealthObject_closure102.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.googleLoadBalancer = reference = googleLoadBalancer;
            }

            public Object doCall(HealthStatus status) {
                CallSite[] callSiteArray = _handleHealthObject_closure102.$getCallSiteArray();
                Object instanceName = callSiteArray[0].call(Utils.class, callSiteArray[1].callGetProperty((Object)status));
                Object googleLBHealthStatus = callSiteArray[2].call(GoogleLoadBalancerHealth.PlatformStatus.class, callSiteArray[3].callGetProperty((Object)status));
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), (Object)callSiteArray[5].callGetProperty(GoogleLoadBalancerType.class)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[6].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), (Object)callSiteArray[7].callGetProperty((Object)status))) {
                        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call(ScriptBytecodeAdapter.getField(_handleHealthObject_closure102.class, GCEUtil.class, (String)"log"))) ? callSiteArray[9].call(ScriptBytecodeAdapter.getField(_handleHealthObject_closure102.class, GCEUtil.class, (String)"log"), (Object)new GStringImpl(new Object[]{instanceName, callSiteArray[10].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), callSiteArray[11].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), callSiteArray[12].callGetProperty((Object)status), callSiteArray[13].callGetProperty((Object)status)}, new String[]{"Skip adding health for ", " to ", " (", "): ", " (", ")"})) : null;
                        return null;
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[14].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), (Object)callSiteArray[15].callGetProperty(GoogleLoadBalancerType.class)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), (Object)callSiteArray[17].callGetProperty((Object)status))) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call(ScriptBytecodeAdapter.getField(_handleHealthObject_closure102.class, GCEUtil.class, (String)"log"))) ? callSiteArray[19].call(ScriptBytecodeAdapter.getField(_handleHealthObject_closure102.class, GCEUtil.class, (String)"log"), (Object)new GStringImpl(new Object[]{instanceName, callSiteArray[20].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), callSiteArray[21].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), callSiteArray[22].callGetProperty((Object)status), callSiteArray[23].callGetProperty((Object)status)}, new String[]{"Skip adding health for ", " to ", " (", "): ", " (", ")"})) : null;
                    return null;
                }
                return callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), callSiteArray[26].callConstructor(GoogleLoadBalancerHealth.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceName", instanceName, "instanceZone", callSiteArray[27].call(Utils.class, callSiteArray[28].callGetProperty((Object)status)), "status", googleLBHealthStatus, "lbHealthSummaries", ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[29].callConstructor(GoogleLoadBalancerHealth.LBHealthSummary.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerName", callSiteArray[30].callGroovyObjectGetProperty(this.googleLoadBalancer.get()), "instanceId", instanceName, "state", callSiteArray[31].call(googleLBHealthStatus)}))})})));
            }

            public Object call(HealthStatus status) {
                CallSite[] callSiteArray = _handleHealthObject_closure102.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[32].callCurrent((GroovyObject)this, (Object)status);
                }
                return this.doCall(status);
            }

            @Generated
            public GoogleLoadBalancer getGoogleLoadBalancer() {
                CallSite[] callSiteArray = _handleHealthObject_closure102.$getCallSiteArray();
                return (GoogleLoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.googleLoadBalancer.get(), GoogleLoadBalancer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleHealthObject_closure102.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "instance";
                stringArray[2] = "valueOf";
                stringArray[3] = "healthState";
                stringArray[4] = "type";
                stringArray[5] = "NETWORK";
                stringArray[6] = "ipAddress";
                stringArray[7] = "ipAddress";
                stringArray[8] = "isDebugEnabled";
                stringArray[9] = "debug";
                stringArray[10] = "name";
                stringArray[11] = "ipAddress";
                stringArray[12] = "healthState";
                stringArray[13] = "ipAddress";
                stringArray[14] = "type";
                stringArray[15] = "NETWORK";
                stringArray[16] = "ipAddress";
                stringArray[17] = "ipAddress";
                stringArray[18] = "isDebugEnabled";
                stringArray[19] = "debug";
                stringArray[20] = "name";
                stringArray[21] = "ipAddress";
                stringArray[22] = "healthState";
                stringArray[23] = "ipAddress";
                stringArray[24] = "leftShift";
                stringArray[25] = "healths";
                stringArray[26] = "<$constructor$>";
                stringArray[27] = "getZoneFromInstanceUrl";
                stringArray[28] = "instance";
                stringArray[29] = "<$constructor$>";
                stringArray[30] = "name";
                stringArray[31] = "toServiceStatus";
                stringArray[32] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[33];
                _handleHealthObject_closure102.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_handleHealthObject_closure102.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _handleHealthObject_closure102.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[939].callSafe(callSiteArray[940].callGetProperty(healthObject), (Object)new _handleHealthObject_closure102(GCEUtil.class, GCEUtil.class, googleLoadBalancer2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GCEUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GCEUtil.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GCEUtil.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GCEUtil.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = GCEUtil.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("1.0");
    }

    static {
        List list;
        GCEUtil.__$swapInit();
        RETRY_ERROR_CODES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412, 429, 503});
        Object object = GCEUtil.$getCallSiteArray()[941].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "updateStatus";
        stringArray[1] = "instanceTypes";
        stringArray[2] = "getAt";
        stringArray[3] = "locationToInstanceTypesMap";
        stringArray[4] = "updateStatusAndThrowNotFoundException";
        stringArray[5] = "updateStatus";
        stringArray[6] = "minus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "project";
        stringArray[10] = "imageProjects";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "compute";
        stringArray[13] = "each";
        stringArray[14] = "timeExecuteBatch";
        stringArray[15] = "updateStatusAndThrowNotFoundException";
        stringArray[16] = "getType";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "getReference";
        stringArray[19] = "updateStatus";
        stringArray[20] = "doRetry";
        stringArray[21] = "TAG_SCOPE";
        stringArray[22] = "SCOPE_GLOBAL";
        stringArray[23] = "registry";
        stringArray[24] = "parseAs";
        stringArray[25] = "imageSource";
        stringArray[26] = "ARTIFACT";
        stringArray[27] = "getImageFromArtifact";
        stringArray[28] = "imageArtifact";
        stringArray[29] = "compute";
        stringArray[30] = "credentials";
        stringArray[31] = "queryImage";
        stringArray[32] = "image";
        stringArray[33] = "credentials";
        stringArray[34] = "getGuestOsFeatures";
        stringArray[35] = "size";
        stringArray[36] = "size";
        stringArray[37] = "each";
        stringArray[38] = "updateStatus";
        stringArray[39] = "getAllMatchingKeyPattern";
        stringArray[40] = "getNetworkKey";
        stringArray[41] = "getAt";
        stringArray[42] = "updateStatusAndThrowNotFoundException";
        stringArray[43] = "updateStatus";
        stringArray[44] = "getAllMatchingKeyPattern";
        stringArray[45] = "getSubnetKey";
        stringArray[46] = "getAt";
        stringArray[47] = "updateStatusAndThrowNotFoundException";
        stringArray[48] = "updateStatus";
        stringArray[49] = "timeExecute";
        stringArray[50] = "list";
        stringArray[51] = "regions";
        stringArray[52] = "TAG_SCOPE";
        stringArray[53] = "SCOPE_GLOBAL";
        stringArray[54] = "iterator";
        stringArray[55] = "items";
        stringArray[56] = "timeExecute";
        stringArray[57] = "get";
        stringArray[58] = "forwardingRules";
        stringArray[59] = "name";
        stringArray[60] = "TAG_SCOPE";
        stringArray[61] = "SCOPE_REGIONAL";
        stringArray[62] = "TAG_REGION";
        stringArray[63] = "name";
        stringArray[64] = "getStatusCode";
        stringArray[65] = "updateStatus";
        stringArray[66] = "timeExecute";
        stringArray[67] = "get";
        stringArray[68] = "backendServices";
        stringArray[69] = "TAG_SCOPE";
        stringArray[70] = "SCOPE_GLOBAL";
        stringArray[71] = "getStatusCode";
        stringArray[72] = "updateStatus";
        stringArray[73] = "timeExecute";
        stringArray[74] = "list";
        stringArray[75] = "targetPools";
        stringArray[76] = "TAG_SCOPE";
        stringArray[77] = "SCOPE_REGIONAL";
        stringArray[78] = "TAG_REGION";
        stringArray[79] = "find";
        stringArray[80] = "items";
        stringArray[81] = "updateStatus";
        stringArray[82] = "timeExecute";
        stringArray[83] = "list";
        stringArray[84] = "httpHealthChecks";
        stringArray[85] = "TAG_SCOPE";
        stringArray[86] = "SCOPE_GLOBAL";
        stringArray[87] = "find";
        stringArray[88] = "items";
        stringArray[89] = "updateStatus";
        stringArray[90] = "healthCheck";
        stringArray[91] = "queryNestedHealthCheck";
        stringArray[92] = "httpHealthCheck";
        stringArray[93] = "queryLegacyHttpHealthCheck";
        stringArray[94] = "httpsHealthCheck";
        stringArray[95] = "queryLegacyHttpsHealthCheck";
        stringArray[96] = "queryNestedHealthCheck";
        stringArray[97] = "queryLegacyHttpHealthCheck";
        stringArray[98] = "queryLegacyHttpsHealthCheck";
        stringArray[99] = "updateStatus";
        stringArray[100] = "filterIdentifiers";
        stringArray[101] = "ns";
        stringArray[102] = "HEALTH_CHECKS";
        stringArray[103] = "getHealthCheckKey";
        stringArray[104] = "getAll";
        stringArray[105] = "ns";
        stringArray[106] = "HEALTH_CHECKS";
        stringArray[107] = "none";
        stringArray[108] = "healthCheck";
        stringArray[109] = "attributes";
        stringArray[110] = "getAt";
        stringArray[111] = "updateStatus";
        stringArray[112] = "filterIdentifiers";
        stringArray[113] = "ns";
        stringArray[114] = "HTTP_HEALTH_CHECKS";
        stringArray[115] = "getHttpHealthCheckKey";
        stringArray[116] = "getAll";
        stringArray[117] = "ns";
        stringArray[118] = "HTTP_HEALTH_CHECKS";
        stringArray[119] = "none";
        stringArray[120] = "httpHealthCheck";
        stringArray[121] = "attributes";
        stringArray[122] = "getAt";
        stringArray[123] = "updateStatus";
        stringArray[124] = "timeExecute";
        stringArray[125] = "get";
        stringArray[126] = "httpsHealthChecks";
        stringArray[127] = "TAG_SCOPE";
        stringArray[128] = "SCOPE_GLOBAL";
        stringArray[129] = "updateStatusAndThrowNotFoundException";
        stringArray[130] = "updateStatusAndThrowNotFoundException";
        stringArray[131] = "updateStatusAndThrowNotFoundException";
        stringArray[132] = "updateStatus";
        stringArray[133] = "doRetry";
        stringArray[134] = "TAG_SCOPE";
        stringArray[135] = "SCOPE_GLOBAL";
        stringArray[136] = "registry";
        stringArray[137] = "findAll";
        stringArray[138] = "size";
        stringArray[139] = "size";
        stringArray[140] = "collect";
        stringArray[141] = "updateStatusAndThrowNotFoundException";
        stringArray[142] = "minus";
        stringArray[143] = "getApplicationLoadBalancers";
        stringArray[144] = "findAll";
        stringArray[145] = "size";
        stringArray[146] = "size";
        stringArray[147] = "collect";
        stringArray[148] = "updateStatusAndThrowNotFoundException";
        stringArray[149] = "minus";
        stringArray[150] = "updateStatus";
        stringArray[151] = "items";
        stringArray[152] = "timeExecute";
        stringArray[153] = "aggregatedList";
        stringArray[154] = "instances";
        stringArray[155] = "TAG_SCOPE";
        stringArray[156] = "SCOPE_GLOBAL";
        stringArray[157] = "minus";
        stringArray[158] = "flatten";
        stringArray[159] = "collect";
        stringArray[160] = "size";
        stringArray[161] = "size";
        stringArray[162] = "collect";
        stringArray[163] = "collect";
        stringArray[164] = "updateStatusAndThrowNotFoundException";
        stringArray[165] = "minus";
        stringArray[166] = "doRetry";
        stringArray[167] = "TAG_SCOPE";
        stringArray[168] = "SCOPE_REGIONAL";
        stringArray[169] = "TAG_REGION";
        stringArray[170] = "registry";
        stringArray[171] = "doRetry";
        stringArray[172] = "TAG_SCOPE";
        stringArray[173] = "SCOPE_ZONAL";
        stringArray[174] = "TAG_ZONE";
        stringArray[175] = "registry";
        stringArray[176] = "withDefault";
        stringArray[177] = "doRetry";
        stringArray[178] = "TAG_SCOPE";
        stringArray[179] = "SCOPE_GLOBAL";
        stringArray[180] = "registry";
        stringArray[181] = "each";
        stringArray[182] = "getZonesFromRegion";
        stringArray[183] = "flatten";
        stringArray[184] = "findResults";
        stringArray[185] = "getServerGroup";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "collect";
        stringArray[188] = "findAll";
        stringArray[189] = "instances";
        stringArray[190] = "timeExecute";
        stringArray[191] = "get";
        stringArray[192] = "instanceTemplates";
        stringArray[193] = "compute";
        stringArray[194] = "project";
        stringArray[195] = "TAG_SCOPE";
        stringArray[196] = "SCOPE_GLOBAL";
        stringArray[197] = "getItems";
        stringArray[198] = "timeExecute";
        stringArray[199] = "list";
        stringArray[200] = "instanceTemplates";
        stringArray[201] = "compute";
        stringArray[202] = "project";
        stringArray[203] = "TAG_SCOPE";
        stringArray[204] = "SCOPE_GLOBAL";
        stringArray[205] = "properties";
        stringArray[206] = "<$constructor$>";
        stringArray[207] = "plus";
        stringArray[208] = "name";
        stringArray[209] = "size";
        stringArray[210] = "networkInterfaces";
        stringArray[211] = "<$constructor$>";
        stringArray[212] = "plus";
        stringArray[213] = "name";
        stringArray[214] = "size";
        stringArray[215] = "networkInterfaces";
        stringArray[216] = "disks";
        stringArray[217] = "find";
        stringArray[218] = "disks";
        stringArray[219] = "getLocalName";
        stringArray[220] = "sourceImage";
        stringArray[221] = "initializeParams";
        stringArray[222] = "collect";
        stringArray[223] = "disks";
        stringArray[224] = "<$constructor$>";
        stringArray[225] = "plus";
        stringArray[226] = "name";
        stringArray[227] = "size";
        stringArray[228] = "disks";
        stringArray[229] = "getAt";
        stringArray[230] = "networkInterfaces";
        stringArray[231] = "email";
        stringArray[232] = "getAt";
        stringArray[233] = "serviceAccounts";
        stringArray[234] = "shieldedVmConfig";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "machineType";
        stringArray[237] = "minCpuPlatform";
        stringArray[238] = "collectEntries";
        stringArray[239] = "items";
        stringArray[240] = "metadata";
        stringArray[241] = "items";
        stringArray[242] = "tags";
        stringArray[243] = "decorateXpnResourceIdIfNeeded";
        stringArray[244] = "network";
        stringArray[245] = "decorateXpnResourceIdIfNeeded";
        stringArray[246] = "subnet";
        stringArray[247] = "retrieveScopesFromServiceAccount";
        stringArray[248] = "serviceAccounts";
        stringArray[249] = "enableSecureBoot";
        stringArray[250] = "enableVtpm";
        stringArray[251] = "enableIntegrityMonitoring";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "getLocalName";
        stringArray[254] = "healthCheck";
        stringArray[255] = "initialDelaySec";
        stringArray[256] = "maxUnavailable";
        stringArray[257] = "scopes";
        stringArray[258] = "find";
        stringArray[259] = "plus";
        stringArray[260] = "plus";
        stringArray[261] = "plus";
        stringArray[262] = "plus";
        stringArray[263] = "plus";
        stringArray[264] = "plus";
        stringArray[265] = "plus";
        stringArray[266] = "plus";
        stringArray[267] = "plus";
        stringArray[268] = "plus";
        stringArray[269] = "plus";
        stringArray[270] = "plus";
        stringArray[271] = "plus";
        stringArray[272] = "credentials";
        stringArray[273] = "disks";
        stringArray[274] = "instanceType";
        stringArray[275] = "disks";
        stringArray[276] = "determineInstanceTypeDisk";
        stringArray[277] = "<$constructor$>";
        stringArray[278] = "eachWithIndex";
        stringArray[279] = "findAll";
        stringArray[280] = "find";
        stringArray[281] = "collect";
        stringArray[282] = "<$constructor$>";
        stringArray[283] = "selfLink";
        stringArray[284] = "selfLink";
        stringArray[285] = "setAccessConfigs";
        stringArray[286] = "<$constructor$>";
        stringArray[287] = "collect";
        stringArray[288] = "<$constructor$>";
        stringArray[289] = "collectEntries";
        stringArray[290] = "getItems";
        stringArray[291] = "<$constructor$>";
        stringArray[292] = "with";
        stringArray[293] = "with";
        stringArray[294] = "autoscalingPolicy";
        stringArray[295] = "collect";
        stringArray[296] = "<$constructor$>";
        stringArray[297] = "resolveAuthScopes";
        stringArray[298] = "<$constructor$>";
        stringArray[299] = "preemptible";
        stringArray[300] = "preemptible";
        stringArray[301] = "automaticRestart";
        stringArray[302] = "automaticRestart";
        stringArray[303] = "onHostMaintenance";
        stringArray[304] = "onHostMaintenance";
        stringArray[305] = "<$constructor$>";
        stringArray[306] = "enableSecureBoot";
        stringArray[307] = "enableSecureBoot";
        stringArray[308] = "enableVtpm";
        stringArray[309] = "enableVtpm";
        stringArray[310] = "enableIntegrityMonitoring";
        stringArray[311] = "enableIntegrityMonitoring";
        stringArray[312] = "updateStatus";
        stringArray[313] = "<$constructor$>";
        stringArray[314] = "split";
        stringArray[315] = "getAt";
        stringArray[316] = "minus";
        stringArray[317] = "length";
        stringArray[318] = "<$constructor$>";
        stringArray[319] = "tokenize";
        stringArray[320] = "indexOf";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "getAt";
        stringArray[323] = "plus";
        stringArray[324] = "getAt";
        stringArray[325] = "<$constructor$>";
        stringArray[326] = "checkIntervalSec";
        stringArray[327] = "timeoutSec";
        stringArray[328] = "healthyThreshold";
        stringArray[329] = "unhealthyThreshold";
        stringArray[330] = "port";
        stringArray[331] = "requestPath";
        stringArray[332] = "name";
        stringArray[333] = "region";
        stringArray[334] = "metadata";
        stringArray[335] = "properties";
        stringArray[336] = "instanceTemplate";
        stringArray[337] = "launchConfig";
        stringArray[338] = "buildMapFromMetadata";
        stringArray[339] = "tokenize";
        stringArray[340] = "get";
        stringArray[341] = "findAll";
        stringArray[342] = "queryAllLoadBalancers";
        stringArray[343] = "warn";
        stringArray[344] = "getItems";
        stringArray[345] = "timeExecute";
        stringArray[346] = "list";
        stringArray[347] = "forwardingRules";
        stringArray[348] = "TAG_SCOPE";
        stringArray[349] = "SCOPE_REGIONAL";
        stringArray[350] = "TAG_REGION";
        stringArray[351] = "findAll";
        stringArray[352] = "each";
        stringArray[353] = "name";
        stringArray[354] = "metadata";
        stringArray[355] = "properties";
        stringArray[356] = "instanceTemplate";
        stringArray[357] = "launchConfig";
        stringArray[358] = "buildMapFromMetadata";
        stringArray[359] = "tokenize";
        stringArray[360] = "get";
        stringArray[361] = "tokenize";
        stringArray[362] = "get";
        stringArray[363] = "plus";
        stringArray[364] = "findAll";
        stringArray[365] = "queryAllLoadBalancers";
        stringArray[366] = "isWarnEnabled";
        stringArray[367] = "warn";
        stringArray[368] = "getItems";
        stringArray[369] = "timeExecute";
        stringArray[370] = "list";
        stringArray[371] = "globalForwardingRules";
        stringArray[372] = "TAG_SCOPE";
        stringArray[373] = "SCOPE_GLOBAL";
        stringArray[374] = "findAll";
        stringArray[375] = "get";
        stringArray[376] = "updateStatusAndThrowNotFoundException";
        stringArray[377] = "readValue";
        stringArray[378] = "split";
        stringArray[379] = "get";
        stringArray[380] = "each";
        stringArray[381] = "name";
        stringArray[382] = "region";
        stringArray[383] = "metadata";
        stringArray[384] = "properties";
        stringArray[385] = "instanceTemplate";
        stringArray[386] = "launchConfig";
        stringArray[387] = "buildMapFromMetadata";
        stringArray[388] = "tokenize";
        stringArray[389] = "get";
        stringArray[390] = "findAll";
        stringArray[391] = "queryAllLoadBalancers";
        stringArray[392] = "isWarnEnabled";
        stringArray[393] = "warn";
        stringArray[394] = "getItems";
        stringArray[395] = "timeExecute";
        stringArray[396] = "list";
        stringArray[397] = "forwardingRules";
        stringArray[398] = "TAG_SCOPE";
        stringArray[399] = "SCOPE_REGIONAL";
        stringArray[400] = "TAG_REGION";
        stringArray[401] = "findAll";
        stringArray[402] = "get";
        stringArray[403] = "updateStatusAndThrowNotFoundException";
        stringArray[404] = "readValue";
        stringArray[405] = "split";
        stringArray[406] = "get";
        stringArray[407] = "each";
        stringArray[408] = "name";
        stringArray[409] = "metadata";
        stringArray[410] = "properties";
        stringArray[411] = "instanceTemplate";
        stringArray[412] = "launchConfig";
        stringArray[413] = "buildMapFromMetadata";
        stringArray[414] = "tokenize";
        stringArray[415] = "get";
        stringArray[416] = "tokenize";
        stringArray[417] = "get";
        stringArray[418] = "plus";
        stringArray[419] = "findAll";
        stringArray[420] = "queryAllLoadBalancers";
        stringArray[421] = "warn";
        stringArray[422] = "getItems";
        stringArray[423] = "timeExecute";
        stringArray[424] = "list";
        stringArray[425] = "globalForwardingRules";
        stringArray[426] = "TAG_SCOPE";
        stringArray[427] = "SCOPE_GLOBAL";
        stringArray[428] = "findAll";
        stringArray[429] = "get";
        stringArray[430] = "updateStatusAndThrowNotFoundException";
        stringArray[431] = "readValue";
        stringArray[432] = "each";
        stringArray[433] = "name";
        stringArray[434] = "metadata";
        stringArray[435] = "properties";
        stringArray[436] = "instanceTemplate";
        stringArray[437] = "launchConfig";
        stringArray[438] = "buildMapFromMetadata";
        stringArray[439] = "tokenize";
        stringArray[440] = "get";
        stringArray[441] = "tokenize";
        stringArray[442] = "get";
        stringArray[443] = "plus";
        stringArray[444] = "findAll";
        stringArray[445] = "queryAllLoadBalancers";
        stringArray[446] = "warn";
        stringArray[447] = "getItems";
        stringArray[448] = "timeExecute";
        stringArray[449] = "list";
        stringArray[450] = "globalForwardingRules";
        stringArray[451] = "TAG_SCOPE";
        stringArray[452] = "SCOPE_GLOBAL";
        stringArray[453] = "findAll";
        stringArray[454] = "get";
        stringArray[455] = "updateStatusAndThrowNotFoundException";
        stringArray[456] = "readValue";
        stringArray[457] = "each";
        stringArray[458] = "balancingMode";
        stringArray[459] = "<$constructor$>";
        stringArray[460] = "RATE";
        stringArray[461] = "UTILIZATION";
        stringArray[462] = "maxRatePerInstance";
        stringArray[463] = "UTILIZATION";
        stringArray[464] = "maxUtilization";
        stringArray[465] = "CONNECTION";
        stringArray[466] = "maxConnectionsPerInstance";
        stringArray[467] = "capacityScaler";
        stringArray[468] = "capacityScaler";
        stringArray[469] = "<$constructor$>";
        stringArray[470] = "RATE";
        stringArray[471] = "UTILIZATION";
        stringArray[472] = "maxRatePerInstance";
        stringArray[473] = "UTILIZATION";
        stringArray[474] = "maxUtilization";
        stringArray[475] = "CONNECTION";
        stringArray[476] = "maxConnectionsPerInstance";
        stringArray[477] = "capacityScaler";
        stringArray[478] = "capacityScaler";
        stringArray[479] = "listeningPort";
        stringArray[480] = "warn";
        stringArray[481] = "setNamedPorts";
        stringArray[482] = "<$constructor$>";
        stringArray[483] = "HTTP_DEFAULT_PORT_NAME";
        stringArray[484] = "listeningPort";
        stringArray[485] = "writeValueAsString";
        stringArray[486] = "putAt";
        stringArray[487] = "valueOf";
        stringArray[488] = "balancingMode";
        stringArray[489] = "<$constructor$>";
        stringArray[490] = "RATE";
        stringArray[491] = "UTILIZATION";
        stringArray[492] = "maxRatePerInstance";
        stringArray[493] = "UTILIZATION";
        stringArray[494] = "maxUtilization";
        stringArray[495] = "CONNECTION";
        stringArray[496] = "maxConnectionsPerInstance";
        stringArray[497] = "capacityScaler";
        stringArray[498] = "<$constructor$>";
        stringArray[499] = "RATE";
        stringArray[500] = "UTILIZATION";
        stringArray[501] = "maxRatePerInstance";
        stringArray[502] = "UTILIZATION";
        stringArray[503] = "maxUtilization";
        stringArray[504] = "CONNECTION";
        stringArray[505] = "maxConnectionsPerInstance";
        stringArray[506] = "capacityScaler";
        stringArray[507] = "name";
        stringArray[508] = "region";
        stringArray[509] = "findAll";
        stringArray[510] = "getApplicationLoadBalancers";
        stringArray[511] = "collect";
        stringArray[512] = "warn";
        stringArray[513] = "getItems";
        stringArray[514] = "timeExecute";
        stringArray[515] = "list";
        stringArray[516] = "globalForwardingRules";
        stringArray[517] = "TAG_SCOPE";
        stringArray[518] = "SCOPE_GLOBAL";
        stringArray[519] = "getItems";
        stringArray[520] = "timeExecute";
        stringArray[521] = "list";
        stringArray[522] = "targetSslProxies";
        stringArray[523] = "TAG_SCOPE";
        stringArray[524] = "SCOPE_GLOBAL";
        stringArray[525] = "collect";
        stringArray[526] = "findAll";
        stringArray[527] = "collect";
        stringArray[528] = "findAll";
        stringArray[529] = "isDebugEnabled";
        stringArray[530] = "debug";
        stringArray[531] = "name";
        stringArray[532] = "collect";
        stringArray[533] = "each";
        stringArray[534] = "name";
        stringArray[535] = "region";
        stringArray[536] = "findAll";
        stringArray[537] = "getApplicationLoadBalancers";
        stringArray[538] = "collect";
        stringArray[539] = "warn";
        stringArray[540] = "getItems";
        stringArray[541] = "timeExecute";
        stringArray[542] = "list";
        stringArray[543] = "globalForwardingRules";
        stringArray[544] = "TAG_SCOPE";
        stringArray[545] = "SCOPE_GLOBAL";
        stringArray[546] = "getItems";
        stringArray[547] = "timeExecute";
        stringArray[548] = "list";
        stringArray[549] = "targetTcpProxies";
        stringArray[550] = "TAG_SCOPE";
        stringArray[551] = "SCOPE_GLOBAL";
        stringArray[552] = "collect";
        stringArray[553] = "findAll";
        stringArray[554] = "collect";
        stringArray[555] = "findAll";
        stringArray[556] = "isDebugEnabled";
        stringArray[557] = "debug";
        stringArray[558] = "name";
        stringArray[559] = "collect";
        stringArray[560] = "each";
        stringArray[561] = "name";
        stringArray[562] = "region";
        stringArray[563] = "findAll";
        stringArray[564] = "getApplicationLoadBalancers";
        stringArray[565] = "collect";
        stringArray[566] = "warn";
        stringArray[567] = "getItems";
        stringArray[568] = "timeExecute";
        stringArray[569] = "list";
        stringArray[570] = "forwardingRules";
        stringArray[571] = "TAG_SCOPE";
        stringArray[572] = "SCOPE_REGIONAL";
        stringArray[573] = "TAG_REGION";
        stringArray[574] = "findAll";
        stringArray[575] = "collect";
        stringArray[576] = "isDebugEnabled";
        stringArray[577] = "debug";
        stringArray[578] = "name";
        stringArray[579] = "each";
        stringArray[580] = "name";
        stringArray[581] = "get";
        stringArray[582] = "asg";
        stringArray[583] = "isDebugEnabled";
        stringArray[584] = "debug";
        stringArray[585] = "name";
        stringArray[586] = "isDebugEnabled";
        stringArray[587] = "debug";
        stringArray[588] = "findAll";
        stringArray[589] = "getApplicationLoadBalancers";
        stringArray[590] = "isWarnEnabled";
        stringArray[591] = "warn";
        stringArray[592] = "getItems";
        stringArray[593] = "timeExecute";
        stringArray[594] = "list";
        stringArray[595] = "globalForwardingRules";
        stringArray[596] = "TAG_SCOPE";
        stringArray[597] = "SCOPE_GLOBAL";
        stringArray[598] = "findAll";
        stringArray[599] = "minus";
        stringArray[600] = "collect";
        stringArray[601] = "isWarnEnabled";
        stringArray[602] = "warn";
        stringArray[603] = "metadata";
        stringArray[604] = "properties";
        stringArray[605] = "instanceTemplate";
        stringArray[606] = "launchConfig";
        stringArray[607] = "buildMapFromMetadata";
        stringArray[608] = "split";
        stringArray[609] = "get";
        stringArray[610] = "each";
        stringArray[611] = "name";
        stringArray[612] = "region";
        stringArray[613] = "get";
        stringArray[614] = "asg";
        stringArray[615] = "isDebugEnabled";
        stringArray[616] = "debug";
        stringArray[617] = "name";
        stringArray[618] = "isDebugEnabled";
        stringArray[619] = "debug";
        stringArray[620] = "findAll";
        stringArray[621] = "getApplicationLoadBalancers";
        stringArray[622] = "isWarnEnabled";
        stringArray[623] = "warn";
        stringArray[624] = "getItems";
        stringArray[625] = "timeExecute";
        stringArray[626] = "list";
        stringArray[627] = "forwardingRules";
        stringArray[628] = "TAG_SCOPE";
        stringArray[629] = "SCOPE_REGIONAL";
        stringArray[630] = "TAG_REGION";
        stringArray[631] = "findAll";
        stringArray[632] = "minus";
        stringArray[633] = "collect";
        stringArray[634] = "isWarnEnabled";
        stringArray[635] = "warn";
        stringArray[636] = "metadata";
        stringArray[637] = "properties";
        stringArray[638] = "instanceTemplate";
        stringArray[639] = "launchConfig";
        stringArray[640] = "buildMapFromMetadata";
        stringArray[641] = "split";
        stringArray[642] = "get";
        stringArray[643] = "each";
        stringArray[644] = "findAll";
        stringArray[645] = "each";
        stringArray[646] = "getItems";
        stringArray[647] = "timeExecute";
        stringArray[648] = "list";
        stringArray[649] = "urlMaps";
        stringArray[650] = "TAG_SCOPE";
        stringArray[651] = "SCOPE_GLOBAL";
        stringArray[652] = "collectEntries";
        stringArray[653] = "each";
        stringArray[654] = "getItems";
        stringArray[655] = "timeExecute";
        stringArray[656] = "list";
        stringArray[657] = "globalForwardingRules";
        stringArray[658] = "TAG_SCOPE";
        stringArray[659] = "SCOPE_GLOBAL";
        stringArray[660] = "each";
        stringArray[661] = "getTarget";
        stringArray[662] = "getTargetProxyType";
        stringArray[663] = "getLocalName";
        stringArray[664] = "HTTP";
        stringArray[665] = "HTTPS";
        stringArray[666] = "SSL";
        stringArray[667] = "TCP";
        stringArray[668] = "isWarnEnabled";
        stringArray[669] = "warn";
        stringArray[670] = "doRetry";
        stringArray[671] = "TAG_SCOPE";
        stringArray[672] = "SCOPE_GLOBAL";
        stringArray[673] = "registry";
        stringArray[674] = "getTarget";
        stringArray[675] = "getTargetProxyType";
        stringArray[676] = "getLocalName";
        stringArray[677] = "HTTP";
        stringArray[678] = "HTTPS";
        stringArray[679] = "isWarnEnabled";
        stringArray[680] = "warn";
        stringArray[681] = "doRetry";
        stringArray[682] = "TAG_SCOPE";
        stringArray[683] = "SCOPE_REGIONAL";
        stringArray[684] = "TAG_REGION";
        stringArray[685] = "registry";
        stringArray[686] = "doRetry";
        stringArray[687] = "TAG_SCOPE";
        stringArray[688] = "SCOPE_GLOBAL";
        stringArray[689] = "registry";
        stringArray[690] = "timeExecute";
        stringArray[691] = "delete";
        stringArray[692] = "globalForwardingRules";
        stringArray[693] = "getName";
        stringArray[694] = "TAG_SCOPE";
        stringArray[695] = "SCOPE_GLOBAL";
        stringArray[696] = "getTarget";
        stringArray[697] = "getLocalName";
        stringArray[698] = "getTargetProxyType";
        stringArray[699] = "HTTP";
        stringArray[700] = "HTTPS";
        stringArray[701] = "SSL";
        stringArray[702] = "TCP";
        stringArray[703] = "isWarnEnabled";
        stringArray[704] = "warn";
        stringArray[705] = "doRetry";
        stringArray[706] = "TAG_SCOPE";
        stringArray[707] = "SCOPE_GLOBAL";
        stringArray[708] = "registry";
        stringArray[709] = "doRetry";
        stringArray[710] = "TAG_SCOPE";
        stringArray[711] = "SCOPE_REGIONAL";
        stringArray[712] = "TAG_REGION";
        stringArray[713] = "registry";
        stringArray[714] = "timeExecute";
        stringArray[715] = "delete";
        stringArray[716] = "forwardingRules";
        stringArray[717] = "getName";
        stringArray[718] = "TAG_SCOPE";
        stringArray[719] = "SCOPE_REGIONAL";
        stringArray[720] = "TAG_REGION";
        stringArray[721] = "getTarget";
        stringArray[722] = "getLocalName";
        stringArray[723] = "getTargetProxyType";
        stringArray[724] = "HTTP";
        stringArray[725] = "HTTPS";
        stringArray[726] = "isWarnEnabled";
        stringArray[727] = "warn";
        stringArray[728] = "doRetry";
        stringArray[729] = "TAG_SCOPE";
        stringArray[730] = "SCOPE_REGIONAL";
        stringArray[731] = "TAG_REGION";
        stringArray[732] = "registry";
        stringArray[733] = "updateStatus";
        stringArray[734] = "getAt";
        stringArray[735] = "doRetry";
        stringArray[736] = "registry";
        stringArray[737] = "code";
        stringArray[738] = "details";
        stringArray[739] = "reason";
        stringArray[740] = "getAt";
        stringArray[741] = "errors";
        stringArray[742] = "details";
        stringArray[743] = "isWarnEnabled";
        stringArray[744] = "warn";
        stringArray[745] = "code";
        stringArray[746] = "details";
        stringArray[747] = "reason";
        stringArray[748] = "getAt";
        stringArray[749] = "errors";
        stringArray[750] = "details";
        stringArray[751] = "isWarnEnabled";
        stringArray[752] = "warn";
        stringArray[753] = "queryNetwork";
        stringArray[754] = "network";
        stringArray[755] = "<$constructor$>";
        stringArray[756] = "securityGroupName";
        stringArray[757] = "selfLink";
        stringArray[758] = "collect";
        stringArray[759] = "allowed";
        stringArray[760] = "description";
        stringArray[761] = "description";
        stringArray[762] = "sourceRanges";
        stringArray[763] = "sourceRanges";
        stringArray[764] = "sourceTags";
        stringArray[765] = "sourceTags";
        stringArray[766] = "targetTags";
        stringArray[767] = "targetTags";
        stringArray[768] = "checkIntervalSec";
        stringArray[769] = "getCheckIntervalSec";
        stringArray[770] = "healthyThreshold";
        stringArray[771] = "getHealthyThreshold";
        stringArray[772] = "unhealthyThreshold";
        stringArray[773] = "getUnhealthyThreshold";
        stringArray[774] = "timeoutSec";
        stringArray[775] = "getTimeoutSec";
        stringArray[776] = "checkIntervalSec";
        stringArray[777] = "getCheckIntervalSec";
        stringArray[778] = "healthyThreshold";
        stringArray[779] = "getHealthyThreshold";
        stringArray[780] = "unhealthyThreshold";
        stringArray[781] = "getUnhealthyThreshold";
        stringArray[782] = "timeoutSec";
        stringArray[783] = "getTimeoutSec";
        stringArray[784] = "healthCheckType";
        stringArray[785] = "HTTP";
        stringArray[786] = "or";
        stringArray[787] = "port";
        stringArray[788] = "port";
        stringArray[789] = "httpHealthCheck";
        stringArray[790] = "requestPath";
        stringArray[791] = "requestPath";
        stringArray[792] = "httpHealthCheck";
        stringArray[793] = "or";
        stringArray[794] = "port";
        stringArray[795] = "port";
        stringArray[796] = "httpHealthCheck";
        stringArray[797] = "requestPath";
        stringArray[798] = "requestPath";
        stringArray[799] = "httpHealthCheck";
        stringArray[800] = "HTTPS";
        stringArray[801] = "or";
        stringArray[802] = "port";
        stringArray[803] = "port";
        stringArray[804] = "httpsHealthCheck";
        stringArray[805] = "requestPath";
        stringArray[806] = "requestPath";
        stringArray[807] = "httpsHealthCheck";
        stringArray[808] = "or";
        stringArray[809] = "port";
        stringArray[810] = "port";
        stringArray[811] = "httpsHealthCheck";
        stringArray[812] = "requestPath";
        stringArray[813] = "requestPath";
        stringArray[814] = "httpsHealthCheck";
        stringArray[815] = "TCP";
        stringArray[816] = "or";
        stringArray[817] = "port";
        stringArray[818] = "port";
        stringArray[819] = "tcpHealthCheck";
        stringArray[820] = "SSL";
        stringArray[821] = "or";
        stringArray[822] = "port";
        stringArray[823] = "port";
        stringArray[824] = "sslHealthCheck";
        stringArray[825] = "UDP";
        stringArray[826] = "or";
        stringArray[827] = "port";
        stringArray[828] = "port";
        stringArray[829] = "udpHealthCheck";
        stringArray[830] = "<$constructor$>";
        stringArray[831] = "checkIntervalSec";
        stringArray[832] = "healthyThreshold";
        stringArray[833] = "unhealthyThreshold";
        stringArray[834] = "timeoutSec";
        stringArray[835] = "healthCheckType";
        stringArray[836] = "HTTP";
        stringArray[837] = "port";
        stringArray[838] = "httpHealthCheck";
        stringArray[839] = "requestPath";
        stringArray[840] = "httpHealthCheck";
        stringArray[841] = "HTTPS";
        stringArray[842] = "port";
        stringArray[843] = "httpsHealthCheck";
        stringArray[844] = "requestPath";
        stringArray[845] = "httpsHealthCheck";
        stringArray[846] = "TCP";
        stringArray[847] = "port";
        stringArray[848] = "tcpHealthCheck";
        stringArray[849] = "SSL";
        stringArray[850] = "port";
        stringArray[851] = "sslHealthCheck";
        stringArray[852] = "<$constructor$>";
        stringArray[853] = "<$constructor$>";
        stringArray[854] = "name";
        stringArray[855] = "checkIntervalSec";
        stringArray[856] = "healthyThreshold";
        stringArray[857] = "unhealthyThreshold";
        stringArray[858] = "timeoutSec";
        stringArray[859] = "healthCheckType";
        stringArray[860] = "HTTP";
        stringArray[861] = "<$constructor$>";
        stringArray[862] = "port";
        stringArray[863] = "requestPath";
        stringArray[864] = "HTTPS";
        stringArray[865] = "<$constructor$>";
        stringArray[866] = "port";
        stringArray[867] = "requestPath";
        stringArray[868] = "TCP";
        stringArray[869] = "<$constructor$>";
        stringArray[870] = "port";
        stringArray[871] = "SSL";
        stringArray[872] = "<$constructor$>";
        stringArray[873] = "port";
        stringArray[874] = "<$constructor$>";
        stringArray[875] = "getItems";
        stringArray[876] = "timeExecute";
        stringArray[877] = "list";
        stringArray[878] = "backendServices";
        stringArray[879] = "TAG_SCOPE";
        stringArray[880] = "SCOPE_GLOBAL";
        stringArray[881] = "getItems";
        stringArray[882] = "timeExecute";
        stringArray[883] = "list";
        stringArray[884] = "regionBackendServices";
        stringArray[885] = "TAG_SCOPE";
        stringArray[886] = "SCOPE_REGIONAL";
        stringArray[887] = "TAG_REGION";
        stringArray[888] = "timeExecute";
        stringArray[889] = "setPageToken";
        stringArray[890] = "list";
        stringArray[891] = "httpHealthChecks";
        stringArray[892] = "TAG_SCOPE";
        stringArray[893] = "SCOPE_GLOBAL";
        stringArray[894] = "getNextPageToken";
        stringArray[895] = "addAll";
        stringArray[896] = "getItems";
        stringArray[897] = "timeExecute";
        stringArray[898] = "setPageToken";
        stringArray[899] = "list";
        stringArray[900] = "httpsHealthChecks";
        stringArray[901] = "TAG_SCOPE";
        stringArray[902] = "SCOPE_GLOBAL";
        stringArray[903] = "getNextPageToken";
        stringArray[904] = "addAll";
        stringArray[905] = "getItems";
        stringArray[906] = "timeExecute";
        stringArray[907] = "setPageToken";
        stringArray[908] = "list";
        stringArray[909] = "healthChecks";
        stringArray[910] = "TAG_SCOPE";
        stringArray[911] = "SCOPE_GLOBAL";
        stringArray[912] = "getNextPageToken";
        stringArray[913] = "addAll";
        stringArray[914] = "getItems";
        stringArray[915] = "timeExecute";
        stringArray[916] = "setPageToken";
        stringArray[917] = "list";
        stringArray[918] = "regionHealthChecks";
        stringArray[919] = "TAG_SCOPE";
        stringArray[920] = "SCOPE_REGIONAL";
        stringArray[921] = "TAG_REGION";
        stringArray[922] = "getNextPageToken";
        stringArray[923] = "addAll";
        stringArray[924] = "getItems";
        stringArray[925] = "<$constructor$>";
        stringArray[926] = "timeExecute";
        stringArray[927] = "setPageToken";
        stringArray[928] = "aggregatedList";
        stringArray[929] = "instances";
        stringArray[930] = "compute";
        stringArray[931] = "project";
        stringArray[932] = "TAG_SCOPE";
        stringArray[933] = "SCOPE_GLOBAL";
        stringArray[934] = "plus";
        stringArray[935] = "transformInstances";
        stringArray[936] = "getNextPageToken";
        stringArray[937] = "each";
        stringArray[938] = "items";
        stringArray[939] = "each";
        stringArray[940] = "healthStatus";
        stringArray[941] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[942];
        GCEUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GCEUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GCEUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

