/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.FixedOrPercent;
import com.google.api.services.compute.model.InstanceGroupManagerAutoHealingPolicy;
import com.google.api.services.compute.model.InstanceGroupManagersSetAutoHealingRequest;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetAutoHealingRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleAutoscalingPolicyDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoHealingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleAutoscalingPolicyAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "UPSERT_SCALING_POLICY";
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private AtomicOperationsRegistry atomicOperationsRegistry;
    @Autowired
    private OrchestrationProcessor orchestrationProcessor;
    @Autowired
    private Cache cacheView;
    @Autowired
    private ObjectMapper objectMapper;
    private final UpsertGoogleAutoscalingPolicyDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UpsertGoogleAutoscalingPolicyAtomicOperation(UpsertGoogleAutoscalingPolicyDescription description) {
        UpsertGoogleAutoscalingPolicyDescription upsertGoogleAutoscalingPolicyDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleAutoscalingPolicyDescription = description;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Initializing upsert of scaling policy for ", "..."}));
        Reference serverGroupName = new Reference(callSiteArray[5].callGroovyObjectGetProperty((Object)this.description));
        Object credentials = callSiteArray[6].callGroovyObjectGetProperty((Object)this.description);
        Reference project = new Reference(callSiteArray[7].callGetProperty(credentials));
        Reference compute = new Reference(callSiteArray[8].callGetProperty(credentials));
        Object accountName = callSiteArray[9].callGroovyObjectGetProperty((Object)this.description);
        Reference region = new Reference(callSiteArray[10].callGroovyObjectGetProperty((Object)this.description));
        Object serverGroup = callSiteArray[11].call(GCEUtil.class, (Object)this.googleClusterProvider, accountName, region.get(), serverGroupName.get());
        Object isRegional = callSiteArray[12].callGetProperty(serverGroup);
        Reference zone = new Reference(callSiteArray[13].callGetProperty(serverGroup));
        Object autoscaler = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.description))) {
            Object ancestorAutoscalingPolicyDescription = callSiteArray[15].callGetProperty(serverGroup);
            if (DefaultTypeTransformation.booleanUnbox((Object)ancestorAutoscalingPolicyDescription)) {
                Object object;
                callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Updating autoscaler for ", "..."}));
                autoscaler = object = callSiteArray[18].call(GCEUtil.class, serverGroupName.get(), callSiteArray[19].callGetProperty(serverGroup), callSiteArray[20].callStatic(UpsertGoogleAutoscalingPolicyAtomicOperation.class, ancestorAutoscalingPolicyDescription, callSiteArray[21].callGroovyObjectGetProperty((Object)this.description)));
                if (DefaultTypeTransformation.booleanUnbox((Object)isRegional)) {
                    Object updateOp = callSiteArray[22].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[23].call(callSiteArray[24].call(compute.get()), project.get(), region.get(), autoscaler), (Object)"compute.regionAutoscalers.update", (Object)callSiteArray[25].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[26].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this), (Object)region.get()));
                    callSiteArray[28].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)region.get(), (Object)callSiteArray[29].call(updateOp), null, (Object)callSiteArray[30].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[31].call(autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), (Object)BASE_PHASE));
                } else {
                    Object updateOp = callSiteArray[32].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[33].call(callSiteArray[34].call(compute.get()), project.get(), zone.get(), autoscaler), (Object)"compute.autoscalers.update", (Object)callSiteArray[35].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[36].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[37].callGroovyObjectGetProperty((Object)this), (Object)zone.get()));
                    callSiteArray[38].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)zone.get(), (Object)callSiteArray[39].call(updateOp), null, (Object)callSiteArray[40].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[41].call(autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), (Object)BASE_PHASE));
                }
            } else {
                Object object;
                callSiteArray[42].call(callSiteArray[43].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Creating new autoscaler for ", "..."}));
                autoscaler = object = callSiteArray[44].call(GCEUtil.class, serverGroupName.get(), callSiteArray[45].callGetProperty(serverGroup), callSiteArray[46].callStatic(UpsertGoogleAutoscalingPolicyAtomicOperation.class, callSiteArray[47].callGroovyObjectGetProperty((Object)this.description)));
                if (DefaultTypeTransformation.booleanUnbox((Object)isRegional)) {
                    Object insertOp = callSiteArray[48].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[49].call(callSiteArray[50].call(compute.get()), project.get(), region.get(), autoscaler), (Object)"compute.regionAutoscalers.insert", (Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[52].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[53].callGroovyObjectGetProperty((Object)this), (Object)region.get()));
                    callSiteArray[54].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)region.get(), (Object)callSiteArray[55].call(insertOp), null, (Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[57].call(autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), (Object)BASE_PHASE));
                } else {
                    Object insertOp = callSiteArray[58].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[59].call(callSiteArray[60].call(compute.get()), project.get(), zone.get(), autoscaler), (Object)"compute.autoscalers.insert", (Object)callSiteArray[61].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[63].callGroovyObjectGetProperty((Object)this), (Object)zone.get()));
                    callSiteArray[64].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)zone.get(), (Object)callSiteArray[65].call(insertOp), null, (Object)callSiteArray[66].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[67].call(autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), (Object)BASE_PHASE));
                }
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].callGroovyObjectGetProperty((Object)this.description))) {
            Object ancestorAutoHealingPolicyDescription = callSiteArray[69].call(GCEUtil.class, callSiteArray[70].callGetProperty(serverGroup));
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure1(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference serverGroupName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.serverGroupName = reference = serverGroupName;
                }

                public Object doCall(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    Object request = callSiteArray[0].call(callSiteArray[1].callConstructor(RegionInstanceGroupManagersSetAutoHealingRequest.class), policy);
                    Object autoHealingOp = callSiteArray[2].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[3].call(callSiteArray[4].call(this.compute.get()), this.project.get(), this.region.get(), this.serverGroupName.get(), request), (Object)"compute.regionInstanceGroupManagers.setAutoHealingPolicies", (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
                    return callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)this.region.get(), (Object)callSiteArray[10].call(autoHealingOp), null, (Object)callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{policy, this.serverGroupName.get()}, new String[]{"autoHealing policy ", " for server group ", ""}), (Object)ScriptBytecodeAdapter.getField(_operate_closure1.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (String)"BASE_PHASE")));
                }

                public Object call(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return callSiteArray[12].callCurrent((GroovyObject)this, policy);
                }

                @Generated
                public Object getCompute() {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public Object getRegion() {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return this.region.get();
                }

                @Generated
                public Object getServerGroupName() {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return this.serverGroupName.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "setAutoHealingPolicies";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "timeExecute";
                    stringArray[3] = "setAutoHealingPolicies";
                    stringArray[4] = "regionInstanceGroupManagers";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_REGIONAL";
                    stringArray[7] = "TAG_REGION";
                    stringArray[8] = "waitForRegionalOperation";
                    stringArray[9] = "googleOperationPoller";
                    stringArray[10] = "getName";
                    stringArray[11] = "task";
                    stringArray[12] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[13];
                    _operate_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _operate_closure1 regionalRequest = new _operate_closure1(this, this, compute, project, region, serverGroupName);
            public final class _operate_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference zone;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference zone, Reference serverGroupName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.zone = reference2 = zone;
                    this.serverGroupName = reference = serverGroupName;
                }

                public Object doCall(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    Object request = callSiteArray[0].call(callSiteArray[1].callConstructor(InstanceGroupManagersSetAutoHealingRequest.class), policy);
                    Object autoHealingOp = callSiteArray[2].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[3].call(callSiteArray[4].call(this.compute.get()), this.project.get(), this.zone.get(), this.serverGroupName.get(), request), (Object)"compute.instanceGroupManagers.setAutoHealingPolicies", (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)this.zone.get()));
                    return callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)this.zone.get(), (Object)callSiteArray[10].call(autoHealingOp), null, (Object)callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{policy, this.serverGroupName.get()}, new String[]{"autoHealing policy ", " for server group ", ""}), (Object)ScriptBytecodeAdapter.getField(_operate_closure2.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (String)"BASE_PHASE")));
                }

                public Object call(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    return callSiteArray[12].callCurrent((GroovyObject)this, policy);
                }

                @Generated
                public Object getCompute() {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public Object getZone() {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    return this.zone.get();
                }

                @Generated
                public Object getServerGroupName() {
                    CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                    return this.serverGroupName.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "setAutoHealingPolicies";
                    stringArray[1] = "<$constructor$>";
                    stringArray[2] = "timeExecute";
                    stringArray[3] = "setAutoHealingPolicies";
                    stringArray[4] = "instanceGroupManagers";
                    stringArray[5] = "TAG_SCOPE";
                    stringArray[6] = "SCOPE_ZONAL";
                    stringArray[7] = "TAG_ZONE";
                    stringArray[8] = "waitForZonalOperation";
                    stringArray[9] = "googleOperationPoller";
                    stringArray[10] = "getName";
                    stringArray[11] = "task";
                    stringArray[12] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[13];
                    _operate_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            _operate_closure2 zonalRequest = new _operate_closure2(this, this, compute, project, zone, serverGroupName);
            if (DefaultTypeTransformation.booleanUnbox((Object)ancestorAutoHealingPolicyDescription)) {
                callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Updating autoHealing policy for ", "..."}));
                Object autoHealingPolicy = callSiteArray[73].callCurrent((GroovyObject)this, callSiteArray[74].callStatic(UpsertGoogleAutoscalingPolicyAtomicOperation.class, ancestorAutoHealingPolicyDescription, callSiteArray[75].callGroovyObjectGetProperty((Object)this.description)), project.get(), compute.get());
                Object object = DefaultTypeTransformation.booleanUnbox((Object)isRegional) ? callSiteArray[76].call((Object)regionalRequest, autoHealingPolicy) : callSiteArray[77].call((Object)zonalRequest, autoHealingPolicy);
            } else {
                callSiteArray[78].call(callSiteArray[79].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Creating new autoHealing policy for ", "..."}));
                Object autoHealingPolicy = callSiteArray[80].callCurrent((GroovyObject)this, callSiteArray[81].callStatic(UpsertGoogleAutoscalingPolicyAtomicOperation.class, callSiteArray[82].callGroovyObjectGetProperty((Object)this.description)), project.get(), compute.get());
                Object object = DefaultTypeTransformation.booleanUnbox((Object)isRegional) ? callSiteArray[83].call((Object)regionalRequest, autoHealingPolicy) : callSiteArray[84].call((Object)zonalRequest, autoHealingPolicy);
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[85].callGroovyObjectGetProperty((Object)this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].callGroovyObjectGetProperty((Object)this.description))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)isRegional)) {
                callSiteArray[87].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)compute.get(), (Object)credentials, (Object)project.get(), (Object)callSiteArray[88].call(GCEUtil.class, project.get(), region.get(), serverGroupName.get()), autoscaler));
            } else {
                callSiteArray[89].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)compute.get(), (Object)credentials, (Object)project.get(), (Object)callSiteArray[90].call(GCEUtil.class, project.get(), zone.get(), serverGroupName.get()), autoscaler));
            }
        }
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private static GoogleAutoscalingPolicy copyAndOverrideAncestorAutoscalingPolicy(GoogleAutoscalingPolicy ancestor, GoogleAutoscalingPolicy update) {
        Reference update2 = new Reference((Object)update);
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        Reference newDescription = new Reference((Object)((GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)ancestor), GoogleAutoscalingPolicy.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((GoogleAutoscalingPolicy)update2.get()))) {
            return (GoogleAutoscalingPolicy)newDescription.get();
        }
        public final class _copyAndOverrideAncestorAutoscalingPolicy_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copyAndOverrideAncestorAutoscalingPolicy_closure3(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(this.update.get(), it), null)) {
                    Object object = callSiteArray[1].call(this.update.get(), it);
                    callSiteArray[2].call(this.newDescription.get(), it, object);
                    return object;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getUpdate() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$getCallSiteArray();
                return (GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)this.update.get(), GoogleAutoscalingPolicy.class);
            }

            @Generated
            public GoogleAutoscalingPolicy getNewDescription() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$getCallSiteArray();
                return (GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)this.newDescription.get(), GoogleAutoscalingPolicy.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoscalingPolicy_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "getAt";
                stringArray[2] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _copyAndOverrideAncestorAutoscalingPolicy_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copyAndOverrideAncestorAutoscalingPolicy_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[92].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"minNumReplicas", "maxNumReplicas", "coolDownPeriodSec", "customMetricUtilizations", "mode", "scalingSchedules"}), (Object)new _copyAndOverrideAncestorAutoscalingPolicy_closure3(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[93].callGroovyObjectGetProperty((Object)((GoogleAutoscalingPolicy)update2.get())), null)) {
            Object scaleInControl = callSiteArray[94].callGroovyObjectGetProperty((Object)((GoogleAutoscalingPolicy)update2.get()));
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[95].callGetProperty(scaleInControl), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[96].callGetProperty(scaleInControl), null)) {
                    Object object = scaleInControl;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
                } else {
                    Object var7_7 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var7_7, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[97].callGetProperty(scaleInControl), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[98].callGetProperty(scaleInControl), null)) {
                Object object = scaleInControl;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
            } else {
                Object var9_9 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var9_9, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
            }
        }
        public final class _copyAndOverrideAncestorAutoscalingPolicy_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copyAndOverrideAncestorAutoscalingPolicy_closure4(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(this.update.get(), it), null)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[1].callGetProperty(callSiteArray[2].call(this.update.get(), it)), null)) {
                        Object object = callSiteArray[3].call(this.update.get(), it);
                        callSiteArray[4].call(this.newDescription.get(), it, object);
                        return object;
                    }
                    Object var4_4 = null;
                    callSiteArray[5].call(this.newDescription.get(), it, var4_4);
                    return var4_4;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getUpdate() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$getCallSiteArray();
                return (GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)this.update.get(), GoogleAutoscalingPolicy.class);
            }

            @Generated
            public GoogleAutoscalingPolicy getNewDescription() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$getCallSiteArray();
                return (GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)this.newDescription.get(), GoogleAutoscalingPolicy.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoscalingPolicy_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "utilizationTarget";
                stringArray[2] = "getAt";
                stringArray[3] = "getAt";
                stringArray[4] = "putAt";
                stringArray[5] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _copyAndOverrideAncestorAutoscalingPolicy_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copyAndOverrideAncestorAutoscalingPolicy_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copyAndOverrideAncestorAutoscalingPolicy_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[99].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"cpuUtilization", "loadBalancingUtilization"}), (Object)new _copyAndOverrideAncestorAutoscalingPolicy_closure4(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        return (GoogleAutoscalingPolicy)newDescription.get();
    }

    private static GoogleAutoscalingPolicy normalizeNewAutoscalingPolicy(GoogleAutoscalingPolicy newPolicy) {
        Reference newPolicy2 = new Reference((Object)newPolicy);
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        public final class _normalizeNewAutoscalingPolicy_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference newPolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _normalizeNewAutoscalingPolicy_closure5(Object _outerInstance, Object _thisObject, Reference newPolicy) {
                Reference reference;
                CallSite[] callSiteArray = _normalizeNewAutoscalingPolicy_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.newPolicy = reference = newPolicy;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _normalizeNewAutoscalingPolicy_closure5.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetPropertySafe(callSiteArray[1].call(this.newPolicy.get(), it)), null)) {
                    Object var3_3 = null;
                    callSiteArray[2].call(this.newPolicy.get(), it, var3_3);
                    return var3_3;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getNewPolicy() {
                CallSite[] callSiteArray = _normalizeNewAutoscalingPolicy_closure5.$getCallSiteArray();
                return (GoogleAutoscalingPolicy)ScriptBytecodeAdapter.castToType((Object)this.newPolicy.get(), GoogleAutoscalingPolicy.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _normalizeNewAutoscalingPolicy_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _normalizeNewAutoscalingPolicy_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "utilizationTarget";
                stringArray[1] = "getAt";
                stringArray[2] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _normalizeNewAutoscalingPolicy_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_normalizeNewAutoscalingPolicy_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _normalizeNewAutoscalingPolicy_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[100].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"cpuUtilization", "loadBalancingUtilization"}), (Object)new _normalizeNewAutoscalingPolicy_closure5(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, newPolicy2));
        return (GoogleAutoscalingPolicy)newPolicy2.get();
    }

    @VisibleForTesting
    public static GoogleAutoHealingPolicy copyAndOverrideAncestorAutoHealingPolicy(GoogleAutoHealingPolicy ancestor, GoogleAutoHealingPolicy update) {
        Reference update2 = new Reference((Object)update);
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        Reference newDescription = new Reference((Object)((GoogleAutoHealingPolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call((Object)ancestor), GoogleAutoHealingPolicy.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((GoogleAutoHealingPolicy)update2.get()))) {
            return (GoogleAutoHealingPolicy)newDescription.get();
        }
        public final class _copyAndOverrideAncestorAutoHealingPolicy_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copyAndOverrideAncestorAutoHealingPolicy_closure6(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(this.update.get(), it), null)) {
                    Object object = callSiteArray[1].call(this.update.get(), it);
                    callSiteArray[2].call(this.newDescription.get(), it, object);
                    return object;
                }
                return null;
            }

            @Generated
            public GoogleAutoHealingPolicy getUpdate() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$getCallSiteArray();
                return (GoogleAutoHealingPolicy)ScriptBytecodeAdapter.castToType((Object)this.update.get(), GoogleAutoHealingPolicy.class);
            }

            @Generated
            public GoogleAutoHealingPolicy getNewDescription() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$getCallSiteArray();
                return (GoogleAutoHealingPolicy)ScriptBytecodeAdapter.castToType((Object)this.newDescription.get(), GoogleAutoHealingPolicy.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoHealingPolicy_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "getAt";
                stringArray[2] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _copyAndOverrideAncestorAutoHealingPolicy_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copyAndOverrideAncestorAutoHealingPolicy_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copyAndOverrideAncestorAutoHealingPolicy_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[102].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"healthCheck", "initialDelaySec", "healthCheckKind"}), (Object)new _copyAndOverrideAncestorAutoHealingPolicy_closure6(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[103].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get())), null)) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[104].callGetProperty(callSiteArray[105].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()))), null) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[106].callGetProperty(callSiteArray[107].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()))), null)) {
                    Object object = callSiteArray[108].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
                } else {
                    Object var6_6 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var6_6, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
                }
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[109].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get())), null)) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[110].callGetProperty(callSiteArray[111].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()))), null) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[112].callGetProperty(callSiteArray[113].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()))), null)) {
                Object object = callSiteArray[114].callGroovyObjectGetProperty((Object)((GoogleAutoHealingPolicy)update2.get()));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
            } else {
                Object var8_8 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var8_8, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
            }
        }
        return (GoogleAutoHealingPolicy)newDescription.get();
    }

    private static GoogleAutoHealingPolicy normalizeNewAutoHealingPolicy(GoogleAutoHealingPolicy newPolicy) {
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[115].callGetPropertySafe(callSiteArray[116].callGroovyObjectGetProperty((Object)newPolicy)), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[117].callGetPropertySafe(callSiteArray[118].callGroovyObjectGetProperty((Object)newPolicy)), null)) {
                Object var2_2 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var2_2, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)newPolicy, (String)"maxUnavailable");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[119].callGetPropertySafe(callSiteArray[120].callGroovyObjectGetProperty((Object)newPolicy)), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[121].callGetPropertySafe(callSiteArray[122].callGroovyObjectGetProperty((Object)newPolicy)), null)) {
            Object var3_3 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var3_3, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)newPolicy, (String)"maxUnavailable");
        }
        return newPolicy;
    }

    private Object buildAutoHealingPolicyFromAutoHealingPolicyDescription(GoogleAutoHealingPolicy autoHealingPolicyDescription, String project, Compute compute) {
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        Object autoHealingHealthCheck = callSiteArray[123].call(GCEUtil.class, ArrayUtil.createArray((Object)project, (Object)callSiteArray[124].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[125].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription), (Object)callSiteArray[126].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription), (Object)compute, (Object)this.cacheView, (Object)callSiteArray[127].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)this));
        List autoHealingPolicy = (List)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].callGroovyObjectGetPropertySafe((Object)autoHealingPolicyDescription)) ? ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[129].callConstructor(InstanceGroupManagerAutoHealingPolicy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", callSiteArray[130].callGetProperty(autoHealingHealthCheck), "initialDelaySec", callSiteArray[131].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription)}))}) : null, List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)autoHealingPolicy) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[132].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription))) {
            Object maxUnavailable = callSiteArray[133].callConstructor(FixedOrPercent.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fixed", (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[134].callGetProperty(callSiteArray[135].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription)), Integer.class), "percent", (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[136].callGetProperty(callSiteArray[137].callGroovyObjectGetProperty((Object)autoHealingPolicyDescription)), Integer.class)}));
            callSiteArray[138].call(callSiteArray[139].call((Object)autoHealingPolicy, (Object)0), maxUnavailable);
        }
        return autoHealingPolicy;
    }

    public void updatePolicyMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, String groupUrl, Object autoscaler) {
        CallSite[] callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$getCallSiteArray();
        Object groupName = callSiteArray[140].call(Utils.class, (Object)groupUrl);
        Object groupRegion = callSiteArray[141].call(Utils.class, (Object)groupUrl);
        String templateUrl = null;
        Object object = callSiteArray[142].call(Utils.class, (Object)groupUrl);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[143].callGetProperty(GoogleServerGroup.ServerGroupType.class))) {
            Object object2 = callSiteArray[144].call(callSiteArray[145].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[146].call(callSiteArray[147].call((Object)compute), (Object)project, groupRegion, groupName), (Object)"compute.regionInstanceGroupManagers.get", (Object)callSiteArray[148].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[149].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[150].callGroovyObjectGetProperty((Object)this), (Object)groupRegion)));
            templateUrl = ShortTypeHandling.castToString((Object)object2);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[151].callGetProperty(GoogleServerGroup.ServerGroupType.class))) {
            Object groupZone = callSiteArray[152].call(Utils.class, (Object)groupUrl);
            Object object3 = callSiteArray[153].call(callSiteArray[154].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[155].call(callSiteArray[156].call((Object)compute), (Object)project, groupZone, groupName), (Object)"compute.instanceGroupManagers.get", (Object)callSiteArray[157].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[158].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[159].callGroovyObjectGetProperty((Object)this), (Object)groupZone)));
            templateUrl = ShortTypeHandling.castToString((Object)object3);
        } else {
            throw (Throwable)callSiteArray[160].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{groupUrl}, new String[]{"Server group referenced by ", " has illegal type."}));
        }
        InstanceTemplate template = (InstanceTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].callCurrent((GroovyObject)this, callSiteArray[162].call(callSiteArray[163].call((Object)compute), (Object)project, callSiteArray[164].call(Utils.class, (Object)templateUrl)), (Object)"compute.instancesTemplates.get", callSiteArray[165].callGroovyObjectGetProperty((Object)this), callSiteArray[166].callGroovyObjectGetProperty((Object)this)), InstanceTemplate.class);
        Object instanceDescription = callSiteArray[167].call(GCEUtil.class, (Object)project, (Object)template);
        Map templateOpMap = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", callSiteArray[168].callGetProperty(instanceDescription), "instanceType", callSiteArray[169].callGetProperty(instanceDescription), "credentials", callSiteArray[170].call((Object)credentials), "disks", callSiteArray[171].callGetProperty(instanceDescription), "instanceMetadata", callSiteArray[172].callGetProperty(instanceDescription), "tags", callSiteArray[173].callGetProperty(instanceDescription), "network", callSiteArray[174].callGetProperty(instanceDescription), "subnet", callSiteArray[175].callGetProperty(instanceDescription), "serviceAccountEmail", callSiteArray[176].callGetProperty(instanceDescription), "authScopes", callSiteArray[177].callGetProperty(instanceDescription), "preemptible", callSiteArray[178].callGetProperty(instanceDescription), "automaticRestart", callSiteArray[179].callGetProperty(instanceDescription), "onHostMaintenance", callSiteArray[180].callGetProperty(instanceDescription), "region", groupRegion, "serverGroupName", groupName});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[181].callGetProperty(instanceDescription))) {
            Object object4 = callSiteArray[182].callGetProperty(instanceDescription);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)templateOpMap, (String)"minCpuPlatform");
        }
        Object instanceMetadata = callSiteArray[183].callGetPropertySafe((Object)templateOpMap);
        if (DefaultTypeTransformation.booleanUnbox((Object)instanceMetadata) && DefaultTypeTransformation.booleanUnbox((Object)autoscaler)) {
            Object object5 = callSiteArray[184].call((Object)this.objectMapper, autoscaler);
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)instanceMetadata, (String)ShortTypeHandling.castToString((Object)callSiteArray[185].callGetProperty(GCEUtil.class)));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)autoscaler)) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[186].callGetProperty(GCEUtil.class), callSiteArray[187].call((Object)this.objectMapper, autoscaler)});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)templateOpMap, (String)"instanceMetadata");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[188].callGetProperty((Object)templateOpMap))) {
            Object converter = callSiteArray[189].call((Object)this.atomicOperationsRegistry, (Object)"modifyGoogleServerGroupInstanceTemplateDescription", (Object)"gce");
            AtomicOperation templateOp = (AtomicOperation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].call(converter, (Object)templateOpMap), AtomicOperation.class);
            callSiteArray[191].call((Object)this.orchestrationProcessor, (Object)"gce", (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{templateOp}), callSiteArray[192].call(callSiteArray[193].call(UUID.class)));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleAutoscalingPolicyAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    @Generated
    public void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    @Generated
    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    @Generated
    public void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    @Generated
    public Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public void setCacheView(Cache cache) {
        this.cacheView = cache;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "updateStatus";
        stringArray[3] = "task";
        stringArray[4] = "serverGroupName";
        stringArray[5] = "serverGroupName";
        stringArray[6] = "credentials";
        stringArray[7] = "project";
        stringArray[8] = "compute";
        stringArray[9] = "accountName";
        stringArray[10] = "region";
        stringArray[11] = "queryServerGroup";
        stringArray[12] = "regional";
        stringArray[13] = "zone";
        stringArray[14] = "autoscalingPolicy";
        stringArray[15] = "autoscalingPolicy";
        stringArray[16] = "updateStatus";
        stringArray[17] = "task";
        stringArray[18] = "buildAutoscaler";
        stringArray[19] = "selfLink";
        stringArray[20] = "copyAndOverrideAncestorAutoscalingPolicy";
        stringArray[21] = "autoscalingPolicy";
        stringArray[22] = "timeExecute";
        stringArray[23] = "update";
        stringArray[24] = "regionAutoscalers";
        stringArray[25] = "TAG_SCOPE";
        stringArray[26] = "SCOPE_REGIONAL";
        stringArray[27] = "TAG_REGION";
        stringArray[28] = "waitForRegionalOperation";
        stringArray[29] = "getName";
        stringArray[30] = "task";
        stringArray[31] = "getName";
        stringArray[32] = "timeExecute";
        stringArray[33] = "update";
        stringArray[34] = "autoscalers";
        stringArray[35] = "TAG_SCOPE";
        stringArray[36] = "SCOPE_ZONAL";
        stringArray[37] = "TAG_ZONE";
        stringArray[38] = "waitForZonalOperation";
        stringArray[39] = "getName";
        stringArray[40] = "task";
        stringArray[41] = "getName";
        stringArray[42] = "updateStatus";
        stringArray[43] = "task";
        stringArray[44] = "buildAutoscaler";
        stringArray[45] = "selfLink";
        stringArray[46] = "normalizeNewAutoscalingPolicy";
        stringArray[47] = "autoscalingPolicy";
        stringArray[48] = "timeExecute";
        stringArray[49] = "insert";
        stringArray[50] = "regionAutoscalers";
        stringArray[51] = "TAG_SCOPE";
        stringArray[52] = "SCOPE_REGIONAL";
        stringArray[53] = "TAG_REGION";
        stringArray[54] = "waitForRegionalOperation";
        stringArray[55] = "getName";
        stringArray[56] = "task";
        stringArray[57] = "getName";
        stringArray[58] = "timeExecute";
        stringArray[59] = "insert";
        stringArray[60] = "autoscalers";
        stringArray[61] = "TAG_SCOPE";
        stringArray[62] = "SCOPE_ZONAL";
        stringArray[63] = "TAG_ZONE";
        stringArray[64] = "waitForZonalOperation";
        stringArray[65] = "getName";
        stringArray[66] = "task";
        stringArray[67] = "getName";
        stringArray[68] = "autoHealingPolicy";
        stringArray[69] = "buildAutoHealingPolicyDescriptionFromAutoHealingPolicy";
        stringArray[70] = "autoHealingPolicy";
        stringArray[71] = "updateStatus";
        stringArray[72] = "task";
        stringArray[73] = "buildAutoHealingPolicyFromAutoHealingPolicyDescription";
        stringArray[74] = "copyAndOverrideAncestorAutoHealingPolicy";
        stringArray[75] = "autoHealingPolicy";
        stringArray[76] = "call";
        stringArray[77] = "call";
        stringArray[78] = "updateStatus";
        stringArray[79] = "task";
        stringArray[80] = "buildAutoHealingPolicyFromAutoHealingPolicyDescription";
        stringArray[81] = "normalizeNewAutoHealingPolicy";
        stringArray[82] = "autoHealingPolicy";
        stringArray[83] = "call";
        stringArray[84] = "call";
        stringArray[85] = "writeMetadata";
        stringArray[86] = "writeMetadata";
        stringArray[87] = "updatePolicyMetadata";
        stringArray[88] = "buildRegionalServerGroupUrl";
        stringArray[89] = "updatePolicyMetadata";
        stringArray[90] = "buildZonalServerGroupUrl";
        stringArray[91] = "clone";
        stringArray[92] = "each";
        stringArray[93] = "scaleInControl";
        stringArray[94] = "scaleInControl";
        stringArray[95] = "timeWindowSec";
        stringArray[96] = "maxScaledInReplicas";
        stringArray[97] = "timeWindowSec";
        stringArray[98] = "maxScaledInReplicas";
        stringArray[99] = "each";
        stringArray[100] = "each";
        stringArray[101] = "clone";
        stringArray[102] = "each";
        stringArray[103] = "maxUnavailable";
        stringArray[104] = "fixed";
        stringArray[105] = "maxUnavailable";
        stringArray[106] = "percent";
        stringArray[107] = "maxUnavailable";
        stringArray[108] = "maxUnavailable";
        stringArray[109] = "maxUnavailable";
        stringArray[110] = "fixed";
        stringArray[111] = "maxUnavailable";
        stringArray[112] = "percent";
        stringArray[113] = "maxUnavailable";
        stringArray[114] = "maxUnavailable";
        stringArray[115] = "fixed";
        stringArray[116] = "maxUnavailable";
        stringArray[117] = "percent";
        stringArray[118] = "maxUnavailable";
        stringArray[119] = "fixed";
        stringArray[120] = "maxUnavailable";
        stringArray[121] = "percent";
        stringArray[122] = "maxUnavailable";
        stringArray[123] = "queryHealthCheck";
        stringArray[124] = "accountName";
        stringArray[125] = "healthCheck";
        stringArray[126] = "healthCheckKind";
        stringArray[127] = "task";
        stringArray[128] = "healthCheck";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "selfLink";
        stringArray[131] = "initialDelaySec";
        stringArray[132] = "maxUnavailable";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "fixed";
        stringArray[135] = "maxUnavailable";
        stringArray[136] = "percent";
        stringArray[137] = "maxUnavailable";
        stringArray[138] = "setMaxUnavailable";
        stringArray[139] = "getAt";
        stringArray[140] = "getLocalName";
        stringArray[141] = "getRegionFromGroupUrl";
        stringArray[142] = "determineServerGroupType";
        stringArray[143] = "REGIONAL";
        stringArray[144] = "getInstanceTemplate";
        stringArray[145] = "timeExecute";
        stringArray[146] = "get";
        stringArray[147] = "regionInstanceGroupManagers";
        stringArray[148] = "TAG_SCOPE";
        stringArray[149] = "SCOPE_REGIONAL";
        stringArray[150] = "TAG_REGION";
        stringArray[151] = "ZONAL";
        stringArray[152] = "getZoneFromGroupUrl";
        stringArray[153] = "getInstanceTemplate";
        stringArray[154] = "timeExecute";
        stringArray[155] = "get";
        stringArray[156] = "instanceGroupManagers";
        stringArray[157] = "TAG_SCOPE";
        stringArray[158] = "SCOPE_ZONAL";
        stringArray[159] = "TAG_ZONE";
        stringArray[160] = "<$constructor$>";
        stringArray[161] = "timeExecute";
        stringArray[162] = "get";
        stringArray[163] = "instanceTemplates";
        stringArray[164] = "getLocalName";
        stringArray[165] = "TAG_SCOPE";
        stringArray[166] = "SCOPE_GLOBAL";
        stringArray[167] = "buildInstanceDescriptionFromTemplate";
        stringArray[168] = "image";
        stringArray[169] = "instanceType";
        stringArray[170] = "getName";
        stringArray[171] = "disks";
        stringArray[172] = "instanceMetadata";
        stringArray[173] = "tags";
        stringArray[174] = "network";
        stringArray[175] = "subnet";
        stringArray[176] = "serviceAccountEmail";
        stringArray[177] = "authScopes";
        stringArray[178] = "preemptible";
        stringArray[179] = "automaticRestart";
        stringArray[180] = "onHostMaintenance";
        stringArray[181] = "minCpuPlatform";
        stringArray[182] = "minCpuPlatform";
        stringArray[183] = "instanceMetadata";
        stringArray[184] = "writeValueAsString";
        stringArray[185] = "AUTOSCALING_POLICY";
        stringArray[186] = "AUTOSCALING_POLICY";
        stringArray[187] = "writeValueAsString";
        stringArray[188] = "instanceMetadata";
        stringArray[189] = "getAtomicOperationConverter";
        stringArray[190] = "convertOperation";
        stringArray[191] = "process";
        stringArray[192] = "toString";
        stringArray[193] = "randomUUID";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[194];
        UpsertGoogleAutoscalingPolicyAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UpsertGoogleAutoscalingPolicyAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UpsertGoogleAutoscalingPolicyAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

