/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapList;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleLoadBalancerAtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleHttpLoadBalancerAtomicOperation
extends DeleteGoogleLoadBalancerAtomicOperation {
    private static final String BASE_PHASE = "DELETE_LOAD_BALANCER";
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    private DeleteGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DeleteGoogleHttpLoadBalancerAtomicOperation(DeleteGoogleLoadBalancerDescription description) {
        DeleteGoogleLoadBalancerDescription deleteGoogleLoadBalancerDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    private static void addServicesFromPathMatchers(List<String> backendServiceUrls, List<PathMatcher> pathMatchers) {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        PathMatcher pathMatcher = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(pathMatchers), Iterator.class);
        while (iterator.hasNext()) {
            pathMatcher = (PathMatcher)ScriptBytecodeAdapter.castToType(iterator.next(), PathMatcher.class);
            callSiteArray[3].call(backendServiceUrls, callSiteArray[4].call((Object)pathMatcher));
            PathRule pathRule = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(callSiteArray[6].call((Object)pathMatcher)), Iterator.class);
            while (iterator2.hasNext()) {
                pathRule = (PathRule)ScriptBytecodeAdapter.castToType(iterator2.next(), PathRule.class);
                callSiteArray[7].call(backendServiceUrls, callSiteArray[8].call((Object)pathRule));
            }
        }
    }

    @Override
    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Initializing deletion of HTTP load balancer ", "..."}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this.description))) {
            throw (Throwable)callSiteArray[13].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[14].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."}));
        }
        Reference compute = new Reference(callSiteArray[15].callGetProperty(callSiteArray[16].callGroovyObjectGetProperty((Object)this.description)));
        Reference project = new Reference(callSiteArray[17].callGetProperty(callSiteArray[18].callGroovyObjectGetProperty((Object)this.description)));
        Reference forwardingRuleName = new Reference(callSiteArray[19].callGroovyObjectGetProperty((Object)this.description));
        callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{forwardingRuleName.get()}, new String[]{"Retrieving global forwarding rule ", "..."}));
        List projectForwardingRules = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(callSiteArray[23].callCurrent((GroovyObject)this, callSiteArray[24].call(callSiteArray[25].call(compute.get()), project.get()), (Object)"compute.globalForwardingRules.list", callSiteArray[26].callGroovyObjectGetProperty((Object)this), callSiteArray[27].callGroovyObjectGetProperty((Object)this))), List.class);
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference forwardingRuleName) {
                Reference reference;
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.forwardingRuleName.get());
            }

            @Generated
            public Object getForwardingRuleName() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.forwardingRuleName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ForwardingRule forwardingRule = (ForwardingRule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)projectForwardingRules, (Object)new _operate_closure1(this, this, forwardingRuleName)), ForwardingRule.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)forwardingRule)) {
            callSiteArray[29].call(GCEUtil.class, (Object)new GStringImpl(new Object[]{forwardingRuleName.get(), project.get()}, new String[]{"Global forwarding rule ", " not found for ", ""}), callSiteArray[30].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE);
        }
        String targetProxyName = ShortTypeHandling.castToString((Object)callSiteArray[31].call(GCEUtil.class, callSiteArray[32].call((Object)forwardingRule)));
        callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"Retrieving target proxy ", "..."}));
        Object retrievedTargetProxy = callSiteArray[35].call(GCEUtil.class, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)forwardingRule, (Object)BASE_PHASE, (Object)this.safeRetry, (Object)this));
        if (!DefaultTypeTransformation.booleanUnbox((Object)retrievedTargetProxy)) {
            callSiteArray[36].call(GCEUtil.class, (Object)new GStringImpl(new Object[]{targetProxyName, project.get()}, new String[]{"Target proxy ", " not found for ", ""}), callSiteArray[37].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE);
        }
        Reference urlMapName = new Reference(callSiteArray[38].call(GCEUtil.class, callSiteArray[39].call(retrievedTargetProxy)));
        Reference listenersToDelete = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference urlMapName;
            private /* synthetic */ Reference listenersToDelete;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference urlMapName, Reference listenersToDelete) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.urlMapName = reference2 = urlMapName;
                this.listenersToDelete = reference = listenersToDelete;
            }

            public Object doCall(ForwardingRule rule) {
                CallSite[] callSiteArray;
                block9: {
                    callSiteArray = _operate_closure2.$getCallSiteArray();
                    Object proxy = callSiteArray[0].call(GCEUtil.class, ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)rule, (Object)ScriptBytecodeAdapter.getField(_operate_closure2.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)this.getThisObject()));
                    if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(GCEUtil.class, callSiteArray[3].callGetPropertySafe(proxy)), (Object)this.urlMapName.get())) break block9;
                    Object object = callSiteArray[4].call(this.listenersToDelete.get(), callSiteArray[5].call((Object)rule));
                    return object;
                }
                Object var5_5 = null;
                try {
                    return var5_5;
                }
                catch (GoogleJsonResponseException e) {
                    block10: {
                        if (!ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[6].call((Object)e), (Object)404)) break block10;
                        throw (Throwable)e;
                    }
                    Object var7_7 = null;
                    return var7_7;
                }
            }

            public Object call(ForwardingRule rule) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[7].callCurrent((GroovyObject)this, (Object)rule);
                }
                return this.doCall(rule);
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getUrlMapName() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.urlMapName.get();
            }

            @Generated
            public List getListenersToDelete() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.listenersToDelete.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getTargetProxyFromRule";
                stringArray[1] = "safeRetry";
                stringArray[2] = "getLocalName";
                stringArray[3] = "urlMap";
                stringArray[4] = "leftShift";
                stringArray[5] = "getName";
                stringArray[6] = "getStatusCode";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _operate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[40].call((Object)projectForwardingRules, (Object)new _operate_closure2(this, this, compute, project, urlMapName, listenersToDelete));
        callSiteArray[41].call(callSiteArray[42].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Retrieving URL map ", "..."}));
        UrlMapList mapList = (UrlMapList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callCurrent((GroovyObject)this, callSiteArray[44].call(callSiteArray[45].call(compute.get()), project.get()), (Object)"compute.urlMaps.list", callSiteArray[46].callGroovyObjectGetProperty((Object)this), callSiteArray[47].callGroovyObjectGetProperty((Object)this)), UrlMapList.class);
        List projectUrlMaps = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)mapList), List.class);
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference urlMapName) {
                Reference reference;
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.urlMapName.get());
            }

            @Generated
            public Object getUrlMapName() {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_operate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        UrlMap urlMap = (UrlMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call((Object)projectUrlMaps, (Object)new _operate_closure3(this, this, urlMapName)), UrlMap.class);
        public final class _operate_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure4(Object _outerInstance, Object _thisObject, Reference urlMapName) {
                Reference reference;
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.urlMapName.get());
            }

            @Generated
            public Object getUrlMapName() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_operate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[50].call((Object)projectUrlMaps, (Object)new _operate_closure4(this, this, urlMapName));
        List backendServiceUrls = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(ArrayList.class), List.class);
        callSiteArray[52].call((Object)backendServiceUrls, callSiteArray[53].call((Object)urlMap));
        callSiteArray[54].callStatic(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (Object)backendServiceUrls, callSiteArray[55].call((Object)urlMap));
        callSiteArray[56].call((Object)backendServiceUrls);
        List healthCheckUrls = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callConstructor(ArrayList.class), List.class);
        String backendServiceUrl = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)backendServiceUrls), Iterator.class);
        while (iterator.hasNext()) {
            backendServiceUrl = ShortTypeHandling.castToString(iterator.next());
            Reference backendServiceName = new Reference(callSiteArray[59].call(GCEUtil.class, (Object)backendServiceUrl));
            callSiteArray[60].call(callSiteArray[61].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Retrieving backend service ", "..."}));
            public final class _operate_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference backendServiceName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure5(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference backendServiceName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.backendServiceName = reference = backendServiceName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.backendServiceName.get()), (Object)"compute.backendServices.get", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
                }

                @Generated
                public Object getCompute() {
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public Object getBackendServiceName() {
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    return this.backendServiceName.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "get";
                    stringArray[2] = "backendServices";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _operate_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            BackendService backendService = (BackendService)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure5(this, this, compute, project, backendServiceName)), (Object)new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Backend service ", ""}), (Object)callSiteArray[63].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", BASE_PHASE, "operation", "compute.backendServices.get", callSiteArray[64].callGroovyObjectGetProperty((Object)this), callSiteArray[65].callGroovyObjectGetProperty((Object)this)}), (Object)callSiteArray[66].callGroovyObjectGetProperty((Object)this))), BackendService.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].callGetPropertySafe((Object)backendService))) {
                callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[70].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Server groups still associated with Http(s) load balancer ", ". Failing..."}));
                throw (Throwable)callSiteArray[71].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[72].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Server groups still associated with Http(s) load balancer: ", "."}));
            }
            callSiteArray[73].call((Object)healthCheckUrls, callSiteArray[74].call((Object)backendService));
        }
        callSiteArray[75].call((Object)healthCheckUrls);
        Reference timeoutSeconds = new Reference(callSiteArray[76].callGroovyObjectGetProperty((Object)this.description));
        public final class _operate_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference timeoutSeconds;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference timeoutSeconds) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.timeoutSeconds = reference = timeoutSeconds;
            }

            public Object doCall(String ruleName) {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure6.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{ruleName}, new String[]{"Deleting listener ", "..."}));
                Operation operation = (Operation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(GCEUtil.class, ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)ruleName, (Object)ScriptBytecodeAdapter.getField(_operate_closure6.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)this.getThisObject())), Operation.class);
                return callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[6].call((Object)operation), (Object)this.timeoutSeconds.get(), (Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[8].call((Object)"listener ", (Object)ruleName), (Object)ScriptBytecodeAdapter.getField(_operate_closure6.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE")));
            }

            public Object call(String ruleName) {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[9].callCurrent((GroovyObject)this, (Object)ruleName);
                }
                return this.doCall(ruleName);
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getTimeoutSeconds() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return this.timeoutSeconds.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "updateStatus";
                stringArray[1] = "task";
                stringArray[2] = "deleteGlobalListener";
                stringArray[3] = "safeRetry";
                stringArray[4] = "waitForGlobalOperation";
                stringArray[5] = "googleOperationPoller";
                stringArray[6] = "getName";
                stringArray[7] = "task";
                stringArray[8] = "plus";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _operate_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[77].call((Object)((List)listenersToDelete.get()), (Object)new _operate_closure6(this, this, compute, project, timeoutSeconds));
        callSiteArray[78].call(callSiteArray[79].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Deleting URL map ", "..."}));
        public final class _operate_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure7(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference urlMapName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.urlMapName.get()), (Object)"compute.urlMaps.delete", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getUrlMapName() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "delete";
                stringArray[2] = "urlMaps";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_GLOBAL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _operate_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Operation deleteUrlMapOperation = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[80].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure7(this, this, compute, project, urlMapName)), (Object)new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Url map ", ""}), (Object)callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE, "operation", "compute.urlMaps.delete", callSiteArray[82].callGroovyObjectGetProperty((Object)this), callSiteArray[83].callGroovyObjectGetProperty((Object)this)}), (Object)callSiteArray[84].callGroovyObjectGetProperty((Object)this))), Operation.class);
        callSiteArray[85].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[86].call((Object)deleteUrlMapOperation), (Object)timeoutSeconds.get(), (Object)callSiteArray[87].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[88].call((Object)"url map ", urlMapName.get()), (Object)BASE_PHASE));
        List deleteBackendServiceAsyncOperations = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(ArrayList.class), List.class);
        String backendServiceUrl2 = null;
        Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call((Object)backendServiceUrls), Iterator.class);
        while (iterator2.hasNext()) {
            backendServiceUrl2 = ShortTypeHandling.castToString(iterator2.next());
            Reference backendServiceName = new Reference(callSiteArray[91].call(GCEUtil.class, (Object)backendServiceUrl2));
            public final class _operate_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference backendServiceName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference backendServiceName) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.backendServiceName = reference = backendServiceName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.backendServiceName.get()), (Object)"compute.backendServices.delete", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
                }

                @Generated
                public Object getCompute() {
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public Object getBackendServiceName() {
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    return this.backendServiceName.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "delete";
                    stringArray[2] = "backendServices";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _operate_closure8.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure8.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure8.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Operation deleteBackendServiceOp = (Operation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call(GCEUtil.class, ArrayUtil.createArray((Object)((Object)new _operate_closure8(this, this, compute, project, backendServiceName)), (Object)new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Backend service ", ""}), (Object)project.get(), (Object)callSiteArray[93].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.backendServices.delete", "phase", BASE_PHASE, callSiteArray[94].callGroovyObjectGetProperty((Object)this), callSiteArray[95].callGroovyObjectGetProperty((Object)this)}), (Object)this.safeRetry, (Object)this)), Operation.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)deleteBackendServiceOp)) continue;
            callSiteArray[96].call((Object)deleteBackendServiceAsyncOperations, callSiteArray[97].callConstructor(BackendServiceAsyncDeleteOperation.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"backendServiceName", backendServiceName.get(), "operationName", callSiteArray[98].call((Object)deleteBackendServiceOp)})));
        }
        BackendServiceAsyncDeleteOperation asyncOperation = null;
        Iterator iterator3 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].call((Object)deleteBackendServiceAsyncOperations), Iterator.class);
        while (iterator3.hasNext()) {
            asyncOperation = (BackendServiceAsyncDeleteOperation)ScriptBytecodeAdapter.castToType(iterator3.next(), BackendServiceAsyncDeleteOperation.class);
            callSiteArray[100].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[101].callGroovyObjectGetProperty((Object)asyncOperation), (Object)timeoutSeconds.get(), (Object)callSiteArray[102].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[103].call((Object)"backend service ", callSiteArray[104].callGroovyObjectGetProperty((Object)asyncOperation)), (Object)BASE_PHASE));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[105].callGroovyObjectGetProperty((Object)this.description))) {
            List deleteHealthCheckAsyncOperations = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callConstructor(ArrayList.class), List.class);
            String healthCheckUrl = null;
            Iterator iterator4 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call((Object)healthCheckUrls), Iterator.class);
            while (iterator4.hasNext()) {
                healthCheckUrl = ShortTypeHandling.castToString(iterator4.next());
                Reference healthCheckName = new Reference(callSiteArray[108].call(GCEUtil.class, (Object)healthCheckUrl));
                public final class _operate_closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference healthCheckName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _operate_closure9(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.healthCheckName = reference = healthCheckName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.healthCheckName.get()), (Object)"compute.healthChecks.delete", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
                    }

                    @Generated
                    public Object getCompute() {
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        return this.compute.get();
                    }

                    @Generated
                    public Object getProject() {
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        return this.project.get();
                    }

                    @Generated
                    public Object getHealthCheckName() {
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        return this.healthCheckName.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "healthChecks";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _operate_closure9.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_operate_closure9.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _operate_closure9.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Operation deleteHealthCheckOp = (Operation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].call(GCEUtil.class, ArrayUtil.createArray((Object)((Object)new _operate_closure9(this, this, compute, project, healthCheckName)), (Object)new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Http health check ", ""}), (Object)project.get(), (Object)callSiteArray[110].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.healthChecks.delete", "phase", BASE_PHASE, callSiteArray[111].callGroovyObjectGetProperty((Object)this), callSiteArray[112].callGroovyObjectGetProperty((Object)this)}), (Object)this.safeRetry, (Object)this)), Operation.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)deleteHealthCheckOp)) continue;
                callSiteArray[113].call((Object)deleteHealthCheckAsyncOperations, callSiteArray[114].callConstructor(HealthCheckAsyncDeleteOperation.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheckName", healthCheckName.get(), "operationName", callSiteArray[115].call((Object)deleteHealthCheckOp)})));
            }
            HealthCheckAsyncDeleteOperation asyncOperation2 = null;
            Iterator iterator5 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].call((Object)deleteHealthCheckAsyncOperations), Iterator.class);
            while (iterator5.hasNext()) {
                asyncOperation2 = (HealthCheckAsyncDeleteOperation)ScriptBytecodeAdapter.castToType(iterator5.next(), HealthCheckAsyncDeleteOperation.class);
                callSiteArray[117].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[118].callGroovyObjectGetProperty((Object)asyncOperation2), (Object)timeoutSeconds.get(), (Object)callSiteArray[119].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[120].call((Object)"health check ", callSiteArray[121].callGroovyObjectGetProperty((Object)asyncOperation2)), (Object)BASE_PHASE));
            }
        }
        callSiteArray[122].call(callSiteArray[123].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[124].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Done deleting http load balancer ", "."}));
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteGoogleHttpLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    static {
        Object object = DeleteGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray()[125].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleHttpLoadBalancerAtomicOperation");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Override
    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    @Generated
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ SafeRetry super$3$getSafeRetry() {
        return super.getSafeRetry();
    }

    public /* synthetic */ void super$3$setSafeRetry(SafeRetry safeRetry) {
        super.setSafeRetry(safeRetry);
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Void super$3$operate(List list) {
        return super.operate(list);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "iterator";
        stringArray[3] = "add";
        stringArray[4] = "getDefaultService";
        stringArray[5] = "iterator";
        stringArray[6] = "getPathRules";
        stringArray[7] = "add";
        stringArray[8] = "getService";
        stringArray[9] = "updateStatus";
        stringArray[10] = "task";
        stringArray[11] = "loadBalancerName";
        stringArray[12] = "credentials";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "accountName";
        stringArray[15] = "compute";
        stringArray[16] = "credentials";
        stringArray[17] = "project";
        stringArray[18] = "credentials";
        stringArray[19] = "loadBalancerName";
        stringArray[20] = "updateStatus";
        stringArray[21] = "task";
        stringArray[22] = "getItems";
        stringArray[23] = "timeExecute";
        stringArray[24] = "list";
        stringArray[25] = "globalForwardingRules";
        stringArray[26] = "TAG_SCOPE";
        stringArray[27] = "SCOPE_GLOBAL";
        stringArray[28] = "find";
        stringArray[29] = "updateStatusAndThrowNotFoundException";
        stringArray[30] = "task";
        stringArray[31] = "getLocalName";
        stringArray[32] = "getTarget";
        stringArray[33] = "updateStatus";
        stringArray[34] = "task";
        stringArray[35] = "getTargetProxyFromRule";
        stringArray[36] = "updateStatusAndThrowNotFoundException";
        stringArray[37] = "task";
        stringArray[38] = "getLocalName";
        stringArray[39] = "getUrlMap";
        stringArray[40] = "each";
        stringArray[41] = "updateStatus";
        stringArray[42] = "task";
        stringArray[43] = "timeExecute";
        stringArray[44] = "list";
        stringArray[45] = "urlMaps";
        stringArray[46] = "TAG_SCOPE";
        stringArray[47] = "SCOPE_GLOBAL";
        stringArray[48] = "getItems";
        stringArray[49] = "find";
        stringArray[50] = "removeAll";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "add";
        stringArray[53] = "getDefaultService";
        stringArray[54] = "addServicesFromPathMatchers";
        stringArray[55] = "getPathMatchers";
        stringArray[56] = "unique";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "iterator";
        stringArray[59] = "getLocalName";
        stringArray[60] = "updateStatus";
        stringArray[61] = "task";
        stringArray[62] = "doRetry";
        stringArray[63] = "task";
        stringArray[64] = "TAG_SCOPE";
        stringArray[65] = "SCOPE_GLOBAL";
        stringArray[66] = "registry";
        stringArray[67] = "backends";
        stringArray[68] = "updateStatus";
        stringArray[69] = "task";
        stringArray[70] = "loadBalancerName";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "loadBalancerName";
        stringArray[73] = "addAll";
        stringArray[74] = "getHealthChecks";
        stringArray[75] = "unique";
        stringArray[76] = "deleteOperationTimeoutSeconds";
        stringArray[77] = "each";
        stringArray[78] = "updateStatus";
        stringArray[79] = "task";
        stringArray[80] = "doRetry";
        stringArray[81] = "task";
        stringArray[82] = "TAG_SCOPE";
        stringArray[83] = "SCOPE_GLOBAL";
        stringArray[84] = "registry";
        stringArray[85] = "waitForGlobalOperation";
        stringArray[86] = "getName";
        stringArray[87] = "task";
        stringArray[88] = "plus";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "iterator";
        stringArray[91] = "getLocalName";
        stringArray[92] = "deleteIfNotInUse";
        stringArray[93] = "task";
        stringArray[94] = "TAG_SCOPE";
        stringArray[95] = "SCOPE_GLOBAL";
        stringArray[96] = "add";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "getName";
        stringArray[99] = "iterator";
        stringArray[100] = "waitForGlobalOperation";
        stringArray[101] = "operationName";
        stringArray[102] = "task";
        stringArray[103] = "plus";
        stringArray[104] = "backendServiceName";
        stringArray[105] = "deleteHealthChecks";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "iterator";
        stringArray[108] = "getLocalName";
        stringArray[109] = "deleteIfNotInUse";
        stringArray[110] = "task";
        stringArray[111] = "TAG_SCOPE";
        stringArray[112] = "SCOPE_GLOBAL";
        stringArray[113] = "add";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "getName";
        stringArray[116] = "iterator";
        stringArray[117] = "waitForGlobalOperation";
        stringArray[118] = "operationName";
        stringArray[119] = "task";
        stringArray[120] = "plus";
        stringArray[121] = "healthCheckName";
        stringArray[122] = "updateStatus";
        stringArray[123] = "task";
        stringArray[124] = "loadBalancerName";
        stringArray[125] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[126];
        DeleteGoogleHttpLoadBalancerAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeleteGoogleHttpLoadBalancerAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeleteGoogleHttpLoadBalancerAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class HealthCheckAsyncDeleteOperation
    implements GroovyObject {
        private String healthCheckName;
        private String operationName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public HealthCheckAsyncDeleteOperation() {
            MetaClass metaClass;
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthCheckAsyncDeleteOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getHealthCheckName() {
            return this.healthCheckName;
        }

        @Generated
        public void setHealthCheckName(String string) {
            this.healthCheckName = string;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public void setOperationName(String string) {
            this.operationName = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(HealthCheckAsyncDeleteOperation.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HealthCheckAsyncDeleteOperation.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class BackendServiceAsyncDeleteOperation
    implements GroovyObject {
        private String backendServiceName;
        private String operationName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public BackendServiceAsyncDeleteOperation() {
            MetaClass metaClass;
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BackendServiceAsyncDeleteOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = BackendServiceAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getBackendServiceName() {
            return this.backendServiceName;
        }

        @Generated
        public void setBackendServiceName(String string) {
            this.backendServiceName = string;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public void setOperationName(String string) {
            this.operationName = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(BackendServiceAsyncDeleteOperation.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = BackendServiceAsyncDeleteOperation.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

