/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.batch.GoogleBatchRequest;
import com.netflix.spinnaker.clouddriver.google.security.AccountForClient;
import java.io.IOException;

public interface GoogleExecutorTraits {
    public static final String TAG_BATCH_CONTEXT = GoogleExecutor.getTAG_BATCH_CONTEXT();
    public static final String TAG_REGION = GoogleExecutor.getTAG_REGION();
    public static final String TAG_SCOPE = GoogleExecutor.getTAG_SCOPE();
    public static final String TAG_ZONE = GoogleExecutor.getTAG_ZONE();
    public static final String SCOPE_GLOBAL = GoogleExecutor.getSCOPE_GLOBAL();
    public static final String SCOPE_REGIONAL = GoogleExecutor.getSCOPE_REGIONAL();
    public static final String SCOPE_ZONAL = GoogleExecutor.getSCOPE_ZONAL();

    public Registry getRegistry();

    default public <T> T timeExecuteBatch(GoogleBatchRequest googleBatchRequest, String batchContext, String ... tags) throws IOException {
        return GoogleExecutor.timeExecuteBatch(this.getRegistry(), googleBatchRequest, batchContext, tags);
    }

    default public <T> T timeExecute(AbstractGoogleClientRequest<T> request, String api, String ... tags) throws IOException {
        String account = AccountForClient.getAccount(request.getAbstractGoogleClient());
        String[] augmentedTags = new String[tags.length + 2];
        augmentedTags[0] = "account";
        augmentedTags[1] = account;
        System.arraycopy(tags, 0, augmentedTags, 2, tags.length);
        return GoogleExecutor.timeExecute(this.getRegistry(), request, "google.api", api, augmentedTags);
    }
}

