/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.client.util.Strings;
import com.google.api.services.compute.ComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class PaginatedComputeRequestImpl<RequestT extends ComputeRequest<ResponseT>, ResponseT, ItemT>
implements PaginatedComputeRequest<RequestT, ItemT> {
    final RequestGenerator<RequestT, ResponseT> requestGenerator;
    final NextPageTokenRetriever<ResponseT> nextPageTokenRetriever;
    final ItemRetriever<ResponseT, ItemT> itemRetriever;
    final Consumer<RequestT> requestModifier;

    PaginatedComputeRequestImpl(RequestGenerator<RequestT, ResponseT> requestGenerator, NextPageTokenRetriever<ResponseT> nextPageTokenRetriever, ItemRetriever<ResponseT, ItemT> itemRetriever) {
        this(requestGenerator, nextPageTokenRetriever, itemRetriever, request -> {});
    }

    private PaginatedComputeRequestImpl(RequestGenerator<RequestT, ResponseT> requestGenerator, NextPageTokenRetriever<ResponseT> nextPageTokenRetriever, ItemRetriever<ResponseT, ItemT> itemRetriever, Consumer<RequestT> requestModifier) {
        this.requestGenerator = requestGenerator;
        this.nextPageTokenRetriever = nextPageTokenRetriever;
        this.itemRetriever = itemRetriever;
        this.requestModifier = requestModifier;
    }

    @Override
    public void execute(Consumer<List<ItemT>> pageConsumer) throws IOException {
        ResponseT response;
        String pageToken = "";
        do {
            GoogleComputeRequest<RequestT, ResponseT> request = this.requestGenerator.createRequest(pageToken);
            this.requestModifier.accept(request.getRequest());
            response = request.execute();
            Optional.ofNullable(this.itemRetriever.getItems(response)).ifPresent(pageConsumer);
        } while (!Strings.isNullOrEmpty((String)(pageToken = this.nextPageTokenRetriever.getNextPageToken(response))));
    }

    @Override
    public PaginatedComputeRequest<RequestT, ItemT> withRequestModifier(Consumer<RequestT> requestModifier) {
        return new PaginatedComputeRequestImpl<RequestT, ResponseT, ItemT>(this.requestGenerator, this.nextPageTokenRetriever, this.itemRetriever, requestModifier);
    }

    @FunctionalInterface
    static interface ItemRetriever<ResponseT, ItemT> {
        @Nullable
        public List<ItemT> getItems(ResponseT var1);
    }

    @FunctionalInterface
    static interface NextPageTokenRetriever<ResponseT> {
        public String getNextPageToken(ResponseT var1);
    }

    @FunctionalInterface
    static interface RequestGenerator<RequestT extends ComputeRequest<ResponseT>, ResponseT> {
        public GoogleComputeRequest<RequestT, ResponseT> createRequest(String var1) throws IOException;
    }
}

