/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.RegionAutoscalerList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.RegionalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;

public final class RegionAutoscalers {
    private final Compute.RegionAutoscalers computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final RegionalGoogleComputeRequestFactory requestFactory;

    RegionAutoscalers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().regionAutoscalers();
        this.credentials = credentials;
        this.requestFactory = new RegionalGoogleComputeRequestFactory("regionAutoscalers", credentials, operationPoller, registry);
    }

    public GoogleComputeGetRequest<Compute.RegionAutoscalers.Get, Autoscaler> get(String region, String name) throws IOException {
        return this.requestFactory.wrapGetRequest(this.computeApi.get(this.credentials.getProject(), region, name), "get", region);
    }

    public PaginatedComputeRequest<Compute.RegionAutoscalers.List, Autoscaler> list(String region) {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject(), region).setPageToken(pageToken), "list", region), RegionAutoscalerList::getNextPageToken, RegionAutoscalerList::getItems);
    }
}

