/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.RegionInstanceGroupManagerList;
import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.RegionalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.util.Optional;

public final class RegionInstanceGroupManagers {
    private final Compute.RegionInstanceGroupManagers computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final RegionalGoogleComputeRequestFactory requestFactory;

    RegionInstanceGroupManagers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().regionInstanceGroupManagers();
        this.credentials = credentials;
        this.requestFactory = new RegionalGoogleComputeRequestFactory("regionInstanceGroupManagers", credentials, operationPoller, registry);
    }

    public GoogleComputeGetRequest<Compute.RegionInstanceGroupManagers.Get, InstanceGroupManager> get(String region, String name) throws IOException {
        return this.requestFactory.wrapGetRequest(this.computeApi.get(this.credentials.getProject(), region, name), "get", region);
    }

    public PaginatedComputeRequest<Compute.RegionInstanceGroupManagers.List, InstanceGroupManager> list(String region) {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject(), region).setPageToken(pageToken), "list", region), RegionInstanceGroupManagerList::getNextPageToken, response -> Optional.ofNullable(response.getItems()).orElseGet(ImmutableList::of));
    }
}

