/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.snapshot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.description.snapshot.RestoreSnapshotDescription;
import com.netflix.spinnaker.clouddriver.google.model.GoogleCluster;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleNetworkLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.clouddriver.jobs.JobRequest;
import com.netflix.spinnaker.clouddriver.jobs.JobResult;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class RestoreSnapshotAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "RESTORE_SNAPSHOT";
    private final RestoreSnapshotDescription description;
    private final String applicationName;
    private final String accountName;
    private final Long snapshotTimestamp;
    private final String directory;
    private String project;
    private String credentialPath;
    private Set imported;
    private List applicationTags;
    private boolean hasEnvCredentials;
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    private GoogleSecurityGroupProvider googleSecurityGroupProvider;
    @Autowired
    private AccountCredentialsRepository accountCredentialsRepository;
    @Autowired
    private JobExecutor jobExecutor;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Front50Service front50Service;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RestoreSnapshotAtomicOperation(RestoreSnapshotDescription description) {
        List list;
        boolean bl;
        RestoreSnapshotDescription restoreSnapshotDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = restoreSnapshotDescription = description;
        Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)description);
        this.applicationName = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[1].callGroovyObjectGetProperty((Object)description);
        this.accountName = ShortTypeHandling.castToString((Object)object2);
        Object object3 = callSiteArray[2].callGroovyObjectGetProperty((Object)description);
        this.snapshotTimestamp = (Long)ScriptBytecodeAdapter.castToType((Object)object3, Long.class);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"", "-", ""});
        this.directory = ShortTypeHandling.castToString((Object)gStringImpl);
        Object object4 = callSiteArray[3].callConstructor(HashSet.class);
        this.imported = (Set)ScriptBytecodeAdapter.castToType((Object)object4, Set.class);
        this.hasEnvCredentials = bl = false;
        this.applicationTags = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        GoogleNamedAccountCredentials credentials = (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[6].call((Object)this.accountCredentialsRepository, (Object)this.accountName), GoogleNamedAccountCredentials.class));
        Object object = callSiteArray[7].callGetProperty((Object)credentials);
        this.project = ShortTypeHandling.castToString((Object)object);
        Object pb = callSiteArray[8].callConstructor(ProcessBuilder.class);
        Object env = callSiteArray[9].call(pb);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].callGetProperty(env), (Object)this.project) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callGetProperty(env)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGetProperty(env))) {
            boolean bl;
            this.hasEnvCredentials = bl = true;
        } else {
            GoogleConfigurationProperties.ManagedAccount account = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this.googleConfigurationProperties)), Iterator.class);
            while (iterator.hasNext()) {
                account = (GoogleConfigurationProperties.ManagedAccount)((Object)ScriptBytecodeAdapter.castToType(iterator.next(), GoogleConfigurationProperties.ManagedAccount.class));
                if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)account), (Object)this.accountName)) continue;
                Object object2 = callSiteArray[16].callGroovyObjectGetProperty((Object)account);
                this.credentialPath = ShortTypeHandling.castToString((Object)object2);
                break;
            }
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.credentialPath, null) && !this.hasEnvCredentials) {
                throw (Throwable)callSiteArray[17].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{this.accountName}, new String[]{"Could not find credentials for ", ""}));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.credentialPath, null) && !this.hasEnvCredentials) {
            throw (Throwable)callSiteArray[18].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{this.accountName}, new String[]{"Could not find credentials for ", ""}));
        }
        File dir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(File.class, (Object)this.directory), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)dir))) {
            throw (Throwable)callSiteArray[21].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"Error creating directory ", ""}));
        }
        callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of server groups for the application ", " in account ", ""}));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleCluster.View cluster) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                public final class _closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure7(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(GoogleServerGroup.View serverGroup) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)serverGroup);
                    }

                    public Object call(GoogleServerGroup.View serverGroup) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)serverGroup);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "importServerGroupState";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure7.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure7.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure7.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)cluster), (Object)new _closure7((Object)this, this.getThisObject()));
            }

            public Object call(GoogleCluster.View cluster) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)cluster);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "serverGroups";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _operate_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[24].call(callSiteArray[25].call((Object)this.googleClusterProvider, (Object)this.applicationName, (Object)this.accountName), (Object)new _operate_closure1(this, this));
        callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of load balancers for the application ", " in account ", ""}));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleLoadBalancerView loadBalancer) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)loadBalancer), (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this))) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)loadBalancer);
                }
                return null;
            }

            public Object call(GoogleLoadBalancerView loadBalancer) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)loadBalancer);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "account";
                stringArray[1] = "accountName";
                stringArray[2] = "importLoadBalancerState";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _operate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[28].call(callSiteArray[29].call((Object)this.googleLoadBalancerProvider, (Object)this.applicationName), (Object)new _operate_closure2(this, this));
        callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of security groups for application ", " in account ", ""}));
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleSecurityGroup securityGroup) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)securityGroup), (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)securityGroup)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(Collections.class, callSiteArray[4].callGroovyObjectGetProperty((Object)securityGroup), callSiteArray[5].callGroovyObjectGetProperty((Object)this)))) {
                        return callSiteArray[6].callCurrent((GroovyObject)this, (Object)securityGroup);
                    }
                    return null;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)securityGroup), (Object)callSiteArray[8].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)securityGroup)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call(Collections.class, callSiteArray[11].callGroovyObjectGetProperty((Object)securityGroup), callSiteArray[12].callGroovyObjectGetProperty((Object)this)))) {
                    return callSiteArray[13].callCurrent((GroovyObject)this, (Object)securityGroup);
                }
                return null;
            }

            public Object call(GoogleSecurityGroup securityGroup) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[14].callCurrent((GroovyObject)this, (Object)securityGroup);
                }
                return this.doCall(securityGroup);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "accountName";
                stringArray[1] = "accountName";
                stringArray[2] = "targetTags";
                stringArray[3] = "disjoint";
                stringArray[4] = "targetTags";
                stringArray[5] = "applicationTags";
                stringArray[6] = "importSecurityGroupState";
                stringArray[7] = "accountName";
                stringArray[8] = "accountName";
                stringArray[9] = "targetTags";
                stringArray[10] = "disjoint";
                stringArray[11] = "targetTags";
                stringArray[12] = "applicationTags";
                stringArray[13] = "importSecurityGroupState";
                stringArray[14] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _operate_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[32].call(callSiteArray[33].call((Object)this.googleSecurityGroupProvider, (Object)true), (Object)new _operate_closure3(this, this));
        callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{this.snapshotTimestamp, this.applicationName, this.accountName}, new String[]{"Restoring snapshot with timestamp ", " for application ", " in account ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[36].callCurrent((GroovyObject)this);
        } else {
            this.createTerraformConfig();
        }
        ArrayList command = (ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"terraform", "apply", callSiteArray[37].call(callSiteArray[38].call((Object)"-state=", (Object)this.directory), (Object)"/terraform.tfstate"), this.directory}), ArrayList.class);
        JobResult jobStatus = (JobResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)this.jobExecutor, callSiteArray[40].callConstructor(JobRequest.class, (Object)command)), JobResult.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[41].callCurrent((GroovyObject)this);
        } else {
            this.cleanUpDirectory();
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[42].call((Object)jobStatus), (Object)callSiteArray[43].callGetProperty(JobResult.Result.class)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call((Object)jobStatus))) {
            String stdOut = ShortTypeHandling.castToString((Object)callSiteArray[45].call((Object)jobStatus));
            String stdErr = ShortTypeHandling.castToString((Object)callSiteArray[46].call((Object)jobStatus));
            throw (Throwable)callSiteArray[47].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{stdOut, stdErr}, new String[]{"", " + ", ""}));
        }
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private Void importServerGroupState(GoogleServerGroup.View serverGroup) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        callSiteArray[48].callCurrent((GroovyObject)this, (Object)"google_compute_instance_group_manager", callSiteArray[49].callGroovyObjectGetProperty((Object)serverGroup), callSiteArray[50].callGroovyObjectGetProperty((Object)serverGroup), callSiteArray[51].callGroovyObjectGetProperty((Object)serverGroup));
        Object instanceTemplate = callSiteArray[52].callGetProperty(callSiteArray[53].callGroovyObjectGetProperty((Object)serverGroup));
        if (DefaultTypeTransformation.booleanUnbox((Object)instanceTemplate) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].call((Object)this.imported, callSiteArray[55].callGetProperty(instanceTemplate)))) {
            callSiteArray[56].callCurrent((GroovyObject)this, (Object)"google_compute_instance_template", callSiteArray[57].callGetProperty(instanceTemplate), callSiteArray[58].callGetProperty(instanceTemplate), callSiteArray[59].callGroovyObjectGetProperty((Object)serverGroup));
            callSiteArray[60].call((Object)this.imported, callSiteArray[61].callGetProperty(instanceTemplate));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].callGetPropertySafe(callSiteArray[63].callGetProperty(callSiteArray[64].callGetProperty(instanceTemplate))))) {
                callSiteArray[65].call((Object)this.applicationTags, callSiteArray[66].callGetProperty(callSiteArray[67].callGetProperty(callSiteArray[68].callGetProperty(instanceTemplate))));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].callGroovyObjectGetProperty((Object)serverGroup))) {
            callSiteArray[70].callCurrent((GroovyObject)this, (Object)"google_compute_autoscaler", callSiteArray[71].callGroovyObjectGetProperty((Object)serverGroup), callSiteArray[72].callGroovyObjectGetProperty((Object)serverGroup), callSiteArray[73].callGroovyObjectGetProperty((Object)serverGroup));
        }
        Object stateFile = callSiteArray[74].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"}));
        String stateJson = ShortTypeHandling.castToString((Object)callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callConstructor(Scanner.class, stateFile), (Object)"\\Z")));
        Reference state = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call((Object)this.objectMapper, (Object)stateJson, (Object)new GroovyObject(this){
            final /* synthetic */ RestoreSnapshotAtomicOperation this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                RestoreSnapshotAtomicOperation restoreSnapshotAtomicOperation;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = restoreSnapshotAtomicOperation = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Map.class)));
        public final class _importServerGroupState_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _importServerGroupState_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _importServerGroupState_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String loadBalancer) {
                CallSite[] callSiteArray = _importServerGroupState_closure4.$getCallSiteArray();
                return new GStringImpl(new Object[]{loadBalancer}, new String[]{"google_compute_target_pool.", ""});
            }

            public Object call(String loadBalancer) {
                CallSite[] callSiteArray = _importServerGroupState_closure4.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[0].callCurrent((GroovyObject)this, (Object)loadBalancer);
                }
                return this.doCall(loadBalancer);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _importServerGroupState_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doCall";
                return new CallSiteArray(_importServerGroupState_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _importServerGroupState_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object igmDependencies = callSiteArray[79].call(callSiteArray[80].callGroovyObjectGetProperty((Object)serverGroup), (Object)new _importServerGroupState_closure4(this, this));
        callSiteArray[81].call(igmDependencies, (Object)new GStringImpl(new Object[]{callSiteArray[82].callGetProperty(instanceTemplate)}, new String[]{"google_compute_instance_template.", ""}));
        callSiteArray[83].callCurrent((GroovyObject)this, callSiteArray[84].call(callSiteArray[85].callGetProperty(callSiteArray[86].call(callSiteArray[87].callGetProperty((Object)((Map)state.get())), (Object)0)), (Object)new GStringImpl(new Object[]{callSiteArray[88].callGroovyObjectGetProperty((Object)serverGroup)}, new String[]{"google_compute_instance_group_manager.", ""})), igmDependencies);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[89].callGroovyObjectGetProperty((Object)serverGroup))) {
            callSiteArray[90].callCurrent((GroovyObject)this, callSiteArray[91].call(callSiteArray[92].callGetProperty(callSiteArray[93].call(callSiteArray[94].callGetProperty((Object)((Map)state.get())), (Object)0)), (Object)new GStringImpl(new Object[]{callSiteArray[95].callGroovyObjectGetProperty((Object)serverGroup)}, new String[]{"google_compute_autoscaler.", ""})), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{callSiteArray[96].callGroovyObjectGetProperty((Object)serverGroup)}, new String[]{"google_compute_instance_group_manager.", ""})}));
        }
        public final class _importServerGroupState_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference state;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _importServerGroupState_closure5(Object _outerInstance, Object _thisObject, Reference state) {
                Reference reference;
                CallSite[] callSiteArray = _importServerGroupState_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.state = reference = state;
            }

            public Object doCall(Object w) {
                CallSite[] callSiteArray = _importServerGroupState_closure5.$getCallSiteArray();
                return callSiteArray[0].call(w, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), this.state.get()));
            }

            @Generated
            public Map getState() {
                CallSite[] callSiteArray = _importServerGroupState_closure5.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.state.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _importServerGroupState_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "writeValueAsString";
                stringArray[2] = "objectMapper";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _importServerGroupState_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_importServerGroupState_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _importServerGroupState_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[97].call(callSiteArray[98].call(stateFile), (Object)new _importServerGroupState_closure5(this, this, state));
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private Void importLoadBalancerState(GoogleLoadBalancerView loadBalancer) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        if (loadBalancer instanceof GoogleNetworkLoadBalancer.View) {
            Object targetPoolName = callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callGroovyObjectGetProperty((Object)loadBalancer), (Object)"/"));
            callSiteArray[102].callCurrent((GroovyObject)this, (Object)"google_compute_target_pool", callSiteArray[103].callGroovyObjectGetProperty((Object)loadBalancer), targetPoolName, callSiteArray[104].callGroovyObjectGetProperty((Object)loadBalancer));
            callSiteArray[105].callCurrent((GroovyObject)this, (Object)"google_compute_forwarding_rule", callSiteArray[106].callGroovyObjectGetProperty((Object)loadBalancer), callSiteArray[107].callGroovyObjectGetProperty((Object)loadBalancer), callSiteArray[108].callGroovyObjectGetProperty((Object)loadBalancer));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].callGroovyObjectGetProperty((Object)loadBalancer)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[110].call((Object)this.imported, callSiteArray[111].callGetProperty(callSiteArray[112].callGroovyObjectGetProperty((Object)loadBalancer))))) {
                callSiteArray[113].callCurrent((GroovyObject)this, (Object)"google_compute_http_health_check", callSiteArray[114].callGetProperty(callSiteArray[115].callGroovyObjectGetProperty((Object)loadBalancer)), callSiteArray[116].callGetProperty(callSiteArray[117].callGroovyObjectGetProperty((Object)loadBalancer)), callSiteArray[118].callGroovyObjectGetProperty((Object)loadBalancer));
                callSiteArray[119].call((Object)this.imported, callSiteArray[120].callGetProperty(callSiteArray[121].callGroovyObjectGetProperty((Object)loadBalancer)));
            }
            Object stateFile = callSiteArray[122].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"}));
            String stateJson = ShortTypeHandling.castToString((Object)callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].callConstructor(Scanner.class, stateFile), (Object)"\\Z")));
            Reference state = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].call((Object)this.objectMapper, (Object)stateJson, (Object)new GroovyObject(this){
                final /* synthetic */ RestoreSnapshotAtomicOperation this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    MetaClass metaClass;
                    RestoreSnapshotAtomicOperation restoreSnapshotAtomicOperation;
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    this.this$0 = restoreSnapshotAtomicOperation = p0;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return this.this$0.this$dist$invoke$1(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    this.this$0.this$dist$set$1(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return this.this$0.this$dist$get$1(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.getProperty(2.class, RestoreSnapshotAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = 2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }), Map.class)));
            callSiteArray[127].callCurrent((GroovyObject)this, callSiteArray[128].call(callSiteArray[129].callGetProperty(callSiteArray[130].call(callSiteArray[131].callGetProperty((Object)((Map)state.get())), (Object)0)), (Object)new GStringImpl(new Object[]{callSiteArray[132].callGroovyObjectGetProperty((Object)loadBalancer)}, new String[]{"google_compute_forwarding_rule.", ""})), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{callSiteArray[133].callGroovyObjectGetProperty((Object)loadBalancer)}, new String[]{"google_compute_target_pool.", ""})}));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].callGroovyObjectGetProperty((Object)loadBalancer))) {
                callSiteArray[135].callCurrent((GroovyObject)this, callSiteArray[136].call(callSiteArray[137].callGetProperty(callSiteArray[138].call(callSiteArray[139].callGetProperty((Object)((Map)state.get())), (Object)0)), (Object)new GStringImpl(new Object[]{callSiteArray[140].callGroovyObjectGetProperty((Object)loadBalancer)}, new String[]{"google_compute_target_pool.", ""})), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{callSiteArray[141].callGetProperty(callSiteArray[142].callGroovyObjectGetProperty((Object)loadBalancer))}, new String[]{"google_compute_http_health_check.", ""})}));
            }
            public final class _importLoadBalancerState_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference state;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _importLoadBalancerState_closure6(Object _outerInstance, Object _thisObject, Reference state) {
                    Reference reference;
                    CallSite[] callSiteArray = _importLoadBalancerState_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.state = reference = state;
                }

                public Object doCall(Object w) {
                    CallSite[] callSiteArray = _importLoadBalancerState_closure6.$getCallSiteArray();
                    return callSiteArray[0].call(w, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), this.state.get()));
                }

                @Generated
                public Map getState() {
                    CallSite[] callSiteArray = _importLoadBalancerState_closure6.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.state.get(), Map.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _importLoadBalancerState_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "leftShift";
                    stringArray[1] = "writeValueAsString";
                    stringArray[2] = "objectMapper";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _importLoadBalancerState_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_importLoadBalancerState_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _importLoadBalancerState_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[143].call(callSiteArray[144].call(stateFile), (Object)new _importLoadBalancerState_closure6(this, this, state));
        }
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private Void importSecurityGroupState(GoogleSecurityGroup securityGroup) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        callSiteArray[145].callCurrent((GroovyObject)this, (Object)"google_compute_firewall", callSiteArray[146].callGroovyObjectGetProperty((Object)securityGroup), callSiteArray[147].callGroovyObjectGetProperty((Object)securityGroup), callSiteArray[148].callGroovyObjectGetProperty((Object)securityGroup));
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    private void importResource(String resource, String name, String id, String region) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        InputStream inputStream = null;
        Object pb = callSiteArray[149].callConstructor(ProcessBuilder.class);
        Map env = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].call(pb), Map.class);
        if (!this.hasEnvCredentials) {
            Object object = callSiteArray[151].callConstructor(ByteArrayInputStream.class, callSiteArray[152].call(callSiteArray[153].call((Object)new GStringImpl(new Object[]{this.credentialPath, this.project, region}, new String[]{"", "\n", "\n", ""}))));
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
        } else {
            Object object = callSiteArray[154].callConstructor(ByteArrayInputStream.class);
            inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)object, InputStream.class);
            String string = region;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)env, (String)"GOOGLE_REGION");
        }
        ArrayList command = (ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"terraform", "import", callSiteArray[155].call(callSiteArray[156].call((Object)"-state=", (Object)this.directory), (Object)"/terraform.tfstate"), callSiteArray[157].call(callSiteArray[158].call((Object)resource, (Object)"."), (Object)name), id}), ArrayList.class);
        JobResult jobStatus = (JobResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].call((Object)this.jobExecutor, callSiteArray[160].callConstructor(JobRequest.class, (Object)command, (Object)env, (Object)inputStream)), JobResult.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[161].call((Object)jobStatus), (Object)callSiteArray[162].callGetProperty(JobResult.Result.class)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[163].call((Object)jobStatus))) {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[164].callCurrent((GroovyObject)this);
            } else {
                this.cleanUpDirectory();
            }
            throw (Throwable)callSiteArray[165].callConstructor(IllegalArgumentException.class, callSiteArray[166].call(callSiteArray[167].call((Object)jobStatus), callSiteArray[168].call((Object)jobStatus)));
        }
    }

    private void createTerraformConfig() {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        Map snapshot = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].call((Object)this.front50Service, (Object)this.directory, callSiteArray[170].call((Object)this.snapshotTimestamp)), Map.class);
        Map terraformConfig = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object = callSiteArray[171].callGetProperty((Object)snapshot);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)terraformConfig, (String)"resource");
        if (!this.hasEnvCredentials) {
            Map provider = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)provider, (String)"google");
            Object object2 = callSiteArray[172].call((Object)new GStringImpl(new Object[]{this.credentialPath}, new String[]{"${file(\"", "\")}"}));
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[173].callGetProperty((Object)provider), (String)"credentials");
            String string = this.project;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)callSiteArray[174].callGetProperty((Object)provider), (String)"project");
            String string2 = "us-central1";
            ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)callSiteArray[175].callGetProperty((Object)provider), (String)"region");
            Map map2 = provider;
            ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)terraformConfig, (String)"provider");
        }
        Object file = callSiteArray[176].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/snapshot.tf.json"}));
        callSiteArray[177].call(file, callSiteArray[178].call((Object)this.objectMapper, (Object)terraformConfig));
    }

    private void addDependencies(Map resource, List dependencies) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[179].callGetProperty((Object)resource), null)) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)resource, (String)"depends_on");
        }
        String dependency = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].call((Object)dependencies), Iterator.class);
        while (iterator.hasNext()) {
            dependency = ShortTypeHandling.castToString(iterator.next());
            callSiteArray[181].call(callSiteArray[182].callGetProperty((Object)resource), (Object)dependency);
        }
    }

    private void cleanUpDirectory() {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        List files = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callConstructor(ArrayList.class), List.class);
        callSiteArray[184].call((Object)files, callSiteArray[185].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"})));
        callSiteArray[186].call((Object)files, callSiteArray[187].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate.backup"})));
        callSiteArray[188].call((Object)files, callSiteArray[189].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", "/snapshot.tf.json"})));
        File file = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[190].call((Object)files), Iterator.class);
        while (iterator.hasNext()) {
            file = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[191].call((Object)file)) || !(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[192].call((Object)file)))) continue;
            throw (Throwable)callSiteArray[193].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[194].callGetProperty((Object)file)}, new String[]{"Error deleting file ", ""}));
        }
        Object dir = callSiteArray[195].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.directory}, new String[]{"", ""}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[196].call(dir))) {
            throw (Throwable)callSiteArray[197].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[198].callGetProperty(dir)}, new String[]{"Error deleting directory ", ""}));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestoreSnapshotAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = RestoreSnapshotAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public GoogleConfigurationProperties getGoogleConfigurationProperties() {
        return this.googleConfigurationProperties;
    }

    @Generated
    public void setGoogleConfigurationProperties(GoogleConfigurationProperties googleConfigurationProperties) {
        this.googleConfigurationProperties = googleConfigurationProperties;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
        return this.googleLoadBalancerProvider;
    }

    @Generated
    public void setGoogleLoadBalancerProvider(GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        this.googleLoadBalancerProvider = googleLoadBalancerProvider;
    }

    @Generated
    public GoogleSecurityGroupProvider getGoogleSecurityGroupProvider() {
        return this.googleSecurityGroupProvider;
    }

    @Generated
    public void setGoogleSecurityGroupProvider(GoogleSecurityGroupProvider googleSecurityGroupProvider) {
        this.googleSecurityGroupProvider = googleSecurityGroupProvider;
    }

    @Generated
    public AccountCredentialsRepository getAccountCredentialsRepository() {
        return this.accountCredentialsRepository;
    }

    @Generated
    public void setAccountCredentialsRepository(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    @Generated
    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Generated
    public void setJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "applicationName";
        stringArray[1] = "accountName";
        stringArray[2] = "snapshotTimestamp";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "get";
        stringArray[5] = "threadLocalTask";
        stringArray[6] = "getOne";
        stringArray[7] = "project";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "environment";
        stringArray[10] = "GOOGLE_PROJECT";
        stringArray[11] = "GOOGLE_CREDENTIALS";
        stringArray[12] = "GOOGLE_REGION";
        stringArray[13] = "iterator";
        stringArray[14] = "accounts";
        stringArray[15] = "name";
        stringArray[16] = "jsonPath";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "mkdir";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "updateStatus";
        stringArray[23] = "task";
        stringArray[24] = "each";
        stringArray[25] = "getClusters";
        stringArray[26] = "updateStatus";
        stringArray[27] = "task";
        stringArray[28] = "each";
        stringArray[29] = "getApplicationLoadBalancers";
        stringArray[30] = "updateStatus";
        stringArray[31] = "task";
        stringArray[32] = "each";
        stringArray[33] = "getAll";
        stringArray[34] = "updateStatus";
        stringArray[35] = "task";
        stringArray[36] = "createTerraformConfig";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "runJob";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "cleanUpDirectory";
        stringArray[42] = "getResult";
        stringArray[43] = "FAILURE";
        stringArray[44] = "getOutput";
        stringArray[45] = "getOutput";
        stringArray[46] = "getError";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "importResource";
        stringArray[49] = "name";
        stringArray[50] = "name";
        stringArray[51] = "region";
        stringArray[52] = "image";
        stringArray[53] = "imageSummary";
        stringArray[54] = "contains";
        stringArray[55] = "name";
        stringArray[56] = "importResource";
        stringArray[57] = "name";
        stringArray[58] = "name";
        stringArray[59] = "region";
        stringArray[60] = "add";
        stringArray[61] = "name";
        stringArray[62] = "items";
        stringArray[63] = "tags";
        stringArray[64] = "properties";
        stringArray[65] = "addAll";
        stringArray[66] = "items";
        stringArray[67] = "tags";
        stringArray[68] = "properties";
        stringArray[69] = "autoscalingPolicy";
        stringArray[70] = "importResource";
        stringArray[71] = "name";
        stringArray[72] = "name";
        stringArray[73] = "region";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "next";
        stringArray[76] = "useDelimiter";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "readValue";
        stringArray[79] = "collect";
        stringArray[80] = "loadBalancers";
        stringArray[81] = "leftShift";
        stringArray[82] = "name";
        stringArray[83] = "addDependencies";
        stringArray[84] = "getAt";
        stringArray[85] = "resources";
        stringArray[86] = "getAt";
        stringArray[87] = "modules";
        stringArray[88] = "name";
        stringArray[89] = "autoscalingPolicy";
        stringArray[90] = "addDependencies";
        stringArray[91] = "getAt";
        stringArray[92] = "resources";
        stringArray[93] = "getAt";
        stringArray[94] = "modules";
        stringArray[95] = "name";
        stringArray[96] = "name";
        stringArray[97] = "withWriter";
        stringArray[98] = "newWriter";
        stringArray[99] = "last";
        stringArray[100] = "split";
        stringArray[101] = "targetPool";
        stringArray[102] = "importResource";
        stringArray[103] = "name";
        stringArray[104] = "region";
        stringArray[105] = "importResource";
        stringArray[106] = "name";
        stringArray[107] = "name";
        stringArray[108] = "region";
        stringArray[109] = "healthCheck";
        stringArray[110] = "contains";
        stringArray[111] = "name";
        stringArray[112] = "healthCheck";
        stringArray[113] = "importResource";
        stringArray[114] = "name";
        stringArray[115] = "healthCheck";
        stringArray[116] = "name";
        stringArray[117] = "healthCheck";
        stringArray[118] = "region";
        stringArray[119] = "add";
        stringArray[120] = "name";
        stringArray[121] = "healthCheck";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "next";
        stringArray[124] = "useDelimiter";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "readValue";
        stringArray[127] = "addDependencies";
        stringArray[128] = "getAt";
        stringArray[129] = "resources";
        stringArray[130] = "getAt";
        stringArray[131] = "modules";
        stringArray[132] = "name";
        stringArray[133] = "name";
        stringArray[134] = "healthCheck";
        stringArray[135] = "addDependencies";
        stringArray[136] = "getAt";
        stringArray[137] = "resources";
        stringArray[138] = "getAt";
        stringArray[139] = "modules";
        stringArray[140] = "name";
        stringArray[141] = "name";
        stringArray[142] = "healthCheck";
        stringArray[143] = "withWriter";
        stringArray[144] = "newWriter";
        stringArray[145] = "importResource";
        stringArray[146] = "name";
        stringArray[147] = "name";
        stringArray[148] = "region";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "environment";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "getBytes";
        stringArray[153] = "toString";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "plus";
        stringArray[156] = "plus";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "runJob";
        stringArray[160] = "<$constructor$>";
        stringArray[161] = "getResult";
        stringArray[162] = "FAILURE";
        stringArray[163] = "getOutput";
        stringArray[164] = "cleanUpDirectory";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "plus";
        stringArray[167] = "getOutput";
        stringArray[168] = "getError";
        stringArray[169] = "getSnapshotVersion";
        stringArray[170] = "toString";
        stringArray[171] = "infrastructure";
        stringArray[172] = "toString";
        stringArray[173] = "google";
        stringArray[174] = "google";
        stringArray[175] = "google";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "write";
        stringArray[178] = "writeValueAsString";
        stringArray[179] = "depends_on";
        stringArray[180] = "iterator";
        stringArray[181] = "leftShift";
        stringArray[182] = "depends_on";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "leftShift";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "leftShift";
        stringArray[187] = "<$constructor$>";
        stringArray[188] = "leftShift";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "iterator";
        stringArray[191] = "exists";
        stringArray[192] = "delete";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "name";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "delete";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "name";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[199];
        RestoreSnapshotAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RestoreSnapshotAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RestoreSnapshotAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

