/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.common.collect.ImmutableSet;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.compute.RegionAutoscalers;
import com.netflix.spinnaker.clouddriver.google.compute.RegionInstanceGroupManagers;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class GoogleRegionalServerGroupCachingAgent
extends AbstractGoogleServerGroupCachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleRegionalServerGroupCachingAgent.class);

    public GoogleRegionalServerGroupCachingAgent(GoogleNamedAccountCredentials credentials, GoogleComputeApiFactory computeApiFactory, Registry registry, String region, ObjectMapper objectMapper) {
        super(credentials, computeApiFactory, registry, region, objectMapper);
    }

    @Override
    Collection<String> getOnDemandKeysToEvictForMissingServerGroup(ProviderCache providerCache, String serverGroupName) {
        String clusterName = null;
        return ImmutableSet.of((Object)Keys.getServerGroupKey(serverGroupName, clusterName, this.getAccountName(), this.getRegion()));
    }

    @Override
    boolean keyOwnedByThisAgent(Map<String, String> parsedKey) {
        return this.getAccountName().equals(parsedKey.get("account")) && this.getRegion().equals(parsedKey.get("region")) && parsedKey.get("zone") == null;
    }

    @Override
    Collection<InstanceGroupManager> retrieveInstanceGroupManagers() throws IOException {
        RegionInstanceGroupManagers managersApi = this.getComputeApiFactory().createRegionInstanceGroupManagers(this.getCredentials());
        return managersApi.list(this.getRegion()).execute();
    }

    @Override
    Collection<Autoscaler> retrieveAutoscalers() throws IOException {
        RegionAutoscalers autoscalersApi = this.getComputeApiFactory().createRegionAutoscalers(this.getCredentials());
        return autoscalersApi.list(this.getRegion()).execute();
    }

    @Override
    Optional<InstanceGroupManager> retrieveInstanceGroupManager(String name) throws IOException {
        RegionInstanceGroupManagers managersApi = this.getComputeApiFactory().createRegionInstanceGroupManagers(this.getCredentials());
        return managersApi.get(this.getRegion(), name).executeGet();
    }

    @Override
    Optional<Autoscaler> retrieveAutoscaler(InstanceGroupManager manager) throws IOException {
        RegionAutoscalers autoscalersApi = this.getComputeApiFactory().createRegionAutoscalers(this.getCredentials());
        return autoscalersApi.get(this.getRegion(), manager.getName()).executeGet();
    }

    @Override
    Collection<Instance> retrieveRelevantInstances(InstanceGroupManager instanceGroupManager) throws IOException {
        return this.retrieveAllInstancesInRegion();
    }

    @Override
    String getBatchContextPrefix() {
        return "RegionalServerGroupCaching";
    }
}

