/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSubnet;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.model.SubnetProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleSubnetProvider
implements SubnetProvider<GoogleSubnet>,
GroovyObject {
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public GoogleSubnetProvider(AccountCredentialsProvider accountCredentialsProvider, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        AccountCredentialsProvider accountCredentialsProvider2;
        MetaClass metaClass;
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(GoogleCloudProvider.class);
        this.cloudProvider = ShortTypeHandling.castToString((Object)object);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.accountCredentialsProvider = accountCredentialsProvider2 = accountCredentialsProvider;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<GoogleSubnet> getAll() {
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].call(Keys.class, (Object)"*", (Object)"*", (Object)"*")), Set.class);
    }

    public Set<GoogleSubnet> getAllMatchingKeyPattern(String pattern) {
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, callSiteArray[4].call((Object)this.cacheView, callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(Keys.Namespace.class)), (Object)pattern)), Set.class);
    }

    public Set<GoogleSubnet> loadResults(Collection<String> identifiers) {
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        Object data = callSiteArray[7].call((Object)this.cacheView, callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty(Keys.Namespace.class)), identifiers, callSiteArray[10].call(RelationshipCacheFilter.class));
        Object transformed = callSiteArray[11].call(data, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"));
        return (Set)ScriptBytecodeAdapter.castToType((Object)transformed, Set.class);
    }

    public GoogleSubnet fromCacheData(CacheData cacheData) {
        Object object;
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        Map subnet = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callGetProperty(callSiteArray[13].callGetProperty((Object)cacheData)), Map.class);
        Map parts = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call(Keys.class, callSiteArray[15].callGetProperty((Object)cacheData)), Map.class);
        return (GoogleSubnet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(GoogleSubnet.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", this.cloudProvider, "id", callSiteArray[17].callGetProperty((Object)parts), "name", callSiteArray[18].callGetProperty((Object)subnet), "gatewayAddress", callSiteArray[19].callGetProperty((Object)subnet), "network", callSiteArray[20].callCurrent((GroovyObject)this, callSiteArray[21].callGetProperty((Object)parts), (Object)subnet), "cidrBlock", callSiteArray[22].callGetProperty((Object)subnet), "account", callSiteArray[23].callGetProperty((Object)parts), "region", callSiteArray[24].callGetProperty((Object)parts), "selfLink", callSiteArray[25].callGetProperty((Object)subnet), "purpose", DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[26].callGetProperty((Object)subnet))) ? object : "n/a"})), GoogleSubnet.class);
    }

    private String deriveNetworkId(String account, Map subnet) {
        CallSite[] callSiteArray = GoogleSubnetProvider.$getCallSiteArray();
        Object accountCredentials = callSiteArray[27].call((Object)this.accountCredentialsProvider, (Object)account);
        if (!(accountCredentials instanceof GoogleNamedAccountCredentials)) {
            throw (Throwable)callSiteArray[28].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{account}, new String[]{"Invalid credentials: ", ""}));
        }
        Object project = callSiteArray[29].callGetProperty(accountCredentials);
        Object networkProject = callSiteArray[30].call(GCEUtil.class, callSiteArray[31].callGetProperty((Object)subnet));
        Object networkId = callSiteArray[32].call(GCEUtil.class, callSiteArray[33].callGetProperty((Object)subnet));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)networkProject, (Object)project)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{networkProject, networkId}, new String[]{"", "/", ""});
            networkId = gStringImpl;
        }
        return ShortTypeHandling.castToString((Object)networkId);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleSubnetProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ID";
        stringArray[1] = "getAllMatchingKeyPattern";
        stringArray[2] = "getSubnetKey";
        stringArray[3] = "loadResults";
        stringArray[4] = "filterIdentifiers";
        stringArray[5] = "ns";
        stringArray[6] = "SUBNETS";
        stringArray[7] = "getAll";
        stringArray[8] = "ns";
        stringArray[9] = "SUBNETS";
        stringArray[10] = "none";
        stringArray[11] = "collect";
        stringArray[12] = "subnet";
        stringArray[13] = "attributes";
        stringArray[14] = "parse";
        stringArray[15] = "id";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "id";
        stringArray[18] = "name";
        stringArray[19] = "gatewayAddress";
        stringArray[20] = "deriveNetworkId";
        stringArray[21] = "account";
        stringArray[22] = "ipCidrRange";
        stringArray[23] = "account";
        stringArray[24] = "region";
        stringArray[25] = "selfLink";
        stringArray[26] = "purpose";
        stringArray[27] = "getCredentials";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "project";
        stringArray[30] = "deriveProjectId";
        stringArray[31] = "network";
        stringArray[32] = "getLocalName";
        stringArray[33] = "network";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[34];
        GoogleSubnetProvider.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GoogleSubnetProvider.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GoogleSubnetProvider.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

