/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.batch;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.ComputeRequest;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBatchRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleBatchRequest.class);
    private static final int MAX_BATCH_SIZE = 100;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(2L);
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(2L);
    private List<QueuedRequest> queuedRequests;
    private String clouddriverUserAgentApplicationName;
    private Compute compute;

    public GoogleBatchRequest(Compute compute, String clouddriverUserAgentApplicationName) {
        this.compute = compute;
        this.clouddriverUserAgentApplicationName = clouddriverUserAgentApplicationName;
        this.queuedRequests = new ArrayList<QueuedRequest>();
    }

    public void execute() {
        if (this.queuedRequests.size() == 0) {
            log.debug("No requests queued in batch, exiting.");
            return;
        }
        ArrayList queuedBatches = new ArrayList();
        List requestPartitions = Lists.partition(this.queuedRequests, (int)100);
        requestPartitions.forEach(requestPart -> {
            BatchRequest newBatch = this.newBatch();
            requestPart.forEach(qr -> {
                try {
                    qr.getRequest().queue(newBatch, qr.getCallback());
                }
                catch (IOException ioe) {
                    log.error("Queueing request {} in batch failed.", qr);
                    throw new RuntimeException(ioe);
                }
            });
            queuedBatches.add(newBatch);
        });
        ForkJoinPool threadPool = new ForkJoinPool(10);
        try {
            threadPool.submit(() -> ((Stream)queuedBatches.stream().parallel()).forEach(this::executeInternalBatch)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        threadPool.shutdown();
    }

    private void executeInternalBatch(BatchRequest b) {
        try {
            b.execute();
        }
        catch (IOException ioe) {
            log.error("Executing batch {} failed.", (Object)b);
            throw new RuntimeException(ioe);
        }
    }

    private BatchRequest newBatch() {
        return this.compute.batch(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setUserAgent(GoogleBatchRequest.this.clouddriverUserAgentApplicationName);
                request.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS);
                request.setReadTimeout(DEFAULT_READ_TIMEOUT_MILLIS);
            }
        });
    }

    public void queue(ComputeRequest request, JsonBatchCallback callback) {
        this.queuedRequests.add(new QueuedRequest(request, callback));
    }

    public Integer size() {
        return this.queuedRequests.size();
    }

    private static class QueuedRequest {
        private ComputeRequest request;
        private JsonBatchCallback callback;

        @Generated
        public ComputeRequest getRequest() {
            return this.request;
        }

        @Generated
        public JsonBatchCallback getCallback() {
            return this.callback;
        }

        @Generated
        public QueuedRequest setRequest(ComputeRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public QueuedRequest setCallback(JsonBatchCallback callback) {
            this.callback = callback;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueuedRequest)) {
                return false;
            }
            QueuedRequest other = (QueuedRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ComputeRequest this$request = this.getRequest();
            ComputeRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            JsonBatchCallback this$callback = this.getCallback();
            JsonBatchCallback other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueuedRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ComputeRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            JsonBatchCallback $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GoogleBatchRequest.QueuedRequest(request=" + this.getRequest() + ", callback=" + this.getCallback() + ")";
        }

        @Generated
        public QueuedRequest(ComputeRequest request, JsonBatchCallback callback) {
            this.request = request;
            this.callback = callback;
        }
    }
}

