/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.services.compute.ComputeRequest;
import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import com.netflix.spinnaker.clouddriver.google.security.AccountForClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class GoogleComputeRequestImpl<RequestT extends ComputeRequest<ResponseT>, ResponseT>
implements GoogleComputeRequest<RequestT, ResponseT> {
    private final RequestT request;
    private final Registry registry;
    private final String metricName;
    private final Map<String, String> tags;

    GoogleComputeRequestImpl(RequestT request, Registry registry, String metricName, Map<String, String> tags) {
        this.request = request;
        this.registry = registry;
        this.metricName = metricName;
        this.tags = tags;
    }

    @Override
    public ResponseT execute() throws IOException {
        return this.timeExecute(this.request);
    }

    private ResponseT timeExecute(RequestT request) throws IOException {
        return (ResponseT)GoogleExecutor.timeExecute(this.registry, request, "google.api", this.metricName, this.getTimeExecuteTags(request));
    }

    private String[] getTimeExecuteTags(RequestT request) {
        String account = AccountForClient.getAccount((AbstractGoogleClient)request.getAbstractGoogleClient());
        return (String[])ImmutableList.builder().add((Object)"account").add((Object)account).addAll(this.flattenTags()).build().toArray((Object[])new String[0]);
    }

    private List<String> flattenTags() {
        return this.tags.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public RequestT getRequest() {
        return this.request;
    }
}

