/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.config;

import com.netflix.spinnaker.clouddriver.google.ComputeVersion;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.config.GoogleConfiguration;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.CredentialsTypeBaseConfiguration;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.poller.Poller;
import com.netflix.spinnaker.kork.configserver.ConfigFileService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GoogleCredentialsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GoogleCredentialsConfiguration.class);
    @Autowired
    NamerRegistry namerRegistry;

    @Bean
    public CredentialsTypeBaseConfiguration<GoogleNamedAccountCredentials, GoogleConfigurationProperties.ManagedAccount> googleCredentialsProperties(ApplicationContext applicationContext, GoogleConfigurationProperties configurationProperties, ConfigFileService configFileService, GoogleConfiguration.DeployDefaults googleDeployDefaults, GoogleExecutor googleExecutor, String clouddriverUserAgentApplicationName) {
        return new CredentialsTypeBaseConfiguration(applicationContext, CredentialsTypeProperties.builder().type("gce").credentialsDefinitionClass(GoogleConfigurationProperties.ManagedAccount.class).credentialsClass(GoogleNamedAccountCredentials.class).credentialsParser(a -> {
            try {
                String jsonKey = configFileService.getContents(a.getJsonPath());
                return new GoogleNamedAccountCredentials.Builder().name(a.getName()).environment(StringUtils.isEmpty((CharSequence)a.getEnvironment()) ? a.getName() : a.getEnvironment()).accountType(StringUtils.isEmpty((CharSequence)a.getAccountType()) ? a.getName() : a.getAccountType()).project(a.getProject()).computeVersion(a.isAlphaListed() ? ComputeVersion.ALPHA : ComputeVersion.DEFAULT).jsonKey(jsonKey).serviceAccountId(a.getServiceAccountId()).serviceAccountProject(a.getServiceAccountProject()).imageProjects(a.getImageProjects()).requiredGroupMembership(a.getRequiredGroupMembership()).permissions(a.getPermissions().build()).applicationName(clouddriverUserAgentApplicationName).consulConfig(a.getConsul()).instanceTypeDisks(googleDeployDefaults.getInstanceTypeDisks()).userDataFile(a.getUserDataFile()).regionsToManage(a.getRegions(), configurationProperties.getDefaultRegions()).namer(this.namerRegistry.getNamingStrategy(a.getNamingStrategy())).build();
            }
            catch (Exception e) {
                log.info("Error loading Google credentials: " + e.getMessage() + ".");
                return null;
            }
        }).defaultCredentialsSource(configurationProperties::getAccounts).build());
    }

    @Bean
    public CredentialsInitializerSynchronizable googleCredentialsInitializerSynchronizable(AbstractCredentialsLoader<GoogleNamedAccountCredentials> loader) {
        final Poller poller = new Poller(loader);
        return new CredentialsInitializerSynchronizable(){

            public void synchronize() {
                poller.run();
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={GoogleNamedAccountCredentials.class}, parameterizedContainer={CredentialsRepository.class})
    public CredentialsRepository<GoogleNamedAccountCredentials> googleCredentialsRepository(CredentialsLifecycleHandler<GoogleNamedAccountCredentials> eventHandler) {
        return new MapBackedCredentialsRepository(GoogleCloudProvider.getID(), eventHandler);
    }
}

