/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.StatefulPolicy;
import com.google.api.services.compute.model.StatefulPolicyPreservedState;
import com.google.api.services.compute.model.StatefulPolicyPreservedStateDiskDevice;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.description.SetStatefulDiskDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;

public class SetStatefulDiskAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "SET_STATEFUL_DISK";
    private final GoogleClusterProvider clusterProvider;
    private final GoogleComputeApiFactory computeApiFactory;
    private final SetStatefulDiskDescription description;

    public SetStatefulDiskAtomicOperation(GoogleClusterProvider clusterProvider, GoogleComputeApiFactory computeApiFactory, SetStatefulDiskDescription description) {
        this.clusterProvider = clusterProvider;
        this.computeApiFactory = computeApiFactory;
        this.description = description;
    }

    public Void operate(List priorOutputs) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        task.updateStatus(BASE_PHASE, String.format("Initializing set stateful disk of instance group %s in region %s", this.description.getServerGroupName(), this.description.getRegion()));
        GoogleServerGroup.View serverGroup = GCEUtil.queryServerGroup(this.clusterProvider, this.description.getAccount(), this.description.getRegion(), this.description.getServerGroupName());
        try {
            GoogleServerGroupManagers managers = this.computeApiFactory.createServerGroupManagers(this.description.getCredentials(), serverGroup);
            task.updateStatus(BASE_PHASE, "Retrieving current instance group definition");
            InstanceGroupManager instanceGroupManager = (InstanceGroupManager)managers.get().execute();
            this.setStatefulPolicy(instanceGroupManager);
            task.updateStatus(BASE_PHASE, "Storing updated instance group definition");
            managers.update(instanceGroupManager).executeAndWait((Task)TaskRepository.threadLocalTask.get(), BASE_PHASE);
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setStatefulPolicy(InstanceGroupManager instanceGroupManager) {
        StatefulPolicyPreservedState preservedState;
        StatefulPolicy statefulPolicy;
        if (instanceGroupManager.getStatefulPolicy() == null) {
            instanceGroupManager.setStatefulPolicy(new StatefulPolicy());
        }
        if ((statefulPolicy = instanceGroupManager.getStatefulPolicy()).getPreservedState() == null) {
            statefulPolicy.setPreservedState(new StatefulPolicyPreservedState());
        }
        if ((preservedState = statefulPolicy.getPreservedState()).getDisks() == null) {
            preservedState.setDisks(new HashMap());
        }
        preservedState.getDisks().put(this.description.getDeviceName(), new StatefulPolicyPreservedStateDiskDevice());
    }

    @VisibleForTesting
    public SetStatefulDiskDescription getDescription() {
        return this.description;
    }
}

