/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerUpdatePolicy;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.compute.GetFirstBatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.Images;
import com.netflix.spinnaker.clouddriver.google.compute.InstanceTemplates;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.description.StatefullyUpdateBootImageDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleResourceIllegalStateException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefullyUpdateBootImageAtomicOperation
extends GoogleAtomicOperation<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatefullyUpdateBootImageAtomicOperation.class);
    private static final String BASE_PHASE = "STATEFULLY_UPDATE_BOOT_IMAGE";
    private static final Random RANDOM = new Random();
    private final GoogleClusterProvider clusterProvider;
    private final GoogleComputeApiFactory computeApiFactory;
    private final GoogleConfigurationProperties googleConfigurationProperties;
    private final StatefullyUpdateBootImageDescription description;

    public StatefullyUpdateBootImageAtomicOperation(GoogleClusterProvider clusterProvider, GoogleComputeApiFactory computeApiFactory, GoogleConfigurationProperties googleConfigurationProperties, StatefullyUpdateBootImageDescription description) {
        this.clusterProvider = clusterProvider;
        this.computeApiFactory = computeApiFactory;
        this.googleConfigurationProperties = googleConfigurationProperties;
        this.description = description;
    }

    public Void operate(List priorOutputs) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        GoogleNamedAccountCredentials credentials = this.description.getCredentials();
        GoogleServerGroup.View serverGroup = GCEUtil.queryServerGroup(this.clusterProvider, this.description.getAccount(), this.description.getRegion(), this.description.getServerGroupName());
        try {
            Image image = this.getImage(task, credentials);
            GoogleServerGroupManagers managers = this.computeApiFactory.createServerGroupManagers(credentials, serverGroup);
            task.updateStatus(BASE_PHASE, String.format("Retrieving server group %s.", serverGroup.getName()));
            InstanceGroupManager instanceGroupManager = (InstanceGroupManager)managers.get().execute();
            GoogleResourceIllegalStateException.checkResourceState(instanceGroupManager.getVersions().size() == 1, "Found more than one instance template for the server group %s.", this.description.getServerGroupName());
            GoogleResourceIllegalStateException.checkResourceState(instanceGroupManager.getStatefulPolicy() != null, "Server group %s does not have a StatefulPolicy", this.description.getServerGroupName());
            String oldTemplateName = GCEUtil.getLocalName(instanceGroupManager.getInstanceTemplate());
            InstanceTemplates instanceTemplates = this.computeApiFactory.createInstanceTemplates(credentials);
            task.updateStatus(BASE_PHASE, String.format("Retrieving instance template %s.", oldTemplateName));
            GoogleComputeGetRequest<Compute.InstanceTemplates.Get, InstanceTemplate> request = instanceTemplates.get(oldTemplateName);
            InstanceTemplate template = (InstanceTemplate)request.execute();
            String newTemplateName = StatefullyUpdateBootImageAtomicOperation.getNewTemplateName(this.description.getServerGroupName());
            template.setName(newTemplateName);
            List disks = template.getProperties().getDisks().stream().filter(AttachedDisk::getBoot).collect(Collectors.toList());
            Preconditions.checkState((disks.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one boot disk, found %s", (int)disks.size());
            AttachedDisk bootDisk = (AttachedDisk)disks.get(0);
            bootDisk.getInitializeParams().setSourceImage(image.getSelfLink());
            task.updateStatus(BASE_PHASE, String.format("Saving new instance template %s.", newTemplateName));
            instanceTemplates.insert(template).executeAndWait(task, BASE_PHASE);
            instanceGroupManager.setInstanceTemplate(GCEUtil.buildInstanceTemplateUrl(credentials.getProject(), newTemplateName)).setVersions((List)ImmutableList.of()).setUpdatePolicy(new InstanceGroupManagerUpdatePolicy().setType("OPPORTUNISTIC"));
            task.updateStatus(BASE_PHASE, String.format("Starting update of server group %s.", serverGroup.getName()));
            managers.patch(instanceGroupManager).executeAndWait(task, BASE_PHASE);
            task.updateStatus(BASE_PHASE, String.format("Deleting instance template %s.", oldTemplateName));
            instanceTemplates.delete(oldTemplateName).executeAndWait(task, BASE_PHASE);
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnull
    private Image getImage(Task task, GoogleNamedAccountCredentials credentials) throws IOException {
        task.updateStatus(BASE_PHASE, "Looking up image " + this.description.getBootImage());
        Images imagesApi = this.computeApiFactory.createImages(credentials);
        GetFirstBatchComputeRequest<Compute.Images.Get, Image> batchRequest = GetFirstBatchComputeRequest.create(this.computeApiFactory.createBatchRequest(credentials));
        for (String project : this.getImageProjects(credentials)) {
            GoogleComputeGetRequest<Compute.Images.Get, Image> request = imagesApi.get(project, this.description.getBootImage());
            batchRequest.queue(request);
        }
        Optional image = batchRequest.execute("findImage");
        return (Image)image.orElseThrow(() -> new GoogleResourceIllegalStateException("Couldn't find an image named " + this.description.getBootImage()));
    }

    private ImmutableSet<String> getImageProjects(GoogleNamedAccountCredentials credentials) {
        return ImmutableSet.builder().add((Object)credentials.getProject()).addAll(credentials.getImageProjects()).addAll(this.googleConfigurationProperties.getBaseImageProjects()).build();
    }

    private static String getNewTemplateName(String serverGroupName) {
        return String.format("%s-%08d", serverGroupName, RANDOM.nextInt(100000000));
    }
}

