/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.TargetPool;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleLoadBalancerAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_LOAD_BALANCER";
    private static final Boolean INSTANCE_REMOVAL_WORKAROUND;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private SafeRetry safeRetry;
    private DeleteGoogleLoadBalancerDescription description;
    @VisibleForTesting
    private GoogleOperationPoller.ThreadSleeper threadSleeper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DeleteGoogleLoadBalancerAtomicOperation() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(GoogleOperationPoller.ThreadSleeper.class);
        this.threadSleeper = (GoogleOperationPoller.ThreadSleeper)ScriptBytecodeAdapter.castToType((Object)object, GoogleOperationPoller.ThreadSleeper.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public DeleteGoogleLoadBalancerAtomicOperation(DeleteGoogleLoadBalancerDescription description) {
        DeleteGoogleLoadBalancerDescription deleteGoogleLoadBalancerDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = callSiteArray[1].callConstructor(GoogleOperationPoller.ThreadSleeper.class);
        this.threadSleeper = (GoogleOperationPoller.ThreadSleeper)ScriptBytecodeAdapter.castToType((Object)object, GoogleOperationPoller.ThreadSleeper.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, callSiteArray[6].call((Object)new GStringImpl(new Object[]{callSiteArray[7].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Initializing deletion of load balancer ", " "}), (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"in ", "..."})));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this.description))) {
            throw (Throwable)callSiteArray[10].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."}));
        }
        Reference compute = new Reference(callSiteArray[12].callGetProperty(callSiteArray[13].callGroovyObjectGetProperty((Object)this.description)));
        Reference project = new Reference(callSiteArray[14].callGetProperty(callSiteArray[15].callGroovyObjectGetProperty((Object)this.description)));
        Reference region = new Reference(callSiteArray[16].callGroovyObjectGetProperty((Object)this.description));
        Reference forwardingRuleName = new Reference(callSiteArray[17].callGroovyObjectGetProperty((Object)this.description));
        callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{forwardingRuleName.get(), region.get()}, new String[]{"Retrieving forwarding rule ", " in ", "..."}));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference forwardingRuleName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.forwardingRuleName.get()), (Object)"compute.forwardingRules.get", (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object getForwardingRuleName() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.forwardingRuleName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "forwardingRules";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _operate_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ForwardingRule forwardingRule = (ForwardingRule)ScriptBytecodeAdapter.asType((Object)callSiteArray[20].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure1(this, this, compute, project, region, forwardingRuleName)), (Object)new GStringImpl(new Object[]{forwardingRuleName.get()}, new String[]{"Regional forwarding rule ", ""}), (Object)callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", BASE_PHASE, "operation", "compute.forwardingRules.get", callSiteArray[22].callGroovyObjectGetProperty((Object)this), callSiteArray[23].callGroovyObjectGetProperty((Object)this), callSiteArray[24].callGroovyObjectGetProperty((Object)this), region.get()}), (Object)callSiteArray[25].callGroovyObjectGetProperty((Object)this))), ForwardingRule.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)forwardingRule, null)) {
            callSiteArray[26].call(GCEUtil.class, (Object)new GStringImpl(new Object[]{forwardingRuleName.get(), region.get(), project.get()}, new String[]{"Forwarding rule ", " not found in ", " for ", ""}), callSiteArray[27].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE);
        }
        Reference targetPoolName = new Reference(callSiteArray[28].call(GCEUtil.class, callSiteArray[29].call((Object)forwardingRule)));
        callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetPoolName.get(), region.get()}, new String[]{"Retrieving target pool ", " in ", "..."}));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference targetPoolName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference targetPoolName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.targetPoolName = reference = targetPoolName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetPoolName.get()), (Object)"compute.targetPools.get", (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object getTargetPoolName() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.targetPoolName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "get";
                stringArray[2] = "targetPools";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _operate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        TargetPool targetPool = (TargetPool)ScriptBytecodeAdapter.asType((Object)callSiteArray[32].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure2(this, this, compute, project, region, targetPoolName)), (Object)new GStringImpl(new Object[]{targetPoolName.get()}, new String[]{"Target pool ", ""}), (Object)callSiteArray[33].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", BASE_PHASE, "operation", "compute.targetPools.get", callSiteArray[34].callGroovyObjectGetProperty((Object)this), callSiteArray[35].callGroovyObjectGetProperty((Object)this), callSiteArray[36].callGroovyObjectGetProperty((Object)this), region.get()}), (Object)callSiteArray[37].callGroovyObjectGetProperty((Object)this))), TargetPool.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)targetPool, null)) {
            callSiteArray[38].call(GCEUtil.class, (Object)new GStringImpl(new Object[]{targetPoolName.get(), region.get(), project.get()}, new String[]{"Target pool ", " not found in ", " for ", ""}), callSiteArray[39].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].callGetProperty((Object)targetPool))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)INSTANCE_REMOVAL_WORKAROUND)) {
                Reference projectInstanceNames = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(DeleteGoogleLoadBalancerAtomicOperation.class, (Object)callSiteArray[41].call(GCEUtil.class, (Object)this, callSiteArray[42].callGroovyObjectGetProperty((Object)this.description)), (String)"name"), List.class)));
                public final class _operate_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference projectInstanceNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _operate_closure3(Object _outerInstance, Object _thisObject, Reference projectInstanceNames) {
                        Reference reference;
                        CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.projectInstanceNames = reference = projectInstanceNames;
                    }

                    public Object doCall(String instanceUrl) {
                        CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].call(GCEUtil.class, (Object)instanceUrl), (Object)this.projectInstanceNames.get());
                    }

                    @Generated
                    public Object call(String instanceUrl) {
                        CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[1].callCurrent((GroovyObject)this, (Object)instanceUrl);
                        }
                        return this.doCall(instanceUrl);
                    }

                    @Generated
                    public List getProjectInstanceNames() {
                        CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.projectInstanceNames.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getLocalName";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _operate_closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_operate_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _operate_closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                List existingReferencedInstances = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(callSiteArray[44].callGetProperty((Object)targetPool), (Object)new _operate_closure3(this, this, projectInstanceNames)), List.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)existingReferencedInstances)) {
                    callSiteArray[45].call(callSiteArray[46].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{existingReferencedInstances, callSiteArray[47].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Instances ", " still associated with network load balancer ", ". Failing..."}));
                    throw (Throwable)callSiteArray[48].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{existingReferencedInstances, callSiteArray[49].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Instances ", " still associated with network load balancer ", ". Failing..."}));
                }
            } else {
                callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[52].callGetProperty((Object)targetPool), callSiteArray[53].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Instances ", " still associated with network load balancer ", ". Failing..."}));
                throw (Throwable)callSiteArray[54].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[55].callGetProperty((Object)targetPool), callSiteArray[56].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Instances ", " still associated with network load balancer ", ". Failing..."}));
            }
        }
        Object healthCheckUrls = callSiteArray[57].call((Object)targetPool);
        Object timeoutSeconds = callSiteArray[58].callGroovyObjectGetProperty((Object)this.description);
        callSiteArray[59].call(callSiteArray[60].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{forwardingRuleName.get(), region.get()}, new String[]{"Deleting forwarding rule ", " in ", "..."}));
        public final class _operate_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure4(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference forwardingRuleName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.forwardingRuleName.get()), (Object)"compute.forwardingRules.delete", (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object getForwardingRuleName() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.forwardingRuleName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "delete";
                stringArray[2] = "forwardingRules";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _operate_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Operation deleteForwardingRuleOperation = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure4(this, this, compute, project, region, forwardingRuleName)), (Object)new GStringImpl(new Object[]{forwardingRuleName.get()}, new String[]{"Regional forwarding rule ", ""}), (Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE, "operation", "compute.forwardingRules.delete", callSiteArray[63].callGroovyObjectGetProperty((Object)this), callSiteArray[64].callGroovyObjectGetProperty((Object)this), callSiteArray[65].callGroovyObjectGetProperty((Object)this), region.get()}), (Object)callSiteArray[66].callGroovyObjectGetProperty((Object)this))), Operation.class);
        callSiteArray[67].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)region.get(), (Object)callSiteArray[68].call((Object)deleteForwardingRuleOperation), (Object)timeoutSeconds, (Object)callSiteArray[69].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[70].call((Object)"forwarding rule ", forwardingRuleName.get()), (Object)BASE_PHASE));
        callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetPoolName.get(), region.get()}, new String[]{"Deleting target pool ", " in ", "..."}));
        public final class _operate_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference targetPoolName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure5(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference targetPoolName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.targetPoolName = reference = targetPoolName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.targetPoolName.get()), (Object)"compute.targetPools.delete", (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object getTargetPoolName() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return this.targetPoolName.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "timeExecute";
                stringArray[1] = "delete";
                stringArray[2] = "targetPools";
                stringArray[3] = "TAG_SCOPE";
                stringArray[4] = "SCOPE_REGIONAL";
                stringArray[5] = "TAG_REGION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _operate_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Operation deleteTargetPoolOperation = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[73].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure5(this, this, compute, project, region, targetPoolName)), (Object)new GStringImpl(new Object[]{targetPoolName.get()}, new String[]{"Target pool ", ""}), (Object)callSiteArray[74].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE, "operation", "compute.targetPools.delete", callSiteArray[75].callGroovyObjectGetProperty((Object)this), callSiteArray[76].callGroovyObjectGetProperty((Object)this), callSiteArray[77].callGroovyObjectGetProperty((Object)this), region.get()}), (Object)callSiteArray[78].callGroovyObjectGetProperty((Object)this))), Operation.class);
        callSiteArray[79].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)region.get(), (Object)callSiteArray[80].call((Object)deleteTargetPoolOperation), (Object)timeoutSeconds, (Object)callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[82].call((Object)"target pool ", targetPoolName.get()), (Object)BASE_PHASE));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[83].callGroovyObjectGetProperty((Object)this.description))) {
            List deleteHealthCheckAsyncOperations = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].callConstructor(ArrayList.class), List.class);
            String healthCheckUrl = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].call(healthCheckUrls), Iterator.class);
            while (iterator.hasNext()) {
                healthCheckUrl = ShortTypeHandling.castToString(iterator.next());
                Reference healthCheckName = new Reference(callSiteArray[86].call(GCEUtil.class, (Object)healthCheckUrl));
                public final class _operate_closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference healthCheckName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _operate_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.healthCheckName = reference = healthCheckName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.healthCheckName.get()), (Object)"compute.httpHealthChecks.delete", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
                    }

                    @Generated
                    public Object getCompute() {
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        return this.compute.get();
                    }

                    @Generated
                    public Object getProject() {
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        return this.project.get();
                    }

                    @Generated
                    public Object getHealthCheckName() {
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        return this.healthCheckName.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "timeExecute";
                        stringArray[1] = "delete";
                        stringArray[2] = "httpHealthChecks";
                        stringArray[3] = "TAG_SCOPE";
                        stringArray[4] = "SCOPE_GLOBAL";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _operate_closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_operate_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _operate_closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Operation deleteHealthCheckOp = (Operation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(GCEUtil.class, ArrayUtil.createArray((Object)((Object)new _operate_closure6(this, this, compute, project, healthCheckName)), (Object)new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Http health check ", ""}), (Object)project.get(), (Object)callSiteArray[88].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.httpsHealthChecks.delete", "phase", BASE_PHASE, callSiteArray[89].callGroovyObjectGetProperty((Object)this), callSiteArray[90].callGroovyObjectGetProperty((Object)this)}), (Object)this.safeRetry, (Object)this)), Operation.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)deleteHealthCheckOp)) continue;
                callSiteArray[91].call((Object)deleteHealthCheckAsyncOperations, callSiteArray[92].callConstructor(HealthCheckAsyncDeleteOperation.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheckName", healthCheckName.get(), "operationName", callSiteArray[93].call((Object)deleteHealthCheckOp)})));
            }
            HealthCheckAsyncDeleteOperation asyncOperation = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call((Object)deleteHealthCheckAsyncOperations), Iterator.class);
            while (iterator2.hasNext()) {
                asyncOperation = (HealthCheckAsyncDeleteOperation)ScriptBytecodeAdapter.castToType(iterator2.next(), HealthCheckAsyncDeleteOperation.class);
                callSiteArray[95].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[96].callGroovyObjectGetProperty((Object)asyncOperation), (Object)timeoutSeconds, (Object)callSiteArray[97].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[98].call((Object)"health check ", callSiteArray[99].callGroovyObjectGetProperty((Object)asyncOperation)), (Object)BASE_PHASE));
            }
        }
        callSiteArray[100].call(callSiteArray[101].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[102].callGroovyObjectGetProperty((Object)this.description), region.get()}, new String[]{"Done deleting load balancer ", " in ", "."}));
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteGoogleLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DeleteGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DeleteGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DeleteGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    static {
        boolean bl = true;
        INSTANCE_REMOVAL_WORKAROUND = bl;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    @Generated
    public GoogleOperationPoller.ThreadSleeper getThreadSleeper() {
        return this.threadSleeper;
    }

    @Generated
    public void setThreadSleeper(GoogleOperationPoller.ThreadSleeper threadSleeper) {
        this.threadSleeper = threadSleeper;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "get";
        stringArray[3] = "threadLocalTask";
        stringArray[4] = "updateStatus";
        stringArray[5] = "task";
        stringArray[6] = "plus";
        stringArray[7] = "loadBalancerName";
        stringArray[8] = "region";
        stringArray[9] = "credentials";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "accountName";
        stringArray[12] = "compute";
        stringArray[13] = "credentials";
        stringArray[14] = "project";
        stringArray[15] = "credentials";
        stringArray[16] = "region";
        stringArray[17] = "loadBalancerName";
        stringArray[18] = "updateStatus";
        stringArray[19] = "task";
        stringArray[20] = "doRetry";
        stringArray[21] = "task";
        stringArray[22] = "TAG_SCOPE";
        stringArray[23] = "SCOPE_REGIONAL";
        stringArray[24] = "TAG_REGION";
        stringArray[25] = "registry";
        stringArray[26] = "updateStatusAndThrowNotFoundException";
        stringArray[27] = "task";
        stringArray[28] = "getLocalName";
        stringArray[29] = "getTarget";
        stringArray[30] = "updateStatus";
        stringArray[31] = "task";
        stringArray[32] = "doRetry";
        stringArray[33] = "task";
        stringArray[34] = "TAG_SCOPE";
        stringArray[35] = "SCOPE_REGIONAL";
        stringArray[36] = "TAG_REGION";
        stringArray[37] = "registry";
        stringArray[38] = "updateStatusAndThrowNotFoundException";
        stringArray[39] = "task";
        stringArray[40] = "instances";
        stringArray[41] = "fetchInstances";
        stringArray[42] = "credentials";
        stringArray[43] = "findAll";
        stringArray[44] = "instance";
        stringArray[45] = "updateStatus";
        stringArray[46] = "task";
        stringArray[47] = "loadBalancerName";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "loadBalancerName";
        stringArray[50] = "updateStatus";
        stringArray[51] = "task";
        stringArray[52] = "instances";
        stringArray[53] = "loadBalancerName";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "instances";
        stringArray[56] = "loadBalancerName";
        stringArray[57] = "getHealthChecks";
        stringArray[58] = "deleteOperationTimeoutSeconds";
        stringArray[59] = "updateStatus";
        stringArray[60] = "task";
        stringArray[61] = "doRetry";
        stringArray[62] = "task";
        stringArray[63] = "TAG_SCOPE";
        stringArray[64] = "SCOPE_REGIONAL";
        stringArray[65] = "TAG_REGION";
        stringArray[66] = "registry";
        stringArray[67] = "waitForRegionalOperation";
        stringArray[68] = "getName";
        stringArray[69] = "task";
        stringArray[70] = "plus";
        stringArray[71] = "updateStatus";
        stringArray[72] = "task";
        stringArray[73] = "doRetry";
        stringArray[74] = "task";
        stringArray[75] = "TAG_SCOPE";
        stringArray[76] = "SCOPE_REGIONAL";
        stringArray[77] = "TAG_REGION";
        stringArray[78] = "registry";
        stringArray[79] = "waitForRegionalOperation";
        stringArray[80] = "getName";
        stringArray[81] = "task";
        stringArray[82] = "plus";
        stringArray[83] = "deleteHealthChecks";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "iterator";
        stringArray[86] = "getLocalName";
        stringArray[87] = "deleteIfNotInUse";
        stringArray[88] = "task";
        stringArray[89] = "TAG_SCOPE";
        stringArray[90] = "SCOPE_GLOBAL";
        stringArray[91] = "add";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "getName";
        stringArray[94] = "iterator";
        stringArray[95] = "waitForGlobalOperation";
        stringArray[96] = "operationName";
        stringArray[97] = "task";
        stringArray[98] = "plus";
        stringArray[99] = "healthCheckName";
        stringArray[100] = "updateStatus";
        stringArray[101] = "task";
        stringArray[102] = "loadBalancerName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[103];
        DeleteGoogleLoadBalancerAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeleteGoogleLoadBalancerAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeleteGoogleLoadBalancerAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class HealthCheckAsyncDeleteOperation
    implements GroovyObject {
        private String healthCheckName;
        private String operationName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public HealthCheckAsyncDeleteOperation() {
            MetaClass metaClass;
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthCheckAsyncDeleteOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = HealthCheckAsyncDeleteOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleLoadBalancerAtomicOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getHealthCheckName() {
            return this.healthCheckName;
        }

        @Generated
        public void setHealthCheckName(String string) {
            this.healthCheckName = string;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public void setOperationName(String string) {
            this.operationName = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(HealthCheckAsyncDeleteOperation.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HealthCheckAsyncDeleteOperation.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

