/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HealthCheckReference;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.Constants;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleLoadBalancerAtomicOperation
extends GoogleAtomicOperation<Map> {
    private static final String BASE_PHASE = "UPSERT_LOAD_BALANCER";
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    private final UpsertGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UpsertGoogleLoadBalancerAtomicOperation() {
        MetaClass metaClass;
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public UpsertGoogleLoadBalancerAtomicOperation(UpsertGoogleLoadBalancerDescription description) {
        UpsertGoogleLoadBalancerDescription upsertGoogleLoadBalancerDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Map operate(List priorOutputs) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, callSiteArray[4].call((Object)new GStringImpl(new Object[]{callSiteArray[5].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Initializing upsert of load balancer ", " "}), (Object)new GStringImpl(new Object[]{callSiteArray[6].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"in ", "..."})));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this.description))) {
            throw (Throwable)callSiteArray[8].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."}));
        }
        Object compute = callSiteArray[10].callGetProperty(callSiteArray[11].callGroovyObjectGetProperty((Object)this.description));
        Object project = callSiteArray[12].callGetProperty(callSiteArray[13].callGroovyObjectGetProperty((Object)this.description));
        Object region = callSiteArray[14].callGroovyObjectGetProperty((Object)this.description);
        Object object = callSiteArray[15].callGroovyObjectGetProperty((Object)this.description);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[16].callGetProperty(Constants.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"ipProtocol");
        Object object3 = callSiteArray[17].callGroovyObjectGetProperty((Object)this.description);
        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[18].callGetProperty(Constants.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"portRange");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callGroovyObjectGetProperty((Object)this.description))) {
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this);
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[1].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _operate_closure1.class, (GroovyObject)this, (String)"checkIntervalSec");
                    Object object3 = callSiteArray[2].callGroovyObjectGetProperty((Object)this);
                    Object object4 = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[3].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, _operate_closure1.class, (GroovyObject)this, (String)"healthyThreshold");
                    Object object5 = callSiteArray[4].callGroovyObjectGetProperty((Object)this);
                    Object object6 = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : callSiteArray[5].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, _operate_closure1.class, (GroovyObject)this, (String)"unhealthyThreshold");
                    Object object7 = callSiteArray[6].callGroovyObjectGetProperty((Object)this);
                    Object object8 = DefaultTypeTransformation.booleanUnbox((Object)object7) ? object7 : callSiteArray[7].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object8, _operate_closure1.class, (GroovyObject)this, (String)"port");
                    Object object9 = callSiteArray[8].callGroovyObjectGetProperty((Object)this);
                    Object object10 = DefaultTypeTransformation.booleanUnbox((Object)object9) ? object9 : callSiteArray[9].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object10, _operate_closure1.class, (GroovyObject)this, (String)"timeoutSec");
                    Object object11 = callSiteArray[10].callGroovyObjectGetProperty((Object)this);
                    Object object12 = DefaultTypeTransformation.booleanUnbox((Object)object11) ? object11 : callSiteArray[11].callGetProperty(Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object12, _operate_closure1.class, (GroovyObject)this, (String)"requestPath");
                    return object12;
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "checkIntervalSec";
                    stringArray[1] = "DEFAULT_CHECK_INTERVAL_SEC";
                    stringArray[2] = "healthyThreshold";
                    stringArray[3] = "DEFAULT_HEALTHY_THRESHOLD";
                    stringArray[4] = "unhealthyThreshold";
                    stringArray[5] = "DEFAULT_UNHEALTHY_THRESHOLD";
                    stringArray[6] = "port";
                    stringArray[7] = "DEFAULT_PORT";
                    stringArray[8] = "timeoutSec";
                    stringArray[9] = "DEFAULT_TIMEOUT_SEC";
                    stringArray[10] = "requestPath";
                    stringArray[11] = "DEFAULT_REQUEST_PATH";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[12];
                    _operate_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this.description), (Object)new _operate_closure1(this, this));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)this.description))) {
            Object object5 = callSiteArray[23].call(GCEUtil.class, ArrayUtil.createArray((Object)project, (Object)region, (Object)callSiteArray[24].callGroovyObjectGetProperty((Object)this.description), (Object)compute, (Object)callSiteArray[25].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)this));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"instances");
        }
        ForwardingRule existingForwardingRule = null;
        TargetPool existingTargetPool = null;
        HttpHealthCheck existingHttpHealthCheck = null;
        boolean needToUpdateForwardingRule = false;
        boolean needToUpdateTargetPool = false;
        boolean needToUpdateHttpHealthCheck = false;
        boolean needToDeleteHttpHealthCheck = false;
        boolean needToCreateNewForwardingRule = false;
        boolean needToCreateNewTargetPool = false;
        boolean needToCreateNewHttpHealthCheck = false;
        Object object6 = callSiteArray[26].call(GCEUtil.class, ArrayUtil.createArray((Object)project, (Object)callSiteArray[27].callGroovyObjectGetProperty((Object)this.description), (Object)compute, (Object)callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)this));
        existingForwardingRule = (ForwardingRule)ScriptBytecodeAdapter.castToType((Object)object6, ForwardingRule.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)existingForwardingRule)) {
            boolean bl;
            boolean bl2;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[29].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[30].call(GCEUtil.class, callSiteArray[31].callGetProperty((Object)existingForwardingRule)))) {
                throw (Throwable)callSiteArray[32].callConstructor(GoogleOperationException.class, callSiteArray[33].call(callSiteArray[34].call((Object)"There is already a network load balancer named ", (Object)new GStringImpl(new Object[]{callSiteArray[35].callGroovyObjectGetProperty((Object)this.description), callSiteArray[36].call(GCEUtil.class, callSiteArray[37].callGetProperty((Object)existingForwardingRule))}, new String[]{"", " (in region ", "). "})), (Object)"Please specify a different name."));
            }
            needToUpdateForwardingRule = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (bl2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].callGroovyObjectGetProperty((Object)this.description)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[39].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[40].callGetProperty((Object)existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[41].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[42].callGetProperty((Object)existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[43].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[44].callGetProperty((Object)existingForwardingRule))) : (bl = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].callGroovyObjectGetProperty((Object)this.description)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[46].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[47].callGetProperty((Object)existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[48].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[49].callGetProperty((Object)existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[51].callGetProperty((Object)existingForwardingRule)));
            Object object7 = callSiteArray[52].call(GCEUtil.class, ArrayUtil.createArray((Object)project, (Object)region, (Object)callSiteArray[53].call(GCEUtil.class, callSiteArray[54].callGetProperty((Object)existingForwardingRule)), (Object)compute, (Object)callSiteArray[55].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)this));
            existingTargetPool = (TargetPool)ScriptBytecodeAdapter.castToType((Object)object7, TargetPool.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)existingTargetPool)) {
                boolean bl3;
                boolean bl4;
                GoogleSessionAffinity newSessionAffinity = (GoogleSessionAffinity)ShortTypeHandling.castToEnum((Object)callSiteArray[56].call(callSiteArray[57].call(Optional.class, callSiteArray[58].callGroovyObjectGetProperty((Object)this.description)), callSiteArray[59].callGetProperty(GoogleSessionAffinity.class)), GoogleSessionAffinity.class);
                int sessionAffinityChanged = 0;
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    boolean bl5 = ScriptBytecodeAdapter.compareNotEqual((Object)((Object)newSessionAffinity), (Object)callSiteArray[60].call(GoogleSessionAffinity.class, callSiteArray[61].call((Object)existingTargetPool)));
                    sessionAffinityChanged = bl5 ? 1 : 0;
                } else {
                    boolean bl6 = ScriptBytecodeAdapter.compareNotEqual((Object)((Object)newSessionAffinity), (Object)callSiteArray[62].call(GoogleSessionAffinity.class, callSiteArray[63].call((Object)existingTargetPool)));
                    sessionAffinityChanged = bl6 ? 1 : 0;
                }
                if (sessionAffinityChanged != 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(callSiteArray[65].callGetProperty((Object)existingTargetPool)))) {
                    callSiteArray[66].call(callSiteArray[67].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Impossible to change Session Affinity for target pool with existing instances.");
                    callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty((Object)this));
                    return (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
                }
                needToUpdateTargetPool = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (bl4 = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[70].callGroovyObjectGetProperty((Object)this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].callGroovyObjectGetProperty((Object)this.description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].callGetProperty((Object)existingTargetPool)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGroovyObjectGetProperty((Object)this.description)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].callGetProperty((Object)existingTargetPool))) : (bl3 = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[75].callGroovyObjectGetProperty((Object)this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].callGroovyObjectGetProperty((Object)this.description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].callGetProperty((Object)existingTargetPool)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGroovyObjectGetProperty((Object)this.description)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].callGetProperty((Object)existingTargetPool)));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callGetProperty((Object)existingTargetPool))) {
                    Object object8 = callSiteArray[81].call(GCEUtil.class, ArrayUtil.createArray((Object)project, (Object)callSiteArray[82].call(GCEUtil.class, callSiteArray[83].call(callSiteArray[84].callGetProperty((Object)existingTargetPool), (Object)0)), (Object)compute, (Object)callSiteArray[85].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)this));
                    existingHttpHealthCheck = (HttpHealthCheck)ScriptBytecodeAdapter.castToType((Object)object8, HttpHealthCheck.class);
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].callGroovyObjectGetProperty((Object)this.description))) {
                            boolean bl7;
                            needToUpdateHttpHealthCheck = bl7 = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[87].callGetProperty(callSiteArray[88].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[89].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[90].callGetProperty(callSiteArray[91].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[92].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[93].callGetProperty(callSiteArray[94].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[95].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[96].callGetProperty(callSiteArray[97].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[98].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[99].callGetProperty(callSiteArray[100].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[101].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[102].callGetProperty(callSiteArray[103].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[104].callGetProperty((Object)existingHttpHealthCheck));
                        } else {
                            boolean bl8;
                            needToDeleteHttpHealthCheck = bl8 = true;
                        }
                    } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[105].callGroovyObjectGetProperty((Object)this.description))) {
                        boolean bl9;
                        needToUpdateHttpHealthCheck = bl9 = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[106].callGetProperty(callSiteArray[107].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[108].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[109].callGetProperty(callSiteArray[110].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[111].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[112].callGetProperty(callSiteArray[113].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[114].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[115].callGetProperty(callSiteArray[116].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[117].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[118].callGetProperty(callSiteArray[119].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[120].callGetProperty((Object)existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[121].callGetProperty(callSiteArray[122].callGroovyObjectGetProperty((Object)this.description)), (Object)callSiteArray[123].callGetProperty((Object)existingHttpHealthCheck));
                    } else {
                        boolean bl10;
                        needToDeleteHttpHealthCheck = bl10 = true;
                    }
                } else {
                    Object object9 = callSiteArray[124].callGroovyObjectGetProperty((Object)this.description);
                    needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)object9);
                }
            } else {
                boolean bl11;
                callSiteArray[125].call(callSiteArray[126].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[127].call(GCEUtil.class, callSiteArray[128].callGetProperty((Object)existingForwardingRule))}, new String[]{"Unable to retrieve referenced target pool ", "."}));
                needToCreateNewTargetPool = bl11 = true;
                Object object10 = callSiteArray[129].callGroovyObjectGetProperty((Object)this.description);
                needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)object10);
            }
        } else {
            boolean bl;
            boolean bl12;
            needToCreateNewForwardingRule = bl12 = true;
            needToCreateNewTargetPool = bl = true;
            Object object11 = callSiteArray[130].callGroovyObjectGetProperty((Object)this.description);
            needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)object11);
        }
        List httpHealthChecksResourceLinks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (needToUpdateHttpHealthCheck) {
            callSiteArray[131].callCurrent((GroovyObject)this, existingHttpHealthCheck, compute, project);
        } else if (needToCreateNewHttpHealthCheck) {
            callSiteArray[132].callCurrent((GroovyObject)this, (Object)httpHealthChecksResourceLinks, compute, project);
        }
        Object targetPoolName = null;
        Object targetPoolResourceOperation = null;
        Object targetPoolResourceLink = null;
        if (needToUpdateTargetPool) {
            Object object12;
            targetPoolName = object12 = callSiteArray[133].callGetProperty(existingTargetPool);
            callSiteArray[134].call(callSiteArray[135].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetPoolName, region}, new String[]{"Updating target pool ", " in ", "..."}));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[136].callGroovyObjectGetProperty((Object)this.description), null)) {
                Object instancesToAdd = callSiteArray[137].call((Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[138].callGroovyObjectGetProperty((Object)this.description), Set.class)), (Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[139].callGetProperty((Object)existingTargetPool), Set.class)));
                List instancesToRemove = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].callGetProperty((Object)existingTargetPool)) ? callSiteArray[141].call((Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[142].callGetProperty((Object)existingTargetPool), Set.class)), (Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[143].callGroovyObjectGetProperty((Object)this.description), Set.class))) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                callSiteArray[144].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetPoolName, (Object)instancesToAdd, (Object)region, (Object)compute, (Object)project));
                callSiteArray[145].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetPoolName, (Object)instancesToRemove, (Object)region, (Object)compute, (Object)project));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].callGroovyObjectGetProperty((Object)this.description)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[147].callGetProperty((Object)existingTargetPool))) {
                Object object13;
                Object object14;
                targetPoolResourceOperation = object14 = callSiteArray[148].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetPoolName, (Object)targetPoolResourceOperation, (Object)existingTargetPool, existingHttpHealthCheck, (Object)region, (Object)compute, (Object)project));
                targetPoolResourceLink = object13 = callSiteArray[149].callGetProperty(targetPoolResourceOperation);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callGroovyObjectGetProperty((Object)this.description)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[151].callGetProperty((Object)existingTargetPool))) {
                Object object15;
                Object object16;
                targetPoolResourceOperation = object16 = callSiteArray[152].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetPoolName, (Object)targetPoolResourceOperation, (Object)httpHealthChecksResourceLinks, (Object)region, (Object)compute, (Object)project));
                targetPoolResourceLink = object15 = callSiteArray[153].callGetProperty(targetPoolResourceOperation);
            }
        } else if (needToCreateNewTargetPool) {
            Object object17;
            Object object18 = callSiteArray[154].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)targetPoolName, targetPoolResourceOperation, (Object)httpHealthChecksResourceLinks, (Object)region, (Object)compute, (Object)project));
            targetPoolResourceOperation = callSiteArray[155].call(object18, (Object)0);
            targetPoolName = callSiteArray[156].call(object18, (Object)1);
            targetPoolResourceLink = object17 = callSiteArray[157].callGetProperty(targetPoolResourceOperation);
        } else {
            Object object19;
            Object object20;
            targetPoolName = object20 = callSiteArray[158].callGetProperty(existingTargetPool);
            targetPoolResourceLink = object19 = callSiteArray[159].callGetProperty(existingTargetPool);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)targetPoolResourceOperation)) {
            callSiteArray[160].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute, (Object)project, (Object)region, (Object)callSiteArray[161].call(targetPoolResourceOperation), null, (Object)callSiteArray[162].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[163].call((Object)"target pool ", callSiteArray[164].call(GCEUtil.class, targetPoolResourceLink)), (Object)BASE_PHASE));
            callSiteArray[165].callCurrent((GroovyObject)this, existingHttpHealthCheck, (Object)needToDeleteHttpHealthCheck, compute, project);
        }
        callSiteArray[166].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)needToUpdateForwardingRule, (Object)targetPoolName, (Object)targetPoolResourceLink, (Object)region, (Object)compute, (Object)project));
        callSiteArray[167].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)needToCreateNewForwardingRule, (Object)targetPoolName, (Object)targetPoolResourceLink, (Object)region, (Object)compute, (Object)project));
        callSiteArray[168].call(callSiteArray[169].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[170].callGroovyObjectGetProperty((Object)this.description), region}, new String[]{"Done upserting load balancer ", " in ", "."}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{region, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[171].callGroovyObjectGetProperty((Object)this.description)})})});
    }

    private void updateHttpHealthCheck(HttpHealthCheck existingHttpHealthCheck, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object healthCheckName = callSiteArray[172].callGetProperty((Object)existingHttpHealthCheck);
        callSiteArray[173].call(callSiteArray[174].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Updating health check ", "..."}));
        Object httpHealthCheck = callSiteArray[175].call(GCEUtil.class, healthCheckName, callSiteArray[176].callGroovyObjectGetProperty((Object)this.description));
        callSiteArray[177].callCurrent((GroovyObject)this, callSiteArray[178].call(callSiteArray[179].call((Object)compute), (Object)project, healthCheckName, httpHealthCheck), (Object)"compute.httpHealthChecks.update", callSiteArray[180].callGroovyObjectGetProperty((Object)this), callSiteArray[181].callGroovyObjectGetProperty((Object)this));
    }

    private void createNewHttpHealthCheck(List<String> httpHealthChecksResourceLinks, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object healthCheckName = callSiteArray[182].call(String.class, (Object)"%s-%s-%d", callSiteArray[183].callGroovyObjectGetProperty((Object)this.description), callSiteArray[184].callGetProperty(Constants.class), callSiteArray[185].call(System.class));
        callSiteArray[186].call(callSiteArray[187].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Creating health check ", "..."}));
        Object httpHealthCheck = callSiteArray[188].call(GCEUtil.class, healthCheckName, callSiteArray[189].callGroovyObjectGetProperty((Object)this.description));
        Object httpHealthCheckResourceOperation = callSiteArray[190].callCurrent((GroovyObject)this, callSiteArray[191].call(callSiteArray[192].call((Object)compute), (Object)project, httpHealthCheck), (Object)"compute.httpHealthChecks.insert", callSiteArray[193].callGroovyObjectGetProperty((Object)this), callSiteArray[194].callGroovyObjectGetProperty((Object)this));
        Object httpHealthCheckResourceLink = callSiteArray[195].callGetProperty(httpHealthCheckResourceOperation);
        callSiteArray[196].call(httpHealthChecksResourceLinks, httpHealthCheckResourceLink);
        callSiteArray[197].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute, (Object)project, (Object)callSiteArray[198].call(httpHealthCheckResourceOperation), null, (Object)callSiteArray[199].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[200].call((Object)"health check ", callSiteArray[201].call(GCEUtil.class, httpHealthCheckResourceLink)), (Object)BASE_PHASE));
    }

    private void addInstancesToTargetPoolIfNecessary(String targetPoolName, Set<String> instancesToAdd, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox(instancesToAdd)) {
            public final class _addInstancesToTargetPoolIfNecessary_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addInstancesToTargetPoolIfNecessary_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _addInstancesToTargetPoolIfNecessary_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    CallSite[] callSiteArray = _addInstancesToTargetPoolIfNecessary_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(GCEUtil.class, instanceUrl);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInstancesToTargetPoolIfNecessary_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getLocalName";
                    return new CallSiteArray(_addInstancesToTargetPoolIfNecessary_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addInstancesToTargetPoolIfNecessary_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object instanceLocalNamesToAdd = callSiteArray[202].call(instancesToAdd, (Object)new _addInstancesToTargetPoolIfNecessary_closure2(this, this));
            callSiteArray[203].call(callSiteArray[204].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{instanceLocalNamesToAdd}, new String[]{"Adding instances ", "..."}));
            Object targetPoolsAddInstanceRequest = callSiteArray[205].callConstructor(TargetPoolsAddInstanceRequest.class);
            public final class _addInstancesToTargetPoolIfNecessary_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addInstancesToTargetPoolIfNecessary_closure3(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _addInstancesToTargetPoolIfNecessary_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    CallSite[] callSiteArray = _addInstancesToTargetPoolIfNecessary_closure3.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(InstanceReference.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", instanceUrl}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInstancesToTargetPoolIfNecessary_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "<$constructor$>";
                    return new CallSiteArray(_addInstancesToTargetPoolIfNecessary_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addInstancesToTargetPoolIfNecessary_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[206].call(instancesToAdd, (Object)new _addInstancesToTargetPoolIfNecessary_closure3(this, this));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)targetPoolsAddInstanceRequest, (String)"instances");
            callSiteArray[207].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[208].call(callSiteArray[209].call((Object)compute), (Object)project, (Object)region, (Object)targetPoolName, targetPoolsAddInstanceRequest), (Object)"compute.targetPools.addInstance", (Object)callSiteArray[210].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[211].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[212].callGroovyObjectGetProperty((Object)this), (Object)region));
        }
    }

    private void removeInstancesFromTargetPoolIfNecessary(String targetPoolName, Collection instancesToRemove, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)instancesToRemove)) {
            public final class _removeInstancesFromTargetPoolIfNecessary_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _removeInstancesFromTargetPoolIfNecessary_closure4(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    CallSite[] callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure4.$getCallSiteArray();
                    return callSiteArray[0].call(GCEUtil.class, instanceUrl);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _removeInstancesFromTargetPoolIfNecessary_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getLocalName";
                    return new CallSiteArray(_removeInstancesFromTargetPoolIfNecessary_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object instanceLocalNamesToRemove = callSiteArray[213].call((Object)instancesToRemove, (Object)new _removeInstancesFromTargetPoolIfNecessary_closure4(this, this));
            callSiteArray[214].call(callSiteArray[215].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{instanceLocalNamesToRemove}, new String[]{"Removing instances ", "..."}));
            Object targetPoolsRemoveInstanceRequest = callSiteArray[216].callConstructor(TargetPoolsRemoveInstanceRequest.class);
            public final class _removeInstancesFromTargetPoolIfNecessary_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _removeInstancesFromTargetPoolIfNecessary_closure5(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    CallSite[] callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure5.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(InstanceReference.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", instanceUrl}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _removeInstancesFromTargetPoolIfNecessary_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "<$constructor$>";
                    return new CallSiteArray(_removeInstancesFromTargetPoolIfNecessary_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _removeInstancesFromTargetPoolIfNecessary_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[217].call((Object)instancesToRemove, (Object)new _removeInstancesFromTargetPoolIfNecessary_closure5(this, this));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)targetPoolsRemoveInstanceRequest, (String)"instances");
            callSiteArray[218].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[219].call(callSiteArray[220].call((Object)compute), (Object)project, (Object)region, (Object)targetPoolName, targetPoolsRemoveInstanceRequest), (Object)"compute.targetPools.removeInstance", (Object)callSiteArray[221].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[222].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[223].callGroovyObjectGetProperty((Object)this), (Object)region));
        }
    }

    private Operation removeHttpHealthCheckFromTargetPool(String targetPoolName, Operation targetPoolResourceOperation, TargetPool existingTargetPool, HttpHealthCheck existingHttpHealthCheck, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[224].call(callSiteArray[225].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[226].callGetProperty((Object)existingHttpHealthCheck)}, new String[]{"Removing health check ", "..."}));
        Object targetPoolsRemoveHealthCheckRequest = callSiteArray[227].callConstructor(TargetPoolsRemoveHealthCheckRequest.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[228].callConstructor(HealthCheckReference.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", callSiteArray[229].call(callSiteArray[230].callGetProperty((Object)existingTargetPool), (Object)0)}))});
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)targetPoolsRemoveHealthCheckRequest, (String)"healthChecks");
        Object object = callSiteArray[231].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[232].call(callSiteArray[233].call((Object)compute), (Object)project, (Object)region, (Object)targetPoolName, targetPoolsRemoveHealthCheckRequest), (Object)"compute.targetPools.removeHealthCheck", (Object)callSiteArray[234].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[235].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[236].callGroovyObjectGetProperty((Object)this), (Object)region));
        targetPoolResourceOperation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
        return targetPoolResourceOperation;
    }

    private Operation addHttpHealthCheckToTargetPool(String targetPoolName, Operation targetPoolResourceOperation, List<String> httpHealthChecksResourceLinks, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[237].call(callSiteArray[238].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[239].call(GCEUtil.class, callSiteArray[240].call(httpHealthChecksResourceLinks, (Object)0))}, new String[]{"Adding health check ", "..."}));
        Object targetPoolsAddHealthCheckRequest = callSiteArray[241].callConstructor(TargetPoolsAddHealthCheckRequest.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[242].callConstructor(HealthCheckReference.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", callSiteArray[243].call(httpHealthChecksResourceLinks, (Object)0)}))});
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)targetPoolsAddHealthCheckRequest, (String)"healthChecks");
        Object object = callSiteArray[244].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[245].call(callSiteArray[246].call((Object)compute), (Object)project, (Object)region, (Object)targetPoolName, targetPoolsAddHealthCheckRequest), (Object)"compute.targetPools.addHealthCheck", (Object)callSiteArray[247].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[248].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[249].callGroovyObjectGetProperty((Object)this), (Object)region));
        targetPoolResourceOperation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
        return targetPoolResourceOperation;
    }

    private List createNewTargetPool(String targetPoolName, Operation targetPoolResourceOperation, List<String> httpHealthChecksResourceLinks, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = callSiteArray[250].call(String.class, (Object)"%s-%s-%d", callSiteArray[251].callGroovyObjectGetProperty((Object)this.description), callSiteArray[252].callGetProperty(GCEUtil.class), callSiteArray[253].call(System.class));
        targetPoolName = ShortTypeHandling.castToString((Object)object);
        callSiteArray[254].call(callSiteArray[255].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetPoolName, region}, new String[]{"Creating target pool ", " in ", "..."}));
        Object targetPool = callSiteArray[256].callConstructor(TargetPool.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetPoolName, "healthChecks", httpHealthChecksResourceLinks, "instances", callSiteArray[257].callGroovyObjectGetProperty((Object)this.description), "sessionAffinity", callSiteArray[258].callGroovyObjectGetProperty((Object)this.description)}));
        Object object2 = callSiteArray[259].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[260].call(callSiteArray[261].call((Object)compute), (Object)project, (Object)region, targetPool), (Object)"compute.tagetPools.insert", (Object)callSiteArray[262].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[263].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[264].callGroovyObjectGetProperty((Object)this), (Object)region));
        targetPoolResourceOperation = (Operation)ScriptBytecodeAdapter.castToType((Object)object2, Operation.class);
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{targetPoolResourceOperation, targetPoolName});
    }

    private void deleteHttpHealthCheckIfNecessary(HttpHealthCheck existingHttpHealthCheck, boolean needToDeleteHttpHealthCheck, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        if (needToDeleteHttpHealthCheck) {
            Object healthCheckName = callSiteArray[265].callGetProperty((Object)existingHttpHealthCheck);
            callSiteArray[266].call(callSiteArray[267].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{healthCheckName}, new String[]{"Deleting health check ", "..."}));
            callSiteArray[268].callCurrent((GroovyObject)this, callSiteArray[269].call(callSiteArray[270].call((Object)compute), (Object)project, healthCheckName), (Object)"compute.httpHealthChecks.delete", callSiteArray[271].callGroovyObjectGetProperty((Object)this), callSiteArray[272].callGroovyObjectGetProperty((Object)this));
        }
    }

    private void updateForwardingRuleIfNecessary(boolean needToUpdateForwardingRule, String targetPoolName, String targetPoolResourceLink, String region, Compute compute, String project) {
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        if (needToUpdateForwardingRule) {
            callSiteArray[273].call(callSiteArray[274].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[275].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Deleting forwarding rule ", "..."}));
            Object forwardingRuleResourceOperation = callSiteArray[276].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[277].call(callSiteArray[278].call((Object)compute), (Object)project, (Object)region, callSiteArray[279].callGroovyObjectGetProperty((Object)this.description)), (Object)"compute.forwardingRules.delete", (Object)callSiteArray[280].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[281].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[282].callGroovyObjectGetProperty((Object)this), (Object)region));
            Object forwardingRuleResourceLink = callSiteArray[283].callGetProperty(forwardingRuleResourceOperation);
            callSiteArray[284].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute, (Object)project, (Object)region, (Object)callSiteArray[285].call(forwardingRuleResourceOperation), null, (Object)callSiteArray[286].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[287].call((Object)"forwarding rule ", callSiteArray[288].call(GCEUtil.class, forwardingRuleResourceLink)), (Object)BASE_PHASE));
            callSiteArray[289].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)true, (Object)targetPoolName, (Object)targetPoolResourceLink, (Object)region, (Object)compute, (Object)project));
        }
    }

    private void createNewForwardingRuleIfNecessary(boolean needToCreateNewForwardingRule, String targetPoolName, String targetPoolResourceLink, String region, Compute compute, String project) {
        Reference region2 = new Reference((Object)region);
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$getCallSiteArray();
        if (needToCreateNewForwardingRule) {
            callSiteArray[290].call(callSiteArray[291].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, callSiteArray[292].call((Object)new GStringImpl(new Object[]{callSiteArray[293].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Creating forwarding rule ", " to "}), (Object)new GStringImpl(new Object[]{targetPoolName, (String)region2.get()}, new String[]{"", " in ", "..."})));
            Reference forwardingRule = new Reference(callSiteArray[294].callConstructor(ForwardingRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[295].callGroovyObjectGetProperty((Object)this.description), "target", targetPoolResourceLink, "IPProtocol", callSiteArray[296].callGroovyObjectGetProperty((Object)this.description), "IPAddress", callSiteArray[297].callGroovyObjectGetProperty((Object)this.description), "portRange", callSiteArray[298].callGroovyObjectGetProperty((Object)this.description)})));
            public final class _createNewForwardingRuleIfNecessary_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference forwardingRule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _createNewForwardingRuleIfNecessary_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference forwardingRule) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.forwardingRule = reference = forwardingRule;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.region.get(), this.forwardingRule.get()), (Object)"compute.forwardingRules.insert", (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)this.region.get()));
                }

                @Generated
                public Compute getCompute() {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
                }

                @Generated
                public String getProject() {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.project.get());
                }

                @Generated
                public String getRegion() {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getForwardingRule() {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return this.forwardingRule.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createNewForwardingRuleIfNecessary_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "insert";
                    stringArray[2] = "forwardingRules";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_REGIONAL";
                    stringArray[5] = "TAG_REGION";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _createNewForwardingRuleIfNecessary_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createNewForwardingRuleIfNecessary_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createNewForwardingRuleIfNecessary_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Operation forwardingRuleOperation = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[299].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _createNewForwardingRuleIfNecessary_closure6(this, this, compute2, project2, region2, forwardingRule)), (Object)new GStringImpl(new Object[]{callSiteArray[300].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Regional forwarding rule ", ""}), (Object)callSiteArray[301].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "insert", "phase", BASE_PHASE, "operation", "compute.forwardingRules.insert", callSiteArray[302].callGroovyObjectGetProperty((Object)this), callSiteArray[303].callGroovyObjectGetProperty((Object)this)}), (Object)callSiteArray[304].callGroovyObjectGetProperty((Object)this))), Operation.class);
            callSiteArray[305].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)((Compute)compute2.get()), (Object)((String)project2.get()), (Object)((String)region2.get()), (Object)callSiteArray[306].call((Object)forwardingRuleOperation), null, (Object)callSiteArray[307].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[308].call((Object)"forwarding rule ", callSiteArray[309].call(GCEUtil.class, (Object)targetPoolResourceLink)), (Object)BASE_PHASE));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "updateStatus";
        stringArray[3] = "task";
        stringArray[4] = "plus";
        stringArray[5] = "loadBalancerName";
        stringArray[6] = "region";
        stringArray[7] = "credentials";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "accountName";
        stringArray[10] = "compute";
        stringArray[11] = "credentials";
        stringArray[12] = "project";
        stringArray[13] = "credentials";
        stringArray[14] = "region";
        stringArray[15] = "ipProtocol";
        stringArray[16] = "DEFAULT_IP_PROTOCOL";
        stringArray[17] = "portRange";
        stringArray[18] = "DEFAULT_PORT_RANGE";
        stringArray[19] = "healthCheck";
        stringArray[20] = "with";
        stringArray[21] = "healthCheck";
        stringArray[22] = "instances";
        stringArray[23] = "queryInstanceUrls";
        stringArray[24] = "instances";
        stringArray[25] = "task";
        stringArray[26] = "queryRegionalForwardingRule";
        stringArray[27] = "loadBalancerName";
        stringArray[28] = "task";
        stringArray[29] = "region";
        stringArray[30] = "getLocalName";
        stringArray[31] = "region";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "loadBalancerName";
        stringArray[36] = "getLocalName";
        stringArray[37] = "region";
        stringArray[38] = "ipAddress";
        stringArray[39] = "ipAddress";
        stringArray[40] = "IPAddress";
        stringArray[41] = "ipProtocol";
        stringArray[42] = "IPProtocol";
        stringArray[43] = "portRange";
        stringArray[44] = "portRange";
        stringArray[45] = "ipAddress";
        stringArray[46] = "ipAddress";
        stringArray[47] = "IPAddress";
        stringArray[48] = "ipProtocol";
        stringArray[49] = "IPProtocol";
        stringArray[50] = "portRange";
        stringArray[51] = "portRange";
        stringArray[52] = "queryTargetPool";
        stringArray[53] = "getLocalName";
        stringArray[54] = "target";
        stringArray[55] = "task";
        stringArray[56] = "orElse";
        stringArray[57] = "ofNullable";
        stringArray[58] = "sessionAffinity";
        stringArray[59] = "NONE";
        stringArray[60] = "valueOf";
        stringArray[61] = "getSessionAffinity";
        stringArray[62] = "valueOf";
        stringArray[63] = "getSessionAffinity";
        stringArray[64] = "any";
        stringArray[65] = "instances";
        stringArray[66] = "updateStatus";
        stringArray[67] = "task";
        stringArray[68] = "fail";
        stringArray[69] = "task";
        stringArray[70] = "instances";
        stringArray[71] = "healthCheck";
        stringArray[72] = "healthChecks";
        stringArray[73] = "healthCheck";
        stringArray[74] = "healthChecks";
        stringArray[75] = "instances";
        stringArray[76] = "healthCheck";
        stringArray[77] = "healthChecks";
        stringArray[78] = "healthCheck";
        stringArray[79] = "healthChecks";
        stringArray[80] = "healthChecks";
        stringArray[81] = "queryHttpHealthCheck";
        stringArray[82] = "getLocalName";
        stringArray[83] = "getAt";
        stringArray[84] = "healthChecks";
        stringArray[85] = "task";
        stringArray[86] = "healthCheck";
        stringArray[87] = "checkIntervalSec";
        stringArray[88] = "healthCheck";
        stringArray[89] = "checkIntervalSec";
        stringArray[90] = "healthyThreshold";
        stringArray[91] = "healthCheck";
        stringArray[92] = "healthyThreshold";
        stringArray[93] = "unhealthyThreshold";
        stringArray[94] = "healthCheck";
        stringArray[95] = "unhealthyThreshold";
        stringArray[96] = "port";
        stringArray[97] = "healthCheck";
        stringArray[98] = "port";
        stringArray[99] = "timeoutSec";
        stringArray[100] = "healthCheck";
        stringArray[101] = "timeoutSec";
        stringArray[102] = "requestPath";
        stringArray[103] = "healthCheck";
        stringArray[104] = "requestPath";
        stringArray[105] = "healthCheck";
        stringArray[106] = "checkIntervalSec";
        stringArray[107] = "healthCheck";
        stringArray[108] = "checkIntervalSec";
        stringArray[109] = "healthyThreshold";
        stringArray[110] = "healthCheck";
        stringArray[111] = "healthyThreshold";
        stringArray[112] = "unhealthyThreshold";
        stringArray[113] = "healthCheck";
        stringArray[114] = "unhealthyThreshold";
        stringArray[115] = "port";
        stringArray[116] = "healthCheck";
        stringArray[117] = "port";
        stringArray[118] = "timeoutSec";
        stringArray[119] = "healthCheck";
        stringArray[120] = "timeoutSec";
        stringArray[121] = "requestPath";
        stringArray[122] = "healthCheck";
        stringArray[123] = "requestPath";
        stringArray[124] = "healthCheck";
        stringArray[125] = "updateStatus";
        stringArray[126] = "task";
        stringArray[127] = "getLocalName";
        stringArray[128] = "target";
        stringArray[129] = "healthCheck";
        stringArray[130] = "healthCheck";
        stringArray[131] = "updateHttpHealthCheck";
        stringArray[132] = "createNewHttpHealthCheck";
        stringArray[133] = "name";
        stringArray[134] = "updateStatus";
        stringArray[135] = "task";
        stringArray[136] = "instances";
        stringArray[137] = "minus";
        stringArray[138] = "instances";
        stringArray[139] = "instances";
        stringArray[140] = "instances";
        stringArray[141] = "minus";
        stringArray[142] = "instances";
        stringArray[143] = "instances";
        stringArray[144] = "addInstancesToTargetPoolIfNecessary";
        stringArray[145] = "removeInstancesFromTargetPoolIfNecessary";
        stringArray[146] = "healthCheck";
        stringArray[147] = "healthChecks";
        stringArray[148] = "removeHttpHealthCheckFromTargetPool";
        stringArray[149] = "targetLink";
        stringArray[150] = "healthCheck";
        stringArray[151] = "healthChecks";
        stringArray[152] = "addHttpHealthCheckToTargetPool";
        stringArray[153] = "targetLink";
        stringArray[154] = "createNewTargetPool";
        stringArray[155] = "getAt";
        stringArray[156] = "getAt";
        stringArray[157] = "targetLink";
        stringArray[158] = "name";
        stringArray[159] = "selfLink";
        stringArray[160] = "waitForRegionalOperation";
        stringArray[161] = "getName";
        stringArray[162] = "task";
        stringArray[163] = "plus";
        stringArray[164] = "getLocalName";
        stringArray[165] = "deleteHttpHealthCheckIfNecessary";
        stringArray[166] = "updateForwardingRuleIfNecessary";
        stringArray[167] = "createNewForwardingRuleIfNecessary";
        stringArray[168] = "updateStatus";
        stringArray[169] = "task";
        stringArray[170] = "loadBalancerName";
        stringArray[171] = "loadBalancerName";
        stringArray[172] = "name";
        stringArray[173] = "updateStatus";
        stringArray[174] = "task";
        stringArray[175] = "buildHttpHealthCheck";
        stringArray[176] = "healthCheck";
        stringArray[177] = "timeExecute";
        stringArray[178] = "update";
        stringArray[179] = "httpHealthChecks";
        stringArray[180] = "TAG_SCOPE";
        stringArray[181] = "SCOPE_GLOBAL";
        stringArray[182] = "format";
        stringArray[183] = "loadBalancerName";
        stringArray[184] = "HEALTH_CHECK_NAME_PREFIX";
        stringArray[185] = "currentTimeMillis";
        stringArray[186] = "updateStatus";
        stringArray[187] = "task";
        stringArray[188] = "buildHttpHealthCheck";
        stringArray[189] = "healthCheck";
        stringArray[190] = "timeExecute";
        stringArray[191] = "insert";
        stringArray[192] = "httpHealthChecks";
        stringArray[193] = "TAG_SCOPE";
        stringArray[194] = "SCOPE_GLOBAL";
        stringArray[195] = "targetLink";
        stringArray[196] = "leftShift";
        stringArray[197] = "waitForGlobalOperation";
        stringArray[198] = "getName";
        stringArray[199] = "task";
        stringArray[200] = "plus";
        stringArray[201] = "getLocalName";
        stringArray[202] = "collect";
        stringArray[203] = "updateStatus";
        stringArray[204] = "task";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "collect";
        stringArray[207] = "timeExecute";
        stringArray[208] = "addInstance";
        stringArray[209] = "targetPools";
        stringArray[210] = "TAG_SCOPE";
        stringArray[211] = "SCOPE_REGIONAL";
        stringArray[212] = "TAG_REGION";
        stringArray[213] = "collect";
        stringArray[214] = "updateStatus";
        stringArray[215] = "task";
        stringArray[216] = "<$constructor$>";
        stringArray[217] = "collect";
        stringArray[218] = "timeExecute";
        stringArray[219] = "removeInstance";
        stringArray[220] = "targetPools";
        stringArray[221] = "TAG_SCOPE";
        stringArray[222] = "SCOPE_REGIONAL";
        stringArray[223] = "TAG_REGION";
        stringArray[224] = "updateStatus";
        stringArray[225] = "task";
        stringArray[226] = "name";
        stringArray[227] = "<$constructor$>";
        stringArray[228] = "<$constructor$>";
        stringArray[229] = "getAt";
        stringArray[230] = "healthChecks";
        stringArray[231] = "timeExecute";
        stringArray[232] = "removeHealthCheck";
        stringArray[233] = "targetPools";
        stringArray[234] = "TAG_SCOPE";
        stringArray[235] = "SCOPE_REGIONAL";
        stringArray[236] = "TAG_REGION";
        stringArray[237] = "updateStatus";
        stringArray[238] = "task";
        stringArray[239] = "getLocalName";
        stringArray[240] = "getAt";
        stringArray[241] = "<$constructor$>";
        stringArray[242] = "<$constructor$>";
        stringArray[243] = "getAt";
        stringArray[244] = "timeExecute";
        stringArray[245] = "addHealthCheck";
        stringArray[246] = "targetPools";
        stringArray[247] = "TAG_SCOPE";
        stringArray[248] = "SCOPE_REGIONAL";
        stringArray[249] = "TAG_REGION";
        stringArray[250] = "format";
        stringArray[251] = "loadBalancerName";
        stringArray[252] = "TARGET_POOL_NAME_PREFIX";
        stringArray[253] = "currentTimeMillis";
        stringArray[254] = "updateStatus";
        stringArray[255] = "task";
        stringArray[256] = "<$constructor$>";
        stringArray[257] = "instances";
        stringArray[258] = "sessionAffinity";
        stringArray[259] = "timeExecute";
        stringArray[260] = "insert";
        stringArray[261] = "targetPools";
        stringArray[262] = "TAG_SCOPE";
        stringArray[263] = "SCOPE_REGIONAL";
        stringArray[264] = "TAG_REGION";
        stringArray[265] = "name";
        stringArray[266] = "updateStatus";
        stringArray[267] = "task";
        stringArray[268] = "timeExecute";
        stringArray[269] = "delete";
        stringArray[270] = "httpHealthChecks";
        stringArray[271] = "TAG_SCOPE";
        stringArray[272] = "SCOPE_GLOBAL";
        stringArray[273] = "updateStatus";
        stringArray[274] = "task";
        stringArray[275] = "loadBalancerName";
        stringArray[276] = "timeExecute";
        stringArray[277] = "delete";
        stringArray[278] = "forwardingRules";
        stringArray[279] = "loadBalancerName";
        stringArray[280] = "TAG_SCOPE";
        stringArray[281] = "SCOPE_REGIONAL";
        stringArray[282] = "TAG_REGION";
        stringArray[283] = "targetLink";
        stringArray[284] = "waitForRegionalOperation";
        stringArray[285] = "getName";
        stringArray[286] = "task";
        stringArray[287] = "plus";
        stringArray[288] = "getLocalName";
        stringArray[289] = "createNewForwardingRuleIfNecessary";
        stringArray[290] = "updateStatus";
        stringArray[291] = "task";
        stringArray[292] = "plus";
        stringArray[293] = "loadBalancerName";
        stringArray[294] = "<$constructor$>";
        stringArray[295] = "loadBalancerName";
        stringArray[296] = "ipProtocol";
        stringArray[297] = "ipAddress";
        stringArray[298] = "portRange";
        stringArray[299] = "doRetry";
        stringArray[300] = "loadBalancerName";
        stringArray[301] = "task";
        stringArray[302] = "TAG_SCOPE";
        stringArray[303] = "SCOPE_GLOBAL";
        stringArray[304] = "registry";
        stringArray[305] = "waitForRegionalOperation";
        stringArray[306] = "getName";
        stringArray[307] = "task";
        stringArray[308] = "plus";
        stringArray[309] = "getLocalName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[310];
        UpsertGoogleLoadBalancerAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UpsertGoogleLoadBalancerAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UpsertGoogleLoadBalancerAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

