/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.model;

import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.NetworkInterface;
import com.netflix.spinnaker.clouddriver.consul.config.ConsulConfig;
import com.netflix.spinnaker.clouddriver.consul.model.ConsulNode;
import com.netflix.spinnaker.clouddriver.consul.provider.ConsulProviderUtils;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstance;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleInstanceHealth;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.math.BigInteger;
import java.util.Optional;

public final class GoogleInstances {
    public static GoogleInstance createFromComputeInstance(Instance input, GoogleNamedAccountCredentials credentials) {
        String localZone = Utils.getLocalName(input.getZone());
        GoogleInstance output = new GoogleInstance();
        output.setName(input.getName());
        output.setAccount(credentials.getProject());
        output.setGceId(Optional.ofNullable(input.getId()).map(BigInteger::toString).orElse(null));
        output.setInstanceType(Utils.getLocalName(input.getMachineType()));
        output.setCpuPlatform(input.getCpuPlatform());
        output.setLaunchTime(GoogleInstances.calculateInstanceTimestamp(input));
        output.setZone(localZone);
        output.setRegion(credentials.regionFromZone(localZone));
        output.setNetworkInterfaces(input.getNetworkInterfaces());
        output.setNetworkName(GoogleInstances.calculateNetworkName(input, credentials));
        output.setMetadata(input.getMetadata());
        output.setDisks(input.getDisks());
        output.setServiceAccounts(input.getServiceAccounts());
        output.setSelfLink(input.getSelfLink());
        output.setTags(input.getTags());
        output.setLabels(input.getLabels());
        output.setConsulNode(GoogleInstances.calculateConsulNode(input, credentials));
        output.setInstanceHealth(GoogleInstances.createInstanceHealth(input));
        return output;
    }

    private static long calculateInstanceTimestamp(Instance input) {
        return input.getCreationTimestamp() != null ? Utils.getTimeFromTimestamp(input.getCreationTimestamp()) : Long.MAX_VALUE;
    }

    private static String calculateNetworkName(Instance input, GoogleNamedAccountCredentials credentials) {
        return Utils.decorateXpnResourceIdIfNeeded(credentials.getProject(), input.getNetworkInterfaces() != null && !input.getNetworkInterfaces().isEmpty() ? ((NetworkInterface)input.getNetworkInterfaces().get(0)).getNetwork() : null);
    }

    private static ConsulNode calculateConsulNode(Instance input, GoogleNamedAccountCredentials credentials) {
        return credentials.getConsulConfig() != null && credentials.getConsulConfig().isEnabled() ? ConsulProviderUtils.getHealths((ConsulConfig)credentials.getConsulConfig(), (String)input.getName()) : null;
    }

    private static GoogleInstanceHealth createInstanceHealth(Instance input) {
        if (input.getStatus() == null) {
            return null;
        }
        GoogleInstanceHealth health = new GoogleInstanceHealth();
        health.setStatus(GoogleInstanceHealth.Status.valueOf(input.getStatus()));
        return health;
    }
}

