/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.model.callbacks;

import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.UrlMap;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathMatcher;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.MapEntry;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class Utils
implements GroovyObject {
    public static final String TARGET_POOL_NAME_PREFIX = "tp";
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final Splitter onSlash;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public Utils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static long getTimeFromTimestamp(String timestamp) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)timestamp)) {
            return DefaultTypeTransformation.longUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callConstructor(SimpleDateFormat.class, (Object)SIMPLE_DATE_FORMAT), (Object)timestamp)));
        }
        return DefaultTypeTransformation.longUnbox((Object)callSiteArray[3].call(System.class));
    }

    public static String derivePortOrPortRange(String portRange) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)portRange) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)portRange, (Object)"-")) : !DefaultTypeTransformation.booleanUnbox((Object)portRange) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)portRange, (Object)"-"))) {
            return portRange;
        }
        Object tokens = callSiteArray[6].call((Object)portRange, (Object)"-");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[7].callGetProperty(tokens), (Object)2)) {
            throw (Throwable)callSiteArray[8].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{portRange}, new String[]{"Port range ", " formatted improperly."}));
        }
        return ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[9].call(tokens, (Object)0), (Object)callSiteArray[10].call(tokens, (Object)1)) ? portRange : callSiteArray[11].call(tokens, (Object)0)));
    }

    public static String getLocalName(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            return fullUrl;
        }
        int lastIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[12].call((Object)fullUrl, (Object)"/"));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)lastIndex, (Object)-1) ? callSiteArray[13].call((Object)fullUrl, callSiteArray[14].call((Object)lastIndex, (Object)1)) : fullUrl));
        }
        return ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)lastIndex, (Object)-1) ? callSiteArray[15].call((Object)fullUrl, (Object)(lastIndex + 1)) : fullUrl));
    }

    @Nonnull
    public static GoogleTargetProxyType getTargetProxyType(@Nullable String fullUrl) {
        String resourceType = Utils.getResourceType(Strings.nullToEmpty((String)fullUrl));
        return GoogleTargetProxyType.fromResourceType(resourceType);
    }

    @Nonnull
    private static String getResourceType(@Nonnull String uri) {
        return ShortTypeHandling.castToString((Object)Lists.reverse((List)onSlash.splitToList((CharSequence)uri)).stream().skip(1).findFirst().orElse(""));
    }

    public static String getZoneFromInstanceUrl(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        String zones = "zones/";
        return ShortTypeHandling.castToString((Object)callSiteArray[16].call((Object)fullUrl, callSiteArray[17].call(callSiteArray[18].call((Object)fullUrl, (Object)zones), callSiteArray[19].call((Object)zones)), callSiteArray[20].call(callSiteArray[21].call((Object)fullUrl, (Object)"instances/"), (Object)1)));
    }

    public static String getHealthCheckType(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            throw (Throwable)callSiteArray[22].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Health check url ", " malformed."}));
        }
        int lastIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[23].call((Object)fullUrl, (Object)"/"));
        if (ScriptBytecodeAdapter.compareEqual((Object)lastIndex, (Object)-1)) {
            throw (Throwable)callSiteArray[24].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Health check url ", " malformed."}));
        }
        String withoutName = ShortTypeHandling.castToString((Object)callSiteArray[25].call((Object)fullUrl, (Object)0, (Object)lastIndex));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[26].callStatic(Utils.class, (Object)withoutName));
        }
        return Utils.getLocalName(withoutName);
    }

    public static Map<String, String> buildMapFromMetadata(Metadata metadata) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        public final class _buildMapFromMetadata_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildMapFromMetadata_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildMapFromMetadata_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Metadata.Items metadataItems) {
                CallSite[] callSiteArray = _buildMapFromMetadata_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].callGetProperty((Object)metadataItems), callSiteArray[1].callGetProperty((Object)metadataItems)});
            }

            @Generated
            public Object call(Metadata.Items metadataItems) {
                CallSite[] callSiteArray = _buildMapFromMetadata_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)metadataItems);
                }
                return this.doCall(metadataItems);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildMapFromMetadata_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "value";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _buildMapFromMetadata_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildMapFromMetadata_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildMapFromMetadata_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callSafe(callSiteArray[28].callGetProperty((Object)metadata), (Object)new _buildMapFromMetadata_closure1(Utils.class, Utils.class)), Map.class);
    }

    public static String getRegionFromGroupUrl(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            return fullUrl;
        }
        Object urlParts = callSiteArray[29].call((Object)fullUrl, (Object)"/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[30].callGetProperty(urlParts), (Object)4)) {
            throw (Throwable)callSiteArray[31].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."}));
        }
        String regionsOrZones = ShortTypeHandling.castToString((Object)callSiteArray[32].call(urlParts, callSiteArray[33].call(callSiteArray[34].callGetProperty(urlParts), (Object)4)));
        String string = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"regions")) {
            return ShortTypeHandling.castToString((Object)callSiteArray[35].call(urlParts, callSiteArray[36].call(callSiteArray[37].callGetProperty(urlParts), (Object)3)));
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"zones")) {
            Object zone = callSiteArray[38].call(urlParts, callSiteArray[39].call(callSiteArray[40].callGetProperty(urlParts), (Object)3));
            Object lastDash = callSiteArray[41].call(zone, (Object)"-");
            return ShortTypeHandling.castToString((Object)callSiteArray[42].call(zone, (Object)0, lastDash));
        }
        throw (Throwable)callSiteArray[43].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."}));
    }

    public static String getZoneFromGroupUrl(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            return fullUrl;
        }
        Object urlParts = callSiteArray[44].call((Object)fullUrl, (Object)"/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[45].callGetProperty(urlParts), (Object)4)) {
            throw (Throwable)callSiteArray[46].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group url ", " malformed."}));
        }
        String regionsOrZones = ShortTypeHandling.castToString((Object)callSiteArray[47].call(urlParts, callSiteArray[48].call(callSiteArray[49].callGetProperty(urlParts), (Object)4)));
        String string = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"regions")) {
            throw (Throwable)callSiteArray[50].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Can't parse a zone from regional group url ", "."}));
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"zones")) {
            return ShortTypeHandling.castToString((Object)callSiteArray[51].call(urlParts, callSiteArray[52].call(callSiteArray[53].callGetProperty(urlParts), (Object)3)));
        }
        throw (Throwable)callSiteArray[54].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group url ", " malformed."}));
    }

    public static GoogleServerGroup.ServerGroupType determineServerGroupType(String fullUrl) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)fullUrl)) {
            return (GoogleServerGroup.ServerGroupType)ShortTypeHandling.castToEnum((Object)fullUrl, GoogleServerGroup.ServerGroupType.class);
        }
        Object urlParts = callSiteArray[55].call((Object)fullUrl, (Object)"/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[56].callGetProperty(urlParts), (Object)4)) {
            throw (Throwable)callSiteArray[57].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."}));
        }
        String regionsOrZones = ShortTypeHandling.castToString((Object)callSiteArray[58].call(urlParts, callSiteArray[59].call(callSiteArray[60].callGetProperty(urlParts), (Object)4)));
        String string = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"regions")) {
            return (GoogleServerGroup.ServerGroupType)ShortTypeHandling.castToEnum((Object)callSiteArray[61].callGetProperty(GoogleServerGroup.ServerGroupType.class), GoogleServerGroup.ServerGroupType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"zones")) {
            return (GoogleServerGroup.ServerGroupType)ShortTypeHandling.castToEnum((Object)callSiteArray[62].callGetProperty(GoogleServerGroup.ServerGroupType.class), GoogleServerGroup.ServerGroupType.class);
        }
        throw (Throwable)callSiteArray[63].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."}));
    }

    public static List<String> deriveNetworkLoadBalancerNamesFromTargetPoolUrls(List<String> targetPoolUrls) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox(targetPoolUrls)) {
            public final class _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object targetPoolUrl) {
                    CallSite[] callSiteArray = _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.$getCallSiteArray();
                    Object targetPoolLocalName = callSiteArray[0].callCurrent((GroovyObject)this, targetPoolUrl);
                    return callSiteArray[1].call(callSiteArray[2].call(targetPoolLocalName, (Object)new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(_deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.class, Utils.class, (String)"TARGET_POOL_NAME_PREFIX")}, new String[]{"-", "-"})), (Object)0);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getLocalName";
                    stringArray[1] = "getAt";
                    stringArray[2] = "split";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(targetPoolUrls, (Object)new _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2(Utils.class, Utils.class)), List.class);
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public static Object getImmutableCopy(Object value) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object valueClass = callSiteArray[65].call(value);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[66].call(ClassUtils.class, valueClass)) || ScriptBytecodeAdapter.compareEqual((Object)valueClass, String.class)) {
            return value;
        }
        if (value instanceof Cloneable) {
            return callSiteArray[67].call(value);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return callSiteArray[68].call(value);
        }
        return null;
    }

    public static List<GoogleBackendService> getBackendServicesFromHttpLoadBalancerView(GoogleHttpLoadBalancer.View googleLoadBalancer) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        List backendServices = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[69].callGroovyObjectGetProperty((Object)googleLoadBalancer)});
        callSiteArray[70].callStatic(Utils.class, callSiteArray[71].callGroovyObjectGetPropertySafe((Object)googleLoadBalancer), (Object)backendServices);
        return backendServices;
    }

    public static List<GoogleBackendService> getBackendServicesFromInternalHttpLoadBalancerView(GoogleInternalHttpLoadBalancer.InternalHttpLbView googleLoadBalancer) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        List backendServices = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[72].callGroovyObjectGetProperty((Object)googleLoadBalancer)});
        callSiteArray[73].callStatic(Utils.class, callSiteArray[74].callGroovyObjectGetPropertySafe((Object)googleLoadBalancer), (Object)backendServices);
        return backendServices;
    }

    public static void collectBackendServicesFromHostRules(List<GoogleHostRule> hostRules, List<GoogleBackendService> backendServices) {
        Reference backendServices2 = new Reference(backendServices);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        public final class _collectBackendServicesFromHostRules_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _collectBackendServicesFromHostRules_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleHostRule hostRule) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure3.$getCallSiteArray();
                return callSiteArray[0].callGroovyObjectGetProperty((Object)hostRule);
            }

            @Generated
            public Object call(GoogleHostRule hostRule) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure3.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)hostRule);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "pathMatcher";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _collectBackendServicesFromHostRules_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_collectBackendServicesFromHostRules_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _collectBackendServicesFromHostRules_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List pathMatchers = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].call(hostRules, (Object)new _collectBackendServicesFromHostRules_closure3(Utils.class, Utils.class)), List.class);
        public final class _collectBackendServicesFromHostRules_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _collectBackendServicesFromHostRules_closure4(Object _outerInstance, Object _thisObject, Reference backendServices) {
                Reference reference;
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.backendServices = reference = backendServices;
            }

            public Object doCall(GooglePathMatcher pathMatcher) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure4.$getCallSiteArray();
                callSiteArray[0].call(this.backendServices.get(), callSiteArray[1].callGroovyObjectGetProperty((Object)pathMatcher));
                public final class _closure22
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServices;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure22(Object _outerInstance, Object _thisObject, Reference backendServices) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.backendServices = reference = backendServices;
                    }

                    public Object doCall(GooglePathRule googlePathRule) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        return callSiteArray[0].call(this.backendServices.get(), callSiteArray[1].callGroovyObjectGetProperty((Object)googlePathRule));
                    }

                    @Generated
                    public Object call(GooglePathRule googlePathRule) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)googlePathRule);
                    }

                    @Generated
                    public List getBackendServices() {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.backendServices.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "backendService";
                        stringArray[2] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure22.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure22.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure22.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[2].callSafe(callSiteArray[3].callGroovyObjectGetPropertySafe((Object)pathMatcher), (Object)new _closure22((Object)this, this.getThisObject(), this.backendServices));
            }

            @Generated
            public Object call(GooglePathMatcher pathMatcher) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure4.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, (Object)pathMatcher);
            }

            @Generated
            public List getBackendServices() {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure4.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.backendServices.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "defaultService";
                stringArray[2] = "each";
                stringArray[3] = "pathRules";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _collectBackendServicesFromHostRules_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_collectBackendServicesFromHostRules_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _collectBackendServicesFromHostRules_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _collectBackendServicesFromHostRules_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _collectBackendServicesFromHostRules_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure5.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareNotEqual((Object)it, null);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _collectBackendServicesFromHostRules_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_collectBackendServicesFromHostRules_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _collectBackendServicesFromHostRules_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[76].callSafe(callSiteArray[77].callSafe((Object)pathMatchers, (Object)new _collectBackendServicesFromHostRules_closure4(Utils.class, Utils.class, backendServices2)), (Object)new _collectBackendServicesFromHostRules_closure5(Utils.class, Utils.class));
    }

    public static List<String> getBackendServicesFromUrlMap(UrlMap urlMap) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Reference backendServices = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[78].call(GCEUtil.class, callSiteArray[79].callGetProperty((Object)urlMap))}));
        public final class _getBackendServicesFromUrlMap_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getBackendServicesFromUrlMap_closure6(Object _outerInstance, Object _thisObject, Reference backendServices) {
                Reference reference;
                CallSite[] callSiteArray = _getBackendServicesFromUrlMap_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.backendServices = reference = backendServices;
            }

            public Object doCall(PathMatcher pathMatcher) {
                CallSite[] callSiteArray = _getBackendServicesFromUrlMap_closure6.$getCallSiteArray();
                callSiteArray[0].call(this.backendServices.get(), callSiteArray[1].call(GCEUtil.class, callSiteArray[2].callGetProperty((Object)pathMatcher)));
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServices;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference backendServices) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.backendServices = reference = backendServices;
                    }

                    public Object doCall(PathRule pathRule) {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return callSiteArray[0].call(this.backendServices.get(), callSiteArray[1].call(GCEUtil.class, callSiteArray[2].callGetProperty((Object)pathRule)));
                    }

                    @Generated
                    public Object call(PathRule pathRule) {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[3].callCurrent((GroovyObject)this, (Object)pathRule);
                        }
                        return this.doCall(pathRule);
                    }

                    @Generated
                    public List getBackendServices() {
                        CallSite[] callSiteArray = _closure23.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.backendServices.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "leftShift";
                        stringArray[1] = "getLocalName";
                        stringArray[2] = "service";
                        stringArray[3] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure23.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure23.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure23.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[3].callSafe(callSiteArray[4].callGetPropertySafe((Object)pathMatcher), (Object)new _closure23((Object)this, this.getThisObject(), this.backendServices));
            }

            @Generated
            public Object call(PathMatcher pathMatcher) {
                CallSite[] callSiteArray = _getBackendServicesFromUrlMap_closure6.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)pathMatcher);
                }
                return this.doCall(pathMatcher);
            }

            @Generated
            public List getBackendServices() {
                CallSite[] callSiteArray = _getBackendServicesFromUrlMap_closure6.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.backendServices.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getBackendServicesFromUrlMap_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "getLocalName";
                stringArray[2] = "defaultService";
                stringArray[3] = "each";
                stringArray[4] = "pathRules";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getBackendServicesFromUrlMap_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getBackendServicesFromUrlMap_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getBackendServicesFromUrlMap_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[80].callSafe(callSiteArray[81].callGetPropertySafe((Object)urlMap), (Object)new _getBackendServicesFromUrlMap_closure6(Utils.class, Utils.class, backendServices));
        return (List)backendServices.get();
    }

    public static boolean determineHttpLoadBalancerDisabledState(GoogleHttpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object httpLoadBalancersFromMetadata = callSiteArray[82].call(callSiteArray[83].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[84].callGetProperty(GCEUtil.class));
        Reference backendServicesFromMetadata = new Reference(callSiteArray[85].call(callSiteArray[86].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[87].callGetProperty(GCEUtil.class)));
        public final class _determineHttpLoadBalancerDisabledState_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServicesFromMetadata;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineHttpLoadBalancerDisabledState_closure7(Object _outerInstance, Object _thisObject, Reference backendServicesFromMetadata) {
                Reference reference;
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.backendServicesFromMetadata = reference = backendServicesFromMetadata;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure7.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)it) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)this.backendServicesFromMetadata.get());
            }

            @Generated
            public Object getBackendServicesFromMetadata() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure7.$getCallSiteArray();
                return this.backendServicesFromMetadata.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_determineHttpLoadBalancerDisabledState_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineHttpLoadBalancerDisabledState_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineHttpLoadBalancerDisabledState_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineHttpLoadBalancerDisabledState_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure8.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "backends";
                return new CallSiteArray(_determineHttpLoadBalancerDisabledState_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineHttpLoadBalancerDisabledState_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List serviceBackends = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].call(callSiteArray[89].call(callSiteArray[90].callStatic(Utils.class, callSiteArray[91].callGroovyObjectGetProperty((Object)loadBalancer)), (Object)new _determineHttpLoadBalancerDisabledState_closure7(Utils.class, Utils.class, backendServicesFromMetadata)), (Object)new _determineHttpLoadBalancerDisabledState_closure8(Utils.class, Utils.class)), List.class);
        public final class _determineHttpLoadBalancerDisabledState_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineHttpLoadBalancerDisabledState_closure9(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure9.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty(this.serverGroup.get()), (Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty(it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure9.$getCallSiteArray();
                return (GoogleServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "region";
                stringArray[1] = "getRegionFromGroupUrl";
                stringArray[2] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _determineHttpLoadBalancerDisabledState_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineHttpLoadBalancerDisabledState_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineHttpLoadBalancerDisabledState_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineHttpLoadBalancerDisabledState_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineHttpLoadBalancerDisabledState_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure10.$getCallSiteArray();
                return callSiteArray[0].call(GCEUtil.class, callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineHttpLoadBalancerDisabledState_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _determineHttpLoadBalancerDisabledState_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineHttpLoadBalancerDisabledState_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineHttpLoadBalancerDisabledState_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List backendGroupNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call((Object)serviceBackends), (Object)new _determineHttpLoadBalancerDisabledState_closure9(Utils.class, Utils.class, serverGroup2)), (Object)new _determineHttpLoadBalancerDisabledState_closure10(Utils.class, Utils.class)), List.class);
        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[95].callGroovyObjectGetProperty((Object)loadBalancer), (Object)httpLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)callSiteArray[96].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), (Object)backendGroupNames);
    }

    public static boolean determineInternalHttpLoadBalancerDisabledState(GoogleInternalHttpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object loadBalancersFromMetadata = callSiteArray[97].call(callSiteArray[98].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[99].callGetProperty(GCEUtil.class));
        Reference backendServicesFromMetadata = new Reference(callSiteArray[100].call(callSiteArray[101].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[102].callGetProperty(GCEUtil.class)));
        public final class _determineInternalHttpLoadBalancerDisabledState_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServicesFromMetadata;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalHttpLoadBalancerDisabledState_closure11(Object _outerInstance, Object _thisObject, Reference backendServicesFromMetadata) {
                Reference reference;
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.backendServicesFromMetadata = reference = backendServicesFromMetadata;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure11.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)it) && ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(it), (Object)this.backendServicesFromMetadata.get());
            }

            @Generated
            public Object getBackendServicesFromMetadata() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure11.$getCallSiteArray();
                return this.backendServicesFromMetadata.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_determineInternalHttpLoadBalancerDisabledState_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineInternalHttpLoadBalancerDisabledState_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalHttpLoadBalancerDisabledState_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure12.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "backends";
                return new CallSiteArray(_determineInternalHttpLoadBalancerDisabledState_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List serviceBackends = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].callStatic(Utils.class, callSiteArray[106].callGroovyObjectGetProperty((Object)loadBalancer)), (Object)new _determineInternalHttpLoadBalancerDisabledState_closure11(Utils.class, Utils.class, backendServicesFromMetadata)), (Object)new _determineInternalHttpLoadBalancerDisabledState_closure12(Utils.class, Utils.class)), List.class);
        public final class _determineInternalHttpLoadBalancerDisabledState_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalHttpLoadBalancerDisabledState_closure13(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure13.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty(this.serverGroup.get()), (Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty(it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure13.$getCallSiteArray();
                return (GoogleServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "region";
                stringArray[1] = "getRegionFromGroupUrl";
                stringArray[2] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _determineInternalHttpLoadBalancerDisabledState_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineInternalHttpLoadBalancerDisabledState_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineInternalHttpLoadBalancerDisabledState_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalHttpLoadBalancerDisabledState_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure14.$getCallSiteArray();
                return callSiteArray[0].call(GCEUtil.class, callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _determineInternalHttpLoadBalancerDisabledState_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineInternalHttpLoadBalancerDisabledState_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalHttpLoadBalancerDisabledState_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List backendGroupNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call((Object)serviceBackends), (Object)new _determineInternalHttpLoadBalancerDisabledState_closure13(Utils.class, Utils.class, serverGroup2)), (Object)new _determineInternalHttpLoadBalancerDisabledState_closure14(Utils.class, Utils.class)), List.class);
        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[110].callGroovyObjectGetProperty((Object)loadBalancer), (Object)loadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)callSiteArray[111].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), (Object)backendGroupNames);
    }

    public static String decorateXpnResourceIdIfNeeded(String managedProjectId, String xpnResource) {
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)xpnResource)) {
            return xpnResource;
        }
        Object xpnResourceProject = callSiteArray[112].call(GCEUtil.class, (Object)xpnResource);
        Object xpnResourceId = callSiteArray[113].call(GCEUtil.class, (Object)xpnResource);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)xpnResourceProject, (Object)managedProjectId)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{xpnResourceProject, xpnResourceId}, new String[]{"", "/", ""});
            xpnResourceId = gStringImpl;
        }
        return ShortTypeHandling.castToString((Object)xpnResourceId);
    }

    public static boolean determineInternalLoadBalancerDisabledState(GoogleInternalLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object regionalLoadBalancersFromMetadata = callSiteArray[114].call(callSiteArray[115].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[116].callGetProperty(GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[117].callGroovyObjectGetProperty((Object)loadBalancer), null)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].call((Object)log)) ? callSiteArray[119].call((Object)log, (Object)new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed internal load balancer encountered: ", ""})) : null;
        }
        List serviceBackends = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].callGetPropertySafe(callSiteArray[121].callGroovyObjectGetPropertySafe((Object)loadBalancer)), List.class);
        public final class _determineInternalLoadBalancerDisabledState_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalLoadBalancerDisabledState_closure15(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure15.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty(this.serverGroup.get()), (Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty(it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure15.$getCallSiteArray();
                return (GoogleServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalLoadBalancerDisabledState_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "region";
                stringArray[1] = "getRegionFromGroupUrl";
                stringArray[2] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _determineInternalLoadBalancerDisabledState_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineInternalLoadBalancerDisabledState_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalLoadBalancerDisabledState_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineInternalLoadBalancerDisabledState_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineInternalLoadBalancerDisabledState_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure16.$getCallSiteArray();
                return callSiteArray[0].call(GCEUtil.class, callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineInternalLoadBalancerDisabledState_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalLoadBalancerDisabledState_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _determineInternalLoadBalancerDisabledState_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineInternalLoadBalancerDisabledState_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineInternalLoadBalancerDisabledState_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List backendGroupNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].call(callSiteArray[123].call((Object)serviceBackends, (Object)new _determineInternalLoadBalancerDisabledState_closure15(Utils.class, Utils.class, serverGroup2)), (Object)new _determineInternalLoadBalancerDisabledState_closure16(Utils.class, Utils.class)), List.class);
        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[124].callGroovyObjectGetProperty((Object)loadBalancer), (Object)regionalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)callSiteArray[125].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), (Object)backendGroupNames);
    }

    public static boolean determineSslLoadBalancerDisabledState(GoogleSslLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object globalLoadBalancersFromMetadata = callSiteArray[126].call(callSiteArray[127].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[128].callGetProperty(GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[129].callGroovyObjectGetProperty((Object)loadBalancer), null)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[130].call((Object)log)) ? callSiteArray[131].call((Object)log, (Object)new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed ssl load balancer encountered: ", ""})) : null;
        }
        List serviceBackends = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].callGetPropertySafe(callSiteArray[133].callGroovyObjectGetPropertySafe((Object)loadBalancer)), List.class);
        public final class _determineSslLoadBalancerDisabledState_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineSslLoadBalancerDisabledState_closure17(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure17.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty(this.serverGroup.get()), (Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty(it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure17.$getCallSiteArray();
                return (GoogleServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineSslLoadBalancerDisabledState_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "region";
                stringArray[1] = "getRegionFromGroupUrl";
                stringArray[2] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _determineSslLoadBalancerDisabledState_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineSslLoadBalancerDisabledState_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineSslLoadBalancerDisabledState_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineSslLoadBalancerDisabledState_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineSslLoadBalancerDisabledState_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure18.$getCallSiteArray();
                return callSiteArray[0].call(GCEUtil.class, callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineSslLoadBalancerDisabledState_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineSslLoadBalancerDisabledState_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _determineSslLoadBalancerDisabledState_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineSslLoadBalancerDisabledState_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineSslLoadBalancerDisabledState_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List backendGroupNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].call(callSiteArray[135].call((Object)serviceBackends, (Object)new _determineSslLoadBalancerDisabledState_closure17(Utils.class, Utils.class, serverGroup2)), (Object)new _determineSslLoadBalancerDisabledState_closure18(Utils.class, Utils.class)), List.class);
        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[136].callGroovyObjectGetProperty((Object)loadBalancer), (Object)globalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)callSiteArray[137].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), (Object)backendGroupNames);
    }

    public static boolean determineTcpLoadBalancerDisabledState(GoogleTcpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object globalLoadBalancersFromMetadata = callSiteArray[138].call(callSiteArray[139].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), callSiteArray[140].callGetProperty(GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[141].callGroovyObjectGetProperty((Object)loadBalancer), null)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[142].call((Object)log)) ? callSiteArray[143].call((Object)log, (Object)new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed tcp load balancer encountered: ", ""})) : null;
        }
        List serviceBackends = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].callGetPropertySafe(callSiteArray[145].callGroovyObjectGetPropertySafe((Object)loadBalancer)), List.class);
        public final class _determineTcpLoadBalancerDisabledState_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineTcpLoadBalancerDisabledState_closure19(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                Reference reference;
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure19.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty(this.serverGroup.get()), (Object)callSiteArray[1].call(Utils.class, callSiteArray[2].callGetProperty(it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure19.$getCallSiteArray();
                return (GoogleServerGroup)ScriptBytecodeAdapter.castToType((Object)this.serverGroup.get(), GoogleServerGroup.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineTcpLoadBalancerDisabledState_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "region";
                stringArray[1] = "getRegionFromGroupUrl";
                stringArray[2] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _determineTcpLoadBalancerDisabledState_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineTcpLoadBalancerDisabledState_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineTcpLoadBalancerDisabledState_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _determineTcpLoadBalancerDisabledState_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _determineTcpLoadBalancerDisabledState_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure20.$getCallSiteArray();
                return callSiteArray[0].call(GCEUtil.class, callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _determineTcpLoadBalancerDisabledState_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineTcpLoadBalancerDisabledState_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _determineTcpLoadBalancerDisabledState_closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_determineTcpLoadBalancerDisabledState_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _determineTcpLoadBalancerDisabledState_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List backendGroupNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].call(callSiteArray[147].call((Object)serviceBackends, (Object)new _determineTcpLoadBalancerDisabledState_closure19(Utils.class, Utils.class, serverGroup2)), (Object)new _determineTcpLoadBalancerDisabledState_closure20(Utils.class, Utils.class)), List.class);
        return ScriptBytecodeAdapter.isCase((Object)callSiteArray[148].callGroovyObjectGetProperty((Object)loadBalancer), (Object)globalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)callSiteArray[149].callGroovyObjectGetProperty((Object)((GoogleServerGroup)serverGroup2.get())), (Object)backendGroupNames);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Collection<String>> mergeOnDemandCacheRelationships(Map<String, Collection<String>> onDemandRelationships, Map<String, Collection<String>> existingRelationships) {
        void var1_1;
        Reference onDemandRelationships2 = new Reference(onDemandRelationships);
        Reference existingRelationships2 = new Reference((Object)var1_1);
        CallSite[] callSiteArray = Utils.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].call((Object)log)) ? callSiteArray[151].call((Object)log, (Object)new GStringImpl(new Object[]{(Map)onDemandRelationships2.get(), (Map)existingRelationships2.get()}, new String[]{"Merging onDemand relationships: ", " with existing relationships: ", ""})) : null;
        Set relationshipKeys = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].call(callSiteArray[153].call((Object)((Map)existingRelationships2.get())), callSiteArray[154].call((Object)((Map)onDemandRelationships2.get()))), Set.class);
        public final class _mergeOnDemandCacheRelationships_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference onDemandRelationships;
            private /* synthetic */ Reference existingRelationships;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mergeOnDemandCacheRelationships_closure21(Object _outerInstance, Object _thisObject, Reference onDemandRelationships, Reference existingRelationships) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _mergeOnDemandCacheRelationships_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.onDemandRelationships = reference2 = onDemandRelationships;
                this.existingRelationships = reference = existingRelationships;
            }

            public Object doCall(String key) {
                CallSite[] callSiteArray = _mergeOnDemandCacheRelationships_closure21.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.onDemandRelationships.get(), (Object)key)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(this.existingRelationships.get(), (Object)key))) {
                    Set ret = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(HashSet.class), Set.class);
                    callSiteArray[3].call((Object)ret, callSiteArray[4].call(this.onDemandRelationships.get(), (Object)key, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                    callSiteArray[5].call((Object)ret, callSiteArray[6].call(this.existingRelationships.get(), (Object)key, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                    return callSiteArray[7].callConstructor(MapEntry.class, (Object)key, (Object)ret);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call(this.onDemandRelationships.get(), (Object)key))) {
                    return callSiteArray[9].callConstructor(MapEntry.class, (Object)key, callSiteArray[10].call(this.onDemandRelationships.get(), (Object)key, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(this.existingRelationships.get(), (Object)key))) {
                    return callSiteArray[12].callConstructor(MapEntry.class, (Object)key, callSiteArray[13].call(this.existingRelationships.get(), (Object)key, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                }
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(ScriptBytecodeAdapter.getField(_mergeOnDemandCacheRelationships_closure21.class, Utils.class, (String)"log"))) ? callSiteArray[15].call(ScriptBytecodeAdapter.getField(_mergeOnDemandCacheRelationships_closure21.class, Utils.class, (String)"log"), (Object)new GStringImpl(new Object[]{key}, new String[]{"Attempted to merge relationship key ", " that neither exists in onDemand cache data nor existing cache data."})) : null;
                return null;
            }

            @Generated
            public Object call(String key) {
                CallSite[] callSiteArray = _mergeOnDemandCacheRelationships_closure21.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[16].callCurrent((GroovyObject)this, (Object)key);
                }
                return this.doCall(key);
            }

            @Generated
            public Map getOnDemandRelationships() {
                CallSite[] callSiteArray = _mergeOnDemandCacheRelationships_closure21.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.onDemandRelationships.get(), Map.class);
            }

            @Generated
            public Map getExistingRelationships() {
                CallSite[] callSiteArray = _mergeOnDemandCacheRelationships_closure21.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.existingRelationships.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergeOnDemandCacheRelationships_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "containsKey";
                stringArray[1] = "containsKey";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "addAll";
                stringArray[4] = "getOrDefault";
                stringArray[5] = "addAll";
                stringArray[6] = "getOrDefault";
                stringArray[7] = "<$constructor$>";
                stringArray[8] = "containsKey";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "getOrDefault";
                stringArray[11] = "containsKey";
                stringArray[12] = "<$constructor$>";
                stringArray[13] = "getOrDefault";
                stringArray[14] = "isWarnEnabled";
                stringArray[15] = "warn";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _mergeOnDemandCacheRelationships_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_mergeOnDemandCacheRelationships_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mergeOnDemandCacheRelationships_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].call((Object)relationshipKeys, (Object)new _mergeOnDemandCacheRelationships_closure21(Utils.class, Utils.class, onDemandRelationships2, existingRelationships2)), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Utils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = Utils.$getCallSiteArray()[156].call(Utils.$getCallSiteArray()[157].call(Splitter.class, (Object)"/"));
        onSlash = (Splitter)ScriptBytecodeAdapter.castToType((Object)object, Splitter.class);
        Object object2 = Utils.$getCallSiteArray()[158].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getTime";
        stringArray[1] = "parse";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "currentTimeMillis";
        stringArray[4] = "contains";
        stringArray[5] = "contains";
        stringArray[6] = "split";
        stringArray[7] = "length";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "getAt";
        stringArray[10] = "getAt";
        stringArray[11] = "getAt";
        stringArray[12] = "lastIndexOf";
        stringArray[13] = "substring";
        stringArray[14] = "plus";
        stringArray[15] = "substring";
        stringArray[16] = "substring";
        stringArray[17] = "plus";
        stringArray[18] = "indexOf";
        stringArray[19] = "length";
        stringArray[20] = "minus";
        stringArray[21] = "indexOf";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "lastIndexOf";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "substring";
        stringArray[26] = "getLocalName";
        stringArray[27] = "collectEntries";
        stringArray[28] = "items";
        stringArray[29] = "split";
        stringArray[30] = "length";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "getAt";
        stringArray[33] = "minus";
        stringArray[34] = "length";
        stringArray[35] = "getAt";
        stringArray[36] = "minus";
        stringArray[37] = "length";
        stringArray[38] = "getAt";
        stringArray[39] = "minus";
        stringArray[40] = "length";
        stringArray[41] = "lastIndexOf";
        stringArray[42] = "substring";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "split";
        stringArray[45] = "length";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "getAt";
        stringArray[48] = "minus";
        stringArray[49] = "length";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "getAt";
        stringArray[52] = "minus";
        stringArray[53] = "length";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "split";
        stringArray[56] = "length";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "getAt";
        stringArray[59] = "minus";
        stringArray[60] = "length";
        stringArray[61] = "REGIONAL";
        stringArray[62] = "ZONAL";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "collect";
        stringArray[65] = "getClass";
        stringArray[66] = "isPrimitiveOrWrapper";
        stringArray[67] = "clone";
        stringArray[68] = "toString";
        stringArray[69] = "defaultService";
        stringArray[70] = "collectBackendServicesFromHostRules";
        stringArray[71] = "hostRules";
        stringArray[72] = "defaultService";
        stringArray[73] = "collectBackendServicesFromHostRules";
        stringArray[74] = "hostRules";
        stringArray[75] = "collect";
        stringArray[76] = "findAll";
        stringArray[77] = "each";
        stringArray[78] = "getLocalName";
        stringArray[79] = "defaultService";
        stringArray[80] = "each";
        stringArray[81] = "pathMatchers";
        stringArray[82] = "get";
        stringArray[83] = "asg";
        stringArray[84] = "GLOBAL_LOAD_BALANCER_NAMES";
        stringArray[85] = "get";
        stringArray[86] = "asg";
        stringArray[87] = "BACKEND_SERVICE_NAMES";
        stringArray[88] = "collect";
        stringArray[89] = "findAll";
        stringArray[90] = "getBackendServicesFromHttpLoadBalancerView";
        stringArray[91] = "view";
        stringArray[92] = "collect";
        stringArray[93] = "findAll";
        stringArray[94] = "flatten";
        stringArray[95] = "name";
        stringArray[96] = "name";
        stringArray[97] = "get";
        stringArray[98] = "asg";
        stringArray[99] = "REGIONAL_LOAD_BALANCER_NAMES";
        stringArray[100] = "get";
        stringArray[101] = "asg";
        stringArray[102] = "REGION_BACKEND_SERVICE_NAMES";
        stringArray[103] = "collect";
        stringArray[104] = "findAll";
        stringArray[105] = "getBackendServicesFromInternalHttpLoadBalancerView";
        stringArray[106] = "view";
        stringArray[107] = "collect";
        stringArray[108] = "findAll";
        stringArray[109] = "flatten";
        stringArray[110] = "name";
        stringArray[111] = "name";
        stringArray[112] = "deriveProjectId";
        stringArray[113] = "getLocalName";
        stringArray[114] = "get";
        stringArray[115] = "asg";
        stringArray[116] = "REGIONAL_LOAD_BALANCER_NAMES";
        stringArray[117] = "backendService";
        stringArray[118] = "isWarnEnabled";
        stringArray[119] = "warn";
        stringArray[120] = "backends";
        stringArray[121] = "backendService";
        stringArray[122] = "collect";
        stringArray[123] = "findAll";
        stringArray[124] = "name";
        stringArray[125] = "name";
        stringArray[126] = "get";
        stringArray[127] = "asg";
        stringArray[128] = "GLOBAL_LOAD_BALANCER_NAMES";
        stringArray[129] = "backendService";
        stringArray[130] = "isWarnEnabled";
        stringArray[131] = "warn";
        stringArray[132] = "backends";
        stringArray[133] = "backendService";
        stringArray[134] = "collect";
        stringArray[135] = "findAll";
        stringArray[136] = "name";
        stringArray[137] = "name";
        stringArray[138] = "get";
        stringArray[139] = "asg";
        stringArray[140] = "GLOBAL_LOAD_BALANCER_NAMES";
        stringArray[141] = "backendService";
        stringArray[142] = "isWarnEnabled";
        stringArray[143] = "warn";
        stringArray[144] = "backends";
        stringArray[145] = "backendService";
        stringArray[146] = "collect";
        stringArray[147] = "findAll";
        stringArray[148] = "name";
        stringArray[149] = "name";
        stringArray[150] = "isDebugEnabled";
        stringArray[151] = "debug";
        stringArray[152] = "plus";
        stringArray[153] = "keySet";
        stringArray[154] = "keySet";
        stringArray[155] = "collectEntries";
        stringArray[156] = "omitEmptyStrings";
        stringArray[157] = "on";
        stringArray[158] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[159];
        Utils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Utils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Utils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

