/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.BackendServiceGroupHealth;
import com.google.api.services.compute.model.ConnectionDraining;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.HealthCheck;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.ResourceGroupReference;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.UrlMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.batch.GoogleBatchRequest;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleLoadBalancerHealth;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancedBackend;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathMatcher;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.FailureLogger;
import com.netflix.spinnaker.clouddriver.google.provider.agent.util.GroupHealthRequest;
import com.netflix.spinnaker.clouddriver.google.provider.agent.util.LoadBalancerHealthResolution;
import com.netflix.spinnaker.clouddriver.google.provider.agent.util.PaginatedRequest;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleInternalHttpLoadBalancerCachingAgent
extends AbstractGoogleLoadBalancerCachingAgent {
    private static final Logger log = LoggerFactory.getLogger(GoogleInternalHttpLoadBalancer.class);
    private Map<String, List<BackendServiceGroupHealth>> bsNameToGroupHealthsMap = new HashMap<String, List<BackendServiceGroupHealth>>();
    private Set<GroupHealthRequest> queuedBsGroupHealthRequests = new HashSet<GroupHealthRequest>();
    private Set<LoadBalancerHealthResolution> resolutions = new HashSet<LoadBalancerHealthResolution>();

    public GoogleInternalHttpLoadBalancerCachingAgent(String clouddriverUserAgentApplicationName, GoogleNamedAccountCredentials credentials, ObjectMapper objectMapper, Registry registry, String region) {
        super(clouddriverUserAgentApplicationName, credentials, objectMapper, registry, region);
    }

    @Override
    public List<GoogleLoadBalancer> constructLoadBalancers(String onDemandLoadBalancerName) {
        ArrayList<GoogleInternalHttpLoadBalancer> loadBalancers = new ArrayList<GoogleInternalHttpLoadBalancer>();
        ArrayList<String> failedLoadBalancers = new ArrayList<String>();
        GoogleBatchRequest forwardingRulesRequest = this.buildGoogleBatchRequest();
        GoogleBatchRequest targetProxyRequest = this.buildGoogleBatchRequest();
        GoogleBatchRequest urlMapRequest = this.buildGoogleBatchRequest();
        GoogleBatchRequest groupHealthRequest = this.buildGoogleBatchRequest();
        this.bsNameToGroupHealthsMap = new HashMap<String, List<BackendServiceGroupHealth>>();
        this.queuedBsGroupHealthRequests = new HashSet<GroupHealthRequest>();
        this.resolutions = new HashSet<LoadBalancerHealthResolution>();
        List<BackendService> projectBackendServices = GCEUtil.fetchRegionBackendServices(this, this.getCompute(), this.getProject(), this.getRegion());
        List<HealthCheck> projectHealthChecks = GCEUtil.fetchRegionalHealthChecks(this, this.getCompute(), this.getProject(), this.getRegion());
        ForwardingRuleCallbacks forwardingRuleCallbacks = new ForwardingRuleCallbacks(loadBalancers, failedLoadBalancers, targetProxyRequest, urlMapRequest, groupHealthRequest, projectBackendServices, projectHealthChecks);
        try {
            if (onDemandLoadBalancerName != null) {
                ForwardingRuleCallbacks.ForwardingRuleSingletonCallback frCallback = forwardingRuleCallbacks.newForwardingRuleSingletonCallback();
                forwardingRulesRequest.queue((ComputeRequest)this.getCompute().forwardingRules().get(this.getProject(), this.getRegion(), onDemandLoadBalancerName), frCallback);
            } else {
                ForwardingRuleCallbacks.ForwardingRuleListCallback frlCallback = forwardingRuleCallbacks.newForwardingRuleListCallback();
                new PaginatedRequest<ForwardingRuleList>((AbstractGoogleCachingAgent)this){

                    @Override
                    public ComputeRequest<ForwardingRuleList> request(String pageToken) {
                        try {
                            return GoogleInternalHttpLoadBalancerCachingAgent.this.getCompute().forwardingRules().list(GoogleInternalHttpLoadBalancerCachingAgent.this.getProject(), GoogleInternalHttpLoadBalancerCachingAgent.this.getRegion()).setPageToken(pageToken);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    @Override
                    public String getNextPageToken(ForwardingRuleList forwardingRuleList) {
                        return forwardingRuleList.getNextPageToken();
                    }
                }.queue(forwardingRulesRequest, frlCallback, "InternalHttpLoadBalancerCaching.forwardingRules");
            }
            this.executeIfRequestsAreQueued(forwardingRulesRequest, "InternalHttpLoadBalancerCaching.forwardingRules");
            this.executeIfRequestsAreQueued(targetProxyRequest, "InternalHttpLoadBalancerCaching.targetProxy");
            this.executeIfRequestsAreQueued(urlMapRequest, "InternalHttpLoadBalancerCaching.urlMapRequest");
            this.executeIfRequestsAreQueued(groupHealthRequest, "InternalHttpLoadBalancerCaching.groupHealth");
            for (LoadBalancerHealthResolution resolution : this.resolutions) {
                for (BackendServiceGroupHealth groupHealth : this.bsNameToGroupHealthsMap.get(resolution.getTarget())) {
                    GCEUtil.handleHealthObject(resolution.getGoogleLoadBalancer(), groupHealth);
                }
            }
            return loadBalancers.stream().filter(lb -> !failedLoadBalancers.contains(lb.getName())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<GoogleLoadBalancer> constructLoadBalancers() {
        return this.constructLoadBalancers(null);
    }

    @Override
    public String determineInstanceKey(GoogleLoadBalancer loadBalancer, GoogleLoadBalancerHealth health) {
        String instanceZone = health.getInstanceZone();
        String instanceRegion = this.getCredentials().regionFromZone(instanceZone);
        return Keys.getInstanceKey(this.getAccountName(), instanceRegion, health.getInstanceName());
    }

    private void handleBackendService(BackendService backendService, GoogleInternalHttpLoadBalancer googleHttpLoadBalancer, List<HealthCheck> healthChecks, GoogleBatchRequest groupHealthRequest) {
        if (backendService == null) {
            return;
        }
        GroupHealthCallback groupHealthCallback = new GroupHealthCallback(backendService.getName());
        List<GoogleBackendService> backendServicesInMap = Utils.getBackendServicesFromInternalHttpLoadBalancerView(googleHttpLoadBalancer.getView());
        List<GoogleBackendService> backendServicesToUpdate = backendServicesInMap.stream().filter(b -> b.getName().equals(backendService.getName())).collect(Collectors.toList());
        for (GoogleBackendService service : backendServicesToUpdate) {
            service.setRegion(googleHttpLoadBalancer.getRegion());
            service.setSessionAffinity(GoogleSessionAffinity.valueOf(backendService.getSessionAffinity()));
            service.setAffinityCookieTtlSec(backendService.getAffinityCookieTtlSec());
            service.setEnableCDN(backendService.getEnableCDN());
            String name = backendService.getPortName();
            service.setPortName(name != null ? name : "http");
            ConnectionDraining draining = backendService.getConnectionDraining();
            service.setConnectionDrainingTimeoutSec(draining == null ? 0 : draining.getDrainingTimeoutSec());
            if (backendService.getBackends() == null) continue;
            List<GoogleLoadBalancedBackend> backends = backendService.getBackends().stream().filter(backend -> backend.getGroup() != null).map(backend -> {
                GoogleLoadBalancedBackend googleBackend = new GoogleLoadBalancedBackend();
                googleBackend.setPolicy(GCEUtil.loadBalancingPolicyFromBackend(backend));
                googleBackend.setServerGroupUrl(backend.getGroup());
                return googleBackend;
            }).collect(Collectors.toList());
            service.setBackends(backends);
        }
        if (backendService.getBackends() != null) {
            backendService.getBackends().stream().filter(backend -> backend.getGroup() != null).forEach(backend -> {
                ResourceGroupReference resourceGroup = new ResourceGroupReference();
                resourceGroup.setGroup(backend.getGroup());
                GroupHealthRequest ghr = new GroupHealthRequest(this.getProject(), backendService.getName(), resourceGroup.getGroup());
                if (!this.queuedBsGroupHealthRequests.contains(ghr)) {
                    log.debug("Queueing a batch call for getHealth(): {}", (Object)ghr);
                    this.queuedBsGroupHealthRequests.add(ghr);
                    try {
                        groupHealthRequest.queue((ComputeRequest)this.getCompute().regionBackendServices().getHealth(this.getProject(), this.getRegion(), backendService.getName(), resourceGroup), groupHealthCallback);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                } else {
                    log.debug("Passing, batch call result cached for getHealth(): {}", (Object)ghr);
                }
                this.resolutions.add(new LoadBalancerHealthResolution(googleHttpLoadBalancer, backendService.getName()));
            });
        }
        for (String healthCheckURL : backendService.getHealthChecks()) {
            String healthCheckName = Utils.getLocalName(healthCheckURL);
            HealthCheck healthCheck = healthChecks.stream().filter(hc -> Utils.getLocalName(hc.getName()).equals(healthCheckName)).findFirst().get();
            GoogleInternalHttpLoadBalancerCachingAgent.handleHealthCheck(healthCheck, backendServicesToUpdate);
        }
    }

    private static void handleHealthCheck(HealthCheck healthCheck, List<GoogleBackendService> googleBackendServices) {
        if (healthCheck == null) {
            return;
        }
        Integer port = null;
        GoogleHealthCheck.HealthCheckType hcType = null;
        String requestPath = null;
        if (healthCheck.getTcpHealthCheck() != null) {
            port = healthCheck.getTcpHealthCheck().getPort();
            hcType = GoogleHealthCheck.HealthCheckType.TCP;
        } else if (healthCheck.getSslHealthCheck() != null) {
            port = healthCheck.getSslHealthCheck().getPort();
            hcType = GoogleHealthCheck.HealthCheckType.SSL;
        } else if (healthCheck.getHttpHealthCheck() != null) {
            port = healthCheck.getHttpHealthCheck().getPort();
            requestPath = healthCheck.getHttpHealthCheck().getRequestPath();
            hcType = GoogleHealthCheck.HealthCheckType.HTTP;
        } else if (healthCheck.getHttpsHealthCheck() != null) {
            port = healthCheck.getHttpsHealthCheck().getPort();
            requestPath = healthCheck.getHttpsHealthCheck().getRequestPath();
            hcType = GoogleHealthCheck.HealthCheckType.HTTPS;
        }
        if (port != null && hcType != null) {
            for (GoogleBackendService googleBackendService : googleBackendServices) {
                GoogleHealthCheck googleHealthCheck = new GoogleHealthCheck();
                googleHealthCheck.setName(healthCheck.getName());
                googleHealthCheck.setRequestPath(requestPath);
                googleHealthCheck.setSelfLink(healthCheck.getSelfLink());
                googleHealthCheck.setPort(port);
                googleHealthCheck.setHealthCheckType(hcType);
                googleHealthCheck.setCheckIntervalSec(healthCheck.getCheckIntervalSec());
                googleHealthCheck.setTimeoutSec(healthCheck.getTimeoutSec());
                googleHealthCheck.setUnhealthyThreshold(healthCheck.getUnhealthyThreshold());
                googleHealthCheck.setHealthyThreshold(healthCheck.getHealthyThreshold());
                googleHealthCheck.setRegion(healthCheck.getRegion());
                googleBackendService.setHealthCheck(googleHealthCheck);
            }
        }
    }

    public class GroupHealthCallback
    extends JsonBatchCallback<BackendServiceGroupHealth> {
        private String backendServiceName;

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
            log.debug("Failed backend service group health call for backend service " + this.getBackendServiceName() + " for Http load balancer. The platform error message was:\n " + e.getMessage() + ".");
        }

        public void onSuccess(BackendServiceGroupHealth backendServiceGroupHealth, HttpHeaders responseHeaders) {
            if (!GoogleInternalHttpLoadBalancerCachingAgent.this.bsNameToGroupHealthsMap.containsKey(this.backendServiceName)) {
                GoogleInternalHttpLoadBalancerCachingAgent.this.bsNameToGroupHealthsMap.put(this.backendServiceName, new ArrayList<BackendServiceGroupHealth>(Arrays.asList(backendServiceGroupHealth)));
            } else {
                GoogleInternalHttpLoadBalancerCachingAgent.this.bsNameToGroupHealthsMap.get(this.backendServiceName).add(backendServiceGroupHealth);
            }
        }

        public String getBackendServiceName() {
            return this.backendServiceName;
        }

        public void setBackendServiceName(String backendServiceName) {
            this.backendServiceName = backendServiceName;
        }

        public GroupHealthCallback(String backendServiceName) {
            this.backendServiceName = backendServiceName;
        }
    }

    public class UrlMapCallback
    extends BaseCallback<UrlMap> {
        private GoogleInternalHttpLoadBalancer googleLoadBalancer;
        private List<BackendService> projectBackendServices;
        private List<HealthCheck> projectHealthChecks;
        private GoogleBatchRequest groupHealthRequest;

        public void onSuccess(UrlMap urlMap, HttpHeaders responseHeaders) {
            if (this.googleLoadBalancer.getDefaultService() != null || this.googleLoadBalancer.getHostRules() != null && this.googleLoadBalancer.getHostRules().size() > 0) {
                log.error("Overwriting UrlMap " + urlMap.getName() + ". You may have a TargetHttp(s)Proxy naming collision.");
            }
            this.googleLoadBalancer.setUrlMapName(urlMap.getName());
            HashSet<String> queuedServices = new HashSet<String>();
            String urlMapDefaultService = Utils.getLocalName(urlMap.getDefaultService());
            queuedServices.add(urlMapDefaultService);
            GoogleBackendService service1 = new GoogleBackendService();
            service1.setName(urlMapDefaultService);
            this.googleLoadBalancer.setDefaultService(service1);
            if (urlMap.getPathMatchers() != null) {
                for (PathMatcher pathMatcher : urlMap.getPathMatchers()) {
                    String pathMatchDefaultService = Utils.getLocalName(pathMatcher.getDefaultService());
                    List pathRules = pathMatcher.getPathRules() != null ? pathMatcher.getPathRules() : new ArrayList();
                    for (HostRule hostRule : urlMap.getHostRules()) {
                        if (hostRule.getPathMatcher() == null || !hostRule.getPathMatcher().equals(pathMatcher.getName())) continue;
                        GoogleBackendService googleBackendService = new GoogleBackendService();
                        googleBackendService.setName(pathMatchDefaultService);
                        GooglePathMatcher gPathMatcher = new GooglePathMatcher();
                        gPathMatcher.setPathRules(new ArrayList<GooglePathRule>());
                        gPathMatcher.setDefaultService(googleBackendService);
                        GoogleHostRule gHostRule = new GoogleHostRule();
                        gHostRule.setHostPatterns(hostRule.getHosts());
                        gHostRule.setPathMatcher(gPathMatcher);
                        List<GooglePathRule> collect = pathRules.stream().map(pathRule -> {
                            GoogleBackendService service = new GoogleBackendService();
                            service.setName(Utils.getLocalName(pathRule.getService()));
                            GooglePathRule googlePathRule = new GooglePathRule();
                            googlePathRule.setPaths(pathRule.getPaths());
                            googlePathRule.setBackendService(service);
                            return googlePathRule;
                        }).collect(Collectors.toList());
                        gPathMatcher.setPathRules(collect);
                        this.googleLoadBalancer.getHostRules().add(gHostRule);
                    }
                    queuedServices.add(pathMatchDefaultService);
                    for (PathRule pathRule2 : pathRules) {
                        if (pathRule2.getService() == null) continue;
                        queuedServices.add(Utils.getLocalName(pathRule2.getService()));
                    }
                }
            }
            for (String queuedService : queuedServices) {
                BackendService service = this.projectBackendServices.stream().filter(bs -> Utils.getLocalName(bs.getName()).equals(queuedService)).findFirst().get();
                GoogleInternalHttpLoadBalancerCachingAgent.this.handleBackendService(service, this.googleLoadBalancer, this.projectHealthChecks, this.groupHealthRequest);
            }
        }

        public UrlMapCallback(GoogleInternalHttpLoadBalancer googleLoadBalancer, List<BackendService> projectBackendServices, List<HealthCheck> projectHealthChecks, GoogleBatchRequest groupHealthRequest, String subject, List<String> failedSubjects) {
            super(failedSubjects, subject);
            this.googleLoadBalancer = googleLoadBalancer;
            this.projectBackendServices = projectBackendServices;
            this.projectHealthChecks = projectHealthChecks;
            this.groupHealthRequest = groupHealthRequest;
        }
    }

    public class TargetProxyCallback
    extends BaseCallback<TargetHttpProxy> {
        private GoogleInternalHttpLoadBalancer googleLoadBalancer;
        private GoogleBatchRequest urlMapRequest;
        private GoogleBatchRequest groupHealthRequest;
        private List<BackendService> projectBackendServices;
        private List<HealthCheck> projectHealthChecks;

        public void onSuccess(TargetHttpProxy targetHttpProxy, HttpHeaders responseHeaders) throws IOException {
            String urlMapURL = targetHttpProxy.getUrlMap();
            if (urlMapURL != null) {
                UrlMapCallback urlMapCallback = new UrlMapCallback(this.googleLoadBalancer, this.projectBackendServices, this.projectHealthChecks, this.groupHealthRequest, this.subject, this.failedSubjects);
                this.urlMapRequest.queue((ComputeRequest)GoogleInternalHttpLoadBalancerCachingAgent.this.getCompute().regionUrlMaps().get(GoogleInternalHttpLoadBalancerCachingAgent.this.getProject(), GoogleInternalHttpLoadBalancerCachingAgent.this.getRegion(), Utils.getLocalName(urlMapURL)), urlMapCallback);
            }
        }

        public TargetProxyCallback(GoogleInternalHttpLoadBalancer googleLoadBalancer, GoogleBatchRequest urlMapRequest, GoogleBatchRequest groupHealthRequest, List<BackendService> projectBackendServices, List<HealthCheck> projectHealthChecks, String subject, List<String> failedSubjects) {
            super(failedSubjects, subject);
            this.googleLoadBalancer = googleLoadBalancer;
            this.urlMapRequest = urlMapRequest;
            this.groupHealthRequest = groupHealthRequest;
            this.projectBackendServices = projectBackendServices;
            this.projectHealthChecks = projectHealthChecks;
        }
    }

    public class TargetHttpsProxyCallback
    extends BaseCallback<TargetHttpsProxy> {
        private GoogleInternalHttpLoadBalancer googleLoadBalancer;
        private GoogleBatchRequest urlMapRequest;
        private GoogleBatchRequest groupHealthRequest;
        private List<BackendService> projectBackendServices;
        private List<HealthCheck> projectHealthChecks;

        public void onSuccess(TargetHttpsProxy targetHttpsProxy, HttpHeaders responseHeaders) throws IOException {
            this.googleLoadBalancer.setCertificate(Utils.getLocalName((String)targetHttpsProxy.getSslCertificates().get(0)));
            String urlMapURL = targetHttpsProxy.getUrlMap();
            if (urlMapURL != null) {
                UrlMapCallback urlMapCallback = new UrlMapCallback(this.googleLoadBalancer, this.projectBackendServices, this.projectHealthChecks, this.groupHealthRequest, this.subject, this.failedSubjects);
                this.urlMapRequest.queue((ComputeRequest)GoogleInternalHttpLoadBalancerCachingAgent.this.getCompute().regionUrlMaps().get(GoogleInternalHttpLoadBalancerCachingAgent.this.getProject(), GoogleInternalHttpLoadBalancerCachingAgent.this.getRegion(), Utils.getLocalName(urlMapURL)), urlMapCallback);
            }
        }

        public TargetHttpsProxyCallback(GoogleInternalHttpLoadBalancer googleLoadBalancer, GoogleBatchRequest urlMapRequest, GoogleBatchRequest groupHealthRequest, List<BackendService> projectBackendServices, List<HealthCheck> projectHealthChecks, String subject, List<String> failedSubjects) {
            super(failedSubjects, subject);
            this.googleLoadBalancer = googleLoadBalancer;
            this.urlMapRequest = urlMapRequest;
            this.groupHealthRequest = groupHealthRequest;
            this.projectBackendServices = projectBackendServices;
            this.projectHealthChecks = projectHealthChecks;
        }
    }

    static abstract class BaseCallback<T>
    extends JsonBatchCallback<T> {
        List<String> failedSubjects;
        String subject;

        public BaseCallback(List<String> failedSubjects, String subject) {
            this.failedSubjects = failedSubjects;
            this.subject = subject;
        }

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
            log.warn("Failed to read a component of subject " + this.subject + ". The platform error message was:\n" + e.getMessage() + ". \nReporting it as 'Failed' to the caching agent. ");
            this.failedSubjects.add(this.subject);
        }
    }

    public class ForwardingRuleCallbacks {
        private List<GoogleInternalHttpLoadBalancer> loadBalancers;
        private List<String> failedLoadBalancers;
        private GoogleBatchRequest targetProxyRequest;
        private GoogleBatchRequest urlMapRequest;
        private GoogleBatchRequest groupHealthRequest;
        private List<BackendService> projectBackendServices;
        private List<HealthCheck> projectHealthChecks;

        public ForwardingRuleSingletonCallback newForwardingRuleSingletonCallback() {
            return new ForwardingRuleSingletonCallback();
        }

        public ForwardingRuleListCallback newForwardingRuleListCallback() {
            return new ForwardingRuleListCallback();
        }

        public void cacheRemainderOfLoadBalancerResourceGraph(ForwardingRule forwardingRule) {
            GoogleInternalHttpLoadBalancer newLoadBalancer = new GoogleInternalHttpLoadBalancer();
            newLoadBalancer.setName(forwardingRule.getName());
            newLoadBalancer.setAccount(GoogleInternalHttpLoadBalancerCachingAgent.this.getAccountName());
            newLoadBalancer.setRegion(Utils.getLocalName(forwardingRule.getRegion()));
            newLoadBalancer.setCreatedTime(Utils.getTimeFromTimestamp(forwardingRule.getCreationTimestamp()));
            newLoadBalancer.setIpAddress(forwardingRule.getIPAddress());
            newLoadBalancer.setIpProtocol(forwardingRule.getIPProtocol());
            newLoadBalancer.setPortRange(forwardingRule.getPortRange());
            newLoadBalancer.setNetwork(forwardingRule.getNetwork());
            newLoadBalancer.setSubnet(forwardingRule.getSubnetwork());
            newLoadBalancer.setHealths(new ArrayList<GoogleLoadBalancerHealth>());
            newLoadBalancer.setHostRules(new ArrayList<GoogleHostRule>());
            this.loadBalancers.add(newLoadBalancer);
            String targetProxyName = Utils.getLocalName(forwardingRule.getTarget());
            TargetProxyCallback targetProxyCallback = new TargetProxyCallback(newLoadBalancer, this.urlMapRequest, this.groupHealthRequest, this.projectBackendServices, this.projectHealthChecks, newLoadBalancer.getName(), this.failedLoadBalancers);
            TargetHttpsProxyCallback targetHttpsProxyCallback = new TargetHttpsProxyCallback(newLoadBalancer, this.urlMapRequest, this.groupHealthRequest, this.projectBackendServices, this.projectHealthChecks, newLoadBalancer.getName(), this.failedLoadBalancers);
            try {
                switch (Utils.getTargetProxyType(forwardingRule.getTarget())) {
                    case HTTP: {
                        this.targetProxyRequest.queue((ComputeRequest)GoogleInternalHttpLoadBalancerCachingAgent.this.getCompute().regionTargetHttpProxies().get(GoogleInternalHttpLoadBalancerCachingAgent.this.getProject(), GoogleInternalHttpLoadBalancerCachingAgent.this.getRegion(), targetProxyName), targetProxyCallback);
                        break;
                    }
                    case HTTPS: {
                        this.targetProxyRequest.queue((ComputeRequest)GoogleInternalHttpLoadBalancerCachingAgent.this.getCompute().regionTargetHttpsProxies().get(GoogleInternalHttpLoadBalancerCachingAgent.this.getProject(), GoogleInternalHttpLoadBalancerCachingAgent.this.getRegion(), targetProxyName), targetHttpsProxyCallback);
                        break;
                    }
                    default: {
                        log.debug("Non-Http target type found for global forwarding rule " + forwardingRule.getName());
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public List<GoogleInternalHttpLoadBalancer> getLoadBalancers() {
            return this.loadBalancers;
        }

        public void setLoadBalancers(List<GoogleInternalHttpLoadBalancer> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        public ForwardingRuleCallbacks(List<GoogleInternalHttpLoadBalancer> loadBalancers, List<String> failedLoadBalancers, GoogleBatchRequest targetProxyRequest, GoogleBatchRequest urlMapRequest, GoogleBatchRequest groupHealthRequest, List<BackendService> projectBackendServices, List<HealthCheck> projectHealthChecks) {
            this.loadBalancers = loadBalancers;
            this.failedLoadBalancers = failedLoadBalancers;
            this.targetProxyRequest = targetProxyRequest;
            this.urlMapRequest = urlMapRequest;
            this.groupHealthRequest = groupHealthRequest;
            this.projectBackendServices = projectBackendServices;
            this.projectHealthChecks = projectHealthChecks;
        }

        public class ForwardingRuleListCallback
        extends JsonBatchCallback<ForwardingRuleList>
        implements FailureLogger {
            public void onSuccess(ForwardingRuleList forwardingRuleList, HttpHeaders responseHeaders) {
                if (forwardingRuleList.getItems() == null) {
                    return;
                }
                forwardingRuleList.getItems().stream().filter(f -> f.getLoadBalancingScheme() != null && f.getLoadBalancingScheme().equals("INTERNAL_MANAGED")).forEach(forwardingRule -> {
                    GoogleTargetProxyType type;
                    GoogleTargetProxyType googleTargetProxyType = type = forwardingRule.getTarget() != null ? Utils.getTargetProxyType(forwardingRule.getTarget()) : null;
                    if (type != GoogleTargetProxyType.HTTP && type != GoogleTargetProxyType.HTTPS) {
                        throw new IllegalArgumentException("Not responsible for on demand caching of load balancers without target proxy or with SSL proxy type.");
                    }
                    ForwardingRuleCallbacks.this.cacheRemainderOfLoadBalancerResourceGraph((ForwardingRule)forwardingRule);
                });
            }

            @Override
            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                log.error(e.getMessage());
            }
        }

        public class ForwardingRuleSingletonCallback
        extends JsonBatchCallback<ForwardingRule> {
            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                if (e.getCode() != 404) {
                    String errorJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)e);
                    log.error(errorJson);
                }
            }

            public void onSuccess(ForwardingRule forwardingRule, HttpHeaders responseHeaders) throws IOException {
                GoogleTargetProxyType type;
                GoogleTargetProxyType googleTargetProxyType = type = forwardingRule.getTarget() != null ? Utils.getTargetProxyType(forwardingRule.getTarget()) : null;
                if (type != GoogleTargetProxyType.HTTP && type != GoogleTargetProxyType.HTTPS) {
                    throw new IllegalArgumentException("Not responsible for on demand caching of load balancers without target proxy or with SSL proxy type.");
                }
                ForwardingRuleCallbacks.this.cacheRemainderOfLoadBalancerResourceGraph(forwardingRule);
            }
        }
    }
}

