/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.security;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AcceleratorTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.consul.config.ConsulConfig;
import com.netflix.spinnaker.clouddriver.google.ComputeVersion;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstanceTypeDisk;
import com.netflix.spinnaker.clouddriver.google.model.GoogleLabeledResource;
import com.netflix.spinnaker.clouddriver.google.security.AccountForClient;
import com.netflix.spinnaker.clouddriver.google.security.GoogleCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleImpersonatedServiceAccountCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleJsonCredentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.moniker.Namer;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleNamedAccountCredentials
extends AbstractAccountCredentials<GoogleCredentials>
implements GroovyObject {
    private static final List<String> SORTED_CPU_PLATFORMS;
    public static final String CREDENTIALS_TYPE = "gce";
    private final String name;
    private final String environment;
    private final String accountType;
    private final String cloudProvider;
    private final List<String> requiredGroupMembership;
    private final Permissions permissions;
    private final GoogleCredentials credentials;
    private final String project;
    private final String xpnHostProject;
    private final String applicationName;
    private final List<String> imageProjects;
    private final ComputeVersion computeVersion;
    private final Map<String, List<String>> regionToZonesMap;
    private final Map<String, Map> locationToInstanceTypesMap;
    private final Map<String, List<String>> locationToCpuPlatformsMap;
    private final List<GoogleInstanceTypeDisk> instanceTypeDisks;
    private final ConsulConfig consulConfig;
    private final Compute compute;
    private final String userDataFile;
    private final List<String> regionsToManage;
    private final Map<String, Map> zoneToAcceleratorTypesMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile, List<String> regionsToManage, Map<String, Map> zoneToAcceleratorTypesMap) {
        String string;
        Compute compute2;
        ConsulConfig consulConfig2;
        ComputeVersion computeVersion2;
        String string2;
        String string3;
        String string4;
        GoogleCredentials googleCredentials;
        Permissions permissions2;
        String string5;
        String string6;
        String string7;
        String string8;
        MetaClass metaClass;
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(GoogleCloudProvider.class);
        this.cloudProvider = ShortTypeHandling.castToString((Object)object);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.name = string8 = name;
        this.environment = string7 = environment;
        this.accountType = string6 = accountType;
        this.cloudProvider = string5 = cloudProvider;
        List<String> list = requiredGroupMembership;
        this.requiredGroupMembership = list;
        this.permissions = permissions2 = permissions;
        this.credentials = googleCredentials = credentials;
        this.project = string4 = project;
        this.xpnHostProject = string3 = xpnHostProject;
        this.applicationName = string2 = applicationName;
        List<String> list2 = imageProjects;
        this.imageProjects = list2;
        this.computeVersion = computeVersion2 = computeVersion;
        Map<String, List<String>> map = regionToZonesMap;
        this.regionToZonesMap = map;
        Map<String, Map> map2 = locationToInstanceTypesMap;
        this.locationToInstanceTypesMap = map2;
        Map<String, List<String>> map3 = locationToCpuPlatformsMap;
        this.locationToCpuPlatformsMap = map3;
        List<GoogleInstanceTypeDisk> list3 = instanceTypeDisks;
        this.instanceTypeDisks = list3;
        this.consulConfig = consulConfig2 = consulConfig;
        this.compute = compute2 = compute;
        this.userDataFile = string = userDataFile;
        List<String> list4 = regionsToManage;
        this.regionsToManage = list4;
        Map<String, Map> map4 = zoneToAcceleratorTypesMap;
        this.zoneToAcceleratorTypesMap = map4;
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile, List<String> regionsToManage) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, userDataFile, regionsToManage, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, userDataFile, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, cloudProvider, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, accountType, ShortTypeHandling.castToString((Object)callSiteArray[1].callGetProperty(GoogleCloudProvider.class)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, environment, null, ShortTypeHandling.castToString((Object)callSiteArray[2].callGetProperty(GoogleCloudProvider.class)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(name, null, null, ShortTypeHandling.castToString((Object)callSiteArray[3].callGetProperty(GoogleCloudProvider.class)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials() {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        this(null, null, null, ShortTypeHandling.castToString((Object)callSiteArray[4].callGetProperty(GoogleCloudProvider.class)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public List<Map> getRegions() {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        Reference regionList = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        if (ScriptBytecodeAdapter.compareNotEqual(this.regionsToManage, null)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(this.regionsToManage))) {
                public final class _getRegions_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getRegions_closure1(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _getRegions_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _getRegions_closure1.$getCallSiteArray();
                        return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].call(it));
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _getRegions_closure1.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getRegions_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "contains";
                        stringArray[1] = "regionsToManage";
                        stringArray[2] = "getKey";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _getRegions_closure1.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_getRegions_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getRegions_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                public final class _getRegions_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference regionList;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _getRegions_closure2(Object _outerInstance, Object _thisObject, Reference regionList) {
                        Reference reference;
                        CallSite[] callSiteArray = _getRegions_closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.regionList = reference = regionList;
                    }

                    public Object doCall(String region, List<String> zones) {
                        CallSite[] callSiteArray = _getRegions_closure2.$getCallSiteArray();
                        return callSiteArray[0].call(this.regionList.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", region, "zones", zones}));
                    }

                    @Generated
                    public Object call(String region, List<String> zones) {
                        CallSite[] callSiteArray = _getRegions_closure2.$getCallSiteArray();
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)region, zones);
                    }

                    @Generated
                    public List getRegionList() {
                        CallSite[] callSiteArray = _getRegions_closure2.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.regionList.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getRegions_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "add";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _getRegions_closure2.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_getRegions_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getRegions_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[6].call(callSiteArray[7].call(this.regionToZonesMap, (Object)new _getRegions_closure1((Object)this, (Object)this)), (Object)new _getRegions_closure2((Object)this, (Object)this, regionList));
            }
        } else {
            public final class _getRegions_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference regionList;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getRegions_closure3(Object _outerInstance, Object _thisObject, Reference regionList) {
                    Reference reference;
                    CallSite[] callSiteArray = _getRegions_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.regionList = reference = regionList;
                }

                public Object doCall(String region, List<String> zones) {
                    CallSite[] callSiteArray = _getRegions_closure3.$getCallSiteArray();
                    return callSiteArray[0].call(this.regionList.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", region, "zones", zones}));
                }

                @Generated
                public Object call(String region, List<String> zones) {
                    CallSite[] callSiteArray = _getRegions_closure3.$getCallSiteArray();
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)region, zones);
                }

                @Generated
                public List getRegionList() {
                    CallSite[] callSiteArray = _getRegions_closure3.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.regionList.get(), List.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getRegions_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "add";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _getRegions_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getRegions_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getRegions_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[8].call(this.regionToZonesMap, (Object)new _getRegions_closure3((Object)this, (Object)this, regionList));
        }
        return (List)regionList.get();
    }

    public String regionFromZone(String zone) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[9].callStatic(GoogleNamedAccountCredentials.class, (Object)zone, this.regionToZonesMap));
    }

    public static String regionFromZone(String zone, Map<String, List<String>> regionToZonesMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)zone, null) || ScriptBytecodeAdapter.compareEqual(regionToZonesMap, null) : ScriptBytecodeAdapter.compareEqual((Object)zone, null) || ScriptBytecodeAdapter.compareEqual(regionToZonesMap, null)) {
            return ShortTypeHandling.castToString(null);
        }
        String region = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call(callSiteArray[11].call(regionToZonesMap)), Iterator.class);
        while (iterator.hasNext()) {
            region = ShortTypeHandling.castToString(iterator.next());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call(callSiteArray[13].call(regionToZonesMap, (Object)region), (Object)zone))) continue;
            return region;
        }
        return ShortTypeHandling.castToString(null);
    }

    public List<String> getZonesFromRegion(String region) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (List)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.compareNotEqual((Object)region, null) && ScriptBytecodeAdapter.compareNotEqual(this.regionToZonesMap, null) ? callSiteArray[14].call(this.regionToZonesMap, (Object)region) : null, List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.compareNotEqual((Object)region, null) && ScriptBytecodeAdapter.compareNotEqual(this.regionToZonesMap, null) ? callSiteArray[15].call(this.regionToZonesMap, (Object)region) : null, List.class);
    }

    private static Map<String, List<String>> queryRegions(Compute compute, String project) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        RegionList regionList = (RegionList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callStatic(GoogleNamedAccountCredentials.class, (Object)compute, (Object)project), RegionList.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callStatic(GoogleNamedAccountCredentials.class, (Object)regionList), Map.class);
        }
        return GoogleNamedAccountCredentials.convertRegionListToMap(regionList);
    }

    @VisibleForTesting
    public static Map<String, List<String>> convertRegionListToMap(RegionList regionList) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _convertRegionListToMap_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _convertRegionListToMap_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _convertRegionListToMap_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Region region) {
                CallSite[] callSiteArray = _convertRegionListToMap_closure4.$getCallSiteArray();
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure12(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(String zone) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        return callSiteArray[0].call(GCEUtil.class, (Object)zone);
                    }

                    @Generated
                    public Object call(String zone) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return callSiteArray[1].callCurrent((GroovyObject)this, (Object)zone);
                        }
                        return this.doCall(zone);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getLocalName";
                        stringArray[1] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure12.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure12.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure12.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[0].callGetProperty((Object)region), callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)region), (Object)new _closure12((Object)this, this.getThisObject()))});
            }

            @Generated
            public Object call(Region region) {
                CallSite[] callSiteArray = _convertRegionListToMap_closure4.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)region);
                }
                return this.doCall(region);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertRegionListToMap_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "collect";
                stringArray[2] = "zones";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _convertRegionListToMap_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_convertRegionListToMap_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _convertRegionListToMap_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].callGetProperty((Object)regionList), (Object)new _convertRegionListToMap_closure4(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class)), Map.class);
    }

    private static RegionList fetchRegions(Compute compute, String project) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        RegionList regionList = (RegionList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[21].call(GoogleExecutor.class), (Object)callSiteArray[22].call(callSiteArray[23].call((Object)compute), (Object)project), (Object)"google.api", (Object)"compute.regions.list", (Object)callSiteArray[24].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[25].callGetProperty(GoogleExecutor.class))), RegionList.class);
        try {
            return regionList;
        }
        catch (IOException ioe) {
            throw (Throwable)callSiteArray[26].callConstructor(RuntimeException.class, callSiteArray[27].call((Object)"Failed loading regions for ", (Object)project), (Object)ioe);
        }
    }

    private static Map<String, Map> queryAcceleratorTypes(Compute compute, String project) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        AcceleratorTypeAggregatedList acceleratorTypeList = (AcceleratorTypeAggregatedList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[29].call(GoogleExecutor.class), (Object)callSiteArray[30].call(callSiteArray[31].call((Object)compute), (Object)project), (Object)"google.api", (Object)"compute.acceleratorTypes.aggregatedList", (Object)callSiteArray[32].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[33].callGetProperty(GoogleExecutor.class))), AcceleratorTypeAggregatedList.class);
        String nextPageToken = ShortTypeHandling.castToString((Object)callSiteArray[34].call((Object)acceleratorTypeList));
        Reference zoneToAcceleratorTypesMap = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[35].callStatic(GoogleNamedAccountCredentials.class, (Object)acceleratorTypeList);
            zoneToAcceleratorTypesMap.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        } else {
            Map<String, Map> map = GoogleNamedAccountCredentials.convertAcceleratorTypeListToMap(acceleratorTypeList);
            zoneToAcceleratorTypesMap.set(map);
        }
        while (DefaultTypeTransformation.booleanUnbox((Object)nextPageToken)) {
            Object object = callSiteArray[36].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[37].call(GoogleExecutor.class), (Object)callSiteArray[38].call(callSiteArray[39].call((Object)compute), (Object)project), (Object)"google.api", (Object)"compute.acceleratorTypes.aggregatedList", (Object)callSiteArray[40].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[41].callGetProperty(GoogleExecutor.class)));
            acceleratorTypeList = (AcceleratorTypeAggregatedList)ScriptBytecodeAdapter.castToType((Object)object, AcceleratorTypeAggregatedList.class);
            Object object2 = callSiteArray[42].call((Object)acceleratorTypeList);
            nextPageToken = ShortTypeHandling.castToString((Object)object2);
            Map subsequentZoneToInstanceTypesMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callStatic(GoogleNamedAccountCredentials.class, (Object)acceleratorTypeList), Map.class);
            public final class _queryAcceleratorTypes_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference zoneToAcceleratorTypesMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryAcceleratorTypes_closure5(Object _outerInstance, Object _thisObject, Reference zoneToAcceleratorTypesMap) {
                    Reference reference;
                    CallSite[] callSiteArray = _queryAcceleratorTypes_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.zoneToAcceleratorTypesMap = reference = zoneToAcceleratorTypesMap;
                }

                public Object doCall(Object zone, Object acceleratorTypes) {
                    CallSite[] callSiteArray = _queryAcceleratorTypes_closure5.$getCallSiteArray();
                    if (ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneToAcceleratorTypesMap.get())) {
                        Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].call(this.zoneToAcceleratorTypesMap.get(), zone)), callSiteArray[3].callGetProperty(acceleratorTypes));
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[4].call(this.zoneToAcceleratorTypesMap.get(), zone), (String)"acceleratorTypes");
                        return object;
                    }
                    Object object = acceleratorTypes;
                    callSiteArray[5].call(this.zoneToAcceleratorTypesMap.get(), zone, object);
                    return object;
                }

                @Generated
                public Object call(Object zone, Object acceleratorTypes) {
                    CallSite[] callSiteArray = _queryAcceleratorTypes_closure5.$getCallSiteArray();
                    return callSiteArray[6].callCurrent((GroovyObject)this, zone, acceleratorTypes);
                }

                @Generated
                public Map getZoneToAcceleratorTypesMap() {
                    CallSite[] callSiteArray = _queryAcceleratorTypes_closure5.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.zoneToAcceleratorTypesMap.get(), Map.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryAcceleratorTypes_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "acceleratorTypes";
                    stringArray[2] = "getAt";
                    stringArray[3] = "acceleratorTypes";
                    stringArray[4] = "getAt";
                    stringArray[5] = "putAt";
                    stringArray[6] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _queryAcceleratorTypes_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_queryAcceleratorTypes_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryAcceleratorTypes_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[44].call((Object)subsequentZoneToInstanceTypesMap, (Object)new _queryAcceleratorTypes_closure5(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, zoneToAcceleratorTypesMap));
        }
        return (Map)zoneToAcceleratorTypesMap.get();
    }

    private static Map<String, Map> queryInstanceTypes(Compute compute, String project, Map<String, List<String>> regionToZonesMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        MachineTypeAggregatedList instanceTypeList = (MachineTypeAggregatedList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[46].call(GoogleExecutor.class), (Object)callSiteArray[47].call(callSiteArray[48].call((Object)compute), (Object)project), (Object)"google.api", (Object)"compute.machineTypes.aggregatedList", (Object)callSiteArray[49].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[50].callGetProperty(GoogleExecutor.class))), MachineTypeAggregatedList.class);
        String nextPageToken = ShortTypeHandling.castToString((Object)callSiteArray[51].call((Object)instanceTypeList));
        Reference zoneToInstanceTypesMap = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[52].callStatic(GoogleNamedAccountCredentials.class, (Object)instanceTypeList);
            zoneToInstanceTypesMap.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        } else {
            Map<String, Map> map = GoogleNamedAccountCredentials.convertInstanceTypeListToMap(instanceTypeList);
            zoneToInstanceTypesMap.set(map);
        }
        while (DefaultTypeTransformation.booleanUnbox((Object)nextPageToken)) {
            Object object = callSiteArray[53].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[54].call(GoogleExecutor.class), (Object)callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call((Object)compute), (Object)project), (Object)nextPageToken), (Object)"google.api", (Object)"compute.machineTypes.aggregatedList", (Object)callSiteArray[58].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[59].callGetProperty(GoogleExecutor.class)));
            instanceTypeList = (MachineTypeAggregatedList)ScriptBytecodeAdapter.castToType((Object)object, MachineTypeAggregatedList.class);
            Object object2 = callSiteArray[60].call((Object)instanceTypeList);
            nextPageToken = ShortTypeHandling.castToString((Object)object2);
            Map subsequentZoneToInstanceTypesMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callStatic(GoogleNamedAccountCredentials.class, (Object)instanceTypeList), Map.class);
            public final class _queryInstanceTypes_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference zoneToInstanceTypesMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryInstanceTypes_closure6(Object _outerInstance, Object _thisObject, Reference zoneToInstanceTypesMap) {
                    Reference reference;
                    CallSite[] callSiteArray = _queryInstanceTypes_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.zoneToInstanceTypesMap = reference = zoneToInstanceTypesMap;
                }

                public Object doCall(Object zone, Object instanceTypes) {
                    CallSite[] callSiteArray = _queryInstanceTypes_closure6.$getCallSiteArray();
                    if (ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneToInstanceTypesMap.get())) {
                        ScriptBytecodeAdapter.setProperty((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].call(this.zoneToInstanceTypesMap.get(), zone)), callSiteArray[3].callGetProperty(instanceTypes)), null, (Object)callSiteArray[4].call(this.zoneToInstanceTypesMap.get(), zone), (String)"instanceTypes");
                        Object object = callSiteArray[5].call(Math.class, callSiteArray[6].callGetProperty(callSiteArray[7].call(this.zoneToInstanceTypesMap.get(), zone)), callSiteArray[8].callGetProperty(instanceTypes));
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[9].call(this.zoneToInstanceTypesMap.get(), zone), (String)"vCpuMax");
                        return object;
                    }
                    Object object = instanceTypes;
                    callSiteArray[10].call(this.zoneToInstanceTypesMap.get(), zone, object);
                    return object;
                }

                @Generated
                public Object call(Object zone, Object instanceTypes) {
                    CallSite[] callSiteArray = _queryInstanceTypes_closure6.$getCallSiteArray();
                    return callSiteArray[11].callCurrent((GroovyObject)this, zone, instanceTypes);
                }

                @Generated
                public Map getZoneToInstanceTypesMap() {
                    CallSite[] callSiteArray = _queryInstanceTypes_closure6.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.zoneToInstanceTypesMap.get(), Map.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryInstanceTypes_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "instanceTypes";
                    stringArray[2] = "getAt";
                    stringArray[3] = "instanceTypes";
                    stringArray[4] = "getAt";
                    stringArray[5] = "max";
                    stringArray[6] = "vCpuMax";
                    stringArray[7] = "getAt";
                    stringArray[8] = "vCpuMax";
                    stringArray[9] = "getAt";
                    stringArray[10] = "putAt";
                    stringArray[11] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[12];
                    _queryInstanceTypes_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_queryInstanceTypes_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryInstanceTypes_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[62].call((Object)subsequentZoneToInstanceTypesMap, (Object)new _queryInstanceTypes_closure6(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, zoneToInstanceTypesMap));
        }
        callSiteArray[63].callStatic(GoogleNamedAccountCredentials.class, (Object)((Map)zoneToInstanceTypesMap.get()), regionToZonesMap);
        return (Map)zoneToInstanceTypesMap.get();
    }

    public static Map<String, Map> convertAcceleratorTypeListToMap(AcceleratorTypeAggregatedList acceleratorTypeList) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _convertAcceleratorTypeListToMap_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _convertAcceleratorTypeListToMap_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _convertAcceleratorTypeListToMap_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object zone, Object acceleratorTypesScopedList) {
                Object object;
                CallSite[] callSiteArray = _convertAcceleratorTypeListToMap_closure7.$getCallSiteArray();
                zone = object = callSiteArray[0].call(GCEUtil.class, zone);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(acceleratorTypesScopedList))) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{zone, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"acceleratorTypes", acceleratorTypesScopedList})});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object zone, Object acceleratorTypesScopedList) {
                CallSite[] callSiteArray = _convertAcceleratorTypeListToMap_closure7.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, zone, acceleratorTypesScopedList);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertAcceleratorTypeListToMap_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "acceleratorTypes";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _convertAcceleratorTypeListToMap_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_convertAcceleratorTypeListToMap_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _convertAcceleratorTypeListToMap_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object zoneToAcceleratorTypesMap = callSiteArray[64].call(callSiteArray[65].callGetProperty((Object)acceleratorTypeList), (Object)new _convertAcceleratorTypeListToMap_closure7(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class));
        return (Map)ScriptBytecodeAdapter.castToType((Object)zoneToAcceleratorTypesMap, Map.class);
    }

    @VisibleForTesting
    public static Map<String, Map> convertInstanceTypeListToMap(MachineTypeAggregatedList instanceTypeList) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _convertInstanceTypeListToMap_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _convertInstanceTypeListToMap_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _convertInstanceTypeListToMap_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object zone, Object machineTypesScopedList) {
                Object object;
                CallSite[] callSiteArray = _convertInstanceTypeListToMap_closure8.$getCallSiteArray();
                zone = object = callSiteArray[0].call(GCEUtil.class, zone);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(machineTypesScopedList))) {
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure13(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                            return callSiteArray[0].callGetProperty(it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "name";
                            return new CallSiteArray(_closure13.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure13.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            return callSiteArray[0].callGetProperty(it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "guestCpus";
                            return new CallSiteArray(_closure14.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure14.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{zone, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTypes", callSiteArray[2].call(callSiteArray[3].callGetProperty(machineTypesScopedList), (Object)new _closure13((Object)this, this.getThisObject())), "vCpuMax", callSiteArray[4].callGetProperty(callSiteArray[5].call(callSiteArray[6].callGetProperty(machineTypesScopedList), (Object)new _closure14((Object)this, this.getThisObject())))})});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object zone, Object machineTypesScopedList) {
                CallSite[] callSiteArray = _convertInstanceTypeListToMap_closure8.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, zone, machineTypesScopedList);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertInstanceTypeListToMap_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "machineTypes";
                stringArray[2] = "collect";
                stringArray[3] = "machineTypes";
                stringArray[4] = "guestCpus";
                stringArray[5] = "max";
                stringArray[6] = "machineTypes";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _convertInstanceTypeListToMap_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_convertInstanceTypeListToMap_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _convertInstanceTypeListToMap_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object zoneToInstanceTypesMap = callSiteArray[66].call(callSiteArray[67].callGetProperty((Object)instanceTypeList), (Object)new _convertInstanceTypeListToMap_closure8(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class));
        return (Map)ScriptBytecodeAdapter.castToType((Object)zoneToInstanceTypesMap, Map.class);
    }

    public static void populateRegionInstanceTypes(Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> regionToZonesMap) {
        Reference locationToInstanceTypesMap2 = new Reference(locationToInstanceTypesMap);
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _populateRegionInstanceTypes_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToInstanceTypesMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _populateRegionInstanceTypes_closure9(Object _outerInstance, Object _thisObject, Reference locationToInstanceTypesMap) {
                Reference reference;
                CallSite[] callSiteArray = _populateRegionInstanceTypes_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.locationToInstanceTypesMap = reference = locationToInstanceTypesMap;
            }

            public Object doCall(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                CallSite[] callSiteArray = _populateRegionInstanceTypes_closure9.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].call(zoneNames2.get()), (Object)3)) {
                    Object object = callSiteArray[1].call(callSiteArray[2].call(zoneNames2.get()), callSiteArray[3].call(callSiteArray[4].call(zoneNames2.get()), (Object)3));
                    zoneNames2.set(object);
                }
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference zoneNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference zoneNames) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.zoneNames = reference = zoneNames;
                    }

                    public Object doCall(Object zone, Object instanceTypesDescriptor) {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneNames.get());
                    }

                    @Generated
                    public Object call(Object zone, Object instanceTypesDescriptor) {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, zone, instanceTypesDescriptor);
                    }

                    @Generated
                    public Object getZoneNames() {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return this.zoneNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "doCall";
                        return new CallSiteArray(_closure15.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure15.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object matchingInstanceTypesDescriptors = callSiteArray[5].call(callSiteArray[6].call(this.locationToInstanceTypesMap.get(), (Object)new _closure15((Object)this, this.getThisObject(), zoneNames2)));
                if (DefaultTypeTransformation.booleanUnbox((Object)matchingInstanceTypesDescriptors)) {
                    public final class _closure16
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure16(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            return callSiteArray[0].callGetProperty(it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "instanceTypes";
                            return new CallSiteArray(_closure16.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure16.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object matchingInstanceTypes = callSiteArray[7].call(matchingInstanceTypesDescriptors, (Object)new _closure16((Object)this, this.getThisObject()));
                    Object firstZoneInstanceTypes = callSiteArray[8].call(matchingInstanceTypes, (Object)0);
                    Object remainingZoneInstanceTypes = callSiteArray[9].call(matchingInstanceTypes, (Object)1);
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure17(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object acc, Object el) {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return callSiteArray[0].call(acc, el);
                        }

                        @Generated
                        public Object call(Object acc, Object el) {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return callSiteArray[1].callCurrent((GroovyObject)this, acc, el);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "intersect";
                            stringArray[1] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure17.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure17.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure17.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object commonInstanceTypes = callSiteArray[10].call(remainingZoneInstanceTypes, firstZoneInstanceTypes, (Object)new _closure17((Object)this, this.getThisObject()));
                    public final class _closure18
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure18(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                            return callSiteArray[0].callGetProperty(it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure18.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "vCpuMax";
                            return new CallSiteArray(_closure18.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure18.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object vCpuMaxInRegion = callSiteArray[11].callGetProperty(callSiteArray[12].call(matchingInstanceTypesDescriptors, (Object)new _closure18((Object)this, this.getThisObject())));
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTypes", commonInstanceTypes, "vCpuMax", vCpuMaxInRegion});
                    callSiteArray[13].call(this.locationToInstanceTypesMap.get(), region, (Object)map);
                    return map;
                }
                return null;
            }

            @Generated
            public Object call(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                CallSite[] callSiteArray = _populateRegionInstanceTypes_closure9.$getCallSiteArray();
                return callSiteArray[14].callCurrent((GroovyObject)this, region, zoneNames2.get());
            }

            @Generated
            public Map getLocationToInstanceTypesMap() {
                CallSite[] callSiteArray = _populateRegionInstanceTypes_closure9.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.locationToInstanceTypesMap.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateRegionInstanceTypes_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "drop";
                stringArray[2] = "sort";
                stringArray[3] = "minus";
                stringArray[4] = "size";
                stringArray[5] = "values";
                stringArray[6] = "findAll";
                stringArray[7] = "collect";
                stringArray[8] = "getAt";
                stringArray[9] = "drop";
                stringArray[10] = "inject";
                stringArray[11] = "vCpuMax";
                stringArray[12] = "min";
                stringArray[13] = "putAt";
                stringArray[14] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _populateRegionInstanceTypes_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_populateRegionInstanceTypes_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _populateRegionInstanceTypes_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[68].call(regionToZonesMap, (Object)new _populateRegionInstanceTypes_closure9(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToInstanceTypesMap2));
    }

    public static Map<String, List<String>> queryCpuPlatforms(Compute compute, String project, Map<String, List<String>> regionToZonesMap) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        Map locationToCpuPlatformsMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(HashMap.class), Map.class);
        ZoneList zoneList = (ZoneList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[71].call(GoogleExecutor.class), (Object)callSiteArray[72].call(callSiteArray[73].call((Object)compute), (Object)project), (Object)"google.api", (Object)"compute.zones.list", (Object)callSiteArray[74].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[75].callGetProperty(GoogleExecutor.class))), ZoneList.class);
        String nextPageToken = ShortTypeHandling.castToString((Object)callSiteArray[76].call((Object)zoneList));
        callSiteArray[77].callStatic(GoogleNamedAccountCredentials.class, (Object)zoneList, (Object)locationToCpuPlatformsMap);
        while (DefaultTypeTransformation.booleanUnbox((Object)nextPageToken)) {
            Object object = callSiteArray[78].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[79].call(GoogleExecutor.class), (Object)callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].call((Object)compute), (Object)project), (Object)nextPageToken), (Object)"google.api", (Object)"compute.zones.list", (Object)callSiteArray[83].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[84].callGetProperty(GoogleExecutor.class)));
            zoneList = (ZoneList)ScriptBytecodeAdapter.castToType((Object)object, ZoneList.class);
            Object object2 = callSiteArray[85].call((Object)zoneList);
            nextPageToken = ShortTypeHandling.castToString((Object)object2);
            callSiteArray[86].callStatic(GoogleNamedAccountCredentials.class, (Object)zoneList, (Object)locationToCpuPlatformsMap);
        }
        callSiteArray[87].callStatic(GoogleNamedAccountCredentials.class, (Object)locationToCpuPlatformsMap, regionToZonesMap);
        return locationToCpuPlatformsMap;
    }

    @VisibleForTesting
    public static void populateLocationToCpuPlatformsMap(ZoneList zoneList, Map<String, List<String>> locationToCpuPlatformsMap) {
        Reference locationToCpuPlatformsMap2 = new Reference(locationToCpuPlatformsMap);
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _populateLocationToCpuPlatformsMap_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToCpuPlatformsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _populateLocationToCpuPlatformsMap_closure10(Object _outerInstance, Object _thisObject, Reference locationToCpuPlatformsMap) {
                Reference reference;
                CallSite[] callSiteArray = _populateLocationToCpuPlatformsMap_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.locationToCpuPlatformsMap = reference = locationToCpuPlatformsMap;
            }

            public Object doCall(Zone zone) {
                CallSite[] callSiteArray = _populateLocationToCpuPlatformsMap_closure10.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty((Object)zone))) {
                    public final class _closure19
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure19(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object a, Object b) {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            return ScriptBytecodeAdapter.compareTo((Object)callSiteArray[0].call(ScriptBytecodeAdapter.getField(_closure19.class, GoogleNamedAccountCredentials.class, (String)"SORTED_CPU_PLATFORMS"), a), (Object)callSiteArray[1].call(ScriptBytecodeAdapter.getField(_closure19.class, GoogleNamedAccountCredentials.class, (String)"SORTED_CPU_PLATFORMS"), b));
                        }

                        @Generated
                        public Object call(Object a, Object b) {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            return callSiteArray[2].callCurrent((GroovyObject)this, a, b);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "indexOf";
                            stringArray[1] = "indexOf";
                            stringArray[2] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[3];
                            _closure19.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure19.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure19.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object object = callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)zone), (Object)new _closure19((Object)this, this.getThisObject()));
                    callSiteArray[3].call(this.locationToCpuPlatformsMap.get(), callSiteArray[4].callGetProperty((Object)zone), object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object call(Zone zone) {
                CallSite[] callSiteArray = _populateLocationToCpuPlatformsMap_closure10.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)zone);
                }
                return this.doCall(zone);
            }

            @Generated
            public Map getLocationToCpuPlatformsMap() {
                CallSite[] callSiteArray = _populateLocationToCpuPlatformsMap_closure10.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.locationToCpuPlatformsMap.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateLocationToCpuPlatformsMap_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "availableCpuPlatforms";
                stringArray[1] = "toSorted";
                stringArray[2] = "availableCpuPlatforms";
                stringArray[3] = "putAt";
                stringArray[4] = "name";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _populateLocationToCpuPlatformsMap_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_populateLocationToCpuPlatformsMap_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _populateLocationToCpuPlatformsMap_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[88].call(callSiteArray[89].call((Object)zoneList), (Object)new _populateLocationToCpuPlatformsMap_closure10(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToCpuPlatformsMap2));
    }

    public static void populateRegionCpuPlatforms(Map<String, List<String>> locationToCpuPlatformsMap, Map<String, List<String>> regionToZonesMap) {
        Reference locationToCpuPlatformsMap2 = new Reference(locationToCpuPlatformsMap);
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        public final class _populateRegionCpuPlatforms_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToCpuPlatformsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _populateRegionCpuPlatforms_closure11(Object _outerInstance, Object _thisObject, Reference locationToCpuPlatformsMap) {
                Reference reference;
                CallSite[] callSiteArray = _populateRegionCpuPlatforms_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.locationToCpuPlatformsMap = reference = locationToCpuPlatformsMap;
            }

            public Object doCall(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                CallSite[] callSiteArray = _populateRegionCpuPlatforms_closure11.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].call(zoneNames2.get()), (Object)3)) {
                    Object object = callSiteArray[1].call(callSiteArray[2].call(zoneNames2.get()), callSiteArray[3].call(callSiteArray[4].call(zoneNames2.get()), (Object)3));
                    zoneNames2.set(object);
                }
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference zoneNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference zoneNames) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.zoneNames = reference = zoneNames;
                    }

                    public Object doCall(Object zone, Object object) {
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        return ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneNames.get());
                    }

                    @Generated
                    public Object call(Object zone, Object object) {
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, zone, object);
                    }

                    @Generated
                    public Object getZoneNames() {
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        return this.zoneNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "doCall";
                        return new CallSiteArray(_closure20.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure20.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object matchingCpuPlatformsLists = callSiteArray[5].call(callSiteArray[6].call(this.locationToCpuPlatformsMap.get(), (Object)new _closure20((Object)this, this.getThisObject(), zoneNames2)));
                if (DefaultTypeTransformation.booleanUnbox((Object)matchingCpuPlatformsLists)) {
                    Object firstZoneCpuPlatforms = callSiteArray[7].call(matchingCpuPlatformsLists, (Object)0);
                    Object remainingZoneCpuPlatforms = callSiteArray[8].call(matchingCpuPlatformsLists, (Object)1);
                    public final class _closure21
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure21(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object acc, Object el) {
                            CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                            return callSiteArray[0].call(acc, el);
                        }

                        @Generated
                        public Object call(Object acc, Object el) {
                            CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                            return callSiteArray[1].callCurrent((GroovyObject)this, acc, el);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure21.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "intersect";
                            stringArray[1] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure21.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure21.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure21.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object commonCpuPlatforms = callSiteArray[9].call(remainingZoneCpuPlatforms, firstZoneCpuPlatforms, (Object)new _closure21((Object)this, this.getThisObject()));
                    if (DefaultTypeTransformation.booleanUnbox((Object)commonCpuPlatforms)) {
                        Object object = commonCpuPlatforms;
                        callSiteArray[10].call(this.locationToCpuPlatformsMap.get(), region, object);
                        return object;
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public Object call(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                CallSite[] callSiteArray = _populateRegionCpuPlatforms_closure11.$getCallSiteArray();
                return callSiteArray[11].callCurrent((GroovyObject)this, region, zoneNames2.get());
            }

            @Generated
            public Map getLocationToCpuPlatformsMap() {
                CallSite[] callSiteArray = _populateRegionCpuPlatforms_closure11.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.locationToCpuPlatformsMap.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateRegionCpuPlatforms_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "drop";
                stringArray[2] = "sort";
                stringArray[3] = "minus";
                stringArray[4] = "size";
                stringArray[5] = "values";
                stringArray[6] = "findAll";
                stringArray[7] = "getAt";
                stringArray[8] = "drop";
                stringArray[9] = "inject";
                stringArray[10] = "putAt";
                stringArray[11] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[12];
                _populateRegionCpuPlatforms_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_populateRegionCpuPlatforms_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _populateRegionCpuPlatforms_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[90].call(regionToZonesMap, (Object)new _populateRegionCpuPlatforms_closure11(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToCpuPlatformsMap2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GoogleNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = GoogleNamedAccountCredentials.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        List list;
        SORTED_CPU_PLATFORMS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"Intel Sandy Bridge", "Intel Ivy Bridge", "Intel Haswell", "Intel Broadwell", "Intel Skylake"});
        Object object = GoogleNamedAccountCredentials.$getCallSiteArray()[91].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public static List<String> getSORTED_CPU_PLATFORMS() {
        return SORTED_CPU_PLATFORMS;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final String getEnvironment() {
        return this.environment;
    }

    @Generated
    public final String getAccountType() {
        return this.accountType;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public final List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    @Generated
    public final Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public final GoogleCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public final String getProject() {
        return this.project;
    }

    @Generated
    public final String getXpnHostProject() {
        return this.xpnHostProject;
    }

    @Generated
    public final String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public final List<String> getImageProjects() {
        return this.imageProjects;
    }

    @Generated
    public final ComputeVersion getComputeVersion() {
        return this.computeVersion;
    }

    @Generated
    public final Map<String, List<String>> getRegionToZonesMap() {
        return this.regionToZonesMap;
    }

    @Generated
    public final Map<String, Map> getLocationToInstanceTypesMap() {
        return this.locationToInstanceTypesMap;
    }

    @Generated
    public final Map<String, List<String>> getLocationToCpuPlatformsMap() {
        return this.locationToCpuPlatformsMap;
    }

    @Generated
    public final List<GoogleInstanceTypeDisk> getInstanceTypeDisks() {
        return this.instanceTypeDisks;
    }

    @Generated
    public final ConsulConfig getConsulConfig() {
        return this.consulConfig;
    }

    @Generated
    public final Compute getCompute() {
        return this.compute;
    }

    @Generated
    public final String getUserDataFile() {
        return this.userDataFile;
    }

    @Generated
    public final List<String> getRegionsToManage() {
        return this.regionsToManage;
    }

    @Generated
    public final Map<String, Map> getZoneToAcceleratorTypesMap() {
        return this.zoneToAcceleratorTypesMap;
    }

    public /* synthetic */ Permissions super$2$getPermissions() {
        return super.getPermissions();
    }

    public /* synthetic */ List super$2$getRequiredGroupMembership() {
        return this.getRequiredGroupMembership();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ID";
        stringArray[1] = "ID";
        stringArray[2] = "ID";
        stringArray[3] = "ID";
        stringArray[4] = "ID";
        stringArray[5] = "isEmpty";
        stringArray[6] = "each";
        stringArray[7] = "findAll";
        stringArray[8] = "each";
        stringArray[9] = "regionFromZone";
        stringArray[10] = "iterator";
        stringArray[11] = "keySet";
        stringArray[12] = "contains";
        stringArray[13] = "get";
        stringArray[14] = "get";
        stringArray[15] = "get";
        stringArray[16] = "fetchRegions";
        stringArray[17] = "convertRegionListToMap";
        stringArray[18] = "collectEntries";
        stringArray[19] = "items";
        stringArray[20] = "timeExecute";
        stringArray[21] = "getRegistry";
        stringArray[22] = "list";
        stringArray[23] = "regions";
        stringArray[24] = "TAG_SCOPE";
        stringArray[25] = "SCOPE_GLOBAL";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "plus";
        stringArray[28] = "timeExecute";
        stringArray[29] = "getRegistry";
        stringArray[30] = "aggregatedList";
        stringArray[31] = "acceleratorTypes";
        stringArray[32] = "TAG_SCOPE";
        stringArray[33] = "SCOPE_GLOBAL";
        stringArray[34] = "getNextPageToken";
        stringArray[35] = "convertAcceleratorTypeListToMap";
        stringArray[36] = "timeExecute";
        stringArray[37] = "getRegistry";
        stringArray[38] = "aggregatedList";
        stringArray[39] = "acceleratorTypes";
        stringArray[40] = "TAG_SCOPE";
        stringArray[41] = "SCOPE_GLOBAL";
        stringArray[42] = "getNextPageToken";
        stringArray[43] = "convertAcceleratorTypeListToMap";
        stringArray[44] = "each";
        stringArray[45] = "timeExecute";
        stringArray[46] = "getRegistry";
        stringArray[47] = "aggregatedList";
        stringArray[48] = "machineTypes";
        stringArray[49] = "TAG_SCOPE";
        stringArray[50] = "SCOPE_GLOBAL";
        stringArray[51] = "getNextPageToken";
        stringArray[52] = "convertInstanceTypeListToMap";
        stringArray[53] = "timeExecute";
        stringArray[54] = "getRegistry";
        stringArray[55] = "setPageToken";
        stringArray[56] = "aggregatedList";
        stringArray[57] = "machineTypes";
        stringArray[58] = "TAG_SCOPE";
        stringArray[59] = "SCOPE_GLOBAL";
        stringArray[60] = "getNextPageToken";
        stringArray[61] = "convertInstanceTypeListToMap";
        stringArray[62] = "each";
        stringArray[63] = "populateRegionInstanceTypes";
        stringArray[64] = "collectEntries";
        stringArray[65] = "items";
        stringArray[66] = "collectEntries";
        stringArray[67] = "items";
        stringArray[68] = "each";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "timeExecute";
        stringArray[71] = "getRegistry";
        stringArray[72] = "list";
        stringArray[73] = "zones";
        stringArray[74] = "TAG_SCOPE";
        stringArray[75] = "SCOPE_GLOBAL";
        stringArray[76] = "getNextPageToken";
        stringArray[77] = "populateLocationToCpuPlatformsMap";
        stringArray[78] = "timeExecute";
        stringArray[79] = "getRegistry";
        stringArray[80] = "setPageToken";
        stringArray[81] = "list";
        stringArray[82] = "zones";
        stringArray[83] = "TAG_SCOPE";
        stringArray[84] = "SCOPE_GLOBAL";
        stringArray[85] = "getNextPageToken";
        stringArray[86] = "populateLocationToCpuPlatformsMap";
        stringArray[87] = "populateRegionCpuPlatforms";
        stringArray[88] = "each";
        stringArray[89] = "getItems";
        stringArray[90] = "each";
        stringArray[91] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[92];
        GoogleNamedAccountCredentials.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GoogleNamedAccountCredentials.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GoogleNamedAccountCredentials.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Builder
    implements GroovyObject {
        private String name;
        private String environment;
        private String accountType;
        private Namer namer;
        private List<String> requiredGroupMembership;
        private Permissions permissions;
        private String project;
        private String xpnHostProject;
        private String applicationName;
        private List<String> imageProjects;
        private ComputeVersion computeVersion;
        private Map<String, List<String>> regionToZonesMap;
        private Map<String, Map> locationToInstanceTypesMap;
        private Map<String, Map> zoneToAcceleratorTypesMap;
        private Map<String, List<String>> locationToCpuPlatformsMap;
        private List<GoogleInstanceTypeDisk> instanceTypeDisks;
        private String jsonKey;
        private String serviceAccountId;
        private String serviceAccountProject;
        private GoogleCredentials credentials;
        private Compute compute;
        private ConsulConfig consulConfig;
        private String userDataFile;
        private List<String> regionsToManage;
        private boolean liveLookupsEnabled;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public Builder() {
            MetaClass metaClass;
            boolean bl;
            List list;
            Map map;
            Map map2;
            Map map3;
            List list2;
            List list3;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.requiredGroupMembership = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Object object = callSiteArray[0].callGetProperty(Permissions.class);
            this.permissions = (Permissions)ScriptBytecodeAdapter.castToType((Object)object, Permissions.class);
            this.imageProjects = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Object object2 = callSiteArray[1].callGetProperty(ComputeVersion.class);
            this.computeVersion = (ComputeVersion)ShortTypeHandling.castToEnum((Object)object2, ComputeVersion.class);
            this.regionToZonesMap = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.locationToInstanceTypesMap = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.zoneToAcceleratorTypesMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.instanceTypeDisks = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.liveLookupsEnabled = bl = true;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder name(String name) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.name = string = name;
            return this;
        }

        public Builder environment(String environment) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.environment = string = environment;
            return this;
        }

        public Builder accountType(String accountType) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.accountType = string = accountType;
            return this;
        }

        public Builder namer(Namer namer) {
            Namer namer2;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.namer = namer2 = namer;
            return this;
        }

        public Builder requiredGroupMembership(List<String> requiredGroupMembership) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = requiredGroupMembership;
            this.requiredGroupMembership = list;
            return this;
        }

        public Builder permissions(Permissions permissions) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)permissions))) {
                Permissions permissions2;
                List list;
                this.requiredGroupMembership = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                this.permissions = permissions2 = permissions;
            }
            return this;
        }

        public Builder project(String project) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.project = string = project;
            return this;
        }

        public Builder applicationName(String applicationName) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.applicationName = string = applicationName;
            return this;
        }

        public Builder imageProjects(List<String> imageProjects) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = imageProjects;
            this.imageProjects = list;
            return this;
        }

        public Builder computeVersion(ComputeVersion version) {
            ComputeVersion computeVersion;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.computeVersion = computeVersion = version;
            return this;
        }

        public Builder jsonKey(String jsonKey) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.jsonKey = string = jsonKey;
            return this;
        }

        public Builder serviceAccountId(String serviceAccountId) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.serviceAccountId = string = serviceAccountId;
            return this;
        }

        public Builder serviceAccountProject(String serviceAccountProject) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.serviceAccountProject = string = serviceAccountProject;
            return this;
        }

        @VisibleForTesting
        public Builder regionToZonesMap(Map<String, List<String>> regionToZonesMap) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Map<String, List<String>> map = regionToZonesMap;
            this.regionToZonesMap = map;
            return this;
        }

        @VisibleForTesting
        public Builder locationToInstanceTypesMap(Map<String, Map> locationToInstanceTypesMap) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Map<String, Map> map = locationToInstanceTypesMap;
            this.locationToInstanceTypesMap = map;
            return this;
        }

        public Builder locationToCpuPlatformsMap(Map<String, List<String>> locationToCpuPlatformsMap) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Map<String, List<String>> map = locationToCpuPlatformsMap;
            this.locationToCpuPlatformsMap = map;
            return this;
        }

        public Builder instanceTypeDisks(List<GoogleInstanceTypeDisk> instanceTypeDisks) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<GoogleInstanceTypeDisk> list = instanceTypeDisks;
            this.instanceTypeDisks = list;
            return this;
        }

        public Builder liveLookupsEnabled(boolean enabled) {
            boolean bl;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.liveLookupsEnabled = bl = enabled;
            return this;
        }

        public Builder consulConfig(ConsulConfig consulConfig) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callGroovyObjectGetPropertySafe((Object)consulConfig))) {
                ConsulConfig consulConfig2;
                callSiteArray[4].call((Object)consulConfig);
                this.consulConfig = consulConfig2 = consulConfig;
            }
            return this;
        }

        public Builder userDataFile(String userDataFile) {
            String string;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.userDataFile = string = userDataFile;
            return this;
        }

        public Builder regionsToManage(List<String> regionsToManage, List<String> defaultRegions) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            List<String> list = ScriptBytecodeAdapter.compareNotEqual(regionsToManage, null) ? regionsToManage : defaultRegions;
            this.regionsToManage = list;
            return this;
        }

        @VisibleForTesting
        public Builder credentials(GoogleCredentials credentials) {
            boolean bl;
            GoogleCredentials googleCredentials;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.credentials = googleCredentials = credentials;
            this.liveLookupsEnabled = bl = false;
            return this;
        }

        @VisibleForTesting
        public Builder compute(Compute compute) {
            boolean bl;
            Compute compute2;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.compute = compute2 = compute;
            this.liveLookupsEnabled = bl = false;
            return this;
        }

        public GoogleNamedAccountCredentials build() {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            GoogleCredentials credentials = this.credentials;
            GStringImpl credInfo = new GStringImpl(new Object[]{this.name}, new String[]{"Google Credentials (", "): "});
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)credentials), null)) {
                if (DefaultTypeTransformation.booleanUnbox((Object)this.jsonKey)) {
                    credInfo = (GString)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)credInfo, (Object)"From JSON key"), GString.class);
                    Object object = callSiteArray[6].callConstructor(GoogleJsonCredentials.class, (Object)this.project, (Object)this.computeVersion, (Object)this.jsonKey);
                    credentials = (GoogleCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)object, GoogleCredentials.class));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccountId) && DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccountProject)) {
                    credInfo = (GString)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call((Object)credInfo, (Object)new GStringImpl(new Object[]{this.serviceAccountProject, this.serviceAccountId}, new String[]{"Impersonating ", "/", ""})), GString.class);
                    Object object = callSiteArray[8].callConstructor(GoogleImpersonatedServiceAccountCredentials.class, (Object)this.project, (Object)this.computeVersion, (Object)this.serviceAccountId, (Object)this.serviceAccountProject);
                    credentials = (GoogleCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)object, GoogleCredentials.class));
                } else {
                    credInfo = (GString)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].call((Object)credInfo, (Object)"Application Default Credentials"), GString.class);
                    Object object = callSiteArray[10].callConstructor(GoogleCredentials.class, (Object)this.project, (Object)this.computeVersion);
                    credentials = (GoogleCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)object, GoogleCredentials.class));
                }
            } else {
                credInfo = (GString)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)credInfo, (Object)"Direct"), GString.class);
            }
            callSiteArray[12].call(ScriptBytecodeAdapter.getField(Builder.class, GoogleNamedAccountCredentials.class, (String)"log"), (Object)credInfo);
            Compute compute = this.compute;
            if (ScriptBytecodeAdapter.compareEqual((Object)compute, null)) {
                Object object = callSiteArray[13].call((Object)credentials, (Object)this.applicationName);
                compute = (Compute)ScriptBytecodeAdapter.castToType((Object)object, Compute.class);
            }
            callSiteArray[14].call(AccountForClient.class, (Object)compute, (Object)this.name);
            if (this.liveLookupsEnabled) {
                Object object = callSiteArray[15].callSafe(callSiteArray[16].call(GoogleExecutor.class, ArrayUtil.createArray((Object)callSiteArray[17].call(GoogleExecutor.class), (Object)callSiteArray[18].call(callSiteArray[19].call((Object)compute), (Object)this.project), (Object)"google.api", (Object)"compute.projects.getXpnHost", (Object)callSiteArray[20].callGetProperty(GoogleExecutor.class), (Object)callSiteArray[21].callGetProperty(GoogleExecutor.class))));
                this.xpnHostProject = ShortTypeHandling.castToString((Object)object);
                Object object2 = callSiteArray[22].callCurrent((GroovyObject)this, (Object)compute, (Object)this.project);
                this.regionToZonesMap = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
                Object object3 = callSiteArray[23].callCurrent((GroovyObject)this, (Object)compute, (Object)this.project, this.regionToZonesMap);
                this.locationToInstanceTypesMap = (Map)ScriptBytecodeAdapter.castToType((Object)object3, Map.class);
                Object object4 = callSiteArray[24].callCurrent((GroovyObject)this, (Object)compute, (Object)this.project);
                this.zoneToAcceleratorTypesMap = (Map)ScriptBytecodeAdapter.castToType((Object)object4, Map.class);
                Object object5 = callSiteArray[25].callCurrent((GroovyObject)this, (Object)compute, (Object)this.project, this.regionToZonesMap);
                this.locationToCpuPlatformsMap = (Map)ScriptBytecodeAdapter.castToType((Object)object5, Map.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.namer) && DefaultTypeTransformation.booleanUnbox((Object)this.name)) {
                callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(NamerRegistry.class), callSiteArray[30].call(GoogleCloudProvider.class)), (Object)this.name), GoogleLabeledResource.class, (Object)this.namer);
            }
            return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(GoogleNamedAccountCredentials.class, ArrayUtil.createArray((Object)this.name, (Object)this.environment, (Object)this.accountType, (Object)callSiteArray[32].callGetProperty(GoogleCloudProvider.class), this.requiredGroupMembership, (Object)this.permissions, (Object)((Object)credentials), (Object)this.project, (Object)this.xpnHostProject, (Object)this.applicationName, this.imageProjects, (Object)((Object)this.computeVersion), this.regionToZonesMap, this.locationToInstanceTypesMap, this.locationToCpuPlatformsMap, this.instanceTypeDisks, (Object)this.consulConfig, (Object)compute, (Object)this.userDataFile, this.regionsToManage, this.zoneToAcceleratorTypesMap)), GoogleNamedAccountCredentials.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, GoogleNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public void setEnvironment(String string) {
            this.environment = string;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public void setAccountType(String string) {
            this.accountType = string;
        }

        @Generated
        public Namer getNamer() {
            return this.namer;
        }

        @Generated
        public void setNamer(Namer namer) {
            this.namer = namer;
        }

        @Generated
        public List<String> getRequiredGroupMembership() {
            return this.requiredGroupMembership;
        }

        @Generated
        public void setRequiredGroupMembership(List<String> list) {
            this.requiredGroupMembership = list;
        }

        @Generated
        public Permissions getPermissions() {
            return this.permissions;
        }

        @Generated
        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public void setProject(String string) {
            this.project = string;
        }

        @Generated
        public String getXpnHostProject() {
            return this.xpnHostProject;
        }

        @Generated
        public void setXpnHostProject(String string) {
            this.xpnHostProject = string;
        }

        @Generated
        public String getApplicationName() {
            return this.applicationName;
        }

        @Generated
        public void setApplicationName(String string) {
            this.applicationName = string;
        }

        @Generated
        public List<String> getImageProjects() {
            return this.imageProjects;
        }

        @Generated
        public void setImageProjects(List<String> list) {
            this.imageProjects = list;
        }

        @Generated
        public ComputeVersion getComputeVersion() {
            return this.computeVersion;
        }

        @Generated
        public void setComputeVersion(ComputeVersion computeVersion) {
            this.computeVersion = computeVersion;
        }

        @Generated
        public Map<String, List<String>> getRegionToZonesMap() {
            return this.regionToZonesMap;
        }

        @Generated
        public void setRegionToZonesMap(Map<String, List<String>> map) {
            this.regionToZonesMap = map;
        }

        @Generated
        public Map<String, Map> getLocationToInstanceTypesMap() {
            return this.locationToInstanceTypesMap;
        }

        @Generated
        public void setLocationToInstanceTypesMap(Map<String, Map> map) {
            this.locationToInstanceTypesMap = map;
        }

        @Generated
        public Map<String, Map> getZoneToAcceleratorTypesMap() {
            return this.zoneToAcceleratorTypesMap;
        }

        @Generated
        public void setZoneToAcceleratorTypesMap(Map<String, Map> map) {
            this.zoneToAcceleratorTypesMap = map;
        }

        @Generated
        public Map<String, List<String>> getLocationToCpuPlatformsMap() {
            return this.locationToCpuPlatformsMap;
        }

        @Generated
        public void setLocationToCpuPlatformsMap(Map<String, List<String>> map) {
            this.locationToCpuPlatformsMap = map;
        }

        @Generated
        public List<GoogleInstanceTypeDisk> getInstanceTypeDisks() {
            return this.instanceTypeDisks;
        }

        @Generated
        public void setInstanceTypeDisks(List<GoogleInstanceTypeDisk> list) {
            this.instanceTypeDisks = list;
        }

        @Generated
        public String getJsonKey() {
            return this.jsonKey;
        }

        @Generated
        public void setJsonKey(String string) {
            this.jsonKey = string;
        }

        @Generated
        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        @Generated
        public void setServiceAccountId(String string) {
            this.serviceAccountId = string;
        }

        @Generated
        public String getServiceAccountProject() {
            return this.serviceAccountProject;
        }

        @Generated
        public void setServiceAccountProject(String string) {
            this.serviceAccountProject = string;
        }

        @Generated
        public GoogleCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public void setCredentials(GoogleCredentials googleCredentials) {
            this.credentials = googleCredentials;
        }

        @Generated
        public Compute getCompute() {
            return this.compute;
        }

        @Generated
        public void setCompute(Compute compute) {
            this.compute = compute;
        }

        @Generated
        public ConsulConfig getConsulConfig() {
            return this.consulConfig;
        }

        @Generated
        public void setConsulConfig(ConsulConfig consulConfig) {
            this.consulConfig = consulConfig;
        }

        @Generated
        public String getUserDataFile() {
            return this.userDataFile;
        }

        @Generated
        public void setUserDataFile(String string) {
            this.userDataFile = string;
        }

        @Generated
        public List<String> getRegionsToManage() {
            return this.regionsToManage;
        }

        @Generated
        public void setRegionsToManage(List<String> list) {
            this.regionsToManage = list;
        }

        @Generated
        public boolean getLiveLookupsEnabled() {
            return this.liveLookupsEnabled;
        }

        @Generated
        public boolean isLiveLookupsEnabled() {
            return this.liveLookupsEnabled;
        }

        @Generated
        public void setLiveLookupsEnabled(boolean bl) {
            this.liveLookupsEnabled = bl;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "EMPTY";
            stringArray[1] = "DEFAULT";
            stringArray[2] = "isRestricted";
            stringArray[3] = "enabled";
            stringArray[4] = "applyDefaults";
            stringArray[5] = "plus";
            stringArray[6] = "<$constructor$>";
            stringArray[7] = "plus";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "plus";
            stringArray[10] = "<$constructor$>";
            stringArray[11] = "plus";
            stringArray[12] = "info";
            stringArray[13] = "getCompute";
            stringArray[14] = "addGoogleClient";
            stringArray[15] = "getName";
            stringArray[16] = "timeExecute";
            stringArray[17] = "getRegistry";
            stringArray[18] = "getXpnHost";
            stringArray[19] = "projects";
            stringArray[20] = "TAG_SCOPE";
            stringArray[21] = "SCOPE_GLOBAL";
            stringArray[22] = "queryRegions";
            stringArray[23] = "queryInstanceTypes";
            stringArray[24] = "queryAcceleratorTypes";
            stringArray[25] = "queryCpuPlatforms";
            stringArray[26] = "setNamer";
            stringArray[27] = "withAccount";
            stringArray[28] = "withProvider";
            stringArray[29] = "lookup";
            stringArray[30] = "getID";
            stringArray[31] = "<$constructor$>";
            stringArray[32] = "ID";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[33];
            Builder.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Builder.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Builder.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

