/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GlobalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;

public final class Instances {
    private final Compute.Instances computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final GlobalGoogleComputeRequestFactory requestFactory;

    Instances(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().instances();
        this.credentials = credentials;
        this.requestFactory = new GlobalGoogleComputeRequestFactory("instances", credentials, operationPoller, registry);
    }

    public PaginatedComputeRequest<Compute.Instances.List, Instance> list(String zone) {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject(), zone).setPageToken(pageToken), "list"), InstanceList::getNextPageToken, InstanceList::getItems);
    }
}

