/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.RegionInstanceGroupManagersAbandonInstancesRequest;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.RegionalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.util.List;

final class RegionGoogleServerGroupManagers
implements GoogleServerGroupManagers {
    private final GoogleNamedAccountCredentials credentials;
    private final RegionalGoogleComputeRequestFactory requestFactory;
    private final Compute.RegionInstanceGroupManagers managers;
    private final String instanceGroupName;
    private final String region;

    RegionGoogleServerGroupManagers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry, String instanceGroupName, String region) {
        this.credentials = credentials;
        this.requestFactory = new RegionalGoogleComputeRequestFactory("regionInstanceGroupManagers", credentials, operationPoller, registry);
        this.managers = credentials.getCompute().regionInstanceGroupManagers();
        this.instanceGroupName = instanceGroupName;
        this.region = region;
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> abandonInstances(List<String> instances) throws IOException {
        RegionInstanceGroupManagersAbandonInstancesRequest request = new RegionInstanceGroupManagersAbandonInstancesRequest();
        request.setInstances(instances);
        return this.requestFactory.wrapOperationRequest(this.managers.abandonInstances(this.credentials.getProject(), this.region, this.instanceGroupName, request), "abandonInstances", this.region);
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> delete() throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.delete(this.credentials.getProject(), this.region, this.instanceGroupName), "delete", this.region);
    }

    @Override
    public GoogleComputeGetRequest<ComputeRequest<InstanceGroupManager>, InstanceGroupManager> get() throws IOException {
        return this.requestFactory.wrapGetRequest(this.managers.get(this.credentials.getProject(), this.region, this.instanceGroupName), "get", this.region);
    }

    @Override
    public GoogleComputeOperationRequest patch(InstanceGroupManager content) throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.patch(this.credentials.getProject(), this.region, this.instanceGroupName, content), "patch", this.region);
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> update(InstanceGroupManager content) throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.update(this.credentials.getProject(), this.region, this.instanceGroupName, content), "update", this.region);
    }
}

