/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.model.Operation;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.util.Map;

final class RegionalGoogleComputeRequestFactory {
    private final String serviceName;
    private final GoogleNamedAccountCredentials credentials;
    private final Registry registry;
    private final GoogleOperationPoller poller;

    RegionalGoogleComputeRequestFactory(String serviceName, GoogleNamedAccountCredentials credentials, GoogleOperationPoller poller, Registry registry) {
        this.serviceName = serviceName;
        this.credentials = credentials;
        this.registry = registry;
        this.poller = poller;
    }

    <RequestT extends ComputeRequest<ResponseT>, ResponseT> GoogleComputeRequest<RequestT, ResponseT> wrapRequest(RequestT request, String api, String region) {
        return new GoogleComputeRequestImpl(request, this.registry, this.getMetricName(api), (Map<String, String>)RegionalGoogleComputeRequestFactory.tags(region));
    }

    <RequestT extends ComputeRequest<ResponseT>, ResponseT> GoogleComputeGetRequest<RequestT, ResponseT> wrapGetRequest(RequestT request, String api, String region) {
        return new GoogleComputeGetRequestImpl(request, this.registry, this.getMetricName(api), (Map<String, String>)RegionalGoogleComputeRequestFactory.tags(region));
    }

    <RequestT extends ComputeRequest<Operation>> GoogleComputeOperationRequest<RequestT> wrapOperationRequest(RequestT request, String api, String region) {
        return new GoogleComputeOperationRequestImpl<RequestT>(request, this.registry, this.getMetricName(api), (Map<String, String>)RegionalGoogleComputeRequestFactory.tags(region), new RegionalOperationWaiter());
    }

    private String getMetricName(String api) {
        return String.join((CharSequence)".", "compute", this.serviceName, api);
    }

    private static ImmutableMap<String, String> tags(String region) {
        return ImmutableMap.builder().put((Object)GoogleExecutor.getTAG_SCOPE(), (Object)GoogleExecutor.getSCOPE_REGIONAL()).put((Object)GoogleExecutor.getTAG_REGION(), (Object)region).build();
    }

    private final class RegionalOperationWaiter
    implements GoogleComputeOperationRequestImpl.OperationWaiter {
        private RegionalOperationWaiter() {
        }

        @Override
        public Operation wait(Operation operation, Task task, String phase) {
            return RegionalGoogleComputeRequestFactory.this.poller.waitForRegionalOperation(RegionalGoogleComputeRequestFactory.this.credentials.getCompute(), RegionalGoogleComputeRequestFactory.this.credentials.getProject(), GCEUtil.getLocalName(operation.getRegion()), operation.getName(), null, task, GCEUtil.getLocalName(operation.getTargetLink()), phase);
        }
    }
}

