/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.AutoscalerList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.ZonalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;

public final class ZoneAutoscalers {
    private final Compute.Autoscalers computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final ZonalGoogleComputeRequestFactory requestFactory;

    ZoneAutoscalers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().autoscalers();
        this.credentials = credentials;
        this.requestFactory = new ZonalGoogleComputeRequestFactory("autoscalers", credentials, operationPoller, registry);
    }

    public GoogleComputeGetRequest<Compute.Autoscalers.Get, Autoscaler> get(String zone, String name) throws IOException {
        return this.requestFactory.wrapGetRequest(this.credentials.getCompute().autoscalers().get(this.credentials.getProject(), zone, name), "get", zone);
    }

    public PaginatedComputeRequest<Compute.Autoscalers.List, Autoscaler> list(String zone) {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject(), zone).setPageToken(pageToken), "list", zone), AutoscalerList::getNextPageToken, AutoscalerList::getItems);
    }
}

