/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.controllers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.compute.model.Image;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.mem.InMemoryCache;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gce/images"})
public class GoogleNamedImageLookupController {
    private final Cache cacheView;
    private final JacksonFactory jsonMapper = new JacksonFactory();
    private final ObjectMapper objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);

    @Autowired
    private GoogleNamedImageLookupController(Cache cacheView) {
        this.cacheView = cacheView;
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public List<NamedImage> list(@RequestParam(required=false) String q, @RequestParam(required=false) String account, HttpServletRequest request) {
        Collection<CacheData> imageCacheData = this.getImageCacheData(account);
        Predicate<NamedImage> queryFilter = this.getQueryFilter(q);
        Predicate<NamedImage> tagFilter = this.getTagFilter(request);
        return imageCacheData.stream().map(this::createNamedImageFromCacheData).filter(queryFilter).filter(tagFilter).sorted(Comparator.comparing(image -> image.imageName)).collect(Collectors.toList());
    }

    private Collection<CacheData> getImageCacheData(String account) {
        String pattern = account == null || account.isEmpty() ? String.format("%s:images:*", GoogleCloudProvider.getID()) : String.format("%s:images:%s:*", GoogleCloudProvider.getID(), account);
        Collection identifiers = this.cacheView.filterIdentifiers(Keys.Namespace.IMAGES.getNs(), pattern);
        return this.cacheView.getAll(Keys.Namespace.IMAGES.getNs(), identifiers, (CacheFilter)RelationshipCacheFilter.none());
    }

    private NamedImage createNamedImageFromCacheData(CacheData cacheDatum) throws RuntimeException {
        try {
            Object hashImage = cacheDatum.getAttributes().get("image");
            Image image = (Image)this.jsonMapper.fromString(this.objectMapper.writeValueAsString(hashImage), Image.class);
            String imageAccount = Keys.parse(cacheDatum.getId()).get("account");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("creationDate", image.get((Object)"creationTimestamp"));
            return new NamedImage(imageAccount, image.getName(), attributes, GoogleNamedImageLookupController.buildTagsMap(image));
        }
        catch (IOException e) {
            throw new RuntimeException("Image deserialization failed");
        }
    }

    private Predicate<NamedImage> getQueryFilter(String q) {
        Predicate<NamedImage> queryFilter = i -> true;
        if (q != null && q.trim().length() > 0) {
            Object glob = q.trim();
            if (!(((String)glob).contains("*") || ((String)glob).contains("?") || ((String)glob).contains("[") || ((String)glob).contains("\\"))) {
                glob = "*" + (String)glob + "*";
            }
            Pattern pattern = new InMemoryCache.Glob((String)glob).toPattern();
            queryFilter = i -> pattern.matcher(i.imageName).matches();
        }
        return queryFilter;
    }

    private Predicate<NamedImage> getTagFilter(HttpServletRequest request) {
        Predicate<NamedImage> tagFilter = i -> true;
        Map<String, String> tagFilters = GoogleNamedImageLookupController.extractTagFilters(request);
        if (!tagFilters.isEmpty()) {
            tagFilter = i -> GoogleNamedImageLookupController.matchesTagFilters(i, tagFilters);
        }
        return tagFilter;
    }

    @VisibleForTesting
    public static Map<String, String> buildTagsMap(Image image) {
        Map labels;
        Map<String, String> tags = new HashMap<String, String>();
        String description = image.getDescription();
        if (description != null) {
            tags = Arrays.stream(description.split(",")).filter(token -> token.contains(": ")).map(token -> token.split(": ", 2)).collect(Collectors.toMap(token -> token[0].trim(), token -> token[1].trim(), (a, b) -> b));
        }
        if ((labels = image.getLabels()) != null) {
            tags.putAll(labels);
        }
        return tags;
    }

    private static List<NamedImage> filter(List<NamedImage> namedImages, Map<String, String> tagFilters) {
        return namedImages.stream().filter(namedImage -> GoogleNamedImageLookupController.matchesTagFilters(namedImage, tagFilters)).collect(Collectors.toList());
    }

    private static boolean matchesTagFilters(NamedImage namedImage, Map<String, String> tagFilters) {
        Map<String, String> tags = namedImage.tags;
        return tagFilters.keySet().stream().allMatch(tag -> tags.containsKey(tag.toLowerCase()) && ((String)tags.get(tag.toLowerCase())).equalsIgnoreCase((String)tagFilters.get(tag)));
    }

    private static Map<String, String> extractTagFilters(HttpServletRequest httpServletRequest) {
        ArrayList parameterNames = Collections.list(httpServletRequest.getParameterNames());
        return parameterNames.stream().filter(Objects::nonNull).filter(parameter -> parameter.toLowerCase().startsWith("tag:")).collect(Collectors.toMap(tagParameter -> tagParameter.replaceAll("tag:", "").toLowerCase(), arg_0 -> ((HttpServletRequest)httpServletRequest).getParameter(arg_0), (a, b) -> b));
    }

    @VisibleForTesting
    public static class NamedImage {
        public String account;
        public String imageName;
        public Map<String, Object> attributes = new HashMap<String, Object>();
        public Map<String, String> tags = new HashMap<String, String>();

        private NamedImage(String account, String imageName, Map<String, Object> attributes, Map<String, String> tags) {
            this.account = account;
            this.imageName = imageName;
            this.attributes = attributes;
            this.tags = tags;
        }
    }
}

