/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleApiException;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleCommonSafeRetry;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import groovy.lang.Closure;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@NonnullByDefault
public class SafeRetry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SafeRetry.class);
    private final GoogleCommonSafeRetry googleCommonSafeRetry;

    @Autowired
    @ParametersAreNullableByDefault
    public SafeRetry(@Value(value="${google.safe-retry-max-wait-interval-ms:60000}") Integer maxWaitInterval, @Value(value="${google.safe-retry-retry-interval-base-sec:2}") Integer retryIntervalBase, @Value(value="${google.safe-retry-jitter-multiplier:1000}") Integer jitterMultiplier, @Value(value="${google.safe-retry-max-retries:10}") Integer maxRetries) {
        this.googleCommonSafeRetry = new GoogleCommonSafeRetry(maxWaitInterval, retryIntervalBase, jitterMultiplier, maxRetries);
    }

    private SafeRetry(GoogleCommonSafeRetry googleCommonSafeRetry) {
        this.googleCommonSafeRetry = googleCommonSafeRetry;
    }

    public static SafeRetry withoutDelay() {
        return new SafeRetry(GoogleCommonSafeRetry.withoutDelay());
    }

    @Nullable
    public <V> V doRetry(Closure<V> operation, String resource, @Nullable Task task, List<Integer> retryCodes, List<Integer> successCodes, Map<String, String> tags, Registry registry) {
        String action = tags.get("action");
        String description = String.format("%s of %s", action, resource);
        if (task != null) {
            task.updateStatus(tags.get("phase"), String.format("Attempting %s...", description));
        }
        try {
            return (V)this.googleCommonSafeRetry.doRetry(operation, description, retryCodes, successCodes, tags, registry);
        }
        catch (GoogleApiException.ResourceInUseException e) {
            log.warn(e.getMessage());
            return null;
        }
        catch (GoogleApiException e) {
            throw new GoogleOperationException(String.format("Failed to " + description, action, resource), e);
        }
    }
}

