/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.googlecommon.deploy.GoogleApiException;
import groovy.lang.Closure;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleInternalHttpLoadBalancerAtomicOperation
extends DeleteGoogleLoadBalancerAtomicOperation {
    private static final String BASE_PHASE = "DELETE_INTERNAL_HTTP_LOAD_BALANCER";
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    private DeleteGoogleLoadBalancerDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    private static void addServicesFromPathMatchers(List<String> backendServiceUrls, List<PathMatcher> pathMatchers) {
        if (pathMatchers == null) {
            return;
        }
        for (PathMatcher pathMatcher : pathMatchers) {
            backendServiceUrls.add(pathMatcher.getDefaultService());
            for (PathRule pathRule : pathMatcher.getPathRules()) {
                backendServiceUrls.add(pathRule.getService());
            }
        }
    }

    public DeleteGoogleInternalHttpLoadBalancerAtomicOperation(DeleteGoogleLoadBalancerDescription description) {
        this.description = description;
    }

    @Override
    public Void operate(List priorOutputs) {
        DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Initializing deletion of Internal HTTP load balancer %s...", this.description.getLoadBalancerName()));
        if (this.description.getCredentials() == null) {
            throw new IllegalArgumentException(String.format("Unable to resolve credentials for Google account '%s'.", this.description.getAccountName()));
        }
        final Compute compute = this.description.getCredentials().getCompute();
        final String project = this.description.getCredentials().getProject();
        final String region = this.description.getRegion();
        String forwardingRuleName = this.description.getLoadBalancerName();
        DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Retrieving forwarding rule " + forwardingRuleName + " in " + region + "...");
        List projectForwardingRules = null;
        try {
            projectForwardingRules = ((ForwardingRuleList)this.timeExecute((AbstractGoogleClientRequest)compute.forwardingRules().list(project, region), "compute.forwardingRules.list", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region})).getItems();
            ForwardingRule forwardingRule = projectForwardingRules.stream().filter(f -> f.getName().equals(forwardingRuleName)).findFirst().orElse(null);
            if (forwardingRule == null) {
                GCEUtil.updateStatusAndThrowNotFoundException("Forwarding rule " + forwardingRuleName + " not found in " + region + " for " + project, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), BASE_PHASE);
            }
            String targetProxyName = GCEUtil.getLocalName(forwardingRule.getTarget());
            DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Retrieving target proxy " + targetProxyName + "...");
            GenericJson retrievedTargetProxy = (GenericJson)GCEUtil.getRegionTargetProxyFromRule(compute, project, region, forwardingRule, BASE_PHASE, this.safeRetry, this);
            if (retrievedTargetProxy == null) {
                GCEUtil.updateStatusAndThrowNotFoundException("Target proxy " + targetProxyName + " not found for " + project + " in " + region, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), BASE_PHASE);
            }
            final String urlMapName = GCEUtil.getLocalName((String)retrievedTargetProxy.get((Object)"urlMap"));
            ArrayList<String> listenersToDelete = new ArrayList<String>();
            for (ForwardingRule rule : projectForwardingRules) {
                if (!rule.getLoadBalancingScheme().equals("INTERNAL_MANAGED")) continue;
                try {
                    GenericJson proxy = (GenericJson)GCEUtil.getRegionTargetProxyFromRule(compute, project, region, rule, BASE_PHASE, this.getSafeRetry(), this);
                    if (!GCEUtil.getLocalName(proxy == null ? null : (String)proxy.get((Object)"urlMap")).equals(urlMapName)) continue;
                    listenersToDelete.add(rule.getName());
                }
                catch (GoogleOperationException e) {
                    if (e.getCause() instanceof GoogleApiException.NotFoundException) continue;
                    throw e;
                }
            }
            DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Retrieving URL map " + urlMapName + "...");
            UrlMapList mapList = (UrlMapList)this.timeExecute((AbstractGoogleClientRequest)compute.regionUrlMaps().list(project, region), "compute.regionUrlMaps.list", new String[]{TAG_SCOPE, SCOPE_REGIONAL});
            List projectUrlMaps = mapList.getItems();
            UrlMap urlMap = projectUrlMaps.stream().filter(u -> u.getName().equals(urlMapName)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("urlMap %s not found.", urlMapName)));
            projectUrlMaps.removeIf(u -> u.getName().equals(urlMapName));
            ImmutableList backendServiceUrls = new ArrayList();
            backendServiceUrls.add(urlMap.getDefaultService());
            DeleteGoogleInternalHttpLoadBalancerAtomicOperation.addServicesFromPathMatchers(backendServiceUrls, urlMap.getPathMatchers());
            backendServiceUrls = ImmutableSet.copyOf(backendServiceUrls).asList();
            HashSet healthCheckUrls = new HashSet();
            for (Object backendServiceUrl : backendServiceUrls) {
                final String backendServiceName = GCEUtil.getLocalName((String)backendServiceUrl);
                DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Retrieving backend service " + backendServiceName + " in " + region + "...");
                BackendService backendService = this.safeRetry.doRetry(new Closure<BackendService>((Object)this, (Object)this){

                    public BackendService call() {
                        try {
                            return (BackendService)DeleteGoogleInternalHttpLoadBalancerAtomicOperation.this.timeExecute((AbstractGoogleClientRequest)compute.regionBackendServices().get(project, region, backendServiceName), "compute.regionBackendServices.get", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_REGIONAL});
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }, "Region Backend service " + backendServiceName, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), (List<Integer>)ImmutableList.of((Object)400, (Object)403, (Object)412), new ArrayList<Integer>(), (Map<String, String>)ImmutableMap.of((Object)"action", (Object)"get", (Object)"phase", (Object)BASE_PHASE, (Object)"operation", (Object)"compute.backendServices.get", (Object)TAG_SCOPE, (Object)SCOPE_REGIONAL, (Object)TAG_REGION, (Object)region), this.getRegistry());
                if (backendService == null) continue;
                if (backendService.getBackends() != null && backendService.getBackends().size() > 0) {
                    DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Server groups still associated with Internal Http(s) load balancer " + this.description.getLoadBalancerName() + ". Failing...");
                    throw new IllegalStateException("Server groups still associated with Internal Http(s) load balancer: " + this.description.getLoadBalancerName() + ".");
                }
                healthCheckUrls.addAll(backendService.getHealthChecks());
            }
            Long timeoutSeconds = this.description.getDeleteOperationTimeoutSeconds();
            for (String ruleName : listenersToDelete) {
                DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deleting listener " + ruleName + " in " + region + "...");
                Operation operation = GCEUtil.deleteRegionalListener(compute, project, region, ruleName, BASE_PHASE, this.getSafeRetry(), this);
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, operation.getName(), timeoutSeconds, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "listener " + ruleName, BASE_PHASE);
            }
            DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deleting URL map " + urlMapName + " in " + region + "...");
            Operation deleteUrlMapOperation = this.safeRetry.doRetry(new Closure<Operation>((Object)this, (Object)this){

                public Operation call() {
                    try {
                        return (Operation)DeleteGoogleInternalHttpLoadBalancerAtomicOperation.this.timeExecute((AbstractGoogleClientRequest)compute.regionUrlMaps().delete(project, region, urlMapName), "compute.regionUrlMaps.delete", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_REGIONAL, GoogleExecutorTraits.TAG_REGION, region});
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }, "Url map " + urlMapName, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), (List<Integer>)ImmutableList.of((Object)400, (Object)403, (Object)412), (List<Integer>)ImmutableList.of((Object)404), (Map<String, String>)ImmutableMap.of((Object)"action", (Object)"delete", (Object)"phase", (Object)BASE_PHASE, (Object)"operation", (Object)"compute.regionUrlMaps.delete", (Object)TAG_SCOPE, (Object)SCOPE_REGIONAL, (Object)TAG_REGION, (Object)region), this.getRegistry());
            this.googleOperationPoller.waitForRegionalOperation(compute, project, region, deleteUrlMapOperation.getName(), timeoutSeconds, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "Regional url map " + urlMapName, BASE_PHASE);
            ArrayList<BackendServiceAsyncDeleteOperation> deleteBackendServiceAsyncOperations = new ArrayList<BackendServiceAsyncDeleteOperation>();
            for (String backendServiceUrl : backendServiceUrls) {
                final String backendServiceName = GCEUtil.getLocalName(backendServiceUrl);
                Operation deleteBackendServiceOp = GCEUtil.deleteIfNotInUse(new Closure<Operation>((Object)this, (Object)this){

                    public Operation call() {
                        try {
                            return (Operation)DeleteGoogleInternalHttpLoadBalancerAtomicOperation.this.timeExecute((AbstractGoogleClientRequest)compute.regionBackendServices().delete(project, region, backendServiceName), "compute.regionBackendServices.delete", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_REGIONAL, GoogleExecutorTraits.TAG_REGION, region});
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }, "Backend service " + backendServiceName, project, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), (Map)ImmutableMap.of((Object)"action", (Object)"delete", (Object)"operation", (Object)"compute.regionBackendServices.delete", (Object)"phase", (Object)BASE_PHASE, (Object)TAG_SCOPE, (Object)SCOPE_REGIONAL, (Object)TAG_REGION, (Object)region), this.safeRetry, this);
                if (deleteBackendServiceOp == null) continue;
                deleteBackendServiceAsyncOperations.add(new BackendServiceAsyncDeleteOperation(backendServiceName, deleteBackendServiceOp.getName()));
            }
            for (BackendServiceAsyncDeleteOperation asyncOperation : deleteBackendServiceAsyncOperations) {
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, asyncOperation.getOperationName(), timeoutSeconds, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "Region backend service " + asyncOperation.getBackendServiceName(), BASE_PHASE);
            }
            if (this.description.getDeleteHealthChecks().booleanValue()) {
                ArrayList<HealthCheckAsyncDeleteOperation> deleteHealthCheckAsyncOperations = new ArrayList<HealthCheckAsyncDeleteOperation>();
                for (String healthCheckUrl : healthCheckUrls) {
                    final String healthCheckName = GCEUtil.getLocalName(healthCheckUrl);
                    Operation deleteHealthCheckOp = GCEUtil.deleteIfNotInUse(new Closure<Operation>((Object)this, (Object)this){

                        public Operation call() {
                            try {
                                return (Operation)DeleteGoogleInternalHttpLoadBalancerAtomicOperation.this.timeExecute((AbstractGoogleClientRequest)compute.regionHealthChecks().delete(project, region, healthCheckName), "compute.regionHealthChecks.delete", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_REGIONAL, GoogleExecutorTraits.TAG_REGION, region});
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    }, "Region Http health check " + healthCheckName, project, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), (Map)ImmutableMap.of((Object)"action", (Object)"delete", (Object)"operation", (Object)"compute.regionHealthChecks.delete", (Object)"phase", (Object)BASE_PHASE, (Object)TAG_SCOPE, (Object)SCOPE_REGIONAL, (Object)TAG_REGION, (Object)region), this.safeRetry, this);
                    if (deleteHealthCheckOp == null) continue;
                    deleteHealthCheckAsyncOperations.add(new HealthCheckAsyncDeleteOperation(healthCheckName, deleteHealthCheckOp.getName()));
                }
                for (HealthCheckAsyncDeleteOperation asyncOperation : deleteHealthCheckAsyncOperations) {
                    this.googleOperationPoller.waitForRegionalOperation(compute, project, region, asyncOperation.getOperationName(), timeoutSeconds, DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region health check " + asyncOperation.getHealthCheckName(), BASE_PHASE);
                }
            }
            DeleteGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Done deleting internal http load balancer " + this.description.getLoadBalancerName() + " in " + region + ".");
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public static class BackendServiceAsyncDeleteOperation {
        private String backendServiceName;
        private String operationName;

        public BackendServiceAsyncDeleteOperation(String backendServiceName, String operationName) {
            this.backendServiceName = backendServiceName;
            this.operationName = operationName;
        }

        public String getBackendServiceName() {
            return this.backendServiceName;
        }

        public String getOperationName() {
            return this.operationName;
        }
    }

    public static class HealthCheckAsyncDeleteOperation {
        private String healthCheckName;
        private String operationName;

        public HealthCheckAsyncDeleteOperation(String healthCheckName, String operationName) {
            this.healthCheckName = healthCheckName;
            this.operationName = operationName;
        }

        public String getHealthCheckName() {
            return this.healthCheckName;
        }

        public String getOperationName() {
            return this.operationName;
        }
    }
}

