/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ConnectionDraining;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HealthCheck;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapReference;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.UpsertGoogleLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancedBackend;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleHttpLoadBalancerAtomicOperation
extends UpsertGoogleLoadBalancerAtomicOperation {
    private static final String BASE_PHASE = "UPSERT_HTTP_LOAD_BALANCER";
    private static final String PATH_MATCHER_PREFIX = "pm";
    public static final String TARGET_HTTP_PROXY_NAME_PREFIX = "target-http-proxy";
    public static final String TARGET_HTTPS_PROXY_NAME_PREFIX = "target-https-proxy";
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private AtomicOperationsRegistry atomicOperationsRegistry;
    @Autowired
    private OrchestrationProcessor orchestrationProcessor;
    @Autowired
    private SafeRetry safeRetry;
    private final UpsertGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UpsertGoogleHttpLoadBalancerAtomicOperation(UpsertGoogleLoadBalancerDescription description) {
        UpsertGoogleLoadBalancerDescription upsertGoogleLoadBalancerDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = UpsertGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        CallSite[] callSiteArray = UpsertGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map operate(List priorOutputs) {
        CallSite[] callSiteArray = UpsertGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        Object httpLoadBalancer = callSiteArray[2].callConstructor(GoogleHttpLoadBalancer.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[3].callGroovyObjectGetProperty((Object)this.description), "urlMapName", callSiteArray[4].callGroovyObjectGetProperty((Object)this.description), "defaultService", callSiteArray[5].callGroovyObjectGetProperty((Object)this.description), "hostRules", callSiteArray[6].callGroovyObjectGetProperty((Object)this.description), "certificate", callSiteArray[7].callGroovyObjectGetProperty((Object)this.description), "ipAddress", callSiteArray[8].callGroovyObjectGetProperty((Object)this.description), "ipProtocol", callSiteArray[9].callGroovyObjectGetProperty((Object)this.description), "portRange", callSiteArray[10].callGroovyObjectGetProperty((Object)this.description)}));
        Object httpLoadBalancerName = callSiteArray[11].callGetProperty(httpLoadBalancer);
        callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Initializing upsert of HTTP load balancer ", "..."}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this.description))) {
            throw (Throwable)callSiteArray[15].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[16].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."}));
        }
        Reference compute = new Reference(callSiteArray[17].callGetProperty(callSiteArray[18].callGroovyObjectGetProperty((Object)this.description)));
        Reference project = new Reference(callSiteArray[19].callGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)this.description)));
        Reference healthCheckExistsSet = new Reference((Object)((HashSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class)));
        Reference healthCheckNeedsUpdatedSet = new Reference((Object)((HashSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class)));
        Reference serviceExistsSet = new Reference((Object)((HashSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class)));
        Reference serviceNeedsUpdatedSet = new Reference((Object)((HashSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class)));
        Boolean urlMapExists = null;
        Boolean targetProxyExists = false;
        Boolean targetProxyNeedsUpdated = false;
        Boolean forwardingRuleExists = null;
        List backendServicesFromDescription = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(callSiteArray[22].call(Utils.class, callSiteArray[23].callGetProperty(httpLoadBalancer))), List.class);
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "healthCheck";
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List healthChecksFromDescription = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].call((Object)backendServicesFromDescription, (Object)new _operate_closure1(this, this))), List.class);
        Object object = callSiteArray[26].callGetPropertySafe(httpLoadBalancer);
        String urlMapName = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : httpLoadBalancerName));
        Set legacyHealthChecks = (Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[27].call(callSiteArray[28].callCurrent((GroovyObject)this, callSiteArray[29].call(callSiteArray[30].call(compute.get()), project.get()), (Object)"compute.httpHealthChecks.list", callSiteArray[31].callGroovyObjectGetProperty((Object)this), callSiteArray[32].callGroovyObjectGetProperty((Object)this))), Set.class);
        Reference existingHealthChecks = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[33].call(callSiteArray[34].callCurrent((GroovyObject)this, callSiteArray[35].call(callSiteArray[36].call(compute.get()), project.get()), (Object)"compute.healthChecks.list", callSiteArray[37].callGroovyObjectGetProperty((Object)this), callSiteArray[38].callGroovyObjectGetProperty((Object)this))), Set.class)));
        Reference existingServices = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[39].call(callSiteArray[40].callCurrent((GroovyObject)this, callSiteArray[41].call(callSiteArray[42].call(compute.get()), project.get()), (Object)"compute.backendServices.list", callSiteArray[43].callGroovyObjectGetProperty((Object)this), callSiteArray[44].callGroovyObjectGetProperty((Object)this))), Set.class)));
        Reference existingUrlMap = new Reference(null);
        try {
            existingUrlMap.set((Object)((UrlMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callCurrent((GroovyObject)this, callSiteArray[46].call(callSiteArray[47].call(compute.get()), project.get(), (Object)urlMapName), (Object)"compute.urlMaps.get", callSiteArray[48].callGroovyObjectGetProperty((Object)this), callSiteArray[49].callGroovyObjectGetProperty((Object)this)), UrlMap.class)));
        }
        catch (GoogleJsonResponseException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[50].call((Object)e), (Object)404)) {
                throw (Throwable)e;
            }
        }
        urlMapExists = (Boolean)ScriptBytecodeAdapter.asType((Object)((UrlMap)existingUrlMap.get()), Boolean.class);
        ForwardingRule existingRule = null;
        try {
            existingRule = (ForwardingRule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, callSiteArray[52].call(callSiteArray[53].call(compute.get()), project.get(), httpLoadBalancerName), (Object)"compute.globalForwardingRules.get", callSiteArray[54].callGroovyObjectGetProperty((Object)this), callSiteArray[55].callGroovyObjectGetProperty((Object)this)), ForwardingRule.class);
        }
        catch (GoogleJsonResponseException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[56].call((Object)e), (Object)404)) {
                throw (Throwable)e;
            }
        }
        forwardingRuleExists = (Boolean)ScriptBytecodeAdapter.asType(existingRule, Boolean.class);
        Object existingProxy = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)forwardingRuleExists)) {
            String targetProxyName = ShortTypeHandling.castToString((Object)callSiteArray[57].call(GCEUtil.class, callSiteArray[58].call((Object)existingRule)));
            Object object2 = callSiteArray[59].call(Utils.class, callSiteArray[60].call((Object)existingRule));
            if (ScriptBytecodeAdapter.isCase((Object)object2, (Object)callSiteArray[61].callGetProperty(GoogleTargetProxyType.class))) {
                existingProxy = callSiteArray[62].callCurrent((GroovyObject)this, callSiteArray[63].call(callSiteArray[64].call(compute.get()), project.get(), (Object)targetProxyName), (Object)"compute.targetHttpProxies.get", callSiteArray[65].callGroovyObjectGetProperty((Object)this), callSiteArray[66].callGroovyObjectGetProperty((Object)this));
            } else if (ScriptBytecodeAdapter.isCase((Object)object2, (Object)callSiteArray[67].callGetProperty(GoogleTargetProxyType.class))) {
                existingProxy = callSiteArray[68].callCurrent((GroovyObject)this, callSiteArray[69].call(callSiteArray[70].call(compute.get()), project.get(), (Object)targetProxyName), (Object)"compute.targetHttpsProxies.get", callSiteArray[71].callGroovyObjectGetProperty((Object)this), callSiteArray[72].callGroovyObjectGetProperty((Object)this));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGetProperty(httpLoadBalancer))) {
                    throw (Throwable)callSiteArray[74].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"", " is an Https load balancer, but the upsert description does not contain a certificate."}));
                }
                targetProxyNeedsUpdated = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[75].call(GCEUtil.class, callSiteArray[76].call(callSiteArray[77].callSafe(existingProxy), (Object)0)), (Object)callSiteArray[78].call(GCEUtil.class, callSiteArray[79].call(GCEUtil.class, project.get(), callSiteArray[80].callGetProperty(httpLoadBalancer))));
            } else {
                Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[81].call((Object)log)) ? callSiteArray[82].call((Object)log, (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"Unexpected target proxy type for ", "."})) : null;
            }
            targetProxyExists = (Boolean)ScriptBytecodeAdapter.asType(existingProxy, Boolean.class);
            if (DefaultTypeTransformation.booleanUnbox(existingProxy) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[83].call(GCEUtil.class, callSiteArray[84].call(existingProxy)), (Object)callSiteArray[85].callGroovyObjectGetProperty((Object)this.description))) {
                throw (Throwable)callSiteArray[86].callConstructor(IllegalStateException.class, callSiteArray[87].call((Object)new GStringImpl(new Object[]{callSiteArray[88].call((Object)existingRule), callSiteArray[89].call(GCEUtil.class, callSiteArray[90].call(existingProxy))}, new String[]{"Listener with name ", " already exists and points to url map: ", ","}), (Object)new GStringImpl(new Object[]{callSiteArray[91].callGroovyObjectGetProperty((Object)this.description)}, new String[]{" which is different from the description url map: ", "."})));
            }
        }
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_operate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[92].call((Object)healthChecksFromDescription), (Object)callSiteArray[93].call(callSiteArray[94].call((Object)healthChecksFromDescription, (Object)false, (Object)new _operate_closure2(this, this))))) {
            throw (Throwable)callSiteArray[95].callConstructor(GoogleOperationException.class, callSiteArray[96].call((Object)"Duplicate health checks with different attributes in the description. ", (Object)"Please specify one object per named health check."));
        }
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingHealthChecks;
            private /* synthetic */ Reference healthCheckExistsSet;
            private /* synthetic */ Reference healthCheckNeedsUpdatedSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference existingHealthChecks, Reference healthCheckExistsSet, Reference healthCheckNeedsUpdatedSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingHealthChecks = reference3 = existingHealthChecks;
                this.healthCheckExistsSet = reference2 = healthCheckExistsSet;
                this.healthCheckNeedsUpdatedSet = reference = healthCheckNeedsUpdatedSet;
            }

            public Object doCall(GoogleHealthCheck healthCheck) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                Reference healthCheckName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)healthCheck)));
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference healthCheckName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure14(Object _outerInstance, Object _thisObject, Reference healthCheckName) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.healthCheckName = reference = healthCheckName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.healthCheckName.get());
                    }

                    @Generated
                    public String getHealthCheckName() {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.healthCheckName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "name";
                        return new CallSiteArray(_closure14.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure14.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object existingHealthCheck = callSiteArray[1].call(this.existingHealthChecks.get(), (Object)new _closure14((Object)this, this.getThisObject(), healthCheckName));
                if (DefaultTypeTransformation.booleanUnbox((Object)existingHealthCheck)) {
                    callSiteArray[2].call(this.healthCheckExistsSet.get(), callSiteArray[3].callGroovyObjectGetProperty((Object)healthCheck));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(GCEUtil.class, existingHealthCheck, (Object)healthCheck))) {
                        return callSiteArray[5].call(this.healthCheckNeedsUpdatedSet.get(), callSiteArray[6].callGroovyObjectGetProperty((Object)healthCheck));
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public Object call(GoogleHealthCheck healthCheck) {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)healthCheck);
            }

            @Generated
            public Set getExistingHealthChecks() {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.existingHealthChecks.get(), Set.class);
            }

            @Generated
            public HashSet getHealthCheckExistsSet() {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.healthCheckExistsSet.get(), HashSet.class);
            }

            @Generated
            public HashSet getHealthCheckNeedsUpdatedSet() {
                CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.healthCheckNeedsUpdatedSet.get(), HashSet.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "find";
                stringArray[2] = "add";
                stringArray[3] = "name";
                stringArray[4] = "healthCheckShouldBeUpdated";
                stringArray[5] = "add";
                stringArray[6] = "name";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _operate_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[97].call((Object)healthChecksFromDescription, (Object)new _operate_closure3(this, this, existingHealthChecks, healthCheckExistsSet, healthCheckNeedsUpdatedSet));
        public final class _operate_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_operate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[98].call((Object)backendServicesFromDescription), (Object)callSiteArray[99].call(callSiteArray[100].call((Object)backendServicesFromDescription, (Object)false, (Object)new _operate_closure4(this, this))))) {
            throw (Throwable)callSiteArray[101].callConstructor(GoogleOperationException.class, callSiteArray[102].call((Object)"Duplicate backend services with different attributes in the description. ", (Object)"Please specify one object per named backend service."));
        }
        Object object4 = ScriptBytecodeAdapter.getPropertySpreadSafe(UpsertGoogleHttpLoadBalancerAtomicOperation.class, (Object)legacyHealthChecks, (String)"name");
        Reference legacyHealthCheckNames = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class)));
        public final class _operate_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingServices;
            private /* synthetic */ Reference serviceExistsSet;
            private /* synthetic */ Reference legacyHealthCheckNames;
            private /* synthetic */ Reference serviceNeedsUpdatedSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure5(Object _outerInstance, Object _thisObject, Reference existingServices, Reference serviceExistsSet, Reference legacyHealthCheckNames, Reference serviceNeedsUpdatedSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.existingServices = reference4 = existingServices;
                this.serviceExistsSet = reference3 = serviceExistsSet;
                this.legacyHealthCheckNames = reference2 = legacyHealthCheckNames;
                this.serviceNeedsUpdatedSet = reference = serviceNeedsUpdatedSet;
            }

            public Object doCall(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                Reference backendServiceName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)backendService)));
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServiceName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference backendServiceName) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.backendServiceName = reference = backendServiceName;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.backendServiceName.get());
                    }

                    @Generated
                    public String getBackendServiceName() {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.backendServiceName.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "name";
                        return new CallSiteArray(_closure15.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure15.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object existingService = callSiteArray[1].call(this.existingServices.get(), (Object)new _closure15((Object)this, this.getThisObject(), backendServiceName));
                if (DefaultTypeTransformation.booleanUnbox((Object)existingService)) {
                    callSiteArray[2].call(this.serviceExistsSet.get(), callSiteArray[3].callGroovyObjectGetProperty((Object)backendService));
                    public final class _closure16
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure16(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            return callSiteArray[0].call(GCEUtil.class, it);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "getLocalName";
                            return new CallSiteArray(_closure16.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure16.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Boolean differentHealthChecks = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[4].call(callSiteArray[5].call(existingService), (Object)new _closure16((Object)this, this.getThisObject())), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[6].callGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)backendService))}));
                    Boolean updateFromLegacyHealthCheck = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call(this.legacyHealthCheckNames.get(), callSiteArray[9].callGetProperty(callSiteArray[10].callGroovyObjectGetProperty((Object)backendService))), Boolean.class);
                    Boolean differentSessionAffinity = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[11].call(GoogleSessionAffinity.class, callSiteArray[12].call(existingService)), (Object)callSiteArray[13].callGroovyObjectGetProperty((Object)backendService));
                    Boolean differentSessionCookieTtl = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[14].call(existingService), (Object)callSiteArray[15].callGroovyObjectGetProperty((Object)backendService));
                    Boolean differentCDN = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].call(existingService), (Object)callSiteArray[17].callGroovyObjectGetProperty((Object)backendService));
                    Boolean differentPortName = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[18].call(existingService), (Object)callSiteArray[19].callGroovyObjectGetProperty((Object)backendService));
                    Boolean differentConnectionDraining = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[20].callSafe(callSiteArray[21].call(existingService)), (Object)callSiteArray[22].callGroovyObjectGetPropertySafe((Object)backendService));
                    if (DefaultTypeTransformation.booleanUnbox((Object)differentHealthChecks) || DefaultTypeTransformation.booleanUnbox((Object)differentSessionAffinity) || DefaultTypeTransformation.booleanUnbox((Object)differentSessionCookieTtl) || DefaultTypeTransformation.booleanUnbox((Object)differentCDN) || DefaultTypeTransformation.booleanUnbox((Object)differentPortName) || DefaultTypeTransformation.booleanUnbox((Object)differentConnectionDraining) || DefaultTypeTransformation.booleanUnbox((Object)updateFromLegacyHealthCheck)) {
                        return callSiteArray[23].call(this.serviceNeedsUpdatedSet.get(), callSiteArray[24].callGroovyObjectGetProperty((Object)backendService));
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return callSiteArray[25].callCurrent((GroovyObject)this, (Object)backendService);
            }

            @Generated
            public Set getExistingServices() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.existingServices.get(), Set.class);
            }

            @Generated
            public HashSet getServiceExistsSet() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.serviceExistsSet.get(), HashSet.class);
            }

            @Generated
            public List getLegacyHealthCheckNames() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.legacyHealthCheckNames.get(), List.class);
            }

            @Generated
            public HashSet getServiceNeedsUpdatedSet() {
                CallSite[] callSiteArray = _operate_closure5.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.serviceNeedsUpdatedSet.get(), HashSet.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "find";
                stringArray[2] = "add";
                stringArray[3] = "name";
                stringArray[4] = "collect";
                stringArray[5] = "getHealthChecks";
                stringArray[6] = "name";
                stringArray[7] = "healthCheck";
                stringArray[8] = "contains";
                stringArray[9] = "name";
                stringArray[10] = "healthCheck";
                stringArray[11] = "valueOf";
                stringArray[12] = "getSessionAffinity";
                stringArray[13] = "sessionAffinity";
                stringArray[14] = "getAffinityCookieTtlSec";
                stringArray[15] = "affinityCookieTtlSec";
                stringArray[16] = "getEnableCDN";
                stringArray[17] = "enableCDN";
                stringArray[18] = "getPortName";
                stringArray[19] = "portName";
                stringArray[20] = "getDrainingTimeoutSec";
                stringArray[21] = "getConnectionDraining";
                stringArray[22] = "connectionDrainingTimeoutSec";
                stringArray[23] = "add";
                stringArray[24] = "name";
                stringArray[25] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[26];
                _operate_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[103].call((Object)backendServicesFromDescription, (Object)new _operate_closure5(this, this, existingServices, serviceExistsSet, legacyHealthCheckNames, serviceNeedsUpdatedSet));
        public final class _operate_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthCheckExistsSet;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference healthCheckNeedsUpdatedSet;
            private /* synthetic */ Reference existingHealthChecks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure6(Object _outerInstance, Object _thisObject, Reference healthCheckExistsSet, Reference compute, Reference project, Reference healthCheckNeedsUpdatedSet, Reference existingHealthChecks) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.healthCheckExistsSet = reference5 = healthCheckExistsSet;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.healthCheckNeedsUpdatedSet = reference2 = healthCheckNeedsUpdatedSet;
                this.existingHealthChecks = reference = existingHealthChecks;
            }

            public Object doCall(GoogleHealthCheck healthCheck) {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                Reference healthCheckName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)healthCheck)));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(this.healthCheckExistsSet.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)healthCheck)))) {
                    callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure6.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"Creating health check ", "..."}));
                    HealthCheck newHealthCheck = (HealthCheck)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(GCEUtil.class, (Object)healthCheck), HealthCheck.class);
                    Object insertHealthCheckOperation = callSiteArray[6].callCurrent((GroovyObject)this, callSiteArray[7].call(callSiteArray[8].call(this.compute.get()), this.project.get(), (Object)newHealthCheck), (Object)"compute.healthChecks.insert", callSiteArray[9].callGroovyObjectGetProperty((Object)this), callSiteArray[10].callGroovyObjectGetProperty((Object)this));
                    return callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[13].call(insertHealthCheckOperation), null, (Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[15].call((Object)"health check ", (Object)((String)healthCheckName.get())), (Object)ScriptBytecodeAdapter.getField(_operate_closure6.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE")));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call(this.healthCheckExistsSet.get(), callSiteArray[17].callGroovyObjectGetProperty((Object)healthCheck))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call(this.healthCheckNeedsUpdatedSet.get(), callSiteArray[19].callGroovyObjectGetProperty((Object)healthCheck)))) {
                    callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure6.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"Updating health check ", "..."}));
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference healthCheckName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure17(Object _outerInstance, Object _thisObject, Reference healthCheckName) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.healthCheckName = reference = healthCheckName;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.healthCheckName.get());
                        }

                        @Generated
                        public String getHealthCheckName() {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.healthCheckName.get());
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "name";
                            return new CallSiteArray(_closure17.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure17.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object hcToUpdate = callSiteArray[22].call(this.existingHealthChecks.get(), (Object)new _closure17((Object)this, this.getThisObject(), healthCheckName));
                    callSiteArray[23].call(GCEUtil.class, hcToUpdate, (Object)healthCheck);
                    Object updateHealthCheckOperation = callSiteArray[24].callCurrent((GroovyObject)this, callSiteArray[25].call(callSiteArray[26].call(this.compute.get()), this.project.get(), (Object)((String)healthCheckName.get()), hcToUpdate), (Object)"compute.healthChecks.update", callSiteArray[27].callGroovyObjectGetProperty((Object)this), callSiteArray[28].callGroovyObjectGetProperty((Object)this));
                    return callSiteArray[29].call(callSiteArray[30].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[31].call(updateHealthCheckOperation), null, (Object)callSiteArray[32].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"health check ", ""}), (Object)ScriptBytecodeAdapter.getField(_operate_closure6.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE")));
                }
                return null;
            }

            @Generated
            public Object call(GoogleHealthCheck healthCheck) {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return callSiteArray[33].callCurrent((GroovyObject)this, (Object)healthCheck);
            }

            @Generated
            public HashSet getHealthCheckExistsSet() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.healthCheckExistsSet.get(), HashSet.class);
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public HashSet getHealthCheckNeedsUpdatedSet() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.healthCheckNeedsUpdatedSet.get(), HashSet.class);
            }

            @Generated
            public Set getExistingHealthChecks() {
                CallSite[] callSiteArray = _operate_closure6.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.existingHealthChecks.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "contains";
                stringArray[2] = "name";
                stringArray[3] = "updateStatus";
                stringArray[4] = "task";
                stringArray[5] = "createNewHealthCheck";
                stringArray[6] = "timeExecute";
                stringArray[7] = "insert";
                stringArray[8] = "healthChecks";
                stringArray[9] = "TAG_SCOPE";
                stringArray[10] = "SCOPE_GLOBAL";
                stringArray[11] = "waitForGlobalOperation";
                stringArray[12] = "googleOperationPoller";
                stringArray[13] = "getName";
                stringArray[14] = "task";
                stringArray[15] = "plus";
                stringArray[16] = "contains";
                stringArray[17] = "name";
                stringArray[18] = "contains";
                stringArray[19] = "name";
                stringArray[20] = "updateStatus";
                stringArray[21] = "task";
                stringArray[22] = "find";
                stringArray[23] = "updateExistingHealthCheck";
                stringArray[24] = "timeExecute";
                stringArray[25] = "update";
                stringArray[26] = "healthChecks";
                stringArray[27] = "TAG_SCOPE";
                stringArray[28] = "SCOPE_GLOBAL";
                stringArray[29] = "waitForGlobalOperation";
                stringArray[30] = "googleOperationPoller";
                stringArray[31] = "getName";
                stringArray[32] = "task";
                stringArray[33] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[34];
                _operate_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[104].call((Object)healthChecksFromDescription, (Object)new _operate_closure6(this, this, healthCheckExistsSet, compute, project, healthCheckNeedsUpdatedSet, existingHealthChecks));
        public final class _operate_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serviceExistsSet;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference serviceNeedsUpdatedSet;
            private /* synthetic */ Reference existingServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure7(Object _outerInstance, Object _thisObject, Reference serviceExistsSet, Reference project, Reference compute, Reference serviceNeedsUpdatedSet, Reference existingServices) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.serviceExistsSet = reference5 = serviceExistsSet;
                this.project = reference4 = project;
                this.compute = reference3 = compute;
                this.serviceNeedsUpdatedSet = reference2 = serviceNeedsUpdatedSet;
                this.existingServices = reference = existingServices;
            }

            public Object doCall(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                Reference backendServiceName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)backendService)));
                Object object = callSiteArray[1].callSafe(callSiteArray[2].callGroovyObjectGetPropertySafe((Object)backendService));
                String sessionAffinity = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "NONE"));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(this.serviceExistsSet.get(), callSiteArray[4].callGroovyObjectGetProperty((Object)backendService)))) {
                    callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure7.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"Creating backend service ", "..."}));
                    Object[] objectArray = new Object[14];
                    objectArray[0] = "name";
                    objectArray[1] = (String)backendServiceName.get();
                    objectArray[2] = "portName";
                    Object object2 = callSiteArray[8].callGroovyObjectGetProperty((Object)backendService);
                    objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[9].callGetProperty(GoogleHttpLoadBalancingPolicy.class);
                    objectArray[4] = "connectionDraining";
                    objectArray[5] = callSiteArray[10].call(callSiteArray[11].callConstructor(ConnectionDraining.class), callSiteArray[12].callGroovyObjectGetProperty((Object)backendService));
                    objectArray[6] = "healthChecks";
                    objectArray[7] = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[13].call(GCEUtil.class, this.project.get(), callSiteArray[14].callGetProperty(callSiteArray[15].callGroovyObjectGetProperty((Object)backendService)))});
                    objectArray[8] = "sessionAffinity";
                    objectArray[9] = sessionAffinity;
                    objectArray[10] = "enableCDN";
                    objectArray[11] = callSiteArray[16].callGroovyObjectGetProperty((Object)backendService);
                    objectArray[12] = "affinityCookieTtlSec";
                    objectArray[13] = callSiteArray[17].callGroovyObjectGetProperty((Object)backendService);
                    BackendService bs = (BackendService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callConstructor(BackendService.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), BackendService.class);
                    Object insertBackendServiceOperation = callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].call(callSiteArray[20].call(this.compute.get()), this.project.get(), (Object)bs), (Object)"compute.backendServices.insert", callSiteArray[21].callGroovyObjectGetProperty((Object)this), callSiteArray[22].callGroovyObjectGetProperty((Object)this));
                    return callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[25].call(insertBackendServiceOperation), null, (Object)callSiteArray[26].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[27].call((Object)"backend service ", (Object)((String)backendServiceName.get())), (Object)ScriptBytecodeAdapter.getField(_operate_closure7.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE")));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call(this.serviceExistsSet.get(), callSiteArray[29].callGroovyObjectGetProperty((Object)backendService)))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call(this.serviceNeedsUpdatedSet.get(), callSiteArray[31].callGroovyObjectGetProperty((Object)backendService)))) {
                        callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure7.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"Updating backend service ", "..."}));
                        public final class _closure18
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference backendServiceName;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure18(Object _outerInstance, Object _thisObject, Reference backendServiceName) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.backendServiceName = reference = backendServiceName;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.backendServiceName.get());
                            }

                            @Generated
                            public String getBackendServiceName() {
                                CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                                return ShortTypeHandling.castToString((Object)this.backendServiceName.get());
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure18.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "name";
                                return new CallSiteArray(_closure18.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure18.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        Object bsToUpdate = callSiteArray[34].call(this.existingServices.get(), (Object)new _closure18((Object)this, this.getThisObject(), backendServiceName));
                        Object hcName = callSiteArray[35].callGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)backendService));
                        Object object3 = callSiteArray[37].callGroovyObjectGetProperty((Object)backendService);
                        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[38].callGetProperty(GoogleHttpLoadBalancingPolicy.class);
                        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)bsToUpdate, (String)"portName");
                        Object object5 = callSiteArray[39].call(callSiteArray[40].callConstructor(ConnectionDraining.class), callSiteArray[41].callGroovyObjectGetProperty((Object)backendService));
                        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)bsToUpdate, (String)"connectionDraining");
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[42].call(GCEUtil.class, this.project.get(), hcName)});
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)bsToUpdate, (String)"healthChecks");
                        String string = sessionAffinity;
                        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)bsToUpdate, (String)"sessionAffinity");
                        Object object6 = callSiteArray[43].callGroovyObjectGetProperty((Object)backendService);
                        ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)bsToUpdate, (String)"enableCDN");
                        Object object7 = callSiteArray[44].callGroovyObjectGetProperty((Object)backendService);
                        ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)bsToUpdate, (String)"affinityCookieTtlSec");
                        Object updateServiceOperation = callSiteArray[45].callCurrent((GroovyObject)this, callSiteArray[46].call(callSiteArray[47].call(this.compute.get()), this.project.get(), (Object)((String)backendServiceName.get()), bsToUpdate), (Object)"compute.backendServices.update", callSiteArray[48].callGroovyObjectGetProperty((Object)this), callSiteArray[49].callGroovyObjectGetProperty((Object)this));
                        callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)callSiteArray[52].call(updateServiceOperation), null, (Object)callSiteArray[53].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"backend service  ", ""}), (Object)ScriptBytecodeAdapter.getField(_operate_closure7.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE")));
                    }
                    return callSiteArray[54].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)this.compute.get(), (Object)callSiteArray[55].callGroovyObjectGetProperty(callSiteArray[56].callGroovyObjectGetProperty((Object)this)), (Object)this.project.get(), (Object)callSiteArray[57].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[58].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[59].callGroovyObjectGetProperty(callSiteArray[60].callGroovyObjectGetProperty((Object)this)), (Object)backendService));
                }
                return null;
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return callSiteArray[61].callCurrent((GroovyObject)this, (Object)backendService);
            }

            @Generated
            public HashSet getServiceExistsSet() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.serviceExistsSet.get(), HashSet.class);
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.project.get();
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public HashSet getServiceNeedsUpdatedSet() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return (HashSet)ScriptBytecodeAdapter.castToType((Object)this.serviceNeedsUpdatedSet.get(), HashSet.class);
            }

            @Generated
            public Set getExistingServices() {
                CallSite[] callSiteArray = _operate_closure7.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.existingServices.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "toString";
                stringArray[2] = "sessionAffinity";
                stringArray[3] = "contains";
                stringArray[4] = "name";
                stringArray[5] = "updateStatus";
                stringArray[6] = "task";
                stringArray[7] = "<$constructor$>";
                stringArray[8] = "portName";
                stringArray[9] = "HTTP_DEFAULT_PORT_NAME";
                stringArray[10] = "setDrainingTimeoutSec";
                stringArray[11] = "<$constructor$>";
                stringArray[12] = "connectionDrainingTimeoutSec";
                stringArray[13] = "buildHealthCheckUrl";
                stringArray[14] = "name";
                stringArray[15] = "healthCheck";
                stringArray[16] = "enableCDN";
                stringArray[17] = "affinityCookieTtlSec";
                stringArray[18] = "timeExecute";
                stringArray[19] = "insert";
                stringArray[20] = "backendServices";
                stringArray[21] = "TAG_SCOPE";
                stringArray[22] = "SCOPE_GLOBAL";
                stringArray[23] = "waitForGlobalOperation";
                stringArray[24] = "googleOperationPoller";
                stringArray[25] = "getName";
                stringArray[26] = "task";
                stringArray[27] = "plus";
                stringArray[28] = "contains";
                stringArray[29] = "name";
                stringArray[30] = "contains";
                stringArray[31] = "name";
                stringArray[32] = "updateStatus";
                stringArray[33] = "task";
                stringArray[34] = "find";
                stringArray[35] = "name";
                stringArray[36] = "healthCheck";
                stringArray[37] = "portName";
                stringArray[38] = "HTTP_DEFAULT_PORT_NAME";
                stringArray[39] = "setDrainingTimeoutSec";
                stringArray[40] = "<$constructor$>";
                stringArray[41] = "connectionDrainingTimeoutSec";
                stringArray[42] = "buildHealthCheckUrl";
                stringArray[43] = "enableCDN";
                stringArray[44] = "affinityCookieTtlSec";
                stringArray[45] = "timeExecute";
                stringArray[46] = "update";
                stringArray[47] = "backendServices";
                stringArray[48] = "TAG_SCOPE";
                stringArray[49] = "SCOPE_GLOBAL";
                stringArray[50] = "waitForGlobalOperation";
                stringArray[51] = "googleOperationPoller";
                stringArray[52] = "getName";
                stringArray[53] = "task";
                stringArray[54] = "fixBackendMetadata";
                stringArray[55] = "credentials";
                stringArray[56] = "description";
                stringArray[57] = "atomicOperationsRegistry";
                stringArray[58] = "orchestrationProcessor";
                stringArray[59] = "loadBalancerName";
                stringArray[60] = "description";
                stringArray[61] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[62];
                _operate_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[105].call((Object)backendServicesFromDescription, (Object)new _operate_closure7(this, this, serviceExistsSet, project, compute, serviceNeedsUpdatedSet, existingServices));
        public final class _operate_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference2 = compute;
                this.project = reference = project;
            }

            public Object doCall(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)this.compute.get(), (Object)callSiteArray[1].callGroovyObjectGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)this)), (Object)this.project.get(), (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[5].callGroovyObjectGetProperty(callSiteArray[6].callGroovyObjectGetProperty((Object)this)), (Object)backendService));
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, (Object)backendService);
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure8.$getCallSiteArray();
                return this.project.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fixBackendMetadata";
                stringArray[1] = "credentials";
                stringArray[2] = "description";
                stringArray[3] = "atomicOperationsRegistry";
                stringArray[4] = "orchestrationProcessor";
                stringArray[5] = "loadBalancerName";
                stringArray[6] = "description";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _operate_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[106].callSafe(callSiteArray[107].callGroovyObjectGetPropertySafe((Object)this.description), (Object)new _operate_closure8(this, this, compute, project));
        Object urlMapToUpdate = null;
        Object urlMapUrl = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)urlMapExists)) {
            callSiteArray[108].call(callSiteArray[109].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{urlMapName}, new String[]{"Creating URL map ", "..."}));
            Reference newUrlMap = new Reference((Object)((UrlMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callConstructor(UrlMap.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", urlMapName, "hostRules", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "pathMatchers", ScriptBytecodeAdapter.createList((Object[])new Object[0])})), UrlMap.class)));
            Object object5 = callSiteArray[111].call(GCEUtil.class, project.get(), callSiteArray[112].callGetProperty(callSiteArray[113].callGetProperty(httpLoadBalancer)));
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)((UrlMap)newUrlMap.get()), (String)"defaultService");
            public final class _operate_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference newUrlMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure9(Object _outerInstance, Object _thisObject, Reference project, Reference newUrlMap) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.project = reference2 = project;
                    this.newUrlMap = reference = newUrlMap;
                }

                public Object doCall(GoogleHostRule hostRule) {
                    CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                    String pathMatcherName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(_operate_closure9.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"PATH_MATCHER_PREFIX"), callSiteArray[0].call(callSiteArray[1].call(UUID.class))}, new String[]{"", "-", ""}));
                    Object pathMatcher = callSiteArray[2].callGroovyObjectGetProperty((Object)hostRule);
                    public final class _closure19
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference project;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure19(Object _outerInstance, Object _thisObject, Reference project) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.project = reference = project;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            return callSiteArray[0].callConstructor(PathRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"paths", callSiteArray[1].callGetProperty(it), "service", callSiteArray[2].call(GCEUtil.class, this.project.get(), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it)))}));
                        }

                        @Generated
                        public Object getProject() {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            return this.project.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure19.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "<$constructor$>";
                            stringArray[1] = "paths";
                            stringArray[2] = "buildBackendServiceUrl";
                            stringArray[3] = "name";
                            stringArray[4] = "backendService";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _closure19.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure19.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure19.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    PathMatcher newPathMatcher = (PathMatcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(PathMatcher.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", pathMatcherName, "defaultService", callSiteArray[4].call(GCEUtil.class, this.project.get(), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(pathMatcher))), "pathRules", callSiteArray[7].call(callSiteArray[8].callGetProperty(pathMatcher), (Object)new _closure19((Object)this, this.getThisObject(), this.project))})), PathMatcher.class);
                    callSiteArray[9].call(callSiteArray[10].callGetProperty(this.newUrlMap.get()), (Object)newPathMatcher);
                    return callSiteArray[11].call(callSiteArray[12].callGetProperty(this.newUrlMap.get()), callSiteArray[13].callConstructor(HostRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathMatcher", pathMatcherName, "hosts", callSiteArray[14].callGroovyObjectGetProperty((Object)hostRule)})));
                }

                @Generated
                public Object call(GoogleHostRule hostRule) {
                    CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                    return callSiteArray[15].callCurrent((GroovyObject)this, (Object)hostRule);
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public UrlMap getNewUrlMap() {
                    CallSite[] callSiteArray = _operate_closure9.$getCallSiteArray();
                    return (UrlMap)ScriptBytecodeAdapter.castToType((Object)this.newUrlMap.get(), UrlMap.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "toString";
                    stringArray[1] = "randomUUID";
                    stringArray[2] = "pathMatcher";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "buildBackendServiceUrl";
                    stringArray[5] = "name";
                    stringArray[6] = "defaultService";
                    stringArray[7] = "collect";
                    stringArray[8] = "pathRules";
                    stringArray[9] = "leftShift";
                    stringArray[10] = "pathMatchers";
                    stringArray[11] = "leftShift";
                    stringArray[12] = "hostRules";
                    stringArray[13] = "<$constructor$>";
                    stringArray[14] = "hostPatterns";
                    stringArray[15] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[16];
                    _operate_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[114].callSafe(callSiteArray[115].callGetPropertySafe(httpLoadBalancer), (Object)new _operate_closure9(this, this, project, newUrlMap));
            Object insertUrlMapOperation = callSiteArray[116].callCurrent((GroovyObject)this, callSiteArray[117].call(callSiteArray[118].call(compute.get()), project.get(), (Object)((UrlMap)newUrlMap.get())), (Object)"compute.urlMaps.insert", callSiteArray[119].callGroovyObjectGetProperty((Object)this), callSiteArray[120].callGroovyObjectGetProperty((Object)this));
            callSiteArray[121].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[122].call(insertUrlMapOperation), null, (Object)callSiteArray[123].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[124].call((Object)"url map ", (Object)urlMapName), (Object)BASE_PHASE));
            urlMapUrl = callSiteArray[125].call(insertUrlMapOperation);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)urlMapExists)) {
            callSiteArray[126].call(callSiteArray[127].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{urlMapName}, new String[]{"Updating URL map ", "..."}));
            Object object6 = callSiteArray[128].call(GCEUtil.class, project.get(), callSiteArray[129].callGetProperty(callSiteArray[130].callGetProperty(httpLoadBalancer)));
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)((UrlMap)existingUrlMap.get()), (String)"defaultService");
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)((UrlMap)existingUrlMap.get()), (String)"pathMatchers");
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)((UrlMap)existingUrlMap.get()), (String)"hostRules");
            public final class _operate_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference existingUrlMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure10(Object _outerInstance, Object _thisObject, Reference project, Reference existingUrlMap) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _operate_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.project = reference2 = project;
                    this.existingUrlMap = reference = existingUrlMap;
                }

                public Object doCall(GoogleHostRule hostRule) {
                    CallSite[] callSiteArray = _operate_closure10.$getCallSiteArray();
                    String pathMatcherName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(_operate_closure10.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"PATH_MATCHER_PREFIX"), callSiteArray[0].call(callSiteArray[1].call(UUID.class))}, new String[]{"", "-", ""}));
                    Object pathMatcher = callSiteArray[2].callGroovyObjectGetProperty((Object)hostRule);
                    public final class _closure20
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference project;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure20(Object _outerInstance, Object _thisObject, Reference project) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.project = reference = project;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                            return callSiteArray[0].callConstructor(PathRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"paths", callSiteArray[1].callGetProperty(it), "service", callSiteArray[2].call(GCEUtil.class, this.project.get(), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it)))}));
                        }

                        @Generated
                        public Object getProject() {
                            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                            return this.project.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure20.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "<$constructor$>";
                            stringArray[1] = "paths";
                            stringArray[2] = "buildBackendServiceUrl";
                            stringArray[3] = "name";
                            stringArray[4] = "backendService";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _closure20.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure20.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure20.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    PathMatcher newPathMatcher = (PathMatcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(PathMatcher.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", pathMatcherName, "defaultService", callSiteArray[4].call(GCEUtil.class, this.project.get(), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(pathMatcher))), "pathRules", callSiteArray[7].call(callSiteArray[8].callGetProperty(pathMatcher), (Object)new _closure20((Object)this, this.getThisObject(), this.project))})), PathMatcher.class);
                    callSiteArray[9].call(callSiteArray[10].callGetProperty(this.existingUrlMap.get()), (Object)newPathMatcher);
                    return callSiteArray[11].call(callSiteArray[12].callGetProperty(this.existingUrlMap.get()), callSiteArray[13].callConstructor(HostRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathMatcher", pathMatcherName, "hosts", callSiteArray[14].callGroovyObjectGetProperty((Object)hostRule)})));
                }

                @Generated
                public Object call(GoogleHostRule hostRule) {
                    CallSite[] callSiteArray = _operate_closure10.$getCallSiteArray();
                    return callSiteArray[15].callCurrent((GroovyObject)this, (Object)hostRule);
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure10.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public UrlMap getExistingUrlMap() {
                    CallSite[] callSiteArray = _operate_closure10.$getCallSiteArray();
                    return (UrlMap)ScriptBytecodeAdapter.castToType((Object)this.existingUrlMap.get(), UrlMap.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "toString";
                    stringArray[1] = "randomUUID";
                    stringArray[2] = "pathMatcher";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "buildBackendServiceUrl";
                    stringArray[5] = "name";
                    stringArray[6] = "defaultService";
                    stringArray[7] = "collect";
                    stringArray[8] = "pathRules";
                    stringArray[9] = "leftShift";
                    stringArray[10] = "pathMatchers";
                    stringArray[11] = "leftShift";
                    stringArray[12] = "hostRules";
                    stringArray[13] = "<$constructor$>";
                    stringArray[14] = "hostPatterns";
                    stringArray[15] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[16];
                    _operate_closure10.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[131].callSafe(callSiteArray[132].callGetPropertySafe(httpLoadBalancer), (Object)new _operate_closure10(this, this, project, existingUrlMap));
            Object updateUrlMapOperation = callSiteArray[133].callCurrent((GroovyObject)this, callSiteArray[134].call(callSiteArray[135].call(compute.get()), project.get(), (Object)urlMapName, (Object)((UrlMap)existingUrlMap.get())), (Object)"compute.urlMaps.update", callSiteArray[136].callGroovyObjectGetProperty((Object)this), callSiteArray[137].callGroovyObjectGetProperty((Object)this));
            callSiteArray[138].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[139].call(updateUrlMapOperation), null, (Object)callSiteArray[140].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{urlMapName}, new String[]{"url map ", ""}), (Object)BASE_PHASE));
            urlMapUrl = callSiteArray[141].call(updateUrlMapOperation);
        } else {
            urlMapUrl = callSiteArray[142].call((Object)((UrlMap)existingUrlMap.get()));
        }
        String targetProxyName = null;
        Object targetProxy = null;
        Object insertTargetProxyOperation = null;
        String targetProxyUrl = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)targetProxyExists)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].callGetProperty(httpLoadBalancer))) {
                targetProxyName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTPS_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                callSiteArray[144].call(callSiteArray[145].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"Creating target proxy ", "..."}));
                targetProxy = callSiteArray[146].callConstructor(TargetHttpsProxy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetProxyName, "sslCertificates", ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[147].call(GCEUtil.class, project.get(), callSiteArray[148].callGetProperty(httpLoadBalancer))}), "urlMap", urlMapUrl}));
                insertTargetProxyOperation = callSiteArray[149].callCurrent((GroovyObject)this, callSiteArray[150].call(callSiteArray[151].call(compute.get()), project.get(), targetProxy), (Object)"compute.targetHttpsProxies.insert", callSiteArray[152].callGroovyObjectGetProperty((Object)this), callSiteArray[153].callGroovyObjectGetProperty((Object)this));
            } else {
                targetProxyName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTP_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                callSiteArray[154].call(callSiteArray[155].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"Creating target proxy ", "..."}));
                targetProxy = callSiteArray[156].callConstructor(TargetHttpProxy.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetProxyName, "urlMap", urlMapUrl}));
                insertTargetProxyOperation = callSiteArray[157].callCurrent((GroovyObject)this, callSiteArray[158].call(callSiteArray[159].call(compute.get()), project.get(), targetProxy), (Object)"compute.targetHttpProxies.insert", callSiteArray[160].callGroovyObjectGetProperty((Object)this), callSiteArray[161].callGroovyObjectGetProperty((Object)this));
            }
            callSiteArray[162].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[163].call(insertTargetProxyOperation), null, (Object)callSiteArray[164].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"target proxy ", ""}), (Object)BASE_PHASE));
            targetProxyUrl = ShortTypeHandling.castToString((Object)callSiteArray[165].call(insertTargetProxyOperation));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)targetProxyExists) && DefaultTypeTransformation.booleanUnbox((Object)targetProxyNeedsUpdated)) {
            GoogleTargetProxyType proxyType = (GoogleTargetProxyType)ShortTypeHandling.castToEnum((Object)callSiteArray[166].call(Utils.class, callSiteArray[167].callSafe(existingProxy)), GoogleTargetProxyType.class);
            GoogleTargetProxyType googleTargetProxyType = proxyType;
            if (!ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[168].callGetProperty(GoogleTargetProxyType.class))) {
                if (!ScriptBytecodeAdapter.isCase((Object)((Object)googleTargetProxyType), (Object)callSiteArray[169].callGetProperty(GoogleTargetProxyType.class))) throw (Throwable)callSiteArray[194].callConstructor(IllegalStateException.class, callSiteArray[195].call((Object)new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Updating Http load balancer ", " failed. "}), (Object)new GStringImpl(new Object[]{targetProxyName, proxyType}, new String[]{"Could not update target proxy ", "; Illegal target proxy type ", "."})));
                targetProxyName = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTPS_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                callSiteArray[170].call(callSiteArray[171].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{targetProxyName}, new String[]{"Updating target proxy ", "..."}));
                TargetHttpsProxiesSetSslCertificatesRequest setSslReq = (TargetHttpsProxiesSetSslCertificatesRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(TargetHttpsProxiesSetSslCertificatesRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sslCertificates", ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[173].call(GCEUtil.class, project.get(), callSiteArray[174].callGetProperty(httpLoadBalancer))})})), TargetHttpsProxiesSetSslCertificatesRequest.class);
                Object sslCertOp = callSiteArray[175].callCurrent((GroovyObject)this, callSiteArray[176].call(callSiteArray[177].call(compute.get()), project.get(), (Object)targetProxyName, (Object)setSslReq), (Object)"compute.targetHttpsProxies.setSslCertificates", callSiteArray[178].callGroovyObjectGetProperty((Object)this), callSiteArray[179].callGroovyObjectGetProperty((Object)this));
                callSiteArray[180].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[181].call(sslCertOp), null, (Object)callSiteArray[182].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[183].callGetProperty(httpLoadBalancer)}, new String[]{"set ssl cert ", ""}), (Object)BASE_PHASE));
                UrlMapReference urlMapRef = (UrlMapReference)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(UrlMapReference.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"urlMap", urlMapUrl})), UrlMapReference.class);
                Object setUrlMapOp = callSiteArray[185].callCurrent((GroovyObject)this, callSiteArray[186].call(callSiteArray[187].call(compute.get()), project.get(), (Object)targetProxyName, (Object)urlMapRef), (Object)"compute.targetHttpsProxies.setUrlMap", callSiteArray[188].callGroovyObjectGetProperty((Object)this), callSiteArray[189].callGroovyObjectGetProperty((Object)this));
                callSiteArray[190].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[191].call(setUrlMapOp), null, (Object)callSiteArray[192].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{urlMapUrl, targetProxyName}, new String[]{"set urlMap ", " for target proxy ", ""}), (Object)BASE_PHASE));
                targetProxyUrl = ShortTypeHandling.castToString((Object)callSiteArray[193].call(setUrlMapOp));
            }
        } else {
            targetProxyUrl = ShortTypeHandling.castToString((Object)callSiteArray[196].call(existingProxy));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)forwardingRuleExists)) {
            callSiteArray[197].call(callSiteArray[198].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Creating global forwarding rule ", "..."}));
            Reference forwardingRule = new Reference(callSiteArray[199].callConstructor(ForwardingRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", httpLoadBalancerName, "IPAddress", callSiteArray[200].callGetProperty(httpLoadBalancer), "IPProtocol", callSiteArray[201].callGetProperty(httpLoadBalancer), "portRange", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[202].callGetProperty(httpLoadBalancer)) ? "443" : callSiteArray[203].callGetProperty(httpLoadBalancer), "target", targetProxyUrl})));
            public final class _operate_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference forwardingRule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _operate_closure11(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference forwardingRule) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.forwardingRule = reference = forwardingRule;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].call(this.compute.get()), this.project.get(), this.forwardingRule.get()), (Object)"compute.globalForwardingRules.insert", callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
                }

                @Generated
                public Object getCompute() {
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    return this.project.get();
                }

                @Generated
                public Object getForwardingRule() {
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    return this.forwardingRule.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _operate_closure11.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "timeExecute";
                    stringArray[1] = "insert";
                    stringArray[2] = "globalForwardingRules";
                    stringArray[3] = "TAG_SCOPE";
                    stringArray[4] = "SCOPE_GLOBAL";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _operate_closure11.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_operate_closure11.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _operate_closure11.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Operation forwardingRuleOp = (Operation)ScriptBytecodeAdapter.asType((Object)callSiteArray[204].call((Object)this.safeRetry, ArrayUtil.createArray((Object)((Object)new _operate_closure11(this, this, compute, project, forwardingRule)), (Object)new GStringImpl(new Object[]{callSiteArray[205].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Global forwarding rule ", ""}), (Object)callSiteArray[206].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "insert", "phase", BASE_PHASE, "operation", "compute.globalForwardingRules.insert", callSiteArray[207].callGroovyObjectGetProperty((Object)this), callSiteArray[208].callGroovyObjectGetProperty((Object)this)}), (Object)callSiteArray[209].callGroovyObjectGetProperty((Object)this))), Operation.class);
            callSiteArray[210].call((Object)this.googleOperationPoller, ArrayUtil.createArray((Object)compute.get(), (Object)project.get(), (Object)callSiteArray[211].call((Object)forwardingRuleOp), null, (Object)callSiteArray[212].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[213].call((Object)"forwarding rule ", httpLoadBalancerName), (Object)BASE_PHASE));
        }
        public final class _operate_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure12(Object _outerInstance, Object _thisObject, Reference compute, Reference project) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _operate_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference2 = compute;
                this.project = reference = project;
            }

            public Object doCall(String forwardingRuleName) {
                CallSite[] callSiteArray = _operate_closure12.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure12.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{forwardingRuleName}, new String[]{"Deleting listener ", "..."}));
                return callSiteArray[2].call(GCEUtil.class, ArrayUtil.createArray((Object)this.compute.get(), (Object)this.project.get(), (Object)forwardingRuleName, (Object)ScriptBytecodeAdapter.getField(_operate_closure12.class, UpsertGoogleHttpLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)this.getThisObject()));
            }

            @Generated
            public Object call(String forwardingRuleName) {
                CallSite[] callSiteArray = _operate_closure12.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[4].callCurrent((GroovyObject)this, (Object)forwardingRuleName);
                }
                return this.doCall(forwardingRuleName);
            }

            @Generated
            public Object getCompute() {
                CallSite[] callSiteArray = _operate_closure12.$getCallSiteArray();
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                CallSite[] callSiteArray = _operate_closure12.$getCallSiteArray();
                return this.project.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "updateStatus";
                stringArray[1] = "task";
                stringArray[2] = "deleteGlobalListener";
                stringArray[3] = "safeRetry";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _operate_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[214].callSafe(callSiteArray[215].callGroovyObjectGetProperty((Object)this.description), (Object)new _operate_closure12(this, this, compute, project));
        callSiteArray[216].call(callSiteArray[217].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Done upserting HTTP load balancer ", ""}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"global", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", httpLoadBalancerName})})});
    }

    /*
     * WARNING - void declaration
     */
    private void fixBackendMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, AtomicOperationsRegistry atomicOperationsRegistry, OrchestrationProcessor orchestrationProcessor, String loadBalancerName, GoogleBackendService backendService) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference credentials2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference atomicOperationsRegistry2 = new Reference((Object)atomicOperationsRegistry);
        Reference orchestrationProcessor2 = new Reference((Object)orchestrationProcessor);
        Reference loadBalancerName2 = new Reference((Object)loadBalancerName);
        Reference backendService2 = new Reference((Object)backendService);
        CallSite[] callSiteArray = UpsertGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray();
        public final class _fixBackendMetadata_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference loadBalancerName;
            private /* synthetic */ Reference backendService;
            private /* synthetic */ Reference atomicOperationsRegistry;
            private /* synthetic */ Reference orchestrationProcessor;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fixBackendMetadata_closure13(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference credentials, Reference loadBalancerName, Reference backendService, Reference atomicOperationsRegistry, Reference orchestrationProcessor) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.compute = reference7 = compute;
                this.project = reference6 = project;
                this.credentials = reference5 = credentials;
                this.loadBalancerName = reference4 = loadBalancerName;
                this.backendService = reference3 = backendService;
                this.atomicOperationsRegistry = reference2 = atomicOperationsRegistry;
                this.orchestrationProcessor = reference = orchestrationProcessor;
            }

            public Object doCall(GoogleLoadBalancedBackend backend) {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                Object groupName = callSiteArray[0].call(Utils.class, callSiteArray[1].callGroovyObjectGetProperty((Object)backend));
                Object groupRegion = callSiteArray[2].call(Utils.class, callSiteArray[3].callGroovyObjectGetProperty((Object)backend));
                String templateUrl = null;
                Object object = callSiteArray[4].call(Utils.class, callSiteArray[5].callGroovyObjectGetProperty((Object)backend));
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[6].callGetProperty(GoogleServerGroup.ServerGroupType.class))) {
                    templateUrl = ShortTypeHandling.castToString((Object)callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[9].call(callSiteArray[10].call(this.compute.get()), this.project.get(), groupRegion, groupName), (Object)"compute.regionInstanceGroupManagers.get", (Object)callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)groupRegion))));
                } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[14].callGetProperty(GoogleServerGroup.ServerGroupType.class))) {
                    Object groupZone = callSiteArray[15].call(Utils.class, callSiteArray[16].callGroovyObjectGetProperty((Object)backend));
                    templateUrl = ShortTypeHandling.castToString((Object)callSiteArray[17].call(callSiteArray[18].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[19].call(callSiteArray[20].call(this.compute.get()), this.project.get(), groupZone, groupName), (Object)"compute.instanceGroupManagers.get", (Object)callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[22].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)groupZone))));
                } else {
                    throw (Throwable)callSiteArray[24].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[25].callGroovyObjectGetProperty((Object)backend)}, new String[]{"Server group referenced by ", " has illegal type."}));
                }
                InstanceTemplate template = (InstanceTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callCurrent((GroovyObject)this, callSiteArray[27].call(callSiteArray[28].call(this.compute.get()), this.project.get(), callSiteArray[29].call(Utils.class, (Object)templateUrl)), (Object)"compute.instancesTemplates.get", callSiteArray[30].callGroovyObjectGetProperty((Object)this), callSiteArray[31].callGroovyObjectGetProperty((Object)this)), InstanceTemplate.class);
                Object instanceDescription = callSiteArray[32].call(GCEUtil.class, this.project.get(), (Object)template);
                Map templateOpMap = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", callSiteArray[33].callGetProperty(instanceDescription), "instanceType", callSiteArray[34].callGetProperty(instanceDescription), "credentials", callSiteArray[35].call(this.credentials.get()), "disks", callSiteArray[36].callGetProperty(instanceDescription), "instanceMetadata", callSiteArray[37].callGetProperty(instanceDescription), "tags", callSiteArray[38].callGetProperty(instanceDescription), "network", callSiteArray[39].callGetProperty(instanceDescription), "subnet", callSiteArray[40].callGetProperty(instanceDescription), "serviceAccountEmail", callSiteArray[41].callGetProperty(instanceDescription), "authScopes", callSiteArray[42].callGetProperty(instanceDescription), "preemptible", callSiteArray[43].callGetProperty(instanceDescription), "automaticRestart", callSiteArray[44].callGetProperty(instanceDescription), "onHostMaintenance", callSiteArray[45].callGetProperty(instanceDescription), "region", groupRegion, "serverGroupName", groupName});
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].callGetProperty(instanceDescription))) {
                    Object object2 = callSiteArray[47].callGetProperty(instanceDescription);
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)templateOpMap, (String)"minCpuPlatform");
                }
                Object instanceMetadata = callSiteArray[48].callGetPropertySafe((Object)templateOpMap);
                if (DefaultTypeTransformation.booleanUnbox((Object)instanceMetadata)) {
                    Object object3 = callSiteArray[49].callSafe(ScriptBytecodeAdapter.getProperty(_fixBackendMetadata_closure13.class, (Object)instanceMetadata, (String)ShortTypeHandling.castToString((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)this))), (Object)",");
                    List globalLbs = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
                    globalLbs = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)globalLbs) ? callSiteArray[51].call((Object)globalLbs, this.loadBalancerName.get()) : ScriptBytecodeAdapter.createList((Object[])new Object[]{this.loadBalancerName.get()})), List.class);
                    Object object4 = callSiteArray[52].call(callSiteArray[53].call((Object)globalLbs), (Object)",");
                    ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)instanceMetadata, (String)ShortTypeHandling.castToString((Object)callSiteArray[54].callGroovyObjectGetProperty((Object)this)));
                    Object object5 = callSiteArray[55].callSafe(ScriptBytecodeAdapter.getProperty(_fixBackendMetadata_closure13.class, (Object)instanceMetadata, (String)ShortTypeHandling.castToString((Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this))), (Object)",");
                    List bsNames = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
                    bsNames = (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)bsNames) ? callSiteArray[57].call((Object)bsNames, callSiteArray[58].callGroovyObjectGetProperty(this.backendService.get())) : ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[59].callGroovyObjectGetProperty(this.backendService.get())})), List.class);
                    Object object6 = callSiteArray[60].call(callSiteArray[61].call((Object)bsNames), (Object)",");
                    ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)instanceMetadata, (String)ShortTypeHandling.castToString((Object)callSiteArray[62].callGroovyObjectGetProperty((Object)this)));
                } else {
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[63].callGetProperty(GCEUtil.class), this.loadBalancerName.get(), callSiteArray[64].callGetProperty(GCEUtil.class), callSiteArray[65].callGroovyObjectGetProperty(this.backendService.get())});
                    ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)templateOpMap, (String)"instanceMetadata");
                }
                Object converter = callSiteArray[66].call(this.atomicOperationsRegistry.get(), (Object)"modifyGoogleServerGroupInstanceTemplateDescription", (Object)"gce");
                AtomicOperation templateOp = (AtomicOperation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call(converter, (Object)templateOpMap), AtomicOperation.class);
                return callSiteArray[68].call(this.orchestrationProcessor.get(), (Object)"gce", (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{templateOp}), callSiteArray[69].call(callSiteArray[70].call(UUID.class)));
            }

            @Generated
            public Object call(GoogleLoadBalancedBackend backend) {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return callSiteArray[71].callCurrent((GroovyObject)this, (Object)backend);
            }

            @Generated
            public Compute getCompute() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return (Compute)ScriptBytecodeAdapter.castToType((Object)this.compute.get(), Compute.class);
            }

            @Generated
            public String getProject() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.project.get());
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return (GoogleNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), GoogleNamedAccountCredentials.class));
            }

            @Generated
            public String getLoadBalancerName() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            @Generated
            public GoogleBackendService getBackendService() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return (GoogleBackendService)ScriptBytecodeAdapter.castToType((Object)this.backendService.get(), GoogleBackendService.class);
            }

            @Generated
            public AtomicOperationsRegistry getAtomicOperationsRegistry() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return (AtomicOperationsRegistry)ScriptBytecodeAdapter.castToType((Object)this.atomicOperationsRegistry.get(), AtomicOperationsRegistry.class);
            }

            @Generated
            public OrchestrationProcessor getOrchestrationProcessor() {
                CallSite[] callSiteArray = _fixBackendMetadata_closure13.$getCallSiteArray();
                return (OrchestrationProcessor)ScriptBytecodeAdapter.castToType((Object)this.orchestrationProcessor.get(), OrchestrationProcessor.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixBackendMetadata_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLocalName";
                stringArray[1] = "serverGroupUrl";
                stringArray[2] = "getRegionFromGroupUrl";
                stringArray[3] = "serverGroupUrl";
                stringArray[4] = "determineServerGroupType";
                stringArray[5] = "serverGroupUrl";
                stringArray[6] = "REGIONAL";
                stringArray[7] = "getInstanceTemplate";
                stringArray[8] = "timeExecute";
                stringArray[9] = "get";
                stringArray[10] = "regionInstanceGroupManagers";
                stringArray[11] = "TAG_SCOPE";
                stringArray[12] = "SCOPE_REGIONAL";
                stringArray[13] = "TAG_REGION";
                stringArray[14] = "ZONAL";
                stringArray[15] = "getZoneFromGroupUrl";
                stringArray[16] = "serverGroupUrl";
                stringArray[17] = "getInstanceTemplate";
                stringArray[18] = "timeExecute";
                stringArray[19] = "get";
                stringArray[20] = "instanceGroupManagers";
                stringArray[21] = "TAG_SCOPE";
                stringArray[22] = "SCOPE_ZONAL";
                stringArray[23] = "TAG_ZONE";
                stringArray[24] = "<$constructor$>";
                stringArray[25] = "serverGroupUrl";
                stringArray[26] = "timeExecute";
                stringArray[27] = "get";
                stringArray[28] = "instanceTemplates";
                stringArray[29] = "getLocalName";
                stringArray[30] = "TAG_SCOPE";
                stringArray[31] = "SCOPE_GLOBAL";
                stringArray[32] = "buildInstanceDescriptionFromTemplate";
                stringArray[33] = "image";
                stringArray[34] = "instanceType";
                stringArray[35] = "getName";
                stringArray[36] = "disks";
                stringArray[37] = "instanceMetadata";
                stringArray[38] = "tags";
                stringArray[39] = "network";
                stringArray[40] = "subnet";
                stringArray[41] = "serviceAccountEmail";
                stringArray[42] = "authScopes";
                stringArray[43] = "preemptible";
                stringArray[44] = "automaticRestart";
                stringArray[45] = "onHostMaintenance";
                stringArray[46] = "minCpuPlatform";
                stringArray[47] = "minCpuPlatform";
                stringArray[48] = "instanceMetadata";
                stringArray[49] = "split";
                stringArray[50] = "GLOBAL_LOAD_BALANCER_NAMES";
                stringArray[51] = "plus";
                stringArray[52] = "join";
                stringArray[53] = "unique";
                stringArray[54] = "GLOBAL_LOAD_BALANCER_NAMES";
                stringArray[55] = "split";
                stringArray[56] = "BACKEND_SERVICE_NAMES";
                stringArray[57] = "plus";
                stringArray[58] = "name";
                stringArray[59] = "name";
                stringArray[60] = "join";
                stringArray[61] = "unique";
                stringArray[62] = "BACKEND_SERVICE_NAMES";
                stringArray[63] = "GLOBAL_LOAD_BALANCER_NAMES";
                stringArray[64] = "BACKEND_SERVICE_NAMES";
                stringArray[65] = "name";
                stringArray[66] = "getAtomicOperationConverter";
                stringArray[67] = "convertOperation";
                stringArray[68] = "process";
                stringArray[69] = "toString";
                stringArray[70] = "randomUUID";
                stringArray[71] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[72];
                _fixBackendMetadata_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_fixBackendMetadata_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fixBackendMetadata_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[218].call(callSiteArray[219].callGroovyObjectGetProperty((Object)((GoogleBackendService)backendService2.get())), (Object)new _fixBackendMetadata_closure13(this, this, compute2, project2, credentials2, loadBalancerName2, backendService2, atomicOperationsRegistry2, orchestrationProcessor2));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleHttpLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = UpsertGoogleHttpLoadBalancerAtomicOperation.$getCallSiteArray()[220].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.UpsertGoogleHttpLoadBalancerAtomicOperation");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    @Generated
    public void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    @Generated
    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    @Generated
    public void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    @Override
    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    @Generated
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Map super$3$operate(List list) {
        return super.operate(list);
    }

    public /* synthetic */ SafeRetry super$3$getSafeRetry() {
        return super.getSafeRetry();
    }

    public /* synthetic */ void super$3$setSafeRetry(SafeRetry safeRetry) {
        super.setSafeRetry(safeRetry);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "loadBalancerName";
        stringArray[4] = "urlMapName";
        stringArray[5] = "defaultService";
        stringArray[6] = "hostRules";
        stringArray[7] = "certificate";
        stringArray[8] = "ipAddress";
        stringArray[9] = "ipProtocol";
        stringArray[10] = "portRange";
        stringArray[11] = "name";
        stringArray[12] = "updateStatus";
        stringArray[13] = "task";
        stringArray[14] = "credentials";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "accountName";
        stringArray[17] = "compute";
        stringArray[18] = "credentials";
        stringArray[19] = "project";
        stringArray[20] = "credentials";
        stringArray[21] = "unique";
        stringArray[22] = "getBackendServicesFromHttpLoadBalancerView";
        stringArray[23] = "view";
        stringArray[24] = "unique";
        stringArray[25] = "collect";
        stringArray[26] = "urlMapName";
        stringArray[27] = "getItems";
        stringArray[28] = "timeExecute";
        stringArray[29] = "list";
        stringArray[30] = "httpHealthChecks";
        stringArray[31] = "TAG_SCOPE";
        stringArray[32] = "SCOPE_GLOBAL";
        stringArray[33] = "getItems";
        stringArray[34] = "timeExecute";
        stringArray[35] = "list";
        stringArray[36] = "healthChecks";
        stringArray[37] = "TAG_SCOPE";
        stringArray[38] = "SCOPE_GLOBAL";
        stringArray[39] = "getItems";
        stringArray[40] = "timeExecute";
        stringArray[41] = "list";
        stringArray[42] = "backendServices";
        stringArray[43] = "TAG_SCOPE";
        stringArray[44] = "SCOPE_GLOBAL";
        stringArray[45] = "timeExecute";
        stringArray[46] = "get";
        stringArray[47] = "urlMaps";
        stringArray[48] = "TAG_SCOPE";
        stringArray[49] = "SCOPE_GLOBAL";
        stringArray[50] = "getStatusCode";
        stringArray[51] = "timeExecute";
        stringArray[52] = "get";
        stringArray[53] = "globalForwardingRules";
        stringArray[54] = "TAG_SCOPE";
        stringArray[55] = "SCOPE_GLOBAL";
        stringArray[56] = "getStatusCode";
        stringArray[57] = "getLocalName";
        stringArray[58] = "getTarget";
        stringArray[59] = "getTargetProxyType";
        stringArray[60] = "getTarget";
        stringArray[61] = "HTTP";
        stringArray[62] = "timeExecute";
        stringArray[63] = "get";
        stringArray[64] = "targetHttpProxies";
        stringArray[65] = "TAG_SCOPE";
        stringArray[66] = "SCOPE_GLOBAL";
        stringArray[67] = "HTTPS";
        stringArray[68] = "timeExecute";
        stringArray[69] = "get";
        stringArray[70] = "targetHttpsProxies";
        stringArray[71] = "TAG_SCOPE";
        stringArray[72] = "SCOPE_GLOBAL";
        stringArray[73] = "certificate";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "getLocalName";
        stringArray[76] = "getAt";
        stringArray[77] = "getSslCertificates";
        stringArray[78] = "getLocalName";
        stringArray[79] = "buildCertificateUrl";
        stringArray[80] = "certificate";
        stringArray[81] = "isWarnEnabled";
        stringArray[82] = "warn";
        stringArray[83] = "getLocalName";
        stringArray[84] = "getUrlMap";
        stringArray[85] = "urlMapName";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "plus";
        stringArray[88] = "getName";
        stringArray[89] = "getLocalName";
        stringArray[90] = "getUrlMap";
        stringArray[91] = "urlMapName";
        stringArray[92] = "size";
        stringArray[93] = "size";
        stringArray[94] = "unique";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "plus";
        stringArray[97] = "each";
        stringArray[98] = "size";
        stringArray[99] = "size";
        stringArray[100] = "unique";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "plus";
        stringArray[103] = "each";
        stringArray[104] = "each";
        stringArray[105] = "each";
        stringArray[106] = "each";
        stringArray[107] = "backendServiceDiff";
        stringArray[108] = "updateStatus";
        stringArray[109] = "task";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "buildBackendServiceUrl";
        stringArray[112] = "name";
        stringArray[113] = "defaultService";
        stringArray[114] = "each";
        stringArray[115] = "hostRules";
        stringArray[116] = "timeExecute";
        stringArray[117] = "insert";
        stringArray[118] = "urlMaps";
        stringArray[119] = "TAG_SCOPE";
        stringArray[120] = "SCOPE_GLOBAL";
        stringArray[121] = "waitForGlobalOperation";
        stringArray[122] = "getName";
        stringArray[123] = "task";
        stringArray[124] = "plus";
        stringArray[125] = "getTargetLink";
        stringArray[126] = "updateStatus";
        stringArray[127] = "task";
        stringArray[128] = "buildBackendServiceUrl";
        stringArray[129] = "name";
        stringArray[130] = "defaultService";
        stringArray[131] = "each";
        stringArray[132] = "hostRules";
        stringArray[133] = "timeExecute";
        stringArray[134] = "update";
        stringArray[135] = "urlMaps";
        stringArray[136] = "TAG_SCOPE";
        stringArray[137] = "SCOPE_GLOBAL";
        stringArray[138] = "waitForGlobalOperation";
        stringArray[139] = "getName";
        stringArray[140] = "task";
        stringArray[141] = "getTargetLink";
        stringArray[142] = "getSelfLink";
        stringArray[143] = "certificate";
        stringArray[144] = "updateStatus";
        stringArray[145] = "task";
        stringArray[146] = "<$constructor$>";
        stringArray[147] = "buildCertificateUrl";
        stringArray[148] = "certificate";
        stringArray[149] = "timeExecute";
        stringArray[150] = "insert";
        stringArray[151] = "targetHttpsProxies";
        stringArray[152] = "TAG_SCOPE";
        stringArray[153] = "SCOPE_GLOBAL";
        stringArray[154] = "updateStatus";
        stringArray[155] = "task";
        stringArray[156] = "<$constructor$>";
        stringArray[157] = "timeExecute";
        stringArray[158] = "insert";
        stringArray[159] = "targetHttpProxies";
        stringArray[160] = "TAG_SCOPE";
        stringArray[161] = "SCOPE_GLOBAL";
        stringArray[162] = "waitForGlobalOperation";
        stringArray[163] = "getName";
        stringArray[164] = "task";
        stringArray[165] = "getTargetLink";
        stringArray[166] = "getTargetProxyType";
        stringArray[167] = "getSelfLink";
        stringArray[168] = "HTTP";
        stringArray[169] = "HTTPS";
        stringArray[170] = "updateStatus";
        stringArray[171] = "task";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "buildCertificateUrl";
        stringArray[174] = "certificate";
        stringArray[175] = "timeExecute";
        stringArray[176] = "setSslCertificates";
        stringArray[177] = "targetHttpsProxies";
        stringArray[178] = "TAG_SCOPE";
        stringArray[179] = "SCOPE_GLOBAL";
        stringArray[180] = "waitForGlobalOperation";
        stringArray[181] = "getName";
        stringArray[182] = "task";
        stringArray[183] = "certificate";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "timeExecute";
        stringArray[186] = "setUrlMap";
        stringArray[187] = "targetHttpsProxies";
        stringArray[188] = "TAG_SCOPE";
        stringArray[189] = "SCOPE_GLOBAL";
        stringArray[190] = "waitForGlobalOperation";
        stringArray[191] = "getName";
        stringArray[192] = "task";
        stringArray[193] = "getTargetLink";
        stringArray[194] = "<$constructor$>";
        stringArray[195] = "plus";
        stringArray[196] = "getSelfLink";
        stringArray[197] = "updateStatus";
        stringArray[198] = "task";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "ipAddress";
        stringArray[201] = "ipProtocol";
        stringArray[202] = "certificate";
        stringArray[203] = "portRange";
        stringArray[204] = "doRetry";
        stringArray[205] = "loadBalancerName";
        stringArray[206] = "task";
        stringArray[207] = "TAG_SCOPE";
        stringArray[208] = "SCOPE_GLOBAL";
        stringArray[209] = "registry";
        stringArray[210] = "waitForGlobalOperation";
        stringArray[211] = "getName";
        stringArray[212] = "task";
        stringArray[213] = "plus";
        stringArray[214] = "each";
        stringArray[215] = "listenersToDelete";
        stringArray[216] = "updateStatus";
        stringArray[217] = "task";
        stringArray[218] = "each";
        stringArray[219] = "backends";
        stringArray[220] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[221];
        UpsertGoogleHttpLoadBalancerAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UpsertGoogleHttpLoadBalancerAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UpsertGoogleHttpLoadBalancerAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

